-------------------------------------------------------------------------------
-- Copyright (c) 1995/2006 Xilinx, Inc.
-- All Right Reserved.
-------------------------------------------------------------------------------
--   ____  ____
--  /   /\/   /
-- /___/  \  /    Vendor      : Xilinx
-- \   \   \/     Version : 11.1
--  \   \         Description : Xilinx Timing Simulation Library Component
--  /   /                       PCI Express
-- /___/   /\     Filename    : X_PCIE_INTERNAL_1_1.vhd
-- \   \  /  \    Timestamp   : Thu Dec 8 2005
--  \___\/\___\
--
-- Revision:
--    12/08/05 - Initial version.
--    01/09/06 - Added architecture
--    01/23/06 - Parameter MC updates CR#224562
--    01/27/06 - CR#224810 Remove GSR pin
--    02/03/06 - pinTime updates
--    02/23/06 - Updated Header
--    03/29/06 - CR#228056 - Fixed input and ouput connectivity.
--    04/24/06 - CR#230393 - Updated timing according to the spreadsheets
--    04/28/06 - CR#230712 - Spreadsheet update
--    05/23/06 - CR#231962 - Add buffers for connectivity
--    06/22/06 - CR#229760 - Missing PERIOD checks added
--    08/14/06 - CR#421379 - PCIE updated to PCIE_INTERNAL_1_1
--                         - spreadsheet updates for parameter default value
--    09/15/06 - CR#423947 - Recrem added
--    10/26/06 -           - replaced ZERO_DELAY with CLK_DELAY to be consistent with writers (PPC440 update)
--                         - ACTIVELANESIN X"11" with X"01";
--    06/18/07 - CR#441402 - Negative setup/hold timing check support
--    05/05/08 - CR#444072 - Add clock port to tisd in declaration & Vitalsetuphold section
--    07/01/08 - CR#476164 - Timing simulation fix for L0PORTNUMBER
--    08/11/08 - CR#479350 - Updated SWIFT to SWIFT for smartmodel wrapper
--    09/24/08 - CR#490332 - Updated wait on section
-- End Revision

----- CELL X_PCIE_INTERNAL_1_1 -----

library IEEE;
use IEEE.STD_LOGIC_1164.all;

library IEEE;
use IEEE.VITAL_Timing.all;

library simprim;
use simprim.VCOMPONENTS.all; 

library secureip; 
use secureip.all; 

entity X_PCIE_INTERNAL_1_1 is
generic (
	TimingChecksOn : boolean := TRUE;
	InstancePath   : string  := "*";
	Xon            : boolean := TRUE;
	MsgOn          : boolean := FALSE;

	LOC             : string  := "UNPLACED";

	ACTIVELANESIN : bit_vector := X"01";
	AERBASEPTR : bit_vector := X"110";
	AERCAPABILITYECRCCHECKCAPABLE : boolean := FALSE;
	AERCAPABILITYECRCGENCAPABLE : boolean := FALSE;
	AERCAPABILITYNEXTPTR : bit_vector := X"138";
	BAR0ADDRWIDTH : integer := 0;
	BAR0EXIST : boolean := TRUE;
	BAR0IOMEMN : integer := 0;
	BAR0MASKWIDTH : bit_vector := X"14";
	BAR0PREFETCHABLE : boolean := TRUE;
	BAR1ADDRWIDTH : integer := 0;
	BAR1EXIST : boolean := FALSE;
	BAR1IOMEMN : integer := 0;
	BAR1MASKWIDTH : bit_vector := X"00";
	BAR1PREFETCHABLE : boolean := FALSE;
	BAR2ADDRWIDTH : integer := 0;
	BAR2EXIST : boolean := FALSE;
	BAR2IOMEMN : integer := 0;
	BAR2MASKWIDTH : bit_vector := X"00";
	BAR2PREFETCHABLE : boolean := FALSE;
	BAR3ADDRWIDTH : integer := 0;
	BAR3EXIST : boolean := FALSE;
	BAR3IOMEMN : integer := 0;
	BAR3MASKWIDTH : bit_vector := X"00";
	BAR3PREFETCHABLE : boolean := FALSE;
	BAR4ADDRWIDTH : integer := 0;
	BAR4EXIST : boolean := FALSE;
	BAR4IOMEMN : integer := 0;
	BAR4MASKWIDTH : bit_vector := X"00";
	BAR4PREFETCHABLE : boolean := FALSE;
	BAR5EXIST : boolean := FALSE;
	BAR5IOMEMN : integer := 0;
	BAR5MASKWIDTH : bit_vector := X"00";
	BAR5PREFETCHABLE : boolean := FALSE;
	CAPABILITIESPOINTER : bit_vector := X"40";
	CARDBUSCISPOINTER : bit_vector := X"00000000";
	CLASSCODE : bit_vector := X"058000";
	CLKDIVIDED : boolean := FALSE;
	CONFIGROUTING : bit_vector := X"1";
	DEVICECAPABILITYENDPOINTL0SLATENCY : bit_vector := X"0";
	DEVICECAPABILITYENDPOINTL1LATENCY : bit_vector := X"0";
	DEVICEID : bit_vector := X"5050";
	DEVICESERIALNUMBER : bit_vector := X"E000000001000A35";
	DSNBASEPTR : bit_vector := X"148";
	DSNCAPABILITYNEXTPTR : bit_vector := X"154";
	DUALCOREENABLE : boolean := FALSE;
	DUALCORESLAVE : boolean := FALSE;
	DUALROLECFGCNTRLROOTEPN : integer := 0;
	EXTCFGCAPPTR : bit_vector := X"00";
	EXTCFGXPCAPPTR : bit_vector := X"000";
	HEADERTYPE : bit_vector := X"00";
	INFINITECOMPLETIONS : boolean := TRUE;
	INTERRUPTPIN : bit_vector := X"00";
	ISSWITCH : boolean := FALSE;
	L0SEXITLATENCY : integer := 7;
	L0SEXITLATENCYCOMCLK : integer := 7;
	L1EXITLATENCY : integer := 7;
	L1EXITLATENCYCOMCLK : integer := 7;
	LINKCAPABILITYASPMSUPPORT : bit_vector := X"1";
	LINKCAPABILITYMAXLINKWIDTH : bit_vector := X"01";
	LINKSTATUSSLOTCLOCKCONFIG : boolean := FALSE;
	LLKBYPASS : boolean := FALSE;
	LOWPRIORITYVCCOUNT : integer := 0;
	MSIBASEPTR : bit_vector := X"048";
	MSICAPABILITYMULTIMSGCAP : bit_vector := X"0";
	MSICAPABILITYNEXTPTR : bit_vector := X"60";
	PBBASEPTR : bit_vector := X"138";
	PBCAPABILITYDW0BASEPOWER : bit_vector := X"00";
	PBCAPABILITYDW0DATASCALE : bit_vector := X"0";
	PBCAPABILITYDW0PMSTATE : bit_vector := X"0";
	PBCAPABILITYDW0PMSUBSTATE : bit_vector := X"0";
	PBCAPABILITYDW0POWERRAIL : bit_vector := X"0";
	PBCAPABILITYDW0TYPE : bit_vector := X"0";
	PBCAPABILITYDW1BASEPOWER : bit_vector := X"00";
	PBCAPABILITYDW1DATASCALE : bit_vector := X"0";
	PBCAPABILITYDW1PMSTATE : bit_vector := X"0";
	PBCAPABILITYDW1PMSUBSTATE : bit_vector := X"0";
	PBCAPABILITYDW1POWERRAIL : bit_vector := X"0";
	PBCAPABILITYDW1TYPE : bit_vector := X"0";
	PBCAPABILITYDW2BASEPOWER : bit_vector := X"00";
	PBCAPABILITYDW2DATASCALE : bit_vector := X"0";
	PBCAPABILITYDW2PMSTATE : bit_vector := X"0";
	PBCAPABILITYDW2PMSUBSTATE : bit_vector := X"0";
	PBCAPABILITYDW2POWERRAIL : bit_vector := X"0";
	PBCAPABILITYDW2TYPE : bit_vector := X"0";
	PBCAPABILITYDW3BASEPOWER : bit_vector := X"00";
	PBCAPABILITYDW3DATASCALE : bit_vector := X"0";
	PBCAPABILITYDW3PMSTATE : bit_vector := X"0";
	PBCAPABILITYDW3PMSUBSTATE : bit_vector := X"0";
	PBCAPABILITYDW3POWERRAIL : bit_vector := X"0";
	PBCAPABILITYDW3TYPE : bit_vector := X"0";
	PBCAPABILITYNEXTPTR : bit_vector := X"148";
	PBCAPABILITYSYSTEMALLOCATED : boolean := FALSE;
	PCIECAPABILITYINTMSGNUM : bit_vector := X"00";
	PCIECAPABILITYNEXTPTR : bit_vector := X"00";
	PCIECAPABILITYSLOTIMPL : boolean := FALSE;
	PCIEREVISION : integer := 1;
	PMBASEPTR : bit_vector := X"040";
	PMCAPABILITYAUXCURRENT : bit_vector := X"0";
	PMCAPABILITYD1SUPPORT : boolean := FALSE;
	PMCAPABILITYD2SUPPORT : boolean := FALSE;
	PMCAPABILITYDSI : boolean := TRUE;
	PMCAPABILITYNEXTPTR : bit_vector := X"60";
	PMCAPABILITYPMESUPPORT : bit_vector := X"00";
	PMDATA0 : bit_vector := X"00";
	PMDATA1 : bit_vector := X"00";
	PMDATA2 : bit_vector := X"00";
	PMDATA3 : bit_vector := X"00";
	PMDATA4 : bit_vector := X"00";
	PMDATA5 : bit_vector := X"00";
	PMDATA6 : bit_vector := X"00";
	PMDATA7 : bit_vector := X"00";
	PMDATA8 : bit_vector := X"00";
	PMDATASCALE0 : integer := 0;
	PMDATASCALE1 : integer := 0;
	PMDATASCALE2 : integer := 0;
	PMDATASCALE3 : integer := 0;
	PMDATASCALE4 : integer := 0;
	PMDATASCALE5 : integer := 0;
	PMDATASCALE6 : integer := 0;
	PMDATASCALE7 : integer := 0;
	PMDATASCALE8 : integer := 0;
	PMSTATUSCONTROLDATASCALE : bit_vector := X"0";
	PORTVCCAPABILITYEXTENDEDVCCOUNT : bit_vector := X"0";
	PORTVCCAPABILITYVCARBCAP : bit_vector := X"00";
	PORTVCCAPABILITYVCARBTABLEOFFSET : bit_vector := X"00";
	RAMSHARETXRX : boolean := FALSE;
	RESETMODE : boolean := FALSE;
	RETRYRAMREADLATENCY : integer := 3;
	RETRYRAMSIZE : bit_vector := X"009";
	RETRYRAMWIDTH : integer := 0;
	RETRYRAMWRITELATENCY : integer := 1;
	RETRYREADADDRPIPE : boolean := FALSE;
	RETRYREADDATAPIPE : boolean := FALSE;
	RETRYWRITEPIPE : boolean := FALSE;
	REVISIONID : bit_vector := X"00";
	RXREADADDRPIPE : boolean := FALSE;
	RXREADDATAPIPE : boolean := FALSE;
	RXWRITEPIPE : boolean := FALSE;
	SELECTASMODE : boolean := FALSE;
	SELECTDLLIF : boolean := FALSE;
	SLOTCAPABILITYATTBUTTONPRESENT : boolean := FALSE;
	SLOTCAPABILITYATTINDICATORPRESENT : boolean := FALSE;
	SLOTCAPABILITYHOTPLUGCAPABLE : boolean := FALSE;
	SLOTCAPABILITYHOTPLUGSURPRISE : boolean := FALSE;
	SLOTCAPABILITYMSLSENSORPRESENT : boolean := FALSE;
	SLOTCAPABILITYPHYSICALSLOTNUM : bit_vector := X"0000";
	SLOTCAPABILITYPOWERCONTROLLERPRESENT : boolean := FALSE;
	SLOTCAPABILITYPOWERINDICATORPRESENT : boolean := FALSE;
	SLOTCAPABILITYSLOTPOWERLIMITSCALE : bit_vector := X"0";
	SLOTCAPABILITYSLOTPOWERLIMITVALUE : bit_vector := X"00";
	SLOTIMPLEMENTED : boolean := FALSE;
	SUBSYSTEMID : bit_vector := X"5050";
	SUBSYSTEMVENDORID : bit_vector := X"10EE";
	TLRAMREADLATENCY : integer := 3;
	TLRAMWIDTH : integer := 0;
	TLRAMWRITELATENCY : integer := 1;
	TXREADADDRPIPE : boolean := FALSE;
	TXREADDATAPIPE : boolean := FALSE;
	TXTSNFTS : integer := 255;
	TXTSNFTSCOMCLK : integer := 255;
	TXWRITEPIPE : boolean := FALSE;
	UPSTREAMFACING : boolean := TRUE;
	VC0RXFIFOBASEC : bit_vector := X"0098";
	VC0RXFIFOBASENP : bit_vector := X"0080";
	VC0RXFIFOBASEP : bit_vector := X"0000";
	VC0RXFIFOLIMITC : bit_vector := X"0117";
	VC0RXFIFOLIMITNP : bit_vector := X"0097";
	VC0RXFIFOLIMITP : bit_vector := X"007f";
	VC0TOTALCREDITSCD : bit_vector := X"000";
	VC0TOTALCREDITSCH : bit_vector := X"00";
	VC0TOTALCREDITSNPH : bit_vector := X"08";
	VC0TOTALCREDITSPD : bit_vector := X"034";
	VC0TOTALCREDITSPH : bit_vector := X"08";
	VC0TXFIFOBASEC : bit_vector := X"0098";
	VC0TXFIFOBASENP : bit_vector := X"0080";
	VC0TXFIFOBASEP : bit_vector := X"0000";
	VC0TXFIFOLIMITC : bit_vector := X"0117";
	VC0TXFIFOLIMITNP : bit_vector := X"0097";
	VC0TXFIFOLIMITP : bit_vector := X"007f";
	VC1RXFIFOBASEC : bit_vector := X"0118";
	VC1RXFIFOBASENP : bit_vector := X"0118";
	VC1RXFIFOBASEP : bit_vector := X"0118";
	VC1RXFIFOLIMITC : bit_vector := X"0118";
	VC1RXFIFOLIMITNP : bit_vector := X"0118";
	VC1RXFIFOLIMITP : bit_vector := X"0118";
	VC1TOTALCREDITSCD : bit_vector := X"000";
	VC1TOTALCREDITSCH : bit_vector := X"00";
	VC1TOTALCREDITSNPH : bit_vector := X"00";
	VC1TOTALCREDITSPD : bit_vector := X"000";
	VC1TOTALCREDITSPH : bit_vector := X"00";
	VC1TXFIFOBASEC : bit_vector := X"0118";
	VC1TXFIFOBASENP : bit_vector := X"0118";
	VC1TXFIFOBASEP : bit_vector := X"0118";
	VC1TXFIFOLIMITC : bit_vector := X"0118";
	VC1TXFIFOLIMITNP : bit_vector := X"0118";
	VC1TXFIFOLIMITP : bit_vector := X"0118";
	VCBASEPTR : bit_vector := X"154";
	VCCAPABILITYNEXTPTR : bit_vector := X"000";
	VENDORID : bit_vector := X"10EE";
	XLINKSUPPORTED : boolean := FALSE;
	XPBASEPTR : bit_vector := X"60";
	XPDEVICEPORTTYPE : bit_vector := X"0";
	XPMAXPAYLOAD : integer := 0;
	XPRCBCONTROL : integer := 0;

      	tperiod_CRMCORECLKDLO_posedge : VitalDelayType := 0 ps;
	tperiod_CRMCORECLKRXO_posedge : VitalDelayType := 0 ps;
	tperiod_CRMCORECLKTXO_posedge : VitalDelayType := 0 ps;
	tperiod_CRMCORECLK_posedge : VitalDelayType := 0 ps;
	tperiod_CRMUSERCLKRXO_posedge : VitalDelayType := 0 ps;
	tperiod_CRMUSERCLKTXO_posedge : VitalDelayType := 0 ps;
	tperiod_CRMUSERCLK_posedge : VitalDelayType := 0 ps;

	tipd_AUXPOWER : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CFGNEGOTIATEDLINKWIDTH : VitalDelayArrayType01 (5 downto 0) := (others => (0 ps, 0 ps));
	tipd_COMPLIANCEAVOID : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CRMCFGBRIDGEHOTRESET : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CRMCORECLK : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CRMCORECLKDLO : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CRMCORECLKRXO : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CRMCORECLKTXO : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CRMLINKRSTN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CRMMACRSTN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CRMMGMTRSTN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CRMNVRSTN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CRMTXHOTRESETN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CRMURSTN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CRMUSERCFGRSTN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CRMUSERCLK : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CRMUSERCLKRXO : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CRMUSERCLKTXO : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_CROSSLINKSEED : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0ACKNAKTIMERADJUSTMENT : VitalDelayArrayType01 (11 downto 0) := (others => (0 ps, 0 ps));
	tipd_L0ALLDOWNPORTSINL1 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0ALLDOWNRXPORTSINL0S : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0ASE : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0ASPORTCOUNT : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
	tipd_L0ASTURNPOOLBITSCONSUMED : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
	tipd_L0ATTENTIONBUTTONPRESSED : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0CFGASSPANTREEOWNEDSTATE : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0CFGASSTATECHANGECMD : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
	tipd_L0CFGDISABLESCRAMBLE : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0CFGEXTENDEDSYNC : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0CFGL0SENTRYENABLE : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0CFGL0SENTRYSUP : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0CFGL0SEXITLAT : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
	tipd_L0CFGLINKDISABLE : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0CFGLOOPBACKMASTER : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0CFGNEGOTIATEDMAXP : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
	tipd_L0CFGVCENABLE : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
	tipd_L0CFGVCID : VitalDelayArrayType01 (23 downto 0) := (others => (0 ps, 0 ps));
	tipd_L0DLLHOLDLINKUP : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0ELECTROMECHANICALINTERLOCKENGAGED : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0FWDASSERTINTALEGACYINT : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0FWDASSERTINTBLEGACYINT : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0FWDASSERTINTCLEGACYINT : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0FWDASSERTINTDLEGACYINT : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0FWDCORRERRIN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0FWDDEASSERTINTALEGACYINT : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0FWDDEASSERTINTBLEGACYINT : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0FWDDEASSERTINTCLEGACYINT : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0FWDDEASSERTINTDLEGACYINT : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0FWDFATALERRIN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0FWDNONFATALERRIN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0LEGACYINTFUNCT0 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0MRLSENSORCLOSEDN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0MSIREQUEST0 : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
	tipd_L0PACKETHEADERFROMUSER : VitalDelayArrayType01 (127 downto 0) := (others => (0 ps, 0 ps));
	tipd_L0PMEREQIN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0PORTNUMBER : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
	tipd_L0POWERFAULTDETECTED : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0PRESENCEDETECTSLOTEMPTYN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0PWRNEWSTATEREQ : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0PWRNEXTLINKSTATE : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
	tipd_L0REPLAYTIMERADJUSTMENT : VitalDelayArrayType01 (11 downto 0) := (others => (0 ps, 0 ps));
	tipd_L0ROOTTURNOFFREQ : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0RXTLTLPNONINITIALIZEDVC : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
	tipd_L0SENDUNLOCKMESSAGE : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0SETCOMPLETERABORTERROR : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0SETCOMPLETIONTIMEOUTCORRERROR : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0SETCOMPLETIONTIMEOUTUNCORRERROR : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0SETDETECTEDCORRERROR : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0SETDETECTEDFATALERROR : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0SETDETECTEDNONFATALERROR : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0SETLINKDETECTEDPARITYERROR : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0SETLINKMASTERDATAPARITY : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0SETLINKRECEIVEDMASTERABORT : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0SETLINKRECEIVEDTARGETABORT : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0SETLINKSIGNALLEDTARGETABORT : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0SETLINKSYSTEMERROR : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0SETUNEXPECTEDCOMPLETIONCORRERROR : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0SETUNEXPECTEDCOMPLETIONUNCORRERROR : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0SETUNSUPPORTEDREQUESTOTHERERROR : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0SETUSERDETECTEDPARITYERROR : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0SETUSERMASTERDATAPARITY : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0SETUSERRECEIVEDMASTERABORT : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0SETUSERRECEIVEDTARGETABORT : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0SETUSERSIGNALLEDTARGETABORT : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0SETUSERSYSTEMERROR : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0TLASFCCREDSTARVATION : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0TLLINKRETRAIN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0TRANSACTIONSPENDING : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0TXBEACON : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0TXCFGPM : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0TXCFGPMTYPE : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
	tipd_L0TXTLFCCMPLMCCRED : VitalDelayArrayType01 (159 downto 0) := (others => (0 ps, 0 ps));
	tipd_L0TXTLFCCMPLMCUPDATE : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
	tipd_L0TXTLFCNPOSTBYPCRED : VitalDelayArrayType01 (191 downto 0) := (others => (0 ps, 0 ps));
	tipd_L0TXTLFCNPOSTBYPUPDATE : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
	tipd_L0TXTLFCPOSTORDCRED : VitalDelayArrayType01 (159 downto 0) := (others => (0 ps, 0 ps));
	tipd_L0TXTLFCPOSTORDUPDATE : VitalDelayArrayType01 (15 downto 0) := (others => (0 ps, 0 ps));
	tipd_L0TXTLSBFCDATA : VitalDelayArrayType01 (18 downto 0) := (others => (0 ps, 0 ps));
	tipd_L0TXTLSBFCUPDATE : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0TXTLTLPDATA : VitalDelayArrayType01 (63 downto 0) := (others => (0 ps, 0 ps));
	tipd_L0TXTLTLPEDB : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0TXTLTLPENABLE : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
	tipd_L0TXTLTLPEND : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
	tipd_L0TXTLTLPLATENCY : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
	tipd_L0TXTLTLPREQ : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0TXTLTLPREQEND : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0TXTLTLPWIDTH : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0UPSTREAMRXPORTINL0S : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0VC0PREVIEWEXPAND : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_L0WAKEN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_LLKRXCHFIFO : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
	tipd_LLKRXCHTC : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
	tipd_LLKRXDSTCONTREQN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_LLKRXDSTREQN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_LLKTX4DWHEADERN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_LLKTXCHFIFO : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
	tipd_LLKTXCHTC : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
	tipd_LLKTXCOMPLETEN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_LLKTXCREATEECRCN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_LLKTXDATA : VitalDelayArrayType01 (63 downto 0) := (others => (0 ps, 0 ps));
	tipd_LLKTXENABLEN : VitalDelayArrayType01 (1 downto 0) := (others => (0 ps, 0 ps));
	tipd_LLKTXEOFN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_LLKTXEOPN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_LLKTXSOFN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_LLKTXSOPN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_LLKTXSRCDSCN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_LLKTXSRCRDYN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_MAINPOWER : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_MGMTADDR : VitalDelayArrayType01 (10 downto 0) := (others => (0 ps, 0 ps));
	tipd_MGMTBWREN : VitalDelayArrayType01 (3 downto 0) := (others => (0 ps, 0 ps));
	tipd_MGMTRDEN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_MGMTSTATSCREDITSEL : VitalDelayArrayType01 (6 downto 0) := (others => (0 ps, 0 ps));
	tipd_MGMTWDATA : VitalDelayArrayType01 (31 downto 0) := (others => (0 ps, 0 ps));
	tipd_MGMTWREN : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_MIMDLLBRDATA : VitalDelayArrayType01 (63 downto 0) := (others => (0 ps, 0 ps));
	tipd_MIMRXBRDATA : VitalDelayArrayType01 (63 downto 0) := (others => (0 ps, 0 ps));
	tipd_MIMTXBRDATA : VitalDelayArrayType01 (63 downto 0) := (others => (0 ps, 0 ps));
	tipd_PIPEPHYSTATUSL0 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPEPHYSTATUSL1 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPEPHYSTATUSL2 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPEPHYSTATUSL3 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPEPHYSTATUSL4 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPEPHYSTATUSL5 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPEPHYSTATUSL6 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPEPHYSTATUSL7 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXCHANISALIGNEDL0 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXCHANISALIGNEDL1 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXCHANISALIGNEDL2 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXCHANISALIGNEDL3 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXCHANISALIGNEDL4 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXCHANISALIGNEDL5 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXCHANISALIGNEDL6 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXCHANISALIGNEDL7 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXDATAKL0 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXDATAKL1 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXDATAKL2 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXDATAKL3 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXDATAKL4 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXDATAKL5 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXDATAKL6 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXDATAKL7 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXDATAL0 : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
	tipd_PIPERXDATAL1 : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
	tipd_PIPERXDATAL2 : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
	tipd_PIPERXDATAL3 : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
	tipd_PIPERXDATAL4 : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
	tipd_PIPERXDATAL5 : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
	tipd_PIPERXDATAL6 : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
	tipd_PIPERXDATAL7 : VitalDelayArrayType01 (7 downto 0) := (others => (0 ps, 0 ps));
	tipd_PIPERXELECIDLEL0 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXELECIDLEL1 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXELECIDLEL2 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXELECIDLEL3 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXELECIDLEL4 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXELECIDLEL5 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXELECIDLEL6 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXELECIDLEL7 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXSTATUSL0 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
	tipd_PIPERXSTATUSL1 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
	tipd_PIPERXSTATUSL2 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
	tipd_PIPERXSTATUSL3 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
	tipd_PIPERXSTATUSL4 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
	tipd_PIPERXSTATUSL5 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
	tipd_PIPERXSTATUSL6 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
	tipd_PIPERXSTATUSL7 : VitalDelayArrayType01 (2 downto 0) := (others => (0 ps, 0 ps));
	tipd_PIPERXVALIDL0 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXVALIDL1 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXVALIDL2 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXVALIDL3 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXVALIDL4 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXVALIDL5 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXVALIDL6 : VitalDelayType01 :=  (0 ps, 0 ps);
	tipd_PIPERXVALIDL7 : VitalDelayType01 :=  (0 ps, 0 ps);
	tpd_CRMCORECLKDLO_MIMDLLBRADD : VitalDelayArrayType01(11 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLKDLO_MIMDLLBREN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLKDLO_MIMDLLBWADD : VitalDelayArrayType01(11 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLKDLO_MIMDLLBWDATA : VitalDelayArrayType01(63 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLKDLO_MIMDLLBWEN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLKRXO_MIMRXBRADD : VitalDelayArrayType01(12 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLKRXO_MIMRXBREN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLKRXO_MIMRXBWADD : VitalDelayArrayType01(12 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLKRXO_MIMRXBWDATA : VitalDelayArrayType01(63 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLKRXO_MIMRXBWEN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLKTXO_MIMTXBRADD : VitalDelayArrayType01(12 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLKTXO_MIMTXBREN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLKTXO_MIMTXBWADD : VitalDelayArrayType01(12 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLKTXO_MIMTXBWDATA : VitalDelayArrayType01(63 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLKTXO_MIMTXBWEN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_BUSMASTERENABLE : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_CRMDOHOTRESETN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_CRMPWRSOFTRESETN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_CRMRXHOTRESETN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_DLLTXPMDLLPOUTSTANDING : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_INTERRUPTDISABLE : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_IOSPACEENABLE : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0ASAUTONOMOUSINITCOMPLETED : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0ATTENTIONINDICATORCONTROL : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_L0CFGLOOPBACKACK : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0COMPLETERID : VitalDelayArrayType01(12 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_L0CORRERRMSGRCVD : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0DLLASRXSTATE : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_L0DLLASTXSTATE : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0DLLERRORVECTOR : VitalDelayArrayType01(6 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_L0DLLRXACKOUTSTANDING : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0DLLTXNONFCOUTSTANDING : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0DLLTXOUTSTANDING : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0DLLVCSTATUS : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_L0DLUPDOWN : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_L0ERRMSGREQID : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_L0FATALERRMSGRCVD : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0FIRSTCFGWRITEOCCURRED : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0FWDCORRERROUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0FWDFATALERROUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0FWDNONFATALERROUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0LTSSMSTATE : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_L0MACENTEREDL0 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0MACLINKTRAINING : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0MACLINKUP : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0MACNEGOTIATEDLINKWIDTH : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_L0MACNEWSTATEACK : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0MACRXL0SSTATE : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0MACUPSTREAMDOWNSTREAM : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0MCFOUND : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_L0MSIENABLE0 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0MULTIMSGEN0 : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_L0NONFATALERRMSGRCVD : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0PMEACK : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0PMEEN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0PMEREQOUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0POWERCONTROLLERCONTROL : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0POWERINDICATORCONTROL : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_L0PWRINHIBITTRANSFERS : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0PWRL1STATE : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0PWRL23READYDEVICE : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0PWRL23READYSTATE : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0PWRSTATE0 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_L0PWRTURNOFFREQ : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0PWRTXL0SSTATE : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0RECEIVEDASSERTINTALEGACYINT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0RECEIVEDASSERTINTBLEGACYINT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0RECEIVEDASSERTINTCLEGACYINT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0RECEIVEDASSERTINTDLEGACYINT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0RECEIVEDDEASSERTINTALEGACYINT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0RECEIVEDDEASSERTINTBLEGACYINT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0RECEIVEDDEASSERTINTCLEGACYINT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0RECEIVEDDEASSERTINTDLEGACYINT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0RXBEACON : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0RXDLLFCCMPLMCCRED : VitalDelayArrayType01(23 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_L0RXDLLFCCMPLMCUPDATE : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_L0RXDLLFCNPOSTBYPCRED : VitalDelayArrayType01(19 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_L0RXDLLFCNPOSTBYPUPDATE : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_L0RXDLLFCPOSTORDCRED : VitalDelayArrayType01(23 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_L0RXDLLFCPOSTORDUPDATE : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_L0RXDLLPM : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0RXDLLPMTYPE : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_L0RXDLLSBFCDATA : VitalDelayArrayType01(18 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_L0RXDLLSBFCUPDATE : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0RXDLLTLPECRCOK : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0RXDLLTLPEND : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_L0RXMACLINKERROR : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_L0STATSCFGOTHERRECEIVED : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0STATSCFGOTHERTRANSMITTED : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0STATSCFGRECEIVED : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0STATSCFGTRANSMITTED : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0STATSDLLPRECEIVED : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0STATSDLLPTRANSMITTED : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0STATSOSRECEIVED : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0STATSOSTRANSMITTED : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0STATSTLPRECEIVED : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0STATSTLPTRANSMITTED : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0TOGGLEELECTROMECHANICALINTERLOCK : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0TRANSFORMEDVC : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_L0TXDLLFCCMPLMCUPDATED : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_L0TXDLLFCNPOSTBYPUPDATED : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_L0TXDLLFCPOSTORDUPDATED : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_L0TXDLLPMUPDATED : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0TXDLLSBFCUPDATED : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_L0UCBYPFOUND : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_L0UCORDFOUND : VitalDelayArrayType01(3 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_L0UNLOCKRECEIVED : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_LLKRX4DWHEADERN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_LLKRXCHCOMPLETIONAVAILABLEN : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_LLKRXCHCOMPLETIONPARTIALN : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_LLKRXCHCONFIGAVAILABLEN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_LLKRXCHCONFIGPARTIALN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_LLKRXCHNONPOSTEDAVAILABLEN : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_LLKRXCHNONPOSTEDPARTIALN : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_LLKRXCHPOSTEDAVAILABLEN : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_LLKRXCHPOSTEDPARTIALN : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_LLKRXDATA : VitalDelayArrayType01(63 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_LLKRXECRCBADN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_LLKRXEOFN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_LLKRXEOPN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_LLKRXPREFERREDTYPE : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_LLKRXSOFN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_LLKRXSOPN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_LLKRXSRCDSCN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_LLKRXSRCLASTREQN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_LLKRXSRCRDYN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_LLKRXVALIDN : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_LLKTCSTATUS : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_LLKTXCHANSPACE : VitalDelayArrayType01(9 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_LLKTXCHCOMPLETIONREADYN : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_LLKTXCHNONPOSTEDREADYN : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_LLKTXCHPOSTEDREADYN : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_LLKTXCONFIGREADYN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_LLKTXDSTRDYN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_MAXPAYLOADSIZE : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_MAXREADREQUESTSIZE : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_MEMSPACEENABLE : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_MGMTPSO : VitalDelayArrayType01(16 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_MGMTRDATA : VitalDelayArrayType01(31 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_MGMTSTATSCREDIT : VitalDelayArrayType01(11 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_PARITYERRORRESPONSE : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPEDESKEWLANESL0 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPEDESKEWLANESL1 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPEDESKEWLANESL2 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPEDESKEWLANESL3 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPEDESKEWLANESL4 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPEDESKEWLANESL5 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPEDESKEWLANESL6 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPEDESKEWLANESL7 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPEPOWERDOWNL0 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_PIPEPOWERDOWNL1 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_PIPEPOWERDOWNL2 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_PIPEPOWERDOWNL3 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_PIPEPOWERDOWNL4 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_PIPEPOWERDOWNL5 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_PIPEPOWERDOWNL6 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_PIPEPOWERDOWNL7 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_PIPERESETL0 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPERESETL1 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPERESETL2 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPERESETL3 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPERESETL4 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPERESETL5 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPERESETL6 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPERESETL7 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPERXPOLARITYL0 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPERXPOLARITYL1 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPERXPOLARITYL2 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPERXPOLARITYL3 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPERXPOLARITYL4 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPERXPOLARITYL5 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPERXPOLARITYL6 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPERXPOLARITYL7 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXCOMPLIANCEL0 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXCOMPLIANCEL1 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXCOMPLIANCEL2 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXCOMPLIANCEL3 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXCOMPLIANCEL4 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXCOMPLIANCEL5 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXCOMPLIANCEL6 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXCOMPLIANCEL7 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXDATAKL0 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXDATAKL1 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXDATAKL2 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXDATAKL3 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXDATAKL4 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXDATAKL5 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXDATAKL6 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXDATAKL7 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXDATAL0 : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_PIPETXDATAL1 : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_PIPETXDATAL2 : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_PIPETXDATAL3 : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_PIPETXDATAL4 : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_PIPETXDATAL5 : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_PIPETXDATAL6 : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_PIPETXDATAL7 : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMCORECLK_PIPETXDETECTRXLOOPBACKL0 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXDETECTRXLOOPBACKL1 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXDETECTRXLOOPBACKL2 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXDETECTRXLOOPBACKL3 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXDETECTRXLOOPBACKL4 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXDETECTRXLOOPBACKL5 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXDETECTRXLOOPBACKL6 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXDETECTRXLOOPBACKL7 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXELECIDLEL0 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXELECIDLEL1 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXELECIDLEL2 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXELECIDLEL3 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXELECIDLEL4 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXELECIDLEL5 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXELECIDLEL6 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_PIPETXELECIDLEL7 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_SERRENABLE : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMCORECLK_URREPORTINGENABLE : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLKRXO_MIMRXBRADD : VitalDelayArrayType01(12 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMUSERCLKRXO_MIMRXBREN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLKTXO_MIMTXBWADD : VitalDelayArrayType01(12 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMUSERCLKTXO_MIMTXBWDATA : VitalDelayArrayType01(63 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMUSERCLKTXO_MIMTXBWEN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_BUSMASTERENABLE : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_INTERRUPTDISABLE : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_IOSPACEENABLE : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0ATTENTIONINDICATORCONTROL : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMUSERCLK_L0COMPLETERID : VitalDelayArrayType01(12 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMUSERCLK_L0CORRERRMSGRCVD : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0ERRMSGREQID : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMUSERCLK_L0FATALERRMSGRCVD : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0FIRSTCFGWRITEOCCURRED : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0FWDCORRERROUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0FWDFATALERROUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0FWDNONFATALERROUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0MSIENABLE0 : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0MULTIMSGEN0 : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMUSERCLK_L0NONFATALERRMSGRCVD : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0PMEACK : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0PMEEN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0PMEREQOUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0POWERCONTROLLERCONTROL : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0POWERINDICATORCONTROL : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMUSERCLK_L0PWRL1STATE : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0PWRL23READYDEVICE : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0PWRL23READYSTATE : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0PWRSTATE0 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMUSERCLK_L0PWRTURNOFFREQ : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0PWRTXL0SSTATE : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0RECEIVEDASSERTINTALEGACYINT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0RECEIVEDASSERTINTBLEGACYINT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0RECEIVEDASSERTINTCLEGACYINT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0RECEIVEDASSERTINTDLEGACYINT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0RECEIVEDDEASSERTINTALEGACYINT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0RECEIVEDDEASSERTINTBLEGACYINT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0RECEIVEDDEASSERTINTCLEGACYINT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0RECEIVEDDEASSERTINTDLEGACYINT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0STATSCFGOTHERRECEIVED : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0STATSCFGOTHERTRANSMITTED : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0STATSCFGRECEIVED : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0STATSCFGTRANSMITTED : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0TOGGLEELECTROMECHANICALINTERLOCK : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_L0UNLOCKRECEIVED : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_LLKRX4DWHEADERN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_LLKRXCHCOMPLETIONAVAILABLEN : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMUSERCLK_LLKRXCHCOMPLETIONPARTIALN : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMUSERCLK_LLKRXCHCONFIGAVAILABLEN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_LLKRXCHCONFIGPARTIALN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_LLKRXCHNONPOSTEDAVAILABLEN : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMUSERCLK_LLKRXCHNONPOSTEDPARTIALN : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMUSERCLK_LLKRXCHPOSTEDAVAILABLEN : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMUSERCLK_LLKRXCHPOSTEDPARTIALN : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMUSERCLK_LLKRXDATA : VitalDelayArrayType01(63 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMUSERCLK_LLKRXECRCBADN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_LLKRXEOFN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_LLKRXEOPN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_LLKRXPREFERREDTYPE : VitalDelayArrayType01(15 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMUSERCLK_LLKRXSOFN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_LLKRXSOPN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_LLKRXSRCDSCN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_LLKRXSRCLASTREQN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_LLKRXSRCRDYN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_LLKRXVALIDN : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMUSERCLK_LLKTCSTATUS : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMUSERCLK_LLKTXCHANSPACE : VitalDelayArrayType01(9 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMUSERCLK_LLKTXCHCOMPLETIONREADYN : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMUSERCLK_LLKTXCHNONPOSTEDREADYN : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMUSERCLK_LLKTXCHPOSTEDREADYN : VitalDelayArrayType01(7 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMUSERCLK_LLKTXCONFIGREADYN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_LLKTXDSTRDYN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_MAXPAYLOADSIZE : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMUSERCLK_MAXREADREQUESTSIZE : VitalDelayArrayType01(2 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMUSERCLK_MEMSPACEENABLE : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_MGMTPSO : VitalDelayArrayType01(16 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMUSERCLK_MGMTRDATA : VitalDelayArrayType01(31 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMUSERCLK_MGMTSTATSCREDIT : VitalDelayArrayType01(11 downto 0) := (others => (0 ps, 0 ps));
	tpd_CRMUSERCLK_PARITYERRORRESPONSE : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_SERRENABLE : VitalDelayType01 := (0 ps, 0 ps);
	tpd_CRMUSERCLK_URREPORTINGENABLE : VitalDelayType01 := (0 ps, 0 ps);
	tpd_L0WAKEN_L0RXBEACON : VitalDelayType01 := (0 ps, 0 ps);
	tpd_MAINPOWER_L0PMEEN : VitalDelayType01 := (0 ps, 0 ps);
	tpd_MAINPOWER_L0PMEREQOUT : VitalDelayType01 := (0 ps, 0 ps);
	tpd_MAINPOWER_L0RXBEACON : VitalDelayType01 := (0 ps, 0 ps);
	tpd_MAINPOWER_PIPEPOWERDOWNL0 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
	tpd_MAINPOWER_PIPEPOWERDOWNL1 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
	tpd_MAINPOWER_PIPEPOWERDOWNL2 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
	tpd_MAINPOWER_PIPEPOWERDOWNL3 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
	tpd_MAINPOWER_PIPEPOWERDOWNL4 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
	tpd_MAINPOWER_PIPEPOWERDOWNL5 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
	tpd_MAINPOWER_PIPEPOWERDOWNL6 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));
	tpd_MAINPOWER_PIPEPOWERDOWNL7 : VitalDelayArrayType01(1 downto 0) := (others => (0 ps, 0 ps));

       	trecovery_CRMLINKRSTN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	trecovery_CRMLINKRSTN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	trecovery_CRMMACRSTN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	trecovery_CRMMACRSTN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	trecovery_CRMMGMTRSTN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	trecovery_CRMMGMTRSTN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	trecovery_CRMNVRSTN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	trecovery_CRMNVRSTN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	trecovery_CRMURSTN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	trecovery_CRMURSTN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	trecovery_CRMUSERCFGRSTN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	trecovery_CRMUSERCFGRSTN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tremoval_CRMLINKRSTN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tremoval_CRMLINKRSTN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tremoval_CRMMACRSTN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tremoval_CRMMACRSTN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tremoval_CRMMGMTRSTN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tremoval_CRMMGMTRSTN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tremoval_CRMNVRSTN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tremoval_CRMNVRSTN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tremoval_CRMURSTN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tremoval_CRMURSTN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tremoval_CRMUSERCFGRSTN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tremoval_CRMUSERCFGRSTN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;

       	thold_AUXPOWER_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_AUXPOWER_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_AUXPOWER_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_AUXPOWER_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_CFGNEGOTIATEDLINKWIDTH_CRMCORECLK_negedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
	thold_CFGNEGOTIATEDLINKWIDTH_CRMCORECLK_posedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
	thold_COMPLIANCEAVOID_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_COMPLIANCEAVOID_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_CRMCFGBRIDGEHOTRESET_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_CRMCFGBRIDGEHOTRESET_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_CRMLINKRSTN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_CRMLINKRSTN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_CRMMACRSTN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_CRMMACRSTN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_CRMMGMTRSTN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_CRMMGMTRSTN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_CRMNVRSTN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_CRMNVRSTN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_CRMTXHOTRESETN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_CRMTXHOTRESETN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_CRMURSTN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_CRMURSTN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_CRMUSERCFGRSTN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_CRMUSERCFGRSTN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_CROSSLINKSEED_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_CROSSLINKSEED_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0ACKNAKTIMERADJUSTMENT_CRMCORECLK_negedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
	thold_L0ACKNAKTIMERADJUSTMENT_CRMCORECLK_posedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
	thold_L0ALLDOWNPORTSINL1_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0ALLDOWNPORTSINL1_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0ALLDOWNPORTSINL1_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0ALLDOWNPORTSINL1_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0ALLDOWNRXPORTSINL0S_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0ALLDOWNRXPORTSINL0S_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0ALLDOWNRXPORTSINL0S_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0ALLDOWNRXPORTSINL0S_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0ASE_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0ASE_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0ASPORTCOUNT_CRMCORECLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_L0ASPORTCOUNT_CRMCORECLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_L0ASTURNPOOLBITSCONSUMED_CRMCORECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_L0ASTURNPOOLBITSCONSUMED_CRMCORECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_L0ATTENTIONBUTTONPRESSED_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0ATTENTIONBUTTONPRESSED_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0ATTENTIONBUTTONPRESSED_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0ATTENTIONBUTTONPRESSED_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0CFGASSPANTREEOWNEDSTATE_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0CFGASSPANTREEOWNEDSTATE_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0CFGASSTATECHANGECMD_CRMCORECLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
	thold_L0CFGASSTATECHANGECMD_CRMCORECLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
	thold_L0CFGDISABLESCRAMBLE_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0CFGDISABLESCRAMBLE_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0CFGEXTENDEDSYNC_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0CFGEXTENDEDSYNC_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0CFGL0SENTRYENABLE_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0CFGL0SENTRYENABLE_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0CFGL0SENTRYSUP_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0CFGL0SENTRYSUP_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0CFGL0SEXITLAT_CRMCORECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_L0CFGL0SEXITLAT_CRMCORECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_L0CFGLINKDISABLE_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0CFGLINKDISABLE_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0CFGLOOPBACKMASTER_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0CFGLOOPBACKMASTER_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0CFGNEGOTIATEDMAXP_CRMCORECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_L0CFGNEGOTIATEDMAXP_CRMCORECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_L0CFGVCENABLE_CRMCORECLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_L0CFGVCENABLE_CRMCORECLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_L0CFGVCID_CRMCORECLK_negedge_posedge : VitalDelayArrayType(23 downto 0) := (others => 0 ps);
	thold_L0CFGVCID_CRMCORECLK_posedge_posedge : VitalDelayArrayType(23 downto 0) := (others => 0 ps);
	thold_L0DLLHOLDLINKUP_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0DLLHOLDLINKUP_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0ELECTROMECHANICALINTERLOCKENGAGED_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0ELECTROMECHANICALINTERLOCKENGAGED_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0ELECTROMECHANICALINTERLOCKENGAGED_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0ELECTROMECHANICALINTERLOCKENGAGED_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDASSERTINTALEGACYINT_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDASSERTINTALEGACYINT_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDASSERTINTALEGACYINT_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDASSERTINTALEGACYINT_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDASSERTINTBLEGACYINT_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDASSERTINTBLEGACYINT_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDASSERTINTBLEGACYINT_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDASSERTINTBLEGACYINT_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDASSERTINTCLEGACYINT_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDASSERTINTCLEGACYINT_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDASSERTINTCLEGACYINT_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDASSERTINTCLEGACYINT_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDASSERTINTDLEGACYINT_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDASSERTINTDLEGACYINT_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDASSERTINTDLEGACYINT_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDASSERTINTDLEGACYINT_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDCORRERRIN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDCORRERRIN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDCORRERRIN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDCORRERRIN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDDEASSERTINTALEGACYINT_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDDEASSERTINTALEGACYINT_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDDEASSERTINTALEGACYINT_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDDEASSERTINTALEGACYINT_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDDEASSERTINTBLEGACYINT_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDDEASSERTINTBLEGACYINT_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDDEASSERTINTBLEGACYINT_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDDEASSERTINTBLEGACYINT_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDDEASSERTINTCLEGACYINT_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDDEASSERTINTCLEGACYINT_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDDEASSERTINTCLEGACYINT_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDDEASSERTINTCLEGACYINT_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDDEASSERTINTDLEGACYINT_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDDEASSERTINTDLEGACYINT_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDDEASSERTINTDLEGACYINT_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDDEASSERTINTDLEGACYINT_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDFATALERRIN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDFATALERRIN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDFATALERRIN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDFATALERRIN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDNONFATALERRIN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDNONFATALERRIN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDNONFATALERRIN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0FWDNONFATALERRIN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0LEGACYINTFUNCT0_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0LEGACYINTFUNCT0_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0LEGACYINTFUNCT0_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0LEGACYINTFUNCT0_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0MRLSENSORCLOSEDN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0MRLSENSORCLOSEDN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0MRLSENSORCLOSEDN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0MRLSENSORCLOSEDN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0MSIREQUEST0_CRMCORECLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
	thold_L0MSIREQUEST0_CRMCORECLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
	thold_L0MSIREQUEST0_CRMUSERCLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
	thold_L0MSIREQUEST0_CRMUSERCLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
	thold_L0PACKETHEADERFROMUSER_CRMCORECLK_negedge_posedge : VitalDelayArrayType(127 downto 0) := (others => 0 ps);
	thold_L0PACKETHEADERFROMUSER_CRMCORECLK_posedge_posedge : VitalDelayArrayType(127 downto 0) := (others => 0 ps);
	thold_L0PACKETHEADERFROMUSER_CRMUSERCLK_negedge_posedge : VitalDelayArrayType(127 downto 0) := (others => 0 ps);
	thold_L0PACKETHEADERFROMUSER_CRMUSERCLK_posedge_posedge : VitalDelayArrayType(127 downto 0) := (others => 0 ps);
	thold_L0PMEREQIN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0PMEREQIN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0PORTNUMBER_CRMCORECLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_L0PORTNUMBER_CRMCORECLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_L0PORTNUMBER_CRMUSERCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_L0PORTNUMBER_CRMUSERCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_L0POWERFAULTDETECTED_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0POWERFAULTDETECTED_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0POWERFAULTDETECTED_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0POWERFAULTDETECTED_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0PRESENCEDETECTSLOTEMPTYN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0PRESENCEDETECTSLOTEMPTYN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0PRESENCEDETECTSLOTEMPTYN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0PRESENCEDETECTSLOTEMPTYN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0PWRNEWSTATEREQ_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0PWRNEWSTATEREQ_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0PWRNEXTLINKSTATE_CRMCORECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_L0PWRNEXTLINKSTATE_CRMCORECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_L0REPLAYTIMERADJUSTMENT_CRMCORECLK_negedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
	thold_L0REPLAYTIMERADJUSTMENT_CRMCORECLK_posedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
	thold_L0ROOTTURNOFFREQ_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0ROOTTURNOFFREQ_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0ROOTTURNOFFREQ_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0ROOTTURNOFFREQ_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0RXTLTLPNONINITIALIZEDVC_CRMCORECLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_L0RXTLTLPNONINITIALIZEDVC_CRMCORECLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_L0SENDUNLOCKMESSAGE_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SENDUNLOCKMESSAGE_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SENDUNLOCKMESSAGE_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SENDUNLOCKMESSAGE_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETCOMPLETERABORTERROR_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETCOMPLETERABORTERROR_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETCOMPLETERABORTERROR_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETCOMPLETERABORTERROR_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETCOMPLETIONTIMEOUTCORRERROR_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETCOMPLETIONTIMEOUTCORRERROR_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETCOMPLETIONTIMEOUTCORRERROR_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETCOMPLETIONTIMEOUTCORRERROR_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETCOMPLETIONTIMEOUTUNCORRERROR_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETCOMPLETIONTIMEOUTUNCORRERROR_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETCOMPLETIONTIMEOUTUNCORRERROR_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETCOMPLETIONTIMEOUTUNCORRERROR_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETDETECTEDCORRERROR_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETDETECTEDCORRERROR_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETDETECTEDCORRERROR_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETDETECTEDCORRERROR_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETDETECTEDFATALERROR_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETDETECTEDFATALERROR_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETDETECTEDFATALERROR_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETDETECTEDFATALERROR_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETDETECTEDNONFATALERROR_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETDETECTEDNONFATALERROR_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETDETECTEDNONFATALERROR_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETDETECTEDNONFATALERROR_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETLINKDETECTEDPARITYERROR_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETLINKDETECTEDPARITYERROR_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETLINKDETECTEDPARITYERROR_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETLINKDETECTEDPARITYERROR_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETLINKMASTERDATAPARITY_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETLINKMASTERDATAPARITY_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETLINKMASTERDATAPARITY_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETLINKMASTERDATAPARITY_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETLINKRECEIVEDMASTERABORT_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETLINKRECEIVEDMASTERABORT_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETLINKRECEIVEDMASTERABORT_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETLINKRECEIVEDMASTERABORT_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETLINKRECEIVEDTARGETABORT_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETLINKRECEIVEDTARGETABORT_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETLINKRECEIVEDTARGETABORT_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETLINKRECEIVEDTARGETABORT_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETLINKSIGNALLEDTARGETABORT_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETLINKSIGNALLEDTARGETABORT_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETLINKSIGNALLEDTARGETABORT_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETLINKSIGNALLEDTARGETABORT_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETLINKSYSTEMERROR_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETLINKSYSTEMERROR_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETLINKSYSTEMERROR_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETLINKSYSTEMERROR_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUNEXPECTEDCOMPLETIONCORRERROR_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUNEXPECTEDCOMPLETIONCORRERROR_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUNEXPECTEDCOMPLETIONCORRERROR_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUNEXPECTEDCOMPLETIONCORRERROR_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUNSUPPORTEDREQUESTOTHERERROR_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUNSUPPORTEDREQUESTOTHERERROR_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUNSUPPORTEDREQUESTOTHERERROR_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUNSUPPORTEDREQUESTOTHERERROR_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUSERDETECTEDPARITYERROR_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUSERDETECTEDPARITYERROR_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUSERDETECTEDPARITYERROR_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUSERDETECTEDPARITYERROR_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUSERMASTERDATAPARITY_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUSERMASTERDATAPARITY_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUSERMASTERDATAPARITY_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUSERMASTERDATAPARITY_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUSERRECEIVEDMASTERABORT_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUSERRECEIVEDMASTERABORT_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUSERRECEIVEDMASTERABORT_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUSERRECEIVEDMASTERABORT_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUSERRECEIVEDTARGETABORT_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUSERRECEIVEDTARGETABORT_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUSERRECEIVEDTARGETABORT_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUSERRECEIVEDTARGETABORT_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUSERSIGNALLEDTARGETABORT_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUSERSIGNALLEDTARGETABORT_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUSERSIGNALLEDTARGETABORT_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUSERSIGNALLEDTARGETABORT_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUSERSYSTEMERROR_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUSERSYSTEMERROR_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUSERSYSTEMERROR_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0SETUSERSYSTEMERROR_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0TLASFCCREDSTARVATION_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0TLASFCCREDSTARVATION_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0TLLINKRETRAIN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0TLLINKRETRAIN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0TRANSACTIONSPENDING_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0TRANSACTIONSPENDING_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0TRANSACTIONSPENDING_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0TRANSACTIONSPENDING_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0TXBEACON_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0TXBEACON_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0TXCFGPMTYPE_CRMCORECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_L0TXCFGPMTYPE_CRMCORECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_L0TXCFGPM_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0TXCFGPM_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0TXTLFCCMPLMCCRED_CRMCORECLK_negedge_posedge : VitalDelayArrayType(159 downto 0) := (others => 0 ps);
	thold_L0TXTLFCCMPLMCCRED_CRMCORECLK_posedge_posedge : VitalDelayArrayType(159 downto 0) := (others => 0 ps);
	thold_L0TXTLFCCMPLMCUPDATE_CRMCORECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	thold_L0TXTLFCCMPLMCUPDATE_CRMCORECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	thold_L0TXTLFCNPOSTBYPCRED_CRMCORECLK_negedge_posedge : VitalDelayArrayType(191 downto 0) := (others => 0 ps);
	thold_L0TXTLFCNPOSTBYPCRED_CRMCORECLK_posedge_posedge : VitalDelayArrayType(191 downto 0) := (others => 0 ps);
	thold_L0TXTLFCNPOSTBYPUPDATE_CRMCORECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	thold_L0TXTLFCNPOSTBYPUPDATE_CRMCORECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	thold_L0TXTLFCPOSTORDCRED_CRMCORECLK_negedge_posedge : VitalDelayArrayType(159 downto 0) := (others => 0 ps);
	thold_L0TXTLFCPOSTORDCRED_CRMCORECLK_posedge_posedge : VitalDelayArrayType(159 downto 0) := (others => 0 ps);
	thold_L0TXTLFCPOSTORDUPDATE_CRMCORECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	thold_L0TXTLFCPOSTORDUPDATE_CRMCORECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	thold_L0TXTLSBFCDATA_CRMCORECLK_negedge_posedge : VitalDelayArrayType(18 downto 0) := (others => 0 ps);
	thold_L0TXTLSBFCDATA_CRMCORECLK_posedge_posedge : VitalDelayArrayType(18 downto 0) := (others => 0 ps);
	thold_L0TXTLSBFCUPDATE_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0TXTLSBFCUPDATE_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0TXTLTLPDATA_CRMCORECLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	thold_L0TXTLTLPDATA_CRMCORECLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	thold_L0TXTLTLPEDB_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0TXTLTLPEDB_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0TXTLTLPENABLE_CRMCORECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_L0TXTLTLPENABLE_CRMCORECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_L0TXTLTLPEND_CRMCORECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_L0TXTLTLPEND_CRMCORECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_L0TXTLTLPLATENCY_CRMCORECLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
	thold_L0TXTLTLPLATENCY_CRMCORECLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
	thold_L0TXTLTLPREQEND_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0TXTLTLPREQEND_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0TXTLTLPREQ_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0TXTLTLPREQ_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0TXTLTLPWIDTH_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0TXTLTLPWIDTH_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0UPSTREAMRXPORTINL0S_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0UPSTREAMRXPORTINL0S_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0UPSTREAMRXPORTINL0S_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0UPSTREAMRXPORTINL0S_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0VC0PREVIEWEXPAND_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0VC0PREVIEWEXPAND_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_L0WAKEN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_L0WAKEN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_LLKRXCHFIFO_CRMCORECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_LLKRXCHFIFO_CRMCORECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_LLKRXCHFIFO_CRMUSERCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_LLKRXCHFIFO_CRMUSERCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_LLKRXCHTC_CRMCORECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_LLKRXCHTC_CRMCORECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_LLKRXCHTC_CRMUSERCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_LLKRXCHTC_CRMUSERCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_LLKRXDSTCONTREQN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_LLKRXDSTCONTREQN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_LLKRXDSTCONTREQN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_LLKRXDSTCONTREQN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_LLKRXDSTREQN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_LLKRXDSTREQN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_LLKRXDSTREQN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_LLKRXDSTREQN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTX4DWHEADERN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTX4DWHEADERN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTX4DWHEADERN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTX4DWHEADERN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXCHFIFO_CRMCORECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_LLKTXCHFIFO_CRMCORECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_LLKTXCHFIFO_CRMUSERCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_LLKTXCHFIFO_CRMUSERCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_LLKTXCHTC_CRMCORECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_LLKTXCHTC_CRMCORECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_LLKTXCHTC_CRMUSERCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_LLKTXCHTC_CRMUSERCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_LLKTXCOMPLETEN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXCOMPLETEN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXCOMPLETEN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXCOMPLETEN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXCREATEECRCN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXCREATEECRCN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXCREATEECRCN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXCREATEECRCN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXDATA_CRMCORECLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	thold_LLKTXDATA_CRMCORECLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	thold_LLKTXDATA_CRMUSERCLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	thold_LLKTXDATA_CRMUSERCLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	thold_LLKTXENABLEN_CRMCORECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_LLKTXENABLEN_CRMCORECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_LLKTXENABLEN_CRMUSERCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_LLKTXENABLEN_CRMUSERCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	thold_LLKTXEOFN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXEOFN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXEOFN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXEOFN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXEOPN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXEOPN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXEOPN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXEOPN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXSOFN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXSOFN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXSOFN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXSOFN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXSOPN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXSOPN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXSOPN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXSOPN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXSRCDSCN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXSRCDSCN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXSRCDSCN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXSRCDSCN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXSRCRDYN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXSRCRDYN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXSRCRDYN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_LLKTXSRCRDYN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_MAINPOWER_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_MAINPOWER_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_MGMTADDR_CRMCORECLK_negedge_posedge : VitalDelayArrayType(10 downto 0) := (others => 0 ps);
	thold_MGMTADDR_CRMCORECLK_posedge_posedge : VitalDelayArrayType(10 downto 0) := (others => 0 ps);
	thold_MGMTADDR_CRMUSERCLK_negedge_posedge : VitalDelayArrayType(10 downto 0) := (others => 0 ps);
	thold_MGMTADDR_CRMUSERCLK_posedge_posedge : VitalDelayArrayType(10 downto 0) := (others => 0 ps);
	thold_MGMTBWREN_CRMCORECLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
	thold_MGMTBWREN_CRMCORECLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
	thold_MGMTBWREN_CRMUSERCLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
	thold_MGMTBWREN_CRMUSERCLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
	thold_MGMTRDEN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_MGMTRDEN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_MGMTRDEN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_MGMTRDEN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_MGMTSTATSCREDITSEL_CRMCORECLK_negedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
	thold_MGMTSTATSCREDITSEL_CRMCORECLK_posedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
	thold_MGMTSTATSCREDITSEL_CRMUSERCLK_negedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
	thold_MGMTSTATSCREDITSEL_CRMUSERCLK_posedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
	thold_MGMTWDATA_CRMCORECLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
	thold_MGMTWDATA_CRMCORECLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
	thold_MGMTWDATA_CRMUSERCLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
	thold_MGMTWDATA_CRMUSERCLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
	thold_MGMTWREN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_MGMTWREN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_MGMTWREN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_MGMTWREN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_MIMDLLBRDATA_CRMCORECLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	thold_MIMDLLBRDATA_CRMCORECLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	thold_MIMRXBRDATA_CRMCORECLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	thold_MIMRXBRDATA_CRMCORECLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	thold_MIMRXBRDATA_CRMUSERCLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	thold_MIMRXBRDATA_CRMUSERCLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	thold_MIMTXBRDATA_CRMCORECLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	thold_MIMTXBRDATA_CRMCORECLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	thold_PIPEPHYSTATUSL0_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPEPHYSTATUSL0_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPEPHYSTATUSL1_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPEPHYSTATUSL1_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPEPHYSTATUSL2_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPEPHYSTATUSL2_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPEPHYSTATUSL3_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPEPHYSTATUSL3_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPEPHYSTATUSL4_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPEPHYSTATUSL4_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPEPHYSTATUSL5_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPEPHYSTATUSL5_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPEPHYSTATUSL6_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPEPHYSTATUSL6_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPEPHYSTATUSL7_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPEPHYSTATUSL7_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXCHANISALIGNEDL0_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXCHANISALIGNEDL0_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXCHANISALIGNEDL1_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXCHANISALIGNEDL1_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXCHANISALIGNEDL2_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXCHANISALIGNEDL2_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXCHANISALIGNEDL3_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXCHANISALIGNEDL3_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXCHANISALIGNEDL4_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXCHANISALIGNEDL4_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXCHANISALIGNEDL5_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXCHANISALIGNEDL5_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXCHANISALIGNEDL6_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXCHANISALIGNEDL6_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXCHANISALIGNEDL7_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXCHANISALIGNEDL7_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXDATAKL0_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXDATAKL0_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXDATAKL1_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXDATAKL1_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXDATAKL2_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXDATAKL2_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXDATAKL3_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXDATAKL3_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXDATAKL4_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXDATAKL4_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXDATAKL5_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXDATAKL5_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXDATAKL6_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXDATAKL6_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXDATAKL7_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXDATAKL7_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXDATAL0_CRMCORECLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_PIPERXDATAL0_CRMCORECLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_PIPERXDATAL1_CRMCORECLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_PIPERXDATAL1_CRMCORECLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_PIPERXDATAL2_CRMCORECLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_PIPERXDATAL2_CRMCORECLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_PIPERXDATAL3_CRMCORECLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_PIPERXDATAL3_CRMCORECLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_PIPERXDATAL4_CRMCORECLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_PIPERXDATAL4_CRMCORECLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_PIPERXDATAL5_CRMCORECLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_PIPERXDATAL5_CRMCORECLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_PIPERXDATAL6_CRMCORECLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_PIPERXDATAL6_CRMCORECLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_PIPERXDATAL7_CRMCORECLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_PIPERXDATAL7_CRMCORECLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	thold_PIPERXELECIDLEL0_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXELECIDLEL0_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXELECIDLEL1_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXELECIDLEL1_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXELECIDLEL2_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXELECIDLEL2_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXELECIDLEL3_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXELECIDLEL3_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXELECIDLEL4_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXELECIDLEL4_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXELECIDLEL5_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXELECIDLEL5_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXELECIDLEL6_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXELECIDLEL6_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXELECIDLEL7_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXELECIDLEL7_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXSTATUSL0_CRMCORECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_PIPERXSTATUSL0_CRMCORECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_PIPERXSTATUSL1_CRMCORECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_PIPERXSTATUSL1_CRMCORECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_PIPERXSTATUSL2_CRMCORECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_PIPERXSTATUSL2_CRMCORECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_PIPERXSTATUSL3_CRMCORECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_PIPERXSTATUSL3_CRMCORECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_PIPERXSTATUSL4_CRMCORECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_PIPERXSTATUSL4_CRMCORECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_PIPERXSTATUSL5_CRMCORECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_PIPERXSTATUSL5_CRMCORECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_PIPERXSTATUSL6_CRMCORECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_PIPERXSTATUSL6_CRMCORECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_PIPERXSTATUSL7_CRMCORECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_PIPERXSTATUSL7_CRMCORECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	thold_PIPERXVALIDL0_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXVALIDL0_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXVALIDL1_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXVALIDL1_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXVALIDL2_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXVALIDL2_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXVALIDL3_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXVALIDL3_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXVALIDL4_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXVALIDL4_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXVALIDL5_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXVALIDL5_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXVALIDL6_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXVALIDL6_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXVALIDL7_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	thold_PIPERXVALIDL7_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_AUXPOWER_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_AUXPOWER_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_AUXPOWER_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_AUXPOWER_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CFGNEGOTIATEDLINKWIDTH_CRMCORECLK_negedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
	tsetup_CFGNEGOTIATEDLINKWIDTH_CRMCORECLK_posedge_posedge : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
	tsetup_COMPLIANCEAVOID_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_COMPLIANCEAVOID_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CRMCFGBRIDGEHOTRESET_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CRMCFGBRIDGEHOTRESET_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CRMLINKRSTN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CRMLINKRSTN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CRMMACRSTN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CRMMACRSTN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CRMMGMTRSTN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CRMMGMTRSTN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CRMNVRSTN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CRMNVRSTN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CRMTXHOTRESETN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CRMTXHOTRESETN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CRMURSTN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CRMURSTN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CRMUSERCFGRSTN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CRMUSERCFGRSTN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_CROSSLINKSEED_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_CROSSLINKSEED_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0ACKNAKTIMERADJUSTMENT_CRMCORECLK_negedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
	tsetup_L0ACKNAKTIMERADJUSTMENT_CRMCORECLK_posedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
	tsetup_L0ALLDOWNPORTSINL1_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0ALLDOWNPORTSINL1_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0ALLDOWNPORTSINL1_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0ALLDOWNPORTSINL1_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0ALLDOWNRXPORTSINL0S_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0ALLDOWNRXPORTSINL0S_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0ALLDOWNRXPORTSINL0S_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0ALLDOWNRXPORTSINL0S_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0ASE_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0ASE_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0ASPORTCOUNT_CRMCORECLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_L0ASPORTCOUNT_CRMCORECLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_L0ASTURNPOOLBITSCONSUMED_CRMCORECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_L0ASTURNPOOLBITSCONSUMED_CRMCORECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_L0ATTENTIONBUTTONPRESSED_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0ATTENTIONBUTTONPRESSED_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0ATTENTIONBUTTONPRESSED_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0ATTENTIONBUTTONPRESSED_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0CFGASSPANTREEOWNEDSTATE_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0CFGASSPANTREEOWNEDSTATE_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0CFGASSTATECHANGECMD_CRMCORECLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
	tsetup_L0CFGASSTATECHANGECMD_CRMCORECLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
	tsetup_L0CFGDISABLESCRAMBLE_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0CFGDISABLESCRAMBLE_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0CFGEXTENDEDSYNC_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0CFGEXTENDEDSYNC_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0CFGL0SENTRYENABLE_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0CFGL0SENTRYENABLE_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0CFGL0SENTRYSUP_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0CFGL0SENTRYSUP_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0CFGL0SEXITLAT_CRMCORECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_L0CFGL0SEXITLAT_CRMCORECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_L0CFGLINKDISABLE_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0CFGLINKDISABLE_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0CFGLOOPBACKMASTER_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0CFGLOOPBACKMASTER_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0CFGNEGOTIATEDMAXP_CRMCORECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_L0CFGNEGOTIATEDMAXP_CRMCORECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_L0CFGVCENABLE_CRMCORECLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_L0CFGVCENABLE_CRMCORECLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_L0CFGVCID_CRMCORECLK_negedge_posedge : VitalDelayArrayType(23 downto 0) := (others => 0 ps);
	tsetup_L0CFGVCID_CRMCORECLK_posedge_posedge : VitalDelayArrayType(23 downto 0) := (others => 0 ps);
	tsetup_L0DLLHOLDLINKUP_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0DLLHOLDLINKUP_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0ELECTROMECHANICALINTERLOCKENGAGED_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0ELECTROMECHANICALINTERLOCKENGAGED_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0ELECTROMECHANICALINTERLOCKENGAGED_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0ELECTROMECHANICALINTERLOCKENGAGED_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDASSERTINTALEGACYINT_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDASSERTINTALEGACYINT_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDASSERTINTALEGACYINT_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDASSERTINTALEGACYINT_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDASSERTINTBLEGACYINT_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDASSERTINTBLEGACYINT_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDASSERTINTBLEGACYINT_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDASSERTINTBLEGACYINT_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDASSERTINTCLEGACYINT_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDASSERTINTCLEGACYINT_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDASSERTINTCLEGACYINT_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDASSERTINTCLEGACYINT_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDASSERTINTDLEGACYINT_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDASSERTINTDLEGACYINT_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDASSERTINTDLEGACYINT_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDASSERTINTDLEGACYINT_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDCORRERRIN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDCORRERRIN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDCORRERRIN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDCORRERRIN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDDEASSERTINTALEGACYINT_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDDEASSERTINTALEGACYINT_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDDEASSERTINTALEGACYINT_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDDEASSERTINTALEGACYINT_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDDEASSERTINTBLEGACYINT_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDDEASSERTINTBLEGACYINT_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDDEASSERTINTBLEGACYINT_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDDEASSERTINTBLEGACYINT_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDDEASSERTINTCLEGACYINT_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDDEASSERTINTCLEGACYINT_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDDEASSERTINTCLEGACYINT_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDDEASSERTINTCLEGACYINT_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDDEASSERTINTDLEGACYINT_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDDEASSERTINTDLEGACYINT_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDDEASSERTINTDLEGACYINT_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDDEASSERTINTDLEGACYINT_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDFATALERRIN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDFATALERRIN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDFATALERRIN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDFATALERRIN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDNONFATALERRIN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDNONFATALERRIN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDNONFATALERRIN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0FWDNONFATALERRIN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0LEGACYINTFUNCT0_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0LEGACYINTFUNCT0_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0LEGACYINTFUNCT0_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0LEGACYINTFUNCT0_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0MRLSENSORCLOSEDN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0MRLSENSORCLOSEDN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0MRLSENSORCLOSEDN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0MRLSENSORCLOSEDN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0MSIREQUEST0_CRMCORECLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
	tsetup_L0MSIREQUEST0_CRMCORECLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
	tsetup_L0MSIREQUEST0_CRMUSERCLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
	tsetup_L0MSIREQUEST0_CRMUSERCLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
	tsetup_L0PACKETHEADERFROMUSER_CRMCORECLK_negedge_posedge : VitalDelayArrayType(127 downto 0) := (others => 0 ps);
	tsetup_L0PACKETHEADERFROMUSER_CRMCORECLK_posedge_posedge : VitalDelayArrayType(127 downto 0) := (others => 0 ps);
	tsetup_L0PACKETHEADERFROMUSER_CRMUSERCLK_negedge_posedge : VitalDelayArrayType(127 downto 0) := (others => 0 ps);
	tsetup_L0PACKETHEADERFROMUSER_CRMUSERCLK_posedge_posedge : VitalDelayArrayType(127 downto 0) := (others => 0 ps);
	tsetup_L0PMEREQIN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0PMEREQIN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0PORTNUMBER_CRMCORECLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_L0PORTNUMBER_CRMCORECLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_L0PORTNUMBER_CRMUSERCLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_L0PORTNUMBER_CRMUSERCLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_L0POWERFAULTDETECTED_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0POWERFAULTDETECTED_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0POWERFAULTDETECTED_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0POWERFAULTDETECTED_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0PRESENCEDETECTSLOTEMPTYN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0PRESENCEDETECTSLOTEMPTYN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0PRESENCEDETECTSLOTEMPTYN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0PRESENCEDETECTSLOTEMPTYN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0PWRNEWSTATEREQ_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0PWRNEWSTATEREQ_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0PWRNEXTLINKSTATE_CRMCORECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_L0PWRNEXTLINKSTATE_CRMCORECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_L0REPLAYTIMERADJUSTMENT_CRMCORECLK_negedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
	tsetup_L0REPLAYTIMERADJUSTMENT_CRMCORECLK_posedge_posedge : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
	tsetup_L0ROOTTURNOFFREQ_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0ROOTTURNOFFREQ_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0ROOTTURNOFFREQ_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0ROOTTURNOFFREQ_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0RXTLTLPNONINITIALIZEDVC_CRMCORECLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_L0RXTLTLPNONINITIALIZEDVC_CRMCORECLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_L0SENDUNLOCKMESSAGE_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SENDUNLOCKMESSAGE_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SENDUNLOCKMESSAGE_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SENDUNLOCKMESSAGE_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETCOMPLETERABORTERROR_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETCOMPLETERABORTERROR_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETCOMPLETERABORTERROR_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETCOMPLETERABORTERROR_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETCOMPLETIONTIMEOUTCORRERROR_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETCOMPLETIONTIMEOUTCORRERROR_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETCOMPLETIONTIMEOUTCORRERROR_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETCOMPLETIONTIMEOUTCORRERROR_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETCOMPLETIONTIMEOUTUNCORRERROR_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETCOMPLETIONTIMEOUTUNCORRERROR_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETCOMPLETIONTIMEOUTUNCORRERROR_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETCOMPLETIONTIMEOUTUNCORRERROR_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETDETECTEDCORRERROR_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETDETECTEDCORRERROR_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETDETECTEDCORRERROR_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETDETECTEDCORRERROR_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETDETECTEDFATALERROR_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETDETECTEDFATALERROR_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETDETECTEDFATALERROR_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETDETECTEDFATALERROR_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETDETECTEDNONFATALERROR_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETDETECTEDNONFATALERROR_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETDETECTEDNONFATALERROR_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETDETECTEDNONFATALERROR_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETLINKDETECTEDPARITYERROR_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETLINKDETECTEDPARITYERROR_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETLINKDETECTEDPARITYERROR_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETLINKDETECTEDPARITYERROR_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETLINKMASTERDATAPARITY_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETLINKMASTERDATAPARITY_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETLINKMASTERDATAPARITY_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETLINKMASTERDATAPARITY_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETLINKRECEIVEDMASTERABORT_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETLINKRECEIVEDMASTERABORT_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETLINKRECEIVEDMASTERABORT_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETLINKRECEIVEDMASTERABORT_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETLINKRECEIVEDTARGETABORT_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETLINKRECEIVEDTARGETABORT_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETLINKRECEIVEDTARGETABORT_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETLINKRECEIVEDTARGETABORT_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETLINKSIGNALLEDTARGETABORT_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETLINKSIGNALLEDTARGETABORT_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETLINKSIGNALLEDTARGETABORT_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETLINKSIGNALLEDTARGETABORT_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETLINKSYSTEMERROR_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETLINKSYSTEMERROR_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETLINKSYSTEMERROR_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETLINKSYSTEMERROR_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUNEXPECTEDCOMPLETIONCORRERROR_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUNEXPECTEDCOMPLETIONCORRERROR_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUNEXPECTEDCOMPLETIONCORRERROR_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUNEXPECTEDCOMPLETIONCORRERROR_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUNSUPPORTEDREQUESTOTHERERROR_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUNSUPPORTEDREQUESTOTHERERROR_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUNSUPPORTEDREQUESTOTHERERROR_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUNSUPPORTEDREQUESTOTHERERROR_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUSERDETECTEDPARITYERROR_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUSERDETECTEDPARITYERROR_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUSERDETECTEDPARITYERROR_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUSERDETECTEDPARITYERROR_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUSERMASTERDATAPARITY_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUSERMASTERDATAPARITY_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUSERMASTERDATAPARITY_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUSERMASTERDATAPARITY_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUSERRECEIVEDMASTERABORT_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUSERRECEIVEDMASTERABORT_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUSERRECEIVEDMASTERABORT_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUSERRECEIVEDMASTERABORT_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUSERRECEIVEDTARGETABORT_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUSERRECEIVEDTARGETABORT_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUSERRECEIVEDTARGETABORT_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUSERRECEIVEDTARGETABORT_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUSERSIGNALLEDTARGETABORT_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUSERSIGNALLEDTARGETABORT_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUSERSIGNALLEDTARGETABORT_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUSERSIGNALLEDTARGETABORT_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUSERSYSTEMERROR_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUSERSYSTEMERROR_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUSERSYSTEMERROR_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0SETUSERSYSTEMERROR_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0TLASFCCREDSTARVATION_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0TLASFCCREDSTARVATION_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0TLLINKRETRAIN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0TLLINKRETRAIN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0TRANSACTIONSPENDING_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0TRANSACTIONSPENDING_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0TRANSACTIONSPENDING_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0TRANSACTIONSPENDING_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0TXBEACON_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0TXBEACON_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0TXCFGPMTYPE_CRMCORECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_L0TXCFGPMTYPE_CRMCORECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_L0TXCFGPM_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0TXCFGPM_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0TXTLFCCMPLMCCRED_CRMCORECLK_negedge_posedge : VitalDelayArrayType(159 downto 0) := (others => 0 ps);
	tsetup_L0TXTLFCCMPLMCCRED_CRMCORECLK_posedge_posedge : VitalDelayArrayType(159 downto 0) := (others => 0 ps);
	tsetup_L0TXTLFCCMPLMCUPDATE_CRMCORECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	tsetup_L0TXTLFCCMPLMCUPDATE_CRMCORECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	tsetup_L0TXTLFCNPOSTBYPCRED_CRMCORECLK_negedge_posedge : VitalDelayArrayType(191 downto 0) := (others => 0 ps);
	tsetup_L0TXTLFCNPOSTBYPCRED_CRMCORECLK_posedge_posedge : VitalDelayArrayType(191 downto 0) := (others => 0 ps);
	tsetup_L0TXTLFCNPOSTBYPUPDATE_CRMCORECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	tsetup_L0TXTLFCNPOSTBYPUPDATE_CRMCORECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	tsetup_L0TXTLFCPOSTORDCRED_CRMCORECLK_negedge_posedge : VitalDelayArrayType(159 downto 0) := (others => 0 ps);
	tsetup_L0TXTLFCPOSTORDCRED_CRMCORECLK_posedge_posedge : VitalDelayArrayType(159 downto 0) := (others => 0 ps);
	tsetup_L0TXTLFCPOSTORDUPDATE_CRMCORECLK_negedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	tsetup_L0TXTLFCPOSTORDUPDATE_CRMCORECLK_posedge_posedge : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	tsetup_L0TXTLSBFCDATA_CRMCORECLK_negedge_posedge : VitalDelayArrayType(18 downto 0) := (others => 0 ps);
	tsetup_L0TXTLSBFCDATA_CRMCORECLK_posedge_posedge : VitalDelayArrayType(18 downto 0) := (others => 0 ps);
	tsetup_L0TXTLSBFCUPDATE_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0TXTLSBFCUPDATE_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0TXTLTLPDATA_CRMCORECLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	tsetup_L0TXTLTLPDATA_CRMCORECLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	tsetup_L0TXTLTLPEDB_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0TXTLTLPEDB_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0TXTLTLPENABLE_CRMCORECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_L0TXTLTLPENABLE_CRMCORECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_L0TXTLTLPEND_CRMCORECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_L0TXTLTLPEND_CRMCORECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_L0TXTLTLPLATENCY_CRMCORECLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
	tsetup_L0TXTLTLPLATENCY_CRMCORECLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
	tsetup_L0TXTLTLPREQEND_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0TXTLTLPREQEND_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0TXTLTLPREQ_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0TXTLTLPREQ_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0TXTLTLPWIDTH_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0TXTLTLPWIDTH_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0UPSTREAMRXPORTINL0S_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0UPSTREAMRXPORTINL0S_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0UPSTREAMRXPORTINL0S_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0UPSTREAMRXPORTINL0S_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0VC0PREVIEWEXPAND_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0VC0PREVIEWEXPAND_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0WAKEN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_L0WAKEN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKRXCHFIFO_CRMCORECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_LLKRXCHFIFO_CRMCORECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_LLKRXCHFIFO_CRMUSERCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_LLKRXCHFIFO_CRMUSERCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_LLKRXCHTC_CRMCORECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_LLKRXCHTC_CRMCORECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_LLKRXCHTC_CRMUSERCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_LLKRXCHTC_CRMUSERCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_LLKRXDSTCONTREQN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKRXDSTCONTREQN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKRXDSTCONTREQN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKRXDSTCONTREQN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKRXDSTREQN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKRXDSTREQN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKRXDSTREQN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKRXDSTREQN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTX4DWHEADERN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTX4DWHEADERN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTX4DWHEADERN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTX4DWHEADERN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXCHFIFO_CRMCORECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_LLKTXCHFIFO_CRMCORECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_LLKTXCHFIFO_CRMUSERCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_LLKTXCHFIFO_CRMUSERCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_LLKTXCHTC_CRMCORECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_LLKTXCHTC_CRMCORECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_LLKTXCHTC_CRMUSERCLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_LLKTXCHTC_CRMUSERCLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_LLKTXCOMPLETEN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXCOMPLETEN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXCOMPLETEN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXCOMPLETEN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXCREATEECRCN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXCREATEECRCN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXCREATEECRCN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXCREATEECRCN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXDATA_CRMCORECLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	tsetup_LLKTXDATA_CRMCORECLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	tsetup_LLKTXDATA_CRMUSERCLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	tsetup_LLKTXDATA_CRMUSERCLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	tsetup_LLKTXENABLEN_CRMCORECLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_LLKTXENABLEN_CRMCORECLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_LLKTXENABLEN_CRMUSERCLK_negedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_LLKTXENABLEN_CRMUSERCLK_posedge_posedge : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tsetup_LLKTXEOFN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXEOFN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXEOFN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXEOFN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXEOPN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXEOPN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXEOPN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXEOPN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXSOFN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXSOFN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXSOFN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXSOFN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXSOPN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXSOPN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXSOPN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXSOPN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXSRCDSCN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXSRCDSCN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXSRCDSCN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXSRCDSCN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXSRCRDYN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXSRCRDYN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXSRCRDYN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_LLKTXSRCRDYN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_MAINPOWER_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_MAINPOWER_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_MGMTADDR_CRMCORECLK_negedge_posedge : VitalDelayArrayType(10 downto 0) := (others => 0 ps);
	tsetup_MGMTADDR_CRMCORECLK_posedge_posedge : VitalDelayArrayType(10 downto 0) := (others => 0 ps);
	tsetup_MGMTADDR_CRMUSERCLK_negedge_posedge : VitalDelayArrayType(10 downto 0) := (others => 0 ps);
	tsetup_MGMTADDR_CRMUSERCLK_posedge_posedge : VitalDelayArrayType(10 downto 0) := (others => 0 ps);
	tsetup_MGMTBWREN_CRMCORECLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
	tsetup_MGMTBWREN_CRMCORECLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
	tsetup_MGMTBWREN_CRMUSERCLK_negedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
	tsetup_MGMTBWREN_CRMUSERCLK_posedge_posedge : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
	tsetup_MGMTRDEN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_MGMTRDEN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_MGMTRDEN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_MGMTRDEN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_MGMTSTATSCREDITSEL_CRMCORECLK_negedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
	tsetup_MGMTSTATSCREDITSEL_CRMCORECLK_posedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
	tsetup_MGMTSTATSCREDITSEL_CRMUSERCLK_negedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
	tsetup_MGMTSTATSCREDITSEL_CRMUSERCLK_posedge_posedge : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
	tsetup_MGMTWDATA_CRMCORECLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
	tsetup_MGMTWDATA_CRMCORECLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
	tsetup_MGMTWDATA_CRMUSERCLK_negedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
	tsetup_MGMTWDATA_CRMUSERCLK_posedge_posedge : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
	tsetup_MGMTWREN_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_MGMTWREN_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_MGMTWREN_CRMUSERCLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_MGMTWREN_CRMUSERCLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_MIMDLLBRDATA_CRMCORECLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	tsetup_MIMDLLBRDATA_CRMCORECLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	tsetup_MIMRXBRDATA_CRMCORECLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	tsetup_MIMRXBRDATA_CRMCORECLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	tsetup_MIMRXBRDATA_CRMUSERCLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	tsetup_MIMRXBRDATA_CRMUSERCLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	tsetup_MIMTXBRDATA_CRMCORECLK_negedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	tsetup_MIMTXBRDATA_CRMCORECLK_posedge_posedge : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	tsetup_PIPEPHYSTATUSL0_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPEPHYSTATUSL0_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPEPHYSTATUSL1_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPEPHYSTATUSL1_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPEPHYSTATUSL2_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPEPHYSTATUSL2_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPEPHYSTATUSL3_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPEPHYSTATUSL3_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPEPHYSTATUSL4_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPEPHYSTATUSL4_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPEPHYSTATUSL5_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPEPHYSTATUSL5_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPEPHYSTATUSL6_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPEPHYSTATUSL6_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPEPHYSTATUSL7_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPEPHYSTATUSL7_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXCHANISALIGNEDL0_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXCHANISALIGNEDL0_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXCHANISALIGNEDL1_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXCHANISALIGNEDL1_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXCHANISALIGNEDL2_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXCHANISALIGNEDL2_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXCHANISALIGNEDL3_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXCHANISALIGNEDL3_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXCHANISALIGNEDL4_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXCHANISALIGNEDL4_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXCHANISALIGNEDL5_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXCHANISALIGNEDL5_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXCHANISALIGNEDL6_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXCHANISALIGNEDL6_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXCHANISALIGNEDL7_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXCHANISALIGNEDL7_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXDATAKL0_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXDATAKL0_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXDATAKL1_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXDATAKL1_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXDATAKL2_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXDATAKL2_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXDATAKL3_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXDATAKL3_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXDATAKL4_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXDATAKL4_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXDATAKL5_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXDATAKL5_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXDATAKL6_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXDATAKL6_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXDATAKL7_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXDATAKL7_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXDATAL0_CRMCORECLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_PIPERXDATAL0_CRMCORECLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_PIPERXDATAL1_CRMCORECLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_PIPERXDATAL1_CRMCORECLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_PIPERXDATAL2_CRMCORECLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_PIPERXDATAL2_CRMCORECLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_PIPERXDATAL3_CRMCORECLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_PIPERXDATAL3_CRMCORECLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_PIPERXDATAL4_CRMCORECLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_PIPERXDATAL4_CRMCORECLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_PIPERXDATAL5_CRMCORECLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_PIPERXDATAL5_CRMCORECLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_PIPERXDATAL6_CRMCORECLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_PIPERXDATAL6_CRMCORECLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_PIPERXDATAL7_CRMCORECLK_negedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_PIPERXDATAL7_CRMCORECLK_posedge_posedge : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tsetup_PIPERXELECIDLEL0_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXELECIDLEL0_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXELECIDLEL1_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXELECIDLEL1_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXELECIDLEL2_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXELECIDLEL2_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXELECIDLEL3_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXELECIDLEL3_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXELECIDLEL4_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXELECIDLEL4_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXELECIDLEL5_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXELECIDLEL5_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXELECIDLEL6_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXELECIDLEL6_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXELECIDLEL7_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXELECIDLEL7_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXSTATUSL0_CRMCORECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_PIPERXSTATUSL0_CRMCORECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_PIPERXSTATUSL1_CRMCORECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_PIPERXSTATUSL1_CRMCORECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_PIPERXSTATUSL2_CRMCORECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_PIPERXSTATUSL2_CRMCORECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_PIPERXSTATUSL3_CRMCORECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_PIPERXSTATUSL3_CRMCORECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_PIPERXSTATUSL4_CRMCORECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_PIPERXSTATUSL4_CRMCORECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_PIPERXSTATUSL5_CRMCORECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_PIPERXSTATUSL5_CRMCORECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_PIPERXSTATUSL6_CRMCORECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_PIPERXSTATUSL6_CRMCORECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_PIPERXSTATUSL7_CRMCORECLK_negedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_PIPERXSTATUSL7_CRMCORECLK_posedge_posedge : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tsetup_PIPERXVALIDL0_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXVALIDL0_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXVALIDL1_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXVALIDL1_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXVALIDL2_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXVALIDL2_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXVALIDL3_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXVALIDL3_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXVALIDL4_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXVALIDL4_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXVALIDL5_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXVALIDL5_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXVALIDL6_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXVALIDL6_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXVALIDL7_CRMCORECLK_negedge_posedge : VitalDelayType := 0 ps;
	tsetup_PIPERXVALIDL7_CRMCORECLK_posedge_posedge : VitalDelayType := 0 ps;

	ticd_CRMCORECLK : VitalDelayType := 0 ps;
	ticd_CRMUSERCLK : VitalDelayType := 0 ps;

        tisd_CRMURSTN_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_CRMNVRSTN_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_CRMMGMTRSTN_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_CRMUSERCFGRSTN_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_CRMMACRSTN_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_CRMLINKRSTN_CRMCORECLK : VitalDelayType := 0 ps;
        
       	tisd_AUXPOWER_CRMUSERCLK : VitalDelayType := 0 ps;
        tisd_AUXPOWER_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_CFGNEGOTIATEDLINKWIDTH_CRMCORECLK : VitalDelayArrayType(5 downto 0) := (others => 0 ps);
	tisd_COMPLIANCEAVOID_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_CRMCFGBRIDGEHOTRESET_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_CRMTXHOTRESETN_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_CROSSLINKSEED_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_L0ACKNAKTIMERADJUSTMENT_CRMCORECLK : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
	tisd_L0ALLDOWNPORTSINL1_CRMUSERCLK : VitalDelayType := 0 ps;
        tisd_L0ALLDOWNPORTSINL1_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_L0ALLDOWNRXPORTSINL0S_CRMUSERCLK : VitalDelayType := 0 ps;
        tisd_L0ALLDOWNRXPORTSINL0S_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_L0ASE_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_L0ASPORTCOUNT_CRMCORECLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tisd_L0ASTURNPOOLBITSCONSUMED_CRMCORECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tisd_L0ATTENTIONBUTTONPRESSED_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0ATTENTIONBUTTONPRESSED_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0CFGASSPANTREEOWNEDSTATE_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_L0CFGASSTATECHANGECMD_CRMCORECLK : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
	tisd_L0CFGDISABLESCRAMBLE_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_L0CFGEXTENDEDSYNC_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_L0CFGL0SENTRYENABLE_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_L0CFGL0SENTRYSUP_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_L0CFGL0SEXITLAT_CRMCORECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tisd_L0CFGLINKDISABLE_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_L0CFGLOOPBACKMASTER_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_L0CFGNEGOTIATEDMAXP_CRMCORECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tisd_L0CFGVCENABLE_CRMCORECLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tisd_L0CFGVCID_CRMCORECLK : VitalDelayArrayType(23 downto 0) := (others => 0 ps);
	tisd_L0DLLHOLDLINKUP_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_L0ELECTROMECHANICALINTERLOCKENGAGED_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0ELECTROMECHANICALINTERLOCKENGAGED_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0FWDASSERTINTALEGACYINT_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0FWDASSERTINTALEGACYINT_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0FWDASSERTINTBLEGACYINT_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0FWDASSERTINTBLEGACYINT_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0FWDASSERTINTCLEGACYINT_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0FWDASSERTINTCLEGACYINT_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0FWDASSERTINTDLEGACYINT_CRMCORECLK : VitalDelayType := 0 ps;
       	tisd_L0FWDASSERTINTDLEGACYINT_CRMUSERCLK : VitalDelayType := 0 ps;
        tisd_L0FWDCORRERRIN_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0FWDCORRERRIN_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0FWDDEASSERTINTALEGACYINT_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0FWDDEASSERTINTALEGACYINT_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0FWDDEASSERTINTBLEGACYINT_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0FWDDEASSERTINTBLEGACYINT_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0FWDDEASSERTINTCLEGACYINT_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0FWDDEASSERTINTCLEGACYINT_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0FWDDEASSERTINTDLEGACYINT_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0FWDDEASSERTINTDLEGACYINT_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0FWDFATALERRIN_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0FWDFATALERRIN_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0FWDNONFATALERRIN_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0FWDNONFATALERRIN_CRMUSERCLK : VitalDelayType := 0 ps;
        tisd_L0LEGACYINTFUNCT0_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0LEGACYINTFUNCT0_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0MRLSENSORCLOSEDN_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0MRLSENSORCLOSEDN_CRMUSERCLK : VitalDelayType := 0 ps;
        tisd_L0MSIREQUEST0_CRMCORECLK : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
        tisd_L0MSIREQUEST0_CRMUSERCLK : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
	tisd_L0PACKETHEADERFROMUSER_CRMCORECLK : VitalDelayArrayType(127 downto 0) := (others => 0 ps);
        tisd_L0PACKETHEADERFROMUSER_CRMUSERCLK : VitalDelayArrayType(127 downto 0) := (others => 0 ps);
	tisd_L0PMEREQIN_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_L0PORTNUMBER_CRMCORECLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
       	tisd_L0PORTNUMBER_CRMUSERCLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tisd_L0POWERFAULTDETECTED_CRMCORECLK : VitalDelayType := 0 ps;
       	tisd_L0POWERFAULTDETECTED_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0PRESENCEDETECTSLOTEMPTYN_CRMCORECLK : VitalDelayType := 0 ps;
       	tisd_L0PRESENCEDETECTSLOTEMPTYN_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0PWRNEWSTATEREQ_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_L0PWRNEXTLINKSTATE_CRMCORECLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tisd_L0REPLAYTIMERADJUSTMENT_CRMCORECLK : VitalDelayArrayType(11 downto 0) := (others => 0 ps);
	tisd_L0ROOTTURNOFFREQ_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0ROOTTURNOFFREQ_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0RXTLTLPNONINITIALIZEDVC_CRMCORECLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tisd_L0SENDUNLOCKMESSAGE_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0SENDUNLOCKMESSAGE_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0SETCOMPLETERABORTERROR_CRMCORECLK : VitalDelayType := 0 ps;
       	tisd_L0SETCOMPLETERABORTERROR_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0SETCOMPLETIONTIMEOUTCORRERROR_CRMCORECLK : VitalDelayType := 0 ps;
       	tisd_L0SETCOMPLETIONTIMEOUTCORRERROR_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0SETCOMPLETIONTIMEOUTUNCORRERROR_CRMCORECLK : VitalDelayType := 0 ps;
       	tisd_L0SETCOMPLETIONTIMEOUTUNCORRERROR_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0SETDETECTEDCORRERROR_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0SETDETECTEDCORRERROR_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0SETDETECTEDFATALERROR_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0SETDETECTEDFATALERROR_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0SETDETECTEDNONFATALERROR_CRMCORECLK : VitalDelayType := 0 ps;
       	tisd_L0SETDETECTEDNONFATALERROR_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0SETLINKDETECTEDPARITYERROR_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0SETLINKDETECTEDPARITYERROR_CRMUSERCLK : VitalDelayType := 0 ps;
        tisd_L0SETLINKMASTERDATAPARITY_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0SETLINKMASTERDATAPARITY_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0SETLINKRECEIVEDMASTERABORT_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0SETLINKRECEIVEDMASTERABORT_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0SETLINKRECEIVEDTARGETABORT_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0SETLINKRECEIVEDTARGETABORT_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0SETLINKSIGNALLEDTARGETABORT_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0SETLINKSIGNALLEDTARGETABORT_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0SETLINKSYSTEMERROR_CRMCORECLK : VitalDelayType := 0 ps;
       	tisd_L0SETLINKSYSTEMERROR_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0SETUNEXPECTEDCOMPLETIONCORRERROR_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0SETUNEXPECTEDCOMPLETIONCORRERROR_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0SETUNSUPPORTEDREQUESTOTHERERROR_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0SETUNSUPPORTEDREQUESTOTHERERROR_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0SETUSERDETECTEDPARITYERROR_CRMCORECLK : VitalDelayType := 0 ps;
       	tisd_L0SETUSERDETECTEDPARITYERROR_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0SETUSERMASTERDATAPARITY_CRMCORECLK : VitalDelayType := 0 ps;
       	tisd_L0SETUSERMASTERDATAPARITY_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0SETUSERRECEIVEDMASTERABORT_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0SETUSERRECEIVEDMASTERABORT_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0SETUSERRECEIVEDTARGETABORT_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0SETUSERRECEIVEDTARGETABORT_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0SETUSERSIGNALLEDTARGETABORT_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0SETUSERSIGNALLEDTARGETABORT_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0SETUSERSYSTEMERROR_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_L0SETUSERSYSTEMERROR_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0TLASFCCREDSTARVATION_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_L0TLLINKRETRAIN_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_L0TRANSACTIONSPENDING_CRMCORECLK : VitalDelayType := 0 ps;
   tisd_L0TRANSACTIONSPENDING_CRMUSERCLK : VitalDelayType := 0 ps;
	tisd_L0TXBEACON_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_L0TXCFGPM_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_L0TXCFGPMTYPE_CRMCORECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tisd_L0TXTLFCCMPLMCCRED_CRMCORECLK : VitalDelayArrayType(159 downto 0) := (others => 0 ps);
	tisd_L0TXTLFCCMPLMCUPDATE_CRMCORECLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	tisd_L0TXTLFCNPOSTBYPCRED_CRMCORECLK : VitalDelayArrayType(191 downto 0) := (others => 0 ps);
	tisd_L0TXTLFCNPOSTBYPUPDATE_CRMCORECLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	tisd_L0TXTLFCPOSTORDCRED_CRMCORECLK : VitalDelayArrayType(159 downto 0) := (others => 0 ps);
	tisd_L0TXTLFCPOSTORDUPDATE_CRMCORECLK : VitalDelayArrayType(15 downto 0) := (others => 0 ps);
	tisd_L0TXTLSBFCDATA_CRMCORECLK : VitalDelayArrayType(18 downto 0) := (others => 0 ps);
	tisd_L0TXTLSBFCUPDATE_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_L0TXTLTLPDATA_CRMCORECLK : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	tisd_L0TXTLTLPEDB_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_L0TXTLTLPENABLE_CRMCORECLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tisd_L0TXTLTLPEND_CRMCORECLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tisd_L0TXTLTLPLATENCY_CRMCORECLK : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
	tisd_L0TXTLTLPREQ_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_L0TXTLTLPREQEND_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_L0TXTLTLPWIDTH_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_L0UPSTREAMRXPORTINL0S_CRMUSERCLK : VitalDelayType := 0 ps;
   tisd_L0UPSTREAMRXPORTINL0S_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_L0VC0PREVIEWEXPAND_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_L0WAKEN_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_LLKRXCHFIFO_CRMUSERCLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
       	tisd_LLKRXCHFIFO_CRMCORECLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tisd_LLKRXCHTC_CRMUSERCLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
        tisd_LLKRXCHTC_CRMCORECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tisd_LLKRXDSTCONTREQN_CRMUSERCLK : VitalDelayType := 0 ps;
        tisd_LLKRXDSTCONTREQN_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_LLKRXDSTREQN_CRMUSERCLK : VitalDelayType := 0 ps;
        tisd_LLKRXDSTREQN_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_LLKTX4DWHEADERN_CRMUSERCLK : VitalDelayType := 0 ps;
        tisd_LLKTX4DWHEADERN_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_LLKTXCHFIFO_CRMUSERCLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
        tisd_LLKTXCHFIFO_CRMCORECLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tisd_LLKTXCHTC_CRMUSERCLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
        tisd_LLKTXCHTC_CRMCORECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tisd_LLKTXCOMPLETEN_CRMUSERCLK : VitalDelayType := 0 ps;
       	tisd_LLKTXCOMPLETEN_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_LLKTXCREATEECRCN_CRMUSERCLK : VitalDelayType := 0 ps;
        tisd_LLKTXCREATEECRCN_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_LLKTXDATA_CRMUSERCLK : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
       	tisd_LLKTXDATA_CRMCORECLK : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	tisd_LLKTXENABLEN_CRMUSERCLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
        tisd_LLKTXENABLEN_CRMCORECLK : VitalDelayArrayType(1 downto 0) := (others => 0 ps);
	tisd_LLKTXEOFN_CRMUSERCLK : VitalDelayType := 0 ps;
        tisd_LLKTXEOFN_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_LLKTXEOPN_CRMUSERCLK : VitalDelayType := 0 ps;
        tisd_LLKTXEOPN_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_LLKTXSOFN_CRMUSERCLK : VitalDelayType := 0 ps;
        tisd_LLKTXSOFN_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_LLKTXSOPN_CRMUSERCLK : VitalDelayType := 0 ps;
        tisd_LLKTXSOPN_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_LLKTXSRCDSCN_CRMUSERCLK : VitalDelayType := 0 ps;
        tisd_LLKTXSRCDSCN_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_LLKTXSRCRDYN_CRMUSERCLK : VitalDelayType := 0 ps;
        tisd_LLKTXSRCRDYN_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_MAINPOWER_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_MGMTADDR_CRMUSERCLK : VitalDelayArrayType(10 downto 0) := (others => 0 ps);
       	tisd_MGMTADDR_CRMCORECLK : VitalDelayArrayType(10 downto 0) := (others => 0 ps);
	tisd_MGMTBWREN_CRMUSERCLK : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
        tisd_MGMTBWREN_CRMCORECLK : VitalDelayArrayType(3 downto 0) := (others => 0 ps);
	tisd_MGMTRDEN_CRMUSERCLK : VitalDelayType := 0 ps;
        tisd_MGMTRDEN_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_MGMTSTATSCREDITSEL_CRMUSERCLK : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
        tisd_MGMTSTATSCREDITSEL_CRMCORECLK : VitalDelayArrayType(6 downto 0) := (others => 0 ps);
	tisd_MGMTWDATA_CRMUSERCLK : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
       	tisd_MGMTWDATA_CRMCORECLK : VitalDelayArrayType(31 downto 0) := (others => 0 ps);
	tisd_MGMTWREN_CRMUSERCLK : VitalDelayType := 0 ps;
       	tisd_MGMTWREN_CRMCORECLK : VitalDelayType := 0 ps;
        tisd_MIMDLLBRDATA_CRMCORECLK : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
       	tisd_MIMRXBRDATA_CRMCORECLK : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
        tisd_MIMRXBRDATA_CRMUSERCLK : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	tisd_MIMTXBRDATA_CRMCORECLK : VitalDelayArrayType(63 downto 0) := (others => 0 ps);
	tisd_PIPEPHYSTATUSL0_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPEPHYSTATUSL1_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPEPHYSTATUSL2_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPEPHYSTATUSL3_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPEPHYSTATUSL4_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPEPHYSTATUSL5_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPEPHYSTATUSL6_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPEPHYSTATUSL7_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXCHANISALIGNEDL0_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXCHANISALIGNEDL1_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXCHANISALIGNEDL2_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXCHANISALIGNEDL3_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXCHANISALIGNEDL4_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXCHANISALIGNEDL5_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXCHANISALIGNEDL6_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXCHANISALIGNEDL7_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXDATAKL0_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXDATAKL1_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXDATAKL2_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXDATAKL3_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXDATAKL4_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXDATAKL5_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXDATAKL6_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXDATAKL7_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXDATAL0_CRMCORECLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tisd_PIPERXDATAL1_CRMCORECLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tisd_PIPERXDATAL2_CRMCORECLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tisd_PIPERXDATAL3_CRMCORECLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tisd_PIPERXDATAL4_CRMCORECLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tisd_PIPERXDATAL5_CRMCORECLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tisd_PIPERXDATAL6_CRMCORECLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tisd_PIPERXDATAL7_CRMCORECLK : VitalDelayArrayType(7 downto 0) := (others => 0 ps);
	tisd_PIPERXELECIDLEL0_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXELECIDLEL1_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXELECIDLEL2_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXELECIDLEL3_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXELECIDLEL4_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXELECIDLEL5_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXELECIDLEL6_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXELECIDLEL7_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXSTATUSL0_CRMCORECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tisd_PIPERXSTATUSL1_CRMCORECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tisd_PIPERXSTATUSL2_CRMCORECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tisd_PIPERXSTATUSL3_CRMCORECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tisd_PIPERXSTATUSL4_CRMCORECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tisd_PIPERXSTATUSL5_CRMCORECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tisd_PIPERXSTATUSL6_CRMCORECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tisd_PIPERXSTATUSL7_CRMCORECLK : VitalDelayArrayType(2 downto 0) := (others => 0 ps);
	tisd_PIPERXVALIDL0_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXVALIDL1_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXVALIDL2_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXVALIDL3_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXVALIDL4_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXVALIDL5_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXVALIDL6_CRMCORECLK : VitalDelayType := 0 ps;
	tisd_PIPERXVALIDL7_CRMCORECLK : VitalDelayType := 0 ps

  );
        port (
		BUSMASTERENABLE : out std_ulogic;
		CRMDOHOTRESETN : out std_ulogic;
		CRMPWRSOFTRESETN : out std_ulogic;
		CRMRXHOTRESETN : out std_ulogic;
		DLLTXPMDLLPOUTSTANDING : out std_ulogic;
		INTERRUPTDISABLE : out std_ulogic;
		IOSPACEENABLE : out std_ulogic;
		L0ASAUTONOMOUSINITCOMPLETED : out std_ulogic;
		L0ATTENTIONINDICATORCONTROL : out std_logic_vector(1 downto 0);
		L0CFGLOOPBACKACK : out std_ulogic;
		L0COMPLETERID : out std_logic_vector(12 downto 0);
		L0CORRERRMSGRCVD : out std_ulogic;
		L0DLLASRXSTATE : out std_logic_vector(1 downto 0);
		L0DLLASTXSTATE : out std_ulogic;
		L0DLLERRORVECTOR : out std_logic_vector(6 downto 0);
		L0DLLRXACKOUTSTANDING : out std_ulogic;
		L0DLLTXNONFCOUTSTANDING : out std_ulogic;
		L0DLLTXOUTSTANDING : out std_ulogic;
		L0DLLVCSTATUS : out std_logic_vector(7 downto 0);
		L0DLUPDOWN : out std_logic_vector(7 downto 0);
		L0ERRMSGREQID : out std_logic_vector(15 downto 0);
		L0FATALERRMSGRCVD : out std_ulogic;
		L0FIRSTCFGWRITEOCCURRED : out std_ulogic;
		L0FWDCORRERROUT : out std_ulogic;
		L0FWDFATALERROUT : out std_ulogic;
		L0FWDNONFATALERROUT : out std_ulogic;
		L0LTSSMSTATE : out std_logic_vector(3 downto 0);
		L0MACENTEREDL0 : out std_ulogic;
		L0MACLINKTRAINING : out std_ulogic;
		L0MACLINKUP : out std_ulogic;
		L0MACNEGOTIATEDLINKWIDTH : out std_logic_vector(3 downto 0);
		L0MACNEWSTATEACK : out std_ulogic;
		L0MACRXL0SSTATE : out std_ulogic;
		L0MACUPSTREAMDOWNSTREAM : out std_ulogic;
		L0MCFOUND : out std_logic_vector(2 downto 0);
		L0MSIENABLE0 : out std_ulogic;
		L0MULTIMSGEN0 : out std_logic_vector(2 downto 0);
		L0NONFATALERRMSGRCVD : out std_ulogic;
		L0PMEACK : out std_ulogic;
		L0PMEEN : out std_ulogic;
		L0PMEREQOUT : out std_ulogic;
		L0POWERCONTROLLERCONTROL : out std_ulogic;
		L0POWERINDICATORCONTROL : out std_logic_vector(1 downto 0);
		L0PWRINHIBITTRANSFERS : out std_ulogic;
		L0PWRL1STATE : out std_ulogic;
		L0PWRL23READYDEVICE : out std_ulogic;
		L0PWRL23READYSTATE : out std_ulogic;
		L0PWRSTATE0 : out std_logic_vector(1 downto 0);
		L0PWRTURNOFFREQ : out std_ulogic;
		L0PWRTXL0SSTATE : out std_ulogic;
		L0RECEIVEDASSERTINTALEGACYINT : out std_ulogic;
		L0RECEIVEDASSERTINTBLEGACYINT : out std_ulogic;
		L0RECEIVEDASSERTINTCLEGACYINT : out std_ulogic;
		L0RECEIVEDASSERTINTDLEGACYINT : out std_ulogic;
		L0RECEIVEDDEASSERTINTALEGACYINT : out std_ulogic;
		L0RECEIVEDDEASSERTINTBLEGACYINT : out std_ulogic;
		L0RECEIVEDDEASSERTINTCLEGACYINT : out std_ulogic;
		L0RECEIVEDDEASSERTINTDLEGACYINT : out std_ulogic;
		L0RXBEACON : out std_ulogic;
		L0RXDLLFCCMPLMCCRED : out std_logic_vector(23 downto 0);
		L0RXDLLFCCMPLMCUPDATE : out std_logic_vector(7 downto 0);
		L0RXDLLFCNPOSTBYPCRED : out std_logic_vector(19 downto 0);
		L0RXDLLFCNPOSTBYPUPDATE : out std_logic_vector(7 downto 0);
		L0RXDLLFCPOSTORDCRED : out std_logic_vector(23 downto 0);
		L0RXDLLFCPOSTORDUPDATE : out std_logic_vector(7 downto 0);
		L0RXDLLPM : out std_ulogic;
		L0RXDLLPMTYPE : out std_logic_vector(2 downto 0);
		L0RXDLLSBFCDATA : out std_logic_vector(18 downto 0);
		L0RXDLLSBFCUPDATE : out std_ulogic;
		L0RXDLLTLPECRCOK : out std_ulogic;
		L0RXDLLTLPEND : out std_logic_vector(1 downto 0);
		L0RXMACLINKERROR : out std_logic_vector(1 downto 0);
		L0STATSCFGOTHERRECEIVED : out std_ulogic;
		L0STATSCFGOTHERTRANSMITTED : out std_ulogic;
		L0STATSCFGRECEIVED : out std_ulogic;
		L0STATSCFGTRANSMITTED : out std_ulogic;
		L0STATSDLLPRECEIVED : out std_ulogic;
		L0STATSDLLPTRANSMITTED : out std_ulogic;
		L0STATSOSRECEIVED : out std_ulogic;
		L0STATSOSTRANSMITTED : out std_ulogic;
		L0STATSTLPRECEIVED : out std_ulogic;
		L0STATSTLPTRANSMITTED : out std_ulogic;
		L0TOGGLEELECTROMECHANICALINTERLOCK : out std_ulogic;
		L0TRANSFORMEDVC : out std_logic_vector(2 downto 0);
		L0TXDLLFCCMPLMCUPDATED : out std_logic_vector(7 downto 0);
		L0TXDLLFCNPOSTBYPUPDATED : out std_logic_vector(7 downto 0);
		L0TXDLLFCPOSTORDUPDATED : out std_logic_vector(7 downto 0);
		L0TXDLLPMUPDATED : out std_ulogic;
		L0TXDLLSBFCUPDATED : out std_ulogic;
		L0UCBYPFOUND : out std_logic_vector(3 downto 0);
		L0UCORDFOUND : out std_logic_vector(3 downto 0);
		L0UNLOCKRECEIVED : out std_ulogic;
		LLKRX4DWHEADERN : out std_ulogic;
		LLKRXCHCOMPLETIONAVAILABLEN : out std_logic_vector(7 downto 0);
		LLKRXCHCOMPLETIONPARTIALN : out std_logic_vector(7 downto 0);
		LLKRXCHCONFIGAVAILABLEN : out std_ulogic;
		LLKRXCHCONFIGPARTIALN : out std_ulogic;
		LLKRXCHNONPOSTEDAVAILABLEN : out std_logic_vector(7 downto 0);
		LLKRXCHNONPOSTEDPARTIALN : out std_logic_vector(7 downto 0);
		LLKRXCHPOSTEDAVAILABLEN : out std_logic_vector(7 downto 0);
		LLKRXCHPOSTEDPARTIALN : out std_logic_vector(7 downto 0);
		LLKRXDATA : out std_logic_vector(63 downto 0);
		LLKRXECRCBADN : out std_ulogic;
		LLKRXEOFN : out std_ulogic;
		LLKRXEOPN : out std_ulogic;
		LLKRXPREFERREDTYPE : out std_logic_vector(15 downto 0);
		LLKRXSOFN : out std_ulogic;
		LLKRXSOPN : out std_ulogic;
		LLKRXSRCDSCN : out std_ulogic;
		LLKRXSRCLASTREQN : out std_ulogic;
		LLKRXSRCRDYN : out std_ulogic;
		LLKRXVALIDN : out std_logic_vector(1 downto 0);
		LLKTCSTATUS : out std_logic_vector(7 downto 0);
		LLKTXCHANSPACE : out std_logic_vector(9 downto 0);
		LLKTXCHCOMPLETIONREADYN : out std_logic_vector(7 downto 0);
		LLKTXCHNONPOSTEDREADYN : out std_logic_vector(7 downto 0);
		LLKTXCHPOSTEDREADYN : out std_logic_vector(7 downto 0);
		LLKTXCONFIGREADYN : out std_ulogic;
		LLKTXDSTRDYN : out std_ulogic;
		MAXPAYLOADSIZE : out std_logic_vector(2 downto 0);
		MAXREADREQUESTSIZE : out std_logic_vector(2 downto 0);
		MEMSPACEENABLE : out std_ulogic;
		MGMTPSO : out std_logic_vector(16 downto 0);
		MGMTRDATA : out std_logic_vector(31 downto 0);
		MGMTSTATSCREDIT : out std_logic_vector(11 downto 0);
		MIMDLLBRADD : out std_logic_vector(11 downto 0);
		MIMDLLBREN : out std_ulogic;
		MIMDLLBWADD : out std_logic_vector(11 downto 0);
		MIMDLLBWDATA : out std_logic_vector(63 downto 0);
		MIMDLLBWEN : out std_ulogic;
		MIMRXBRADD : out std_logic_vector(12 downto 0);
		MIMRXBREN : out std_ulogic;
		MIMRXBWADD : out std_logic_vector(12 downto 0);
		MIMRXBWDATA : out std_logic_vector(63 downto 0);
		MIMRXBWEN : out std_ulogic;
		MIMTXBRADD : out std_logic_vector(12 downto 0);
		MIMTXBREN : out std_ulogic;
		MIMTXBWADD : out std_logic_vector(12 downto 0);
		MIMTXBWDATA : out std_logic_vector(63 downto 0);
		MIMTXBWEN : out std_ulogic;
		PARITYERRORRESPONSE : out std_ulogic;
		PIPEDESKEWLANESL0 : out std_ulogic;
		PIPEDESKEWLANESL1 : out std_ulogic;
		PIPEDESKEWLANESL2 : out std_ulogic;
		PIPEDESKEWLANESL3 : out std_ulogic;
		PIPEDESKEWLANESL4 : out std_ulogic;
		PIPEDESKEWLANESL5 : out std_ulogic;
		PIPEDESKEWLANESL6 : out std_ulogic;
		PIPEDESKEWLANESL7 : out std_ulogic;
		PIPEPOWERDOWNL0 : out std_logic_vector(1 downto 0);
		PIPEPOWERDOWNL1 : out std_logic_vector(1 downto 0);
		PIPEPOWERDOWNL2 : out std_logic_vector(1 downto 0);
		PIPEPOWERDOWNL3 : out std_logic_vector(1 downto 0);
		PIPEPOWERDOWNL4 : out std_logic_vector(1 downto 0);
		PIPEPOWERDOWNL5 : out std_logic_vector(1 downto 0);
		PIPEPOWERDOWNL6 : out std_logic_vector(1 downto 0);
		PIPEPOWERDOWNL7 : out std_logic_vector(1 downto 0);
		PIPERESETL0 : out std_ulogic;
		PIPERESETL1 : out std_ulogic;
		PIPERESETL2 : out std_ulogic;
		PIPERESETL3 : out std_ulogic;
		PIPERESETL4 : out std_ulogic;
		PIPERESETL5 : out std_ulogic;
		PIPERESETL6 : out std_ulogic;
		PIPERESETL7 : out std_ulogic;
		PIPERXPOLARITYL0 : out std_ulogic;
		PIPERXPOLARITYL1 : out std_ulogic;
		PIPERXPOLARITYL2 : out std_ulogic;
		PIPERXPOLARITYL3 : out std_ulogic;
		PIPERXPOLARITYL4 : out std_ulogic;
		PIPERXPOLARITYL5 : out std_ulogic;
		PIPERXPOLARITYL6 : out std_ulogic;
		PIPERXPOLARITYL7 : out std_ulogic;
		PIPETXCOMPLIANCEL0 : out std_ulogic;
		PIPETXCOMPLIANCEL1 : out std_ulogic;
		PIPETXCOMPLIANCEL2 : out std_ulogic;
		PIPETXCOMPLIANCEL3 : out std_ulogic;
		PIPETXCOMPLIANCEL4 : out std_ulogic;
		PIPETXCOMPLIANCEL5 : out std_ulogic;
		PIPETXCOMPLIANCEL6 : out std_ulogic;
		PIPETXCOMPLIANCEL7 : out std_ulogic;
		PIPETXDATAKL0 : out std_ulogic;
		PIPETXDATAKL1 : out std_ulogic;
		PIPETXDATAKL2 : out std_ulogic;
		PIPETXDATAKL3 : out std_ulogic;
		PIPETXDATAKL4 : out std_ulogic;
		PIPETXDATAKL5 : out std_ulogic;
		PIPETXDATAKL6 : out std_ulogic;
		PIPETXDATAKL7 : out std_ulogic;
		PIPETXDATAL0 : out std_logic_vector(7 downto 0);
		PIPETXDATAL1 : out std_logic_vector(7 downto 0);
		PIPETXDATAL2 : out std_logic_vector(7 downto 0);
		PIPETXDATAL3 : out std_logic_vector(7 downto 0);
		PIPETXDATAL4 : out std_logic_vector(7 downto 0);
		PIPETXDATAL5 : out std_logic_vector(7 downto 0);
		PIPETXDATAL6 : out std_logic_vector(7 downto 0);
		PIPETXDATAL7 : out std_logic_vector(7 downto 0);
		PIPETXDETECTRXLOOPBACKL0 : out std_ulogic;
		PIPETXDETECTRXLOOPBACKL1 : out std_ulogic;
		PIPETXDETECTRXLOOPBACKL2 : out std_ulogic;
		PIPETXDETECTRXLOOPBACKL3 : out std_ulogic;
		PIPETXDETECTRXLOOPBACKL4 : out std_ulogic;
		PIPETXDETECTRXLOOPBACKL5 : out std_ulogic;
		PIPETXDETECTRXLOOPBACKL6 : out std_ulogic;
		PIPETXDETECTRXLOOPBACKL7 : out std_ulogic;
		PIPETXELECIDLEL0 : out std_ulogic;
		PIPETXELECIDLEL1 : out std_ulogic;
		PIPETXELECIDLEL2 : out std_ulogic;
		PIPETXELECIDLEL3 : out std_ulogic;
		PIPETXELECIDLEL4 : out std_ulogic;
		PIPETXELECIDLEL5 : out std_ulogic;
		PIPETXELECIDLEL6 : out std_ulogic;
		PIPETXELECIDLEL7 : out std_ulogic;
		SERRENABLE : out std_ulogic;
		URREPORTINGENABLE : out std_ulogic;

		AUXPOWER : in std_ulogic;
		CFGNEGOTIATEDLINKWIDTH : in std_logic_vector(5 downto 0);
		COMPLIANCEAVOID : in std_ulogic;
		CRMCFGBRIDGEHOTRESET : in std_ulogic;
		CRMCORECLK : in std_ulogic;
		CRMCORECLKDLO : in std_ulogic;
		CRMCORECLKRXO : in std_ulogic;
		CRMCORECLKTXO : in std_ulogic;
		CRMLINKRSTN : in std_ulogic;
		CRMMACRSTN : in std_ulogic;
		CRMMGMTRSTN : in std_ulogic;
		CRMNVRSTN : in std_ulogic;
		CRMTXHOTRESETN : in std_ulogic;
		CRMURSTN : in std_ulogic;
		CRMUSERCFGRSTN : in std_ulogic;
		CRMUSERCLK : in std_ulogic;
		CRMUSERCLKRXO : in std_ulogic;
		CRMUSERCLKTXO : in std_ulogic;
		CROSSLINKSEED : in std_ulogic;
		L0ACKNAKTIMERADJUSTMENT : in std_logic_vector(11 downto 0);
		L0ALLDOWNPORTSINL1 : in std_ulogic;
		L0ALLDOWNRXPORTSINL0S : in std_ulogic;
		L0ASE : in std_ulogic;
		L0ASPORTCOUNT : in std_logic_vector(7 downto 0);
		L0ASTURNPOOLBITSCONSUMED : in std_logic_vector(2 downto 0);
		L0ATTENTIONBUTTONPRESSED : in std_ulogic;
		L0CFGASSPANTREEOWNEDSTATE : in std_ulogic;
		L0CFGASSTATECHANGECMD : in std_logic_vector(3 downto 0);
		L0CFGDISABLESCRAMBLE : in std_ulogic;
		L0CFGEXTENDEDSYNC : in std_ulogic;
		L0CFGL0SENTRYENABLE : in std_ulogic;
		L0CFGL0SENTRYSUP : in std_ulogic;
		L0CFGL0SEXITLAT : in std_logic_vector(2 downto 0);
		L0CFGLINKDISABLE : in std_ulogic;
		L0CFGLOOPBACKMASTER : in std_ulogic;
		L0CFGNEGOTIATEDMAXP : in std_logic_vector(2 downto 0);
		L0CFGVCENABLE : in std_logic_vector(7 downto 0);
		L0CFGVCID : in std_logic_vector(23 downto 0);
		L0DLLHOLDLINKUP : in std_ulogic;
		L0ELECTROMECHANICALINTERLOCKENGAGED : in std_ulogic;
		L0FWDASSERTINTALEGACYINT : in std_ulogic;
		L0FWDASSERTINTBLEGACYINT : in std_ulogic;
		L0FWDASSERTINTCLEGACYINT : in std_ulogic;
		L0FWDASSERTINTDLEGACYINT : in std_ulogic;
		L0FWDCORRERRIN : in std_ulogic;
		L0FWDDEASSERTINTALEGACYINT : in std_ulogic;
		L0FWDDEASSERTINTBLEGACYINT : in std_ulogic;
		L0FWDDEASSERTINTCLEGACYINT : in std_ulogic;
		L0FWDDEASSERTINTDLEGACYINT : in std_ulogic;
		L0FWDFATALERRIN : in std_ulogic;
		L0FWDNONFATALERRIN : in std_ulogic;
		L0LEGACYINTFUNCT0 : in std_ulogic;
		L0MRLSENSORCLOSEDN : in std_ulogic;
		L0MSIREQUEST0 : in std_logic_vector(3 downto 0);
		L0PACKETHEADERFROMUSER : in std_logic_vector(127 downto 0);
		L0PMEREQIN : in std_ulogic;
		L0PORTNUMBER : in std_logic_vector(7 downto 0);
		L0POWERFAULTDETECTED : in std_ulogic;
		L0PRESENCEDETECTSLOTEMPTYN : in std_ulogic;
		L0PWRNEWSTATEREQ : in std_ulogic;
		L0PWRNEXTLINKSTATE : in std_logic_vector(1 downto 0);
		L0REPLAYTIMERADJUSTMENT : in std_logic_vector(11 downto 0);
		L0ROOTTURNOFFREQ : in std_ulogic;
		L0RXTLTLPNONINITIALIZEDVC : in std_logic_vector(7 downto 0);
		L0SENDUNLOCKMESSAGE : in std_ulogic;
		L0SETCOMPLETERABORTERROR : in std_ulogic;
		L0SETCOMPLETIONTIMEOUTCORRERROR : in std_ulogic;
		L0SETCOMPLETIONTIMEOUTUNCORRERROR : in std_ulogic;
		L0SETDETECTEDCORRERROR : in std_ulogic;
		L0SETDETECTEDFATALERROR : in std_ulogic;
		L0SETDETECTEDNONFATALERROR : in std_ulogic;
		L0SETLINKDETECTEDPARITYERROR : in std_ulogic;
		L0SETLINKMASTERDATAPARITY : in std_ulogic;
		L0SETLINKRECEIVEDMASTERABORT : in std_ulogic;
		L0SETLINKRECEIVEDTARGETABORT : in std_ulogic;
		L0SETLINKSIGNALLEDTARGETABORT : in std_ulogic;
		L0SETLINKSYSTEMERROR : in std_ulogic;
		L0SETUNEXPECTEDCOMPLETIONCORRERROR : in std_ulogic;
		L0SETUNEXPECTEDCOMPLETIONUNCORRERROR : in std_ulogic;
		L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR : in std_ulogic;
		L0SETUNSUPPORTEDREQUESTOTHERERROR : in std_ulogic;
		L0SETUSERDETECTEDPARITYERROR : in std_ulogic;
		L0SETUSERMASTERDATAPARITY : in std_ulogic;
		L0SETUSERRECEIVEDMASTERABORT : in std_ulogic;
		L0SETUSERRECEIVEDTARGETABORT : in std_ulogic;
		L0SETUSERSIGNALLEDTARGETABORT : in std_ulogic;
		L0SETUSERSYSTEMERROR : in std_ulogic;
		L0TLASFCCREDSTARVATION : in std_ulogic;
		L0TLLINKRETRAIN : in std_ulogic;
		L0TRANSACTIONSPENDING : in std_ulogic;
		L0TXBEACON : in std_ulogic;
		L0TXCFGPM : in std_ulogic;
		L0TXCFGPMTYPE : in std_logic_vector(2 downto 0);
		L0TXTLFCCMPLMCCRED : in std_logic_vector(159 downto 0);
		L0TXTLFCCMPLMCUPDATE : in std_logic_vector(15 downto 0);
		L0TXTLFCNPOSTBYPCRED : in std_logic_vector(191 downto 0);
		L0TXTLFCNPOSTBYPUPDATE : in std_logic_vector(15 downto 0);
		L0TXTLFCPOSTORDCRED : in std_logic_vector(159 downto 0);
		L0TXTLFCPOSTORDUPDATE : in std_logic_vector(15 downto 0);
		L0TXTLSBFCDATA : in std_logic_vector(18 downto 0);
		L0TXTLSBFCUPDATE : in std_ulogic;
		L0TXTLTLPDATA : in std_logic_vector(63 downto 0);
		L0TXTLTLPEDB : in std_ulogic;
		L0TXTLTLPENABLE : in std_logic_vector(1 downto 0);
		L0TXTLTLPEND : in std_logic_vector(1 downto 0);
		L0TXTLTLPLATENCY : in std_logic_vector(3 downto 0);
		L0TXTLTLPREQ : in std_ulogic;
		L0TXTLTLPREQEND : in std_ulogic;
		L0TXTLTLPWIDTH : in std_ulogic;
		L0UPSTREAMRXPORTINL0S : in std_ulogic;
		L0VC0PREVIEWEXPAND : in std_ulogic;
		L0WAKEN : in std_ulogic;
		LLKRXCHFIFO : in std_logic_vector(1 downto 0);
		LLKRXCHTC : in std_logic_vector(2 downto 0);
		LLKRXDSTCONTREQN : in std_ulogic;
		LLKRXDSTREQN : in std_ulogic;
		LLKTX4DWHEADERN : in std_ulogic;
		LLKTXCHFIFO : in std_logic_vector(1 downto 0);
		LLKTXCHTC : in std_logic_vector(2 downto 0);
		LLKTXCOMPLETEN : in std_ulogic;
		LLKTXCREATEECRCN : in std_ulogic;
		LLKTXDATA : in std_logic_vector(63 downto 0);
		LLKTXENABLEN : in std_logic_vector(1 downto 0);
		LLKTXEOFN : in std_ulogic;
		LLKTXEOPN : in std_ulogic;
		LLKTXSOFN : in std_ulogic;
		LLKTXSOPN : in std_ulogic;
		LLKTXSRCDSCN : in std_ulogic;
		LLKTXSRCRDYN : in std_ulogic;
		MAINPOWER : in std_ulogic;
		MGMTADDR : in std_logic_vector(10 downto 0);
		MGMTBWREN : in std_logic_vector(3 downto 0);
		MGMTRDEN : in std_ulogic;
		MGMTSTATSCREDITSEL : in std_logic_vector(6 downto 0);
		MGMTWDATA : in std_logic_vector(31 downto 0);
		MGMTWREN : in std_ulogic;
		MIMDLLBRDATA : in std_logic_vector(63 downto 0);
		MIMRXBRDATA : in std_logic_vector(63 downto 0);
		MIMTXBRDATA : in std_logic_vector(63 downto 0);
		PIPEPHYSTATUSL0 : in std_ulogic;
		PIPEPHYSTATUSL1 : in std_ulogic;
		PIPEPHYSTATUSL2 : in std_ulogic;
		PIPEPHYSTATUSL3 : in std_ulogic;
		PIPEPHYSTATUSL4 : in std_ulogic;
		PIPEPHYSTATUSL5 : in std_ulogic;
		PIPEPHYSTATUSL6 : in std_ulogic;
		PIPEPHYSTATUSL7 : in std_ulogic;
		PIPERXCHANISALIGNEDL0 : in std_ulogic;
		PIPERXCHANISALIGNEDL1 : in std_ulogic;
		PIPERXCHANISALIGNEDL2 : in std_ulogic;
		PIPERXCHANISALIGNEDL3 : in std_ulogic;
		PIPERXCHANISALIGNEDL4 : in std_ulogic;
		PIPERXCHANISALIGNEDL5 : in std_ulogic;
		PIPERXCHANISALIGNEDL6 : in std_ulogic;
		PIPERXCHANISALIGNEDL7 : in std_ulogic;
		PIPERXDATAKL0 : in std_ulogic;
		PIPERXDATAKL1 : in std_ulogic;
		PIPERXDATAKL2 : in std_ulogic;
		PIPERXDATAKL3 : in std_ulogic;
		PIPERXDATAKL4 : in std_ulogic;
		PIPERXDATAKL5 : in std_ulogic;
		PIPERXDATAKL6 : in std_ulogic;
		PIPERXDATAKL7 : in std_ulogic;
		PIPERXDATAL0 : in std_logic_vector(7 downto 0);
		PIPERXDATAL1 : in std_logic_vector(7 downto 0);
		PIPERXDATAL2 : in std_logic_vector(7 downto 0);
		PIPERXDATAL3 : in std_logic_vector(7 downto 0);
		PIPERXDATAL4 : in std_logic_vector(7 downto 0);
		PIPERXDATAL5 : in std_logic_vector(7 downto 0);
		PIPERXDATAL6 : in std_logic_vector(7 downto 0);
		PIPERXDATAL7 : in std_logic_vector(7 downto 0);
		PIPERXELECIDLEL0 : in std_ulogic;
		PIPERXELECIDLEL1 : in std_ulogic;
		PIPERXELECIDLEL2 : in std_ulogic;
		PIPERXELECIDLEL3 : in std_ulogic;
		PIPERXELECIDLEL4 : in std_ulogic;
		PIPERXELECIDLEL5 : in std_ulogic;
		PIPERXELECIDLEL6 : in std_ulogic;
		PIPERXELECIDLEL7 : in std_ulogic;
		PIPERXSTATUSL0 : in std_logic_vector(2 downto 0);
		PIPERXSTATUSL1 : in std_logic_vector(2 downto 0);
		PIPERXSTATUSL2 : in std_logic_vector(2 downto 0);
		PIPERXSTATUSL3 : in std_logic_vector(2 downto 0);
		PIPERXSTATUSL4 : in std_logic_vector(2 downto 0);
		PIPERXSTATUSL5 : in std_logic_vector(2 downto 0);
		PIPERXSTATUSL6 : in std_logic_vector(2 downto 0);
		PIPERXSTATUSL7 : in std_logic_vector(2 downto 0);
		PIPERXVALIDL0 : in std_ulogic;
		PIPERXVALIDL1 : in std_ulogic;
		PIPERXVALIDL2 : in std_ulogic;
		PIPERXVALIDL3 : in std_ulogic;
		PIPERXVALIDL4 : in std_ulogic;
		PIPERXVALIDL5 : in std_ulogic;
		PIPERXVALIDL6 : in std_ulogic;
		PIPERXVALIDL7 : in std_ulogic
     );
attribute VITAL_LEVEL0 of X_PCIE_INTERNAL_1_1 :     entity is true;
end X_PCIE_INTERNAL_1_1;

architecture X_PCIE_INTERNAL_1_1_V of X_PCIE_INTERNAL_1_1 is

  component PCIE_INTERNAL_1_1_SWIFT
    port (
      BUSMASTERENABLE      : out std_ulogic;
      CRMDOHOTRESETN       : out std_ulogic;
      CRMPWRSOFTRESETN     : out std_ulogic;
      CRMRXHOTRESETN       : out std_ulogic;
      DLLTXPMDLLPOUTSTANDING : out std_ulogic;
      INTERRUPTDISABLE     : out std_ulogic;
      IOSPACEENABLE        : out std_ulogic;
      L0ASAUTONOMOUSINITCOMPLETED : out std_ulogic;
      L0ATTENTIONINDICATORCONTROL : out std_logic_vector(1 downto 0);
      L0CFGLOOPBACKACK     : out std_ulogic;
      L0COMPLETERID        : out std_logic_vector(12 downto 0);
      L0CORRERRMSGRCVD     : out std_ulogic;
      L0DLLASRXSTATE       : out std_logic_vector(1 downto 0);
      L0DLLASTXSTATE       : out std_ulogic;
      L0DLLERRORVECTOR     : out std_logic_vector(6 downto 0);
      L0DLLRXACKOUTSTANDING : out std_ulogic;
      L0DLLTXNONFCOUTSTANDING : out std_ulogic;
      L0DLLTXOUTSTANDING   : out std_ulogic;
      L0DLLVCSTATUS        : out std_logic_vector(7 downto 0);
      L0DLUPDOWN           : out std_logic_vector(7 downto 0);
      L0ERRMSGREQID        : out std_logic_vector(15 downto 0);
      L0FATALERRMSGRCVD    : out std_ulogic;
      L0FIRSTCFGWRITEOCCURRED : out std_ulogic;
      L0FWDCORRERROUT      : out std_ulogic;
      L0FWDFATALERROUT     : out std_ulogic;
      L0FWDNONFATALERROUT  : out std_ulogic;
      L0LTSSMSTATE         : out std_logic_vector(3 downto 0);
      L0MACENTEREDL0       : out std_ulogic;
      L0MACLINKTRAINING    : out std_ulogic;
      L0MACLINKUP          : out std_ulogic;
      L0MACNEGOTIATEDLINKWIDTH : out std_logic_vector(3 downto 0);
      L0MACNEWSTATEACK     : out std_ulogic;
      L0MACRXL0SSTATE      : out std_ulogic;
      L0MACUPSTREAMDOWNSTREAM : out std_ulogic;
      L0MCFOUND            : out std_logic_vector(2 downto 0);
      L0MSIENABLE0         : out std_ulogic;
      L0MULTIMSGEN0        : out std_logic_vector(2 downto 0);
      L0NONFATALERRMSGRCVD : out std_ulogic;
      L0PMEACK             : out std_ulogic;
      L0PMEEN              : out std_ulogic;
      L0PMEREQOUT          : out std_ulogic;
      L0POWERCONTROLLERCONTROL : out std_ulogic;
      L0POWERINDICATORCONTROL : out std_logic_vector(1 downto 0);
      L0PWRINHIBITTRANSFERS : out std_ulogic;
      L0PWRL1STATE         : out std_ulogic;
      L0PWRL23READYDEVICE  : out std_ulogic;
      L0PWRL23READYSTATE   : out std_ulogic;
      L0PWRSTATE0          : out std_logic_vector(1 downto 0);
      L0PWRTURNOFFREQ      : out std_ulogic;
      L0PWRTXL0SSTATE      : out std_ulogic;
      L0RECEIVEDASSERTINTALEGACYINT : out std_ulogic;
      L0RECEIVEDASSERTINTBLEGACYINT : out std_ulogic;
      L0RECEIVEDASSERTINTCLEGACYINT : out std_ulogic;
      L0RECEIVEDASSERTINTDLEGACYINT : out std_ulogic;
      L0RECEIVEDDEASSERTINTALEGACYINT : out std_ulogic;
      L0RECEIVEDDEASSERTINTBLEGACYINT : out std_ulogic;
      L0RECEIVEDDEASSERTINTCLEGACYINT : out std_ulogic;
      L0RECEIVEDDEASSERTINTDLEGACYINT : out std_ulogic;
      L0RXBEACON           : out std_ulogic;
      L0RXDLLFCCMPLMCCRED  : out std_logic_vector(23 downto 0);
      L0RXDLLFCCMPLMCUPDATE : out std_logic_vector(7 downto 0);
      L0RXDLLFCNPOSTBYPCRED : out std_logic_vector(19 downto 0);
      L0RXDLLFCNPOSTBYPUPDATE : out std_logic_vector(7 downto 0);
      L0RXDLLFCPOSTORDCRED : out std_logic_vector(23 downto 0);
      L0RXDLLFCPOSTORDUPDATE : out std_logic_vector(7 downto 0);
      L0RXDLLPM            : out std_ulogic;
      L0RXDLLPMTYPE        : out std_logic_vector(2 downto 0);
      L0RXDLLSBFCDATA      : out std_logic_vector(18 downto 0);
      L0RXDLLSBFCUPDATE    : out std_ulogic;
      L0RXDLLTLPECRCOK     : out std_ulogic;
      L0RXDLLTLPEND        : out std_logic_vector(1 downto 0);
      L0RXMACLINKERROR     : out std_logic_vector(1 downto 0);
      L0STATSCFGOTHERRECEIVED : out std_ulogic;
      L0STATSCFGOTHERTRANSMITTED : out std_ulogic;
      L0STATSCFGRECEIVED   : out std_ulogic;
      L0STATSCFGTRANSMITTED : out std_ulogic;
      L0STATSDLLPRECEIVED  : out std_ulogic;
      L0STATSDLLPTRANSMITTED : out std_ulogic;
      L0STATSOSRECEIVED    : out std_ulogic;
      L0STATSOSTRANSMITTED : out std_ulogic;
      L0STATSTLPRECEIVED   : out std_ulogic;
      L0STATSTLPTRANSMITTED : out std_ulogic;
      L0TOGGLEELECTROMECHANICALINTERLOCK : out std_ulogic;
      L0TRANSFORMEDVC      : out std_logic_vector(2 downto 0);
      L0TXDLLFCCMPLMCUPDATED : out std_logic_vector(7 downto 0);
      L0TXDLLFCNPOSTBYPUPDATED : out std_logic_vector(7 downto 0);
      L0TXDLLFCPOSTORDUPDATED : out std_logic_vector(7 downto 0);
      L0TXDLLPMUPDATED     : out std_ulogic;
      L0TXDLLSBFCUPDATED   : out std_ulogic;
      L0UCBYPFOUND         : out std_logic_vector(3 downto 0);
      L0UCORDFOUND         : out std_logic_vector(3 downto 0);
      L0UNLOCKRECEIVED     : out std_ulogic;
      LLKRX4DWHEADERN      : out std_ulogic;
      LLKRXCHCOMPLETIONAVAILABLEN : out std_logic_vector(7 downto 0);
      LLKRXCHCOMPLETIONPARTIALN : out std_logic_vector(7 downto 0);
      LLKRXCHCONFIGAVAILABLEN : out std_ulogic;
      LLKRXCHCONFIGPARTIALN : out std_ulogic;
      LLKRXCHNONPOSTEDAVAILABLEN : out std_logic_vector(7 downto 0);
      LLKRXCHNONPOSTEDPARTIALN : out std_logic_vector(7 downto 0);
      LLKRXCHPOSTEDAVAILABLEN : out std_logic_vector(7 downto 0);
      LLKRXCHPOSTEDPARTIALN : out std_logic_vector(7 downto 0);
      LLKRXDATA            : out std_logic_vector(63 downto 0);
      LLKRXECRCBADN        : out std_ulogic;
      LLKRXEOFN            : out std_ulogic;
      LLKRXEOPN            : out std_ulogic;
      LLKRXPREFERREDTYPE   : out std_logic_vector(15 downto 0);
      LLKRXSOFN            : out std_ulogic;
      LLKRXSOPN            : out std_ulogic;
      LLKRXSRCDSCN         : out std_ulogic;
      LLKRXSRCLASTREQN     : out std_ulogic;
      LLKRXSRCRDYN         : out std_ulogic;
      LLKRXVALIDN          : out std_logic_vector(1 downto 0);
      LLKTCSTATUS          : out std_logic_vector(7 downto 0);
      LLKTXCHANSPACE       : out std_logic_vector(9 downto 0);
      LLKTXCHCOMPLETIONREADYN : out std_logic_vector(7 downto 0);
      LLKTXCHNONPOSTEDREADYN : out std_logic_vector(7 downto 0);
      LLKTXCHPOSTEDREADYN  : out std_logic_vector(7 downto 0);
      LLKTXCONFIGREADYN    : out std_ulogic;
      LLKTXDSTRDYN         : out std_ulogic;
      MAXPAYLOADSIZE       : out std_logic_vector(2 downto 0);
      MAXREADREQUESTSIZE   : out std_logic_vector(2 downto 0);
      MEMSPACEENABLE       : out std_ulogic;
      MGMTPSO              : out std_logic_vector(16 downto 0);
      MGMTRDATA            : out std_logic_vector(31 downto 0);
      MGMTSTATSCREDIT      : out std_logic_vector(11 downto 0);
      MIMDLLBRADD          : out std_logic_vector(11 downto 0);
      MIMDLLBREN           : out std_ulogic;
      MIMDLLBWADD          : out std_logic_vector(11 downto 0);
      MIMDLLBWDATA         : out std_logic_vector(63 downto 0);
      MIMDLLBWEN           : out std_ulogic;
      MIMRXBRADD           : out std_logic_vector(12 downto 0);
      MIMRXBREN            : out std_ulogic;
      MIMRXBWADD           : out std_logic_vector(12 downto 0);
      MIMRXBWDATA          : out std_logic_vector(63 downto 0);
      MIMRXBWEN            : out std_ulogic;
      MIMTXBRADD           : out std_logic_vector(12 downto 0);
      MIMTXBREN            : out std_ulogic;
      MIMTXBWADD           : out std_logic_vector(12 downto 0);
      MIMTXBWDATA          : out std_logic_vector(63 downto 0);
      MIMTXBWEN            : out std_ulogic;
      PARITYERRORRESPONSE  : out std_ulogic;
      PIPEDESKEWLANESL0    : out std_ulogic;
      PIPEDESKEWLANESL1    : out std_ulogic;
      PIPEDESKEWLANESL2    : out std_ulogic;
      PIPEDESKEWLANESL3    : out std_ulogic;
      PIPEDESKEWLANESL4    : out std_ulogic;
      PIPEDESKEWLANESL5    : out std_ulogic;
      PIPEDESKEWLANESL6    : out std_ulogic;
      PIPEDESKEWLANESL7    : out std_ulogic;
      PIPEPOWERDOWNL0      : out std_logic_vector(1 downto 0);
      PIPEPOWERDOWNL1      : out std_logic_vector(1 downto 0);
      PIPEPOWERDOWNL2      : out std_logic_vector(1 downto 0);
      PIPEPOWERDOWNL3      : out std_logic_vector(1 downto 0);
      PIPEPOWERDOWNL4      : out std_logic_vector(1 downto 0);
      PIPEPOWERDOWNL5      : out std_logic_vector(1 downto 0);
      PIPEPOWERDOWNL6      : out std_logic_vector(1 downto 0);
      PIPEPOWERDOWNL7      : out std_logic_vector(1 downto 0);
      PIPERESETL0          : out std_ulogic;
      PIPERESETL1          : out std_ulogic;
      PIPERESETL2          : out std_ulogic;
      PIPERESETL3          : out std_ulogic;
      PIPERESETL4          : out std_ulogic;
      PIPERESETL5          : out std_ulogic;
      PIPERESETL6          : out std_ulogic;
      PIPERESETL7          : out std_ulogic;
      PIPERXPOLARITYL0     : out std_ulogic;
      PIPERXPOLARITYL1     : out std_ulogic;
      PIPERXPOLARITYL2     : out std_ulogic;
      PIPERXPOLARITYL3     : out std_ulogic;
      PIPERXPOLARITYL4     : out std_ulogic;
      PIPERXPOLARITYL5     : out std_ulogic;
      PIPERXPOLARITYL6     : out std_ulogic;
      PIPERXPOLARITYL7     : out std_ulogic;
      PIPETXCOMPLIANCEL0   : out std_ulogic;
      PIPETXCOMPLIANCEL1   : out std_ulogic;
      PIPETXCOMPLIANCEL2   : out std_ulogic;
      PIPETXCOMPLIANCEL3   : out std_ulogic;
      PIPETXCOMPLIANCEL4   : out std_ulogic;
      PIPETXCOMPLIANCEL5   : out std_ulogic;
      PIPETXCOMPLIANCEL6   : out std_ulogic;
      PIPETXCOMPLIANCEL7   : out std_ulogic;
      PIPETXDATAKL0        : out std_ulogic;
      PIPETXDATAKL1        : out std_ulogic;
      PIPETXDATAKL2        : out std_ulogic;
      PIPETXDATAKL3        : out std_ulogic;
      PIPETXDATAKL4        : out std_ulogic;
      PIPETXDATAKL5        : out std_ulogic;
      PIPETXDATAKL6        : out std_ulogic;
      PIPETXDATAKL7        : out std_ulogic;
      PIPETXDATAL0         : out std_logic_vector(7 downto 0);
      PIPETXDATAL1         : out std_logic_vector(7 downto 0);
      PIPETXDATAL2         : out std_logic_vector(7 downto 0);
      PIPETXDATAL3         : out std_logic_vector(7 downto 0);
      PIPETXDATAL4         : out std_logic_vector(7 downto 0);
      PIPETXDATAL5         : out std_logic_vector(7 downto 0);
      PIPETXDATAL6         : out std_logic_vector(7 downto 0);
      PIPETXDATAL7         : out std_logic_vector(7 downto 0);
      PIPETXDETECTRXLOOPBACKL0 : out std_ulogic;
      PIPETXDETECTRXLOOPBACKL1 : out std_ulogic;
      PIPETXDETECTRXLOOPBACKL2 : out std_ulogic;
      PIPETXDETECTRXLOOPBACKL3 : out std_ulogic;
      PIPETXDETECTRXLOOPBACKL4 : out std_ulogic;
      PIPETXDETECTRXLOOPBACKL5 : out std_ulogic;
      PIPETXDETECTRXLOOPBACKL6 : out std_ulogic;
      PIPETXDETECTRXLOOPBACKL7 : out std_ulogic;
      PIPETXELECIDLEL0     : out std_ulogic;
      PIPETXELECIDLEL1     : out std_ulogic;
      PIPETXELECIDLEL2     : out std_ulogic;
      PIPETXELECIDLEL3     : out std_ulogic;
      PIPETXELECIDLEL4     : out std_ulogic;
      PIPETXELECIDLEL5     : out std_ulogic;
      PIPETXELECIDLEL6     : out std_ulogic;
      PIPETXELECIDLEL7     : out std_ulogic;
      SERRENABLE           : out std_ulogic;
      URREPORTINGENABLE    : out std_ulogic;

      AUXPOWER             : in std_ulogic;
      CFGNEGOTIATEDLINKWIDTH : in std_logic_vector(5 downto 0);
      COMPLIANCEAVOID      : in std_ulogic;
      CRMCFGBRIDGEHOTRESET : in std_ulogic;
      CRMCORECLK           : in std_ulogic;
      CRMCORECLKDLO        : in std_ulogic;
      CRMCORECLKRXO        : in std_ulogic;
      CRMCORECLKTXO        : in std_ulogic;
      CRMLINKRSTN          : in std_ulogic;
      CRMMACRSTN           : in std_ulogic;
      CRMMGMTRSTN          : in std_ulogic;
      CRMNVRSTN            : in std_ulogic;
      CRMTXHOTRESETN       : in std_ulogic;
      CRMURSTN             : in std_ulogic;
      CRMUSERCFGRSTN       : in std_ulogic;
      CRMUSERCLK           : in std_ulogic;
      CRMUSERCLKRXO        : in std_ulogic;
      CRMUSERCLKTXO        : in std_ulogic;
      CROSSLINKSEED        : in std_ulogic;
      GSR                  : in std_ulogic;
      L0ACKNAKTIMERADJUSTMENT : in std_logic_vector(11 downto 0);
      L0ALLDOWNPORTSINL1   : in std_ulogic;
      L0ALLDOWNRXPORTSINL0S : in std_ulogic;
      L0ASE                : in std_ulogic;
      L0ASPORTCOUNT        : in std_logic_vector(7 downto 0);
      L0ASTURNPOOLBITSCONSUMED : in std_logic_vector(2 downto 0);
      L0ATTENTIONBUTTONPRESSED : in std_ulogic;
      L0CFGASSPANTREEOWNEDSTATE : in std_ulogic;
      L0CFGASSTATECHANGECMD : in std_logic_vector(3 downto 0);
      L0CFGDISABLESCRAMBLE : in std_ulogic;
      L0CFGEXTENDEDSYNC    : in std_ulogic;
      L0CFGL0SENTRYENABLE  : in std_ulogic;
      L0CFGL0SENTRYSUP     : in std_ulogic;
      L0CFGL0SEXITLAT      : in std_logic_vector(2 downto 0);
      L0CFGLINKDISABLE     : in std_ulogic;
      L0CFGLOOPBACKMASTER  : in std_ulogic;
      L0CFGNEGOTIATEDMAXP  : in std_logic_vector(2 downto 0);
      L0CFGVCENABLE        : in std_logic_vector(7 downto 0);
      L0CFGVCID            : in std_logic_vector(23 downto 0);
      L0DLLHOLDLINKUP      : in std_ulogic;
      L0ELECTROMECHANICALINTERLOCKENGAGED : in std_ulogic;
      L0FWDASSERTINTALEGACYINT : in std_ulogic;
      L0FWDASSERTINTBLEGACYINT : in std_ulogic;
      L0FWDASSERTINTCLEGACYINT : in std_ulogic;
      L0FWDASSERTINTDLEGACYINT : in std_ulogic;
      L0FWDCORRERRIN       : in std_ulogic;
      L0FWDDEASSERTINTALEGACYINT : in std_ulogic;
      L0FWDDEASSERTINTBLEGACYINT : in std_ulogic;
      L0FWDDEASSERTINTCLEGACYINT : in std_ulogic;
      L0FWDDEASSERTINTDLEGACYINT : in std_ulogic;
      L0FWDFATALERRIN      : in std_ulogic;
      L0FWDNONFATALERRIN   : in std_ulogic;
      L0LEGACYINTFUNCT0    : in std_ulogic;
      L0MRLSENSORCLOSEDN   : in std_ulogic;
      L0MSIREQUEST0        : in std_logic_vector(3 downto 0);
      L0PACKETHEADERFROMUSER : in std_logic_vector(127 downto 0);
      L0PMEREQIN           : in std_ulogic;
      L0PORTNUMBER         : in std_logic_vector(7 downto 0);
      L0POWERFAULTDETECTED : in std_ulogic;
      L0PRESENCEDETECTSLOTEMPTYN : in std_ulogic;
      L0PWRNEWSTATEREQ     : in std_ulogic;
      L0PWRNEXTLINKSTATE   : in std_logic_vector(1 downto 0);
      L0REPLAYTIMERADJUSTMENT : in std_logic_vector(11 downto 0);
      L0ROOTTURNOFFREQ     : in std_ulogic;
      L0RXTLTLPNONINITIALIZEDVC : in std_logic_vector(7 downto 0);
      L0SENDUNLOCKMESSAGE  : in std_ulogic;
      L0SETCOMPLETERABORTERROR : in std_ulogic;
      L0SETCOMPLETIONTIMEOUTCORRERROR : in std_ulogic;
      L0SETCOMPLETIONTIMEOUTUNCORRERROR : in std_ulogic;
      L0SETDETECTEDCORRERROR : in std_ulogic;
      L0SETDETECTEDFATALERROR : in std_ulogic;
      L0SETDETECTEDNONFATALERROR : in std_ulogic;
      L0SETLINKDETECTEDPARITYERROR : in std_ulogic;
      L0SETLINKMASTERDATAPARITY : in std_ulogic;
      L0SETLINKRECEIVEDMASTERABORT : in std_ulogic;
      L0SETLINKRECEIVEDTARGETABORT : in std_ulogic;
      L0SETLINKSIGNALLEDTARGETABORT : in std_ulogic;
      L0SETLINKSYSTEMERROR : in std_ulogic;
      L0SETUNEXPECTEDCOMPLETIONCORRERROR : in std_ulogic;
      L0SETUNEXPECTEDCOMPLETIONUNCORRERROR : in std_ulogic;
      L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR : in std_ulogic;
      L0SETUNSUPPORTEDREQUESTOTHERERROR : in std_ulogic;
      L0SETUSERDETECTEDPARITYERROR : in std_ulogic;
      L0SETUSERMASTERDATAPARITY : in std_ulogic;
      L0SETUSERRECEIVEDMASTERABORT : in std_ulogic;
      L0SETUSERRECEIVEDTARGETABORT : in std_ulogic;
      L0SETUSERSIGNALLEDTARGETABORT : in std_ulogic;
      L0SETUSERSYSTEMERROR : in std_ulogic;
      L0TLASFCCREDSTARVATION : in std_ulogic;
      L0TLLINKRETRAIN      : in std_ulogic;
      L0TRANSACTIONSPENDING : in std_ulogic;
      L0TXBEACON           : in std_ulogic;
      L0TXCFGPM            : in std_ulogic;
      L0TXCFGPMTYPE        : in std_logic_vector(2 downto 0);
      L0TXTLFCCMPLMCCRED   : in std_logic_vector(159 downto 0);
      L0TXTLFCCMPLMCUPDATE : in std_logic_vector(15 downto 0);
      L0TXTLFCNPOSTBYPCRED : in std_logic_vector(191 downto 0);
      L0TXTLFCNPOSTBYPUPDATE : in std_logic_vector(15 downto 0);
      L0TXTLFCPOSTORDCRED  : in std_logic_vector(159 downto 0);
      L0TXTLFCPOSTORDUPDATE : in std_logic_vector(15 downto 0);
      L0TXTLSBFCDATA       : in std_logic_vector(18 downto 0);
      L0TXTLSBFCUPDATE     : in std_ulogic;
      L0TXTLTLPDATA        : in std_logic_vector(63 downto 0);
      L0TXTLTLPEDB         : in std_ulogic;
      L0TXTLTLPENABLE      : in std_logic_vector(1 downto 0);
      L0TXTLTLPEND         : in std_logic_vector(1 downto 0);
      L0TXTLTLPLATENCY     : in std_logic_vector(3 downto 0);
      L0TXTLTLPREQ         : in std_ulogic;
      L0TXTLTLPREQEND      : in std_ulogic;
      L0TXTLTLPWIDTH       : in std_ulogic;
      L0UPSTREAMRXPORTINL0S : in std_ulogic;
      L0VC0PREVIEWEXPAND   : in std_ulogic;
      L0WAKEN              : in std_ulogic;
      LLKRXCHFIFO          : in std_logic_vector(1 downto 0);
      LLKRXCHTC            : in std_logic_vector(2 downto 0);
      LLKRXDSTCONTREQN     : in std_ulogic;
      LLKRXDSTREQN         : in std_ulogic;
      LLKTX4DWHEADERN      : in std_ulogic;
      LLKTXCHFIFO          : in std_logic_vector(1 downto 0);
      LLKTXCHTC            : in std_logic_vector(2 downto 0);
      LLKTXCOMPLETEN       : in std_ulogic;
      LLKTXCREATEECRCN     : in std_ulogic;
      LLKTXDATA            : in std_logic_vector(63 downto 0);
      LLKTXENABLEN         : in std_logic_vector(1 downto 0);
      LLKTXEOFN            : in std_ulogic;
      LLKTXEOPN            : in std_ulogic;
      LLKTXSOFN            : in std_ulogic;
      LLKTXSOPN            : in std_ulogic;
      LLKTXSRCDSCN         : in std_ulogic;
      LLKTXSRCRDYN         : in std_ulogic;
      MAINPOWER            : in std_ulogic;
      MGMTADDR             : in std_logic_vector(10 downto 0);
      MGMTBWREN            : in std_logic_vector(3 downto 0);
      MGMTRDEN             : in std_ulogic;
      MGMTSTATSCREDITSEL   : in std_logic_vector(6 downto 0);
      MGMTWDATA            : in std_logic_vector(31 downto 0);
      MGMTWREN             : in std_ulogic;
      MIMDLLBRDATA         : in std_logic_vector(63 downto 0);
      MIMRXBRDATA          : in std_logic_vector(63 downto 0);
      MIMTXBRDATA          : in std_logic_vector(63 downto 0);
      PIPEPHYSTATUSL0      : in std_ulogic;
      PIPEPHYSTATUSL1      : in std_ulogic;
      PIPEPHYSTATUSL2      : in std_ulogic;
      PIPEPHYSTATUSL3      : in std_ulogic;
      PIPEPHYSTATUSL4      : in std_ulogic;
      PIPEPHYSTATUSL5      : in std_ulogic;
      PIPEPHYSTATUSL6      : in std_ulogic;
      PIPEPHYSTATUSL7      : in std_ulogic;
      PIPERXCHANISALIGNEDL0 : in std_ulogic;
      PIPERXCHANISALIGNEDL1 : in std_ulogic;
      PIPERXCHANISALIGNEDL2 : in std_ulogic;
      PIPERXCHANISALIGNEDL3 : in std_ulogic;
      PIPERXCHANISALIGNEDL4 : in std_ulogic;
      PIPERXCHANISALIGNEDL5 : in std_ulogic;
      PIPERXCHANISALIGNEDL6 : in std_ulogic;
      PIPERXCHANISALIGNEDL7 : in std_ulogic;
      PIPERXDATAKL0        : in std_ulogic;
      PIPERXDATAKL1        : in std_ulogic;
      PIPERXDATAKL2        : in std_ulogic;
      PIPERXDATAKL3        : in std_ulogic;
      PIPERXDATAKL4        : in std_ulogic;
      PIPERXDATAKL5        : in std_ulogic;
      PIPERXDATAKL6        : in std_ulogic;
      PIPERXDATAKL7        : in std_ulogic;
      PIPERXDATAL0         : in std_logic_vector(7 downto 0);
      PIPERXDATAL1         : in std_logic_vector(7 downto 0);
      PIPERXDATAL2         : in std_logic_vector(7 downto 0);
      PIPERXDATAL3         : in std_logic_vector(7 downto 0);
      PIPERXDATAL4         : in std_logic_vector(7 downto 0);
      PIPERXDATAL5         : in std_logic_vector(7 downto 0);
      PIPERXDATAL6         : in std_logic_vector(7 downto 0);
      PIPERXDATAL7         : in std_logic_vector(7 downto 0);
      PIPERXELECIDLEL0     : in std_ulogic;
      PIPERXELECIDLEL1     : in std_ulogic;
      PIPERXELECIDLEL2     : in std_ulogic;
      PIPERXELECIDLEL3     : in std_ulogic;
      PIPERXELECIDLEL4     : in std_ulogic;
      PIPERXELECIDLEL5     : in std_ulogic;
      PIPERXELECIDLEL6     : in std_ulogic;
      PIPERXELECIDLEL7     : in std_ulogic;
      PIPERXSTATUSL0       : in std_logic_vector(2 downto 0);
      PIPERXSTATUSL1       : in std_logic_vector(2 downto 0);
      PIPERXSTATUSL2       : in std_logic_vector(2 downto 0);
      PIPERXSTATUSL3       : in std_logic_vector(2 downto 0);
      PIPERXSTATUSL4       : in std_logic_vector(2 downto 0);
      PIPERXSTATUSL5       : in std_logic_vector(2 downto 0);
      PIPERXSTATUSL6       : in std_logic_vector(2 downto 0);
      PIPERXSTATUSL7       : in std_logic_vector(2 downto 0);
      PIPERXVALIDL0        : in std_ulogic;
      PIPERXVALIDL1        : in std_ulogic;
      PIPERXVALIDL2        : in std_ulogic;
      PIPERXVALIDL3        : in std_ulogic;
      PIPERXVALIDL4        : in std_ulogic;
      PIPERXVALIDL5        : in std_ulogic;
      PIPERXVALIDL6        : in std_ulogic;
      PIPERXVALIDL7        : in std_ulogic;
      
      MCACTIVELANESIN             : in std_logic_vector(7 downto 0);
      MCAERBASEPTR                : in std_logic_vector(11 downto 0);
      MCAERCAPABILITYECRCCHECKCAPABLE : in std_ulogic;
      MCAERCAPABILITYECRCGENCAPABLE : in std_ulogic;
      MCAERCAPABILITYNEXTPTR      : in std_logic_vector(11 downto 0);
      MCBAR0ADDRWIDTH             : in std_ulogic;
      MCBAR0EXIST                 : in std_ulogic;
      MCBAR0IOMEMN                : in std_ulogic;
      MCBAR0MASKWIDTH             : in std_logic_vector(5 downto 0);
      MCBAR0PREFETCHABLE          : in std_ulogic;
      MCBAR1ADDRWIDTH             : in std_ulogic;
      MCBAR1EXIST                 : in std_ulogic;
      MCBAR1IOMEMN                : in std_ulogic;
      MCBAR1MASKWIDTH             : in std_logic_vector(5 downto 0);
      MCBAR1PREFETCHABLE          : in std_ulogic;
      MCBAR2ADDRWIDTH             : in std_ulogic;
      MCBAR2EXIST                 : in std_ulogic;
      MCBAR2IOMEMN                : in std_ulogic;
      MCBAR2MASKWIDTH             : in std_logic_vector(5 downto 0);
      MCBAR2PREFETCHABLE          : in std_ulogic;
      MCBAR3ADDRWIDTH             : in std_ulogic;
      MCBAR3EXIST                 : in std_ulogic;
      MCBAR3IOMEMN                : in std_ulogic;
      MCBAR3MASKWIDTH             : in std_logic_vector(5 downto 0);
      MCBAR3PREFETCHABLE          : in std_ulogic;
      MCBAR4ADDRWIDTH             : in std_ulogic;
      MCBAR4EXIST                 : in std_ulogic;
      MCBAR4IOMEMN                : in std_ulogic;
      MCBAR4MASKWIDTH             : in std_logic_vector(5 downto 0);
      MCBAR4PREFETCHABLE          : in std_ulogic;
      MCBAR5ADDRWIDTH             : in std_ulogic;
      MCBAR5EXIST                 : in std_ulogic;
      MCBAR5IOMEMN                : in std_ulogic;
      MCBAR5MASKWIDTH             : in std_logic_vector(5 downto 0);
      MCBAR5PREFETCHABLE          : in std_ulogic;
      MCCAPABILITIESPOINTER       : in std_logic_vector(7 downto 0);
      MCCARDBUSCISPOINTER         : in std_logic_vector(31 downto 0);
      MCCLASSCODE                 : in std_logic_vector(23 downto 0);
--      CLKDIVIDED                : in std_ulogic;
      MCCONFIGROUTING             : in std_logic_vector(2 downto 0);
      MCDEVICECAPABILITYENDPOINTL0SLATENCY : in std_logic_vector(2 downto 0);
      MCDEVICECAPABILITYENDPOINTL1LATENCY : in std_logic_vector(2 downto 0);
      MCDEVICEID                  : in std_logic_vector(15 downto 0);
      MCDEVICESERIALNUMBER        : in std_logic_vector(63 downto 0);
      MCDSNBASEPTR                : in std_logic_vector(11 downto 0);
      MCDSNCAPABILITYNEXTPTR      : in std_logic_vector(11 downto 0);
      MCDUALCOREENABLE            : in std_ulogic;
      MCDUALCORESLAVE             : in std_ulogic;
      MCDUALROLECFGCNTRLROOTEPN   : in std_ulogic;
      MCEXTCFGCAPPTR              : in std_logic_vector(7 downto 0);
      MCEXTCFGXPCAPPTR            : in std_logic_vector(11 downto 0);
      MCHEADERTYPE                : in std_logic_vector(7 downto 0);
      MCINFINITECOMPLETIONS       : in std_ulogic;
      MCINTERRUPTPIN              : in std_logic_vector(7 downto 0);
      MCISSWITCH                  : in std_ulogic;
      MCL0SEXITLATENCY            : in std_logic_vector(2 downto 0);
      MCL0SEXITLATENCYCOMCLK      : in std_logic_vector(2 downto 0);
      MCL1EXITLATENCY             : in std_logic_vector(2 downto 0);
      MCL1EXITLATENCYCOMCLK       : in std_logic_vector(2 downto 0);
      MCLINKCAPABILITYASPMSUPPORT : in std_logic_vector(1 downto 0);
      MCLINKCAPABILITYMAXLINKWIDTH : in std_logic_vector(5 downto 0);
      MCLINKSTATUSSLOTCLOCKCONFIG : in std_ulogic;
      MCLLKBYPASS                 : in std_ulogic;
      MCLOWPRIORITYVCCOUNT        : in std_logic_vector(2 downto 0);
      MCMSIBASEPTR                : in std_logic_vector(11 downto 0);
      MCMSICAPABILITYMULTIMSGCAP  : in std_logic_vector(2 downto 0);
      MCMSICAPABILITYNEXTPTR      : in std_logic_vector(7 downto 0);
      MCPBBASEPTR                 : in std_logic_vector(11 downto 0);
      MCPBCAPABILITYDW0BASEPOWER  : in std_logic_vector(7 downto 0);
      MCPBCAPABILITYDW0DATASCALE  : in std_logic_vector(1 downto 0);
      MCPBCAPABILITYDW0PMSTATE    : in std_logic_vector(1 downto 0);
      MCPBCAPABILITYDW0PMSUBSTATE : in std_logic_vector(2 downto 0);
      MCPBCAPABILITYDW0POWERRAIL  : in std_logic_vector(2 downto 0);
      MCPBCAPABILITYDW0TYPE       : in std_logic_vector(2 downto 0);
      MCPBCAPABILITYDW1BASEPOWER  : in std_logic_vector(7 downto 0);
      MCPBCAPABILITYDW1DATASCALE  : in std_logic_vector(1 downto 0);
      MCPBCAPABILITYDW1PMSTATE    : in std_logic_vector(1 downto 0);
      MCPBCAPABILITYDW1PMSUBSTATE : in std_logic_vector(2 downto 0);
      MCPBCAPABILITYDW1POWERRAIL  : in std_logic_vector(2 downto 0);
      MCPBCAPABILITYDW1TYPE       : in std_logic_vector(2 downto 0);
      MCPBCAPABILITYDW2BASEPOWER  : in std_logic_vector(7 downto 0);
      MCPBCAPABILITYDW2DATASCALE  : in std_logic_vector(1 downto 0);
      MCPBCAPABILITYDW2PMSTATE    : in std_logic_vector(1 downto 0);
      MCPBCAPABILITYDW2PMSUBSTATE : in std_logic_vector(2 downto 0);
      MCPBCAPABILITYDW2POWERRAIL  : in std_logic_vector(2 downto 0);
      MCPBCAPABILITYDW2TYPE       : in std_logic_vector(2 downto 0);
      MCPBCAPABILITYDW3BASEPOWER  : in std_logic_vector(7 downto 0);
      MCPBCAPABILITYDW3DATASCALE  : in std_logic_vector(1 downto 0);
      MCPBCAPABILITYDW3PMSTATE    : in std_logic_vector(1 downto 0);
      MCPBCAPABILITYDW3PMSUBSTATE : in std_logic_vector(2 downto 0);
      MCPBCAPABILITYDW3POWERRAIL  : in std_logic_vector(2 downto 0);
      MCPBCAPABILITYDW3TYPE       : in std_logic_vector(2 downto 0);
      MCPBCAPABILITYNEXTPTR       : in std_logic_vector(11 downto 0);
      MCPBCAPABILITYSYSTEMALLOCATED : in std_ulogic;
      MCPCIECAPABILITYINTMSGNUM   : in std_logic_vector(4 downto 0);
      MCPCIECAPABILITYNEXTPTR     : in std_logic_vector(7 downto 0);
      MCPCIECAPABILITYSLOTIMPL    : in std_ulogic;
      MCPCIEREVISION              : in std_ulogic;
      MCPMBASEPTR                 : in std_logic_vector(11 downto 0);
      MCPMCAPABILITYAUXCURRENT    : in std_logic_vector(2 downto 0);
      MCPMCAPABILITYD1SUPPORT     : in std_ulogic;
      MCPMCAPABILITYD2SUPPORT     : in std_ulogic;
      MCPMCAPABILITYDSI           : in std_ulogic;
      MCPMCAPABILITYNEXTPTR       : in std_logic_vector(7 downto 0);
      MCPMCAPABILITYPMESUPPORT    : in std_logic_vector(4 downto 0);
      MCPMDATA0                   : in std_logic_vector(7 downto 0);
      MCPMDATA1                   : in std_logic_vector(7 downto 0);
      MCPMDATA2                   : in std_logic_vector(7 downto 0);
      MCPMDATA3                   : in std_logic_vector(7 downto 0);
      MCPMDATA4                   : in std_logic_vector(7 downto 0);
      MCPMDATA5                   : in std_logic_vector(7 downto 0);
      MCPMDATA6                   : in std_logic_vector(7 downto 0);
      MCPMDATA7                   : in std_logic_vector(7 downto 0);
      MCPMDATA8                   : in std_logic_vector(7 downto 0);
      MCPMDATASCALE0              : in std_logic_vector(1 downto 0);
      MCPMDATASCALE1              : in std_logic_vector(1 downto 0);
      MCPMDATASCALE2              : in std_logic_vector(1 downto 0);
      MCPMDATASCALE3              : in std_logic_vector(1 downto 0);
      MCPMDATASCALE4              : in std_logic_vector(1 downto 0);
      MCPMDATASCALE5              : in std_logic_vector(1 downto 0);
      MCPMDATASCALE6              : in std_logic_vector(1 downto 0);
      MCPMDATASCALE7              : in std_logic_vector(1 downto 0);
      MCPMDATASCALE8              : in std_logic_vector(1 downto 0);
      MCPMSTATUSCONTROLDATASCALE  : in std_logic_vector(1 downto 0);
      MCPORTVCCAPABILITYEXTENDEDVCCOUNT : in std_logic_vector(2 downto 0);
      MCPORTVCCAPABILITYVCARBCAP  : in std_logic_vector(7 downto 0);
      MCPORTVCCAPABILITYVCARBTABLEOFFSET : in std_logic_vector(7 downto 0);
      MCRAMSHARETXRX              : in std_ulogic;
      MCRESETMODE                 : in std_ulogic;
      MCRETRYRAMREADLATENCY       : in std_logic_vector(2 downto 0);
      MCRETRYRAMSIZE              : in std_logic_vector(11 downto 0);
      MCRETRYRAMWIDTH             : in std_ulogic;
      MCRETRYRAMWRITELATENCY      : in std_logic_vector(2 downto 0);
      MCRETRYREADADDRPIPE         : in std_ulogic;
      MCRETRYREADDATAPIPE         : in std_ulogic;
      MCRETRYWRITEPIPE            : in std_ulogic;
      MCREVISIONID                : in std_logic_vector(7 downto 0);
      MCRXREADADDRPIPE            : in std_ulogic;
      MCRXREADDATAPIPE            : in std_ulogic;
      MCRXWRITEPIPE               : in std_ulogic;
      MCSELECTASMODE              : in std_ulogic;
      MCSELECTDLLIF               : in std_ulogic;
      MCSLOTCAPABILITYATTBUTTONPRESENT : in std_ulogic;
      MCSLOTCAPABILITYATTINDICATORPRESENT : in std_ulogic;
      MCSLOTCAPABILITYHOTPLUGCAPABLE : in std_ulogic;
      MCSLOTCAPABILITYHOTPLUGSURPRISE : in std_ulogic;
      MCSLOTCAPABILITYMSLSENSORPRESENT : in std_ulogic;
      MCSLOTCAPABILITYPHYSICALSLOTNUM : in std_logic_vector(12 downto 0);
      MCSLOTCAPABILITYPOWERCONTROLLERPRESENT : in std_ulogic;
      MCSLOTCAPABILITYPOWERINDICATORPRESENT : in std_ulogic;
      MCSLOTCAPABILITYSLOTPOWERLIMITSCALE : in std_logic_vector(1 downto 0);
      MCSLOTCAPABILITYSLOTPOWERLIMITVALUE : in std_logic_vector(7 downto 0);
      MCSLOTIMPLEMENTED           : in std_ulogic;
      MCSUBSYSTEMID               : in std_logic_vector(15 downto 0);
      MCSUBSYSTEMVENDORID         : in std_logic_vector(15 downto 0);
      MCTLRAMREADLATENCY          : in std_logic_vector(2 downto 0);
      MCTLRAMWIDTH                : in std_ulogic;
      MCTLRAMWRITELATENCY         : in std_logic_vector(2 downto 0);
      MCTXREADADDRPIPE            : in std_ulogic;
      MCTXREADDATAPIPE            : in std_ulogic;
      MCTXTSNFTS                  : in std_logic_vector(7 downto 0);
      MCTXTSNFTSCOMCLK            : in std_logic_vector(7 downto 0);
      MCTXWRITEPIPE               : in std_ulogic;
      MCUPSTREAMFACING            : in std_ulogic;
      MCVC0RXFIFOBASEC            : in std_logic_vector(12 downto 0);
      MCVC0RXFIFOBASENP           : in std_logic_vector(12 downto 0);
      MCVC0RXFIFOBASEP            : in std_logic_vector(12 downto 0);
      MCVC0RXFIFOLIMITC           : in std_logic_vector(12 downto 0);
      MCVC0RXFIFOLIMITNP          : in std_logic_vector(12 downto 0);
      MCVC0RXFIFOLIMITP           : in std_logic_vector(12 downto 0);
      MCVC0TOTALCREDITSCD         : in std_logic_vector(10 downto 0);
      MCVC0TOTALCREDITSCH         : in std_logic_vector(6 downto 0);
      MCVC0TOTALCREDITSNPH        : in std_logic_vector(6 downto 0);
      MCVC0TOTALCREDITSPD         : in std_logic_vector(10 downto 0);
      MCVC0TOTALCREDITSPH         : in std_logic_vector(6 downto 0);
      MCVC0TXFIFOBASEC            : in std_logic_vector(12 downto 0);
      MCVC0TXFIFOBASENP           : in std_logic_vector(12 downto 0);
      MCVC0TXFIFOBASEP            : in std_logic_vector(12 downto 0);
      MCVC0TXFIFOLIMITC           : in std_logic_vector(12 downto 0);
      MCVC0TXFIFOLIMITNP          : in std_logic_vector(12 downto 0);
      MCVC0TXFIFOLIMITP           : in std_logic_vector(12 downto 0);
      MCVC1RXFIFOBASEC            : in std_logic_vector(12 downto 0);
      MCVC1RXFIFOBASENP           : in std_logic_vector(12 downto 0);
      MCVC1RXFIFOBASEP            : in std_logic_vector(12 downto 0);
      MCVC1RXFIFOLIMITC           : in std_logic_vector(12 downto 0);
      MCVC1RXFIFOLIMITNP          : in std_logic_vector(12 downto 0);
      MCVC1RXFIFOLIMITP           : in std_logic_vector(12 downto 0);
      MCVC1TOTALCREDITSCD         : in std_logic_vector(10 downto 0);
      MCVC1TOTALCREDITSCH         : in std_logic_vector(6 downto 0);
      MCVC1TOTALCREDITSNPH        : in std_logic_vector(6 downto 0);
      MCVC1TOTALCREDITSPD         : in std_logic_vector(10 downto 0);
      MCVC1TOTALCREDITSPH         : in std_logic_vector(6 downto 0);
      MCVC1TXFIFOBASEC            : in std_logic_vector(12 downto 0);
      MCVC1TXFIFOBASENP           : in std_logic_vector(12 downto 0);
      MCVC1TXFIFOBASEP            : in std_logic_vector(12 downto 0);
      MCVC1TXFIFOLIMITC           : in std_logic_vector(12 downto 0);
      MCVC1TXFIFOLIMITNP          : in std_logic_vector(12 downto 0);
      MCVC1TXFIFOLIMITP           : in std_logic_vector(12 downto 0);
      MCVCBASEPTR                 : in std_logic_vector(11 downto 0);
      MCVCCAPABILITYNEXTPTR       : in std_logic_vector(11 downto 0);
      MCVENDORID                  : in std_logic_vector(15 downto 0);
      MCXLINKSUPPORTED            : in std_ulogic;
      MCXPBASEPTR                 : in std_logic_vector(7 downto 0);
      MCXPDEVICEPORTTYPE          : in std_logic_vector(3 downto 0);
      MCXPMAXPAYLOAD              : in std_logic_vector(2 downto 0);
      MCXPRCBCONTROL              : in std_ulogic
    );
  end component;

        constant IN_DELAY : time := 0 ps;
	constant OUT_DELAY : time := 0 ps;
	constant CLK_DELAY : time := 0 ps;

  	signal   VC0TXFIFOBASEP_BINARY  :  std_logic_vector(12 downto 0) := To_StdLogicVector(VC0TXFIFOBASEP)(12 downto 0);
	signal   VC0TXFIFOBASENP_BINARY  :  std_logic_vector(12 downto 0) := To_StdLogicVector(VC0TXFIFOBASENP)(12 downto 0);
	signal   VC0TXFIFOBASEC_BINARY  :  std_logic_vector(12 downto 0) := To_StdLogicVector(VC0TXFIFOBASEC)(12 downto 0);
	signal   VC0TXFIFOLIMITP_BINARY  :  std_logic_vector(12 downto 0) := To_StdLogicVector(VC0TXFIFOLIMITP)(12 downto 0);
	signal   VC0TXFIFOLIMITNP_BINARY  :  std_logic_vector(12 downto 0) := To_StdLogicVector(VC0TXFIFOLIMITNP)(12 downto 0);
	signal   VC0TXFIFOLIMITC_BINARY  :  std_logic_vector(12 downto 0) := To_StdLogicVector(VC0TXFIFOLIMITC)(12 downto 0);
	signal   VC0TOTALCREDITSPH_BINARY  :  std_logic_vector(6 downto 0) := To_StdLogicVector(VC0TOTALCREDITSPH)(6 downto 0);
	signal   VC0TOTALCREDITSNPH_BINARY  :  std_logic_vector(6 downto 0) := To_StdLogicVector(VC0TOTALCREDITSNPH)(6 downto 0);
	signal   VC0TOTALCREDITSCH_BINARY  :  std_logic_vector(6 downto 0) := To_StdLogicVector(VC0TOTALCREDITSCH)(6 downto 0);
	signal   VC0TOTALCREDITSPD_BINARY  :  std_logic_vector(10 downto 0) := To_StdLogicVector(VC0TOTALCREDITSPD)(10 downto 0);
	signal   VC0TOTALCREDITSCD_BINARY  :  std_logic_vector(10 downto 0) := To_StdLogicVector(VC0TOTALCREDITSCD)(10 downto 0);
	signal   VC0RXFIFOBASEP_BINARY  :  std_logic_vector(12 downto 0) := To_StdLogicVector(VC0RXFIFOBASEP)(12 downto 0);
	signal   VC0RXFIFOBASENP_BINARY  :  std_logic_vector(12 downto 0) := To_StdLogicVector(VC0RXFIFOBASENP)(12 downto 0);
	signal   VC0RXFIFOBASEC_BINARY  :  std_logic_vector(12 downto 0) := To_StdLogicVector(VC0RXFIFOBASEC)(12 downto 0);
	signal   VC0RXFIFOLIMITP_BINARY  :  std_logic_vector(12 downto 0) := To_StdLogicVector(VC0RXFIFOLIMITP)(12 downto 0);
	signal   VC0RXFIFOLIMITNP_BINARY  :  std_logic_vector(12 downto 0) := To_StdLogicVector(VC0RXFIFOLIMITNP)(12 downto 0);
	signal   VC0RXFIFOLIMITC_BINARY  :  std_logic_vector(12 downto 0) := To_StdLogicVector(VC0RXFIFOLIMITC)(12 downto 0);
	signal   VC1TXFIFOBASEP_BINARY  :  std_logic_vector(12 downto 0) := To_StdLogicVector(VC1TXFIFOBASEP)(12 downto 0);
	signal   VC1TXFIFOBASENP_BINARY  :  std_logic_vector(12 downto 0) := To_StdLogicVector(VC1TXFIFOBASENP)(12 downto 0);
	signal   VC1TXFIFOBASEC_BINARY  :  std_logic_vector(12 downto 0) := To_StdLogicVector(VC1TXFIFOBASEC)(12 downto 0);
	signal   VC1TXFIFOLIMITP_BINARY  :  std_logic_vector(12 downto 0) := To_StdLogicVector(VC1TXFIFOLIMITP)(12 downto 0);
	signal   VC1TXFIFOLIMITNP_BINARY  :  std_logic_vector(12 downto 0) := To_StdLogicVector(VC1TXFIFOLIMITNP)(12 downto 0);
	signal   VC1TXFIFOLIMITC_BINARY  :  std_logic_vector(12 downto 0) := To_StdLogicVector(VC1TXFIFOLIMITC)(12 downto 0);
	signal   VC1TOTALCREDITSPH_BINARY  :  std_logic_vector(6 downto 0) := To_StdLogicVector(VC1TOTALCREDITSPH)(6 downto 0);
	signal   VC1TOTALCREDITSNPH_BINARY  :  std_logic_vector(6 downto 0) := To_StdLogicVector(VC1TOTALCREDITSNPH)(6 downto 0);
	signal   VC1TOTALCREDITSCH_BINARY  :  std_logic_vector(6 downto 0) := To_StdLogicVector(VC1TOTALCREDITSCH)(6 downto 0);
	signal   VC1TOTALCREDITSPD_BINARY  :  std_logic_vector(10 downto 0) := To_StdLogicVector(VC1TOTALCREDITSPD)(10 downto 0);
	signal   VC1TOTALCREDITSCD_BINARY  :  std_logic_vector(10 downto 0) := To_StdLogicVector(VC1TOTALCREDITSCD)(10 downto 0);
	signal   VC1RXFIFOBASEP_BINARY  :  std_logic_vector(12 downto 0) := To_StdLogicVector(VC1RXFIFOBASEP)(12 downto 0);
	signal   VC1RXFIFOBASENP_BINARY  :  std_logic_vector(12 downto 0) := To_StdLogicVector(VC1RXFIFOBASENP)(12 downto 0);
	signal   VC1RXFIFOBASEC_BINARY  :  std_logic_vector(12 downto 0) := To_StdLogicVector(VC1RXFIFOBASEC)(12 downto 0);
	signal   VC1RXFIFOLIMITP_BINARY  :  std_logic_vector(12 downto 0) := To_StdLogicVector(VC1RXFIFOLIMITP)(12 downto 0);
	signal   VC1RXFIFOLIMITNP_BINARY  :  std_logic_vector(12 downto 0) := To_StdLogicVector(VC1RXFIFOLIMITNP)(12 downto 0);
	signal   VC1RXFIFOLIMITC_BINARY  :  std_logic_vector(12 downto 0) := To_StdLogicVector(VC1RXFIFOLIMITC)(12 downto 0);
	signal   ACTIVELANESIN_BINARY  :  std_logic_vector(7 downto 0) := To_StdLogicVector(ACTIVELANESIN);
	signal   TXTSNFTS_BINARY  :  std_logic_vector(7 downto 0);
	signal   TXTSNFTSCOMCLK_BINARY  :  std_logic_vector(7 downto 0);
	signal   RETRYRAMREADLATENCY_BINARY  :  std_logic_vector(2 downto 0);
	signal   RETRYRAMWRITELATENCY_BINARY  :  std_logic_vector(2 downto 0);
	signal   RETRYRAMWIDTH_BINARY  :  std_ulogic;
	signal   RETRYRAMSIZE_BINARY  :  std_logic_vector(11 downto 0) := To_StdLogicVector(RETRYRAMSIZE);
	signal   RETRYWRITEPIPE_BINARY  :  std_ulogic;
	signal   RETRYREADADDRPIPE_BINARY  :  std_ulogic;
	signal   RETRYREADDATAPIPE_BINARY  :  std_ulogic;
	signal   XLINKSUPPORTED_BINARY  :  std_ulogic;
	signal   INFINITECOMPLETIONS_BINARY  :  std_ulogic;
	signal   TLRAMREADLATENCY_BINARY  :  std_logic_vector(2 downto 0);
	signal   TLRAMWRITELATENCY_BINARY  :  std_logic_vector(2 downto 0);
	signal   TLRAMWIDTH_BINARY  :  std_ulogic;
	signal   RAMSHARETXRX_BINARY  :  std_ulogic;
	signal   L0SEXITLATENCY_BINARY  :  std_logic_vector(2 downto 0);
	signal   L0SEXITLATENCYCOMCLK_BINARY  :  std_logic_vector(2 downto 0);
	signal   L1EXITLATENCY_BINARY  :  std_logic_vector(2 downto 0);
	signal   L1EXITLATENCYCOMCLK_BINARY  :  std_logic_vector(2 downto 0);
	signal   DUALCORESLAVE_BINARY  :  std_ulogic;
	signal   DUALCOREENABLE_BINARY  :  std_ulogic;
	signal   DUALROLECFGCNTRLROOTEPN_BINARY  :  std_ulogic;
	signal   RXREADADDRPIPE_BINARY  :  std_ulogic;
	signal   RXREADDATAPIPE_BINARY  :  std_ulogic;
	signal   TXWRITEPIPE_BINARY  :  std_ulogic;
	signal   TXREADADDRPIPE_BINARY  :  std_ulogic;
	signal   TXREADDATAPIPE_BINARY  :  std_ulogic;
	signal   RXWRITEPIPE_BINARY  :  std_ulogic;
	signal   LLKBYPASS_BINARY  :  std_ulogic;
	signal   PCIEREVISION_BINARY  :  std_ulogic;
	signal   SELECTDLLIF_BINARY  :  std_ulogic;
	signal   SELECTASMODE_BINARY  :  std_ulogic;
	signal   ISSWITCH_BINARY  :  std_ulogic;
	signal   UPSTREAMFACING_BINARY  :  std_ulogic;
	signal   SLOTIMPLEMENTED_BINARY  :  std_ulogic;
	signal   EXTCFGCAPPTR_BINARY  :  std_logic_vector(7 downto 0) := To_StdLogicVector(EXTCFGCAPPTR);
	signal   EXTCFGXPCAPPTR_BINARY  :  std_logic_vector(11 downto 0) := To_StdLogicVector(EXTCFGXPCAPPTR);
	signal   BAR0EXIST_BINARY  :  std_ulogic;
	signal   BAR1EXIST_BINARY  :  std_ulogic;
	signal   BAR2EXIST_BINARY  :  std_ulogic;
	signal   BAR3EXIST_BINARY  :  std_ulogic;
	signal   BAR4EXIST_BINARY  :  std_ulogic;
	signal   BAR5EXIST_BINARY  :  std_ulogic;
	signal   BAR0ADDRWIDTH_BINARY  :  std_ulogic;
	signal   BAR1ADDRWIDTH_BINARY  :  std_ulogic;
	signal   BAR2ADDRWIDTH_BINARY  :  std_ulogic;
	signal   BAR3ADDRWIDTH_BINARY  :  std_ulogic;
	signal   BAR4ADDRWIDTH_BINARY  :  std_ulogic;
	signal   BAR5ADDRWIDTH_BINARY  :  std_ulogic := '0';
	signal   BAR0PREFETCHABLE_BINARY  :  std_ulogic;
	signal   BAR1PREFETCHABLE_BINARY  :  std_ulogic;
	signal   BAR2PREFETCHABLE_BINARY  :  std_ulogic;
	signal   BAR3PREFETCHABLE_BINARY  :  std_ulogic;
	signal   BAR4PREFETCHABLE_BINARY  :  std_ulogic;
	signal   BAR5PREFETCHABLE_BINARY  :  std_ulogic;
  	signal   BAR0IOMEMN_BINARY  :  std_ulogic;
	signal   BAR1IOMEMN_BINARY  :  std_ulogic;
	signal   BAR2IOMEMN_BINARY  :  std_ulogic;
	signal   BAR3IOMEMN_BINARY  :  std_ulogic;
	signal   BAR4IOMEMN_BINARY  :  std_ulogic;
	signal   BAR5IOMEMN_BINARY  :  std_ulogic;
	signal   BAR0MASKWIDTH_BINARY  :  std_logic_vector(5 downto 0) := To_StdLogicVector(BAR0MASKWIDTH)(5 downto 0);
	signal   BAR1MASKWIDTH_BINARY  :  std_logic_vector(5 downto 0) := To_StdLogicVector(BAR1MASKWIDTH)(5 downto 0);
	signal   BAR2MASKWIDTH_BINARY  :  std_logic_vector(5 downto 0) := To_StdLogicVector(BAR2MASKWIDTH)(5 downto 0);
	signal   BAR3MASKWIDTH_BINARY  :  std_logic_vector(5 downto 0) := To_StdLogicVector(BAR3MASKWIDTH)(5 downto 0);
	signal   BAR4MASKWIDTH_BINARY  :  std_logic_vector(5 downto 0) := To_StdLogicVector(BAR4MASKWIDTH)(5 downto 0);
	signal   BAR5MASKWIDTH_BINARY  :  std_logic_vector(5 downto 0) := To_StdLogicVector(BAR5MASKWIDTH)(5 downto 0);
	signal   CONFIGROUTING_BINARY  :  std_logic_vector(2 downto 0) := To_StdLogicVector(CONFIGROUTING)(2 downto 0);
	signal   XPDEVICEPORTTYPE_BINARY  :  std_logic_vector(3 downto 0) := To_StdLogicVector(XPDEVICEPORTTYPE);
	signal   HEADERTYPE_BINARY  :  std_logic_vector(7 downto 0) := To_StdLogicVector(HEADERTYPE);
	signal   XPMAXPAYLOAD_BINARY  :  std_logic_vector(2 downto 0);
	signal   XPRCBCONTROL_BINARY  :  std_ulogic;
	signal   LOWPRIORITYVCCOUNT_BINARY  :  std_logic_vector(2 downto 0);
	signal   VENDORID_BINARY  :  std_logic_vector(15 downto 0) := To_StdLogicVector(VENDORID);
	signal   DEVICEID_BINARY  :  std_logic_vector(15 downto 0) := To_StdLogicVector(DEVICEID);
	signal   REVISIONID_BINARY  :  std_logic_vector(7 downto 0) := To_StdLogicVector(REVISIONID);
	signal   CLASSCODE_BINARY  :  std_logic_vector(23 downto 0) := To_StdLogicVector(CLASSCODE);
	signal   CARDBUSCISPOINTER_BINARY  :  std_logic_vector(31 downto 0) := To_StdLogicVector(CARDBUSCISPOINTER);
	signal   SUBSYSTEMVENDORID_BINARY  :  std_logic_vector(15 downto 0) := To_StdLogicVector(SUBSYSTEMVENDORID);
	signal   SUBSYSTEMID_BINARY  :  std_logic_vector(15 downto 0) := To_StdLogicVector(SUBSYSTEMID);
	signal   CAPABILITIESPOINTER_BINARY  :  std_logic_vector(7 downto 0) := To_StdLogicVector(CAPABILITIESPOINTER);
	signal   INTERRUPTPIN_BINARY  :  std_logic_vector(7 downto 0) := To_StdLogicVector(INTERRUPTPIN);
	signal   PMCAPABILITYNEXTPTR_BINARY  :  std_logic_vector(7 downto 0) := To_StdLogicVector(PMCAPABILITYNEXTPTR);
	signal   PMCAPABILITYDSI_BINARY  :  std_ulogic;
	signal   PMCAPABILITYAUXCURRENT_BINARY  :  std_logic_vector(2 downto 0) := To_StdLogicVector(PMCAPABILITYAUXCURRENT)(2 downto 0);
	signal   PMCAPABILITYD1SUPPORT_BINARY  :  std_ulogic;
	signal   PMCAPABILITYD2SUPPORT_BINARY  :  std_ulogic;
	signal   PMCAPABILITYPMESUPPORT_BINARY  :  std_logic_vector(4 downto 0) := To_StdLogicVector(PMCAPABILITYPMESUPPORT)(4 downto 0);
	signal   PMSTATUSCONTROLDATASCALE_BINARY  :  std_logic_vector(1 downto 0) := To_StdLogicVector(PMSTATUSCONTROLDATASCALE)(1 downto 0);
	signal   PMDATA0_BINARY  :  std_logic_vector(7 downto 0) := To_StdLogicVector(PMDATA0);
	signal   PMDATA1_BINARY  :  std_logic_vector(7 downto 0) := To_StdLogicVector(PMDATA1);
	signal   PMDATA2_BINARY  :  std_logic_vector(7 downto 0) := To_StdLogicVector(PMDATA2);
	signal   PMDATA3_BINARY  :  std_logic_vector(7 downto 0) := To_StdLogicVector(PMDATA3);
	signal   PMDATA4_BINARY  :  std_logic_vector(7 downto 0) := To_StdLogicVector(PMDATA4);
	signal   PMDATA5_BINARY  :  std_logic_vector(7 downto 0) := To_StdLogicVector(PMDATA5);
	signal   PMDATA6_BINARY  :  std_logic_vector(7 downto 0) := To_StdLogicVector(PMDATA6);
	signal   PMDATA7_BINARY  :  std_logic_vector(7 downto 0) := To_StdLogicVector(PMDATA7);
	signal   PMDATA8_BINARY  :  std_logic_vector(7 downto 0) := To_StdLogicVector(PMDATA8);
	signal   PMDATASCALE0_BINARY  :  std_logic_vector(1 downto 0);
	signal   PMDATASCALE1_BINARY  :  std_logic_vector(1 downto 0);
	signal   PMDATASCALE2_BINARY  :  std_logic_vector(1 downto 0);
	signal   PMDATASCALE3_BINARY  :  std_logic_vector(1 downto 0);
	signal   PMDATASCALE4_BINARY  :  std_logic_vector(1 downto 0);
	signal   PMDATASCALE5_BINARY  :  std_logic_vector(1 downto 0);
	signal   PMDATASCALE6_BINARY  :  std_logic_vector(1 downto 0);
	signal   PMDATASCALE7_BINARY  :  std_logic_vector(1 downto 0);
	signal   PMDATASCALE8_BINARY  :  std_logic_vector(1 downto 0);
	signal   MSICAPABILITYNEXTPTR_BINARY  :  std_logic_vector(7 downto 0) := To_StdLogicVector(MSICAPABILITYNEXTPTR);
	signal   MSICAPABILITYMULTIMSGCAP_BINARY  :  std_logic_vector(2 downto 0) := To_StdLogicVector(MSICAPABILITYMULTIMSGCAP)(2 downto 0);
	signal   PCIECAPABILITYNEXTPTR_BINARY  :  std_logic_vector(7 downto 0) := To_StdLogicVector(PCIECAPABILITYNEXTPTR);
	signal   PCIECAPABILITYSLOTIMPL_BINARY  :  std_ulogic;
	signal   PCIECAPABILITYINTMSGNUM_BINARY  :  std_logic_vector(4 downto 0) := To_StdLogicVector(PCIECAPABILITYINTMSGNUM)(4 downto 0);
	signal   DEVICECAPABILITYENDPOINTL0SLATENCY_BINARY  :  std_logic_vector(2 downto 0) := To_StdLogicVector(DEVICECAPABILITYENDPOINTL0SLATENCY)(2 downto 0);
	signal   DEVICECAPABILITYENDPOINTL1LATENCY_BINARY  :  std_logic_vector(2 downto 0) := To_StdLogicVector(DEVICECAPABILITYENDPOINTL1LATENCY)(2 downto 0);
	signal   LINKCAPABILITYMAXLINKWIDTH_BINARY  :  std_logic_vector(5 downto 0) := To_StdLogicVector(LINKCAPABILITYMAXLINKWIDTH)(5 downto 0);
	signal   LINKCAPABILITYASPMSUPPORT_BINARY  :  std_logic_vector(1 downto 0) := To_StdLogicVector(LINKCAPABILITYASPMSUPPORT)(1 downto 0);
	signal   LINKSTATUSSLOTCLOCKCONFIG_BINARY  :  std_ulogic;
	signal   SLOTCAPABILITYATTBUTTONPRESENT_BINARY  :  std_ulogic;
	signal   SLOTCAPABILITYPOWERCONTROLLERPRESENT_BINARY  :  std_ulogic;
	signal   SLOTCAPABILITYMSLSENSORPRESENT_BINARY  :  std_ulogic;
	signal   SLOTCAPABILITYATTINDICATORPRESENT_BINARY  :  std_ulogic;
	signal   SLOTCAPABILITYPOWERINDICATORPRESENT_BINARY  :  std_ulogic;
	signal   SLOTCAPABILITYHOTPLUGSURPRISE_BINARY  :  std_ulogic;
	signal   SLOTCAPABILITYHOTPLUGCAPABLE_BINARY  :  std_ulogic;
	signal   SLOTCAPABILITYSLOTPOWERLIMITVALUE_BINARY  :  std_logic_vector(7 downto 0) := To_StdLogicVector(SLOTCAPABILITYSLOTPOWERLIMITVALUE);
	signal   SLOTCAPABILITYSLOTPOWERLIMITSCALE_BINARY  :  std_logic_vector(1 downto 0) := To_StdLogicVector(SLOTCAPABILITYSLOTPOWERLIMITSCALE)(1 downto 0);
	signal   SLOTCAPABILITYPHYSICALSLOTNUM_BINARY  :  std_logic_vector(12 downto 0) := To_StdLogicVector(SLOTCAPABILITYPHYSICALSLOTNUM)(12 downto 0);
	signal   AERCAPABILITYNEXTPTR_BINARY  :  std_logic_vector(11 downto 0) := To_StdLogicVector(AERCAPABILITYNEXTPTR);
	signal   AERCAPABILITYECRCGENCAPABLE_BINARY  :  std_ulogic;
	signal   AERCAPABILITYECRCCHECKCAPABLE_BINARY  :  std_ulogic;
	signal   VCCAPABILITYNEXTPTR_BINARY  :  std_logic_vector(11 downto 0) := To_StdLogicVector(VCCAPABILITYNEXTPTR);
	signal   PORTVCCAPABILITYEXTENDEDVCCOUNT_BINARY  :  std_logic_vector(2 downto 0) := To_StdLogicVector(PORTVCCAPABILITYEXTENDEDVCCOUNT)(2 downto 0);
	signal   PORTVCCAPABILITYVCARBCAP_BINARY  :  std_logic_vector(7 downto 0) := To_StdLogicVector(PORTVCCAPABILITYVCARBCAP);
	signal   PORTVCCAPABILITYVCARBTABLEOFFSET_BINARY  :  std_logic_vector(7 downto 0) := To_StdLogicVector(PORTVCCAPABILITYVCARBTABLEOFFSET);
	signal   DSNCAPABILITYNEXTPTR_BINARY  :  std_logic_vector(11 downto 0) := To_StdLogicVector(DSNCAPABILITYNEXTPTR);
	signal   DEVICESERIALNUMBER_BINARY  :  std_logic_vector(63 downto 0) := To_StdLogicVector(DEVICESERIALNUMBER);
	signal   PBCAPABILITYNEXTPTR_BINARY  :  std_logic_vector(11 downto 0) := To_StdLogicVector(PBCAPABILITYNEXTPTR);
	signal   PBCAPABILITYDW0BASEPOWER_BINARY  :  std_logic_vector(7 downto 0) := To_StdLogicVector(PBCAPABILITYDW0BASEPOWER);
	signal   PBCAPABILITYDW0DATASCALE_BINARY  :  std_logic_vector(1 downto 0) := To_StdLogicVector(PBCAPABILITYDW0DATASCALE)(1 downto 0);
	signal   PBCAPABILITYDW0PMSUBSTATE_BINARY  :  std_logic_vector(2 downto 0) := To_StdLogicVector(PBCAPABILITYDW0PMSUBSTATE)(2 downto 0);
	signal   PBCAPABILITYDW0PMSTATE_BINARY  :  std_logic_vector(1 downto 0) := To_StdLogicVector(PBCAPABILITYDW0PMSTATE)(1 downto 0);
	signal   PBCAPABILITYDW0TYPE_BINARY  :  std_logic_vector(2 downto 0) := To_StdLogicVector(PBCAPABILITYDW0TYPE)(2 downto 0);
	signal   PBCAPABILITYDW0POWERRAIL_BINARY  :  std_logic_vector(2 downto 0) := To_StdLogicVector(PBCAPABILITYDW0POWERRAIL)(2 downto 0);
	signal   PBCAPABILITYDW1BASEPOWER_BINARY  :  std_logic_vector(7 downto 0) := To_StdLogicVector(PBCAPABILITYDW1BASEPOWER);
	signal   PBCAPABILITYDW1DATASCALE_BINARY  :  std_logic_vector(1 downto 0) := To_StdLogicVector(PBCAPABILITYDW1DATASCALE)(1 downto 0);
	signal   PBCAPABILITYDW1PMSUBSTATE_BINARY  :  std_logic_vector(2 downto 0) := To_StdLogicVector(PBCAPABILITYDW1PMSUBSTATE)(2 downto 0);
	signal   PBCAPABILITYDW1PMSTATE_BINARY  :  std_logic_vector(1 downto 0) := To_StdLogicVector(PBCAPABILITYDW1PMSTATE)(1 downto 0);
	signal   PBCAPABILITYDW1TYPE_BINARY  :  std_logic_vector(2 downto 0) := To_StdLogicVector(PBCAPABILITYDW1TYPE)(2 downto 0);
	signal   PBCAPABILITYDW1POWERRAIL_BINARY  :  std_logic_vector(2 downto 0) := To_StdLogicVector(PBCAPABILITYDW1POWERRAIL)(2 downto 0);
	signal   PBCAPABILITYDW2BASEPOWER_BINARY  :  std_logic_vector(7 downto 0) := To_StdLogicVector(PBCAPABILITYDW2BASEPOWER);
	signal   PBCAPABILITYDW2DATASCALE_BINARY  :  std_logic_vector(1 downto 0) := To_StdLogicVector(PBCAPABILITYDW2DATASCALE)(1 downto 0);
	signal   PBCAPABILITYDW2PMSUBSTATE_BINARY  :  std_logic_vector(2 downto 0) := To_StdLogicVector(PBCAPABILITYDW2PMSUBSTATE)(2 downto 0);
	signal   PBCAPABILITYDW2PMSTATE_BINARY  :  std_logic_vector(1 downto 0) := To_StdLogicVector(PBCAPABILITYDW2PMSTATE)(1 downto 0);
	signal   PBCAPABILITYDW2TYPE_BINARY  :  std_logic_vector(2 downto 0) := To_StdLogicVector(PBCAPABILITYDW2TYPE)(2 downto 0);
	signal   PBCAPABILITYDW2POWERRAIL_BINARY  :  std_logic_vector(2 downto 0) := To_StdLogicVector(PBCAPABILITYDW2POWERRAIL)(2 downto 0);
	signal   PBCAPABILITYDW3BASEPOWER_BINARY  :  std_logic_vector(7 downto 0) := To_StdLogicVector(PBCAPABILITYDW3BASEPOWER);
	signal   PBCAPABILITYDW3DATASCALE_BINARY  :  std_logic_vector(1 downto 0) := To_StdLogicVector(PBCAPABILITYDW3DATASCALE)(1 downto 0);
	signal   PBCAPABILITYDW3PMSUBSTATE_BINARY  :  std_logic_vector(2 downto 0) := To_StdLogicVector(PBCAPABILITYDW3PMSUBSTATE)(2 downto 0);
	signal   PBCAPABILITYDW3PMSTATE_BINARY  :  std_logic_vector(1 downto 0) := To_StdLogicVector(PBCAPABILITYDW3PMSTATE)(1 downto 0);
	signal   PBCAPABILITYDW3TYPE_BINARY  :  std_logic_vector(2 downto 0) := To_StdLogicVector(PBCAPABILITYDW3TYPE)(2 downto 0);
	signal   PBCAPABILITYDW3POWERRAIL_BINARY  :  std_logic_vector(2 downto 0) := To_StdLogicVector(PBCAPABILITYDW3POWERRAIL)(2 downto 0);
	signal   PBCAPABILITYSYSTEMALLOCATED_BINARY  :  std_ulogic;
	signal   RESETMODE_BINARY  :  std_ulogic;
	signal   AERBASEPTR_BINARY  :  std_logic_vector(11 downto 0) := To_StdLogicVector(AERBASEPTR);
	signal   DSNBASEPTR_BINARY  :  std_logic_vector(11 downto 0) := To_StdLogicVector(DSNBASEPTR);
	signal   MSIBASEPTR_BINARY  :  std_logic_vector(11 downto 0) := To_StdLogicVector(MSIBASEPTR);
	signal   PBBASEPTR_BINARY  :  std_logic_vector(11 downto 0) := To_StdLogicVector(PBBASEPTR);
	signal   PMBASEPTR_BINARY  :  std_logic_vector(11 downto 0) := To_StdLogicVector(PMBASEPTR);
	signal   VCBASEPTR_BINARY  :  std_logic_vector(11 downto 0) := To_StdLogicVector(VCBASEPTR);
	signal   XPBASEPTR_BINARY  :  std_logic_vector(7 downto 0) := To_StdLogicVector(XPBASEPTR);
	signal   CLKDIVIDED_BINARY  :  std_ulogic;

       	signal   PIPETXDATAL0_out  :  std_logic_vector(7 downto 0);
	signal   PIPETXDATAKL0_out  :  std_ulogic;
	signal   PIPETXELECIDLEL0_out  :  std_ulogic;
	signal   PIPETXDETECTRXLOOPBACKL0_out  :  std_ulogic;
	signal   PIPETXCOMPLIANCEL0_out  :  std_ulogic;
	signal   PIPERXPOLARITYL0_out  :  std_ulogic;
	signal   PIPEPOWERDOWNL0_out  :  std_logic_vector(1 downto 0);
	signal   PIPEDESKEWLANESL0_out  :  std_ulogic;
	signal   PIPERESETL0_out  :  std_ulogic;
	signal   PIPETXDATAL1_out  :  std_logic_vector(7 downto 0);
	signal   PIPETXDATAKL1_out  :  std_ulogic;
	signal   PIPETXELECIDLEL1_out  :  std_ulogic;
	signal   PIPETXDETECTRXLOOPBACKL1_out  :  std_ulogic;
	signal   PIPETXCOMPLIANCEL1_out  :  std_ulogic;
	signal   PIPERXPOLARITYL1_out  :  std_ulogic;
	signal   PIPEPOWERDOWNL1_out  :  std_logic_vector(1 downto 0);
	signal   PIPEDESKEWLANESL1_out  :  std_ulogic;
	signal   PIPERESETL1_out  :  std_ulogic;
	signal   PIPETXDATAL2_out  :  std_logic_vector(7 downto 0);
	signal   PIPETXDATAKL2_out  :  std_ulogic;
	signal   PIPETXELECIDLEL2_out  :  std_ulogic;
	signal   PIPETXDETECTRXLOOPBACKL2_out  :  std_ulogic;
	signal   PIPETXCOMPLIANCEL2_out  :  std_ulogic;
	signal   PIPERXPOLARITYL2_out  :  std_ulogic;
	signal   PIPEPOWERDOWNL2_out  :  std_logic_vector(1 downto 0);
	signal   PIPEDESKEWLANESL2_out  :  std_ulogic;
	signal   PIPERESETL2_out  :  std_ulogic;
	signal   PIPETXDATAL3_out  :  std_logic_vector(7 downto 0);
	signal   PIPETXDATAKL3_out  :  std_ulogic;
	signal   PIPETXELECIDLEL3_out  :  std_ulogic;
	signal   PIPETXDETECTRXLOOPBACKL3_out  :  std_ulogic;
	signal   PIPETXCOMPLIANCEL3_out  :  std_ulogic;
	signal   PIPERXPOLARITYL3_out  :  std_ulogic;
	signal   PIPEPOWERDOWNL3_out  :  std_logic_vector(1 downto 0);
	signal   PIPEDESKEWLANESL3_out  :  std_ulogic;
	signal   PIPERESETL3_out  :  std_ulogic;
	signal   PIPETXDATAL4_out  :  std_logic_vector(7 downto 0);
	signal   PIPETXDATAKL4_out  :  std_ulogic;
	signal   PIPETXELECIDLEL4_out  :  std_ulogic;
	signal   PIPETXDETECTRXLOOPBACKL4_out  :  std_ulogic;
	signal   PIPETXCOMPLIANCEL4_out  :  std_ulogic;
	signal   PIPERXPOLARITYL4_out  :  std_ulogic;
	signal   PIPEPOWERDOWNL4_out  :  std_logic_vector(1 downto 0);
	signal   PIPEDESKEWLANESL4_out  :  std_ulogic;
	signal   PIPERESETL4_out  :  std_ulogic;
	signal   PIPETXDATAL5_out  :  std_logic_vector(7 downto 0);
	signal   PIPETXDATAKL5_out  :  std_ulogic;
	signal   PIPETXELECIDLEL5_out  :  std_ulogic;
	signal   PIPETXDETECTRXLOOPBACKL5_out  :  std_ulogic;
	signal   PIPETXCOMPLIANCEL5_out  :  std_ulogic;
	signal   PIPERXPOLARITYL5_out  :  std_ulogic;
	signal   PIPEPOWERDOWNL5_out  :  std_logic_vector(1 downto 0);
	signal   PIPEDESKEWLANESL5_out  :  std_ulogic;
	signal   PIPERESETL5_out  :  std_ulogic;
	signal   PIPETXDATAL6_out  :  std_logic_vector(7 downto 0);
	signal   PIPETXDATAKL6_out  :  std_ulogic;
	signal   PIPETXELECIDLEL6_out  :  std_ulogic;
	signal   PIPETXDETECTRXLOOPBACKL6_out  :  std_ulogic;
	signal   PIPETXCOMPLIANCEL6_out  :  std_ulogic;
	signal   PIPERXPOLARITYL6_out  :  std_ulogic;
	signal   PIPEPOWERDOWNL6_out  :  std_logic_vector(1 downto 0);
	signal   PIPEDESKEWLANESL6_out  :  std_ulogic;
	signal   PIPERESETL6_out  :  std_ulogic;
	signal   PIPETXDATAL7_out  :  std_logic_vector(7 downto 0);
	signal   PIPETXDATAKL7_out  :  std_ulogic;
	signal   PIPETXELECIDLEL7_out  :  std_ulogic;
	signal   PIPETXDETECTRXLOOPBACKL7_out  :  std_ulogic;
	signal   PIPETXCOMPLIANCEL7_out  :  std_ulogic;
	signal   PIPERXPOLARITYL7_out  :  std_ulogic;
	signal   PIPEPOWERDOWNL7_out  :  std_logic_vector(1 downto 0);
	signal   PIPEDESKEWLANESL7_out  :  std_ulogic;
	signal   PIPERESETL7_out  :  std_ulogic;
	signal   MIMRXBWDATA_out  :  std_logic_vector(63 downto 0);
	signal   MIMRXBWADD_out  :  std_logic_vector(12 downto 0);
	signal   MIMRXBRADD_out  :  std_logic_vector(12 downto 0);
	signal   MIMRXBWEN_out  :  std_ulogic;
	signal   MIMRXBREN_out  :  std_ulogic;
	signal   MIMTXBWDATA_out  :  std_logic_vector(63 downto 0);
	signal   MIMTXBWADD_out  :  std_logic_vector(12 downto 0);
	signal   MIMTXBRADD_out  :  std_logic_vector(12 downto 0);
	signal   MIMTXBWEN_out  :  std_ulogic;
	signal   MIMTXBREN_out  :  std_ulogic;
	signal   MIMDLLBWDATA_out  :  std_logic_vector(63 downto 0);
	signal   MIMDLLBWADD_out  :  std_logic_vector(11 downto 0);
	signal   MIMDLLBRADD_out  :  std_logic_vector(11 downto 0);
	signal   MIMDLLBWEN_out  :  std_ulogic;
	signal   MIMDLLBREN_out  :  std_ulogic;
	signal   CRMRXHOTRESETN_out  :  std_ulogic;
	signal   CRMDOHOTRESETN_out  :  std_ulogic;
	signal   CRMPWRSOFTRESETN_out  :  std_ulogic;
	signal   LLKTCSTATUS_out  :  std_logic_vector(7 downto 0);
	signal   LLKTXDSTRDYN_out  :  std_ulogic;
	signal   LLKTXCHANSPACE_out  :  std_logic_vector(9 downto 0);
	signal   LLKTXCHPOSTEDREADYN_out  :  std_logic_vector(7 downto 0);
	signal   LLKTXCHNONPOSTEDREADYN_out  :  std_logic_vector(7 downto 0);
	signal   LLKTXCHCOMPLETIONREADYN_out  :  std_logic_vector(7 downto 0);
	signal   LLKTXCONFIGREADYN_out  :  std_ulogic;
	signal   LLKRXDATA_out  :  std_logic_vector(63 downto 0);
	signal   LLKRXSRCRDYN_out  :  std_ulogic;
	signal   LLKRXSRCLASTREQN_out  :  std_ulogic;
	signal   LLKRXSRCDSCN_out  :  std_ulogic;
	signal   LLKRXSOFN_out  :  std_ulogic;
	signal   LLKRXEOFN_out  :  std_ulogic;
	signal   LLKRXSOPN_out  :  std_ulogic;
	signal   LLKRXEOPN_out  :  std_ulogic;
	signal   LLKRXVALIDN_out  :  std_logic_vector(1 downto 0);
	signal   LLKRXPREFERREDTYPE_out  :  std_logic_vector(15 downto 0);
	signal   LLKRXCHPOSTEDAVAILABLEN_out  :  std_logic_vector(7 downto 0);
	signal   LLKRXCHNONPOSTEDAVAILABLEN_out  :  std_logic_vector(7 downto 0);
	signal   LLKRXCHCOMPLETIONAVAILABLEN_out  :  std_logic_vector(7 downto 0);
	signal   LLKRXCHCONFIGAVAILABLEN_out  :  std_ulogic;
	signal   LLKRXCHPOSTEDPARTIALN_out  :  std_logic_vector(7 downto 0);
	signal   LLKRXCHNONPOSTEDPARTIALN_out  :  std_logic_vector(7 downto 0);
	signal   LLKRXCHCOMPLETIONPARTIALN_out  :  std_logic_vector(7 downto 0);
	signal   LLKRXCHCONFIGPARTIALN_out  :  std_ulogic;
	signal   LLKRX4DWHEADERN_out  :  std_ulogic;
	signal   LLKRXECRCBADN_out  :  std_ulogic;
	signal   MGMTRDATA_out  :  std_logic_vector(31 downto 0);
	signal   MGMTPSO_out  :  std_logic_vector(16 downto 0);
	signal   MGMTSTATSCREDIT_out  :  std_logic_vector(11 downto 0);
	signal   L0RXDLLTLPECRCOK_out  :  std_ulogic;
	signal   DLLTXPMDLLPOUTSTANDING_out  :  std_ulogic;
	signal   L0FIRSTCFGWRITEOCCURRED_out  :  std_ulogic;
	signal   L0CFGLOOPBACKACK_out  :  std_ulogic;
	signal   L0MACUPSTREAMDOWNSTREAM_out  :  std_ulogic;
	signal   L0RXMACLINKERROR_out  :  std_logic_vector(1 downto 0);
	signal   L0MACLINKUP_out  :  std_ulogic;
	signal   L0MACNEGOTIATEDLINKWIDTH_out  :  std_logic_vector(3 downto 0);
	signal   L0MACLINKTRAINING_out  :  std_ulogic;
	signal   L0LTSSMSTATE_out  :  std_logic_vector(3 downto 0);
	signal   L0DLLVCSTATUS_out  :  std_logic_vector(7 downto 0);
	signal   L0DLUPDOWN_out  :  std_logic_vector(7 downto 0);
	signal   L0DLLERRORVECTOR_out  :  std_logic_vector(6 downto 0);
	signal   L0DLLASRXSTATE_out  :  std_logic_vector(1 downto 0);
	signal   L0DLLASTXSTATE_out  :  std_ulogic;
	signal   L0ASAUTONOMOUSINITCOMPLETED_out  :  std_ulogic;
	signal   L0COMPLETERID_out  :  std_logic_vector(12 downto 0);
	signal   L0UNLOCKRECEIVED_out  :  std_ulogic;
	signal   L0CORRERRMSGRCVD_out  :  std_ulogic;
	signal   L0FATALERRMSGRCVD_out  :  std_ulogic;
	signal   L0NONFATALERRMSGRCVD_out  :  std_ulogic;
	signal   L0ERRMSGREQID_out  :  std_logic_vector(15 downto 0);
	signal   L0FWDCORRERROUT_out  :  std_ulogic;
	signal   L0FWDFATALERROUT_out  :  std_ulogic;
	signal   L0FWDNONFATALERROUT_out  :  std_ulogic;
	signal   L0RECEIVEDASSERTINTALEGACYINT_out  :  std_ulogic;
	signal   L0RECEIVEDASSERTINTBLEGACYINT_out  :  std_ulogic;
	signal   L0RECEIVEDASSERTINTCLEGACYINT_out  :  std_ulogic;
	signal   L0RECEIVEDASSERTINTDLEGACYINT_out  :  std_ulogic;
	signal   L0RECEIVEDDEASSERTINTALEGACYINT_out  :  std_ulogic;
	signal   L0RECEIVEDDEASSERTINTBLEGACYINT_out  :  std_ulogic;
	signal   L0RECEIVEDDEASSERTINTCLEGACYINT_out  :  std_ulogic;
	signal   L0RECEIVEDDEASSERTINTDLEGACYINT_out  :  std_ulogic;
	signal   L0MSIENABLE0_out  :  std_ulogic;
	signal   L0MULTIMSGEN0_out  :  std_logic_vector(2 downto 0);
	signal   L0STATSDLLPRECEIVED_out  :  std_ulogic;
	signal   L0STATSDLLPTRANSMITTED_out  :  std_ulogic;
	signal   L0STATSOSRECEIVED_out  :  std_ulogic;
	signal   L0STATSOSTRANSMITTED_out  :  std_ulogic;
	signal   L0STATSTLPRECEIVED_out  :  std_ulogic;
	signal   L0STATSTLPTRANSMITTED_out  :  std_ulogic;
	signal   L0STATSCFGRECEIVED_out  :  std_ulogic;
	signal   L0STATSCFGTRANSMITTED_out  :  std_ulogic;
	signal   L0STATSCFGOTHERRECEIVED_out  :  std_ulogic;
	signal   L0STATSCFGOTHERTRANSMITTED_out  :  std_ulogic;
	signal   MAXPAYLOADSIZE_out  :  std_logic_vector(2 downto 0);
	signal   MAXREADREQUESTSIZE_out  :  std_logic_vector(2 downto 0);
	signal   IOSPACEENABLE_out  :  std_ulogic;
	signal   MEMSPACEENABLE_out  :  std_ulogic;
	signal   L0ATTENTIONINDICATORCONTROL_out  :  std_logic_vector(1 downto 0);
	signal   L0POWERINDICATORCONTROL_out  :  std_logic_vector(1 downto 0);
	signal   L0POWERCONTROLLERCONTROL_out  :  std_ulogic;
	signal   L0TOGGLEELECTROMECHANICALINTERLOCK_out  :  std_ulogic;
	signal   L0RXBEACON_out  :  std_ulogic;
	signal   L0PWRSTATE0_out  :  std_logic_vector(1 downto 0);
	signal   L0PMEACK_out  :  std_ulogic;
	signal   L0PMEREQOUT_out  :  std_ulogic;
	signal   L0PMEEN_out  :  std_ulogic;
	signal   L0PWRINHIBITTRANSFERS_out  :  std_ulogic;
	signal   L0PWRL1STATE_out  :  std_ulogic;
	signal   L0PWRL23READYDEVICE_out  :  std_ulogic;
	signal   L0PWRL23READYSTATE_out  :  std_ulogic;
	signal   L0PWRTXL0SSTATE_out  :  std_ulogic;
	signal   L0PWRTURNOFFREQ_out  :  std_ulogic;
	signal   L0RXDLLPM_out  :  std_ulogic;
	signal   L0RXDLLPMTYPE_out  :  std_logic_vector(2 downto 0);
	signal   L0TXDLLPMUPDATED_out  :  std_ulogic;
	signal   L0MACNEWSTATEACK_out  :  std_ulogic;
	signal   L0MACRXL0SSTATE_out  :  std_ulogic;
	signal   L0MACENTEREDL0_out  :  std_ulogic;
	signal   L0DLLRXACKOUTSTANDING_out  :  std_ulogic;
	signal   L0DLLTXOUTSTANDING_out  :  std_ulogic;
	signal   L0DLLTXNONFCOUTSTANDING_out  :  std_ulogic;
	signal   L0RXDLLTLPEND_out  :  std_logic_vector(1 downto 0);
	signal   L0TXDLLSBFCUPDATED_out  :  std_ulogic;
	signal   L0RXDLLSBFCDATA_out  :  std_logic_vector(18 downto 0);
	signal   L0RXDLLSBFCUPDATE_out  :  std_ulogic;
	signal   L0TXDLLFCNPOSTBYPUPDATED_out  :  std_logic_vector(7 downto 0);
	signal   L0TXDLLFCPOSTORDUPDATED_out  :  std_logic_vector(7 downto 0);
	signal   L0TXDLLFCCMPLMCUPDATED_out  :  std_logic_vector(7 downto 0);
	signal   L0RXDLLFCNPOSTBYPCRED_out  :  std_logic_vector(19 downto 0);
	signal   L0RXDLLFCNPOSTBYPUPDATE_out  :  std_logic_vector(7 downto 0);
	signal   L0RXDLLFCPOSTORDCRED_out  :  std_logic_vector(23 downto 0);
	signal   L0RXDLLFCPOSTORDUPDATE_out  :  std_logic_vector(7 downto 0);
	signal   L0RXDLLFCCMPLMCCRED_out  :  std_logic_vector(23 downto 0);
	signal   L0RXDLLFCCMPLMCUPDATE_out  :  std_logic_vector(7 downto 0);
	signal   L0UCBYPFOUND_out  :  std_logic_vector(3 downto 0);
	signal   L0UCORDFOUND_out  :  std_logic_vector(3 downto 0);
	signal   L0MCFOUND_out  :  std_logic_vector(2 downto 0);
	signal   L0TRANSFORMEDVC_out  :  std_logic_vector(2 downto 0);
	signal   BUSMASTERENABLE_out  :  std_ulogic;
	signal   PARITYERRORRESPONSE_out  :  std_ulogic;
	signal   SERRENABLE_out  :  std_ulogic;
	signal   INTERRUPTDISABLE_out  :  std_ulogic;
	signal   URREPORTINGENABLE_out  :  std_ulogic;

	signal   PIPETXDATAL0_outdelay  :  std_logic_vector(7 downto 0);
	signal   PIPETXDATAKL0_outdelay  :  std_ulogic;
	signal   PIPETXELECIDLEL0_outdelay  :  std_ulogic;
	signal   PIPETXDETECTRXLOOPBACKL0_outdelay  :  std_ulogic;
	signal   PIPETXCOMPLIANCEL0_outdelay  :  std_ulogic;
	signal   PIPERXPOLARITYL0_outdelay  :  std_ulogic;
	signal   PIPEPOWERDOWNL0_outdelay  :  std_logic_vector(1 downto 0);
	signal   PIPEDESKEWLANESL0_outdelay  :  std_ulogic;
	signal   PIPERESETL0_outdelay  :  std_ulogic;
	signal   PIPETXDATAL1_outdelay  :  std_logic_vector(7 downto 0);
	signal   PIPETXDATAKL1_outdelay  :  std_ulogic;
	signal   PIPETXELECIDLEL1_outdelay  :  std_ulogic;
	signal   PIPETXDETECTRXLOOPBACKL1_outdelay  :  std_ulogic;
	signal   PIPETXCOMPLIANCEL1_outdelay  :  std_ulogic;
	signal   PIPERXPOLARITYL1_outdelay  :  std_ulogic;
	signal   PIPEPOWERDOWNL1_outdelay  :  std_logic_vector(1 downto 0);
	signal   PIPEDESKEWLANESL1_outdelay  :  std_ulogic;
	signal   PIPERESETL1_outdelay  :  std_ulogic;
	signal   PIPETXDATAL2_outdelay  :  std_logic_vector(7 downto 0);
	signal   PIPETXDATAKL2_outdelay  :  std_ulogic;
	signal   PIPETXELECIDLEL2_outdelay  :  std_ulogic;
	signal   PIPETXDETECTRXLOOPBACKL2_outdelay  :  std_ulogic;
	signal   PIPETXCOMPLIANCEL2_outdelay  :  std_ulogic;
	signal   PIPERXPOLARITYL2_outdelay  :  std_ulogic;
	signal   PIPEPOWERDOWNL2_outdelay  :  std_logic_vector(1 downto 0);
	signal   PIPEDESKEWLANESL2_outdelay  :  std_ulogic;
	signal   PIPERESETL2_outdelay  :  std_ulogic;
	signal   PIPETXDATAL3_outdelay  :  std_logic_vector(7 downto 0);
	signal   PIPETXDATAKL3_outdelay  :  std_ulogic;
	signal   PIPETXELECIDLEL3_outdelay  :  std_ulogic;
	signal   PIPETXDETECTRXLOOPBACKL3_outdelay  :  std_ulogic;
	signal   PIPETXCOMPLIANCEL3_outdelay  :  std_ulogic;
	signal   PIPERXPOLARITYL3_outdelay  :  std_ulogic;
	signal   PIPEPOWERDOWNL3_outdelay  :  std_logic_vector(1 downto 0);
	signal   PIPEDESKEWLANESL3_outdelay  :  std_ulogic;
	signal   PIPERESETL3_outdelay  :  std_ulogic;
	signal   PIPETXDATAL4_outdelay  :  std_logic_vector(7 downto 0);
	signal   PIPETXDATAKL4_outdelay  :  std_ulogic;
	signal   PIPETXELECIDLEL4_outdelay  :  std_ulogic;
	signal   PIPETXDETECTRXLOOPBACKL4_outdelay  :  std_ulogic;
	signal   PIPETXCOMPLIANCEL4_outdelay  :  std_ulogic;
	signal   PIPERXPOLARITYL4_outdelay  :  std_ulogic;
	signal   PIPEPOWERDOWNL4_outdelay  :  std_logic_vector(1 downto 0);
	signal   PIPEDESKEWLANESL4_outdelay  :  std_ulogic;
	signal   PIPERESETL4_outdelay  :  std_ulogic;
	signal   PIPETXDATAL5_outdelay  :  std_logic_vector(7 downto 0);
	signal   PIPETXDATAKL5_outdelay  :  std_ulogic;
	signal   PIPETXELECIDLEL5_outdelay  :  std_ulogic;
	signal   PIPETXDETECTRXLOOPBACKL5_outdelay  :  std_ulogic;
	signal   PIPETXCOMPLIANCEL5_outdelay  :  std_ulogic;
	signal   PIPERXPOLARITYL5_outdelay  :  std_ulogic;
	signal   PIPEPOWERDOWNL5_outdelay  :  std_logic_vector(1 downto 0);
	signal   PIPEDESKEWLANESL5_outdelay  :  std_ulogic;
	signal   PIPERESETL5_outdelay  :  std_ulogic;
	signal   PIPETXDATAL6_outdelay  :  std_logic_vector(7 downto 0);
	signal   PIPETXDATAKL6_outdelay  :  std_ulogic;
	signal   PIPETXELECIDLEL6_outdelay  :  std_ulogic;
	signal   PIPETXDETECTRXLOOPBACKL6_outdelay  :  std_ulogic;
	signal   PIPETXCOMPLIANCEL6_outdelay  :  std_ulogic;
	signal   PIPERXPOLARITYL6_outdelay  :  std_ulogic;
	signal   PIPEPOWERDOWNL6_outdelay  :  std_logic_vector(1 downto 0);
	signal   PIPEDESKEWLANESL6_outdelay  :  std_ulogic;
	signal   PIPERESETL6_outdelay  :  std_ulogic;
	signal   PIPETXDATAL7_outdelay  :  std_logic_vector(7 downto 0);
	signal   PIPETXDATAKL7_outdelay  :  std_ulogic;
	signal   PIPETXELECIDLEL7_outdelay  :  std_ulogic;
	signal   PIPETXDETECTRXLOOPBACKL7_outdelay  :  std_ulogic;
	signal   PIPETXCOMPLIANCEL7_outdelay  :  std_ulogic;
	signal   PIPERXPOLARITYL7_outdelay  :  std_ulogic;
	signal   PIPEPOWERDOWNL7_outdelay  :  std_logic_vector(1 downto 0);
	signal   PIPEDESKEWLANESL7_outdelay  :  std_ulogic;
	signal   PIPERESETL7_outdelay  :  std_ulogic;
	signal   MIMRXBWDATA_outdelay  :  std_logic_vector(63 downto 0);
	signal   MIMRXBWADD_outdelay  :  std_logic_vector(12 downto 0);
	signal   MIMRXBRADD_outdelay  :  std_logic_vector(12 downto 0);
	signal   MIMRXBWEN_outdelay  :  std_ulogic;
	signal   MIMRXBREN_outdelay  :  std_ulogic;
	signal   MIMTXBWDATA_outdelay  :  std_logic_vector(63 downto 0);
	signal   MIMTXBWADD_outdelay  :  std_logic_vector(12 downto 0);
	signal   MIMTXBRADD_outdelay  :  std_logic_vector(12 downto 0);
	signal   MIMTXBWEN_outdelay  :  std_ulogic;
	signal   MIMTXBREN_outdelay  :  std_ulogic;
	signal   MIMDLLBWDATA_outdelay  :  std_logic_vector(63 downto 0);
	signal   MIMDLLBWADD_outdelay  :  std_logic_vector(11 downto 0);
	signal   MIMDLLBRADD_outdelay  :  std_logic_vector(11 downto 0);
	signal   MIMDLLBWEN_outdelay  :  std_ulogic;
	signal   MIMDLLBREN_outdelay  :  std_ulogic;
	signal   CRMRXHOTRESETN_outdelay  :  std_ulogic;
	signal   CRMDOHOTRESETN_outdelay  :  std_ulogic;
	signal   CRMPWRSOFTRESETN_outdelay  :  std_ulogic;
	signal   LLKTCSTATUS_outdelay  :  std_logic_vector(7 downto 0);
	signal   LLKTXDSTRDYN_outdelay  :  std_ulogic;
	signal   LLKTXCHANSPACE_outdelay  :  std_logic_vector(9 downto 0);
	signal   LLKTXCHPOSTEDREADYN_outdelay  :  std_logic_vector(7 downto 0);
	signal   LLKTXCHNONPOSTEDREADYN_outdelay  :  std_logic_vector(7 downto 0);
	signal   LLKTXCHCOMPLETIONREADYN_outdelay  :  std_logic_vector(7 downto 0);
	signal   LLKTXCONFIGREADYN_outdelay  :  std_ulogic;
	signal   LLKRXDATA_outdelay  :  std_logic_vector(63 downto 0);
	signal   LLKRXSRCRDYN_outdelay  :  std_ulogic;
	signal   LLKRXSRCLASTREQN_outdelay  :  std_ulogic;
	signal   LLKRXSRCDSCN_outdelay  :  std_ulogic;
	signal   LLKRXSOFN_outdelay  :  std_ulogic;
	signal   LLKRXEOFN_outdelay  :  std_ulogic;
	signal   LLKRXSOPN_outdelay  :  std_ulogic;
	signal   LLKRXEOPN_outdelay  :  std_ulogic;
	signal   LLKRXVALIDN_outdelay  :  std_logic_vector(1 downto 0);
	signal   LLKRXPREFERREDTYPE_outdelay  :  std_logic_vector(15 downto 0);
	signal   LLKRXCHPOSTEDAVAILABLEN_outdelay  :  std_logic_vector(7 downto 0);
	signal   LLKRXCHNONPOSTEDAVAILABLEN_outdelay  :  std_logic_vector(7 downto 0);
	signal   LLKRXCHCOMPLETIONAVAILABLEN_outdelay  :  std_logic_vector(7 downto 0);
	signal   LLKRXCHCONFIGAVAILABLEN_outdelay  :  std_ulogic;
	signal   LLKRXCHPOSTEDPARTIALN_outdelay  :  std_logic_vector(7 downto 0);
	signal   LLKRXCHNONPOSTEDPARTIALN_outdelay  :  std_logic_vector(7 downto 0);
	signal   LLKRXCHCOMPLETIONPARTIALN_outdelay  :  std_logic_vector(7 downto 0);
	signal   LLKRXCHCONFIGPARTIALN_outdelay  :  std_ulogic;
	signal   LLKRX4DWHEADERN_outdelay  :  std_ulogic;
	signal   LLKRXECRCBADN_outdelay  :  std_ulogic;
	signal   MGMTRDATA_outdelay  :  std_logic_vector(31 downto 0);
	signal   MGMTPSO_outdelay  :  std_logic_vector(16 downto 0);
	signal   MGMTSTATSCREDIT_outdelay  :  std_logic_vector(11 downto 0);
	signal   L0RXDLLTLPECRCOK_outdelay  :  std_ulogic;
	signal   DLLTXPMDLLPOUTSTANDING_outdelay  :  std_ulogic;
	signal   L0FIRSTCFGWRITEOCCURRED_outdelay  :  std_ulogic;
	signal   L0CFGLOOPBACKACK_outdelay  :  std_ulogic;
	signal   L0MACUPSTREAMDOWNSTREAM_outdelay  :  std_ulogic;
	signal   L0RXMACLINKERROR_outdelay  :  std_logic_vector(1 downto 0);
	signal   L0MACLINKUP_outdelay  :  std_ulogic;
	signal   L0MACNEGOTIATEDLINKWIDTH_outdelay  :  std_logic_vector(3 downto 0);
	signal   L0MACLINKTRAINING_outdelay  :  std_ulogic;
	signal   L0LTSSMSTATE_outdelay  :  std_logic_vector(3 downto 0);
	signal   L0DLLVCSTATUS_outdelay  :  std_logic_vector(7 downto 0);
	signal   L0DLUPDOWN_outdelay  :  std_logic_vector(7 downto 0);
	signal   L0DLLERRORVECTOR_outdelay  :  std_logic_vector(6 downto 0);
	signal   L0DLLASRXSTATE_outdelay  :  std_logic_vector(1 downto 0);
	signal   L0DLLASTXSTATE_outdelay  :  std_ulogic;
	signal   L0ASAUTONOMOUSINITCOMPLETED_outdelay  :  std_ulogic;
	signal   L0COMPLETERID_outdelay  :  std_logic_vector(12 downto 0);
	signal   L0UNLOCKRECEIVED_outdelay  :  std_ulogic;
	signal   L0CORRERRMSGRCVD_outdelay  :  std_ulogic;
	signal   L0FATALERRMSGRCVD_outdelay  :  std_ulogic;
	signal   L0NONFATALERRMSGRCVD_outdelay  :  std_ulogic;
	signal   L0ERRMSGREQID_outdelay  :  std_logic_vector(15 downto 0);
	signal   L0FWDCORRERROUT_outdelay  :  std_ulogic;
	signal   L0FWDFATALERROUT_outdelay  :  std_ulogic;
	signal   L0FWDNONFATALERROUT_outdelay  :  std_ulogic;
	signal   L0RECEIVEDASSERTINTALEGACYINT_outdelay  :  std_ulogic;
	signal   L0RECEIVEDASSERTINTBLEGACYINT_outdelay  :  std_ulogic;
	signal   L0RECEIVEDASSERTINTCLEGACYINT_outdelay  :  std_ulogic;
	signal   L0RECEIVEDASSERTINTDLEGACYINT_outdelay  :  std_ulogic;
	signal   L0RECEIVEDDEASSERTINTALEGACYINT_outdelay  :  std_ulogic;
	signal   L0RECEIVEDDEASSERTINTBLEGACYINT_outdelay  :  std_ulogic;
	signal   L0RECEIVEDDEASSERTINTCLEGACYINT_outdelay  :  std_ulogic;
	signal   L0RECEIVEDDEASSERTINTDLEGACYINT_outdelay  :  std_ulogic;
	signal   L0MSIENABLE0_outdelay  :  std_ulogic;
	signal   L0MULTIMSGEN0_outdelay  :  std_logic_vector(2 downto 0);
	signal   L0STATSDLLPRECEIVED_outdelay  :  std_ulogic;
	signal   L0STATSDLLPTRANSMITTED_outdelay  :  std_ulogic;
	signal   L0STATSOSRECEIVED_outdelay  :  std_ulogic;
	signal   L0STATSOSTRANSMITTED_outdelay  :  std_ulogic;
	signal   L0STATSTLPRECEIVED_outdelay  :  std_ulogic;
	signal   L0STATSTLPTRANSMITTED_outdelay  :  std_ulogic;
	signal   L0STATSCFGRECEIVED_outdelay  :  std_ulogic;
	signal   L0STATSCFGTRANSMITTED_outdelay  :  std_ulogic;
	signal   L0STATSCFGOTHERRECEIVED_outdelay  :  std_ulogic;
	signal   L0STATSCFGOTHERTRANSMITTED_outdelay  :  std_ulogic;
	signal   MAXPAYLOADSIZE_outdelay  :  std_logic_vector(2 downto 0);
	signal   MAXREADREQUESTSIZE_outdelay  :  std_logic_vector(2 downto 0);
	signal   IOSPACEENABLE_outdelay  :  std_ulogic;
	signal   MEMSPACEENABLE_outdelay  :  std_ulogic;
	signal   L0ATTENTIONINDICATORCONTROL_outdelay  :  std_logic_vector(1 downto 0);
	signal   L0POWERINDICATORCONTROL_outdelay  :  std_logic_vector(1 downto 0);
	signal   L0POWERCONTROLLERCONTROL_outdelay  :  std_ulogic;
	signal   L0TOGGLEELECTROMECHANICALINTERLOCK_outdelay  :  std_ulogic;
	signal   L0RXBEACON_outdelay  :  std_ulogic;
	signal   L0PWRSTATE0_outdelay  :  std_logic_vector(1 downto 0);
	signal   L0PMEACK_outdelay  :  std_ulogic;
	signal   L0PMEREQOUT_outdelay  :  std_ulogic;
	signal   L0PMEEN_outdelay  :  std_ulogic;
	signal   L0PWRINHIBITTRANSFERS_outdelay  :  std_ulogic;
	signal   L0PWRL1STATE_outdelay  :  std_ulogic;
	signal   L0PWRL23READYDEVICE_outdelay  :  std_ulogic;
	signal   L0PWRL23READYSTATE_outdelay  :  std_ulogic;
	signal   L0PWRTXL0SSTATE_outdelay  :  std_ulogic;
	signal   L0PWRTURNOFFREQ_outdelay  :  std_ulogic;
	signal   L0RXDLLPM_outdelay  :  std_ulogic;
	signal   L0RXDLLPMTYPE_outdelay  :  std_logic_vector(2 downto 0);
	signal   L0TXDLLPMUPDATED_outdelay  :  std_ulogic;
	signal   L0MACNEWSTATEACK_outdelay  :  std_ulogic;
	signal   L0MACRXL0SSTATE_outdelay  :  std_ulogic;
	signal   L0MACENTEREDL0_outdelay  :  std_ulogic;
	signal   L0DLLRXACKOUTSTANDING_outdelay  :  std_ulogic;
	signal   L0DLLTXOUTSTANDING_outdelay  :  std_ulogic;
	signal   L0DLLTXNONFCOUTSTANDING_outdelay  :  std_ulogic;
	signal   L0RXDLLTLPEND_outdelay  :  std_logic_vector(1 downto 0);
	signal   L0TXDLLSBFCUPDATED_outdelay  :  std_ulogic;
	signal   L0RXDLLSBFCDATA_outdelay  :  std_logic_vector(18 downto 0);
	signal   L0RXDLLSBFCUPDATE_outdelay  :  std_ulogic;
	signal   L0TXDLLFCNPOSTBYPUPDATED_outdelay  :  std_logic_vector(7 downto 0);
	signal   L0TXDLLFCPOSTORDUPDATED_outdelay  :  std_logic_vector(7 downto 0);
	signal   L0TXDLLFCCMPLMCUPDATED_outdelay  :  std_logic_vector(7 downto 0);
	signal   L0RXDLLFCNPOSTBYPCRED_outdelay  :  std_logic_vector(19 downto 0);
	signal   L0RXDLLFCNPOSTBYPUPDATE_outdelay  :  std_logic_vector(7 downto 0);
	signal   L0RXDLLFCPOSTORDCRED_outdelay  :  std_logic_vector(23 downto 0);
	signal   L0RXDLLFCPOSTORDUPDATE_outdelay  :  std_logic_vector(7 downto 0);
	signal   L0RXDLLFCCMPLMCCRED_outdelay  :  std_logic_vector(23 downto 0);
	signal   L0RXDLLFCCMPLMCUPDATE_outdelay  :  std_logic_vector(7 downto 0);
	signal   L0UCBYPFOUND_outdelay  :  std_logic_vector(3 downto 0);
	signal   L0UCORDFOUND_outdelay  :  std_logic_vector(3 downto 0);
	signal   L0MCFOUND_outdelay  :  std_logic_vector(2 downto 0);
	signal   L0TRANSFORMEDVC_outdelay  :  std_logic_vector(2 downto 0);
	signal   BUSMASTERENABLE_outdelay  :  std_ulogic;
	signal   PARITYERRORRESPONSE_outdelay  :  std_ulogic;
	signal   SERRENABLE_outdelay  :  std_ulogic;
	signal   INTERRUPTDISABLE_outdelay  :  std_ulogic;
	signal   URREPORTINGENABLE_outdelay  :  std_ulogic;

	signal   PIPERXELECIDLEL0_ipd  :  std_ulogic;
	signal   PIPERXSTATUSL0_ipd  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL0_ipd  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL0_ipd  :  std_ulogic;
	signal   PIPERXDATAKL0_ipd  :  std_ulogic;
	signal   PIPERXVALIDL0_ipd  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL0_ipd  :  std_ulogic;
	signal   PIPERXELECIDLEL1_ipd  :  std_ulogic;
	signal   PIPERXSTATUSL1_ipd  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL1_ipd  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL1_ipd  :  std_ulogic;
	signal   PIPERXDATAKL1_ipd  :  std_ulogic;
	signal   PIPERXVALIDL1_ipd  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL1_ipd  :  std_ulogic;
	signal   PIPERXELECIDLEL2_ipd  :  std_ulogic;
	signal   PIPERXSTATUSL2_ipd  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL2_ipd  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL2_ipd  :  std_ulogic;
	signal   PIPERXDATAKL2_ipd  :  std_ulogic;
	signal   PIPERXVALIDL2_ipd  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL2_ipd  :  std_ulogic;
	signal   PIPERXELECIDLEL3_ipd  :  std_ulogic;
	signal   PIPERXSTATUSL3_ipd  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL3_ipd  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL3_ipd  :  std_ulogic;
	signal   PIPERXDATAKL3_ipd  :  std_ulogic;
	signal   PIPERXVALIDL3_ipd  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL3_ipd  :  std_ulogic;
	signal   PIPERXELECIDLEL4_ipd  :  std_ulogic;
	signal   PIPERXSTATUSL4_ipd  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL4_ipd  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL4_ipd  :  std_ulogic;
	signal   PIPERXDATAKL4_ipd  :  std_ulogic;
	signal   PIPERXVALIDL4_ipd  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL4_ipd  :  std_ulogic;
	signal   PIPERXELECIDLEL5_ipd  :  std_ulogic;
	signal   PIPERXSTATUSL5_ipd  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL5_ipd  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL5_ipd  :  std_ulogic;
	signal   PIPERXDATAKL5_ipd  :  std_ulogic;
	signal   PIPERXVALIDL5_ipd  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL5_ipd  :  std_ulogic;
	signal   PIPERXELECIDLEL6_ipd  :  std_ulogic;
	signal   PIPERXSTATUSL6_ipd  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL6_ipd  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL6_ipd  :  std_ulogic;
	signal   PIPERXDATAKL6_ipd  :  std_ulogic;
	signal   PIPERXVALIDL6_ipd  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL6_ipd  :  std_ulogic;
	signal   PIPERXELECIDLEL7_ipd  :  std_ulogic;
	signal   PIPERXSTATUSL7_ipd  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL7_ipd  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL7_ipd  :  std_ulogic;
	signal   PIPERXDATAKL7_ipd  :  std_ulogic;
	signal   PIPERXVALIDL7_ipd  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL7_ipd  :  std_ulogic;
	signal   MIMRXBRDATA_ipd  :  std_logic_vector(63 downto 0);
	signal   CRMCORECLKRXO_ipd  :  std_ulogic;
	signal   CRMUSERCLKRXO_ipd  :  std_ulogic;
	signal   MIMTXBRDATA_ipd  :  std_logic_vector(63 downto 0);
	signal   CRMCORECLKTXO_ipd  :  std_ulogic;
	signal   CRMUSERCLKTXO_ipd  :  std_ulogic;
	signal   MIMDLLBRDATA_ipd  :  std_logic_vector(63 downto 0);
	signal   CRMCORECLKDLO_ipd  :  std_ulogic;
	signal   CRMCORECLK_ipd  :  std_ulogic;
	signal   CRMUSERCLK_ipd  :  std_ulogic;
	signal   CRMURSTN_ipd  :  std_ulogic;
	signal   CRMNVRSTN_ipd  :  std_ulogic;
	signal   CRMMGMTRSTN_ipd  :  std_ulogic;
	signal   CRMUSERCFGRSTN_ipd  :  std_ulogic;
	signal   CRMMACRSTN_ipd  :  std_ulogic;
	signal   CRMLINKRSTN_ipd  :  std_ulogic;
	signal   CRMTXHOTRESETN_ipd  :  std_ulogic;
	signal   CRMCFGBRIDGEHOTRESET_ipd  :  std_ulogic;
	signal   LLKTXDATA_ipd  :  std_logic_vector(63 downto 0);
	signal   LLKTXSRCRDYN_ipd  :  std_ulogic;
	signal   LLKTXSRCDSCN_ipd  :  std_ulogic;
	signal   LLKTXCOMPLETEN_ipd  :  std_ulogic;
	signal   LLKTXSOFN_ipd  :  std_ulogic;
	signal   LLKTXEOFN_ipd  :  std_ulogic;
	signal   LLKTXSOPN_ipd  :  std_ulogic;
	signal   LLKTXEOPN_ipd  :  std_ulogic;
	signal   LLKTXENABLEN_ipd  :  std_logic_vector(1 downto 0);
	signal   LLKTXCHTC_ipd  :  std_logic_vector(2 downto 0);
	signal   LLKTXCHFIFO_ipd  :  std_logic_vector(1 downto 0);
	signal   LLKTXCREATEECRCN_ipd  :  std_ulogic;
	signal   LLKTX4DWHEADERN_ipd  :  std_ulogic;
	signal   LLKRXDSTREQN_ipd  :  std_ulogic;
	signal   LLKRXCHTC_ipd  :  std_logic_vector(2 downto 0);
	signal   LLKRXCHFIFO_ipd  :  std_logic_vector(1 downto 0);
	signal   LLKRXDSTCONTREQN_ipd  :  std_ulogic;
	signal   MGMTWDATA_ipd  :  std_logic_vector(31 downto 0);
	signal   MGMTBWREN_ipd  :  std_logic_vector(3 downto 0);
	signal   MGMTWREN_ipd  :  std_ulogic;
	signal   MGMTADDR_ipd  :  std_logic_vector(10 downto 0);
	signal   MGMTRDEN_ipd  :  std_ulogic;
	signal   MGMTSTATSCREDITSEL_ipd  :  std_logic_vector(6 downto 0);
	signal   MAINPOWER_ipd  :  std_ulogic;
	signal   AUXPOWER_ipd  :  std_ulogic;
	signal   L0TLLINKRETRAIN_ipd  :  std_ulogic;
	signal   CFGNEGOTIATEDLINKWIDTH_ipd  :  std_logic_vector(5 downto 0);
	signal   CROSSLINKSEED_ipd  :  std_ulogic;
	signal   COMPLIANCEAVOID_ipd  :  std_ulogic;
	signal   L0VC0PREVIEWEXPAND_ipd  :  std_ulogic;
	signal   L0CFGVCID_ipd  :  std_logic_vector(23 downto 0);
	signal   L0CFGLOOPBACKMASTER_ipd  :  std_ulogic;
	signal   L0REPLAYTIMERADJUSTMENT_ipd  :  std_logic_vector(11 downto 0);
	signal   L0ACKNAKTIMERADJUSTMENT_ipd  :  std_logic_vector(11 downto 0);
	signal   L0DLLHOLDLINKUP_ipd  :  std_ulogic;
	signal   L0CFGASSTATECHANGECMD_ipd  :  std_logic_vector(3 downto 0);
	signal   L0CFGASSPANTREEOWNEDSTATE_ipd  :  std_ulogic;
	signal   L0ASE_ipd  :  std_ulogic;
	signal   L0ASTURNPOOLBITSCONSUMED_ipd  :  std_logic_vector(2 downto 0);
	signal   L0ASPORTCOUNT_ipd  :  std_logic_vector(7 downto 0);
	signal   L0CFGVCENABLE_ipd  :  std_logic_vector(7 downto 0);
	signal   L0CFGNEGOTIATEDMAXP_ipd  :  std_logic_vector(2 downto 0);
	signal   L0CFGDISABLESCRAMBLE_ipd  :  std_ulogic;
	signal   L0CFGEXTENDEDSYNC_ipd  :  std_ulogic;
	signal   L0CFGLINKDISABLE_ipd  :  std_ulogic;
	signal   L0PORTNUMBER_ipd  :  std_logic_vector(7 downto 0);
	signal   L0SENDUNLOCKMESSAGE_ipd  :  std_ulogic;
	signal   L0ALLDOWNRXPORTSINL0S_ipd  :  std_ulogic;
	signal   L0UPSTREAMRXPORTINL0S_ipd  :  std_ulogic;
	signal   L0TRANSACTIONSPENDING_ipd  :  std_ulogic;
	signal   L0ALLDOWNPORTSINL1_ipd  :  std_ulogic;
	signal   L0FWDCORRERRIN_ipd  :  std_ulogic;
	signal   L0FWDFATALERRIN_ipd  :  std_ulogic;
	signal   L0FWDNONFATALERRIN_ipd  :  std_ulogic;
	signal   L0SETCOMPLETERABORTERROR_ipd  :  std_ulogic;
	signal   L0SETDETECTEDCORRERROR_ipd  :  std_ulogic;
	signal   L0SETDETECTEDFATALERROR_ipd  :  std_ulogic;
	signal   L0SETDETECTEDNONFATALERROR_ipd  :  std_ulogic;
	signal   L0SETLINKDETECTEDPARITYERROR_ipd  :  std_ulogic;
	signal   L0SETLINKMASTERDATAPARITY_ipd  :  std_ulogic;
	signal   L0SETLINKRECEIVEDMASTERABORT_ipd  :  std_ulogic;
	signal   L0SETLINKRECEIVEDTARGETABORT_ipd  :  std_ulogic;
	signal   L0SETLINKSYSTEMERROR_ipd  :  std_ulogic;
	signal   L0SETLINKSIGNALLEDTARGETABORT_ipd  :  std_ulogic;
	signal   L0SETUSERDETECTEDPARITYERROR_ipd  :  std_ulogic;
	signal   L0SETUSERMASTERDATAPARITY_ipd  :  std_ulogic;
	signal   L0SETUSERRECEIVEDMASTERABORT_ipd  :  std_ulogic;
	signal   L0SETUSERRECEIVEDTARGETABORT_ipd  :  std_ulogic;
	signal   L0SETUSERSYSTEMERROR_ipd  :  std_ulogic;
	signal   L0SETUSERSIGNALLEDTARGETABORT_ipd  :  std_ulogic;
	signal   L0SETCOMPLETIONTIMEOUTUNCORRERROR_ipd  :  std_ulogic;
	signal   L0SETCOMPLETIONTIMEOUTCORRERROR_ipd  :  std_ulogic;
	signal   L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_ipd  :  std_ulogic;
	signal   L0SETUNEXPECTEDCOMPLETIONCORRERROR_ipd  :  std_ulogic;
	signal   L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_ipd  :  std_ulogic;
	signal   L0SETUNSUPPORTEDREQUESTOTHERERROR_ipd  :  std_ulogic;
	signal   L0PACKETHEADERFROMUSER_ipd  :  std_logic_vector(127 downto 0);
	signal   L0LEGACYINTFUNCT0_ipd  :  std_ulogic;
	signal   L0FWDASSERTINTALEGACYINT_ipd  :  std_ulogic;
	signal   L0FWDASSERTINTBLEGACYINT_ipd  :  std_ulogic;
	signal   L0FWDASSERTINTCLEGACYINT_ipd  :  std_ulogic;
	signal   L0FWDASSERTINTDLEGACYINT_ipd  :  std_ulogic;
	signal   L0FWDDEASSERTINTALEGACYINT_ipd  :  std_ulogic;
	signal   L0FWDDEASSERTINTBLEGACYINT_ipd  :  std_ulogic;
	signal   L0FWDDEASSERTINTCLEGACYINT_ipd  :  std_ulogic;
	signal   L0FWDDEASSERTINTDLEGACYINT_ipd  :  std_ulogic;
	signal   L0MSIREQUEST0_ipd  :  std_logic_vector(3 downto 0);
	signal   L0ELECTROMECHANICALINTERLOCKENGAGED_ipd  :  std_ulogic;
	signal   L0MRLSENSORCLOSEDN_ipd  :  std_ulogic;
	signal   L0POWERFAULTDETECTED_ipd  :  std_ulogic;
	signal   L0PRESENCEDETECTSLOTEMPTYN_ipd  :  std_ulogic;
	signal   L0ATTENTIONBUTTONPRESSED_ipd  :  std_ulogic;
	signal   L0TXBEACON_ipd  :  std_ulogic;
	signal   L0WAKEN_ipd  :  std_ulogic;
	signal   L0PMEREQIN_ipd  :  std_ulogic;
	signal   L0ROOTTURNOFFREQ_ipd  :  std_ulogic;
	signal   L0TXCFGPM_ipd  :  std_ulogic;
	signal   L0TXCFGPMTYPE_ipd  :  std_logic_vector(2 downto 0);
	signal   L0PWRNEWSTATEREQ_ipd  :  std_ulogic;
	signal   L0PWRNEXTLINKSTATE_ipd  :  std_logic_vector(1 downto 0);
	signal   L0CFGL0SENTRYSUP_ipd  :  std_ulogic;
	signal   L0CFGL0SENTRYENABLE_ipd  :  std_ulogic;
	signal   L0CFGL0SEXITLAT_ipd  :  std_logic_vector(2 downto 0);
	signal   L0TXTLTLPDATA_ipd  :  std_logic_vector(63 downto 0);
	signal   L0TXTLTLPEND_ipd  :  std_logic_vector(1 downto 0);
	signal   L0TXTLTLPENABLE_ipd  :  std_logic_vector(1 downto 0);
	signal   L0TXTLTLPEDB_ipd  :  std_ulogic;
	signal   L0TXTLTLPREQ_ipd  :  std_ulogic;
	signal   L0TXTLTLPREQEND_ipd  :  std_ulogic;
	signal   L0TXTLTLPWIDTH_ipd  :  std_ulogic;
	signal   L0TXTLTLPLATENCY_ipd  :  std_logic_vector(3 downto 0);
	signal   L0TLASFCCREDSTARVATION_ipd  :  std_ulogic;
	signal   L0TXTLSBFCDATA_ipd  :  std_logic_vector(18 downto 0);
	signal   L0TXTLSBFCUPDATE_ipd  :  std_ulogic;
	signal   L0TXTLFCNPOSTBYPCRED_ipd  :  std_logic_vector(191 downto 0);
	signal   L0TXTLFCNPOSTBYPUPDATE_ipd  :  std_logic_vector(15 downto 0);
	signal   L0TXTLFCPOSTORDCRED_ipd  :  std_logic_vector(159 downto 0);
	signal   L0TXTLFCPOSTORDUPDATE_ipd  :  std_logic_vector(15 downto 0);
	signal   L0TXTLFCCMPLMCCRED_ipd  :  std_logic_vector(159 downto 0);
	signal   L0TXTLFCCMPLMCUPDATE_ipd  :  std_logic_vector(15 downto 0);
	signal   L0RXTLTLPNONINITIALIZEDVC_ipd  :  std_logic_vector(7 downto 0);

	signal   PIPERXELECIDLEL0_dly  :  std_ulogic;
	signal   PIPERXSTATUSL0_dly  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL0_dly  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL0_dly  :  std_ulogic;
	signal   PIPERXDATAKL0_dly  :  std_ulogic;
	signal   PIPERXVALIDL0_dly  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL0_dly  :  std_ulogic;
	signal   PIPERXELECIDLEL1_dly  :  std_ulogic;
	signal   PIPERXSTATUSL1_dly  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL1_dly  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL1_dly  :  std_ulogic;
	signal   PIPERXDATAKL1_dly  :  std_ulogic;
	signal   PIPERXVALIDL1_dly  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL1_dly  :  std_ulogic;
	signal   PIPERXELECIDLEL2_dly  :  std_ulogic;
	signal   PIPERXSTATUSL2_dly  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL2_dly  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL2_dly  :  std_ulogic;
	signal   PIPERXDATAKL2_dly  :  std_ulogic;
	signal   PIPERXVALIDL2_dly  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL2_dly  :  std_ulogic;
	signal   PIPERXELECIDLEL3_dly  :  std_ulogic;
	signal   PIPERXSTATUSL3_dly  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL3_dly  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL3_dly  :  std_ulogic;
	signal   PIPERXDATAKL3_dly  :  std_ulogic;
	signal   PIPERXVALIDL3_dly  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL3_dly  :  std_ulogic;
	signal   PIPERXELECIDLEL4_dly  :  std_ulogic;
	signal   PIPERXSTATUSL4_dly  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL4_dly  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL4_dly  :  std_ulogic;
	signal   PIPERXDATAKL4_dly  :  std_ulogic;
	signal   PIPERXVALIDL4_dly  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL4_dly  :  std_ulogic;
	signal   PIPERXELECIDLEL5_dly  :  std_ulogic;
	signal   PIPERXSTATUSL5_dly  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL5_dly  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL5_dly  :  std_ulogic;
	signal   PIPERXDATAKL5_dly  :  std_ulogic;
	signal   PIPERXVALIDL5_dly  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL5_dly  :  std_ulogic;
	signal   PIPERXELECIDLEL6_dly  :  std_ulogic;
	signal   PIPERXSTATUSL6_dly  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL6_dly  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL6_dly  :  std_ulogic;
	signal   PIPERXDATAKL6_dly  :  std_ulogic;
	signal   PIPERXVALIDL6_dly  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL6_dly  :  std_ulogic;
	signal   PIPERXELECIDLEL7_dly  :  std_ulogic;
	signal   PIPERXSTATUSL7_dly  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL7_dly  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL7_dly  :  std_ulogic;
	signal   PIPERXDATAKL7_dly  :  std_ulogic;
	signal   PIPERXVALIDL7_dly  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL7_dly  :  std_ulogic;
	signal   MIMRXBRDATA_dly  :  std_logic_vector(63 downto 0);
	signal   CRMCORECLKRXO_dly  :  std_ulogic;
	signal   CRMUSERCLKRXO_dly  :  std_ulogic;
	signal   MIMTXBRDATA_dly  :  std_logic_vector(63 downto 0);
	signal   CRMCORECLKTXO_dly  :  std_ulogic;
	signal   CRMUSERCLKTXO_dly  :  std_ulogic;
	signal   MIMDLLBRDATA_dly  :  std_logic_vector(63 downto 0);
	signal   CRMCORECLKDLO_dly  :  std_ulogic;
	signal   CRMCORECLK_dly  :  std_ulogic;
	signal   CRMUSERCLK_dly  :  std_ulogic;
	signal   CRMURSTN_dly  :  std_ulogic;
	signal   CRMNVRSTN_dly  :  std_ulogic;
	signal   CRMMGMTRSTN_dly  :  std_ulogic;
	signal   CRMUSERCFGRSTN_dly  :  std_ulogic;
	signal   CRMMACRSTN_dly  :  std_ulogic;
	signal   CRMLINKRSTN_dly  :  std_ulogic;
	signal   CRMTXHOTRESETN_dly  :  std_ulogic;
	signal   CRMCFGBRIDGEHOTRESET_dly  :  std_ulogic;
	signal   LLKTXDATA_dly  :  std_logic_vector(63 downto 0);
	signal   LLKTXSRCRDYN_dly  :  std_ulogic;
	signal   LLKTXSRCDSCN_dly  :  std_ulogic;
	signal   LLKTXCOMPLETEN_dly  :  std_ulogic;
	signal   LLKTXSOFN_dly  :  std_ulogic;
	signal   LLKTXEOFN_dly  :  std_ulogic;
	signal   LLKTXSOPN_dly  :  std_ulogic;
	signal   LLKTXEOPN_dly  :  std_ulogic;
	signal   LLKTXENABLEN_dly  :  std_logic_vector(1 downto 0);
	signal   LLKTXCHTC_dly  :  std_logic_vector(2 downto 0);
	signal   LLKTXCHFIFO_dly  :  std_logic_vector(1 downto 0);
	signal   LLKTXCREATEECRCN_dly  :  std_ulogic;
	signal   LLKTX4DWHEADERN_dly  :  std_ulogic;
	signal   LLKRXDSTREQN_dly  :  std_ulogic;
	signal   LLKRXCHTC_dly  :  std_logic_vector(2 downto 0);
	signal   LLKRXCHFIFO_dly  :  std_logic_vector(1 downto 0);
	signal   LLKRXDSTCONTREQN_dly  :  std_ulogic;
	signal   MGMTWDATA_dly  :  std_logic_vector(31 downto 0);
	signal   MGMTBWREN_dly  :  std_logic_vector(3 downto 0);
	signal   MGMTWREN_dly  :  std_ulogic;
	signal   MGMTADDR_dly  :  std_logic_vector(10 downto 0);
	signal   MGMTRDEN_dly  :  std_ulogic;
	signal   MGMTSTATSCREDITSEL_dly  :  std_logic_vector(6 downto 0);
	signal   MAINPOWER_dly  :  std_ulogic;
	signal   AUXPOWER_dly  :  std_ulogic;
	signal   L0TLLINKRETRAIN_dly  :  std_ulogic;
	signal   CFGNEGOTIATEDLINKWIDTH_dly  :  std_logic_vector(5 downto 0);
	signal   CROSSLINKSEED_dly  :  std_ulogic;
	signal   COMPLIANCEAVOID_dly  :  std_ulogic;
	signal   L0VC0PREVIEWEXPAND_dly  :  std_ulogic;
	signal   L0CFGVCID_dly  :  std_logic_vector(23 downto 0);
	signal   L0CFGLOOPBACKMASTER_dly  :  std_ulogic;
	signal   L0REPLAYTIMERADJUSTMENT_dly  :  std_logic_vector(11 downto 0);
	signal   L0ACKNAKTIMERADJUSTMENT_dly  :  std_logic_vector(11 downto 0);
	signal   L0DLLHOLDLINKUP_dly  :  std_ulogic;
	signal   L0CFGASSTATECHANGECMD_dly  :  std_logic_vector(3 downto 0);
	signal   L0CFGASSPANTREEOWNEDSTATE_dly  :  std_ulogic;
	signal   L0ASE_dly  :  std_ulogic;
	signal   L0ASTURNPOOLBITSCONSUMED_dly  :  std_logic_vector(2 downto 0);
	signal   L0ASPORTCOUNT_dly  :  std_logic_vector(7 downto 0);
	signal   L0CFGVCENABLE_dly  :  std_logic_vector(7 downto 0);
	signal   L0CFGNEGOTIATEDMAXP_dly  :  std_logic_vector(2 downto 0);
	signal   L0CFGDISABLESCRAMBLE_dly  :  std_ulogic;
	signal   L0CFGEXTENDEDSYNC_dly  :  std_ulogic;
	signal   L0CFGLINKDISABLE_dly  :  std_ulogic;
	signal   L0PORTNUMBER_dly  :  std_logic_vector(7 downto 0);
	signal   L0SENDUNLOCKMESSAGE_dly  :  std_ulogic;
	signal   L0ALLDOWNRXPORTSINL0S_dly  :  std_ulogic;
	signal   L0UPSTREAMRXPORTINL0S_dly  :  std_ulogic;
	signal   L0TRANSACTIONSPENDING_dly  :  std_ulogic;
	signal   L0ALLDOWNPORTSINL1_dly  :  std_ulogic;
	signal   L0FWDCORRERRIN_dly  :  std_ulogic;
	signal   L0FWDFATALERRIN_dly  :  std_ulogic;
	signal   L0FWDNONFATALERRIN_dly  :  std_ulogic;
	signal   L0SETCOMPLETERABORTERROR_dly  :  std_ulogic;
	signal   L0SETDETECTEDCORRERROR_dly  :  std_ulogic;
	signal   L0SETDETECTEDFATALERROR_dly  :  std_ulogic;
	signal   L0SETDETECTEDNONFATALERROR_dly  :  std_ulogic;
	signal   L0SETLINKDETECTEDPARITYERROR_dly  :  std_ulogic;
	signal   L0SETLINKMASTERDATAPARITY_dly  :  std_ulogic;
	signal   L0SETLINKRECEIVEDMASTERABORT_dly  :  std_ulogic;
	signal   L0SETLINKRECEIVEDTARGETABORT_dly  :  std_ulogic;
	signal   L0SETLINKSYSTEMERROR_dly  :  std_ulogic;
	signal   L0SETLINKSIGNALLEDTARGETABORT_dly  :  std_ulogic;
	signal   L0SETUSERDETECTEDPARITYERROR_dly  :  std_ulogic;
	signal   L0SETUSERMASTERDATAPARITY_dly  :  std_ulogic;
	signal   L0SETUSERRECEIVEDMASTERABORT_dly  :  std_ulogic;
	signal   L0SETUSERRECEIVEDTARGETABORT_dly  :  std_ulogic;
	signal   L0SETUSERSYSTEMERROR_dly  :  std_ulogic;
	signal   L0SETUSERSIGNALLEDTARGETABORT_dly  :  std_ulogic;
	signal   L0SETCOMPLETIONTIMEOUTUNCORRERROR_dly  :  std_ulogic;
	signal   L0SETCOMPLETIONTIMEOUTCORRERROR_dly  :  std_ulogic;
	signal   L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_dly  :  std_ulogic;
	signal   L0SETUNEXPECTEDCOMPLETIONCORRERROR_dly  :  std_ulogic;
	signal   L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_dly  :  std_ulogic;
	signal   L0SETUNSUPPORTEDREQUESTOTHERERROR_dly  :  std_ulogic;
	signal   L0PACKETHEADERFROMUSER_dly  :  std_logic_vector(127 downto 0);
	signal   L0LEGACYINTFUNCT0_dly  :  std_ulogic;
	signal   L0FWDASSERTINTALEGACYINT_dly  :  std_ulogic;
	signal   L0FWDASSERTINTBLEGACYINT_dly  :  std_ulogic;
	signal   L0FWDASSERTINTCLEGACYINT_dly  :  std_ulogic;
	signal   L0FWDASSERTINTDLEGACYINT_dly  :  std_ulogic;
	signal   L0FWDDEASSERTINTALEGACYINT_dly  :  std_ulogic;
	signal   L0FWDDEASSERTINTBLEGACYINT_dly  :  std_ulogic;
	signal   L0FWDDEASSERTINTCLEGACYINT_dly  :  std_ulogic;
	signal   L0FWDDEASSERTINTDLEGACYINT_dly  :  std_ulogic;
	signal   L0MSIREQUEST0_dly  :  std_logic_vector(3 downto 0);
	signal   L0ELECTROMECHANICALINTERLOCKENGAGED_dly  :  std_ulogic;
	signal   L0MRLSENSORCLOSEDN_dly  :  std_ulogic;
	signal   L0POWERFAULTDETECTED_dly  :  std_ulogic;
	signal   L0PRESENCEDETECTSLOTEMPTYN_dly  :  std_ulogic;
	signal   L0ATTENTIONBUTTONPRESSED_dly  :  std_ulogic;
	signal   L0TXBEACON_dly  :  std_ulogic;
	signal   L0WAKEN_dly  :  std_ulogic;
	signal   L0PMEREQIN_dly  :  std_ulogic;
	signal   L0ROOTTURNOFFREQ_dly  :  std_ulogic;
	signal   L0TXCFGPM_dly  :  std_ulogic;
	signal   L0TXCFGPMTYPE_dly  :  std_logic_vector(2 downto 0);
	signal   L0PWRNEWSTATEREQ_dly  :  std_ulogic;
	signal   L0PWRNEXTLINKSTATE_dly  :  std_logic_vector(1 downto 0);
	signal   L0CFGL0SENTRYSUP_dly  :  std_ulogic;
	signal   L0CFGL0SENTRYENABLE_dly  :  std_ulogic;
	signal   L0CFGL0SEXITLAT_dly  :  std_logic_vector(2 downto 0);
	signal   L0TXTLTLPDATA_dly  :  std_logic_vector(63 downto 0);
	signal   L0TXTLTLPEND_dly  :  std_logic_vector(1 downto 0);
	signal   L0TXTLTLPENABLE_dly  :  std_logic_vector(1 downto 0);
	signal   L0TXTLTLPEDB_dly  :  std_ulogic;
	signal   L0TXTLTLPREQ_dly  :  std_ulogic;
	signal   L0TXTLTLPREQEND_dly  :  std_ulogic;
	signal   L0TXTLTLPWIDTH_dly  :  std_ulogic;
	signal   L0TXTLTLPLATENCY_dly  :  std_logic_vector(3 downto 0);
	signal   L0TLASFCCREDSTARVATION_dly  :  std_ulogic;
	signal   L0TXTLSBFCDATA_dly  :  std_logic_vector(18 downto 0);
	signal   L0TXTLSBFCUPDATE_dly  :  std_ulogic;
	signal   L0TXTLFCNPOSTBYPCRED_dly  :  std_logic_vector(191 downto 0);
	signal   L0TXTLFCNPOSTBYPUPDATE_dly  :  std_logic_vector(15 downto 0);
	signal   L0TXTLFCPOSTORDCRED_dly  :  std_logic_vector(159 downto 0);
	signal   L0TXTLFCPOSTORDUPDATE_dly  :  std_logic_vector(15 downto 0);
	signal   L0TXTLFCCMPLMCCRED_dly  :  std_logic_vector(159 downto 0);
	signal   L0TXTLFCCMPLMCUPDATE_dly  :  std_logic_vector(15 downto 0);
	signal   L0RXTLTLPNONINITIALIZEDVC_dly  :  std_logic_vector(7 downto 0);

        signal AUXPOWER_CRMUSERCLK_dly : std_ulogic;
        signal AUXPOWER_CRMCORECLK_dly : std_ulogic;
        signal CRMURSTN_CRMCORECLK_dly: std_ulogic;
        signal CRMNVRSTN_CRMCORECLK_dly: std_ulogic;
        signal CRMMGMTRSTN_CRMCORECLK_dly: std_ulogic;
        signal CRMUSERCFGRSTN_CRMCORECLK_dly: std_ulogic;
        signal CRMMACRSTN_CRMCORECLK_dly: std_ulogic;
        signal CRMLINKRSTN_CRMCORECLK_dly: std_ulogic;
        signal CFGNEGOTIATEDLINKWIDTH_CRMCORECLK_dly : std_logic_vector(5 downto 0);
	signal COMPLIANCEAVOID_CRMCORECLK_dly : std_ulogic;
	signal CRMCFGBRIDGEHOTRESET_CRMCORECLK_dly : std_ulogic;
	signal CRMTXHOTRESETN_CRMCORECLK_dly : std_ulogic;
        signal CROSSLINKSEED_CRMCORECLK_dly : std_ulogic;
	signal L0ACKNAKTIMERADJUSTMENT_CRMCORECLK_dly : std_logic_vector(11 downto 0);
	signal L0ALLDOWNPORTSINL1_CRMUSERCLK_dly : std_ulogic;
        signal L0ALLDOWNPORTSINL1_CRMCORECLK_dly : std_ulogic;
	signal L0ALLDOWNRXPORTSINL0S_CRMUSERCLK_dly : std_ulogic;
        signal L0ALLDOWNRXPORTSINL0S_CRMCORECLK_dly : std_ulogic;
	signal L0ASE_CRMCORECLK_dly : std_ulogic;
	signal L0ASPORTCOUNT_CRMCORECLK_dly : std_logic_vector(7 downto 0);
	signal L0ASTURNPOOLBITSCONSUMED_CRMCORECLK_dly : std_logic_vector(2 downto 0);
	signal L0ATTENTIONBUTTONPRESSED_CRMCORECLK_dly : std_ulogic;
        signal L0ATTENTIONBUTTONPRESSED_CRMUSERCLK_dly : std_ulogic;
	signal L0CFGASSPANTREEOWNEDSTATE_CRMCORECLK_dly : std_ulogic;
	signal L0CFGASSTATECHANGECMD_CRMCORECLK_dly : std_logic_vector(3 downto 0);
	signal L0CFGDISABLESCRAMBLE_CRMCORECLK_dly : std_ulogic;
	signal L0CFGEXTENDEDSYNC_CRMCORECLK_dly : std_ulogic;
	signal L0CFGL0SENTRYENABLE_CRMCORECLK_dly : std_ulogic;
	signal L0CFGL0SENTRYSUP_CRMCORECLK_dly : std_ulogic;
	signal L0CFGL0SEXITLAT_CRMCORECLK_dly : std_logic_vector(2 downto 0);
	signal L0CFGLINKDISABLE_CRMCORECLK_dly : std_ulogic;
	signal L0CFGLOOPBACKMASTER_CRMCORECLK_dly : std_ulogic;
	signal L0CFGNEGOTIATEDMAXP_CRMCORECLK_dly : std_logic_vector(2 downto 0);
	signal L0CFGVCENABLE_CRMCORECLK_dly : std_logic_vector(7 downto 0);
	signal L0CFGVCID_CRMCORECLK_dly : std_logic_vector(23 downto 0);
	signal L0DLLHOLDLINKUP_CRMCORECLK_dly : std_ulogic;
	signal L0ELECTROMECHANICALINTERLOCKENGAGED_CRMCORECLK_dly : std_ulogic;
        signal L0ELECTROMECHANICALINTERLOCKENGAGED_CRMUSERCLK_dly : std_ulogic;
	signal L0FWDASSERTINTALEGACYINT_CRMCORECLK_dly : std_ulogic;
        signal L0FWDASSERTINTALEGACYINT_CRMUSERCLK_dly : std_ulogic;
	signal L0FWDASSERTINTBLEGACYINT_CRMCORECLK_dly : std_ulogic;
        signal L0FWDASSERTINTBLEGACYINT_CRMUSERCLK_dly : std_ulogic;
	signal L0FWDASSERTINTCLEGACYINT_CRMCORECLK_dly : std_ulogic;
        signal L0FWDASSERTINTCLEGACYINT_CRMUSERCLK_dly : std_ulogic;
	signal L0FWDASSERTINTDLEGACYINT_CRMCORECLK_dly : std_ulogic;
       	signal L0FWDASSERTINTDLEGACYINT_CRMUSERCLK_dly : std_ulogic;
        signal L0FWDCORRERRIN_CRMCORECLK_dly : std_ulogic;
        signal L0FWDCORRERRIN_CRMUSERCLK_dly : std_ulogic;
	signal L0FWDDEASSERTINTALEGACYINT_CRMCORECLK_dly : std_ulogic;
        signal L0FWDDEASSERTINTALEGACYINT_CRMUSERCLK_dly : std_ulogic;
	signal L0FWDDEASSERTINTBLEGACYINT_CRMCORECLK_dly : std_ulogic;
        signal L0FWDDEASSERTINTBLEGACYINT_CRMUSERCLK_dly : std_ulogic;
	signal L0FWDDEASSERTINTCLEGACYINT_CRMCORECLK_dly : std_ulogic;
        signal L0FWDDEASSERTINTCLEGACYINT_CRMUSERCLK_dly : std_ulogic;
	signal L0FWDDEASSERTINTDLEGACYINT_CRMCORECLK_dly : std_ulogic;
        signal L0FWDDEASSERTINTDLEGACYINT_CRMUSERCLK_dly : std_ulogic;
	signal L0FWDFATALERRIN_CRMCORECLK_dly : std_ulogic;
        signal L0FWDFATALERRIN_CRMUSERCLK_dly : std_ulogic;
	signal L0FWDNONFATALERRIN_CRMCORECLK_dly : std_ulogic;
        signal L0FWDNONFATALERRIN_CRMUSERCLK_dly : std_ulogic;
        signal L0LEGACYINTFUNCT0_CRMCORECLK_dly : std_ulogic;
        signal L0LEGACYINTFUNCT0_CRMUSERCLK_dly : std_ulogic;
	signal L0MRLSENSORCLOSEDN_CRMCORECLK_dly : std_ulogic;
        signal L0MRLSENSORCLOSEDN_CRMUSERCLK_dly : std_ulogic;
        signal L0MSIREQUEST0_CRMCORECLK_dly : std_logic_vector(3 downto 0);
        signal L0MSIREQUEST0_CRMUSERCLK_dly : std_logic_vector(3 downto 0);
	signal L0PACKETHEADERFROMUSER_CRMCORECLK_dly : std_logic_vector(127 downto 0);
        signal L0PACKETHEADERFROMUSER_CRMUSERCLK_dly : std_logic_vector(127 downto 0);
	signal L0PMEREQIN_CRMCORECLK_dly : std_ulogic;
	signal L0PORTNUMBER_CRMCORECLK_dly : std_logic_vector(7 downto 0);
       	signal L0PORTNUMBER_CRMUSERCLK_dly : std_logic_vector(7 downto 0);
	signal L0POWERFAULTDETECTED_CRMCORECLK_dly : std_ulogic;
       	signal L0POWERFAULTDETECTED_CRMUSERCLK_dly : std_ulogic;
	signal L0PRESENCEDETECTSLOTEMPTYN_CRMCORECLK_dly : std_ulogic;
       	signal L0PRESENCEDETECTSLOTEMPTYN_CRMUSERCLK_dly : std_ulogic;
	signal L0PWRNEWSTATEREQ_CRMCORECLK_dly : std_ulogic;
	signal L0PWRNEXTLINKSTATE_CRMCORECLK_dly : std_logic_vector(1 downto 0);
	signal L0REPLAYTIMERADJUSTMENT_CRMCORECLK_dly : std_logic_vector(11 downto 0);
	signal L0ROOTTURNOFFREQ_CRMCORECLK_dly : std_ulogic;
        signal L0ROOTTURNOFFREQ_CRMUSERCLK_dly : std_ulogic;
	signal L0RXTLTLPNONINITIALIZEDVC_CRMCORECLK_dly : std_logic_vector(7 downto 0);
	signal L0SENDUNLOCKMESSAGE_CRMCORECLK_dly : std_ulogic;
        signal L0SENDUNLOCKMESSAGE_CRMUSERCLK_dly : std_ulogic;
	signal L0SETCOMPLETERABORTERROR_CRMCORECLK_dly : std_ulogic;
       	signal L0SETCOMPLETERABORTERROR_CRMUSERCLK_dly : std_ulogic;
	signal L0SETCOMPLETIONTIMEOUTCORRERROR_CRMCORECLK_dly : std_ulogic;
       	signal L0SETCOMPLETIONTIMEOUTCORRERROR_CRMUSERCLK_dly : std_ulogic;
	signal L0SETCOMPLETIONTIMEOUTUNCORRERROR_CRMCORECLK_dly : std_ulogic;
       	signal L0SETCOMPLETIONTIMEOUTUNCORRERROR_CRMUSERCLK_dly : std_ulogic;
	signal L0SETDETECTEDCORRERROR_CRMCORECLK_dly : std_ulogic;
        signal L0SETDETECTEDCORRERROR_CRMUSERCLK_dly : std_ulogic;
	signal L0SETDETECTEDFATALERROR_CRMCORECLK_dly : std_ulogic;
        signal L0SETDETECTEDFATALERROR_CRMUSERCLK_dly : std_ulogic;
	signal L0SETDETECTEDNONFATALERROR_CRMCORECLK_dly : std_ulogic;
       	signal L0SETDETECTEDNONFATALERROR_CRMUSERCLK_dly : std_ulogic;
	signal L0SETLINKDETECTEDPARITYERROR_CRMCORECLK_dly : std_ulogic;
        signal L0SETLINKDETECTEDPARITYERROR_CRMUSERCLK_dly : std_ulogic;
        signal L0SETLINKMASTERDATAPARITY_CRMCORECLK_dly : std_ulogic;
        signal L0SETLINKMASTERDATAPARITY_CRMUSERCLK_dly : std_ulogic;
	signal L0SETLINKRECEIVEDMASTERABORT_CRMCORECLK_dly : std_ulogic;
        signal L0SETLINKRECEIVEDMASTERABORT_CRMUSERCLK_dly : std_ulogic;
	signal L0SETLINKRECEIVEDTARGETABORT_CRMCORECLK_dly : std_ulogic;
        signal L0SETLINKRECEIVEDTARGETABORT_CRMUSERCLK_dly : std_ulogic;
	signal L0SETLINKSIGNALLEDTARGETABORT_CRMCORECLK_dly : std_ulogic;
        signal L0SETLINKSIGNALLEDTARGETABORT_CRMUSERCLK_dly : std_ulogic;
	signal L0SETLINKSYSTEMERROR_CRMCORECLK_dly : std_ulogic;
       	signal L0SETLINKSYSTEMERROR_CRMUSERCLK_dly : std_ulogic;
	signal L0SETUNEXPECTEDCOMPLETIONCORRERROR_CRMCORECLK_dly : std_ulogic;
        signal L0SETUNEXPECTEDCOMPLETIONCORRERROR_CRMUSERCLK_dly : std_ulogic;
	signal L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_CRMCORECLK_dly : std_ulogic;
        signal L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_CRMUSERCLK_dly : std_ulogic;
	signal L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_CRMCORECLK_dly : std_ulogic;
        signal L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_CRMUSERCLK_dly : std_ulogic;
	signal L0SETUNSUPPORTEDREQUESTOTHERERROR_CRMCORECLK_dly : std_ulogic;
        signal L0SETUNSUPPORTEDREQUESTOTHERERROR_CRMUSERCLK_dly : std_ulogic;
	signal L0SETUSERDETECTEDPARITYERROR_CRMCORECLK_dly : std_ulogic;
       	signal L0SETUSERDETECTEDPARITYERROR_CRMUSERCLK_dly : std_ulogic;
	signal L0SETUSERMASTERDATAPARITY_CRMCORECLK_dly : std_ulogic;
       	signal L0SETUSERMASTERDATAPARITY_CRMUSERCLK_dly : std_ulogic;
	signal L0SETUSERRECEIVEDMASTERABORT_CRMCORECLK_dly : std_ulogic;
        signal L0SETUSERRECEIVEDMASTERABORT_CRMUSERCLK_dly : std_ulogic;
	signal L0SETUSERRECEIVEDTARGETABORT_CRMCORECLK_dly : std_ulogic;
        signal L0SETUSERRECEIVEDTARGETABORT_CRMUSERCLK_dly : std_ulogic;
	signal L0SETUSERSIGNALLEDTARGETABORT_CRMCORECLK_dly : std_ulogic;
        signal L0SETUSERSIGNALLEDTARGETABORT_CRMUSERCLK_dly : std_ulogic;
	signal L0SETUSERSYSTEMERROR_CRMCORECLK_dly : std_ulogic;
        signal L0SETUSERSYSTEMERROR_CRMUSERCLK_dly : std_ulogic;
	signal L0TLASFCCREDSTARVATION_CRMCORECLK_dly : std_ulogic;
	signal L0TLLINKRETRAIN_CRMCORECLK_dly : std_ulogic;
	signal L0TRANSACTIONSPENDING_CRMCORECLK_dly : std_ulogic;
        signal L0TRANSACTIONSPENDING_CRMUSERCLK_dly : std_ulogic;
	signal L0TXBEACON_CRMCORECLK_dly : std_ulogic;
	signal L0TXCFGPM_CRMCORECLK_dly : std_ulogic;
	signal L0TXCFGPMTYPE_CRMCORECLK_dly : std_logic_vector(2 downto 0);
	signal L0TXTLFCCMPLMCCRED_CRMCORECLK_dly : std_logic_vector(159 downto 0);
	signal L0TXTLFCCMPLMCUPDATE_CRMCORECLK_dly : std_logic_vector(15 downto 0);
	signal L0TXTLFCNPOSTBYPCRED_CRMCORECLK_dly : std_logic_vector(191 downto 0);
	signal L0TXTLFCNPOSTBYPUPDATE_CRMCORECLK_dly : std_logic_vector(15 downto 0);
	signal L0TXTLFCPOSTORDCRED_CRMCORECLK_dly : std_logic_vector(159 downto 0);
	signal L0TXTLFCPOSTORDUPDATE_CRMCORECLK_dly : std_logic_vector(15 downto 0);
	signal L0TXTLSBFCDATA_CRMCORECLK_dly : std_logic_vector(18 downto 0);
	signal L0TXTLSBFCUPDATE_CRMCORECLK_dly : std_ulogic;
	signal L0TXTLTLPDATA_CRMCORECLK_dly : std_logic_vector(63 downto 0);
	signal L0TXTLTLPEDB_CRMCORECLK_dly : std_ulogic;
	signal L0TXTLTLPENABLE_CRMCORECLK_dly : std_logic_vector(1 downto 0);
	signal L0TXTLTLPEND_CRMCORECLK_dly : std_logic_vector(1 downto 0);
	signal L0TXTLTLPLATENCY_CRMCORECLK_dly : std_logic_vector(3 downto 0);
	signal L0TXTLTLPREQ_CRMCORECLK_dly : std_ulogic;
	signal L0TXTLTLPREQEND_CRMCORECLK_dly : std_ulogic;
	signal L0TXTLTLPWIDTH_CRMCORECLK_dly : std_ulogic;
	signal L0UPSTREAMRXPORTINL0S_CRMUSERCLK_dly : std_ulogic;
        signal L0UPSTREAMRXPORTINL0S_CRMCORECLK_dly : std_ulogic;
	signal L0VC0PREVIEWEXPAND_CRMCORECLK_dly : std_ulogic;
	signal L0WAKEN_CRMCORECLK_dly : std_ulogic;
	signal LLKRXCHFIFO_CRMUSERCLK_dly : std_logic_vector(1 downto 0);
       	signal LLKRXCHFIFO_CRMCORECLK_dly : std_logic_vector(1 downto 0);
	signal LLKRXCHTC_CRMUSERCLK_dly : std_logic_vector(2 downto 0);
        signal LLKRXCHTC_CRMCORECLK_dly : std_logic_vector(2 downto 0);
	signal LLKRXDSTCONTREQN_CRMUSERCLK_dly : std_ulogic;
        signal LLKRXDSTCONTREQN_CRMCORECLK_dly : std_ulogic;
	signal LLKRXDSTREQN_CRMUSERCLK_dly : std_ulogic;
        signal LLKRXDSTREQN_CRMCORECLK_dly : std_ulogic;
	signal LLKTX4DWHEADERN_CRMUSERCLK_dly : std_ulogic;
        signal LLKTX4DWHEADERN_CRMCORECLK_dly : std_ulogic;
	signal LLKTXCHFIFO_CRMUSERCLK_dly : std_logic_vector(1 downto 0);
        signal LLKTXCHFIFO_CRMCORECLK_dly : std_logic_vector(1 downto 0);
	signal LLKTXCHTC_CRMUSERCLK_dly : std_logic_vector(2 downto 0);
        signal LLKTXCHTC_CRMCORECLK_dly : std_logic_vector(2 downto 0);
	signal LLKTXCOMPLETEN_CRMUSERCLK_dly : std_ulogic;
       	signal LLKTXCOMPLETEN_CRMCORECLK_dly : std_ulogic;
	signal LLKTXCREATEECRCN_CRMUSERCLK_dly : std_ulogic;
        signal LLKTXCREATEECRCN_CRMCORECLK_dly : std_ulogic;
	signal LLKTXDATA_CRMUSERCLK_dly : std_logic_vector(63 downto 0);
       	signal LLKTXDATA_CRMCORECLK_dly : std_logic_vector(63 downto 0);
	signal LLKTXENABLEN_CRMUSERCLK_dly : std_logic_vector(1 downto 0);
        signal LLKTXENABLEN_CRMCORECLK_dly : std_logic_vector(1 downto 0);
	signal LLKTXEOFN_CRMUSERCLK_dly : std_ulogic;
        signal LLKTXEOFN_CRMCORECLK_dly : std_ulogic;
	signal LLKTXEOPN_CRMUSERCLK_dly : std_ulogic;
        signal LLKTXEOPN_CRMCORECLK_dly : std_ulogic;
	signal LLKTXSOFN_CRMUSERCLK_dly : std_ulogic;
        signal LLKTXSOFN_CRMCORECLK_dly : std_ulogic;
	signal LLKTXSOPN_CRMUSERCLK_dly : std_ulogic;
        signal LLKTXSOPN_CRMCORECLK_dly : std_ulogic;
	signal LLKTXSRCDSCN_CRMUSERCLK_dly : std_ulogic;
        signal LLKTXSRCDSCN_CRMCORECLK_dly : std_ulogic;
	signal LLKTXSRCRDYN_CRMUSERCLK_dly : std_ulogic;
        signal LLKTXSRCRDYN_CRMCORECLK_dly : std_ulogic;
	signal MAINPOWER_CRMCORECLK_dly : std_ulogic;
	signal MGMTADDR_CRMUSERCLK_dly : std_logic_vector(10 downto 0);
       	signal MGMTADDR_CRMCORECLK_dly : std_logic_vector(10 downto 0);
	signal MGMTBWREN_CRMUSERCLK_dly : std_logic_vector(3 downto 0);
        signal MGMTBWREN_CRMCORECLK_dly : std_logic_vector(3 downto 0);
	signal MGMTRDEN_CRMUSERCLK_dly : std_ulogic;
        signal MGMTRDEN_CRMCORECLK_dly : std_ulogic;
	signal MGMTSTATSCREDITSEL_CRMUSERCLK_dly : std_logic_vector(6 downto 0);
        signal MGMTSTATSCREDITSEL_CRMCORECLK_dly : std_logic_vector(6 downto 0);
	signal MGMTWDATA_CRMUSERCLK_dly : std_logic_vector(31 downto 0);
       	signal MGMTWDATA_CRMCORECLK_dly : std_logic_vector(31 downto 0);
	signal MGMTWREN_CRMUSERCLK_dly : std_ulogic;
       	signal MGMTWREN_CRMCORECLK_dly : std_ulogic;
        signal MIMDLLBRDATA_CRMCORECLK_dly : std_logic_vector(63 downto 0);
       	signal MIMRXBRDATA_CRMCORECLK_dly : std_logic_vector(63 downto 0);
	signal MIMTXBRDATA_CRMCORECLK_dly : std_logic_vector(63 downto 0);
	signal PIPEPHYSTATUSL0_CRMCORECLK_dly : std_ulogic;
	signal PIPEPHYSTATUSL1_CRMCORECLK_dly : std_ulogic;
	signal PIPEPHYSTATUSL2_CRMCORECLK_dly : std_ulogic;
	signal PIPEPHYSTATUSL3_CRMCORECLK_dly : std_ulogic;
	signal PIPEPHYSTATUSL4_CRMCORECLK_dly : std_ulogic;
	signal PIPEPHYSTATUSL5_CRMCORECLK_dly : std_ulogic;
	signal PIPEPHYSTATUSL6_CRMCORECLK_dly : std_ulogic;
	signal PIPEPHYSTATUSL7_CRMCORECLK_dly : std_ulogic;
	signal PIPERXCHANISALIGNEDL0_CRMCORECLK_dly : std_ulogic;
	signal PIPERXCHANISALIGNEDL1_CRMCORECLK_dly : std_ulogic;
	signal PIPERXCHANISALIGNEDL2_CRMCORECLK_dly : std_ulogic;
	signal PIPERXCHANISALIGNEDL3_CRMCORECLK_dly : std_ulogic;
	signal PIPERXCHANISALIGNEDL4_CRMCORECLK_dly : std_ulogic;
	signal PIPERXCHANISALIGNEDL5_CRMCORECLK_dly : std_ulogic;
	signal PIPERXCHANISALIGNEDL6_CRMCORECLK_dly : std_ulogic;
	signal PIPERXCHANISALIGNEDL7_CRMCORECLK_dly : std_ulogic;
	signal PIPERXDATAKL0_CRMCORECLK_dly : std_ulogic;
	signal PIPERXDATAKL1_CRMCORECLK_dly : std_ulogic;
	signal PIPERXDATAKL2_CRMCORECLK_dly : std_ulogic;
	signal PIPERXDATAKL3_CRMCORECLK_dly : std_ulogic;
	signal PIPERXDATAKL4_CRMCORECLK_dly : std_ulogic;
	signal PIPERXDATAKL5_CRMCORECLK_dly : std_ulogic;
	signal PIPERXDATAKL6_CRMCORECLK_dly : std_ulogic;
	signal PIPERXDATAKL7_CRMCORECLK_dly : std_ulogic;
	signal PIPERXDATAL0_CRMCORECLK_dly : std_logic_vector(7 downto 0);
	signal PIPERXDATAL1_CRMCORECLK_dly : std_logic_vector(7 downto 0);
	signal PIPERXDATAL2_CRMCORECLK_dly : std_logic_vector(7 downto 0);
	signal PIPERXDATAL3_CRMCORECLK_dly : std_logic_vector(7 downto 0);
	signal PIPERXDATAL4_CRMCORECLK_dly : std_logic_vector(7 downto 0);
	signal PIPERXDATAL5_CRMCORECLK_dly : std_logic_vector(7 downto 0);
	signal PIPERXDATAL6_CRMCORECLK_dly : std_logic_vector(7 downto 0);
	signal PIPERXDATAL7_CRMCORECLK_dly : std_logic_vector(7 downto 0);
	signal PIPERXELECIDLEL0_CRMCORECLK_dly : std_ulogic;
	signal PIPERXELECIDLEL1_CRMCORECLK_dly : std_ulogic;
	signal PIPERXELECIDLEL2_CRMCORECLK_dly : std_ulogic;
	signal PIPERXELECIDLEL3_CRMCORECLK_dly : std_ulogic;
	signal PIPERXELECIDLEL4_CRMCORECLK_dly : std_ulogic;
	signal PIPERXELECIDLEL5_CRMCORECLK_dly : std_ulogic;
	signal PIPERXELECIDLEL6_CRMCORECLK_dly : std_ulogic;
	signal PIPERXELECIDLEL7_CRMCORECLK_dly : std_ulogic;
	signal PIPERXSTATUSL0_CRMCORECLK_dly : std_logic_vector(2 downto 0);
	signal PIPERXSTATUSL1_CRMCORECLK_dly : std_logic_vector(2 downto 0);
	signal PIPERXSTATUSL2_CRMCORECLK_dly : std_logic_vector(2 downto 0);
	signal PIPERXSTATUSL3_CRMCORECLK_dly : std_logic_vector(2 downto 0);
	signal PIPERXSTATUSL4_CRMCORECLK_dly : std_logic_vector(2 downto 0);
	signal PIPERXSTATUSL5_CRMCORECLK_dly : std_logic_vector(2 downto 0);
	signal PIPERXSTATUSL6_CRMCORECLK_dly : std_logic_vector(2 downto 0);
	signal PIPERXSTATUSL7_CRMCORECLK_dly : std_logic_vector(2 downto 0);
	signal PIPERXVALIDL0_CRMCORECLK_dly : std_ulogic;
	signal PIPERXVALIDL1_CRMCORECLK_dly : std_ulogic;
	signal PIPERXVALIDL2_CRMCORECLK_dly : std_ulogic;
	signal PIPERXVALIDL3_CRMCORECLK_dly : std_ulogic;
	signal PIPERXVALIDL4_CRMCORECLK_dly : std_ulogic;
	signal PIPERXVALIDL5_CRMCORECLK_dly : std_ulogic;
	signal PIPERXVALIDL6_CRMCORECLK_dly : std_ulogic;
        signal PIPERXVALIDL7_CRMCORECLK_dly : std_ulogic;

	signal   PIPERXELECIDLEL0_indelay  :  std_ulogic;
	signal   PIPERXSTATUSL0_indelay  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL0_indelay  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL0_indelay  :  std_ulogic;
	signal   PIPERXDATAKL0_indelay  :  std_ulogic;
	signal   PIPERXVALIDL0_indelay  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL0_indelay  :  std_ulogic;
	signal   PIPERXELECIDLEL1_indelay  :  std_ulogic;
	signal   PIPERXSTATUSL1_indelay  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL1_indelay  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL1_indelay  :  std_ulogic;
	signal   PIPERXDATAKL1_indelay  :  std_ulogic;
	signal   PIPERXVALIDL1_indelay  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL1_indelay  :  std_ulogic;
	signal   PIPERXELECIDLEL2_indelay  :  std_ulogic;
	signal   PIPERXSTATUSL2_indelay  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL2_indelay  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL2_indelay  :  std_ulogic;
	signal   PIPERXDATAKL2_indelay  :  std_ulogic;
	signal   PIPERXVALIDL2_indelay  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL2_indelay  :  std_ulogic;
	signal   PIPERXELECIDLEL3_indelay  :  std_ulogic;
	signal   PIPERXSTATUSL3_indelay  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL3_indelay  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL3_indelay  :  std_ulogic;
	signal   PIPERXDATAKL3_indelay  :  std_ulogic;
	signal   PIPERXVALIDL3_indelay  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL3_indelay  :  std_ulogic;
	signal   PIPERXELECIDLEL4_indelay  :  std_ulogic;
	signal   PIPERXSTATUSL4_indelay  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL4_indelay  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL4_indelay  :  std_ulogic;
	signal   PIPERXDATAKL4_indelay  :  std_ulogic;
	signal   PIPERXVALIDL4_indelay  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL4_indelay  :  std_ulogic;
	signal   PIPERXELECIDLEL5_indelay  :  std_ulogic;
	signal   PIPERXSTATUSL5_indelay  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL5_indelay  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL5_indelay  :  std_ulogic;
	signal   PIPERXDATAKL5_indelay  :  std_ulogic;
	signal   PIPERXVALIDL5_indelay  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL5_indelay  :  std_ulogic;
	signal   PIPERXELECIDLEL6_indelay  :  std_ulogic;
	signal   PIPERXSTATUSL6_indelay  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL6_indelay  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL6_indelay  :  std_ulogic;
	signal   PIPERXDATAKL6_indelay  :  std_ulogic;
	signal   PIPERXVALIDL6_indelay  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL6_indelay  :  std_ulogic;
	signal   PIPERXELECIDLEL7_indelay  :  std_ulogic;
	signal   PIPERXSTATUSL7_indelay  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL7_indelay  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL7_indelay  :  std_ulogic;
	signal   PIPERXDATAKL7_indelay  :  std_ulogic;
	signal   PIPERXVALIDL7_indelay  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL7_indelay  :  std_ulogic;
	signal   MIMRXBRDATA_indelay  :  std_logic_vector(63 downto 0);
	signal   CRMCORECLKRXO_indelay  :  std_ulogic;
	signal   CRMUSERCLKRXO_indelay  :  std_ulogic;
	signal   MIMTXBRDATA_indelay  :  std_logic_vector(63 downto 0);
	signal   CRMCORECLKTXO_indelay  :  std_ulogic;
	signal   CRMUSERCLKTXO_indelay  :  std_ulogic;
	signal   MIMDLLBRDATA_indelay  :  std_logic_vector(63 downto 0);
	signal   CRMCORECLKDLO_indelay  :  std_ulogic;
	signal   CRMCORECLK_indelay  :  std_ulogic;
	signal   CRMUSERCLK_indelay  :  std_ulogic;
	signal   CRMURSTN_indelay  :  std_ulogic;
	signal   CRMNVRSTN_indelay  :  std_ulogic;
	signal   CRMMGMTRSTN_indelay  :  std_ulogic;
	signal   CRMUSERCFGRSTN_indelay  :  std_ulogic;
	signal   CRMMACRSTN_indelay  :  std_ulogic;
	signal   CRMLINKRSTN_indelay  :  std_ulogic;
	signal   CRMTXHOTRESETN_indelay  :  std_ulogic;
	signal   CRMCFGBRIDGEHOTRESET_indelay  :  std_ulogic;
	signal   LLKTXDATA_indelay  :  std_logic_vector(63 downto 0);
	signal   LLKTXSRCRDYN_indelay  :  std_ulogic;
	signal   LLKTXSRCDSCN_indelay  :  std_ulogic;
	signal   LLKTXCOMPLETEN_indelay  :  std_ulogic;
	signal   LLKTXSOFN_indelay  :  std_ulogic;
	signal   LLKTXEOFN_indelay  :  std_ulogic;
	signal   LLKTXSOPN_indelay  :  std_ulogic;
	signal   LLKTXEOPN_indelay  :  std_ulogic;
	signal   LLKTXENABLEN_indelay  :  std_logic_vector(1 downto 0);
	signal   LLKTXCHTC_indelay  :  std_logic_vector(2 downto 0);
	signal   LLKTXCHFIFO_indelay  :  std_logic_vector(1 downto 0);
	signal   LLKTXCREATEECRCN_indelay  :  std_ulogic;
	signal   LLKTX4DWHEADERN_indelay  :  std_ulogic;
	signal   LLKRXDSTREQN_indelay  :  std_ulogic;
	signal   LLKRXCHTC_indelay  :  std_logic_vector(2 downto 0);
	signal   LLKRXCHFIFO_indelay  :  std_logic_vector(1 downto 0);
	signal   LLKRXDSTCONTREQN_indelay  :  std_ulogic;
	signal   MGMTWDATA_indelay  :  std_logic_vector(31 downto 0);
	signal   MGMTBWREN_indelay  :  std_logic_vector(3 downto 0);
	signal   MGMTWREN_indelay  :  std_ulogic;
	signal   MGMTADDR_indelay  :  std_logic_vector(10 downto 0);
	signal   MGMTRDEN_indelay  :  std_ulogic;
	signal   MGMTSTATSCREDITSEL_indelay  :  std_logic_vector(6 downto 0);
	signal   MAINPOWER_indelay  :  std_ulogic;
	signal   AUXPOWER_indelay  :  std_ulogic;
	signal   L0TLLINKRETRAIN_indelay  :  std_ulogic;
	signal   CFGNEGOTIATEDLINKWIDTH_indelay  :  std_logic_vector(5 downto 0);
	signal   CROSSLINKSEED_indelay  :  std_ulogic;
	signal   COMPLIANCEAVOID_indelay  :  std_ulogic;
	signal   L0VC0PREVIEWEXPAND_indelay  :  std_ulogic;
	signal   L0CFGVCID_indelay  :  std_logic_vector(23 downto 0);
	signal   L0CFGLOOPBACKMASTER_indelay  :  std_ulogic;
	signal   L0REPLAYTIMERADJUSTMENT_indelay  :  std_logic_vector(11 downto 0);
	signal   L0ACKNAKTIMERADJUSTMENT_indelay  :  std_logic_vector(11 downto 0);
	signal   L0DLLHOLDLINKUP_indelay  :  std_ulogic;
	signal   L0CFGASSTATECHANGECMD_indelay  :  std_logic_vector(3 downto 0);
	signal   L0CFGASSPANTREEOWNEDSTATE_indelay  :  std_ulogic;
	signal   L0ASE_indelay  :  std_ulogic;
	signal   L0ASTURNPOOLBITSCONSUMED_indelay  :  std_logic_vector(2 downto 0);
	signal   L0ASPORTCOUNT_indelay  :  std_logic_vector(7 downto 0);
	signal   L0CFGVCENABLE_indelay  :  std_logic_vector(7 downto 0);
	signal   L0CFGNEGOTIATEDMAXP_indelay  :  std_logic_vector(2 downto 0);
	signal   L0CFGDISABLESCRAMBLE_indelay  :  std_ulogic;
	signal   L0CFGEXTENDEDSYNC_indelay  :  std_ulogic;
	signal   L0CFGLINKDISABLE_indelay  :  std_ulogic;
	signal   L0PORTNUMBER_indelay  :  std_logic_vector(7 downto 0);
	signal   L0SENDUNLOCKMESSAGE_indelay  :  std_ulogic;
	signal   L0ALLDOWNRXPORTSINL0S_indelay  :  std_ulogic;
	signal   L0UPSTREAMRXPORTINL0S_indelay  :  std_ulogic;
	signal   L0TRANSACTIONSPENDING_indelay  :  std_ulogic;
	signal   L0ALLDOWNPORTSINL1_indelay  :  std_ulogic;
	signal   L0FWDCORRERRIN_indelay  :  std_ulogic;
	signal   L0FWDFATALERRIN_indelay  :  std_ulogic;
	signal   L0FWDNONFATALERRIN_indelay  :  std_ulogic;
	signal   L0SETCOMPLETERABORTERROR_indelay  :  std_ulogic;
	signal   L0SETDETECTEDCORRERROR_indelay  :  std_ulogic;
	signal   L0SETDETECTEDFATALERROR_indelay  :  std_ulogic;
	signal   L0SETDETECTEDNONFATALERROR_indelay  :  std_ulogic;
	signal   L0SETLINKDETECTEDPARITYERROR_indelay  :  std_ulogic;
	signal   L0SETLINKMASTERDATAPARITY_indelay  :  std_ulogic;
	signal   L0SETLINKRECEIVEDMASTERABORT_indelay  :  std_ulogic;
	signal   L0SETLINKRECEIVEDTARGETABORT_indelay  :  std_ulogic;
	signal   L0SETLINKSYSTEMERROR_indelay  :  std_ulogic;
	signal   L0SETLINKSIGNALLEDTARGETABORT_indelay  :  std_ulogic;
	signal   L0SETUSERDETECTEDPARITYERROR_indelay  :  std_ulogic;
	signal   L0SETUSERMASTERDATAPARITY_indelay  :  std_ulogic;
	signal   L0SETUSERRECEIVEDMASTERABORT_indelay  :  std_ulogic;
	signal   L0SETUSERRECEIVEDTARGETABORT_indelay  :  std_ulogic;
	signal   L0SETUSERSYSTEMERROR_indelay  :  std_ulogic;
	signal   L0SETUSERSIGNALLEDTARGETABORT_indelay  :  std_ulogic;
	signal   L0SETCOMPLETIONTIMEOUTUNCORRERROR_indelay  :  std_ulogic;
	signal   L0SETCOMPLETIONTIMEOUTCORRERROR_indelay  :  std_ulogic;
	signal   L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_indelay  :  std_ulogic;
	signal   L0SETUNEXPECTEDCOMPLETIONCORRERROR_indelay  :  std_ulogic;
	signal   L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_indelay  :  std_ulogic;
	signal   L0SETUNSUPPORTEDREQUESTOTHERERROR_indelay  :  std_ulogic;
	signal   L0PACKETHEADERFROMUSER_indelay  :  std_logic_vector(127 downto 0);
	signal   L0LEGACYINTFUNCT0_indelay  :  std_ulogic;
	signal   L0FWDASSERTINTALEGACYINT_indelay  :  std_ulogic;
	signal   L0FWDASSERTINTBLEGACYINT_indelay  :  std_ulogic;
	signal   L0FWDASSERTINTCLEGACYINT_indelay  :  std_ulogic;
	signal   L0FWDASSERTINTDLEGACYINT_indelay  :  std_ulogic;
	signal   L0FWDDEASSERTINTALEGACYINT_indelay  :  std_ulogic;
	signal   L0FWDDEASSERTINTBLEGACYINT_indelay  :  std_ulogic;
	signal   L0FWDDEASSERTINTCLEGACYINT_indelay  :  std_ulogic;
	signal   L0FWDDEASSERTINTDLEGACYINT_indelay  :  std_ulogic;
	signal   L0MSIREQUEST0_indelay  :  std_logic_vector(3 downto 0);
	signal   L0ELECTROMECHANICALINTERLOCKENGAGED_indelay  :  std_ulogic;
	signal   L0MRLSENSORCLOSEDN_indelay  :  std_ulogic;
	signal   L0POWERFAULTDETECTED_indelay  :  std_ulogic;
	signal   L0PRESENCEDETECTSLOTEMPTYN_indelay  :  std_ulogic;
	signal   L0ATTENTIONBUTTONPRESSED_indelay  :  std_ulogic;
	signal   L0TXBEACON_indelay  :  std_ulogic;
	signal   L0WAKEN_indelay  :  std_ulogic;
	signal   L0PMEREQIN_indelay  :  std_ulogic;
	signal   L0ROOTTURNOFFREQ_indelay  :  std_ulogic;
	signal   L0TXCFGPM_indelay  :  std_ulogic;
	signal   L0TXCFGPMTYPE_indelay  :  std_logic_vector(2 downto 0);
	signal   L0PWRNEWSTATEREQ_indelay  :  std_ulogic;
	signal   L0PWRNEXTLINKSTATE_indelay  :  std_logic_vector(1 downto 0);
	signal   L0CFGL0SENTRYSUP_indelay  :  std_ulogic;
	signal   L0CFGL0SENTRYENABLE_indelay  :  std_ulogic;
	signal   L0CFGL0SEXITLAT_indelay  :  std_logic_vector(2 downto 0);
	signal   L0TXTLTLPDATA_indelay  :  std_logic_vector(63 downto 0);
	signal   L0TXTLTLPEND_indelay  :  std_logic_vector(1 downto 0);
	signal   L0TXTLTLPENABLE_indelay  :  std_logic_vector(1 downto 0);
	signal   L0TXTLTLPEDB_indelay  :  std_ulogic;
	signal   L0TXTLTLPREQ_indelay  :  std_ulogic;
	signal   L0TXTLTLPREQEND_indelay  :  std_ulogic;
	signal   L0TXTLTLPWIDTH_indelay  :  std_ulogic;
	signal   L0TXTLTLPLATENCY_indelay  :  std_logic_vector(3 downto 0);
	signal   L0TLASFCCREDSTARVATION_indelay  :  std_ulogic;
	signal   L0TXTLSBFCDATA_indelay  :  std_logic_vector(18 downto 0);
	signal   L0TXTLSBFCUPDATE_indelay  :  std_ulogic;
	signal   L0TXTLFCNPOSTBYPCRED_indelay  :  std_logic_vector(191 downto 0);
	signal   L0TXTLFCNPOSTBYPUPDATE_indelay  :  std_logic_vector(15 downto 0);
	signal   L0TXTLFCPOSTORDCRED_indelay  :  std_logic_vector(159 downto 0);
	signal   L0TXTLFCPOSTORDUPDATE_indelay  :  std_logic_vector(15 downto 0);
	signal   L0TXTLFCCMPLMCCRED_indelay  :  std_logic_vector(159 downto 0);
	signal   L0TXTLFCCMPLMCUPDATE_indelay  :  std_logic_vector(15 downto 0);
	signal   L0RXTLTLPNONINITIALIZEDVC_indelay  :  std_logic_vector(7 downto 0);

        signal   PIPERXELECIDLEL0_indly  :  std_ulogic;
	signal   PIPERXSTATUSL0_indly  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL0_indly  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL0_indly  :  std_ulogic;
	signal   PIPERXDATAKL0_indly  :  std_ulogic;
	signal   PIPERXVALIDL0_indly  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL0_indly  :  std_ulogic;
	signal   PIPERXELECIDLEL1_indly  :  std_ulogic;
	signal   PIPERXSTATUSL1_indly  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL1_indly  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL1_indly  :  std_ulogic;
	signal   PIPERXDATAKL1_indly  :  std_ulogic;
	signal   PIPERXVALIDL1_indly  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL1_indly  :  std_ulogic;
	signal   PIPERXELECIDLEL2_indly  :  std_ulogic;
	signal   PIPERXSTATUSL2_indly  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL2_indly  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL2_indly  :  std_ulogic;
	signal   PIPERXDATAKL2_indly  :  std_ulogic;
	signal   PIPERXVALIDL2_indly  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL2_indly  :  std_ulogic;
	signal   PIPERXELECIDLEL3_indly  :  std_ulogic;
	signal   PIPERXSTATUSL3_indly  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL3_indly  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL3_indly  :  std_ulogic;
	signal   PIPERXDATAKL3_indly  :  std_ulogic;
	signal   PIPERXVALIDL3_indly  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL3_indly  :  std_ulogic;
	signal   PIPERXELECIDLEL4_indly  :  std_ulogic;
	signal   PIPERXSTATUSL4_indly  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL4_indly  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL4_indly  :  std_ulogic;
	signal   PIPERXDATAKL4_indly  :  std_ulogic;
	signal   PIPERXVALIDL4_indly  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL4_indly  :  std_ulogic;
	signal   PIPERXELECIDLEL5_indly  :  std_ulogic;
	signal   PIPERXSTATUSL5_indly  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL5_indly  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL5_indly  :  std_ulogic;
	signal   PIPERXDATAKL5_indly  :  std_ulogic;
	signal   PIPERXVALIDL5_indly  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL5_indly  :  std_ulogic;
	signal   PIPERXELECIDLEL6_indly  :  std_ulogic;
	signal   PIPERXSTATUSL6_indly  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL6_indly  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL6_indly  :  std_ulogic;
	signal   PIPERXDATAKL6_indly  :  std_ulogic;
	signal   PIPERXVALIDL6_indly  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL6_indly  :  std_ulogic;
	signal   PIPERXELECIDLEL7_indly  :  std_ulogic;
	signal   PIPERXSTATUSL7_indly  :  std_logic_vector(2 downto 0);
	signal   PIPERXDATAL7_indly  :  std_logic_vector(7 downto 0);
	signal   PIPEPHYSTATUSL7_indly  :  std_ulogic;
	signal   PIPERXDATAKL7_indly  :  std_ulogic;
	signal   PIPERXVALIDL7_indly  :  std_ulogic;
	signal   PIPERXCHANISALIGNEDL7_indly  :  std_ulogic;
	signal   MIMRXBRDATA_indly  :  std_logic_vector(63 downto 0);
	signal   CRMCORECLKRXO_indly  :  std_ulogic;
	signal   CRMUSERCLKRXO_indly  :  std_ulogic;
	signal   MIMTXBRDATA_indly  :  std_logic_vector(63 downto 0);
	signal   CRMCORECLKTXO_indly  :  std_ulogic;
	signal   CRMUSERCLKTXO_indly  :  std_ulogic;
	signal   MIMDLLBRDATA_indly  :  std_logic_vector(63 downto 0);
	signal   CRMCORECLKDLO_indly  :  std_ulogic;
	signal   CRMCORECLK_indly  :  std_ulogic;
	signal   CRMUSERCLK_indly  :  std_ulogic;
	signal   CRMURSTN_indly  :  std_ulogic;
	signal   CRMNVRSTN_indly  :  std_ulogic;
	signal   CRMMGMTRSTN_indly  :  std_ulogic;
	signal   CRMUSERCFGRSTN_indly  :  std_ulogic;
	signal   CRMMACRSTN_indly  :  std_ulogic;
	signal   CRMLINKRSTN_indly  :  std_ulogic;
	signal   CRMTXHOTRESETN_indly  :  std_ulogic;
	signal   CRMCFGBRIDGEHOTRESET_indly  :  std_ulogic;
	signal   LLKTXDATA_indly  :  std_logic_vector(63 downto 0);
	signal   LLKTXSRCRDYN_indly  :  std_ulogic;
	signal   LLKTXSRCDSCN_indly  :  std_ulogic;
	signal   LLKTXCOMPLETEN_indly  :  std_ulogic;
	signal   LLKTXSOFN_indly  :  std_ulogic;
	signal   LLKTXEOFN_indly  :  std_ulogic;
	signal   LLKTXSOPN_indly  :  std_ulogic;
	signal   LLKTXEOPN_indly  :  std_ulogic;
	signal   LLKTXENABLEN_indly  :  std_logic_vector(1 downto 0);
	signal   LLKTXCHTC_indly  :  std_logic_vector(2 downto 0);
	signal   LLKTXCHFIFO_indly  :  std_logic_vector(1 downto 0);
	signal   LLKTXCREATEECRCN_indly  :  std_ulogic;
	signal   LLKTX4DWHEADERN_indly  :  std_ulogic;
	signal   LLKRXDSTREQN_indly  :  std_ulogic;
	signal   LLKRXCHTC_indly  :  std_logic_vector(2 downto 0);
	signal   LLKRXCHFIFO_indly  :  std_logic_vector(1 downto 0);
	signal   LLKRXDSTCONTREQN_indly  :  std_ulogic;
	signal   MGMTWDATA_indly  :  std_logic_vector(31 downto 0);
	signal   MGMTBWREN_indly  :  std_logic_vector(3 downto 0);
	signal   MGMTWREN_indly  :  std_ulogic;
	signal   MGMTADDR_indly  :  std_logic_vector(10 downto 0);
	signal   MGMTRDEN_indly  :  std_ulogic;
	signal   MGMTSTATSCREDITSEL_indly  :  std_logic_vector(6 downto 0);
	signal   MAINPOWER_indly  :  std_ulogic;
	signal   AUXPOWER_indly  :  std_ulogic;
	signal   L0TLLINKRETRAIN_indly  :  std_ulogic;
	signal   CFGNEGOTIATEDLINKWIDTH_indly  :  std_logic_vector(5 downto 0);
	signal   CROSSLINKSEED_indly  :  std_ulogic;
	signal   COMPLIANCEAVOID_indly  :  std_ulogic;
	signal   L0VC0PREVIEWEXPAND_indly  :  std_ulogic;
	signal   L0CFGVCID_indly  :  std_logic_vector(23 downto 0);
	signal   L0CFGLOOPBACKMASTER_indly  :  std_ulogic;
	signal   L0REPLAYTIMERADJUSTMENT_indly  :  std_logic_vector(11 downto 0);
	signal   L0ACKNAKTIMERADJUSTMENT_indly  :  std_logic_vector(11 downto 0);
	signal   L0DLLHOLDLINKUP_indly  :  std_ulogic;
	signal   L0CFGASSTATECHANGECMD_indly  :  std_logic_vector(3 downto 0);
	signal   L0CFGASSPANTREEOWNEDSTATE_indly  :  std_ulogic;
	signal   L0ASE_indly  :  std_ulogic;
	signal   L0ASTURNPOOLBITSCONSUMED_indly  :  std_logic_vector(2 downto 0);
	signal   L0ASPORTCOUNT_indly  :  std_logic_vector(7 downto 0);
	signal   L0CFGVCENABLE_indly  :  std_logic_vector(7 downto 0);
	signal   L0CFGNEGOTIATEDMAXP_indly  :  std_logic_vector(2 downto 0);
	signal   L0CFGDISABLESCRAMBLE_indly  :  std_ulogic;
	signal   L0CFGEXTENDEDSYNC_indly  :  std_ulogic;
	signal   L0CFGLINKDISABLE_indly  :  std_ulogic;
	signal   L0PORTNUMBER_indly  :  std_logic_vector(7 downto 0);
	signal   L0SENDUNLOCKMESSAGE_indly  :  std_ulogic;
	signal   L0ALLDOWNRXPORTSINL0S_indly  :  std_ulogic;
	signal   L0UPSTREAMRXPORTINL0S_indly  :  std_ulogic;
	signal   L0TRANSACTIONSPENDING_indly  :  std_ulogic;
	signal   L0ALLDOWNPORTSINL1_indly  :  std_ulogic;
	signal   L0FWDCORRERRIN_indly  :  std_ulogic;
	signal   L0FWDFATALERRIN_indly  :  std_ulogic;
	signal   L0FWDNONFATALERRIN_indly  :  std_ulogic;
	signal   L0SETCOMPLETERABORTERROR_indly  :  std_ulogic;
	signal   L0SETDETECTEDCORRERROR_indly  :  std_ulogic;
	signal   L0SETDETECTEDFATALERROR_indly  :  std_ulogic;
	signal   L0SETDETECTEDNONFATALERROR_indly  :  std_ulogic;
	signal   L0SETLINKDETECTEDPARITYERROR_indly  :  std_ulogic;
	signal   L0SETLINKMASTERDATAPARITY_indly  :  std_ulogic;
	signal   L0SETLINKRECEIVEDMASTERABORT_indly  :  std_ulogic;
	signal   L0SETLINKRECEIVEDTARGETABORT_indly  :  std_ulogic;
	signal   L0SETLINKSYSTEMERROR_indly  :  std_ulogic;
	signal   L0SETLINKSIGNALLEDTARGETABORT_indly  :  std_ulogic;
	signal   L0SETUSERDETECTEDPARITYERROR_indly  :  std_ulogic;
	signal   L0SETUSERMASTERDATAPARITY_indly  :  std_ulogic;
	signal   L0SETUSERRECEIVEDMASTERABORT_indly  :  std_ulogic;
	signal   L0SETUSERRECEIVEDTARGETABORT_indly  :  std_ulogic;
	signal   L0SETUSERSYSTEMERROR_indly  :  std_ulogic;
	signal   L0SETUSERSIGNALLEDTARGETABORT_indly  :  std_ulogic;
	signal   L0SETCOMPLETIONTIMEOUTUNCORRERROR_indly  :  std_ulogic;
	signal   L0SETCOMPLETIONTIMEOUTCORRERROR_indly  :  std_ulogic;
	signal   L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_indly  :  std_ulogic;
	signal   L0SETUNEXPECTEDCOMPLETIONCORRERROR_indly  :  std_ulogic;
	signal   L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_indly  :  std_ulogic;
	signal   L0SETUNSUPPORTEDREQUESTOTHERERROR_indly  :  std_ulogic;
	signal   L0PACKETHEADERFROMUSER_indly  :  std_logic_vector(127 downto 0);
	signal   L0LEGACYINTFUNCT0_indly  :  std_ulogic;
	signal   L0FWDASSERTINTALEGACYINT_indly  :  std_ulogic;
	signal   L0FWDASSERTINTBLEGACYINT_indly  :  std_ulogic;
	signal   L0FWDASSERTINTCLEGACYINT_indly  :  std_ulogic;
	signal   L0FWDASSERTINTDLEGACYINT_indly  :  std_ulogic;
	signal   L0FWDDEASSERTINTALEGACYINT_indly  :  std_ulogic;
	signal   L0FWDDEASSERTINTBLEGACYINT_indly  :  std_ulogic;
	signal   L0FWDDEASSERTINTCLEGACYINT_indly  :  std_ulogic;
	signal   L0FWDDEASSERTINTDLEGACYINT_indly  :  std_ulogic;
	signal   L0MSIREQUEST0_indly  :  std_logic_vector(3 downto 0);
	signal   L0ELECTROMECHANICALINTERLOCKENGAGED_indly  :  std_ulogic;
	signal   L0MRLSENSORCLOSEDN_indly  :  std_ulogic;
	signal   L0POWERFAULTDETECTED_indly  :  std_ulogic;
	signal   L0PRESENCEDETECTSLOTEMPTYN_indly  :  std_ulogic;
	signal   L0ATTENTIONBUTTONPRESSED_indly  :  std_ulogic;
	signal   L0TXBEACON_indly  :  std_ulogic;
	signal   L0WAKEN_indly  :  std_ulogic;
	signal   L0PMEREQIN_indly  :  std_ulogic;
	signal   L0ROOTTURNOFFREQ_indly  :  std_ulogic;
	signal   L0TXCFGPM_indly  :  std_ulogic;
	signal   L0TXCFGPMTYPE_indly  :  std_logic_vector(2 downto 0);
	signal   L0PWRNEWSTATEREQ_indly  :  std_ulogic;
	signal   L0PWRNEXTLINKSTATE_indly  :  std_logic_vector(1 downto 0);
	signal   L0CFGL0SENTRYSUP_indly  :  std_ulogic;
	signal   L0CFGL0SENTRYENABLE_indly  :  std_ulogic;
	signal   L0CFGL0SEXITLAT_indly  :  std_logic_vector(2 downto 0);
	signal   L0TXTLTLPDATA_indly  :  std_logic_vector(63 downto 0);
	signal   L0TXTLTLPEND_indly  :  std_logic_vector(1 downto 0);
	signal   L0TXTLTLPENABLE_indly  :  std_logic_vector(1 downto 0);
	signal   L0TXTLTLPEDB_indly  :  std_ulogic;
	signal   L0TXTLTLPREQ_indly  :  std_ulogic;
	signal   L0TXTLTLPREQEND_indly  :  std_ulogic;
	signal   L0TXTLTLPWIDTH_indly  :  std_ulogic;
	signal   L0TXTLTLPLATENCY_indly  :  std_logic_vector(3 downto 0);
	signal   L0TLASFCCREDSTARVATION_indly  :  std_ulogic;
	signal   L0TXTLSBFCDATA_indly  :  std_logic_vector(18 downto 0);
	signal   L0TXTLSBFCUPDATE_indly  :  std_ulogic;
	signal   L0TXTLFCNPOSTBYPCRED_indly  :  std_logic_vector(191 downto 0);
	signal   L0TXTLFCNPOSTBYPUPDATE_indly  :  std_logic_vector(15 downto 0);
	signal   L0TXTLFCPOSTORDCRED_indly  :  std_logic_vector(159 downto 0);
	signal   L0TXTLFCPOSTORDUPDATE_indly  :  std_logic_vector(15 downto 0);
	signal   L0TXTLFCCMPLMCCRED_indly  :  std_logic_vector(159 downto 0);
	signal   L0TXTLFCCMPLMCUPDATE_indly  :  std_logic_vector(15 downto 0);
	signal   L0RXTLTLPNONINITIALIZEDVC_indly  :  std_logic_vector(7 downto 0);

-- <!--Aldec correction start
	signal GSR_local : std_ulogic;
-- Aldec correction end -->

begin
	WireDelay : block
	begin
              VitalWireDelay (PIPERXELECIDLEL0_ipd,PIPERXELECIDLEL0,tipd_PIPERXELECIDLEL0);
           PIPERXSTATUSL0_DELAY : for i in 2 downto 0 generate
              VitalWireDelay (PIPERXSTATUSL0_ipd(i),PIPERXSTATUSL0(i),tipd_PIPERXSTATUSL0(i));
           end generate PIPERXSTATUSL0_DELAY;
           PIPERXDATAL0_DELAY : for i in 7 downto 0 generate
              VitalWireDelay (PIPERXDATAL0_ipd(i),PIPERXDATAL0(i),tipd_PIPERXDATAL0(i));
           end generate PIPERXDATAL0_DELAY;
              VitalWireDelay (PIPEPHYSTATUSL0_ipd,PIPEPHYSTATUSL0,tipd_PIPEPHYSTATUSL0);
              VitalWireDelay (PIPERXDATAKL0_ipd,PIPERXDATAKL0,tipd_PIPERXDATAKL0);
              VitalWireDelay (PIPERXVALIDL0_ipd,PIPERXVALIDL0,tipd_PIPERXVALIDL0);
              VitalWireDelay (PIPERXCHANISALIGNEDL0_ipd,PIPERXCHANISALIGNEDL0,tipd_PIPERXCHANISALIGNEDL0);
              VitalWireDelay (PIPERXELECIDLEL1_ipd,PIPERXELECIDLEL1,tipd_PIPERXELECIDLEL1);
           PIPERXSTATUSL1_DELAY : for i in 2 downto 0 generate
              VitalWireDelay (PIPERXSTATUSL1_ipd(i),PIPERXSTATUSL1(i),tipd_PIPERXSTATUSL1(i));
           end generate PIPERXSTATUSL1_DELAY;
           PIPERXDATAL1_DELAY : for i in 7 downto 0 generate
              VitalWireDelay (PIPERXDATAL1_ipd(i),PIPERXDATAL1(i),tipd_PIPERXDATAL1(i));
           end generate PIPERXDATAL1_DELAY;
              VitalWireDelay (PIPEPHYSTATUSL1_ipd,PIPEPHYSTATUSL1,tipd_PIPEPHYSTATUSL1);
              VitalWireDelay (PIPERXDATAKL1_ipd,PIPERXDATAKL1,tipd_PIPERXDATAKL1);
              VitalWireDelay (PIPERXVALIDL1_ipd,PIPERXVALIDL1,tipd_PIPERXVALIDL1);
              VitalWireDelay (PIPERXCHANISALIGNEDL1_ipd,PIPERXCHANISALIGNEDL1,tipd_PIPERXCHANISALIGNEDL1);
              VitalWireDelay (PIPERXELECIDLEL2_ipd,PIPERXELECIDLEL2,tipd_PIPERXELECIDLEL2);
           PIPERXSTATUSL2_DELAY : for i in 2 downto 0 generate
              VitalWireDelay (PIPERXSTATUSL2_ipd(i),PIPERXSTATUSL2(i),tipd_PIPERXSTATUSL2(i));
           end generate PIPERXSTATUSL2_DELAY;
           PIPERXDATAL2_DELAY : for i in 7 downto 0 generate
              VitalWireDelay (PIPERXDATAL2_ipd(i),PIPERXDATAL2(i),tipd_PIPERXDATAL2(i));
           end generate PIPERXDATAL2_DELAY;
              VitalWireDelay (PIPEPHYSTATUSL2_ipd,PIPEPHYSTATUSL2,tipd_PIPEPHYSTATUSL2);
              VitalWireDelay (PIPERXDATAKL2_ipd,PIPERXDATAKL2,tipd_PIPERXDATAKL2);
              VitalWireDelay (PIPERXVALIDL2_ipd,PIPERXVALIDL2,tipd_PIPERXVALIDL2);
              VitalWireDelay (PIPERXCHANISALIGNEDL2_ipd,PIPERXCHANISALIGNEDL2,tipd_PIPERXCHANISALIGNEDL2);
              VitalWireDelay (PIPERXELECIDLEL3_ipd,PIPERXELECIDLEL3,tipd_PIPERXELECIDLEL3);
           PIPERXSTATUSL3_DELAY : for i in 2 downto 0 generate
              VitalWireDelay (PIPERXSTATUSL3_ipd(i),PIPERXSTATUSL3(i),tipd_PIPERXSTATUSL3(i));
           end generate PIPERXSTATUSL3_DELAY;
           PIPERXDATAL3_DELAY : for i in 7 downto 0 generate
              VitalWireDelay (PIPERXDATAL3_ipd(i),PIPERXDATAL3(i),tipd_PIPERXDATAL3(i));
           end generate PIPERXDATAL3_DELAY;
              VitalWireDelay (PIPEPHYSTATUSL3_ipd,PIPEPHYSTATUSL3,tipd_PIPEPHYSTATUSL3);
              VitalWireDelay (PIPERXDATAKL3_ipd,PIPERXDATAKL3,tipd_PIPERXDATAKL3);
              VitalWireDelay (PIPERXVALIDL3_ipd,PIPERXVALIDL3,tipd_PIPERXVALIDL3);
              VitalWireDelay (PIPERXCHANISALIGNEDL3_ipd,PIPERXCHANISALIGNEDL3,tipd_PIPERXCHANISALIGNEDL3);
              VitalWireDelay (PIPERXELECIDLEL4_ipd,PIPERXELECIDLEL4,tipd_PIPERXELECIDLEL4);
           PIPERXSTATUSL4_DELAY : for i in 2 downto 0 generate
              VitalWireDelay (PIPERXSTATUSL4_ipd(i),PIPERXSTATUSL4(i),tipd_PIPERXSTATUSL4(i));
           end generate PIPERXSTATUSL4_DELAY;
           PIPERXDATAL4_DELAY : for i in 7 downto 0 generate
              VitalWireDelay (PIPERXDATAL4_ipd(i),PIPERXDATAL4(i),tipd_PIPERXDATAL4(i));
           end generate PIPERXDATAL4_DELAY;
              VitalWireDelay (PIPEPHYSTATUSL4_ipd,PIPEPHYSTATUSL4,tipd_PIPEPHYSTATUSL4);
              VitalWireDelay (PIPERXDATAKL4_ipd,PIPERXDATAKL4,tipd_PIPERXDATAKL4);
              VitalWireDelay (PIPERXVALIDL4_ipd,PIPERXVALIDL4,tipd_PIPERXVALIDL4);
              VitalWireDelay (PIPERXCHANISALIGNEDL4_ipd,PIPERXCHANISALIGNEDL4,tipd_PIPERXCHANISALIGNEDL4);
              VitalWireDelay (PIPERXELECIDLEL5_ipd,PIPERXELECIDLEL5,tipd_PIPERXELECIDLEL5);
           PIPERXSTATUSL5_DELAY : for i in 2 downto 0 generate
              VitalWireDelay (PIPERXSTATUSL5_ipd(i),PIPERXSTATUSL5(i),tipd_PIPERXSTATUSL5(i));
           end generate PIPERXSTATUSL5_DELAY;
           PIPERXDATAL5_DELAY : for i in 7 downto 0 generate
              VitalWireDelay (PIPERXDATAL5_ipd(i),PIPERXDATAL5(i),tipd_PIPERXDATAL5(i));
           end generate PIPERXDATAL5_DELAY;
              VitalWireDelay (PIPEPHYSTATUSL5_ipd,PIPEPHYSTATUSL5,tipd_PIPEPHYSTATUSL5);
              VitalWireDelay (PIPERXDATAKL5_ipd,PIPERXDATAKL5,tipd_PIPERXDATAKL5);
              VitalWireDelay (PIPERXVALIDL5_ipd,PIPERXVALIDL5,tipd_PIPERXVALIDL5);
              VitalWireDelay (PIPERXCHANISALIGNEDL5_ipd,PIPERXCHANISALIGNEDL5,tipd_PIPERXCHANISALIGNEDL5);
              VitalWireDelay (PIPERXELECIDLEL6_ipd,PIPERXELECIDLEL6,tipd_PIPERXELECIDLEL6);
           PIPERXSTATUSL6_DELAY : for i in 2 downto 0 generate
              VitalWireDelay (PIPERXSTATUSL6_ipd(i),PIPERXSTATUSL6(i),tipd_PIPERXSTATUSL6(i));
           end generate PIPERXSTATUSL6_DELAY;
           PIPERXDATAL6_DELAY : for i in 7 downto 0 generate
              VitalWireDelay (PIPERXDATAL6_ipd(i),PIPERXDATAL6(i),tipd_PIPERXDATAL6(i));
           end generate PIPERXDATAL6_DELAY;
              VitalWireDelay (PIPEPHYSTATUSL6_ipd,PIPEPHYSTATUSL6,tipd_PIPEPHYSTATUSL6);
              VitalWireDelay (PIPERXDATAKL6_ipd,PIPERXDATAKL6,tipd_PIPERXDATAKL6);
              VitalWireDelay (PIPERXVALIDL6_ipd,PIPERXVALIDL6,tipd_PIPERXVALIDL6);
              VitalWireDelay (PIPERXCHANISALIGNEDL6_ipd,PIPERXCHANISALIGNEDL6,tipd_PIPERXCHANISALIGNEDL6);
              VitalWireDelay (PIPERXELECIDLEL7_ipd,PIPERXELECIDLEL7,tipd_PIPERXELECIDLEL7);
           PIPERXSTATUSL7_DELAY : for i in 2 downto 0 generate
              VitalWireDelay (PIPERXSTATUSL7_ipd(i),PIPERXSTATUSL7(i),tipd_PIPERXSTATUSL7(i));
           end generate PIPERXSTATUSL7_DELAY;
           PIPERXDATAL7_DELAY : for i in 7 downto 0 generate
              VitalWireDelay (PIPERXDATAL7_ipd(i),PIPERXDATAL7(i),tipd_PIPERXDATAL7(i));
           end generate PIPERXDATAL7_DELAY;
              VitalWireDelay (PIPEPHYSTATUSL7_ipd,PIPEPHYSTATUSL7,tipd_PIPEPHYSTATUSL7);
              VitalWireDelay (PIPERXDATAKL7_ipd,PIPERXDATAKL7,tipd_PIPERXDATAKL7);
              VitalWireDelay (PIPERXVALIDL7_ipd,PIPERXVALIDL7,tipd_PIPERXVALIDL7);
              VitalWireDelay (PIPERXCHANISALIGNEDL7_ipd,PIPERXCHANISALIGNEDL7,tipd_PIPERXCHANISALIGNEDL7);
           MIMRXBRDATA_DELAY : for i in 63 downto 0 generate
              VitalWireDelay (MIMRXBRDATA_ipd(i),MIMRXBRDATA(i),tipd_MIMRXBRDATA(i));
           end generate MIMRXBRDATA_DELAY;
              VitalWireDelay (CRMCORECLKRXO_ipd,CRMCORECLKRXO,tipd_CRMCORECLKRXO);
              VitalWireDelay (CRMUSERCLKRXO_ipd,CRMUSERCLKRXO,tipd_CRMUSERCLKRXO);
           MIMTXBRDATA_DELAY : for i in 63 downto 0 generate
              VitalWireDelay (MIMTXBRDATA_ipd(i),MIMTXBRDATA(i),tipd_MIMTXBRDATA(i));
           end generate MIMTXBRDATA_DELAY;
              VitalWireDelay (CRMCORECLKTXO_ipd,CRMCORECLKTXO,tipd_CRMCORECLKTXO);
              VitalWireDelay (CRMUSERCLKTXO_ipd,CRMUSERCLKTXO,tipd_CRMUSERCLKTXO);
           MIMDLLBRDATA_DELAY : for i in 63 downto 0 generate
              VitalWireDelay (MIMDLLBRDATA_ipd(i),MIMDLLBRDATA(i),tipd_MIMDLLBRDATA(i));
           end generate MIMDLLBRDATA_DELAY;
              VitalWireDelay (CRMCORECLKDLO_ipd,CRMCORECLKDLO,tipd_CRMCORECLKDLO);
              VitalWireDelay (CRMCORECLK_ipd,CRMCORECLK,tipd_CRMCORECLK);
              VitalWireDelay (CRMUSERCLK_ipd,CRMUSERCLK,tipd_CRMUSERCLK);
              VitalWireDelay (CRMURSTN_ipd,CRMURSTN,tipd_CRMURSTN);
              VitalWireDelay (CRMNVRSTN_ipd,CRMNVRSTN,tipd_CRMNVRSTN);
              VitalWireDelay (CRMMGMTRSTN_ipd,CRMMGMTRSTN,tipd_CRMMGMTRSTN);
              VitalWireDelay (CRMUSERCFGRSTN_ipd,CRMUSERCFGRSTN,tipd_CRMUSERCFGRSTN);
              VitalWireDelay (CRMMACRSTN_ipd,CRMMACRSTN,tipd_CRMMACRSTN);
              VitalWireDelay (CRMLINKRSTN_ipd,CRMLINKRSTN,tipd_CRMLINKRSTN);
              VitalWireDelay (CRMTXHOTRESETN_ipd,CRMTXHOTRESETN,tipd_CRMTXHOTRESETN);
              VitalWireDelay (CRMCFGBRIDGEHOTRESET_ipd,CRMCFGBRIDGEHOTRESET,tipd_CRMCFGBRIDGEHOTRESET);
           LLKTXDATA_DELAY : for i in 63 downto 0 generate
              VitalWireDelay (LLKTXDATA_ipd(i),LLKTXDATA(i),tipd_LLKTXDATA(i));
           end generate LLKTXDATA_DELAY;
              VitalWireDelay (LLKTXSRCRDYN_ipd,LLKTXSRCRDYN,tipd_LLKTXSRCRDYN);
              VitalWireDelay (LLKTXSRCDSCN_ipd,LLKTXSRCDSCN,tipd_LLKTXSRCDSCN);
              VitalWireDelay (LLKTXCOMPLETEN_ipd,LLKTXCOMPLETEN,tipd_LLKTXCOMPLETEN);
              VitalWireDelay (LLKTXSOFN_ipd,LLKTXSOFN,tipd_LLKTXSOFN);
              VitalWireDelay (LLKTXEOFN_ipd,LLKTXEOFN,tipd_LLKTXEOFN);
              VitalWireDelay (LLKTXSOPN_ipd,LLKTXSOPN,tipd_LLKTXSOPN);
              VitalWireDelay (LLKTXEOPN_ipd,LLKTXEOPN,tipd_LLKTXEOPN);
           LLKTXENABLEN_DELAY : for i in 1 downto 0 generate
              VitalWireDelay (LLKTXENABLEN_ipd(i),LLKTXENABLEN(i),tipd_LLKTXENABLEN(i));
           end generate LLKTXENABLEN_DELAY;
           LLKTXCHTC_DELAY : for i in 2 downto 0 generate
              VitalWireDelay (LLKTXCHTC_ipd(i),LLKTXCHTC(i),tipd_LLKTXCHTC(i));
           end generate LLKTXCHTC_DELAY;
           LLKTXCHFIFO_DELAY : for i in 1 downto 0 generate
              VitalWireDelay (LLKTXCHFIFO_ipd(i),LLKTXCHFIFO(i),tipd_LLKTXCHFIFO(i));
           end generate LLKTXCHFIFO_DELAY;
              VitalWireDelay (LLKTXCREATEECRCN_ipd,LLKTXCREATEECRCN,tipd_LLKTXCREATEECRCN);
              VitalWireDelay (LLKTX4DWHEADERN_ipd,LLKTX4DWHEADERN,tipd_LLKTX4DWHEADERN);
              VitalWireDelay (LLKRXDSTREQN_ipd,LLKRXDSTREQN,tipd_LLKRXDSTREQN);
           LLKRXCHTC_DELAY : for i in 2 downto 0 generate
              VitalWireDelay (LLKRXCHTC_ipd(i),LLKRXCHTC(i),tipd_LLKRXCHTC(i));
           end generate LLKRXCHTC_DELAY;
           LLKRXCHFIFO_DELAY : for i in 1 downto 0 generate
              VitalWireDelay (LLKRXCHFIFO_ipd(i),LLKRXCHFIFO(i),tipd_LLKRXCHFIFO(i));
           end generate LLKRXCHFIFO_DELAY;
              VitalWireDelay (LLKRXDSTCONTREQN_ipd,LLKRXDSTCONTREQN,tipd_LLKRXDSTCONTREQN);
           MGMTWDATA_DELAY : for i in 31 downto 0 generate
              VitalWireDelay (MGMTWDATA_ipd(i),MGMTWDATA(i),tipd_MGMTWDATA(i));
           end generate MGMTWDATA_DELAY;
           MGMTBWREN_DELAY : for i in 3 downto 0 generate
              VitalWireDelay (MGMTBWREN_ipd(i),MGMTBWREN(i),tipd_MGMTBWREN(i));
           end generate MGMTBWREN_DELAY;
              VitalWireDelay (MGMTWREN_ipd,MGMTWREN,tipd_MGMTWREN);
           MGMTADDR_DELAY : for i in 10 downto 0 generate
              VitalWireDelay (MGMTADDR_ipd(i),MGMTADDR(i),tipd_MGMTADDR(i));
           end generate MGMTADDR_DELAY;
              VitalWireDelay (MGMTRDEN_ipd,MGMTRDEN,tipd_MGMTRDEN);
           MGMTSTATSCREDITSEL_DELAY : for i in 6 downto 0 generate
              VitalWireDelay (MGMTSTATSCREDITSEL_ipd(i),MGMTSTATSCREDITSEL(i),tipd_MGMTSTATSCREDITSEL(i));
           end generate MGMTSTATSCREDITSEL_DELAY;
              VitalWireDelay (MAINPOWER_ipd,MAINPOWER,tipd_MAINPOWER);
              VitalWireDelay (AUXPOWER_ipd,AUXPOWER,tipd_AUXPOWER);
              VitalWireDelay (L0TLLINKRETRAIN_ipd,L0TLLINKRETRAIN,tipd_L0TLLINKRETRAIN);
           CFGNEGOTIATEDLINKWIDTH_DELAY : for i in 5 downto 0 generate
              VitalWireDelay (CFGNEGOTIATEDLINKWIDTH_ipd(i),CFGNEGOTIATEDLINKWIDTH(i),tipd_CFGNEGOTIATEDLINKWIDTH(i));
           end generate CFGNEGOTIATEDLINKWIDTH_DELAY;
              VitalWireDelay (CROSSLINKSEED_ipd,CROSSLINKSEED,tipd_CROSSLINKSEED);
              VitalWireDelay (COMPLIANCEAVOID_ipd,COMPLIANCEAVOID,tipd_COMPLIANCEAVOID);
              VitalWireDelay (L0VC0PREVIEWEXPAND_ipd,L0VC0PREVIEWEXPAND,tipd_L0VC0PREVIEWEXPAND);
           L0CFGVCID_DELAY : for i in 23 downto 0 generate
              VitalWireDelay (L0CFGVCID_ipd(i),L0CFGVCID(i),tipd_L0CFGVCID(i));
           end generate L0CFGVCID_DELAY;
              VitalWireDelay (L0CFGLOOPBACKMASTER_ipd,L0CFGLOOPBACKMASTER,tipd_L0CFGLOOPBACKMASTER);
           L0REPLAYTIMERADJUSTMENT_DELAY : for i in 11 downto 0 generate
              VitalWireDelay (L0REPLAYTIMERADJUSTMENT_ipd(i),L0REPLAYTIMERADJUSTMENT(i),tipd_L0REPLAYTIMERADJUSTMENT(i));
           end generate L0REPLAYTIMERADJUSTMENT_DELAY;
           L0ACKNAKTIMERADJUSTMENT_DELAY : for i in 11 downto 0 generate
              VitalWireDelay (L0ACKNAKTIMERADJUSTMENT_ipd(i),L0ACKNAKTIMERADJUSTMENT(i),tipd_L0ACKNAKTIMERADJUSTMENT(i));
           end generate L0ACKNAKTIMERADJUSTMENT_DELAY;
              VitalWireDelay (L0DLLHOLDLINKUP_ipd,L0DLLHOLDLINKUP,tipd_L0DLLHOLDLINKUP);
           L0CFGASSTATECHANGECMD_DELAY : for i in 3 downto 0 generate
              VitalWireDelay (L0CFGASSTATECHANGECMD_ipd(i),L0CFGASSTATECHANGECMD(i),tipd_L0CFGASSTATECHANGECMD(i));
           end generate L0CFGASSTATECHANGECMD_DELAY;
              VitalWireDelay (L0CFGASSPANTREEOWNEDSTATE_ipd,L0CFGASSPANTREEOWNEDSTATE,tipd_L0CFGASSPANTREEOWNEDSTATE);
              VitalWireDelay (L0ASE_ipd,L0ASE,tipd_L0ASE);
           L0ASTURNPOOLBITSCONSUMED_DELAY : for i in 2 downto 0 generate
              VitalWireDelay (L0ASTURNPOOLBITSCONSUMED_ipd(i),L0ASTURNPOOLBITSCONSUMED(i),tipd_L0ASTURNPOOLBITSCONSUMED(i));
           end generate L0ASTURNPOOLBITSCONSUMED_DELAY;
           L0ASPORTCOUNT_DELAY : for i in 7 downto 0 generate
              VitalWireDelay (L0ASPORTCOUNT_ipd(i),L0ASPORTCOUNT(i),tipd_L0ASPORTCOUNT(i));
           end generate L0ASPORTCOUNT_DELAY;
           L0CFGVCENABLE_DELAY : for i in 7 downto 0 generate
              VitalWireDelay (L0CFGVCENABLE_ipd(i),L0CFGVCENABLE(i),tipd_L0CFGVCENABLE(i));
           end generate L0CFGVCENABLE_DELAY;
           L0CFGNEGOTIATEDMAXP_DELAY : for i in 2 downto 0 generate
              VitalWireDelay (L0CFGNEGOTIATEDMAXP_ipd(i),L0CFGNEGOTIATEDMAXP(i),tipd_L0CFGNEGOTIATEDMAXP(i));
           end generate L0CFGNEGOTIATEDMAXP_DELAY;
              VitalWireDelay (L0CFGDISABLESCRAMBLE_ipd,L0CFGDISABLESCRAMBLE,tipd_L0CFGDISABLESCRAMBLE);
              VitalWireDelay (L0CFGEXTENDEDSYNC_ipd,L0CFGEXTENDEDSYNC,tipd_L0CFGEXTENDEDSYNC);
              VitalWireDelay (L0CFGLINKDISABLE_ipd,L0CFGLINKDISABLE,tipd_L0CFGLINKDISABLE);
           L0PORTNUMBER_DELAY : for i in 7 downto 0 generate
              VitalWireDelay (L0PORTNUMBER_ipd(i),L0PORTNUMBER(i),tipd_L0PORTNUMBER(i));
           end generate L0PORTNUMBER_DELAY;
              VitalWireDelay (L0SENDUNLOCKMESSAGE_ipd,L0SENDUNLOCKMESSAGE,tipd_L0SENDUNLOCKMESSAGE);
              VitalWireDelay (L0ALLDOWNRXPORTSINL0S_ipd,L0ALLDOWNRXPORTSINL0S,tipd_L0ALLDOWNRXPORTSINL0S);
              VitalWireDelay (L0UPSTREAMRXPORTINL0S_ipd,L0UPSTREAMRXPORTINL0S,tipd_L0UPSTREAMRXPORTINL0S);
              VitalWireDelay (L0TRANSACTIONSPENDING_ipd,L0TRANSACTIONSPENDING,tipd_L0TRANSACTIONSPENDING);
              VitalWireDelay (L0ALLDOWNPORTSINL1_ipd,L0ALLDOWNPORTSINL1,tipd_L0ALLDOWNPORTSINL1);
              VitalWireDelay (L0FWDCORRERRIN_ipd,L0FWDCORRERRIN,tipd_L0FWDCORRERRIN);
              VitalWireDelay (L0FWDFATALERRIN_ipd,L0FWDFATALERRIN,tipd_L0FWDFATALERRIN);
              VitalWireDelay (L0FWDNONFATALERRIN_ipd,L0FWDNONFATALERRIN,tipd_L0FWDNONFATALERRIN);
              VitalWireDelay (L0SETCOMPLETERABORTERROR_ipd,L0SETCOMPLETERABORTERROR,tipd_L0SETCOMPLETERABORTERROR);
              VitalWireDelay (L0SETDETECTEDCORRERROR_ipd,L0SETDETECTEDCORRERROR,tipd_L0SETDETECTEDCORRERROR);
              VitalWireDelay (L0SETDETECTEDFATALERROR_ipd,L0SETDETECTEDFATALERROR,tipd_L0SETDETECTEDFATALERROR);
              VitalWireDelay (L0SETDETECTEDNONFATALERROR_ipd,L0SETDETECTEDNONFATALERROR,tipd_L0SETDETECTEDNONFATALERROR);
              VitalWireDelay (L0SETLINKDETECTEDPARITYERROR_ipd,L0SETLINKDETECTEDPARITYERROR,tipd_L0SETLINKDETECTEDPARITYERROR);
              VitalWireDelay (L0SETLINKMASTERDATAPARITY_ipd,L0SETLINKMASTERDATAPARITY,tipd_L0SETLINKMASTERDATAPARITY);
              VitalWireDelay (L0SETLINKRECEIVEDMASTERABORT_ipd,L0SETLINKRECEIVEDMASTERABORT,tipd_L0SETLINKRECEIVEDMASTERABORT);
              VitalWireDelay (L0SETLINKRECEIVEDTARGETABORT_ipd,L0SETLINKRECEIVEDTARGETABORT,tipd_L0SETLINKRECEIVEDTARGETABORT);
              VitalWireDelay (L0SETLINKSYSTEMERROR_ipd,L0SETLINKSYSTEMERROR,tipd_L0SETLINKSYSTEMERROR);
              VitalWireDelay (L0SETLINKSIGNALLEDTARGETABORT_ipd,L0SETLINKSIGNALLEDTARGETABORT,tipd_L0SETLINKSIGNALLEDTARGETABORT);
              VitalWireDelay (L0SETUSERDETECTEDPARITYERROR_ipd,L0SETUSERDETECTEDPARITYERROR,tipd_L0SETUSERDETECTEDPARITYERROR);
              VitalWireDelay (L0SETUSERMASTERDATAPARITY_ipd,L0SETUSERMASTERDATAPARITY,tipd_L0SETUSERMASTERDATAPARITY);
              VitalWireDelay (L0SETUSERRECEIVEDMASTERABORT_ipd,L0SETUSERRECEIVEDMASTERABORT,tipd_L0SETUSERRECEIVEDMASTERABORT);
              VitalWireDelay (L0SETUSERRECEIVEDTARGETABORT_ipd,L0SETUSERRECEIVEDTARGETABORT,tipd_L0SETUSERRECEIVEDTARGETABORT);
              VitalWireDelay (L0SETUSERSYSTEMERROR_ipd,L0SETUSERSYSTEMERROR,tipd_L0SETUSERSYSTEMERROR);
              VitalWireDelay (L0SETUSERSIGNALLEDTARGETABORT_ipd,L0SETUSERSIGNALLEDTARGETABORT,tipd_L0SETUSERSIGNALLEDTARGETABORT);
              VitalWireDelay (L0SETCOMPLETIONTIMEOUTUNCORRERROR_ipd,L0SETCOMPLETIONTIMEOUTUNCORRERROR,tipd_L0SETCOMPLETIONTIMEOUTUNCORRERROR);
              VitalWireDelay (L0SETCOMPLETIONTIMEOUTCORRERROR_ipd,L0SETCOMPLETIONTIMEOUTCORRERROR,tipd_L0SETCOMPLETIONTIMEOUTCORRERROR);
              VitalWireDelay (L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_ipd,L0SETUNEXPECTEDCOMPLETIONUNCORRERROR,tipd_L0SETUNEXPECTEDCOMPLETIONUNCORRERROR);
              VitalWireDelay (L0SETUNEXPECTEDCOMPLETIONCORRERROR_ipd,L0SETUNEXPECTEDCOMPLETIONCORRERROR,tipd_L0SETUNEXPECTEDCOMPLETIONCORRERROR);
              VitalWireDelay (L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_ipd,L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR,tipd_L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR);
              VitalWireDelay (L0SETUNSUPPORTEDREQUESTOTHERERROR_ipd,L0SETUNSUPPORTEDREQUESTOTHERERROR,tipd_L0SETUNSUPPORTEDREQUESTOTHERERROR);
           L0PACKETHEADERFROMUSER_DELAY : for i in 127 downto 0 generate
              VitalWireDelay (L0PACKETHEADERFROMUSER_ipd(i),L0PACKETHEADERFROMUSER(i),tipd_L0PACKETHEADERFROMUSER(i));
           end generate L0PACKETHEADERFROMUSER_DELAY;
              VitalWireDelay (L0LEGACYINTFUNCT0_ipd,L0LEGACYINTFUNCT0,tipd_L0LEGACYINTFUNCT0);
              VitalWireDelay (L0FWDASSERTINTALEGACYINT_ipd,L0FWDASSERTINTALEGACYINT,tipd_L0FWDASSERTINTALEGACYINT);
              VitalWireDelay (L0FWDASSERTINTBLEGACYINT_ipd,L0FWDASSERTINTBLEGACYINT,tipd_L0FWDASSERTINTBLEGACYINT);
              VitalWireDelay (L0FWDASSERTINTCLEGACYINT_ipd,L0FWDASSERTINTCLEGACYINT,tipd_L0FWDASSERTINTCLEGACYINT);
              VitalWireDelay (L0FWDASSERTINTDLEGACYINT_ipd,L0FWDASSERTINTDLEGACYINT,tipd_L0FWDASSERTINTDLEGACYINT);
              VitalWireDelay (L0FWDDEASSERTINTALEGACYINT_ipd,L0FWDDEASSERTINTALEGACYINT,tipd_L0FWDDEASSERTINTALEGACYINT);
              VitalWireDelay (L0FWDDEASSERTINTBLEGACYINT_ipd,L0FWDDEASSERTINTBLEGACYINT,tipd_L0FWDDEASSERTINTBLEGACYINT);
              VitalWireDelay (L0FWDDEASSERTINTCLEGACYINT_ipd,L0FWDDEASSERTINTCLEGACYINT,tipd_L0FWDDEASSERTINTCLEGACYINT);
              VitalWireDelay (L0FWDDEASSERTINTDLEGACYINT_ipd,L0FWDDEASSERTINTDLEGACYINT,tipd_L0FWDDEASSERTINTDLEGACYINT);
           L0MSIREQUEST0_DELAY : for i in 3 downto 0 generate
              VitalWireDelay (L0MSIREQUEST0_ipd(i),L0MSIREQUEST0(i),tipd_L0MSIREQUEST0(i));
           end generate L0MSIREQUEST0_DELAY;
              VitalWireDelay (L0ELECTROMECHANICALINTERLOCKENGAGED_ipd,L0ELECTROMECHANICALINTERLOCKENGAGED,tipd_L0ELECTROMECHANICALINTERLOCKENGAGED);
              VitalWireDelay (L0MRLSENSORCLOSEDN_ipd,L0MRLSENSORCLOSEDN,tipd_L0MRLSENSORCLOSEDN);
              VitalWireDelay (L0POWERFAULTDETECTED_ipd,L0POWERFAULTDETECTED,tipd_L0POWERFAULTDETECTED);
              VitalWireDelay (L0PRESENCEDETECTSLOTEMPTYN_ipd,L0PRESENCEDETECTSLOTEMPTYN,tipd_L0PRESENCEDETECTSLOTEMPTYN);
              VitalWireDelay (L0ATTENTIONBUTTONPRESSED_ipd,L0ATTENTIONBUTTONPRESSED,tipd_L0ATTENTIONBUTTONPRESSED);
              VitalWireDelay (L0TXBEACON_ipd,L0TXBEACON,tipd_L0TXBEACON);
              VitalWireDelay (L0WAKEN_ipd,L0WAKEN,tipd_L0WAKEN);
              VitalWireDelay (L0PMEREQIN_ipd,L0PMEREQIN,tipd_L0PMEREQIN);
              VitalWireDelay (L0ROOTTURNOFFREQ_ipd,L0ROOTTURNOFFREQ,tipd_L0ROOTTURNOFFREQ);
              VitalWireDelay (L0TXCFGPM_ipd,L0TXCFGPM,tipd_L0TXCFGPM);
           L0TXCFGPMTYPE_DELAY : for i in 2 downto 0 generate
              VitalWireDelay (L0TXCFGPMTYPE_ipd(i),L0TXCFGPMTYPE(i),tipd_L0TXCFGPMTYPE(i));
           end generate L0TXCFGPMTYPE_DELAY;
              VitalWireDelay (L0PWRNEWSTATEREQ_ipd,L0PWRNEWSTATEREQ,tipd_L0PWRNEWSTATEREQ);
           L0PWRNEXTLINKSTATE_DELAY : for i in 1 downto 0 generate
              VitalWireDelay (L0PWRNEXTLINKSTATE_ipd(i),L0PWRNEXTLINKSTATE(i),tipd_L0PWRNEXTLINKSTATE(i));
           end generate L0PWRNEXTLINKSTATE_DELAY;
              VitalWireDelay (L0CFGL0SENTRYSUP_ipd,L0CFGL0SENTRYSUP,tipd_L0CFGL0SENTRYSUP);
              VitalWireDelay (L0CFGL0SENTRYENABLE_ipd,L0CFGL0SENTRYENABLE,tipd_L0CFGL0SENTRYENABLE);
           L0CFGL0SEXITLAT_DELAY : for i in 2 downto 0 generate
              VitalWireDelay (L0CFGL0SEXITLAT_ipd(i),L0CFGL0SEXITLAT(i),tipd_L0CFGL0SEXITLAT(i));
           end generate L0CFGL0SEXITLAT_DELAY;
           L0TXTLTLPDATA_DELAY : for i in 63 downto 0 generate
              VitalWireDelay (L0TXTLTLPDATA_ipd(i),L0TXTLTLPDATA(i),tipd_L0TXTLTLPDATA(i));
           end generate L0TXTLTLPDATA_DELAY;
           L0TXTLTLPEND_DELAY : for i in 1 downto 0 generate
              VitalWireDelay (L0TXTLTLPEND_ipd(i),L0TXTLTLPEND(i),tipd_L0TXTLTLPEND(i));
           end generate L0TXTLTLPEND_DELAY;
           L0TXTLTLPENABLE_DELAY : for i in 1 downto 0 generate
              VitalWireDelay (L0TXTLTLPENABLE_ipd(i),L0TXTLTLPENABLE(i),tipd_L0TXTLTLPENABLE(i));
           end generate L0TXTLTLPENABLE_DELAY;
              VitalWireDelay (L0TXTLTLPEDB_ipd,L0TXTLTLPEDB,tipd_L0TXTLTLPEDB);
              VitalWireDelay (L0TXTLTLPREQ_ipd,L0TXTLTLPREQ,tipd_L0TXTLTLPREQ);
              VitalWireDelay (L0TXTLTLPREQEND_ipd,L0TXTLTLPREQEND,tipd_L0TXTLTLPREQEND);
              VitalWireDelay (L0TXTLTLPWIDTH_ipd,L0TXTLTLPWIDTH,tipd_L0TXTLTLPWIDTH);
           L0TXTLTLPLATENCY_DELAY : for i in 3 downto 0 generate
              VitalWireDelay (L0TXTLTLPLATENCY_ipd(i),L0TXTLTLPLATENCY(i),tipd_L0TXTLTLPLATENCY(i));
           end generate L0TXTLTLPLATENCY_DELAY;
              VitalWireDelay (L0TLASFCCREDSTARVATION_ipd,L0TLASFCCREDSTARVATION,tipd_L0TLASFCCREDSTARVATION);
           L0TXTLSBFCDATA_DELAY : for i in 18 downto 0 generate
              VitalWireDelay (L0TXTLSBFCDATA_ipd(i),L0TXTLSBFCDATA(i),tipd_L0TXTLSBFCDATA(i));
           end generate L0TXTLSBFCDATA_DELAY;
              VitalWireDelay (L0TXTLSBFCUPDATE_ipd,L0TXTLSBFCUPDATE,tipd_L0TXTLSBFCUPDATE);
           L0TXTLFCNPOSTBYPCRED_DELAY : for i in 191 downto 0 generate
              VitalWireDelay (L0TXTLFCNPOSTBYPCRED_ipd(i),L0TXTLFCNPOSTBYPCRED(i),tipd_L0TXTLFCNPOSTBYPCRED(i));
           end generate L0TXTLFCNPOSTBYPCRED_DELAY;
           L0TXTLFCNPOSTBYPUPDATE_DELAY : for i in 15 downto 0 generate
              VitalWireDelay (L0TXTLFCNPOSTBYPUPDATE_ipd(i),L0TXTLFCNPOSTBYPUPDATE(i),tipd_L0TXTLFCNPOSTBYPUPDATE(i));
           end generate L0TXTLFCNPOSTBYPUPDATE_DELAY;
           L0TXTLFCPOSTORDCRED_DELAY : for i in 159 downto 0 generate
              VitalWireDelay (L0TXTLFCPOSTORDCRED_ipd(i),L0TXTLFCPOSTORDCRED(i),tipd_L0TXTLFCPOSTORDCRED(i));
           end generate L0TXTLFCPOSTORDCRED_DELAY;
           L0TXTLFCPOSTORDUPDATE_DELAY : for i in 15 downto 0 generate
              VitalWireDelay (L0TXTLFCPOSTORDUPDATE_ipd(i),L0TXTLFCPOSTORDUPDATE(i),tipd_L0TXTLFCPOSTORDUPDATE(i));
           end generate L0TXTLFCPOSTORDUPDATE_DELAY;
           L0TXTLFCCMPLMCCRED_DELAY : for i in 159 downto 0 generate
              VitalWireDelay (L0TXTLFCCMPLMCCRED_ipd(i),L0TXTLFCCMPLMCCRED(i),tipd_L0TXTLFCCMPLMCCRED(i));
           end generate L0TXTLFCCMPLMCCRED_DELAY;
           L0TXTLFCCMPLMCUPDATE_DELAY : for i in 15 downto 0 generate
              VitalWireDelay (L0TXTLFCCMPLMCUPDATE_ipd(i),L0TXTLFCCMPLMCUPDATE(i),tipd_L0TXTLFCCMPLMCUPDATE(i));
           end generate L0TXTLFCCMPLMCUPDATE_DELAY;
           L0RXTLTLPNONINITIALIZEDVC_DELAY : for i in 7 downto 0 generate
              VitalWireDelay (L0RXTLTLPNONINITIALIZEDVC_ipd(i),L0RXTLTLPNONINITIALIZEDVC(i),tipd_L0RXTLTLPNONINITIALIZEDVC(i));
           end generate L0RXTLTLPNONINITIALIZEDVC_DELAY;
	end block;

	SignalDelay : block
	begin
       	VitalSignalDelay (PIPERXELECIDLEL0_CRMCORECLK_dly,PIPERXELECIDLEL0_ipd,tisd_PIPERXELECIDLEL0_CRMCORECLK);
	PIPERXSTATUSL0_DELAY : for i in 2 downto 0 generate
	VitalSignalDelay (PIPERXSTATUSL0_CRMCORECLK_dly(i),PIPERXSTATUSL0_ipd(i),tisd_PIPERXSTATUSL0_CRMCORECLK(i));
	end generate PIPERXSTATUSL0_DELAY;
	PIPERXDATAL0_DELAY : for i in 7 downto 0 generate
	VitalSignalDelay (PIPERXDATAL0_CRMCORECLK_dly(i),PIPERXDATAL0_ipd(i),tisd_PIPERXDATAL0_CRMCORECLK(i));
	end generate PIPERXDATAL0_DELAY;
	VitalSignalDelay (PIPEPHYSTATUSL0_CRMCORECLK_dly,PIPEPHYSTATUSL0_ipd,tisd_PIPEPHYSTATUSL0_CRMCORECLK);
	VitalSignalDelay (PIPERXDATAKL0_CRMCORECLK_dly,PIPERXDATAKL0_ipd,tisd_PIPERXDATAKL0_CRMCORECLK);
	VitalSignalDelay (PIPERXVALIDL0_CRMCORECLK_dly,PIPERXVALIDL0_ipd,tisd_PIPERXVALIDL0_CRMCORECLK);
	VitalSignalDelay (PIPERXCHANISALIGNEDL0_CRMCORECLK_dly,PIPERXCHANISALIGNEDL0_ipd,tisd_PIPERXCHANISALIGNEDL0_CRMCORECLK);
	VitalSignalDelay (PIPERXELECIDLEL1_CRMCORECLK_dly,PIPERXELECIDLEL1_ipd,tisd_PIPERXELECIDLEL1_CRMCORECLK);
	PIPERXSTATUSL1_DELAY : for i in 2 downto 0 generate
	VitalSignalDelay (PIPERXSTATUSL1_CRMCORECLK_dly(i),PIPERXSTATUSL1_ipd(i),tisd_PIPERXSTATUSL1_CRMCORECLK(i));
	end generate PIPERXSTATUSL1_DELAY;
	PIPERXDATAL1_DELAY : for i in 7 downto 0 generate
	VitalSignalDelay (PIPERXDATAL1_CRMCORECLK_dly(i),PIPERXDATAL1_ipd(i),tisd_PIPERXDATAL1_CRMCORECLK(i));
	end generate PIPERXDATAL1_DELAY;
	VitalSignalDelay (PIPEPHYSTATUSL1_CRMCORECLK_dly,PIPEPHYSTATUSL1_ipd,tisd_PIPEPHYSTATUSL1_CRMCORECLK);
	VitalSignalDelay (PIPERXDATAKL1_CRMCORECLK_dly,PIPERXDATAKL1_ipd,tisd_PIPERXDATAKL1_CRMCORECLK);
	VitalSignalDelay (PIPERXVALIDL1_CRMCORECLK_dly,PIPERXVALIDL1_ipd,tisd_PIPERXVALIDL1_CRMCORECLK);
	VitalSignalDelay (PIPERXCHANISALIGNEDL1_CRMCORECLK_dly,PIPERXCHANISALIGNEDL1_ipd,tisd_PIPERXCHANISALIGNEDL1_CRMCORECLK);
	VitalSignalDelay (PIPERXELECIDLEL2_CRMCORECLK_dly,PIPERXELECIDLEL2_ipd,tisd_PIPERXELECIDLEL2_CRMCORECLK);
	PIPERXSTATUSL2_DELAY : for i in 2 downto 0 generate
	VitalSignalDelay (PIPERXSTATUSL2_CRMCORECLK_dly(i),PIPERXSTATUSL2_ipd(i),tisd_PIPERXSTATUSL2_CRMCORECLK(i));
	end generate PIPERXSTATUSL2_DELAY;
	PIPERXDATAL2_DELAY : for i in 7 downto 0 generate
	VitalSignalDelay (PIPERXDATAL2_CRMCORECLK_dly(i),PIPERXDATAL2_ipd(i),tisd_PIPERXDATAL2_CRMCORECLK(i));
	end generate PIPERXDATAL2_DELAY;
	VitalSignalDelay (PIPEPHYSTATUSL2_CRMCORECLK_dly,PIPEPHYSTATUSL2_ipd,tisd_PIPEPHYSTATUSL2_CRMCORECLK);
	VitalSignalDelay (PIPERXDATAKL2_CRMCORECLK_dly,PIPERXDATAKL2_ipd,tisd_PIPERXDATAKL2_CRMCORECLK);
	VitalSignalDelay (PIPERXVALIDL2_CRMCORECLK_dly,PIPERXVALIDL2_ipd,tisd_PIPERXVALIDL2_CRMCORECLK);
	VitalSignalDelay (PIPERXCHANISALIGNEDL2_CRMCORECLK_dly,PIPERXCHANISALIGNEDL2_ipd,tisd_PIPERXCHANISALIGNEDL2_CRMCORECLK);
	VitalSignalDelay (PIPERXELECIDLEL3_CRMCORECLK_dly,PIPERXELECIDLEL3_ipd,tisd_PIPERXELECIDLEL3_CRMCORECLK);
	PIPERXSTATUSL3_DELAY : for i in 2 downto 0 generate
	VitalSignalDelay (PIPERXSTATUSL3_CRMCORECLK_dly(i),PIPERXSTATUSL3_ipd(i),tisd_PIPERXSTATUSL3_CRMCORECLK(i));
	end generate PIPERXSTATUSL3_DELAY;
	PIPERXDATAL3_DELAY : for i in 7 downto 0 generate
	VitalSignalDelay (PIPERXDATAL3_CRMCORECLK_dly(i),PIPERXDATAL3_ipd(i),tisd_PIPERXDATAL3_CRMCORECLK(i));
	end generate PIPERXDATAL3_DELAY;
	VitalSignalDelay (PIPEPHYSTATUSL3_CRMCORECLK_dly,PIPEPHYSTATUSL3_ipd,tisd_PIPEPHYSTATUSL3_CRMCORECLK);
	VitalSignalDelay (PIPERXDATAKL3_CRMCORECLK_dly,PIPERXDATAKL3_ipd,tisd_PIPERXDATAKL3_CRMCORECLK);
	VitalSignalDelay (PIPERXVALIDL3_CRMCORECLK_dly,PIPERXVALIDL3_ipd,tisd_PIPERXVALIDL3_CRMCORECLK);
	VitalSignalDelay (PIPERXCHANISALIGNEDL3_CRMCORECLK_dly,PIPERXCHANISALIGNEDL3_ipd,tisd_PIPERXCHANISALIGNEDL3_CRMCORECLK);
	VitalSignalDelay (PIPERXELECIDLEL4_CRMCORECLK_dly,PIPERXELECIDLEL4_ipd,tisd_PIPERXELECIDLEL4_CRMCORECLK);
	PIPERXSTATUSL4_DELAY : for i in 2 downto 0 generate
	VitalSignalDelay (PIPERXSTATUSL4_CRMCORECLK_dly(i),PIPERXSTATUSL4_ipd(i),tisd_PIPERXSTATUSL4_CRMCORECLK(i));
	end generate PIPERXSTATUSL4_DELAY;
	PIPERXDATAL4_DELAY : for i in 7 downto 0 generate
	VitalSignalDelay (PIPERXDATAL4_CRMCORECLK_dly(i),PIPERXDATAL4_ipd(i),tisd_PIPERXDATAL4_CRMCORECLK(i));
	end generate PIPERXDATAL4_DELAY;
	VitalSignalDelay (PIPEPHYSTATUSL4_CRMCORECLK_dly,PIPEPHYSTATUSL4_ipd,tisd_PIPEPHYSTATUSL4_CRMCORECLK);
	VitalSignalDelay (PIPERXDATAKL4_CRMCORECLK_dly,PIPERXDATAKL4_ipd,tisd_PIPERXDATAKL4_CRMCORECLK);
	VitalSignalDelay (PIPERXVALIDL4_CRMCORECLK_dly,PIPERXVALIDL4_ipd,tisd_PIPERXVALIDL4_CRMCORECLK);
	VitalSignalDelay (PIPERXCHANISALIGNEDL4_CRMCORECLK_dly,PIPERXCHANISALIGNEDL4_ipd,tisd_PIPERXCHANISALIGNEDL4_CRMCORECLK);
	VitalSignalDelay (PIPERXELECIDLEL5_CRMCORECLK_dly,PIPERXELECIDLEL5_ipd,tisd_PIPERXELECIDLEL5_CRMCORECLK);
	PIPERXSTATUSL5_DELAY : for i in 2 downto 0 generate
	VitalSignalDelay (PIPERXSTATUSL5_CRMCORECLK_dly(i),PIPERXSTATUSL5_ipd(i),tisd_PIPERXSTATUSL5_CRMCORECLK(i));
	end generate PIPERXSTATUSL5_DELAY;
	PIPERXDATAL5_DELAY : for i in 7 downto 0 generate
	VitalSignalDelay (PIPERXDATAL5_CRMCORECLK_dly(i),PIPERXDATAL5_ipd(i),tisd_PIPERXDATAL5_CRMCORECLK(i));
	end generate PIPERXDATAL5_DELAY;
	VitalSignalDelay (PIPEPHYSTATUSL5_CRMCORECLK_dly,PIPEPHYSTATUSL5_ipd,tisd_PIPEPHYSTATUSL5_CRMCORECLK);
	VitalSignalDelay (PIPERXDATAKL5_CRMCORECLK_dly,PIPERXDATAKL5_ipd,tisd_PIPERXDATAKL5_CRMCORECLK);
	VitalSignalDelay (PIPERXVALIDL5_CRMCORECLK_dly,PIPERXVALIDL5_ipd,tisd_PIPERXVALIDL5_CRMCORECLK);
	VitalSignalDelay (PIPERXCHANISALIGNEDL5_CRMCORECLK_dly,PIPERXCHANISALIGNEDL5_ipd,tisd_PIPERXCHANISALIGNEDL5_CRMCORECLK);
	VitalSignalDelay (PIPERXELECIDLEL6_CRMCORECLK_dly,PIPERXELECIDLEL6_ipd,tisd_PIPERXELECIDLEL6_CRMCORECLK);
	PIPERXSTATUSL6_DELAY : for i in 2 downto 0 generate
	VitalSignalDelay (PIPERXSTATUSL6_CRMCORECLK_dly(i),PIPERXSTATUSL6_ipd(i),tisd_PIPERXSTATUSL6_CRMCORECLK(i));
	end generate PIPERXSTATUSL6_DELAY;
	PIPERXDATAL6_DELAY : for i in 7 downto 0 generate
	VitalSignalDelay (PIPERXDATAL6_CRMCORECLK_dly(i),PIPERXDATAL6_ipd(i),tisd_PIPERXDATAL6_CRMCORECLK(i));
	end generate PIPERXDATAL6_DELAY;
	VitalSignalDelay (PIPEPHYSTATUSL6_CRMCORECLK_dly,PIPEPHYSTATUSL6_ipd,tisd_PIPEPHYSTATUSL6_CRMCORECLK);
	VitalSignalDelay (PIPERXDATAKL6_CRMCORECLK_dly,PIPERXDATAKL6_ipd,tisd_PIPERXDATAKL6_CRMCORECLK);
	VitalSignalDelay (PIPERXVALIDL6_CRMCORECLK_dly,PIPERXVALIDL6_ipd,tisd_PIPERXVALIDL6_CRMCORECLK);
	VitalSignalDelay (PIPERXCHANISALIGNEDL6_CRMCORECLK_dly,PIPERXCHANISALIGNEDL6_ipd,tisd_PIPERXCHANISALIGNEDL6_CRMCORECLK);
	VitalSignalDelay (PIPERXELECIDLEL7_CRMCORECLK_dly,PIPERXELECIDLEL7_ipd,tisd_PIPERXELECIDLEL7_CRMCORECLK);
	PIPERXSTATUSL7_DELAY : for i in 2 downto 0 generate
	VitalSignalDelay (PIPERXSTATUSL7_CRMCORECLK_dly(i),PIPERXSTATUSL7_ipd(i),tisd_PIPERXSTATUSL7_CRMCORECLK(i));
	end generate PIPERXSTATUSL7_DELAY;
	PIPERXDATAL7_DELAY : for i in 7 downto 0 generate
	VitalSignalDelay (PIPERXDATAL7_CRMCORECLK_dly(i),PIPERXDATAL7_ipd(i),tisd_PIPERXDATAL7_CRMCORECLK(i));
	end generate PIPERXDATAL7_DELAY;
	VitalSignalDelay (PIPEPHYSTATUSL7_CRMCORECLK_dly,PIPEPHYSTATUSL7_ipd,tisd_PIPEPHYSTATUSL7_CRMCORECLK);
	VitalSignalDelay (PIPERXDATAKL7_CRMCORECLK_dly,PIPERXDATAKL7_ipd,tisd_PIPERXDATAKL7_CRMCORECLK);
	VitalSignalDelay (PIPERXVALIDL7_CRMCORECLK_dly,PIPERXVALIDL7_ipd,tisd_PIPERXVALIDL7_CRMCORECLK);
	VitalSignalDelay (PIPERXCHANISALIGNEDL7_dly,PIPERXCHANISALIGNEDL7_ipd,tisd_PIPERXCHANISALIGNEDL7_CRMCORECLK);
	MIMRXBRDATA_DELAY : for i in 63 downto 0 generate
	VitalSignalDelay (MIMRXBRDATA_CRMCORECLK_dly(i),MIMRXBRDATA_ipd(i),tisd_MIMRXBRDATA_CRMCORECLK(i));
	end generate MIMRXBRDATA_DELAY;
	MIMTXBRDATA_DELAY : for i in 63 downto 0 generate
	VitalSignalDelay (MIMTXBRDATA_CRMCORECLK_dly(i),MIMTXBRDATA_ipd(i),tisd_MIMTXBRDATA_CRMCORECLK(i));
	end generate MIMTXBRDATA_DELAY;
	MIMDLLBRDATA_DELAY : for i in 63 downto 0 generate
	VitalSignalDelay (MIMDLLBRDATA_CRMCORECLK_dly(i),MIMDLLBRDATA_ipd(i),tisd_MIMDLLBRDATA_CRMCORECLK(i));
	end generate MIMDLLBRDATA_DELAY;
	VitalSignalDelay (CRMURSTN_CRMCORECLK_dly,CRMURSTN_ipd,tisd_CRMURSTN_CRMCORECLK);
	VitalSignalDelay (CRMNVRSTN_CRMCORECLK_dly,CRMNVRSTN_ipd,tisd_CRMNVRSTN_CRMCORECLK);
	VitalSignalDelay (CRMMGMTRSTN_CRMCORECLK_dly,CRMMGMTRSTN_ipd,tisd_CRMMGMTRSTN_CRMCORECLK);
	VitalSignalDelay (CRMUSERCFGRSTN_CRMCORECLK_dly,CRMUSERCFGRSTN_ipd,tisd_CRMUSERCFGRSTN_CRMCORECLK);
	VitalSignalDelay (CRMMACRSTN_CRMCORECLK_dly,CRMMACRSTN_ipd,tisd_CRMMACRSTN_CRMCORECLK);
	VitalSignalDelay (CRMLINKRSTN_CRMCORECLK_dly,CRMLINKRSTN_ipd,tisd_CRMLINKRSTN_CRMCORECLK);
	VitalSignalDelay (CRMTXHOTRESETN_CRMCORECLK_dly,CRMTXHOTRESETN_ipd,tisd_CRMTXHOTRESETN_CRMCORECLK);
	VitalSignalDelay (CRMCFGBRIDGEHOTRESET_CRMCORECLK_dly,CRMCFGBRIDGEHOTRESET_ipd,tisd_CRMCFGBRIDGEHOTRESET_CRMCORECLK);
	LLKTXDATA_DELAY : for i in 63 downto 0 generate
	VitalSignalDelay (LLKTXDATA_CRMCORECLK_dly(i),LLKTXDATA_ipd(i),tisd_LLKTXDATA_CRMCORECLK(i));
        VitalSignalDelay (LLKTXDATA_CRMUSERCLK_dly(i),LLKTXDATA_ipd(i),tisd_LLKTXDATA_CRMUSERCLK(i));
	end generate LLKTXDATA_DELAY;
	VitalSignalDelay (LLKTXSRCRDYN_CRMCORECLK_dly,LLKTXSRCRDYN_ipd,tisd_LLKTXSRCRDYN_CRMCORECLK);
        VitalSignalDelay (LLKTXSRCRDYN_CRMUSERCLK_dly,LLKTXSRCRDYN_ipd,tisd_LLKTXSRCRDYN_CRMUSERCLK);
	VitalSignalDelay (LLKTXSRCDSCN_CRMCORECLK_dly,LLKTXSRCDSCN_ipd,tisd_LLKTXSRCDSCN_CRMCORECLK);
        VitalSignalDelay (LLKTXSRCDSCN_CRMUSERCLK_dly,LLKTXSRCDSCN_ipd,tisd_LLKTXSRCDSCN_CRMUSERCLK);
	VitalSignalDelay (LLKTXCOMPLETEN_CRMCORECLK_dly,LLKTXCOMPLETEN_ipd,tisd_LLKTXCOMPLETEN_CRMCORECLK);
       	VitalSignalDelay (LLKTXCOMPLETEN_CRMUSERCLK_dly,LLKTXCOMPLETEN_ipd,tisd_LLKTXCOMPLETEN_CRMUSERCLK);
	VitalSignalDelay (LLKTXSOFN_CRMCORECLK_dly,LLKTXSOFN_ipd,tisd_LLKTXSOFN_CRMCORECLK);
        VitalSignalDelay (LLKTXSOFN_CRMUSERCLK_dly,LLKTXSOFN_ipd,tisd_LLKTXSOFN_CRMUSERCLK);
	VitalSignalDelay (LLKTXEOFN_CRMCORECLK_dly,LLKTXEOFN_ipd,tisd_LLKTXEOFN_CRMCORECLK);
        VitalSignalDelay (LLKTXEOFN_CRMUSERCLK_dly,LLKTXEOFN_ipd,tisd_LLKTXEOFN_CRMUSERCLK);
	VitalSignalDelay (LLKTXSOPN_CRMCORECLK_dly,LLKTXSOPN_ipd,tisd_LLKTXSOPN_CRMCORECLK);
        VitalSignalDelay (LLKTXSOPN_CRMUSERCLK_dly,LLKTXSOPN_ipd,tisd_LLKTXSOPN_CRMUSERCLK);
	VitalSignalDelay (LLKTXEOPN_CRMCORECLK_dly,LLKTXEOPN_ipd,tisd_LLKTXEOPN_CRMCORECLK);
        VitalSignalDelay (LLKTXEOPN_CRMUSERCLK_dly,LLKTXEOPN_ipd,tisd_LLKTXEOPN_CRMUSERCLK);
	LLKTXENABLEN_DELAY : for i in 1 downto 0 generate
	VitalSignalDelay (LLKTXENABLEN_CRMCORECLK_dly(i),LLKTXENABLEN_ipd(i),tisd_LLKTXENABLEN_CRMCORECLK(i));
        VitalSignalDelay (LLKTXENABLEN_CRMUSERCLK_dly(i),LLKTXENABLEN_ipd(i),tisd_LLKTXENABLEN_CRMUSERCLK(i));
	end generate LLKTXENABLEN_DELAY;
	LLKTXCHTC_DELAY : for i in 2 downto 0 generate
	VitalSignalDelay (LLKTXCHTC_CRMCORECLK_dly(i),LLKTXCHTC_ipd(i),tisd_LLKTXCHTC_CRMCORECLK(i));
        VitalSignalDelay (LLKTXCHTC_CRMUSERCLK_dly(i),LLKTXCHTC_ipd(i),tisd_LLKTXCHTC_CRMUSERCLK(i));
	end generate LLKTXCHTC_DELAY;
	LLKTXCHFIFO_DELAY : for i in 1 downto 0 generate
	VitalSignalDelay (LLKTXCHFIFO_CRMCORECLK_dly(i),LLKTXCHFIFO_ipd(i),tisd_LLKTXCHFIFO_CRMCORECLK(i));
        VitalSignalDelay (LLKTXCHFIFO_CRMUSERCLK_dly(i),LLKTXCHFIFO_ipd(i),tisd_LLKTXCHFIFO_CRMUSERCLK(i));
	end generate LLKTXCHFIFO_DELAY;
	VitalSignalDelay (LLKTXCREATEECRCN_CRMCORECLK_dly,LLKTXCREATEECRCN_ipd,tisd_LLKTXCREATEECRCN_CRMCORECLK);
        VitalSignalDelay (LLKTXCREATEECRCN_CRMUSERCLK_dly,LLKTXCREATEECRCN_ipd,tisd_LLKTXCREATEECRCN_CRMUSERCLK);
	VitalSignalDelay (LLKTX4DWHEADERN_CRMCORECLK_dly,LLKTX4DWHEADERN_ipd,tisd_LLKTX4DWHEADERN_CRMCORECLK);
        VitalSignalDelay (LLKTX4DWHEADERN_CRMUSERCLK_dly,LLKTX4DWHEADERN_ipd,tisd_LLKTX4DWHEADERN_CRMUSERCLK);
	VitalSignalDelay (LLKRXDSTREQN_CRMCORECLK_dly,LLKRXDSTREQN_ipd,tisd_LLKRXDSTREQN_CRMCORECLK);
        VitalSignalDelay (LLKRXDSTREQN_CRMUSERCLK_dly,LLKRXDSTREQN_ipd,tisd_LLKRXDSTREQN_CRMUSERCLK);
	LLKRXCHTC_DELAY : for i in 2 downto 0 generate
	VitalSignalDelay (LLKRXCHTC_CRMCORECLK_dly(i),LLKRXCHTC_ipd(i),tisd_LLKRXCHTC_CRMCORECLK(i));
        VitalSignalDelay (LLKRXCHTC_CRMUSERCLK_dly(i),LLKRXCHTC_ipd(i),tisd_LLKRXCHTC_CRMUSERCLK(i));
	end generate LLKRXCHTC_DELAY;
	LLKRXCHFIFO_DELAY : for i in 1 downto 0 generate
	VitalSignalDelay (LLKRXCHFIFO_CRMCORECLK_dly(i),LLKRXCHFIFO_ipd(i),tisd_LLKRXCHFIFO_CRMCORECLK(i));
       	VitalSignalDelay (LLKRXCHFIFO_CRMUSERCLK_dly(i),LLKRXCHFIFO_ipd(i),tisd_LLKRXCHFIFO_CRMUSERCLK(i));
	end generate LLKRXCHFIFO_DELAY;
	VitalSignalDelay (LLKRXDSTCONTREQN_CRMCORECLK_dly,LLKRXDSTCONTREQN_ipd,tisd_LLKRXDSTCONTREQN_CRMCORECLK);
        VitalSignalDelay (LLKRXDSTCONTREQN_CRMUSERCLK_dly,LLKRXDSTCONTREQN_ipd,tisd_LLKRXDSTCONTREQN_CRMUSERCLK);
	MGMTWDATA_DELAY : for i in 31 downto 0 generate
	VitalSignalDelay (MGMTWDATA_CRMCORECLK_dly(i),MGMTWDATA_ipd(i),tisd_MGMTWDATA_CRMCORECLK(i));
       	VitalSignalDelay (MGMTWDATA_CRMUSERCLK_dly(i),MGMTWDATA_ipd(i),tisd_MGMTWDATA_CRMUSERCLK(i));
	end generate MGMTWDATA_DELAY;
	MGMTBWREN_DELAY : for i in 3 downto 0 generate
	VitalSignalDelay (MGMTBWREN_CRMCORECLK_dly(i),MGMTBWREN_ipd(i),tisd_MGMTBWREN_CRMCORECLK(i));
        VitalSignalDelay (MGMTBWREN_CRMUSERCLK_dly(i),MGMTBWREN_ipd(i),tisd_MGMTBWREN_CRMUSERCLK(i));
	end generate MGMTBWREN_DELAY;
	VitalSignalDelay (MGMTWREN_CRMCORECLK_dly,MGMTWREN_ipd,tisd_MGMTWREN_CRMCORECLK);
        VitalSignalDelay (MGMTWREN_CRMUSERCLK_dly,MGMTWREN_ipd,tisd_MGMTWREN_CRMUSERCLK);
	MGMTADDR_DELAY : for i in 10 downto 0 generate
	VitalSignalDelay (MGMTADDR_CRMCORECLK_dly(i),MGMTADDR_ipd(i),tisd_MGMTADDR_CRMCORECLK(i));
        VitalSignalDelay (MGMTADDR_CRMUSERCLK_dly(i),MGMTADDR_ipd(i),tisd_MGMTADDR_CRMUSERCLK(i));
	end generate MGMTADDR_DELAY;
	VitalSignalDelay (MGMTRDEN_CRMCORECLK_dly,MGMTRDEN_ipd,tisd_MGMTRDEN_CRMCORECLK);
        VitalSignalDelay (MGMTRDEN_CRMUSERCLK_dly,MGMTRDEN_ipd,tisd_MGMTRDEN_CRMUSERCLK);
	MGMTSTATSCREDITSEL_DELAY : for i in 6 downto 0 generate
	VitalSignalDelay (MGMTSTATSCREDITSEL_CRMCORECLK_dly(i),MGMTSTATSCREDITSEL_ipd(i),tisd_MGMTSTATSCREDITSEL_CRMCORECLK(i));
        VitalSignalDelay (MGMTSTATSCREDITSEL_CRMUSERCLK_dly(i),MGMTSTATSCREDITSEL_ipd(i),tisd_MGMTSTATSCREDITSEL_CRMUSERCLK(i));
	end generate MGMTSTATSCREDITSEL_DELAY;
	VitalSignalDelay (MAINPOWER_CRMCORECLK_dly,MAINPOWER_ipd,tisd_MAINPOWER_CRMCORECLK);
	VitalSignalDelay (AUXPOWER_CRMCORECLK_dly,AUXPOWER_ipd,tisd_AUXPOWER_CRMCORECLK);
        VitalSignalDelay (AUXPOWER_CRMUSERCLK_dly,AUXPOWER_ipd,tisd_AUXPOWER_CRMUSERCLK);
	VitalSignalDelay (L0TLLINKRETRAIN_CRMCORECLK_dly,L0TLLINKRETRAIN_ipd,tisd_L0TLLINKRETRAIN_CRMCORECLK);
	CFGNEGOTIATEDLINKWIDTH_DELAY : for i in 5 downto 0 generate
	VitalSignalDelay (CFGNEGOTIATEDLINKWIDTH_CRMCORECLK_dly(i),CFGNEGOTIATEDLINKWIDTH_ipd(i),tisd_CFGNEGOTIATEDLINKWIDTH_CRMCORECLK(i));
	end generate CFGNEGOTIATEDLINKWIDTH_DELAY;
	VitalSignalDelay (CROSSLINKSEED_CRMCORECLK_dly,CROSSLINKSEED_ipd,tisd_CROSSLINKSEED_CRMCORECLK);
	VitalSignalDelay (COMPLIANCEAVOID_CRMCORECLK_dly,COMPLIANCEAVOID_ipd,tisd_COMPLIANCEAVOID_CRMCORECLK);
	VitalSignalDelay (L0VC0PREVIEWEXPAND_dly,L0VC0PREVIEWEXPAND_ipd,tisd_L0VC0PREVIEWEXPAND_CRMCORECLK);
	L0CFGVCID_DELAY : for i in 23 downto 0 generate
	VitalSignalDelay (L0CFGVCID_CRMCORECLK_dly(i),L0CFGVCID_ipd(i),tisd_L0CFGVCID_CRMCORECLK(i));
	end generate L0CFGVCID_DELAY;
	VitalSignalDelay (L0CFGLOOPBACKMASTER_CRMCORECLK_dly,L0CFGLOOPBACKMASTER_ipd,tisd_L0CFGLOOPBACKMASTER_CRMCORECLK);
	L0REPLAYTIMERADJUSTMENT_DELAY : for i in 11 downto 0 generate
	VitalSignalDelay (L0REPLAYTIMERADJUSTMENT_CRMCORECLK_dly(i),L0REPLAYTIMERADJUSTMENT_ipd(i),tisd_L0REPLAYTIMERADJUSTMENT_CRMCORECLK(i));
	end generate L0REPLAYTIMERADJUSTMENT_DELAY;
	L0ACKNAKTIMERADJUSTMENT_DELAY : for i in 11 downto 0 generate
	VitalSignalDelay (L0ACKNAKTIMERADJUSTMENT_CRMCORECLK_dly(i),L0ACKNAKTIMERADJUSTMENT_ipd(i),tisd_L0ACKNAKTIMERADJUSTMENT_CRMCORECLK(i));
	end generate L0ACKNAKTIMERADJUSTMENT_DELAY;
	VitalSignalDelay (L0DLLHOLDLINKUP_CRMCORECLK_dly,L0DLLHOLDLINKUP_ipd,tisd_L0DLLHOLDLINKUP_CRMCORECLK);
	L0CFGASSTATECHANGECMD_DELAY : for i in 3 downto 0 generate
	VitalSignalDelay (L0CFGASSTATECHANGECMD_CRMCORECLK_dly(i),L0CFGASSTATECHANGECMD_ipd(i),tisd_L0CFGASSTATECHANGECMD_CRMCORECLK(i));
	end generate L0CFGASSTATECHANGECMD_DELAY;
	VitalSignalDelay (L0CFGASSPANTREEOWNEDSTATE_CRMCORECLK_dly,L0CFGASSPANTREEOWNEDSTATE_ipd,tisd_L0CFGASSPANTREEOWNEDSTATE_CRMCORECLK);
	VitalSignalDelay (L0ASE_dly,L0ASE_ipd,tisd_L0ASE_CRMCORECLK);
	L0ASTURNPOOLBITSCONSUMED_DELAY : for i in 2 downto 0 generate
	VitalSignalDelay (L0ASTURNPOOLBITSCONSUMED_CRMCORECLK_dly(i),L0ASTURNPOOLBITSCONSUMED_ipd(i),tisd_L0ASTURNPOOLBITSCONSUMED_CRMCORECLK(i));
	end generate L0ASTURNPOOLBITSCONSUMED_DELAY;
	L0ASPORTCOUNT_DELAY : for i in 7 downto 0 generate
	VitalSignalDelay (L0ASPORTCOUNT_CRMCORECLK_dly(i),L0ASPORTCOUNT_ipd(i),tisd_L0ASPORTCOUNT_CRMCORECLK(i));
	end generate L0ASPORTCOUNT_DELAY;
	L0CFGVCENABLE_DELAY : for i in 7 downto 0 generate
	VitalSignalDelay (L0CFGVCENABLE_CRMCORECLK_dly(i),L0CFGVCENABLE_ipd(i),tisd_L0CFGVCENABLE_CRMCORECLK(i));
	end generate L0CFGVCENABLE_DELAY;
	L0CFGNEGOTIATEDMAXP_DELAY : for i in 2 downto 0 generate
	VitalSignalDelay (L0CFGNEGOTIATEDMAXP_CRMCORECLK_dly(i),L0CFGNEGOTIATEDMAXP_ipd(i),tisd_L0CFGNEGOTIATEDMAXP_CRMCORECLK(i));
	end generate L0CFGNEGOTIATEDMAXP_DELAY;
	VitalSignalDelay (L0CFGDISABLESCRAMBLE_CRMCORECLK_dly,L0CFGDISABLESCRAMBLE_ipd,tisd_L0CFGDISABLESCRAMBLE_CRMCORECLK);
	VitalSignalDelay (L0CFGEXTENDEDSYNC_CRMCORECLK_dly,L0CFGEXTENDEDSYNC_ipd,tisd_L0CFGEXTENDEDSYNC_CRMCORECLK);
	VitalSignalDelay (L0CFGLINKDISABLE_CRMCORECLK_dly,L0CFGLINKDISABLE_ipd,tisd_L0CFGLINKDISABLE_CRMCORECLK);
	L0PORTNUMBER_DELAY : for i in 7 downto 0 generate
	VitalSignalDelay (L0PORTNUMBER_CRMCORECLK_dly(i),L0PORTNUMBER_ipd(i),tisd_L0PORTNUMBER_CRMCORECLK(i));
        VitalSignalDelay (L0PORTNUMBER_CRMUSERCLK_dly(i),L0PORTNUMBER_ipd(i),tisd_L0PORTNUMBER_CRMUSERCLK(i));
	end generate L0PORTNUMBER_DELAY;
	VitalSignalDelay (L0SENDUNLOCKMESSAGE_CRMCORECLK_dly,L0SENDUNLOCKMESSAGE_ipd,tisd_L0SENDUNLOCKMESSAGE_CRMCORECLK);
        VitalSignalDelay (L0SENDUNLOCKMESSAGE_CRMUSERCLK_dly,L0SENDUNLOCKMESSAGE_ipd,tisd_L0SENDUNLOCKMESSAGE_CRMUSERCLK);
	VitalSignalDelay (L0ALLDOWNRXPORTSINL0S_CRMCORECLK_dly,L0ALLDOWNRXPORTSINL0S_ipd,tisd_L0ALLDOWNRXPORTSINL0S_CRMCORECLK);
        VitalSignalDelay (L0ALLDOWNRXPORTSINL0S_CRMUSERCLK_dly,L0ALLDOWNRXPORTSINL0S_ipd,tisd_L0ALLDOWNRXPORTSINL0S_CRMUSERCLK);
	VitalSignalDelay (L0UPSTREAMRXPORTINL0S_CRMCORECLK_dly,L0UPSTREAMRXPORTINL0S_ipd,tisd_L0UPSTREAMRXPORTINL0S_CRMCORECLK);
        VitalSignalDelay (L0UPSTREAMRXPORTINL0S_CRMUSERCLK_dly,L0UPSTREAMRXPORTINL0S_ipd,tisd_L0UPSTREAMRXPORTINL0S_CRMUSERCLK);
	VitalSignalDelay (L0TRANSACTIONSPENDING_CRMCORECLK_dly,L0TRANSACTIONSPENDING_ipd,tisd_L0TRANSACTIONSPENDING_CRMCORECLK);
        VitalSignalDelay (L0TRANSACTIONSPENDING_CRMUSERCLK_dly,L0TRANSACTIONSPENDING_ipd,tisd_L0TRANSACTIONSPENDING_CRMUSERCLK);
	VitalSignalDelay (L0ALLDOWNPORTSINL1_CRMCORECLK_dly,L0ALLDOWNPORTSINL1_ipd,tisd_L0ALLDOWNPORTSINL1_CRMCORECLK);
        VitalSignalDelay (L0ALLDOWNPORTSINL1_CRMUSERCLK_dly,L0ALLDOWNPORTSINL1_ipd,tisd_L0ALLDOWNPORTSINL1_CRMUSERCLK);
        VitalSignalDelay (L0FWDCORRERRIN_CRMCORECLK_dly,L0FWDCORRERRIN_ipd,tisd_L0FWDCORRERRIN_CRMCORECLK);
        VitalSignalDelay (L0FWDCORRERRIN_CRMUSERCLK_dly,L0FWDCORRERRIN_ipd,tisd_L0FWDCORRERRIN_CRMUSERCLK);
	VitalSignalDelay (L0FWDFATALERRIN_CRMCORECLK_dly,L0FWDFATALERRIN_ipd,tisd_L0FWDFATALERRIN_CRMCORECLK);
        VitalSignalDelay (L0FWDFATALERRIN_CRMUSERCLK_dly,L0FWDFATALERRIN_ipd,tisd_L0FWDFATALERRIN_CRMUSERCLK);
	VitalSignalDelay (L0FWDNONFATALERRIN_CRMCORECLK_dly,L0FWDNONFATALERRIN_ipd,tisd_L0FWDNONFATALERRIN_CRMCORECLK);
        VitalSignalDelay (L0FWDNONFATALERRIN_CRMUSERCLK_dly,L0FWDNONFATALERRIN_ipd,tisd_L0FWDNONFATALERRIN_CRMUSERCLK);
	VitalSignalDelay (L0SETCOMPLETERABORTERROR_CRMCORECLK_dly,L0SETCOMPLETERABORTERROR_ipd,tisd_L0SETCOMPLETERABORTERROR_CRMCORECLK);
        VitalSignalDelay (L0SETCOMPLETERABORTERROR_CRMUSERCLK_dly,L0SETCOMPLETERABORTERROR_ipd,tisd_L0SETCOMPLETERABORTERROR_CRMUSERCLK);
	VitalSignalDelay (L0SETDETECTEDCORRERROR_CRMCORECLK_dly,L0SETDETECTEDCORRERROR_ipd,tisd_L0SETDETECTEDCORRERROR_CRMCORECLK);
	VitalSignalDelay (L0SETDETECTEDFATALERROR_CRMCORECLK_dly,L0SETDETECTEDFATALERROR_ipd,tisd_L0SETDETECTEDFATALERROR_CRMCORECLK);
        VitalSignalDelay (L0SETDETECTEDFATALERROR_CRMUSERCLK_dly,L0SETDETECTEDFATALERROR_ipd,tisd_L0SETDETECTEDFATALERROR_CRMUSERCLK);
	VitalSignalDelay (L0SETDETECTEDNONFATALERROR_CRMCORECLK_dly,L0SETDETECTEDNONFATALERROR_ipd,tisd_L0SETDETECTEDNONFATALERROR_CRMCORECLK);
        VitalSignalDelay (L0SETDETECTEDNONFATALERROR_CRMUSERCLK_dly,L0SETDETECTEDNONFATALERROR_ipd,tisd_L0SETDETECTEDNONFATALERROR_CRMUSERCLK);
	VitalSignalDelay (L0SETLINKDETECTEDPARITYERROR_CRMCORECLK_dly,L0SETLINKDETECTEDPARITYERROR_ipd,tisd_L0SETLINKDETECTEDPARITYERROR_CRMCORECLK);
        VitalSignalDelay (L0SETLINKDETECTEDPARITYERROR_CRMUSERCLK_dly,L0SETLINKDETECTEDPARITYERROR_ipd,tisd_L0SETLINKDETECTEDPARITYERROR_CRMUSERCLK);
	VitalSignalDelay (L0SETLINKMASTERDATAPARITY_CRMCORECLK_dly,L0SETLINKMASTERDATAPARITY_ipd,tisd_L0SETLINKMASTERDATAPARITY_CRMCORECLK);
       	VitalSignalDelay (L0SETLINKMASTERDATAPARITY_CRMUSERCLK_dly,L0SETLINKMASTERDATAPARITY_ipd,tisd_L0SETLINKMASTERDATAPARITY_CRMUSERCLK);
	VitalSignalDelay (L0SETLINKRECEIVEDMASTERABORT_CRMCORECLK_dly,L0SETLINKRECEIVEDMASTERABORT_ipd,tisd_L0SETLINKRECEIVEDMASTERABORT_CRMCORECLK);
        VitalSignalDelay (L0SETLINKRECEIVEDMASTERABORT_CRMUSERCLK_dly,L0SETLINKRECEIVEDMASTERABORT_ipd,tisd_L0SETLINKRECEIVEDMASTERABORT_CRMUSERCLK);
	VitalSignalDelay (L0SETLINKRECEIVEDTARGETABORT_CRMCORECLK_dly,L0SETLINKRECEIVEDTARGETABORT_ipd,tisd_L0SETLINKRECEIVEDTARGETABORT_CRMCORECLK);
       	VitalSignalDelay (L0SETLINKRECEIVEDTARGETABORT_CRMUSERCLK_dly,L0SETLINKRECEIVEDTARGETABORT_ipd,tisd_L0SETLINKRECEIVEDTARGETABORT_CRMUSERCLK);
	VitalSignalDelay (L0SETLINKSYSTEMERROR_CRMCORECLK_dly,L0SETLINKSYSTEMERROR_ipd,tisd_L0SETLINKSYSTEMERROR_CRMCORECLK);
        VitalSignalDelay (L0SETLINKSYSTEMERROR_CRMUSERCLK_dly,L0SETLINKSYSTEMERROR_ipd,tisd_L0SETLINKSYSTEMERROR_CRMUSERCLK);
	VitalSignalDelay (L0SETLINKSIGNALLEDTARGETABORT_CRMCORECLK_dly,L0SETLINKSIGNALLEDTARGETABORT_ipd,tisd_L0SETLINKSIGNALLEDTARGETABORT_CRMCORECLK);
        VitalSignalDelay (L0SETLINKSIGNALLEDTARGETABORT_CRMUSERCLK_dly,L0SETLINKSIGNALLEDTARGETABORT_ipd,tisd_L0SETLINKSIGNALLEDTARGETABORT_CRMUSERCLK);
	VitalSignalDelay (L0SETUSERDETECTEDPARITYERROR_CRMCORECLK_dly,L0SETUSERDETECTEDPARITYERROR_ipd,tisd_L0SETUSERDETECTEDPARITYERROR_CRMCORECLK);
       	VitalSignalDelay (L0SETUSERDETECTEDPARITYERROR_CRMUSERCLK_dly,L0SETUSERDETECTEDPARITYERROR_ipd,tisd_L0SETUSERDETECTEDPARITYERROR_CRMUSERCLK);
	VitalSignalDelay (L0SETUSERMASTERDATAPARITY_CRMCORECLK_dly,L0SETUSERMASTERDATAPARITY_ipd,tisd_L0SETUSERMASTERDATAPARITY_CRMCORECLK);
        VitalSignalDelay (L0SETUSERMASTERDATAPARITY_CRMUSERCLK_dly,L0SETUSERMASTERDATAPARITY_ipd,tisd_L0SETUSERMASTERDATAPARITY_CRMUSERCLK);
	VitalSignalDelay (L0SETUSERRECEIVEDMASTERABORT_CRMCORECLK_dly,L0SETUSERRECEIVEDMASTERABORT_ipd,tisd_L0SETUSERRECEIVEDMASTERABORT_CRMCORECLK);
        VitalSignalDelay (L0SETUSERRECEIVEDMASTERABORT_CRMUSERCLK_dly,L0SETUSERRECEIVEDMASTERABORT_ipd,tisd_L0SETUSERRECEIVEDMASTERABORT_CRMUSERCLK);
	VitalSignalDelay (L0SETUSERRECEIVEDTARGETABORT_CRMCORECLK_dly,L0SETUSERRECEIVEDTARGETABORT_ipd,tisd_L0SETUSERRECEIVEDTARGETABORT_CRMCORECLK);
        VitalSignalDelay (L0SETUSERRECEIVEDTARGETABORT_CRMUSERCLK_dly,L0SETUSERRECEIVEDTARGETABORT_ipd,tisd_L0SETUSERRECEIVEDTARGETABORT_CRMUSERCLK);
	VitalSignalDelay (L0SETUSERSYSTEMERROR_CRMCORECLK_dly,L0SETUSERSYSTEMERROR_ipd,tisd_L0SETUSERSYSTEMERROR_CRMCORECLK);
        VitalSignalDelay (L0SETUSERSYSTEMERROR_CRMUSERCLK_dly,L0SETUSERSYSTEMERROR_ipd,tisd_L0SETUSERSYSTEMERROR_CRMUSERCLK);
	VitalSignalDelay (L0SETUSERSIGNALLEDTARGETABORT_CRMCORECLK_dly,L0SETUSERSIGNALLEDTARGETABORT_ipd,tisd_L0SETUSERSIGNALLEDTARGETABORT_CRMCORECLK);
        VitalSignalDelay (L0SETUSERSIGNALLEDTARGETABORT_CRMUSERCLK_dly,L0SETUSERSIGNALLEDTARGETABORT_ipd,tisd_L0SETUSERSIGNALLEDTARGETABORT_CRMUSERCLK);
	VitalSignalDelay (L0SETCOMPLETIONTIMEOUTUNCORRERROR_CRMCORECLK_dly,L0SETCOMPLETIONTIMEOUTUNCORRERROR_ipd,tisd_L0SETCOMPLETIONTIMEOUTUNCORRERROR_CRMCORECLK);
        VitalSignalDelay (L0SETCOMPLETIONTIMEOUTUNCORRERROR_CRMUSERCLK_dly,L0SETCOMPLETIONTIMEOUTUNCORRERROR_ipd,tisd_L0SETCOMPLETIONTIMEOUTUNCORRERROR_CRMUSERCLK);
	VitalSignalDelay (L0SETCOMPLETIONTIMEOUTCORRERROR_CRMCORECLK_dly,L0SETCOMPLETIONTIMEOUTCORRERROR_ipd,tisd_L0SETCOMPLETIONTIMEOUTCORRERROR_CRMCORECLK);
        VitalSignalDelay (L0SETCOMPLETIONTIMEOUTCORRERROR_CRMUSERCLK_dly,L0SETCOMPLETIONTIMEOUTCORRERROR_ipd,tisd_L0SETCOMPLETIONTIMEOUTCORRERROR_CRMUSERCLK);
	VitalSignalDelay (L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_CRMCORECLK_dly,L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_ipd,tisd_L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_CRMCORECLK);
        VitalSignalDelay (L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_CRMUSERCLK_dly,L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_ipd,tisd_L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_CRMUSERCLK);
        VitalSignalDelay (L0SETUNEXPECTEDCOMPLETIONCORRERROR_CRMCORECLK_dly,L0SETUNEXPECTEDCOMPLETIONCORRERROR_ipd,tisd_L0SETUNEXPECTEDCOMPLETIONCORRERROR_CRMCORECLK);
       	VitalSignalDelay (L0SETUNEXPECTEDCOMPLETIONCORRERROR_CRMUSERCLK_dly,L0SETUNEXPECTEDCOMPLETIONCORRERROR_ipd,tisd_L0SETUNEXPECTEDCOMPLETIONCORRERROR_CRMUSERCLK);
	VitalSignalDelay (L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_CRMCORECLK_dly,L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_ipd,tisd_L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_CRMCORECLK);
        VitalSignalDelay (L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_CRMUSERCLK_dly,L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_ipd,tisd_L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_CRMUSERCLK);
	VitalSignalDelay (L0SETUNSUPPORTEDREQUESTOTHERERROR_CRMCORECLK_dly,L0SETUNSUPPORTEDREQUESTOTHERERROR_ipd,tisd_L0SETUNSUPPORTEDREQUESTOTHERERROR_CRMCORECLK);
        VitalSignalDelay (L0SETUNSUPPORTEDREQUESTOTHERERROR_CRMUSERCLK_dly,L0SETUNSUPPORTEDREQUESTOTHERERROR_ipd,tisd_L0SETUNSUPPORTEDREQUESTOTHERERROR_CRMUSERCLK);
	L0PACKETHEADERFROMUSER_DELAY : for i in 127 downto 0 generate
	VitalSignalDelay (L0PACKETHEADERFROMUSER_CRMCORECLK_dly(i),L0PACKETHEADERFROMUSER_ipd(i),tisd_L0PACKETHEADERFROMUSER_CRMCORECLK(i));
        VitalSignalDelay (L0PACKETHEADERFROMUSER_CRMUSERCLK_dly(i),L0PACKETHEADERFROMUSER_ipd(i),tisd_L0PACKETHEADERFROMUSER_CRMUSERCLK(i));
	end generate L0PACKETHEADERFROMUSER_DELAY;
	VitalSignalDelay (L0LEGACYINTFUNCT0_CRMCORECLK_dly,L0LEGACYINTFUNCT0_ipd,tisd_L0LEGACYINTFUNCT0_CRMCORECLK);
        VitalSignalDelay (L0LEGACYINTFUNCT0_CRMUSERCLK_dly,L0LEGACYINTFUNCT0_ipd,tisd_L0LEGACYINTFUNCT0_CRMUSERCLK);
	VitalSignalDelay (L0FWDASSERTINTALEGACYINT_CRMCORECLK_dly,L0FWDASSERTINTALEGACYINT_ipd,tisd_L0FWDASSERTINTALEGACYINT_CRMCORECLK);
        VitalSignalDelay (L0FWDASSERTINTALEGACYINT_CRMUSERCLK_dly,L0FWDASSERTINTALEGACYINT_ipd,tisd_L0FWDASSERTINTALEGACYINT_CRMUSERCLK);
	VitalSignalDelay (L0FWDASSERTINTBLEGACYINT_CRMCORECLK_dly,L0FWDASSERTINTBLEGACYINT_ipd,tisd_L0FWDASSERTINTBLEGACYINT_CRMCORECLK);
        VitalSignalDelay (L0FWDASSERTINTBLEGACYINT_CRMUSERCLK_dly,L0FWDASSERTINTBLEGACYINT_ipd,tisd_L0FWDASSERTINTBLEGACYINT_CRMUSERCLK);
	VitalSignalDelay (L0FWDASSERTINTCLEGACYINT_CRMCORECLK_dly,L0FWDASSERTINTCLEGACYINT_ipd,tisd_L0FWDASSERTINTCLEGACYINT_CRMCORECLK);
        VitalSignalDelay (L0FWDASSERTINTCLEGACYINT_CRMUSERCLK_dly,L0FWDASSERTINTCLEGACYINT_ipd,tisd_L0FWDASSERTINTCLEGACYINT_CRMUSERCLK);
	VitalSignalDelay (L0FWDASSERTINTDLEGACYINT_CRMCORECLK_dly,L0FWDASSERTINTDLEGACYINT_ipd,tisd_L0FWDASSERTINTDLEGACYINT_CRMCORECLK);
        VitalSignalDelay (L0FWDASSERTINTDLEGACYINT_CRMUSERCLK_dly,L0FWDASSERTINTDLEGACYINT_ipd,tisd_L0FWDASSERTINTDLEGACYINT_CRMUSERCLK);
	VitalSignalDelay (L0FWDDEASSERTINTALEGACYINT_CRMCORECLK_dly,L0FWDDEASSERTINTALEGACYINT_ipd,tisd_L0FWDDEASSERTINTALEGACYINT_CRMCORECLK);
       	VitalSignalDelay (L0FWDDEASSERTINTALEGACYINT_CRMUSERCLK_dly,L0FWDDEASSERTINTALEGACYINT_ipd,tisd_L0FWDDEASSERTINTALEGACYINT_CRMUSERCLK);
	VitalSignalDelay (L0FWDDEASSERTINTBLEGACYINT_CRMCORECLK_dly,L0FWDDEASSERTINTBLEGACYINT_ipd,tisd_L0FWDDEASSERTINTBLEGACYINT_CRMCORECLK);
        VitalSignalDelay (L0FWDDEASSERTINTBLEGACYINT_CRMUSERCLK_dly,L0FWDDEASSERTINTBLEGACYINT_ipd,tisd_L0FWDDEASSERTINTBLEGACYINT_CRMUSERCLK);
	VitalSignalDelay (L0FWDDEASSERTINTCLEGACYINT_CRMCORECLK_dly,L0FWDDEASSERTINTCLEGACYINT_ipd,tisd_L0FWDDEASSERTINTCLEGACYINT_CRMCORECLK);
        VitalSignalDelay (L0FWDDEASSERTINTCLEGACYINT_CRMUSERCLK_dly,L0FWDDEASSERTINTCLEGACYINT_ipd,tisd_L0FWDDEASSERTINTCLEGACYINT_CRMUSERCLK);
	VitalSignalDelay (L0FWDDEASSERTINTDLEGACYINT_CRMCORECLK_dly,L0FWDDEASSERTINTDLEGACYINT_ipd,tisd_L0FWDDEASSERTINTDLEGACYINT_CRMCORECLK);
        VitalSignalDelay (L0FWDDEASSERTINTDLEGACYINT_CRMUSERCLK_dly,L0FWDDEASSERTINTDLEGACYINT_ipd,tisd_L0FWDDEASSERTINTDLEGACYINT_CRMUSERCLK);
	L0MSIREQUEST0_DELAY : for i in 3 downto 0 generate
	VitalSignalDelay (L0MSIREQUEST0_CRMCORECLK_dly(i),L0MSIREQUEST0_ipd(i),tisd_L0MSIREQUEST0_CRMCORECLK(i));
        VitalSignalDelay (L0MSIREQUEST0_CRMUSERCLK_dly(i),L0MSIREQUEST0_ipd(i),tisd_L0MSIREQUEST0_CRMUSERCLK(i));
	end generate L0MSIREQUEST0_DELAY;
	VitalSignalDelay (L0ELECTROMECHANICALINTERLOCKENGAGED_CRMCORECLK_dly,L0ELECTROMECHANICALINTERLOCKENGAGED_ipd,tisd_L0ELECTROMECHANICALINTERLOCKENGAGED_CRMCORECLK);
       	VitalSignalDelay (L0ELECTROMECHANICALINTERLOCKENGAGED_CRMUSERCLK_dly,L0ELECTROMECHANICALINTERLOCKENGAGED_ipd,tisd_L0ELECTROMECHANICALINTERLOCKENGAGED_CRMUSERCLK);
	VitalSignalDelay (L0MRLSENSORCLOSEDN_CRMCORECLK_dly,L0MRLSENSORCLOSEDN_ipd,tisd_L0MRLSENSORCLOSEDN_CRMCORECLK);
       	VitalSignalDelay (L0MRLSENSORCLOSEDN_CRMUSERCLK_dly,L0MRLSENSORCLOSEDN_ipd,tisd_L0MRLSENSORCLOSEDN_CRMUSERCLK);
	VitalSignalDelay (L0POWERFAULTDETECTED_CRMCORECLK_dly,L0POWERFAULTDETECTED_ipd,tisd_L0POWERFAULTDETECTED_CRMCORECLK);
        VitalSignalDelay (L0POWERFAULTDETECTED_CRMUSERCLK_dly,L0POWERFAULTDETECTED_ipd,tisd_L0POWERFAULTDETECTED_CRMUSERCLK);
	VitalSignalDelay (L0PRESENCEDETECTSLOTEMPTYN_CRMCORECLK_dly,L0PRESENCEDETECTSLOTEMPTYN_ipd,tisd_L0PRESENCEDETECTSLOTEMPTYN_CRMCORECLK);
        VitalSignalDelay (L0PRESENCEDETECTSLOTEMPTYN_CRMUSERCLK_dly,L0PRESENCEDETECTSLOTEMPTYN_ipd,tisd_L0PRESENCEDETECTSLOTEMPTYN_CRMUSERCLK);
	VitalSignalDelay (L0ATTENTIONBUTTONPRESSED_CRMCORECLK_dly,L0ATTENTIONBUTTONPRESSED_ipd,tisd_L0ATTENTIONBUTTONPRESSED_CRMCORECLK);
        VitalSignalDelay (L0ATTENTIONBUTTONPRESSED_CRMUSERCLK_dly,L0ATTENTIONBUTTONPRESSED_ipd,tisd_L0ATTENTIONBUTTONPRESSED_CRMUSERCLK);
	VitalSignalDelay (L0TXBEACON_CRMCORECLK_dly,L0TXBEACON_ipd,tisd_L0TXBEACON_CRMCORECLK);
	VitalSignalDelay (L0WAKEN_CRMCORECLK_dly,L0WAKEN_ipd,tisd_L0WAKEN_CRMCORECLK);
	VitalSignalDelay (L0PMEREQIN_CRMCORECLK_dly,L0PMEREQIN_ipd,tisd_L0PMEREQIN_CRMCORECLK);
	VitalSignalDelay (L0ROOTTURNOFFREQ_CRMCORECLK_dly,L0ROOTTURNOFFREQ_ipd,tisd_L0ROOTTURNOFFREQ_CRMCORECLK);
       	VitalSignalDelay (L0ROOTTURNOFFREQ_CRMUSERCLK_dly,L0ROOTTURNOFFREQ_ipd,tisd_L0ROOTTURNOFFREQ_CRMUSERCLK);
	VitalSignalDelay (L0TXCFGPM_CRMCORECLK_dly,L0TXCFGPM_ipd,tisd_L0TXCFGPM_CRMCORECLK);
	L0TXCFGPMTYPE_DELAY : for i in 2 downto 0 generate
	VitalSignalDelay (L0TXCFGPMTYPE_CRMCORECLK_dly(i),L0TXCFGPMTYPE_ipd(i),tisd_L0TXCFGPMTYPE_CRMCORECLK(i));
	end generate L0TXCFGPMTYPE_DELAY;
	VitalSignalDelay (L0PWRNEWSTATEREQ_CRMCORECLK_dly,L0PWRNEWSTATEREQ_ipd,tisd_L0PWRNEWSTATEREQ_CRMCORECLK);
	L0PWRNEXTLINKSTATE_DELAY : for i in 1 downto 0 generate
	VitalSignalDelay (L0PWRNEXTLINKSTATE_CRMCORECLK_dly(i),L0PWRNEXTLINKSTATE_ipd(i),tisd_L0PWRNEXTLINKSTATE_CRMCORECLK(i));
	end generate L0PWRNEXTLINKSTATE_DELAY;
	VitalSignalDelay (L0CFGL0SENTRYSUP_CRMCORECLK_dly,L0CFGL0SENTRYSUP_ipd,tisd_L0CFGL0SENTRYSUP_CRMCORECLK);
	VitalSignalDelay (L0CFGL0SENTRYENABLE_CRMCORECLK_dly,L0CFGL0SENTRYENABLE_ipd,tisd_L0CFGL0SENTRYENABLE_CRMCORECLK);
	L0CFGL0SEXITLAT_DELAY : for i in 2 downto 0 generate
	VitalSignalDelay (L0CFGL0SEXITLAT_CRMCORECLK_dly(i),L0CFGL0SEXITLAT_ipd(i),tisd_L0CFGL0SEXITLAT_CRMCORECLK(i));
	end generate L0CFGL0SEXITLAT_DELAY;
	L0TXTLTLPDATA_DELAY : for i in 63 downto 0 generate
	VitalSignalDelay (L0TXTLTLPDATA_CRMCORECLK_dly(i),L0TXTLTLPDATA_ipd(i),tisd_L0TXTLTLPDATA_CRMCORECLK(i));
	end generate L0TXTLTLPDATA_DELAY;
	L0TXTLTLPEND_DELAY : for i in 1 downto 0 generate
	VitalSignalDelay (L0TXTLTLPEND_CRMCORECLK_dly(i),L0TXTLTLPEND_ipd(i),tisd_L0TXTLTLPEND_CRMCORECLK(i));
	end generate L0TXTLTLPEND_DELAY;
	L0TXTLTLPENABLE_DELAY : for i in 1 downto 0 generate
	VitalSignalDelay (L0TXTLTLPENABLE_CRMCORECLK_dly(i),L0TXTLTLPENABLE_ipd(i),tisd_L0TXTLTLPENABLE_CRMCORECLK(i));
	end generate L0TXTLTLPENABLE_DELAY;
	VitalSignalDelay (L0TXTLTLPEDB_CRMCORECLK_dly,L0TXTLTLPEDB_ipd,tisd_L0TXTLTLPEDB_CRMCORECLK);
	VitalSignalDelay (L0TXTLTLPREQ_CRMCORECLK_dly,L0TXTLTLPREQ_ipd,tisd_L0TXTLTLPREQ_CRMCORECLK);
	VitalSignalDelay (L0TXTLTLPREQEND_CRMCORECLK_dly,L0TXTLTLPREQEND_ipd,tisd_L0TXTLTLPREQEND_CRMCORECLK);
	VitalSignalDelay (L0TXTLTLPWIDTH_CRMCORECLK_dly,L0TXTLTLPWIDTH_ipd,tisd_L0TXTLTLPWIDTH_CRMCORECLK);
	L0TXTLTLPLATENCY_DELAY : for i in 3 downto 0 generate
	VitalSignalDelay (L0TXTLTLPLATENCY_CRMCORECLK_dly(i),L0TXTLTLPLATENCY_ipd(i),tisd_L0TXTLTLPLATENCY_CRMCORECLK(i));
	end generate L0TXTLTLPLATENCY_DELAY;
	VitalSignalDelay (L0TLASFCCREDSTARVATION_CRMCORECLK_dly,L0TLASFCCREDSTARVATION_ipd,tisd_L0TLASFCCREDSTARVATION_CRMCORECLK);
	L0TXTLSBFCDATA_DELAY : for i in 18 downto 0 generate
	VitalSignalDelay (L0TXTLSBFCDATA_CRMCORECLK_dly(i),L0TXTLSBFCDATA_ipd(i),tisd_L0TXTLSBFCDATA_CRMCORECLK(i));
	end generate L0TXTLSBFCDATA_DELAY;
	VitalSignalDelay (L0TXTLSBFCUPDATE_CRMCORECLK_dly,L0TXTLSBFCUPDATE_ipd,tisd_L0TXTLSBFCUPDATE_CRMCORECLK);
	L0TXTLFCNPOSTBYPCRED_DELAY : for i in 191 downto 0 generate
	VitalSignalDelay (L0TXTLFCNPOSTBYPCRED_CRMCORECLK_dly(i),L0TXTLFCNPOSTBYPCRED_ipd(i),tisd_L0TXTLFCNPOSTBYPCRED_CRMCORECLK(i));
	end generate L0TXTLFCNPOSTBYPCRED_DELAY;
	L0TXTLFCNPOSTBYPUPDATE_DELAY : for i in 15 downto 0 generate
	VitalSignalDelay (L0TXTLFCNPOSTBYPUPDATE_CRMCORECLK_dly(i),L0TXTLFCNPOSTBYPUPDATE_ipd(i),tisd_L0TXTLFCNPOSTBYPUPDATE_CRMCORECLK(i));
	end generate L0TXTLFCNPOSTBYPUPDATE_DELAY;
	L0TXTLFCPOSTORDCRED_DELAY : for i in 159 downto 0 generate
	VitalSignalDelay (L0TXTLFCPOSTORDCRED_CRMCORECLK_dly(i),L0TXTLFCPOSTORDCRED_ipd(i),tisd_L0TXTLFCPOSTORDCRED_CRMCORECLK(i));
	end generate L0TXTLFCPOSTORDCRED_DELAY;
	L0TXTLFCPOSTORDUPDATE_DELAY : for i in 15 downto 0 generate
	VitalSignalDelay (L0TXTLFCPOSTORDUPDATE_CRMCORECLK_dly(i),L0TXTLFCPOSTORDUPDATE_ipd(i),tisd_L0TXTLFCPOSTORDUPDATE_CRMCORECLK(i));
	end generate L0TXTLFCPOSTORDUPDATE_DELAY;
	L0TXTLFCCMPLMCCRED_DELAY : for i in 159 downto 0 generate
	VitalSignalDelay (L0TXTLFCCMPLMCCRED_CRMCORECLK_dly(i),L0TXTLFCCMPLMCCRED_ipd(i),tisd_L0TXTLFCCMPLMCCRED_CRMCORECLK(i));
	end generate L0TXTLFCCMPLMCCRED_DELAY;
	L0TXTLFCCMPLMCUPDATE_DELAY : for i in 15 downto 0 generate
	VitalSignalDelay (L0TXTLFCCMPLMCUPDATE_CRMCORECLK_dly(i),L0TXTLFCCMPLMCUPDATE_ipd(i),tisd_L0TXTLFCCMPLMCUPDATE_CRMCORECLK(i));
	end generate L0TXTLFCCMPLMCUPDATE_DELAY;
	L0RXTLTLPNONINITIALIZEDVC_DELAY : for i in 7 downto 0 generate
	VitalSignalDelay (L0RXTLTLPNONINITIALIZEDVC_CRMCORECLK_dly(i),L0RXTLTLPNONINITIALIZEDVC_ipd(i),tisd_L0RXTLTLPNONINITIALIZEDVC_CRMCORECLK(i));
	end generate L0RXTLTLPNONINITIALIZEDVC_DELAY;

	VitalSignalDelay (CRMCORECLK_dly,CRMCORECLK_ipd,ticd_CRMCORECLK);
	VitalSignalDelay (CRMUSERCLK_dly,CRMUSERCLK_ipd,ticd_CRMUSERCLK);
	end block;

        SELECTPROC: process (AUXPOWER_CRMUSERCLK_dly,AUXPOWER_CRMCORECLK_dly,L0ALLDOWNPORTSINL1_CRMUSERCLK_dly, L0ALLDOWNPORTSINL1_CRMCORECLK_dly,L0ALLDOWNRXPORTSINL0S_CRMUSERCLK_dly,L0ALLDOWNRXPORTSINL0S_CRMCORECLK_dly,L0ATTENTIONBUTTONPRESSED_CRMUSERCLK_dly,L0ATTENTIONBUTTONPRESSED_CRMCORECLK_dly,L0ELECTROMECHANICALINTERLOCKENGAGED_CRMUSERCLK_dly,L0ELECTROMECHANICALINTERLOCKENGAGED_CRMCORECLK_dly,L0FWDASSERTINTALEGACYINT_CRMUSERCLK_dly,L0FWDASSERTINTALEGACYINT_CRMCORECLK_dly,L0FWDASSERTINTBLEGACYINT_CRMUSERCLK_dly,L0FWDASSERTINTBLEGACYINT_CRMCORECLK_dly,L0FWDASSERTINTCLEGACYINT_CRMUSERCLK_dly,L0FWDASSERTINTCLEGACYINT_CRMCORECLK_dly,L0FWDASSERTINTDLEGACYINT_CRMUSERCLK_dly,L0FWDASSERTINTDLEGACYINT_CRMCORECLK_dly,L0FWDCORRERRIN_CRMUSERCLK_dly,L0FWDCORRERRIN_CRMCORECLK_dly,L0FWDDEASSERTINTALEGACYINT_CRMUSERCLK_dly,L0FWDDEASSERTINTALEGACYINT_CRMCORECLK_dly,L0FWDDEASSERTINTBLEGACYINT_CRMUSERCLK_dly,L0FWDDEASSERTINTBLEGACYINT_CRMCORECLK_dly,L0FWDDEASSERTINTCLEGACYINT_CRMUSERCLK_dly,L0FWDDEASSERTINTCLEGACYINT_CRMCORECLK_dly, L0FWDDEASSERTINTDLEGACYINT_CRMUSERCLK_dly,L0FWDDEASSERTINTDLEGACYINT_CRMCORECLK_dly,L0FWDFATALERRIN_CRMUSERCLK_dly,L0FWDFATALERRIN_CRMCORECLK_dly,L0FWDNONFATALERRIN_CRMUSERCLK_dly,L0FWDNONFATALERRIN_CRMCORECLK_dly,L0LEGACYINTFUNCT0_CRMCORECLK_dly,L0MRLSENSORCLOSEDN_CRMUSERCLK_dly,L0MRLSENSORCLOSEDN_CRMCORECLK_dly,L0MSIREQUEST0_CRMUSERCLK_dly,L0MSIREQUEST0_CRMCORECLK_dly,L0PACKETHEADERFROMUSER_CRMUSERCLK_dly,L0PACKETHEADERFROMUSER_CRMCORECLK_dly, L0PORTNUMBER_CRMUSERCLK_dly,L0PORTNUMBER_CRMCORECLK_dly,L0POWERFAULTDETECTED_CRMUSERCLK_dly,L0POWERFAULTDETECTED_CRMCORECLK_dly,L0PRESENCEDETECTSLOTEMPTYN_CRMUSERCLK_dly,L0PRESENCEDETECTSLOTEMPTYN_CRMCORECLK_dly,L0ROOTTURNOFFREQ_CRMUSERCLK_dly,L0ROOTTURNOFFREQ_CRMCORECLK_dly,L0SENDUNLOCKMESSAGE_CRMUSERCLK_dly,L0SENDUNLOCKMESSAGE_CRMCORECLK_dly,L0SETCOMPLETERABORTERROR_CRMUSERCLK_dly,L0SETCOMPLETERABORTERROR_CRMCORECLK_dly,L0SETCOMPLETIONTIMEOUTCORRERROR_CRMUSERCLK_dly,L0SETCOMPLETIONTIMEOUTUNCORRERROR_CRMCORECLK_dly,L0SETDETECTEDCORRERROR_CRMUSERCLK_dly,L0SETDETECTEDCORRERROR_CRMCORECLK_dly,L0SETDETECTEDFATALERROR_CRMUSERCLK_dly,L0SETDETECTEDFATALERROR_CRMCORECLK_dly,L0SETDETECTEDNONFATALERROR_CRMUSERCLK_dly,L0SETDETECTEDNONFATALERROR_CRMCORECLK_dly,L0SETLINKDETECTEDPARITYERROR_CRMUSERCLK_dly,L0SETLINKDETECTEDPARITYERROR_CRMCORECLK_dly,L0SETLINKMASTERDATAPARITY_CRMUSERCLK_dly,L0SETLINKMASTERDATAPARITY_CRMCORECLK_dly,L0SETLINKRECEIVEDMASTERABORT_CRMUSERCLK_dly,L0SETLINKRECEIVEDMASTERABORT_CRMCORECLK_dly,L0SETLINKRECEIVEDTARGETABORT_CRMUSERCLK_dly,L0SETLINKRECEIVEDTARGETABORT_CRMCORECLK_dly,L0SETLINKSIGNALLEDTARGETABORT_CRMUSERCLK_dly,L0SETLINKSIGNALLEDTARGETABORT_CRMCORECLK_dly,L0SETLINKSYSTEMERROR_CRMUSERCLK_dly,L0SETLINKSYSTEMERROR_CRMCORECLK_dly,L0SETUNEXPECTEDCOMPLETIONCORRERROR_CRMUSERCLK_dly,L0SETUNEXPECTEDCOMPLETIONCORRERROR_CRMCORECLK_dly,L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_CRMUSERCLK_dly,L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_CRMCORECLK_dly,L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_CRMUSERCLK_dly,L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_CRMCORECLK_dly,L0SETUNSUPPORTEDREQUESTOTHERERROR_CRMUSERCLK_dly,L0SETUNSUPPORTEDREQUESTOTHERERROR_CRMCORECLK_dly,L0SETUSERDETECTEDPARITYERROR_CRMUSERCLK_dly,L0SETUSERDETECTEDPARITYERROR_CRMCORECLK_dly,L0SETUSERMASTERDATAPARITY_CRMUSERCLK_dly,L0SETUSERMASTERDATAPARITY_CRMCORECLK_dly,L0SETUSERRECEIVEDMASTERABORT_CRMUSERCLK_dly,L0SETUSERRECEIVEDMASTERABORT_CRMCORECLK_dly,L0SETUSERRECEIVEDTARGETABORT_CRMUSERCLK_dly,L0SETUSERRECEIVEDTARGETABORT_CRMCORECLK_dly,L0SETUSERSIGNALLEDTARGETABORT_CRMUSERCLK_dly,L0SETUSERSIGNALLEDTARGETABORT_CRMCORECLK_dly,L0SETUSERSYSTEMERROR_CRMUSERCLK_dly,L0SETUSERSYSTEMERROR_CRMCORECLK_dly,L0TRANSACTIONSPENDING_CRMUSERCLK_dly,L0TRANSACTIONSPENDING_CRMCORECLK_dly,L0UPSTREAMRXPORTINL0S_CRMUSERCLK_dly,L0UPSTREAMRXPORTINL0S_CRMCORECLK_dly,LLKRXCHFIFO_CRMUSERCLK_dly,LLKRXCHFIFO_CRMCORECLK_dly,LLKRXDSTCONTREQN_CRMUSERCLK_dly,LLKRXDSTCONTREQN_CRMCORECLK_dly,LLKTX4DWHEADERN_CRMUSERCLK_dly,LLKTX4DWHEADERN_CRMCORECLK_dly,LLKTXCHFIFO_CRMUSERCLK_dly,LLKTXCHFIFO_CRMCORECLK_dly,LLKTXCHTC_CRMUSERCLK_dly,LLKTXCHTC_CRMCORECLK_dly,LLKTXCREATEECRCN_CRMUSERCLK_dly,LLKTXCREATEECRCN_CRMCORECLK_dly,LLKTXDATA_CRMUSERCLK_dly,LLKTXDATA_CRMCORECLK_dly,LLKTXENABLEN_CRMUSERCLK_dly,LLKTXENABLEN_CRMCORECLK_dly,LLKTXEOFN_CRMUSERCLK_dly,LLKTXEOFN_CRMCORECLK_dly,LLKTXEOPN_CRMUSERCLK_dly,LLKTXEOPN_CRMCORECLK_dly,LLKTXSOFN_CRMUSERCLK_dly,LLKTXSOFN_CRMCORECLK_dly,LLKTXSOPN_CRMUSERCLK_dly,LLKTXSOPN_CRMCORECLK_dly,LLKTXSRCDSCN_CRMUSERCLK_dly,LLKTXSRCDSCN_CRMCORECLK_dly,LLKTXSRCRDYN_CRMUSERCLK_dly,LLKTXSRCRDYN_CRMCORECLK_dly,MGMTADDR_CRMUSERCLK_dly,MGMTADDR_CRMCORECLK_dly,MGMTBWREN_CRMUSERCLK_dly,MGMTBWREN_CRMCORECLK_dly,MGMTRDEN_CRMUSERCLK_dly,MGMTRDEN_CRMCORECLK_dly,MGMTSTATSCREDITSEL_CRMUSERCLK_dly,MGMTSTATSCREDITSEL_CRMCORECLK_dly, MGMTWDATA_CRMUSERCLK_dly,MGMTWDATA_CRMCORECLK_dly,MGMTWREN_CRMUSERCLK_dly,MGMTWREN_CRMCORECLK_dly)
              begin

              if(abs(tisd_AUXPOWER_CRMUSERCLK) > abs(tisd_AUXPOWER_CRMCORECLK)) then
                AUXPOWER_indelay <= AUXPOWER_CRMUSERCLK_dly;
              else
                AUXPOWER_indelay <= AUXPOWER_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0ALLDOWNPORTSINL1_CRMUSERCLK) > abs (tisd_L0ALLDOWNPORTSINL1_CRMCORECLK)) then
                L0ALLDOWNPORTSINL1_indelay <= L0ALLDOWNPORTSINL1_CRMUSERCLK_dly;
              else
                L0ALLDOWNPORTSINL1_indelay <= L0ALLDOWNPORTSINL1_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0ALLDOWNRXPORTSINL0S_CRMUSERCLK) > abs (tisd_L0ALLDOWNRXPORTSINL0S_CRMCORECLK)) then
                L0ALLDOWNRXPORTSINL0S_indelay <= L0ALLDOWNRXPORTSINL0S_CRMUSERCLK_dly;
              else
                L0ALLDOWNRXPORTSINL0S_indelay <= L0ALLDOWNRXPORTSINL0S_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0ATTENTIONBUTTONPRESSED_CRMUSERCLK) > abs (tisd_L0ATTENTIONBUTTONPRESSED_CRMCORECLK)) then
                L0ATTENTIONBUTTONPRESSED_indelay <= L0ATTENTIONBUTTONPRESSED_CRMUSERCLK_dly;
              else
                L0ATTENTIONBUTTONPRESSED_indelay <= L0ATTENTIONBUTTONPRESSED_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0ELECTROMECHANICALINTERLOCKENGAGED_CRMUSERCLK) > abs (tisd_L0ELECTROMECHANICALINTERLOCKENGAGED_CRMCORECLK)) then
                L0ELECTROMECHANICALINTERLOCKENGAGED_indelay <= L0ELECTROMECHANICALINTERLOCKENGAGED_CRMUSERCLK_dly;
              else
                L0ELECTROMECHANICALINTERLOCKENGAGED_indelay <= L0ELECTROMECHANICALINTERLOCKENGAGED_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0FWDASSERTINTALEGACYINT_CRMUSERCLK) > abs (tisd_L0FWDASSERTINTALEGACYINT_CRMCORECLK)) then
                L0FWDASSERTINTALEGACYINT_indelay <= L0FWDASSERTINTALEGACYINT_CRMUSERCLK_dly;
              else
                L0FWDASSERTINTALEGACYINT_indelay <= L0FWDASSERTINTALEGACYINT_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0FWDASSERTINTBLEGACYINT_CRMUSERCLK) > abs (tisd_L0FWDASSERTINTBLEGACYINT_CRMCORECLK)) then
                L0FWDASSERTINTBLEGACYINT_indelay <= L0FWDASSERTINTBLEGACYINT_CRMUSERCLK_dly;
              else
                L0FWDASSERTINTBLEGACYINT_indelay <= L0FWDASSERTINTBLEGACYINT_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0FWDASSERTINTCLEGACYINT_CRMUSERCLK) > abs (tisd_L0FWDASSERTINTCLEGACYINT_CRMCORECLK)) then
                L0FWDASSERTINTCLEGACYINT_indelay <= L0FWDASSERTINTCLEGACYINT_CRMUSERCLK_dly;
              else
                L0FWDASSERTINTCLEGACYINT_indelay <= L0FWDASSERTINTCLEGACYINT_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0FWDASSERTINTDLEGACYINT_CRMUSERCLK) > abs (tisd_L0FWDASSERTINTDLEGACYINT_CRMCORECLK)) then
                L0FWDASSERTINTDLEGACYINT_indelay <= L0FWDASSERTINTDLEGACYINT_CRMUSERCLK_dly;
              else
                L0FWDASSERTINTDLEGACYINT_indelay <= L0FWDASSERTINTDLEGACYINT_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0FWDCORRERRIN_CRMUSERCLK) > abs (tisd_L0FWDCORRERRIN_CRMCORECLK)) then
                L0FWDCORRERRIN_indelay <= L0FWDCORRERRIN_CRMUSERCLK_dly;
              else
                L0FWDCORRERRIN_indelay <= L0FWDCORRERRIN_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0FWDDEASSERTINTALEGACYINT_CRMUSERCLK) > abs (tisd_L0FWDDEASSERTINTALEGACYINT_CRMCORECLK)) then
                L0FWDDEASSERTINTALEGACYINT_indelay <= L0FWDDEASSERTINTALEGACYINT_CRMUSERCLK_dly;
              else
                L0FWDDEASSERTINTALEGACYINT_indelay <= L0FWDDEASSERTINTALEGACYINT_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0FWDDEASSERTINTBLEGACYINT_CRMUSERCLK) > abs (tisd_L0FWDDEASSERTINTBLEGACYINT_CRMCORECLK)) then
                L0FWDDEASSERTINTBLEGACYINT_indelay <= L0FWDDEASSERTINTBLEGACYINT_CRMUSERCLK_dly;
              else
                L0FWDDEASSERTINTBLEGACYINT_indelay <= L0FWDDEASSERTINTBLEGACYINT_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0FWDDEASSERTINTCLEGACYINT_CRMUSERCLK) > abs (tisd_L0FWDDEASSERTINTCLEGACYINT_CRMCORECLK)) then
                L0FWDDEASSERTINTCLEGACYINT_indelay <= L0FWDDEASSERTINTCLEGACYINT_CRMUSERCLK_dly;
              else
                L0FWDDEASSERTINTCLEGACYINT_indelay <= L0FWDDEASSERTINTCLEGACYINT_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0FWDDEASSERTINTDLEGACYINT_CRMUSERCLK) > abs (tisd_L0FWDDEASSERTINTDLEGACYINT_CRMCORECLK)) then
                L0FWDDEASSERTINTDLEGACYINT_indelay <= L0FWDDEASSERTINTDLEGACYINT_CRMUSERCLK_dly;
              else
                L0FWDDEASSERTINTDLEGACYINT_indelay <= L0FWDDEASSERTINTDLEGACYINT_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0FWDFATALERRIN_CRMUSERCLK) > abs (tisd_L0FWDFATALERRIN_CRMCORECLK)) then
                L0FWDFATALERRIN_indelay <= L0FWDFATALERRIN_CRMUSERCLK_dly;
              else
                L0FWDFATALERRIN_indelay <= L0FWDFATALERRIN_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0FWDNONFATALERRIN_CRMUSERCLK) > abs (tisd_L0FWDNONFATALERRIN_CRMCORECLK)) then
                L0FWDNONFATALERRIN_indelay <= L0FWDNONFATALERRIN_CRMUSERCLK_dly;
              else
                L0FWDNONFATALERRIN_indelay <= L0FWDNONFATALERRIN_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0LEGACYINTFUNCT0_CRMUSERCLK) > abs (tisd_L0LEGACYINTFUNCT0_CRMCORECLK)) then
                L0LEGACYINTFUNCT0_indelay <= L0LEGACYINTFUNCT0_CRMUSERCLK_dly;
              else
                L0LEGACYINTFUNCT0_indelay <= L0LEGACYINTFUNCT0_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0MRLSENSORCLOSEDN_CRMUSERCLK) > abs (tisd_L0MRLSENSORCLOSEDN_CRMCORECLK)) then
                L0MRLSENSORCLOSEDN_indelay <= L0MRLSENSORCLOSEDN_CRMUSERCLK_dly;
              else
                L0MRLSENSORCLOSEDN_indelay <= L0MRLSENSORCLOSEDN_CRMCORECLK_dly;
              end if;

             L0MSIREQUEST0_FOR: for i in 3 downto 0 loop
             L0MSIREQUEST0_IF : if (abs(tisd_L0MSIREQUEST0_CRMUSERCLK(i)) > abs(tisd_L0MSIREQUEST0_CRMCORECLK(i))) then
               L0MSIREQUEST0_indelay(i) <= L0MSIREQUEST0_CRMUSERCLK_dly(i);
             else
               L0MSIREQUEST0_indelay(i) <= L0MSIREQUEST0_CRMCORECLK_dly(i);
              end if;
              end loop;

              L0PACKETHEADERFROMUSER_FOR: for i in 127 downto 0 loop
              L0PACKETHEADERFROMUSER_IF : if(abs (tisd_L0PACKETHEADERFROMUSER_CRMUSERCLK(i)) > abs (tisd_L0PACKETHEADERFROMUSER_CRMCORECLK(i))) then
                L0PACKETHEADERFROMUSER_indelay(i) <= L0PACKETHEADERFROMUSER_CRMUSERCLK_dly(i);
              else
                L0PACKETHEADERFROMUSER_indelay(i) <= L0PACKETHEADERFROMUSER_CRMCORECLK_dly(i);
              end if;
              end loop;

              L0PORTNUMBER_FOR: for i in 7 downto 0 loop
              L0PORTNUMBER_IF :
              if(abs (tisd_L0PORTNUMBER_CRMUSERCLK(i)) > abs (tisd_L0PORTNUMBER_CRMCORECLK(i))) then
                L0PORTNUMBER_indelay(i) <= L0PORTNUMBER_CRMUSERCLK_dly(i);
              else
                L0PORTNUMBER_indelay(i) <= L0PORTNUMBER_CRMCORECLK_dly(i);
              end if;
              end loop;
             
              if(abs (tisd_L0POWERFAULTDETECTED_CRMUSERCLK) > abs (tisd_L0POWERFAULTDETECTED_CRMCORECLK)) then
                L0POWERFAULTDETECTED_indelay <= L0POWERFAULTDETECTED_CRMUSERCLK_dly;
              else
                L0POWERFAULTDETECTED_indelay <= L0POWERFAULTDETECTED_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0PRESENCEDETECTSLOTEMPTYN_CRMUSERCLK) > abs (tisd_L0PRESENCEDETECTSLOTEMPTYN_CRMCORECLK)) then
                L0PRESENCEDETECTSLOTEMPTYN_indelay <= L0PRESENCEDETECTSLOTEMPTYN_CRMUSERCLK_dly;
              else
                L0PRESENCEDETECTSLOTEMPTYN_indelay <= L0PRESENCEDETECTSLOTEMPTYN_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0ROOTTURNOFFREQ_CRMUSERCLK) > abs (tisd_L0ROOTTURNOFFREQ_CRMCORECLK)) then
                L0ROOTTURNOFFREQ_indelay <= L0ROOTTURNOFFREQ_CRMUSERCLK_dly;
              else
                L0ROOTTURNOFFREQ_indelay <= L0ROOTTURNOFFREQ_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0SENDUNLOCKMESSAGE_CRMUSERCLK) > abs (tisd_L0SENDUNLOCKMESSAGE_CRMCORECLK)) then
                L0SENDUNLOCKMESSAGE_indelay <= L0SENDUNLOCKMESSAGE_CRMUSERCLK_dly;
              else
                L0SENDUNLOCKMESSAGE_indelay <= L0SENDUNLOCKMESSAGE_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0SETCOMPLETERABORTERROR_CRMUSERCLK) > abs (tisd_L0SETCOMPLETERABORTERROR_CRMCORECLK)) then
                L0SETCOMPLETERABORTERROR_indelay <= L0SETCOMPLETERABORTERROR_CRMUSERCLK_dly;
              else
                L0SETCOMPLETERABORTERROR_indelay <= L0SETCOMPLETERABORTERROR_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0SETCOMPLETIONTIMEOUTCORRERROR_CRMUSERCLK) > abs (tisd_L0SETCOMPLETIONTIMEOUTCORRERROR_CRMCORECLK)) then
                L0SETCOMPLETIONTIMEOUTCORRERROR_indelay <= L0SETCOMPLETIONTIMEOUTCORRERROR_CRMUSERCLK_dly;
              else
                L0SETCOMPLETIONTIMEOUTCORRERROR_indelay <= L0SETCOMPLETIONTIMEOUTCORRERROR_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0SETCOMPLETIONTIMEOUTUNCORRERROR_CRMUSERCLK) > abs (tisd_L0SETCOMPLETIONTIMEOUTUNCORRERROR_CRMCORECLK)) then
                L0SETCOMPLETIONTIMEOUTUNCORRERROR_indelay <= L0SETCOMPLETIONTIMEOUTUNCORRERROR_CRMUSERCLK_dly;
              else
                L0SETCOMPLETIONTIMEOUTUNCORRERROR_indelay <= L0SETCOMPLETIONTIMEOUTUNCORRERROR_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0SETDETECTEDCORRERROR_CRMUSERCLK) > abs (tisd_L0SETDETECTEDCORRERROR_CRMCORECLK)) then
                L0SETDETECTEDCORRERROR_indelay <= L0SETDETECTEDCORRERROR_CRMUSERCLK_dly;
              else
                L0SETDETECTEDCORRERROR_indelay <= L0SETDETECTEDCORRERROR_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0SETDETECTEDFATALERROR_CRMUSERCLK) > abs (tisd_L0SETDETECTEDFATALERROR_CRMCORECLK)) then
                L0SETDETECTEDFATALERROR_indelay <= L0SETDETECTEDFATALERROR_CRMUSERCLK_dly;
              else
                L0SETDETECTEDFATALERROR_indelay <= L0SETDETECTEDFATALERROR_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0SETDETECTEDNONFATALERROR_CRMUSERCLK) > abs (tisd_L0SETDETECTEDNONFATALERROR_CRMCORECLK)) then
                L0SETDETECTEDNONFATALERROR_indelay <= L0SETDETECTEDNONFATALERROR_CRMUSERCLK_dly;
              else
                L0SETDETECTEDNONFATALERROR_indelay <= L0SETDETECTEDNONFATALERROR_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0SETLINKDETECTEDPARITYERROR_CRMUSERCLK) > abs (tisd_L0SETLINKDETECTEDPARITYERROR_CRMCORECLK)) then
                L0SETLINKDETECTEDPARITYERROR_indelay <= L0SETLINKDETECTEDPARITYERROR_CRMUSERCLK_dly;
              else
                L0SETLINKDETECTEDPARITYERROR_indelay <= L0SETLINKDETECTEDPARITYERROR_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0SETLINKMASTERDATAPARITY_CRMUSERCLK) > abs (tisd_L0SETLINKMASTERDATAPARITY_CRMCORECLK)) then
                L0SETLINKMASTERDATAPARITY_indelay <= L0SETLINKMASTERDATAPARITY_CRMUSERCLK_dly;
              else
                L0SETLINKMASTERDATAPARITY_indelay <= L0SETLINKMASTERDATAPARITY_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0SETLINKRECEIVEDMASTERABORT_CRMUSERCLK) > abs (tisd_L0SETLINKRECEIVEDMASTERABORT_CRMCORECLK)) then
                L0SETLINKRECEIVEDMASTERABORT_indelay <= L0SETLINKRECEIVEDMASTERABORT_CRMUSERCLK_dly;
              else
                L0SETLINKRECEIVEDMASTERABORT_indelay <= L0SETLINKRECEIVEDMASTERABORT_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0SETLINKRECEIVEDTARGETABORT_CRMUSERCLK) > abs (tisd_L0SETLINKRECEIVEDTARGETABORT_CRMCORECLK)) then
                L0SETLINKRECEIVEDTARGETABORT_indelay <= L0SETLINKRECEIVEDTARGETABORT_CRMUSERCLK_dly;
              else
                L0SETLINKRECEIVEDTARGETABORT_indelay <= L0SETLINKRECEIVEDTARGETABORT_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0SETLINKSIGNALLEDTARGETABORT_CRMUSERCLK) > abs (tisd_L0SETLINKSIGNALLEDTARGETABORT_CRMCORECLK)) then
                L0SETLINKSIGNALLEDTARGETABORT_indelay <= L0SETLINKSIGNALLEDTARGETABORT_CRMUSERCLK_dly;
              else
                L0SETLINKSIGNALLEDTARGETABORT_indelay <= L0SETLINKSIGNALLEDTARGETABORT_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0SETLINKSYSTEMERROR_CRMUSERCLK) > abs (tisd_L0SETLINKSYSTEMERROR_CRMCORECLK)) then
                L0SETLINKSYSTEMERROR_indelay <= L0SETLINKSYSTEMERROR_CRMUSERCLK_dly;
              else
                L0SETLINKSYSTEMERROR_indelay <= L0SETLINKSYSTEMERROR_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0SETUNEXPECTEDCOMPLETIONCORRERROR_CRMUSERCLK) > abs (tisd_L0SETUNEXPECTEDCOMPLETIONCORRERROR_CRMCORECLK)) then
                L0SETUNEXPECTEDCOMPLETIONCORRERROR_indelay <= L0SETUNEXPECTEDCOMPLETIONCORRERROR_CRMUSERCLK_dly;
              else
                L0SETUNEXPECTEDCOMPLETIONCORRERROR_indelay <= L0SETUNEXPECTEDCOMPLETIONCORRERROR_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_CRMUSERCLK) > abs (tisd_L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_CRMCORECLK)) then
                L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_indelay <= L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_CRMUSERCLK_dly;
              else
                L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_indelay <= L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_CRMUSERCLK) > abs (tisd_L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_CRMCORECLK)) then
                L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_indelay <= L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_CRMUSERCLK_dly;
              else
                L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_indelay <= L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0SETUNSUPPORTEDREQUESTOTHERERROR_CRMUSERCLK) > abs (tisd_L0SETUNSUPPORTEDREQUESTOTHERERROR_CRMCORECLK)) then
                L0SETUNSUPPORTEDREQUESTOTHERERROR_indelay <= L0SETUNSUPPORTEDREQUESTOTHERERROR_CRMUSERCLK_dly;
              else
                L0SETUNSUPPORTEDREQUESTOTHERERROR_indelay <= L0SETUNSUPPORTEDREQUESTOTHERERROR_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0SETUSERDETECTEDPARITYERROR_CRMUSERCLK) > abs (tisd_L0SETUSERDETECTEDPARITYERROR_CRMCORECLK)) then
                L0SETUSERDETECTEDPARITYERROR_indelay <= L0SETUSERDETECTEDPARITYERROR_CRMUSERCLK_dly;
              else
                L0SETUSERDETECTEDPARITYERROR_indelay <= L0SETUSERDETECTEDPARITYERROR_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0SETUSERMASTERDATAPARITY_CRMUSERCLK) > abs (tisd_L0SETUSERMASTERDATAPARITY_CRMCORECLK)) then
                L0SETUSERMASTERDATAPARITY_indelay <= L0SETUSERMASTERDATAPARITY_CRMUSERCLK_dly;
              else
                L0SETUSERMASTERDATAPARITY_indelay <= L0SETUSERMASTERDATAPARITY_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0SETUSERRECEIVEDMASTERABORT_CRMUSERCLK) > abs (tisd_L0SETUSERRECEIVEDMASTERABORT_CRMCORECLK)) then
                L0SETUSERRECEIVEDMASTERABORT_indelay <= L0SETUSERRECEIVEDMASTERABORT_CRMUSERCLK_dly;
              else
                L0SETUSERRECEIVEDMASTERABORT_indelay <= L0SETUSERRECEIVEDMASTERABORT_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0SETUSERRECEIVEDTARGETABORT_CRMUSERCLK) > abs (tisd_L0SETUSERRECEIVEDTARGETABORT_CRMCORECLK)) then
                L0SETUSERRECEIVEDTARGETABORT_indelay <= L0SETUSERRECEIVEDTARGETABORT_CRMUSERCLK_dly;
              else
                L0SETUSERRECEIVEDTARGETABORT_indelay <= L0SETUSERRECEIVEDTARGETABORT_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0SETUSERSIGNALLEDTARGETABORT_CRMUSERCLK) > abs (tisd_L0SETUSERSIGNALLEDTARGETABORT_CRMCORECLK)) then
                L0SETUSERSIGNALLEDTARGETABORT_indelay <= L0SETUSERSIGNALLEDTARGETABORT_CRMUSERCLK_dly;
              else
                L0SETUSERSIGNALLEDTARGETABORT_indelay <= L0SETUSERSIGNALLEDTARGETABORT_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0SETUSERSYSTEMERROR_CRMUSERCLK) > abs (tisd_L0SETUSERSYSTEMERROR_CRMCORECLK)) then
                L0SETUSERSYSTEMERROR_indelay <= L0SETUSERSYSTEMERROR_CRMUSERCLK_dly;
              else
                L0SETUSERSYSTEMERROR_indelay <= L0SETUSERSYSTEMERROR_CRMCORECLK_dly;
              end if;
              if(abs (tisd_L0TRANSACTIONSPENDING_CRMUSERCLK) > abs (tisd_L0TRANSACTIONSPENDING_CRMCORECLK)) then
                L0TRANSACTIONSPENDING_indelay <= L0TRANSACTIONSPENDING_CRMUSERCLK_dly;
              else
                L0TRANSACTIONSPENDING_indelay <= L0TRANSACTIONSPENDING_CRMCORECLK_dly;
              end if;
               if(abs (tisd_L0UPSTREAMRXPORTINL0S_CRMUSERCLK) > abs (tisd_L0UPSTREAMRXPORTINL0S_CRMCORECLK)) then
                L0UPSTREAMRXPORTINL0S_indelay <= L0UPSTREAMRXPORTINL0S_CRMUSERCLK_dly;
              else
                L0UPSTREAMRXPORTINL0S_indelay <= L0UPSTREAMRXPORTINL0S_CRMCORECLK_dly;
              end if;

              LLKRXCHFIFO_FOR: for i in 1 downto 0 loop
              LLKRXCHFIFO_IF :
              if(abs (tisd_LLKRXCHFIFO_CRMUSERCLK(i)) > abs (tisd_LLKRXCHFIFO_CRMUSERCLK(i))) then
                LLKRXCHFIFO_indelay(i) <= LLKRXCHFIFO_CRMUSERCLK_dly(i);
              else
                LLKRXCHFIFO_indelay(i) <= LLKRXCHFIFO_CRMCORECLK_dly(i);
              end if;
              end loop;

              LLKRXCHTC_FOR: for i in 2 downto 0 loop
              LLKRXCHTC_IF :
              if(abs (tisd_LLKRXCHTC_CRMUSERCLK(i)) > abs (tisd_LLKRXCHTC_CRMCORECLK(i))) then
                LLKRXCHTC_indelay(i) <= LLKRXCHTC_CRMUSERCLK_dly(i);
              else
                LLKRXCHTC_indelay(i) <= LLKRXCHTC_CRMCORECLK_dly(i);
              end if;
              end loop;
                
              if(abs (tisd_LLKRXDSTCONTREQN_CRMUSERCLK) > abs (tisd_LLKRXDSTREQN_CRMUSERCLK)) then
                LLKRXDSTCONTREQN_indelay <= LLKRXDSTCONTREQN_CRMUSERCLK_dly;
              else
                LLKRXDSTCONTREQN_indelay <= LLKRXDSTCONTREQN_CRMCORECLK_dly;
              end if;
              if(abs (tisd_LLKTX4DWHEADERN_CRMUSERCLK) > abs (tisd_LLKTX4DWHEADERN_CRMCORECLK)) then
                LLKTX4DWHEADERN_indelay <= LLKTX4DWHEADERN_CRMUSERCLK_dly;
              else
                LLKTX4DWHEADERN_indelay <= LLKTX4DWHEADERN_CRMCORECLK_dly;
              end if;

              LLKTXCHFIFO_FOR: for i in 1 downto 0 loop
              LLKTXCHFIFO_IF :
              if(abs (tisd_LLKTXCHFIFO_CRMUSERCLK(i)) > abs (tisd_LLKTXCHFIFO_CRMCORECLK(i))) then
                LLKTXCHFIFO_indelay(i) <= LLKTXCHFIFO_CRMUSERCLK_dly(i);
              else
                LLKTXCHFIFO_indelay(i) <= LLKTXCHFIFO_CRMCORECLK_dly(i);
              end if;
              end loop;

              LLKTXCHTC_FOR: for i in 2 downto 0 loop
              LLKTXCHTC_IF :
              if(abs (tisd_LLKTXCHTC_CRMUSERCLK(i)) > abs (tisd_LLKTXCHTC_CRMCORECLK(i))) then
                LLKTXCHTC_indelay(i) <= LLKTXCHTC_CRMUSERCLK_dly(i);
              else
                LLKTXCHTC_indelay(i) <= LLKTXCHTC_CRMCORECLK_dly(i);
              end if;
              end loop;
                
              if(abs (tisd_LLKTXCOMPLETEN_CRMUSERCLK) > abs (tisd_LLKTXCOMPLETEN_CRMCORECLK)) then
                LLKTXCOMPLETEN_indelay <= LLKTXCOMPLETEN_CRMUSERCLK_dly;
              else
                LLKTXCOMPLETEN_indelay <= LLKTXCOMPLETEN_CRMCORECLK_dly;
              end if;
              if(abs (tisd_LLKTXCREATEECRCN_CRMUSERCLK) > abs (tisd_LLKTXCREATEECRCN_CRMCORECLK)) then
                LLKTXCREATEECRCN_indelay <= LLKTXCREATEECRCN_CRMUSERCLK_dly;
              else
                LLKTXCREATEECRCN_indelay <= LLKTXCREATEECRCN_CRMCORECLK_dly;
              end if;

              LLKTXDATA_FOR: for i in 63 downto 0 loop
              LLKTXDATA_IF :
                if(abs (tisd_LLKTXDATA_CRMUSERCLK(i)) > abs (tisd_LLKTXDATA_CRMCORECLK(i))) then
                LLKTXDATA_indelay(i) <= LLKTXDATA_CRMUSERCLK_dly(i);
              else
                LLKTXDATA_indelay(i) <= LLKTXDATA_CRMCORECLK_dly(i);
              end if;
               end loop;

              LLKTXENABLEN_FOR: for i in 1 downto 0 loop
              LLKTXENABLEN_IF :
              if(abs (tisd_LLKTXENABLEN_CRMUSERCLK(i)) > abs (tisd_LLKTXENABLEN_CRMCORECLK(i))) then
                LLKTXENABLEN_indelay(i) <= LLKTXENABLEN_CRMUSERCLK_dly(i);
              else
                LLKTXENABLEN_indelay(i) <= LLKTXENABLEN_CRMCORECLK_dly(i);
              end if;
               end loop;
                
              if(abs (tisd_LLKTXEOFN_CRMUSERCLK) > abs (tisd_LLKTXEOFN_CRMCORECLK)) then
                LLKTXEOFN_indelay <= LLKTXEOFN_CRMUSERCLK_dly;
              else
                LLKTXEOFN_indelay <= LLKTXEOFN_CRMCORECLK_dly;
              end if;
               if(abs (tisd_LLKTXEOPN_CRMUSERCLK) > abs (tisd_LLKTXEOPN_CRMCORECLK)) then
                LLKTXEOPN_indelay <= LLKTXEOPN_CRMUSERCLK_dly;
              else
                LLKTXEOPN_indelay <= LLKTXEOPN_CRMCORECLK_dly;
              end if;
              if(abs (tisd_LLKTXSOFN_CRMUSERCLK) > abs (tisd_LLKTXSOFN_CRMCORECLK)) then
                LLKTXSOFN_indelay <= LLKTXSOFN_CRMUSERCLK_dly;
              else
                LLKTXSOFN_indelay <= LLKTXSOFN_CRMCORECLK_dly;
              end if;
              if(abs (tisd_LLKTXSOPN_CRMUSERCLK) > abs (tisd_LLKTXSOPN_CRMCORECLK)) then
                LLKTXSOPN_indelay <= LLKTXSOPN_CRMUSERCLK_dly;
              else
                LLKTXSOPN_indelay <= LLKTXSOPN_CRMCORECLK_dly;
              end if;
              if(abs (tisd_LLKTXSRCDSCN_CRMUSERCLK) > abs (tisd_LLKTXSRCDSCN_CRMCORECLK)) then
                LLKTXSRCDSCN_indelay <= LLKTXSRCDSCN_CRMUSERCLK_dly;
              else
                LLKTXSRCDSCN_indelay <= LLKTXSRCDSCN_CRMCORECLK_dly;
              end if;
              if(abs (tisd_LLKTXSRCRDYN_CRMUSERCLK) > abs (tisd_LLKTXSRCRDYN_CRMCORECLK)) then
                LLKTXSRCRDYN_indelay <= LLKTXSRCRDYN_CRMUSERCLK_dly;
              else
                LLKTXSRCRDYN_indelay <= LLKTXSRCRDYN_CRMCORECLK_dly;
              end if;

              MGMTADDR_FOR: for i in 10 downto 0 loop
              MGMTADDR_IF :
                if(abs (tisd_MGMTADDR_CRMUSERCLK(i)) > abs (tisd_MGMTADDR_CRMCORECLK(i))) then
                MGMTADDR_indelay(i) <= MGMTADDR_CRMUSERCLK_dly(i);
              else
                MGMTADDR_indelay(i) <= MGMTADDR_CRMCORECLK_dly(i);
              end if;
               end loop;

              MGMTBWREN_FOR: for i in 3 downto 0 loop
              MGMTBWREN_IF :
              if(abs (tisd_MGMTBWREN_CRMUSERCLK(i)) > abs (tisd_MGMTBWREN_CRMCORECLK(i))) then
                MGMTBWREN_indelay(i) <= MGMTBWREN_CRMUSERCLK_dly(i);
              else
                MGMTBWREN_indelay(i) <= MGMTBWREN_CRMCORECLK_dly(i);
              end if;
               end loop;
                
              if(abs (tisd_MGMTRDEN_CRMUSERCLK) > abs (tisd_MGMTRDEN_CRMCORECLK)) then
                MGMTRDEN_indelay <= MGMTRDEN_CRMUSERCLK_dly;
              else
                MGMTRDEN_indelay <= MGMTRDEN_CRMCORECLK_dly;
              end if;

              MGMTSTATSCREDITSEL_FOR: for i in 6 downto 0 loop
              MGMTSTATSCREDITSEL_IF :
                if(abs (tisd_MGMTSTATSCREDITSEL_CRMUSERCLK(i)) > abs (tisd_MGMTSTATSCREDITSEL_CRMCORECLK(i))) then
                MGMTSTATSCREDITSEL_indelay(i) <= MGMTSTATSCREDITSEL_CRMUSERCLK_dly(i);
              else
                MGMTSTATSCREDITSEL_indelay(i) <= MGMTSTATSCREDITSEL_CRMCORECLK_dly(i);
              end if;
               end loop;

              MGMTWDATA_FOR: for i in 31 downto 0 loop
              MGMTWDATA_IF :
              if(abs (tisd_MGMTWDATA_CRMUSERCLK(i)) > abs (tisd_MGMTWDATA_CRMCORECLK(i))) then
                MGMTWDATA_indelay(i) <= MGMTWDATA_CRMUSERCLK_dly(i);
              else
                MGMTWDATA_indelay(i) <= MGMTWDATA_CRMCORECLK_dly(i);
              end if;
              end loop;
                
              if(abs (tisd_MGMTWREN_CRMUSERCLK) > abs (tisd_MGMTWREN_CRMCORECLK)) then
                MGMTWREN_indelay <= MGMTWREN_CRMUSERCLK_dly;
              else
                MGMTWREN_indelay <= MGMTWREN_CRMCORECLK_dly;
              end if;
                
        end process SELECTPROC;

              
        CRMCORECLKDLO_dly <= CRMCORECLKDLO_ipd;
        CRMCORECLKRXO_dly <= CRMCORECLKRXO_ipd;
        CRMCORECLKTXO_dly <= CRMCORECLKTXO_ipd;
        CRMUSERCLKRXO_dly <= CRMUSERCLKRXO_ipd;
        CRMUSERCLKTXO_dly <= CRMUSERCLKTXO_ipd;

        --Input ports sensitive to single clock
        
        CRMURSTN_indelay <= CRMURSTN_CRMCORECLK_dly;
        CRMNVRSTN_indelay <= CRMNVRSTN_CRMCORECLK_dly;
        CRMMGMTRSTN_indelay <=  CRMMGMTRSTN_CRMCORECLK_dly;
	CRMUSERCFGRSTN_indelay <=  CRMUSERCFGRSTN_CRMCORECLK_dly;
	CRMMACRSTN_indelay <=  CRMMACRSTN_CRMCORECLK_dly;
	CRMLINKRSTN_indelay <=  CRMLINKRSTN_CRMCORECLK_dly;

        CFGNEGOTIATEDLINKWIDTH_indelay <=  CFGNEGOTIATEDLINKWIDTH_CRMCORECLK_dly;
	COMPLIANCEAVOID_indelay <=  COMPLIANCEAVOID_CRMCORECLK_dly; 
	CRMCFGBRIDGEHOTRESET_indelay <=  CRMCFGBRIDGEHOTRESET_CRMCORECLK_dly; 
	CRMTXHOTRESETN_indelay <=  CRMTXHOTRESETN_CRMCORECLK_dly; 
        CROSSLINKSEED_indelay <=  CROSSLINKSEED_CRMCORECLK_dly; 
	L0ACKNAKTIMERADJUSTMENT_indelay <=  L0ACKNAKTIMERADJUSTMENT_CRMCORECLK_dly;
        L0ASE_indelay <=   L0ASE_CRMCORECLK_dly; 
	L0ASPORTCOUNT_indelay <=   L0ASPORTCOUNT_CRMCORECLK_dly;
	L0ASTURNPOOLBITSCONSUMED_indelay <=   L0ASTURNPOOLBITSCONSUMED_CRMCORECLK_dly;
        L0CFGASSPANTREEOWNEDSTATE_indelay <=  L0CFGASSPANTREEOWNEDSTATE_CRMCORECLK_dly; 
	L0CFGASSTATECHANGECMD_indelay <=   L0CFGASSTATECHANGECMD_CRMCORECLK_dly;
	L0CFGDISABLESCRAMBLE_indelay <=   L0CFGDISABLESCRAMBLE_CRMCORECLK_dly;
	L0CFGEXTENDEDSYNC_indelay <=   L0CFGEXTENDEDSYNC_CRMCORECLK_dly; 
	L0CFGL0SENTRYENABLE_indelay <=   L0CFGL0SENTRYENABLE_CRMCORECLK_dly;
	L0CFGL0SENTRYSUP_indelay <=   L0CFGL0SENTRYSUP_CRMCORECLK_dly;
	L0CFGL0SEXITLAT_indelay <=   L0CFGL0SEXITLAT_CRMCORECLK_dly; 
	L0CFGLINKDISABLE_indelay <=   L0CFGLINKDISABLE_CRMCORECLK_dly;
	L0CFGLOOPBACKMASTER_indelay <=   L0CFGLOOPBACKMASTER_CRMCORECLK_dly;
	L0CFGNEGOTIATEDMAXP_indelay <=   L0CFGNEGOTIATEDMAXP_CRMCORECLK_dly;
	L0CFGVCENABLE_indelay <=   L0CFGVCENABLE_CRMCORECLK_dly; 
	L0CFGVCID_indelay <=   L0CFGVCID_CRMCORECLK_dly; 
	L0DLLHOLDLINKUP_indelay <=   L0DLLHOLDLINKUP_CRMCORECLK_dly;
        L0PMEREQIN_indelay <= L0PMEREQIN_CRMCORECLK_dly; 
        L0PWRNEWSTATEREQ_indelay <=  L0PWRNEWSTATEREQ_CRMCORECLK_dly;
	L0PWRNEXTLINKSTATE_indelay <=  L0PWRNEXTLINKSTATE_CRMCORECLK_dly;
	L0REPLAYTIMERADJUSTMENT_indelay <=  L0REPLAYTIMERADJUSTMENT_CRMCORECLK_dly;
        L0RXTLTLPNONINITIALIZEDVC_indelay <=  L0RXTLTLPNONINITIALIZEDVC_CRMCORECLK_dly; 
        L0TLASFCCREDSTARVATION_indelay <= L0TLASFCCREDSTARVATION_CRMCORECLK_dly;
	L0TLLINKRETRAIN_indelay <= L0TLLINKRETRAIN_CRMCORECLK_dly; 
        L0TXBEACON_indelay <=  L0TXBEACON_CRMCORECLK_dly;
	L0TXCFGPM_indelay <=  L0TXCFGPM_CRMCORECLK_dly;
	L0TXCFGPMTYPE_indelay <=  L0TXCFGPMTYPE_CRMCORECLK_dly; 
	L0TXTLFCCMPLMCCRED_indelay <=  L0TXTLFCCMPLMCCRED_CRMCORECLK_dly; 
	L0TXTLFCCMPLMCUPDATE_indelay <=  L0TXTLFCCMPLMCUPDATE_CRMCORECLK_dly;
	L0TXTLFCNPOSTBYPCRED_indelay <=  L0TXTLFCNPOSTBYPCRED_CRMCORECLK_dly;
	L0TXTLFCNPOSTBYPUPDATE_indelay <=  L0TXTLFCNPOSTBYPUPDATE_CRMCORECLK_dly;
	L0TXTLFCPOSTORDCRED_indelay <=  L0TXTLFCPOSTORDCRED_CRMCORECLK_dly; 
	L0TXTLFCPOSTORDUPDATE_indelay <=  L0TXTLFCPOSTORDUPDATE_CRMCORECLK_dly; 
	L0TXTLSBFCDATA_indelay <=  L0TXTLSBFCDATA_CRMCORECLK_dly; 
	L0TXTLSBFCUPDATE_indelay <=  L0TXTLSBFCUPDATE_CRMCORECLK_dly;
	L0TXTLTLPDATA_indelay <=  L0TXTLTLPDATA_CRMCORECLK_dly;
	L0TXTLTLPEDB_indelay <=  L0TXTLTLPEDB_CRMCORECLK_dly;
	L0TXTLTLPENABLE_indelay <=  L0TXTLTLPENABLE_CRMCORECLK_dly;
	L0TXTLTLPEND_indelay <=  L0TXTLTLPEND_CRMCORECLK_dly;
	L0TXTLTLPLATENCY_indelay <=  L0TXTLTLPLATENCY_CRMCORECLK_dly;
	L0TXTLTLPREQ_indelay <=  L0TXTLTLPREQ_CRMCORECLK_dly;
	L0TXTLTLPREQEND_indelay <=  L0TXTLTLPREQEND_CRMCORECLK_dly; 
	L0TXTLTLPWIDTH_indelay <=  L0TXTLTLPWIDTH_CRMCORECLK_dly;
        L0VC0PREVIEWEXPAND_indelay <=  L0VC0PREVIEWEXPAND_CRMCORECLK_dly; 
	L0WAKEN_indelay <=  L0WAKEN_CRMCORECLK_dly;
        MAINPOWER_indelay <=  MAINPOWER_CRMCORECLK_dly; 
        MIMDLLBRDATA_indelay <=  MIMDLLBRDATA_CRMCORECLK_dly;
        MIMRXBRDATA_indelay <=  MIMRXBRDATA_CRMCORECLK_dly;
        MIMTXBRDATA_indelay <=  MIMTXBRDATA_CRMCORECLK_dly;
	PIPEPHYSTATUSL0_indelay <=  PIPEPHYSTATUSL0_CRMCORECLK_dly; 
	PIPEPHYSTATUSL1_indelay <=  PIPEPHYSTATUSL1_CRMCORECLK_dly; 
	PIPEPHYSTATUSL2_indelay <=  PIPEPHYSTATUSL2_CRMCORECLK_dly; 
	PIPEPHYSTATUSL3_indelay <=  PIPEPHYSTATUSL3_CRMCORECLK_dly; 
	PIPEPHYSTATUSL4_indelay <= PIPEPHYSTATUSL4_CRMCORECLK_dly; 
	PIPEPHYSTATUSL5_indelay <=  PIPEPHYSTATUSL5_CRMCORECLK_dly; 
	PIPEPHYSTATUSL6_indelay <=  PIPEPHYSTATUSL6_CRMCORECLK_dly; 
	PIPEPHYSTATUSL7_indelay <=  PIPEPHYSTATUSL7_CRMCORECLK_dly; 
	PIPERXCHANISALIGNEDL0_indelay <=  PIPERXCHANISALIGNEDL0_CRMCORECLK_dly; 
	PIPERXCHANISALIGNEDL1_indelay <=  PIPERXCHANISALIGNEDL1_CRMCORECLK_dly; 
	PIPERXCHANISALIGNEDL2_indelay <=  PIPERXCHANISALIGNEDL2_CRMCORECLK_dly; 
	PIPERXCHANISALIGNEDL3_indelay <=  PIPERXCHANISALIGNEDL3_CRMCORECLK_dly; 
	PIPERXCHANISALIGNEDL4_indelay <=  PIPERXCHANISALIGNEDL4_CRMCORECLK_dly; 
	PIPERXCHANISALIGNEDL5_indelay <=  PIPERXCHANISALIGNEDL5_CRMCORECLK_dly; 
	PIPERXCHANISALIGNEDL6_indelay <=  PIPERXCHANISALIGNEDL6_CRMCORECLK_dly; 
	PIPERXCHANISALIGNEDL7_indelay <=  PIPERXCHANISALIGNEDL7_CRMCORECLK_dly; 
	PIPERXDATAKL0_indelay <=  PIPERXDATAKL0_CRMCORECLK_dly; 
	PIPERXDATAKL1_indelay <=  PIPERXDATAKL1_CRMCORECLK_dly; 
	PIPERXDATAKL2_indelay <=  PIPERXDATAKL2_CRMCORECLK_dly; 
	PIPERXDATAKL3_indelay <=  PIPERXDATAKL3_CRMCORECLK_dly; 
	PIPERXDATAKL4_indelay <=  PIPERXDATAKL4_CRMCORECLK_dly; 
	PIPERXDATAKL5_indelay <=  PIPERXDATAKL5_CRMCORECLK_dly; 
	PIPERXDATAKL6_indelay <=  PIPERXDATAKL6_CRMCORECLK_dly; 
	PIPERXDATAKL7_indelay <=  PIPERXDATAKL7_CRMCORECLK_dly; 
	PIPERXDATAL0_indelay <=  PIPERXDATAL0_CRMCORECLK_dly;
	PIPERXDATAL1_indelay <=  PIPERXDATAL1_CRMCORECLK_dly;
	PIPERXDATAL2_indelay <=  PIPERXDATAL2_CRMCORECLK_dly;
	PIPERXDATAL3_indelay <=  PIPERXDATAL3_CRMCORECLK_dly;
	PIPERXDATAL4_indelay <=  PIPERXDATAL4_CRMCORECLK_dly;
	PIPERXDATAL5_indelay <=  PIPERXDATAL5_CRMCORECLK_dly;
	PIPERXDATAL6_indelay <=  PIPERXDATAL6_CRMCORECLK_dly;
	PIPERXDATAL7_indelay <=  PIPERXDATAL7_CRMCORECLK_dly;
	PIPERXELECIDLEL0_indelay <=  PIPERXELECIDLEL0_CRMCORECLK_dly; 
	PIPERXELECIDLEL1_indelay <=  PIPERXELECIDLEL1_CRMCORECLK_dly; 
	PIPERXELECIDLEL2_indelay <=  PIPERXELECIDLEL2_CRMCORECLK_dly; 
	PIPERXELECIDLEL3_indelay <=  PIPERXELECIDLEL3_CRMCORECLK_dly; 
	PIPERXELECIDLEL4_indelay <=  PIPERXELECIDLEL4_CRMCORECLK_dly; 
	PIPERXELECIDLEL5_indelay <=  PIPERXELECIDLEL5_CRMCORECLK_dly; 
	PIPERXELECIDLEL6_indelay <=  PIPERXELECIDLEL6_CRMCORECLK_dly; 
	PIPERXELECIDLEL7_indelay <=  PIPERXELECIDLEL7_CRMCORECLK_dly; 
	PIPERXSTATUSL0_indelay <=  PIPERXSTATUSL0_CRMCORECLK_dly;
	PIPERXSTATUSL1_indelay <=  PIPERXSTATUSL1_CRMCORECLK_dly;
	PIPERXSTATUSL2_indelay <=  PIPERXSTATUSL2_CRMCORECLK_dly;
	PIPERXSTATUSL3_indelay <=  PIPERXSTATUSL3_CRMCORECLK_dly;
	PIPERXSTATUSL4_indelay <=  PIPERXSTATUSL4_CRMCORECLK_dly;
	PIPERXSTATUSL5_indelay <=  PIPERXSTATUSL5_CRMCORECLK_dly;
	PIPERXSTATUSL6_indelay <=  PIPERXSTATUSL6_CRMCORECLK_dly;
	PIPERXSTATUSL7_indelay <=  PIPERXSTATUSL7_CRMCORECLK_dly;
	PIPERXVALIDL0_indelay <=  PIPERXVALIDL0_CRMCORECLK_dly; 
	PIPERXVALIDL1_indelay <=  PIPERXVALIDL1_CRMCORECLK_dly; 
	PIPERXVALIDL2_indelay <=  PIPERXVALIDL2_CRMCORECLK_dly; 
	PIPERXVALIDL3_indelay <=  PIPERXVALIDL3_CRMCORECLK_dly; 
	PIPERXVALIDL4_indelay <=  PIPERXVALIDL4_CRMCORECLK_dly; 
	PIPERXVALIDL5_indelay <=  PIPERXVALIDL5_CRMCORECLK_dly; 
	PIPERXVALIDL6_indelay <=  PIPERXVALIDL6_CRMCORECLK_dly; 
	PIPERXVALIDL7_indelay <=  PIPERXVALIDL7_CRMCORECLK_dly; 




        BUSMASTERENABLE_out <= BUSMASTERENABLE_outdelay after OUT_DELAY;
        CRMDOHOTRESETN_out <= CRMDOHOTRESETN_outdelay after OUT_DELAY;
        CRMPWRSOFTRESETN_out <= CRMPWRSOFTRESETN_outdelay after OUT_DELAY;
        CRMRXHOTRESETN_out <= CRMRXHOTRESETN_outdelay after OUT_DELAY;
        DLLTXPMDLLPOUTSTANDING_out <= DLLTXPMDLLPOUTSTANDING_outdelay after OUT_DELAY;
        INTERRUPTDISABLE_out <= INTERRUPTDISABLE_outdelay after OUT_DELAY;
        IOSPACEENABLE_out <= IOSPACEENABLE_outdelay after OUT_DELAY;
        L0ASAUTONOMOUSINITCOMPLETED_out <= L0ASAUTONOMOUSINITCOMPLETED_outdelay after OUT_DELAY;
        L0ATTENTIONINDICATORCONTROL_out <= L0ATTENTIONINDICATORCONTROL_outdelay after OUT_DELAY;
        L0CFGLOOPBACKACK_out <= L0CFGLOOPBACKACK_outdelay after OUT_DELAY;
        L0COMPLETERID_out <= L0COMPLETERID_outdelay after OUT_DELAY;
        L0CORRERRMSGRCVD_out <= L0CORRERRMSGRCVD_outdelay after OUT_DELAY;
        L0DLLASRXSTATE_out <= L0DLLASRXSTATE_outdelay after OUT_DELAY;
        L0DLLASTXSTATE_out <= L0DLLASTXSTATE_outdelay after OUT_DELAY;
        L0DLLERRORVECTOR_out <= L0DLLERRORVECTOR_outdelay after OUT_DELAY;
        L0DLLRXACKOUTSTANDING_out <= L0DLLRXACKOUTSTANDING_outdelay after OUT_DELAY;
        L0DLLTXNONFCOUTSTANDING_out <= L0DLLTXNONFCOUTSTANDING_outdelay after OUT_DELAY;
        L0DLLTXOUTSTANDING_out <= L0DLLTXOUTSTANDING_outdelay after OUT_DELAY;
        L0DLLVCSTATUS_out <= L0DLLVCSTATUS_outdelay after OUT_DELAY;
        L0DLUPDOWN_out <= L0DLUPDOWN_outdelay after OUT_DELAY;
        L0ERRMSGREQID_out <= L0ERRMSGREQID_outdelay after OUT_DELAY;
        L0FATALERRMSGRCVD_out <= L0FATALERRMSGRCVD_outdelay after OUT_DELAY;
        L0FIRSTCFGWRITEOCCURRED_out <= L0FIRSTCFGWRITEOCCURRED_outdelay after OUT_DELAY;
        L0FWDCORRERROUT_out <= L0FWDCORRERROUT_outdelay after OUT_DELAY;
        L0FWDFATALERROUT_out <= L0FWDFATALERROUT_outdelay after OUT_DELAY;
        L0FWDNONFATALERROUT_out <= L0FWDNONFATALERROUT_outdelay after OUT_DELAY;
        L0LTSSMSTATE_out <= L0LTSSMSTATE_outdelay after OUT_DELAY;
        L0MACENTEREDL0_out <= L0MACENTEREDL0_outdelay after OUT_DELAY;
        L0MACLINKTRAINING_out <= L0MACLINKTRAINING_outdelay after OUT_DELAY;
        L0MACLINKUP_out <= L0MACLINKUP_outdelay after OUT_DELAY;
        L0MACNEGOTIATEDLINKWIDTH_out <= L0MACNEGOTIATEDLINKWIDTH_outdelay after OUT_DELAY;
        L0MACNEWSTATEACK_out <= L0MACNEWSTATEACK_outdelay after OUT_DELAY;
        L0MACRXL0SSTATE_out <= L0MACRXL0SSTATE_outdelay after OUT_DELAY;
        L0MACUPSTREAMDOWNSTREAM_out <= L0MACUPSTREAMDOWNSTREAM_outdelay after OUT_DELAY;
        L0MCFOUND_out <= L0MCFOUND_outdelay after OUT_DELAY;
        L0MSIENABLE0_out <= L0MSIENABLE0_outdelay after OUT_DELAY;
        L0MULTIMSGEN0_out <= L0MULTIMSGEN0_outdelay after OUT_DELAY;
        L0NONFATALERRMSGRCVD_out <= L0NONFATALERRMSGRCVD_outdelay after OUT_DELAY;
        L0PMEACK_out <= L0PMEACK_outdelay after OUT_DELAY;
        L0PMEEN_out <= L0PMEEN_outdelay after OUT_DELAY;
        L0PMEREQOUT_out <= L0PMEREQOUT_outdelay after OUT_DELAY;
        L0POWERCONTROLLERCONTROL_out <= L0POWERCONTROLLERCONTROL_outdelay after OUT_DELAY;
        L0POWERINDICATORCONTROL_out <= L0POWERINDICATORCONTROL_outdelay after OUT_DELAY;
        L0PWRINHIBITTRANSFERS_out <= L0PWRINHIBITTRANSFERS_outdelay after OUT_DELAY;
        L0PWRL1STATE_out <= L0PWRL1STATE_outdelay after OUT_DELAY;
        L0PWRL23READYDEVICE_out <= L0PWRL23READYDEVICE_outdelay after OUT_DELAY;
        L0PWRL23READYSTATE_out <= L0PWRL23READYSTATE_outdelay after OUT_DELAY;
        L0PWRSTATE0_out <= L0PWRSTATE0_outdelay after OUT_DELAY;
        L0PWRTURNOFFREQ_out <= L0PWRTURNOFFREQ_outdelay after OUT_DELAY;
        L0PWRTXL0SSTATE_out <= L0PWRTXL0SSTATE_outdelay after OUT_DELAY;
        L0RECEIVEDASSERTINTALEGACYINT_out <= L0RECEIVEDASSERTINTALEGACYINT_outdelay after OUT_DELAY;
        L0RECEIVEDASSERTINTBLEGACYINT_out <= L0RECEIVEDASSERTINTBLEGACYINT_outdelay after OUT_DELAY;
        L0RECEIVEDASSERTINTCLEGACYINT_out <= L0RECEIVEDASSERTINTCLEGACYINT_outdelay after OUT_DELAY;
        L0RECEIVEDASSERTINTDLEGACYINT_out <= L0RECEIVEDASSERTINTDLEGACYINT_outdelay after OUT_DELAY;
        L0RECEIVEDDEASSERTINTALEGACYINT_out <= L0RECEIVEDDEASSERTINTALEGACYINT_outdelay after OUT_DELAY;
        L0RECEIVEDDEASSERTINTBLEGACYINT_out <= L0RECEIVEDDEASSERTINTBLEGACYINT_outdelay after OUT_DELAY;
        L0RECEIVEDDEASSERTINTCLEGACYINT_out <= L0RECEIVEDDEASSERTINTCLEGACYINT_outdelay after OUT_DELAY;
        L0RECEIVEDDEASSERTINTDLEGACYINT_out <= L0RECEIVEDDEASSERTINTDLEGACYINT_outdelay after OUT_DELAY;
        L0RXBEACON_out <= L0RXBEACON_outdelay after OUT_DELAY;
        L0RXDLLFCCMPLMCCRED_out <= L0RXDLLFCCMPLMCCRED_outdelay after OUT_DELAY;
        L0RXDLLFCCMPLMCUPDATE_out <= L0RXDLLFCCMPLMCUPDATE_outdelay after OUT_DELAY;
        L0RXDLLFCNPOSTBYPCRED_out <= L0RXDLLFCNPOSTBYPCRED_outdelay after OUT_DELAY;
        L0RXDLLFCNPOSTBYPUPDATE_out <= L0RXDLLFCNPOSTBYPUPDATE_outdelay after OUT_DELAY;
        L0RXDLLFCPOSTORDCRED_out <= L0RXDLLFCPOSTORDCRED_outdelay after OUT_DELAY;
        L0RXDLLFCPOSTORDUPDATE_out <= L0RXDLLFCPOSTORDUPDATE_outdelay after OUT_DELAY;
        L0RXDLLPMTYPE_out <= L0RXDLLPMTYPE_outdelay after OUT_DELAY;
        L0RXDLLPM_out <= L0RXDLLPM_outdelay after OUT_DELAY;
        L0RXDLLSBFCDATA_out <= L0RXDLLSBFCDATA_outdelay after OUT_DELAY;
        L0RXDLLSBFCUPDATE_out <= L0RXDLLSBFCUPDATE_outdelay after OUT_DELAY;
        L0RXDLLTLPECRCOK_out <= L0RXDLLTLPECRCOK_outdelay after OUT_DELAY;
        L0RXDLLTLPEND_out <= L0RXDLLTLPEND_outdelay after OUT_DELAY;
        L0RXMACLINKERROR_out <= L0RXMACLINKERROR_outdelay after OUT_DELAY;
        L0STATSCFGOTHERRECEIVED_out <= L0STATSCFGOTHERRECEIVED_outdelay after OUT_DELAY;
        L0STATSCFGOTHERTRANSMITTED_out <= L0STATSCFGOTHERTRANSMITTED_outdelay after OUT_DELAY;
        L0STATSCFGRECEIVED_out <= L0STATSCFGRECEIVED_outdelay after OUT_DELAY;
        L0STATSCFGTRANSMITTED_out <= L0STATSCFGTRANSMITTED_outdelay after OUT_DELAY;
        L0STATSDLLPRECEIVED_out <= L0STATSDLLPRECEIVED_outdelay after OUT_DELAY;
        L0STATSDLLPTRANSMITTED_out <= L0STATSDLLPTRANSMITTED_outdelay after OUT_DELAY;
        L0STATSOSRECEIVED_out <= L0STATSOSRECEIVED_outdelay after OUT_DELAY;
        L0STATSOSTRANSMITTED_out <= L0STATSOSTRANSMITTED_outdelay after OUT_DELAY;
        L0STATSTLPRECEIVED_out <= L0STATSTLPRECEIVED_outdelay after OUT_DELAY;
        L0STATSTLPTRANSMITTED_out <= L0STATSTLPTRANSMITTED_outdelay after OUT_DELAY;
        L0TOGGLEELECTROMECHANICALINTERLOCK_out <= L0TOGGLEELECTROMECHANICALINTERLOCK_outdelay after OUT_DELAY;
        L0TRANSFORMEDVC_out <= L0TRANSFORMEDVC_outdelay after OUT_DELAY;
        L0TXDLLFCCMPLMCUPDATED_out <= L0TXDLLFCCMPLMCUPDATED_outdelay after OUT_DELAY;
        L0TXDLLFCNPOSTBYPUPDATED_out <= L0TXDLLFCNPOSTBYPUPDATED_outdelay after OUT_DELAY;
        L0TXDLLFCPOSTORDUPDATED_out <= L0TXDLLFCPOSTORDUPDATED_outdelay after OUT_DELAY;
        L0TXDLLPMUPDATED_out <= L0TXDLLPMUPDATED_outdelay after OUT_DELAY;
        L0TXDLLSBFCUPDATED_out <= L0TXDLLSBFCUPDATED_outdelay after OUT_DELAY;
        L0UCBYPFOUND_out <= L0UCBYPFOUND_outdelay after OUT_DELAY;
        L0UCORDFOUND_out <= L0UCORDFOUND_outdelay after OUT_DELAY;
        L0UNLOCKRECEIVED_out <= L0UNLOCKRECEIVED_outdelay after OUT_DELAY;
        LLKRX4DWHEADERN_out <= LLKRX4DWHEADERN_outdelay after OUT_DELAY;
        LLKRXCHCOMPLETIONAVAILABLEN_out <= LLKRXCHCOMPLETIONAVAILABLEN_outdelay after OUT_DELAY;
        LLKRXCHCOMPLETIONPARTIALN_out <= LLKRXCHCOMPLETIONPARTIALN_outdelay after OUT_DELAY;
        LLKRXCHCONFIGAVAILABLEN_out <= LLKRXCHCONFIGAVAILABLEN_outdelay after OUT_DELAY;
        LLKRXCHCONFIGPARTIALN_out <= LLKRXCHCONFIGPARTIALN_outdelay after OUT_DELAY;
        LLKRXCHNONPOSTEDAVAILABLEN_out <= LLKRXCHNONPOSTEDAVAILABLEN_outdelay after OUT_DELAY;
        LLKRXCHNONPOSTEDPARTIALN_out <= LLKRXCHNONPOSTEDPARTIALN_outdelay after OUT_DELAY;
        LLKRXCHPOSTEDAVAILABLEN_out <= LLKRXCHPOSTEDAVAILABLEN_outdelay after OUT_DELAY;
        LLKRXCHPOSTEDPARTIALN_out <= LLKRXCHPOSTEDPARTIALN_outdelay after OUT_DELAY;
        LLKRXDATA_out <= LLKRXDATA_outdelay after OUT_DELAY;
        LLKRXECRCBADN_out <= LLKRXECRCBADN_outdelay after OUT_DELAY;
        LLKRXEOFN_out <= LLKRXEOFN_outdelay after OUT_DELAY;
        LLKRXEOPN_out <= LLKRXEOPN_outdelay after OUT_DELAY;
        LLKRXPREFERREDTYPE_out <= LLKRXPREFERREDTYPE_outdelay after OUT_DELAY;
        LLKRXSOFN_out <= LLKRXSOFN_outdelay after OUT_DELAY;
        LLKRXSOPN_out <= LLKRXSOPN_outdelay after OUT_DELAY;
        LLKRXSRCDSCN_out <= LLKRXSRCDSCN_outdelay after OUT_DELAY;
        LLKRXSRCLASTREQN_out <= LLKRXSRCLASTREQN_outdelay after OUT_DELAY;
        LLKRXSRCRDYN_out <= LLKRXSRCRDYN_outdelay after OUT_DELAY;
        LLKRXVALIDN_out <= LLKRXVALIDN_outdelay after OUT_DELAY;
        LLKTCSTATUS_out <= LLKTCSTATUS_outdelay after OUT_DELAY;
        LLKTXCHANSPACE_out <= LLKTXCHANSPACE_outdelay after OUT_DELAY;
        LLKTXCHCOMPLETIONREADYN_out <= LLKTXCHCOMPLETIONREADYN_outdelay after OUT_DELAY;
        LLKTXCHNONPOSTEDREADYN_out <= LLKTXCHNONPOSTEDREADYN_outdelay after OUT_DELAY;
        LLKTXCHPOSTEDREADYN_out <= LLKTXCHPOSTEDREADYN_outdelay after OUT_DELAY;
        LLKTXCONFIGREADYN_out <= LLKTXCONFIGREADYN_outdelay after OUT_DELAY;
        LLKTXDSTRDYN_out <= LLKTXDSTRDYN_outdelay after OUT_DELAY;
        MAXPAYLOADSIZE_out <= MAXPAYLOADSIZE_outdelay after OUT_DELAY;
        MAXREADREQUESTSIZE_out <= MAXREADREQUESTSIZE_outdelay after OUT_DELAY;
        MEMSPACEENABLE_out <= MEMSPACEENABLE_outdelay after OUT_DELAY;
        MGMTPSO_out <= MGMTPSO_outdelay after OUT_DELAY;
        MGMTRDATA_out <= MGMTRDATA_outdelay after OUT_DELAY;
        MGMTSTATSCREDIT_out <= MGMTSTATSCREDIT_outdelay after OUT_DELAY;
        MIMDLLBRADD_out <= MIMDLLBRADD_outdelay after OUT_DELAY;
        MIMDLLBREN_out <= MIMDLLBREN_outdelay after OUT_DELAY;
        MIMDLLBWADD_out <= MIMDLLBWADD_outdelay after OUT_DELAY;
        MIMDLLBWDATA_out <= MIMDLLBWDATA_outdelay after OUT_DELAY;
        MIMDLLBWEN_out <= MIMDLLBWEN_outdelay after OUT_DELAY;
        MIMRXBRADD_out <= MIMRXBRADD_outdelay after OUT_DELAY;
        MIMRXBREN_out <= MIMRXBREN_outdelay after OUT_DELAY;
        MIMRXBWADD_out <= MIMRXBWADD_outdelay after OUT_DELAY;
        MIMRXBWDATA_out <= MIMRXBWDATA_outdelay after OUT_DELAY;
        MIMRXBWEN_out <= MIMRXBWEN_outdelay after OUT_DELAY;
        MIMTXBRADD_out <= MIMTXBRADD_outdelay after OUT_DELAY;
        MIMTXBREN_out <= MIMTXBREN_outdelay after OUT_DELAY;
        MIMTXBWADD_out <= MIMTXBWADD_outdelay after OUT_DELAY;
        MIMTXBWDATA_out <= MIMTXBWDATA_outdelay after OUT_DELAY;
        MIMTXBWEN_out <= MIMTXBWEN_outdelay after OUT_DELAY;
        PARITYERRORRESPONSE_out <= PARITYERRORRESPONSE_outdelay after OUT_DELAY;
        PIPEDESKEWLANESL0_out <= PIPEDESKEWLANESL0_outdelay after OUT_DELAY;
        PIPEDESKEWLANESL1_out <= PIPEDESKEWLANESL1_outdelay after OUT_DELAY;
        PIPEDESKEWLANESL2_out <= PIPEDESKEWLANESL2_outdelay after OUT_DELAY;
        PIPEDESKEWLANESL3_out <= PIPEDESKEWLANESL3_outdelay after OUT_DELAY;
        PIPEDESKEWLANESL4_out <= PIPEDESKEWLANESL4_outdelay after OUT_DELAY;
        PIPEDESKEWLANESL5_out <= PIPEDESKEWLANESL5_outdelay after OUT_DELAY;
        PIPEDESKEWLANESL6_out <= PIPEDESKEWLANESL6_outdelay after OUT_DELAY;
        PIPEDESKEWLANESL7_out <= PIPEDESKEWLANESL7_outdelay after OUT_DELAY;
        PIPEPOWERDOWNL0_out <= PIPEPOWERDOWNL0_outdelay after OUT_DELAY;
        PIPEPOWERDOWNL1_out <= PIPEPOWERDOWNL1_outdelay after OUT_DELAY;
        PIPEPOWERDOWNL2_out <= PIPEPOWERDOWNL2_outdelay after OUT_DELAY;
        PIPEPOWERDOWNL3_out <= PIPEPOWERDOWNL3_outdelay after OUT_DELAY;
        PIPEPOWERDOWNL4_out <= PIPEPOWERDOWNL4_outdelay after OUT_DELAY;
        PIPEPOWERDOWNL5_out <= PIPEPOWERDOWNL5_outdelay after OUT_DELAY;
        PIPEPOWERDOWNL6_out <= PIPEPOWERDOWNL6_outdelay after OUT_DELAY;
        PIPEPOWERDOWNL7_out <= PIPEPOWERDOWNL7_outdelay after OUT_DELAY;
        PIPERESETL0_out <= PIPERESETL0_outdelay after OUT_DELAY;
        PIPERESETL1_out <= PIPERESETL1_outdelay after OUT_DELAY;
        PIPERESETL2_out <= PIPERESETL2_outdelay after OUT_DELAY;
        PIPERESETL3_out <= PIPERESETL3_outdelay after OUT_DELAY;
        PIPERESETL4_out <= PIPERESETL4_outdelay after OUT_DELAY;
        PIPERESETL5_out <= PIPERESETL5_outdelay after OUT_DELAY;
        PIPERESETL6_out <= PIPERESETL6_outdelay after OUT_DELAY;
        PIPERESETL7_out <= PIPERESETL7_outdelay after OUT_DELAY;
        PIPERXPOLARITYL0_out <= PIPERXPOLARITYL0_outdelay after OUT_DELAY;
        PIPERXPOLARITYL1_out <= PIPERXPOLARITYL1_outdelay after OUT_DELAY;
        PIPERXPOLARITYL2_out <= PIPERXPOLARITYL2_outdelay after OUT_DELAY;
        PIPERXPOLARITYL3_out <= PIPERXPOLARITYL3_outdelay after OUT_DELAY;
        PIPERXPOLARITYL4_out <= PIPERXPOLARITYL4_outdelay after OUT_DELAY;
        PIPERXPOLARITYL5_out <= PIPERXPOLARITYL5_outdelay after OUT_DELAY;
        PIPERXPOLARITYL6_out <= PIPERXPOLARITYL6_outdelay after OUT_DELAY;
        PIPERXPOLARITYL7_out <= PIPERXPOLARITYL7_outdelay after OUT_DELAY;
        PIPETXCOMPLIANCEL0_out <= PIPETXCOMPLIANCEL0_outdelay after OUT_DELAY;
        PIPETXCOMPLIANCEL1_out <= PIPETXCOMPLIANCEL1_outdelay after OUT_DELAY;
        PIPETXCOMPLIANCEL2_out <= PIPETXCOMPLIANCEL2_outdelay after OUT_DELAY;
        PIPETXCOMPLIANCEL3_out <= PIPETXCOMPLIANCEL3_outdelay after OUT_DELAY;
        PIPETXCOMPLIANCEL4_out <= PIPETXCOMPLIANCEL4_outdelay after OUT_DELAY;
        PIPETXCOMPLIANCEL5_out <= PIPETXCOMPLIANCEL5_outdelay after OUT_DELAY;
        PIPETXCOMPLIANCEL6_out <= PIPETXCOMPLIANCEL6_outdelay after OUT_DELAY;
        PIPETXCOMPLIANCEL7_out <= PIPETXCOMPLIANCEL7_outdelay after OUT_DELAY;
        PIPETXDATAKL0_out <= PIPETXDATAKL0_outdelay after OUT_DELAY;
        PIPETXDATAKL1_out <= PIPETXDATAKL1_outdelay after OUT_DELAY;
        PIPETXDATAKL2_out <= PIPETXDATAKL2_outdelay after OUT_DELAY;
        PIPETXDATAKL3_out <= PIPETXDATAKL3_outdelay after OUT_DELAY;
        PIPETXDATAKL4_out <= PIPETXDATAKL4_outdelay after OUT_DELAY;
        PIPETXDATAKL5_out <= PIPETXDATAKL5_outdelay after OUT_DELAY;
        PIPETXDATAKL6_out <= PIPETXDATAKL6_outdelay after OUT_DELAY;
        PIPETXDATAKL7_out <= PIPETXDATAKL7_outdelay after OUT_DELAY;
        PIPETXDATAL0_out <= PIPETXDATAL0_outdelay after OUT_DELAY;
        PIPETXDATAL1_out <= PIPETXDATAL1_outdelay after OUT_DELAY;
        PIPETXDATAL2_out <= PIPETXDATAL2_outdelay after OUT_DELAY;
        PIPETXDATAL3_out <= PIPETXDATAL3_outdelay after OUT_DELAY;
        PIPETXDATAL4_out <= PIPETXDATAL4_outdelay after OUT_DELAY;
        PIPETXDATAL5_out <= PIPETXDATAL5_outdelay after OUT_DELAY;
        PIPETXDATAL6_out <= PIPETXDATAL6_outdelay after OUT_DELAY;
        PIPETXDATAL7_out <= PIPETXDATAL7_outdelay after OUT_DELAY;
        PIPETXDETECTRXLOOPBACKL0_out <= PIPETXDETECTRXLOOPBACKL0_outdelay after OUT_DELAY;
        PIPETXDETECTRXLOOPBACKL1_out <= PIPETXDETECTRXLOOPBACKL1_outdelay after OUT_DELAY;
        PIPETXDETECTRXLOOPBACKL2_out <= PIPETXDETECTRXLOOPBACKL2_outdelay after OUT_DELAY;
        PIPETXDETECTRXLOOPBACKL3_out <= PIPETXDETECTRXLOOPBACKL3_outdelay after OUT_DELAY;
        PIPETXDETECTRXLOOPBACKL4_out <= PIPETXDETECTRXLOOPBACKL4_outdelay after OUT_DELAY;
        PIPETXDETECTRXLOOPBACKL5_out <= PIPETXDETECTRXLOOPBACKL5_outdelay after OUT_DELAY;
        PIPETXDETECTRXLOOPBACKL6_out <= PIPETXDETECTRXLOOPBACKL6_outdelay after OUT_DELAY;
        PIPETXDETECTRXLOOPBACKL7_out <= PIPETXDETECTRXLOOPBACKL7_outdelay after OUT_DELAY;
        PIPETXELECIDLEL0_out <= PIPETXELECIDLEL0_outdelay after OUT_DELAY;
        PIPETXELECIDLEL1_out <= PIPETXELECIDLEL1_outdelay after OUT_DELAY;
        PIPETXELECIDLEL2_out <= PIPETXELECIDLEL2_outdelay after OUT_DELAY;
        PIPETXELECIDLEL3_out <= PIPETXELECIDLEL3_outdelay after OUT_DELAY;
        PIPETXELECIDLEL4_out <= PIPETXELECIDLEL4_outdelay after OUT_DELAY;
        PIPETXELECIDLEL5_out <= PIPETXELECIDLEL5_outdelay after OUT_DELAY;
        PIPETXELECIDLEL6_out <= PIPETXELECIDLEL6_outdelay after OUT_DELAY;
        PIPETXELECIDLEL7_out <= PIPETXELECIDLEL7_outdelay after OUT_DELAY;
        SERRENABLE_out <= SERRENABLE_outdelay after OUT_DELAY;
        URREPORTINGENABLE_out <= URREPORTINGENABLE_outdelay after OUT_DELAY;
        
        CRMCORECLKDLO_indly <= CRMCORECLKDLO_dly after CLK_DELAY;
        CRMCORECLKRXO_indly <= CRMCORECLKRXO_dly after CLK_DELAY;
        CRMCORECLKTXO_indly <= CRMCORECLKTXO_dly after CLK_DELAY;
        CRMCORECLK_indly <= CRMCORECLK_dly after CLK_DELAY;
        CRMUSERCLKRXO_indly <= CRMUSERCLKRXO_dly after CLK_DELAY;
        CRMUSERCLKTXO_indly <= CRMUSERCLKTXO_dly after CLK_DELAY;
        CRMUSERCLK_indly <= CRMUSERCLK_dly after CLK_DELAY;
        
        AUXPOWER_indly <= AUXPOWER_indelay after IN_DELAY;
        CFGNEGOTIATEDLINKWIDTH_indly <= CFGNEGOTIATEDLINKWIDTH_indelay after IN_DELAY;
        COMPLIANCEAVOID_indly <= COMPLIANCEAVOID_indelay after IN_DELAY;
        CRMCFGBRIDGEHOTRESET_indly <= CRMCFGBRIDGEHOTRESET_indelay after IN_DELAY;
        CRMLINKRSTN_indly <= CRMLINKRSTN_indelay after IN_DELAY;
        CRMMACRSTN_indly <= CRMMACRSTN_indelay after IN_DELAY;
        CRMMGMTRSTN_indly <= CRMMGMTRSTN_indelay after IN_DELAY;
        CRMNVRSTN_indly <= CRMNVRSTN_indelay after IN_DELAY;
        CRMTXHOTRESETN_indly <= CRMTXHOTRESETN_indelay after IN_DELAY;
        CRMURSTN_indly <= CRMURSTN_indelay after IN_DELAY;
        CRMUSERCFGRSTN_indly <= CRMUSERCFGRSTN_indelay after IN_DELAY;
        CROSSLINKSEED_indly <= CROSSLINKSEED_indelay after IN_DELAY;
        L0ACKNAKTIMERADJUSTMENT_indly <= L0ACKNAKTIMERADJUSTMENT_indelay after IN_DELAY;
        L0ALLDOWNPORTSINL1_indly <= L0ALLDOWNPORTSINL1_indelay after IN_DELAY;
        L0ALLDOWNRXPORTSINL0S_indly <= L0ALLDOWNRXPORTSINL0S_indelay after IN_DELAY;
        L0ASE_indly <= L0ASE_indelay after IN_DELAY;
        L0ASPORTCOUNT_indly <= L0ASPORTCOUNT_indelay after IN_DELAY;
        L0ASTURNPOOLBITSCONSUMED_indly <= L0ASTURNPOOLBITSCONSUMED_indelay after IN_DELAY;
        L0ATTENTIONBUTTONPRESSED_indly <= L0ATTENTIONBUTTONPRESSED_indelay after IN_DELAY;
        L0CFGASSPANTREEOWNEDSTATE_indly <= L0CFGASSPANTREEOWNEDSTATE_indelay after IN_DELAY;
        L0CFGASSTATECHANGECMD_indly <= L0CFGASSTATECHANGECMD_indelay after IN_DELAY;
        L0CFGDISABLESCRAMBLE_indly <= L0CFGDISABLESCRAMBLE_indelay after IN_DELAY;
        L0CFGEXTENDEDSYNC_indly <= L0CFGEXTENDEDSYNC_indelay after IN_DELAY;
        L0CFGL0SENTRYENABLE_indly <= L0CFGL0SENTRYENABLE_indelay after IN_DELAY;
        L0CFGL0SENTRYSUP_indly <= L0CFGL0SENTRYSUP_indelay after IN_DELAY;
        L0CFGL0SEXITLAT_indly <= L0CFGL0SEXITLAT_indelay after IN_DELAY;
        L0CFGLINKDISABLE_indly <= L0CFGLINKDISABLE_indelay after IN_DELAY;
        L0CFGLOOPBACKMASTER_indly <= L0CFGLOOPBACKMASTER_indelay after IN_DELAY;
        L0CFGNEGOTIATEDMAXP_indly <= L0CFGNEGOTIATEDMAXP_indelay after IN_DELAY;
        L0CFGVCENABLE_indly <= L0CFGVCENABLE_indelay after IN_DELAY;
        L0CFGVCID_indly <= L0CFGVCID_indelay after IN_DELAY;
        L0DLLHOLDLINKUP_indly <= L0DLLHOLDLINKUP_indelay after IN_DELAY;
        L0ELECTROMECHANICALINTERLOCKENGAGED_indly <= L0ELECTROMECHANICALINTERLOCKENGAGED_indelay after IN_DELAY;
        L0FWDASSERTINTALEGACYINT_indly <= L0FWDASSERTINTALEGACYINT_indelay after IN_DELAY;
        L0FWDASSERTINTBLEGACYINT_indly <= L0FWDASSERTINTBLEGACYINT_indelay after IN_DELAY;
        L0FWDASSERTINTCLEGACYINT_indly <= L0FWDASSERTINTCLEGACYINT_indelay after IN_DELAY;
        L0FWDASSERTINTDLEGACYINT_indly <= L0FWDASSERTINTDLEGACYINT_indelay after IN_DELAY;
        L0FWDCORRERRIN_indly <= L0FWDCORRERRIN_indelay after IN_DELAY;
        L0FWDDEASSERTINTALEGACYINT_indly <= L0FWDDEASSERTINTALEGACYINT_indelay after IN_DELAY;
        L0FWDDEASSERTINTBLEGACYINT_indly <= L0FWDDEASSERTINTBLEGACYINT_indelay after IN_DELAY;
        L0FWDDEASSERTINTCLEGACYINT_indly <= L0FWDDEASSERTINTCLEGACYINT_indelay after IN_DELAY;
        L0FWDDEASSERTINTDLEGACYINT_indly <= L0FWDDEASSERTINTDLEGACYINT_indelay after IN_DELAY;
        L0FWDFATALERRIN_indly <= L0FWDFATALERRIN_indelay after IN_DELAY;
        L0FWDNONFATALERRIN_indly <= L0FWDNONFATALERRIN_indelay after IN_DELAY;
        L0LEGACYINTFUNCT0_indly <= L0LEGACYINTFUNCT0_indelay after IN_DELAY;
        L0MRLSENSORCLOSEDN_indly <= L0MRLSENSORCLOSEDN_indelay after IN_DELAY;
        L0MSIREQUEST0_indly <= L0MSIREQUEST0_indelay after IN_DELAY;
        L0PACKETHEADERFROMUSER_indly <= L0PACKETHEADERFROMUSER_indelay after IN_DELAY;
        L0PMEREQIN_indly <= L0PMEREQIN_indelay after IN_DELAY;
        L0PORTNUMBER_indly <= L0PORTNUMBER_indelay after IN_DELAY;
        L0POWERFAULTDETECTED_indly <= L0POWERFAULTDETECTED_indelay after IN_DELAY;
        L0PRESENCEDETECTSLOTEMPTYN_indly <= L0PRESENCEDETECTSLOTEMPTYN_indelay after IN_DELAY;
        L0PWRNEWSTATEREQ_indly <= L0PWRNEWSTATEREQ_indelay after IN_DELAY;
        L0PWRNEXTLINKSTATE_indly <= L0PWRNEXTLINKSTATE_indelay after IN_DELAY;
        L0REPLAYTIMERADJUSTMENT_indly <= L0REPLAYTIMERADJUSTMENT_indelay after IN_DELAY;
        L0ROOTTURNOFFREQ_indly <= L0ROOTTURNOFFREQ_indelay after IN_DELAY;
        L0RXTLTLPNONINITIALIZEDVC_indly <= L0RXTLTLPNONINITIALIZEDVC_indelay after IN_DELAY;
        L0SENDUNLOCKMESSAGE_indly <= L0SENDUNLOCKMESSAGE_indelay after IN_DELAY;
        L0SETCOMPLETERABORTERROR_indly <= L0SETCOMPLETERABORTERROR_indelay after IN_DELAY;
        L0SETCOMPLETIONTIMEOUTCORRERROR_indly <= L0SETCOMPLETIONTIMEOUTCORRERROR_indelay after IN_DELAY;
        L0SETCOMPLETIONTIMEOUTUNCORRERROR_indly <= L0SETCOMPLETIONTIMEOUTUNCORRERROR_indelay after IN_DELAY;
        L0SETDETECTEDCORRERROR_indly <= L0SETDETECTEDCORRERROR_indelay after IN_DELAY;
        L0SETDETECTEDFATALERROR_indly <= L0SETDETECTEDFATALERROR_indelay after IN_DELAY;
        L0SETDETECTEDNONFATALERROR_indly <= L0SETDETECTEDNONFATALERROR_indelay after IN_DELAY;
        L0SETLINKDETECTEDPARITYERROR_indly <= L0SETLINKDETECTEDPARITYERROR_indelay after IN_DELAY;
        L0SETLINKMASTERDATAPARITY_indly <= L0SETLINKMASTERDATAPARITY_indelay after IN_DELAY;
        L0SETLINKRECEIVEDMASTERABORT_indly <= L0SETLINKRECEIVEDMASTERABORT_indelay after IN_DELAY;
        L0SETLINKRECEIVEDTARGETABORT_indly <= L0SETLINKRECEIVEDTARGETABORT_indelay after IN_DELAY;
        L0SETLINKSIGNALLEDTARGETABORT_indly <= L0SETLINKSIGNALLEDTARGETABORT_indelay after IN_DELAY;
        L0SETLINKSYSTEMERROR_indly <= L0SETLINKSYSTEMERROR_indelay after IN_DELAY;
        L0SETUNEXPECTEDCOMPLETIONCORRERROR_indly <= L0SETUNEXPECTEDCOMPLETIONCORRERROR_indelay after IN_DELAY;
        L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_indly <= L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_indelay after IN_DELAY;
        L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_indly <= L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_indelay after IN_DELAY;
        L0SETUNSUPPORTEDREQUESTOTHERERROR_indly <= L0SETUNSUPPORTEDREQUESTOTHERERROR_indelay after IN_DELAY;
        L0SETUSERDETECTEDPARITYERROR_indly <= L0SETUSERDETECTEDPARITYERROR_indelay after IN_DELAY;
        L0SETUSERMASTERDATAPARITY_indly <= L0SETUSERMASTERDATAPARITY_indelay after IN_DELAY;
        L0SETUSERRECEIVEDMASTERABORT_indly <= L0SETUSERRECEIVEDMASTERABORT_indelay after IN_DELAY;
        L0SETUSERRECEIVEDTARGETABORT_indly <= L0SETUSERRECEIVEDTARGETABORT_indelay after IN_DELAY;
        L0SETUSERSIGNALLEDTARGETABORT_indly <= L0SETUSERSIGNALLEDTARGETABORT_indelay after IN_DELAY;
        L0SETUSERSYSTEMERROR_indly <= L0SETUSERSYSTEMERROR_indelay after IN_DELAY;
        L0TLASFCCREDSTARVATION_indly <= L0TLASFCCREDSTARVATION_indelay after IN_DELAY;
        L0TLLINKRETRAIN_indly <= L0TLLINKRETRAIN_indelay after IN_DELAY;
        L0TRANSACTIONSPENDING_indly <= L0TRANSACTIONSPENDING_indelay after IN_DELAY;
        L0TXBEACON_indly <= L0TXBEACON_indelay after IN_DELAY;
        L0TXCFGPMTYPE_indly <= L0TXCFGPMTYPE_indelay after IN_DELAY;
        L0TXCFGPM_indly <= L0TXCFGPM_indelay after IN_DELAY;
        L0TXTLFCCMPLMCCRED_indly <= L0TXTLFCCMPLMCCRED_indelay after IN_DELAY;
        L0TXTLFCCMPLMCUPDATE_indly <= L0TXTLFCCMPLMCUPDATE_indelay after IN_DELAY;
        L0TXTLFCNPOSTBYPCRED_indly <= L0TXTLFCNPOSTBYPCRED_indelay after IN_DELAY;
        L0TXTLFCNPOSTBYPUPDATE_indly <= L0TXTLFCNPOSTBYPUPDATE_indelay after IN_DELAY;
        L0TXTLFCPOSTORDCRED_indly <= L0TXTLFCPOSTORDCRED_indelay after IN_DELAY;
        L0TXTLFCPOSTORDUPDATE_indly <= L0TXTLFCPOSTORDUPDATE_indelay after IN_DELAY;
        L0TXTLSBFCDATA_indly <= L0TXTLSBFCDATA_indelay after IN_DELAY;
        L0TXTLSBFCUPDATE_indly <= L0TXTLSBFCUPDATE_indelay after IN_DELAY;
        L0TXTLTLPDATA_indly <= L0TXTLTLPDATA_indelay after IN_DELAY;
        L0TXTLTLPEDB_indly <= L0TXTLTLPEDB_indelay after IN_DELAY;
        L0TXTLTLPENABLE_indly <= L0TXTLTLPENABLE_indelay after IN_DELAY;
        L0TXTLTLPEND_indly <= L0TXTLTLPEND_indelay after IN_DELAY;
        L0TXTLTLPLATENCY_indly <= L0TXTLTLPLATENCY_indelay after IN_DELAY;
        L0TXTLTLPREQEND_indly <= L0TXTLTLPREQEND_indelay after IN_DELAY;
        L0TXTLTLPREQ_indly <= L0TXTLTLPREQ_indelay after IN_DELAY;
        L0TXTLTLPWIDTH_indly <= L0TXTLTLPWIDTH_indelay after IN_DELAY;
        L0UPSTREAMRXPORTINL0S_indly <= L0UPSTREAMRXPORTINL0S_indelay after IN_DELAY;
        L0VC0PREVIEWEXPAND_indly <= L0VC0PREVIEWEXPAND_indelay after IN_DELAY;
        L0WAKEN_indly <= L0WAKEN_indelay after IN_DELAY;
        LLKRXCHFIFO_indly <= LLKRXCHFIFO_indelay after IN_DELAY;
        LLKRXCHTC_indly <= LLKRXCHTC_indelay after IN_DELAY;
        LLKRXDSTCONTREQN_indly <= LLKRXDSTCONTREQN_indelay after IN_DELAY;
        LLKRXDSTREQN_indly <= LLKRXDSTREQN_indelay after IN_DELAY;
        LLKTX4DWHEADERN_indly <= LLKTX4DWHEADERN_indelay after IN_DELAY;
        LLKTXCHFIFO_indly <= LLKTXCHFIFO_indelay after IN_DELAY;
        LLKTXCHTC_indly <= LLKTXCHTC_indelay after IN_DELAY;
        LLKTXCOMPLETEN_indly <= LLKTXCOMPLETEN_indelay after IN_DELAY;
        LLKTXCREATEECRCN_indly <= LLKTXCREATEECRCN_indelay after IN_DELAY;
        LLKTXDATA_indly <= LLKTXDATA_indelay after IN_DELAY;
        LLKTXENABLEN_indly <= LLKTXENABLEN_indelay after IN_DELAY;
        LLKTXEOFN_indly <= LLKTXEOFN_indelay after IN_DELAY;
        LLKTXEOPN_indly <= LLKTXEOPN_indelay after IN_DELAY;
        LLKTXSOFN_indly <= LLKTXSOFN_indelay after IN_DELAY;
        LLKTXSOPN_indly <= LLKTXSOPN_indelay after IN_DELAY;
        LLKTXSRCDSCN_indly <= LLKTXSRCDSCN_indelay after IN_DELAY;
        LLKTXSRCRDYN_indly <= LLKTXSRCRDYN_indelay after IN_DELAY;
        MAINPOWER_indly <= MAINPOWER_indelay after IN_DELAY;
        MGMTADDR_indly <= MGMTADDR_indelay after IN_DELAY;
        MGMTBWREN_indly <= MGMTBWREN_indelay after IN_DELAY;
        MGMTRDEN_indly <= MGMTRDEN_indelay after IN_DELAY;
        MGMTSTATSCREDITSEL_indly <= MGMTSTATSCREDITSEL_indelay after IN_DELAY;
        MGMTWDATA_indly <= MGMTWDATA_indelay after IN_DELAY;
        MGMTWREN_indly <= MGMTWREN_indelay after IN_DELAY;
        MIMDLLBRDATA_indly <= MIMDLLBRDATA_indelay after IN_DELAY;
        MIMRXBRDATA_indly <= MIMRXBRDATA_indelay after IN_DELAY;
        MIMTXBRDATA_indly <= MIMTXBRDATA_indelay after IN_DELAY;
        PIPEPHYSTATUSL0_indly <= PIPEPHYSTATUSL0_indelay after IN_DELAY;
        PIPEPHYSTATUSL1_indly <= PIPEPHYSTATUSL1_indelay after IN_DELAY;
        PIPEPHYSTATUSL2_indly <= PIPEPHYSTATUSL2_indelay after IN_DELAY;
        PIPEPHYSTATUSL3_indly <= PIPEPHYSTATUSL3_indelay after IN_DELAY;
        PIPEPHYSTATUSL4_indly <= PIPEPHYSTATUSL4_indelay after IN_DELAY;
        PIPEPHYSTATUSL5_indly <= PIPEPHYSTATUSL5_indelay after IN_DELAY;
        PIPEPHYSTATUSL6_indly <= PIPEPHYSTATUSL6_indelay after IN_DELAY;
        PIPEPHYSTATUSL7_indly <= PIPEPHYSTATUSL7_indelay after IN_DELAY;
        PIPERXCHANISALIGNEDL0_indly <= PIPERXCHANISALIGNEDL0_indelay after IN_DELAY;
        PIPERXCHANISALIGNEDL1_indly <= PIPERXCHANISALIGNEDL1_indelay after IN_DELAY;
        PIPERXCHANISALIGNEDL2_indly <= PIPERXCHANISALIGNEDL2_indelay after IN_DELAY;
        PIPERXCHANISALIGNEDL3_indly <= PIPERXCHANISALIGNEDL3_indelay after IN_DELAY;
        PIPERXCHANISALIGNEDL4_indly <= PIPERXCHANISALIGNEDL4_indelay after IN_DELAY;
        PIPERXCHANISALIGNEDL5_indly <= PIPERXCHANISALIGNEDL5_indelay after IN_DELAY;
        PIPERXCHANISALIGNEDL6_indly <= PIPERXCHANISALIGNEDL6_indelay after IN_DELAY;
        PIPERXCHANISALIGNEDL7_indly <= PIPERXCHANISALIGNEDL7_indelay after IN_DELAY;
        PIPERXDATAKL0_indly <= PIPERXDATAKL0_indelay after IN_DELAY;
        PIPERXDATAKL1_indly <= PIPERXDATAKL1_indelay after IN_DELAY;
        PIPERXDATAKL2_indly <= PIPERXDATAKL2_indelay after IN_DELAY;
        PIPERXDATAKL3_indly <= PIPERXDATAKL3_indelay after IN_DELAY;
        PIPERXDATAKL4_indly <= PIPERXDATAKL4_indelay after IN_DELAY;
        PIPERXDATAKL5_indly <= PIPERXDATAKL5_indelay after IN_DELAY;
        PIPERXDATAKL6_indly <= PIPERXDATAKL6_indelay after IN_DELAY;
        PIPERXDATAKL7_indly <= PIPERXDATAKL7_indelay after IN_DELAY;
        PIPERXDATAL0_indly <= PIPERXDATAL0_indelay after IN_DELAY;
        PIPERXDATAL1_indly <= PIPERXDATAL1_indelay after IN_DELAY;
        PIPERXDATAL2_indly <= PIPERXDATAL2_indelay after IN_DELAY;
        PIPERXDATAL3_indly <= PIPERXDATAL3_indelay after IN_DELAY;
        PIPERXDATAL4_indly <= PIPERXDATAL4_indelay after IN_DELAY;
        PIPERXDATAL5_indly <= PIPERXDATAL5_indelay after IN_DELAY;
        PIPERXDATAL6_indly <= PIPERXDATAL6_indelay after IN_DELAY;
        PIPERXDATAL7_indly <= PIPERXDATAL7_indelay after IN_DELAY;
        PIPERXELECIDLEL0_indly <= PIPERXELECIDLEL0_indelay after IN_DELAY;
        PIPERXELECIDLEL1_indly <= PIPERXELECIDLEL1_indelay after IN_DELAY;
        PIPERXELECIDLEL2_indly <= PIPERXELECIDLEL2_indelay after IN_DELAY;
        PIPERXELECIDLEL3_indly <= PIPERXELECIDLEL3_indelay after IN_DELAY;
        PIPERXELECIDLEL4_indly <= PIPERXELECIDLEL4_indelay after IN_DELAY;
        PIPERXELECIDLEL5_indly <= PIPERXELECIDLEL5_indelay after IN_DELAY;
        PIPERXELECIDLEL6_indly <= PIPERXELECIDLEL6_indelay after IN_DELAY;
        PIPERXELECIDLEL7_indly <= PIPERXELECIDLEL7_indelay after IN_DELAY;
        PIPERXSTATUSL0_indly <= PIPERXSTATUSL0_indelay after IN_DELAY;
        PIPERXSTATUSL1_indly <= PIPERXSTATUSL1_indelay after IN_DELAY;
        PIPERXSTATUSL2_indly <= PIPERXSTATUSL2_indelay after IN_DELAY;
        PIPERXSTATUSL3_indly <= PIPERXSTATUSL3_indelay after IN_DELAY;
        PIPERXSTATUSL4_indly <= PIPERXSTATUSL4_indelay after IN_DELAY;
        PIPERXSTATUSL5_indly <= PIPERXSTATUSL5_indelay after IN_DELAY;
        PIPERXSTATUSL6_indly <= PIPERXSTATUSL6_indelay after IN_DELAY;
        PIPERXSTATUSL7_indly <= PIPERXSTATUSL7_indelay after IN_DELAY;
        PIPERXVALIDL0_indly <= PIPERXVALIDL0_indelay after IN_DELAY;
        PIPERXVALIDL1_indly <= PIPERXVALIDL1_indelay after IN_DELAY;
        PIPERXVALIDL2_indly <= PIPERXVALIDL2_indelay after IN_DELAY;
        PIPERXVALIDL3_indly <= PIPERXVALIDL3_indelay after IN_DELAY;
        PIPERXVALIDL4_indly <= PIPERXVALIDL4_indelay after IN_DELAY;
        PIPERXVALIDL5_indly <= PIPERXVALIDL5_indelay after IN_DELAY;
        PIPERXVALIDL6_indly <= PIPERXVALIDL6_indelay after IN_DELAY;
        PIPERXVALIDL7_indly <= PIPERXVALIDL7_indelay after IN_DELAY;
        
-- <!--Aldec correction start
	GSR_local <= GSR;
-- Aldec correction end -->
  
	pcie_swift_bw_1 : PCIE_INTERNAL_1_1_SWIFT
	port map (
        MCACTIVELANESIN  =>  ACTIVELANESIN_BINARY,
	MCAERBASEPTR  =>  AERBASEPTR_BINARY,
	MCAERCAPABILITYECRCCHECKCAPABLE  =>  AERCAPABILITYECRCCHECKCAPABLE_BINARY,
	MCAERCAPABILITYECRCGENCAPABLE  =>  AERCAPABILITYECRCGENCAPABLE_BINARY,
	MCAERCAPABILITYNEXTPTR  =>  AERCAPABILITYNEXTPTR_BINARY,
	MCBAR0ADDRWIDTH  =>  BAR0ADDRWIDTH_BINARY,
	MCBAR0EXIST  =>  BAR0EXIST_BINARY,
	MCBAR0IOMEMN  =>  BAR0IOMEMN_BINARY,
	MCBAR0MASKWIDTH  =>  BAR0MASKWIDTH_BINARY,
	MCBAR0PREFETCHABLE  =>  BAR0PREFETCHABLE_BINARY,
	MCBAR1ADDRWIDTH  =>  BAR1ADDRWIDTH_BINARY,
	MCBAR1EXIST  =>  BAR1EXIST_BINARY,
	MCBAR1IOMEMN  =>  BAR1IOMEMN_BINARY,
	MCBAR1MASKWIDTH  =>  BAR1MASKWIDTH_BINARY,
	MCBAR1PREFETCHABLE  =>  BAR1PREFETCHABLE_BINARY,
	MCBAR2ADDRWIDTH  =>  BAR2ADDRWIDTH_BINARY,
	MCBAR2EXIST  =>  BAR2EXIST_BINARY,
	MCBAR2IOMEMN  =>  BAR2IOMEMN_BINARY,
	MCBAR2MASKWIDTH  =>  BAR2MASKWIDTH_BINARY,
	MCBAR2PREFETCHABLE  =>  BAR2PREFETCHABLE_BINARY,
	MCBAR3ADDRWIDTH  =>  BAR3ADDRWIDTH_BINARY,
	MCBAR3EXIST  =>  BAR3EXIST_BINARY,
	MCBAR3IOMEMN  =>  BAR3IOMEMN_BINARY,
	MCBAR3MASKWIDTH  =>  BAR3MASKWIDTH_BINARY,
	MCBAR3PREFETCHABLE  =>  BAR3PREFETCHABLE_BINARY,
	MCBAR4ADDRWIDTH  =>  BAR4ADDRWIDTH_BINARY,
	MCBAR4EXIST  =>  BAR4EXIST_BINARY,
	MCBAR4IOMEMN  =>  BAR4IOMEMN_BINARY,
	MCBAR4MASKWIDTH  =>  BAR4MASKWIDTH_BINARY,
	MCBAR4PREFETCHABLE  =>  BAR4PREFETCHABLE_BINARY,
	MCBAR5ADDRWIDTH  =>  BAR5ADDRWIDTH_BINARY,
	MCBAR5EXIST  =>  BAR5EXIST_BINARY,
	MCBAR5IOMEMN  =>  BAR5IOMEMN_BINARY,
	MCBAR5MASKWIDTH  =>  BAR5MASKWIDTH_BINARY,
	MCBAR5PREFETCHABLE  =>  BAR5PREFETCHABLE_BINARY,
	MCCAPABILITIESPOINTER  =>  CAPABILITIESPOINTER_BINARY,
	MCCARDBUSCISPOINTER  =>  CARDBUSCISPOINTER_BINARY,
	MCCLASSCODE  =>  CLASSCODE_BINARY,
--CLKDIVIDED  =>  CLKDIVIDED_BINARY,
	MCCONFIGROUTING  =>  CONFIGROUTING_BINARY,
	MCDEVICECAPABILITYENDPOINTL0SLATENCY  =>  DEVICECAPABILITYENDPOINTL0SLATENCY_BINARY,
	MCDEVICECAPABILITYENDPOINTL1LATENCY  =>  DEVICECAPABILITYENDPOINTL1LATENCY_BINARY,
	MCDEVICEID  =>  DEVICEID_BINARY,
	MCDEVICESERIALNUMBER  =>  DEVICESERIALNUMBER_BINARY,
	MCDSNBASEPTR  =>  DSNBASEPTR_BINARY,
	MCDSNCAPABILITYNEXTPTR  =>  DSNCAPABILITYNEXTPTR_BINARY,
	MCDUALCOREENABLE  =>  DUALCOREENABLE_BINARY,
	MCDUALCORESLAVE  =>  DUALCORESLAVE_BINARY,
	MCDUALROLECFGCNTRLROOTEPN  =>  DUALROLECFGCNTRLROOTEPN_BINARY,
	MCEXTCFGCAPPTR  =>  EXTCFGCAPPTR_BINARY,
	MCEXTCFGXPCAPPTR  =>  EXTCFGXPCAPPTR_BINARY,
	MCHEADERTYPE  =>  HEADERTYPE_BINARY,
	MCINFINITECOMPLETIONS  =>  INFINITECOMPLETIONS_BINARY,
	MCINTERRUPTPIN  =>  INTERRUPTPIN_BINARY,
	MCISSWITCH  =>  ISSWITCH_BINARY,
	MCL0SEXITLATENCY  =>  L0SEXITLATENCY_BINARY,
	MCL0SEXITLATENCYCOMCLK  =>  L0SEXITLATENCYCOMCLK_BINARY,
	MCL1EXITLATENCY  =>  L1EXITLATENCY_BINARY,
	MCL1EXITLATENCYCOMCLK  =>  L1EXITLATENCYCOMCLK_BINARY,
	MCLINKCAPABILITYASPMSUPPORT  =>  LINKCAPABILITYASPMSUPPORT_BINARY,
	MCLINKCAPABILITYMAXLINKWIDTH  =>  LINKCAPABILITYMAXLINKWIDTH_BINARY,
	MCLINKSTATUSSLOTCLOCKCONFIG  =>  LINKSTATUSSLOTCLOCKCONFIG_BINARY,
	MCLLKBYPASS  =>  LLKBYPASS_BINARY,
	MCLOWPRIORITYVCCOUNT  =>  LOWPRIORITYVCCOUNT_BINARY,
	MCMSIBASEPTR  =>  MSIBASEPTR_BINARY,
	MCMSICAPABILITYMULTIMSGCAP  =>  MSICAPABILITYMULTIMSGCAP_BINARY,
	MCMSICAPABILITYNEXTPTR  =>  MSICAPABILITYNEXTPTR_BINARY,
	MCPBBASEPTR  =>  PBBASEPTR_BINARY,
	MCPBCAPABILITYDW0BASEPOWER  =>  PBCAPABILITYDW0BASEPOWER_BINARY,
	MCPBCAPABILITYDW0DATASCALE  =>  PBCAPABILITYDW0DATASCALE_BINARY,
	MCPBCAPABILITYDW0PMSTATE  =>  PBCAPABILITYDW0PMSTATE_BINARY,
	MCPBCAPABILITYDW0PMSUBSTATE  =>  PBCAPABILITYDW0PMSUBSTATE_BINARY,
	MCPBCAPABILITYDW0POWERRAIL  =>  PBCAPABILITYDW0POWERRAIL_BINARY,
	MCPBCAPABILITYDW0TYPE  =>  PBCAPABILITYDW0TYPE_BINARY,
	MCPBCAPABILITYDW1BASEPOWER  =>  PBCAPABILITYDW1BASEPOWER_BINARY,
	MCPBCAPABILITYDW1DATASCALE  =>  PBCAPABILITYDW1DATASCALE_BINARY,
	MCPBCAPABILITYDW1PMSTATE  =>  PBCAPABILITYDW1PMSTATE_BINARY,
	MCPBCAPABILITYDW1PMSUBSTATE  =>  PBCAPABILITYDW1PMSUBSTATE_BINARY,
	MCPBCAPABILITYDW1POWERRAIL  =>  PBCAPABILITYDW1POWERRAIL_BINARY,
	MCPBCAPABILITYDW1TYPE  =>  PBCAPABILITYDW1TYPE_BINARY,
	MCPBCAPABILITYDW2BASEPOWER  =>  PBCAPABILITYDW2BASEPOWER_BINARY,
	MCPBCAPABILITYDW2DATASCALE  =>  PBCAPABILITYDW2DATASCALE_BINARY,
	MCPBCAPABILITYDW2PMSTATE  =>  PBCAPABILITYDW2PMSTATE_BINARY,
	MCPBCAPABILITYDW2PMSUBSTATE  =>  PBCAPABILITYDW2PMSUBSTATE_BINARY,
	MCPBCAPABILITYDW2POWERRAIL  =>  PBCAPABILITYDW2POWERRAIL_BINARY,
	MCPBCAPABILITYDW2TYPE  =>  PBCAPABILITYDW2TYPE_BINARY,
	MCPBCAPABILITYDW3BASEPOWER  =>  PBCAPABILITYDW3BASEPOWER_BINARY,
	MCPBCAPABILITYDW3DATASCALE  =>  PBCAPABILITYDW3DATASCALE_BINARY,
	MCPBCAPABILITYDW3PMSTATE  =>  PBCAPABILITYDW3PMSTATE_BINARY,
	MCPBCAPABILITYDW3PMSUBSTATE  =>  PBCAPABILITYDW3PMSUBSTATE_BINARY,
	MCPBCAPABILITYDW3POWERRAIL  =>  PBCAPABILITYDW3POWERRAIL_BINARY,
	MCPBCAPABILITYDW3TYPE  =>  PBCAPABILITYDW3TYPE_BINARY,
	MCPBCAPABILITYNEXTPTR  =>  PBCAPABILITYNEXTPTR_BINARY,
	MCPBCAPABILITYSYSTEMALLOCATED  =>  PBCAPABILITYSYSTEMALLOCATED_BINARY,
	MCPCIECAPABILITYINTMSGNUM  =>  PCIECAPABILITYINTMSGNUM_BINARY,
	MCPCIECAPABILITYNEXTPTR  =>  PCIECAPABILITYNEXTPTR_BINARY,
	MCPCIECAPABILITYSLOTIMPL  =>  PCIECAPABILITYSLOTIMPL_BINARY,
	MCPCIEREVISION  =>  PCIEREVISION_BINARY,
	MCPMBASEPTR  =>  PMBASEPTR_BINARY,
	MCPMCAPABILITYAUXCURRENT  =>  PMCAPABILITYAUXCURRENT_BINARY,
	MCPMCAPABILITYD1SUPPORT  =>  PMCAPABILITYD1SUPPORT_BINARY,
	MCPMCAPABILITYD2SUPPORT  =>  PMCAPABILITYD2SUPPORT_BINARY,
	MCPMCAPABILITYDSI  =>  PMCAPABILITYDSI_BINARY,
	MCPMCAPABILITYNEXTPTR  =>  PMCAPABILITYNEXTPTR_BINARY,
	MCPMCAPABILITYPMESUPPORT  =>  PMCAPABILITYPMESUPPORT_BINARY,
	MCPMDATA0  =>  PMDATA0_BINARY,
	MCPMDATA1  =>  PMDATA1_BINARY,
	MCPMDATA2  =>  PMDATA2_BINARY,
	MCPMDATA3  =>  PMDATA3_BINARY,
	MCPMDATA4  =>  PMDATA4_BINARY,
	MCPMDATA5  =>  PMDATA5_BINARY,
	MCPMDATA6  =>  PMDATA6_BINARY,
	MCPMDATA7  =>  PMDATA7_BINARY,
	MCPMDATA8  =>  PMDATA8_BINARY,
	MCPMDATASCALE0  =>  PMDATASCALE0_BINARY,
	MCPMDATASCALE1  =>  PMDATASCALE1_BINARY,
	MCPMDATASCALE2  =>  PMDATASCALE2_BINARY,
	MCPMDATASCALE3  =>  PMDATASCALE3_BINARY,
	MCPMDATASCALE4  =>  PMDATASCALE4_BINARY,
	MCPMDATASCALE5  =>  PMDATASCALE5_BINARY,
	MCPMDATASCALE6  =>  PMDATASCALE6_BINARY,
	MCPMDATASCALE7  =>  PMDATASCALE7_BINARY,
	MCPMDATASCALE8  =>  PMDATASCALE8_BINARY,
	MCPMSTATUSCONTROLDATASCALE  =>  PMSTATUSCONTROLDATASCALE_BINARY,
	MCPORTVCCAPABILITYEXTENDEDVCCOUNT  =>  PORTVCCAPABILITYEXTENDEDVCCOUNT_BINARY,
	MCPORTVCCAPABILITYVCARBCAP  =>  PORTVCCAPABILITYVCARBCAP_BINARY,
	MCPORTVCCAPABILITYVCARBTABLEOFFSET  =>  PORTVCCAPABILITYVCARBTABLEOFFSET_BINARY,
	MCRAMSHARETXRX  =>  RAMSHARETXRX_BINARY,
	MCRESETMODE  =>  RESETMODE_BINARY,
	MCRETRYRAMREADLATENCY  =>  RETRYRAMREADLATENCY_BINARY,
	MCRETRYRAMSIZE  =>  RETRYRAMSIZE_BINARY,
	MCRETRYRAMWIDTH  =>  RETRYRAMWIDTH_BINARY,
	MCRETRYRAMWRITELATENCY  =>  RETRYRAMWRITELATENCY_BINARY,
	MCRETRYREADADDRPIPE  =>  RETRYREADADDRPIPE_BINARY,
	MCRETRYREADDATAPIPE  =>  RETRYREADDATAPIPE_BINARY,
	MCRETRYWRITEPIPE  =>  RETRYWRITEPIPE_BINARY,
	MCREVISIONID  =>  REVISIONID_BINARY,
	MCRXREADADDRPIPE  =>  RXREADADDRPIPE_BINARY,
	MCRXREADDATAPIPE  =>  RXREADDATAPIPE_BINARY,
	MCRXWRITEPIPE  =>  RXWRITEPIPE_BINARY,
	MCSELECTASMODE  =>  SELECTASMODE_BINARY,
	MCSELECTDLLIF  =>  SELECTDLLIF_BINARY,
	MCSLOTCAPABILITYATTBUTTONPRESENT  =>  SLOTCAPABILITYATTBUTTONPRESENT_BINARY,
	MCSLOTCAPABILITYATTINDICATORPRESENT  =>  SLOTCAPABILITYATTINDICATORPRESENT_BINARY,
	MCSLOTCAPABILITYHOTPLUGCAPABLE  =>  SLOTCAPABILITYHOTPLUGCAPABLE_BINARY,
	MCSLOTCAPABILITYHOTPLUGSURPRISE  =>  SLOTCAPABILITYHOTPLUGSURPRISE_BINARY,
	MCSLOTCAPABILITYMSLSENSORPRESENT  =>  SLOTCAPABILITYMSLSENSORPRESENT_BINARY,
	MCSLOTCAPABILITYPHYSICALSLOTNUM  =>  SLOTCAPABILITYPHYSICALSLOTNUM_BINARY,
	MCSLOTCAPABILITYPOWERCONTROLLERPRESENT  =>  SLOTCAPABILITYPOWERCONTROLLERPRESENT_BINARY,
	MCSLOTCAPABILITYPOWERINDICATORPRESENT  =>  SLOTCAPABILITYPOWERINDICATORPRESENT_BINARY,
	MCSLOTCAPABILITYSLOTPOWERLIMITSCALE  =>  SLOTCAPABILITYSLOTPOWERLIMITSCALE_BINARY,
	MCSLOTCAPABILITYSLOTPOWERLIMITVALUE  =>  SLOTCAPABILITYSLOTPOWERLIMITVALUE_BINARY,
	MCSLOTIMPLEMENTED  =>  SLOTIMPLEMENTED_BINARY,
	MCSUBSYSTEMID  =>  SUBSYSTEMID_BINARY,
	MCSUBSYSTEMVENDORID  =>  SUBSYSTEMVENDORID_BINARY,
	MCTLRAMREADLATENCY  =>  TLRAMREADLATENCY_BINARY,
	MCTLRAMWIDTH  =>  TLRAMWIDTH_BINARY,
	MCTLRAMWRITELATENCY  =>  TLRAMWRITELATENCY_BINARY,
	MCTXREADADDRPIPE  =>  TXREADADDRPIPE_BINARY,
	MCTXREADDATAPIPE  =>  TXREADDATAPIPE_BINARY,
	MCTXTSNFTS  =>  TXTSNFTS_BINARY,
	MCTXTSNFTSCOMCLK  =>  TXTSNFTSCOMCLK_BINARY,
	MCTXWRITEPIPE  =>  TXWRITEPIPE_BINARY,
	MCUPSTREAMFACING  =>  UPSTREAMFACING_BINARY,
	MCVC0RXFIFOBASEC  =>  VC0RXFIFOBASEC_BINARY,
	MCVC0RXFIFOBASENP  =>  VC0RXFIFOBASENP_BINARY,
	MCVC0RXFIFOBASEP  =>  VC0RXFIFOBASEP_BINARY,
	MCVC0RXFIFOLIMITC  =>  VC0RXFIFOLIMITC_BINARY,
	MCVC0RXFIFOLIMITNP  =>  VC0RXFIFOLIMITNP_BINARY,
	MCVC0RXFIFOLIMITP  =>  VC0RXFIFOLIMITP_BINARY,
	MCVC0TOTALCREDITSCD  =>  VC0TOTALCREDITSCD_BINARY,
	MCVC0TOTALCREDITSCH  =>  VC0TOTALCREDITSCH_BINARY,
	MCVC0TOTALCREDITSNPH  =>  VC0TOTALCREDITSNPH_BINARY,
	MCVC0TOTALCREDITSPD  =>  VC0TOTALCREDITSPD_BINARY,
	MCVC0TOTALCREDITSPH  =>  VC0TOTALCREDITSPH_BINARY,
	MCVC0TXFIFOBASEC  =>  VC0TXFIFOBASEC_BINARY,
	MCVC0TXFIFOBASENP  =>  VC0TXFIFOBASENP_BINARY,
	MCVC0TXFIFOBASEP  =>  VC0TXFIFOBASEP_BINARY,
	MCVC0TXFIFOLIMITC  =>  VC0TXFIFOLIMITC_BINARY,
	MCVC0TXFIFOLIMITNP  =>  VC0TXFIFOLIMITNP_BINARY,
	MCVC0TXFIFOLIMITP  =>  VC0TXFIFOLIMITP_BINARY,
	MCVC1RXFIFOBASEC  =>  VC1RXFIFOBASEC_BINARY,
	MCVC1RXFIFOBASENP  =>  VC1RXFIFOBASENP_BINARY,
	MCVC1RXFIFOBASEP  =>  VC1RXFIFOBASEP_BINARY,
	MCVC1RXFIFOLIMITC  =>  VC1RXFIFOLIMITC_BINARY,
	MCVC1RXFIFOLIMITNP  =>  VC1RXFIFOLIMITNP_BINARY,
	MCVC1RXFIFOLIMITP  =>  VC1RXFIFOLIMITP_BINARY,
	MCVC1TOTALCREDITSCD  =>  VC1TOTALCREDITSCD_BINARY,
	MCVC1TOTALCREDITSCH  =>  VC1TOTALCREDITSCH_BINARY,
	MCVC1TOTALCREDITSNPH  =>  VC1TOTALCREDITSNPH_BINARY,
	MCVC1TOTALCREDITSPD  =>  VC1TOTALCREDITSPD_BINARY,
	MCVC1TOTALCREDITSPH  =>  VC1TOTALCREDITSPH_BINARY,
	MCVC1TXFIFOBASEC  =>  VC1TXFIFOBASEC_BINARY,
	MCVC1TXFIFOBASENP  =>  VC1TXFIFOBASENP_BINARY,
	MCVC1TXFIFOBASEP  =>  VC1TXFIFOBASEP_BINARY,
	MCVC1TXFIFOLIMITC  =>  VC1TXFIFOLIMITC_BINARY,
	MCVC1TXFIFOLIMITNP  =>  VC1TXFIFOLIMITNP_BINARY,
	MCVC1TXFIFOLIMITP  =>  VC1TXFIFOLIMITP_BINARY,
	MCVCBASEPTR  =>  VCBASEPTR_BINARY,
	MCVCCAPABILITYNEXTPTR  =>  VCCAPABILITYNEXTPTR_BINARY,
	MCVENDORID  =>  VENDORID_BINARY,
	MCXLINKSUPPORTED  =>  XLINKSUPPORTED_BINARY,
	MCXPBASEPTR  =>  XPBASEPTR_BINARY,
	MCXPDEVICEPORTTYPE  =>  XPDEVICEPORTTYPE_BINARY,
	MCXPMAXPAYLOAD  =>  XPMAXPAYLOAD_BINARY,
	MCXPRCBCONTROL  =>  XPRCBCONTROL_BINARY,

       	BUSMASTERENABLE  =>  BUSMASTERENABLE_outdelay,
	CRMDOHOTRESETN  =>  CRMDOHOTRESETN_outdelay,
	CRMPWRSOFTRESETN  =>  CRMPWRSOFTRESETN_outdelay,
	CRMRXHOTRESETN  =>  CRMRXHOTRESETN_outdelay,
	DLLTXPMDLLPOUTSTANDING  =>  DLLTXPMDLLPOUTSTANDING_outdelay,
	INTERRUPTDISABLE  =>  INTERRUPTDISABLE_outdelay,
	IOSPACEENABLE  =>  IOSPACEENABLE_outdelay,
	L0ASAUTONOMOUSINITCOMPLETED  =>  L0ASAUTONOMOUSINITCOMPLETED_outdelay,
	L0ATTENTIONINDICATORCONTROL  =>  L0ATTENTIONINDICATORCONTROL_outdelay,
	L0CFGLOOPBACKACK  =>  L0CFGLOOPBACKACK_outdelay,
	L0COMPLETERID  =>  L0COMPLETERID_outdelay,
	L0CORRERRMSGRCVD  =>  L0CORRERRMSGRCVD_outdelay,
	L0DLLASRXSTATE  =>  L0DLLASRXSTATE_outdelay,
	L0DLLASTXSTATE  =>  L0DLLASTXSTATE_outdelay,
	L0DLLERRORVECTOR  =>  L0DLLERRORVECTOR_outdelay,
	L0DLLRXACKOUTSTANDING  =>  L0DLLRXACKOUTSTANDING_outdelay,
	L0DLLTXNONFCOUTSTANDING  =>  L0DLLTXNONFCOUTSTANDING_outdelay,
	L0DLLTXOUTSTANDING  =>  L0DLLTXOUTSTANDING_outdelay,
	L0DLLVCSTATUS  =>  L0DLLVCSTATUS_outdelay,
	L0DLUPDOWN  =>  L0DLUPDOWN_outdelay,
	L0ERRMSGREQID  =>  L0ERRMSGREQID_outdelay,
	L0FATALERRMSGRCVD  =>  L0FATALERRMSGRCVD_outdelay,
	L0FIRSTCFGWRITEOCCURRED  =>  L0FIRSTCFGWRITEOCCURRED_outdelay,
	L0FWDCORRERROUT  =>  L0FWDCORRERROUT_outdelay,
	L0FWDFATALERROUT  =>  L0FWDFATALERROUT_outdelay,
	L0FWDNONFATALERROUT  =>  L0FWDNONFATALERROUT_outdelay,
	L0LTSSMSTATE  =>  L0LTSSMSTATE_outdelay,
	L0MACENTEREDL0  =>  L0MACENTEREDL0_outdelay,
	L0MACLINKTRAINING  =>  L0MACLINKTRAINING_outdelay,
	L0MACLINKUP  =>  L0MACLINKUP_outdelay,
	L0MACNEGOTIATEDLINKWIDTH  =>  L0MACNEGOTIATEDLINKWIDTH_outdelay,
	L0MACNEWSTATEACK  =>  L0MACNEWSTATEACK_outdelay,
	L0MACRXL0SSTATE  =>  L0MACRXL0SSTATE_outdelay,
	L0MACUPSTREAMDOWNSTREAM  =>  L0MACUPSTREAMDOWNSTREAM_outdelay,
	L0MCFOUND  =>  L0MCFOUND_outdelay,
	L0MSIENABLE0  =>  L0MSIENABLE0_outdelay,
	L0MULTIMSGEN0  =>  L0MULTIMSGEN0_outdelay,
	L0NONFATALERRMSGRCVD  =>  L0NONFATALERRMSGRCVD_outdelay,
	L0PMEACK  =>  L0PMEACK_outdelay,
	L0PMEEN  =>  L0PMEEN_outdelay,
	L0PMEREQOUT  =>  L0PMEREQOUT_outdelay,
	L0POWERCONTROLLERCONTROL  =>  L0POWERCONTROLLERCONTROL_outdelay,
	L0POWERINDICATORCONTROL  =>  L0POWERINDICATORCONTROL_outdelay,
	L0PWRINHIBITTRANSFERS  =>  L0PWRINHIBITTRANSFERS_outdelay,
	L0PWRL1STATE  =>  L0PWRL1STATE_outdelay,
	L0PWRL23READYDEVICE  =>  L0PWRL23READYDEVICE_outdelay,
	L0PWRL23READYSTATE  =>  L0PWRL23READYSTATE_outdelay,
	L0PWRSTATE0  =>  L0PWRSTATE0_outdelay,
	L0PWRTURNOFFREQ  =>  L0PWRTURNOFFREQ_outdelay,
	L0PWRTXL0SSTATE  =>  L0PWRTXL0SSTATE_outdelay,
	L0RECEIVEDASSERTINTALEGACYINT  =>  L0RECEIVEDASSERTINTALEGACYINT_outdelay,
	L0RECEIVEDASSERTINTBLEGACYINT  =>  L0RECEIVEDASSERTINTBLEGACYINT_outdelay,
	L0RECEIVEDASSERTINTCLEGACYINT  =>  L0RECEIVEDASSERTINTCLEGACYINT_outdelay,
	L0RECEIVEDASSERTINTDLEGACYINT  =>  L0RECEIVEDASSERTINTDLEGACYINT_outdelay,
	L0RECEIVEDDEASSERTINTALEGACYINT  =>  L0RECEIVEDDEASSERTINTALEGACYINT_outdelay,
	L0RECEIVEDDEASSERTINTBLEGACYINT  =>  L0RECEIVEDDEASSERTINTBLEGACYINT_outdelay,
	L0RECEIVEDDEASSERTINTCLEGACYINT  =>  L0RECEIVEDDEASSERTINTCLEGACYINT_outdelay,
	L0RECEIVEDDEASSERTINTDLEGACYINT  =>  L0RECEIVEDDEASSERTINTDLEGACYINT_outdelay,
	L0RXBEACON  =>  L0RXBEACON_outdelay,
	L0RXDLLFCCMPLMCCRED  =>  L0RXDLLFCCMPLMCCRED_outdelay,
	L0RXDLLFCCMPLMCUPDATE  =>  L0RXDLLFCCMPLMCUPDATE_outdelay,
	L0RXDLLFCNPOSTBYPCRED  =>  L0RXDLLFCNPOSTBYPCRED_outdelay,
	L0RXDLLFCNPOSTBYPUPDATE  =>  L0RXDLLFCNPOSTBYPUPDATE_outdelay,
	L0RXDLLFCPOSTORDCRED  =>  L0RXDLLFCPOSTORDCRED_outdelay,
	L0RXDLLFCPOSTORDUPDATE  =>  L0RXDLLFCPOSTORDUPDATE_outdelay,
	L0RXDLLPM  =>  L0RXDLLPM_outdelay,
	L0RXDLLPMTYPE  =>  L0RXDLLPMTYPE_outdelay,
	L0RXDLLSBFCDATA  =>  L0RXDLLSBFCDATA_outdelay,
	L0RXDLLSBFCUPDATE  =>  L0RXDLLSBFCUPDATE_outdelay,
	L0RXDLLTLPECRCOK  =>  L0RXDLLTLPECRCOK_outdelay,
	L0RXDLLTLPEND  =>  L0RXDLLTLPEND_outdelay,
	L0RXMACLINKERROR  =>  L0RXMACLINKERROR_outdelay,
	L0STATSCFGOTHERRECEIVED  =>  L0STATSCFGOTHERRECEIVED_outdelay,
	L0STATSCFGOTHERTRANSMITTED  =>  L0STATSCFGOTHERTRANSMITTED_outdelay,
	L0STATSCFGRECEIVED  =>  L0STATSCFGRECEIVED_outdelay,
	L0STATSCFGTRANSMITTED  =>  L0STATSCFGTRANSMITTED_outdelay,
	L0STATSDLLPRECEIVED  =>  L0STATSDLLPRECEIVED_outdelay,
	L0STATSDLLPTRANSMITTED  =>  L0STATSDLLPTRANSMITTED_outdelay,
	L0STATSOSRECEIVED  =>  L0STATSOSRECEIVED_outdelay,
	L0STATSOSTRANSMITTED  =>  L0STATSOSTRANSMITTED_outdelay,
	L0STATSTLPRECEIVED  =>  L0STATSTLPRECEIVED_outdelay,
	L0STATSTLPTRANSMITTED  =>  L0STATSTLPTRANSMITTED_outdelay,
	L0TOGGLEELECTROMECHANICALINTERLOCK  =>  L0TOGGLEELECTROMECHANICALINTERLOCK_outdelay,
	L0TRANSFORMEDVC  =>  L0TRANSFORMEDVC_outdelay,
	L0TXDLLFCCMPLMCUPDATED  =>  L0TXDLLFCCMPLMCUPDATED_outdelay,
	L0TXDLLFCNPOSTBYPUPDATED  =>  L0TXDLLFCNPOSTBYPUPDATED_outdelay,
	L0TXDLLFCPOSTORDUPDATED  =>  L0TXDLLFCPOSTORDUPDATED_outdelay,
	L0TXDLLPMUPDATED  =>  L0TXDLLPMUPDATED_outdelay,
	L0TXDLLSBFCUPDATED  =>  L0TXDLLSBFCUPDATED_outdelay,
	L0UCBYPFOUND  =>  L0UCBYPFOUND_outdelay,
	L0UCORDFOUND  =>  L0UCORDFOUND_outdelay,
	L0UNLOCKRECEIVED  =>  L0UNLOCKRECEIVED_outdelay,
	LLKRX4DWHEADERN  =>  LLKRX4DWHEADERN_outdelay,
	LLKRXCHCOMPLETIONAVAILABLEN  =>  LLKRXCHCOMPLETIONAVAILABLEN_outdelay,
	LLKRXCHCOMPLETIONPARTIALN  =>  LLKRXCHCOMPLETIONPARTIALN_outdelay,
	LLKRXCHCONFIGAVAILABLEN  =>  LLKRXCHCONFIGAVAILABLEN_outdelay,
	LLKRXCHCONFIGPARTIALN  =>  LLKRXCHCONFIGPARTIALN_outdelay,
	LLKRXCHNONPOSTEDAVAILABLEN  =>  LLKRXCHNONPOSTEDAVAILABLEN_outdelay,
	LLKRXCHNONPOSTEDPARTIALN  =>  LLKRXCHNONPOSTEDPARTIALN_outdelay,
	LLKRXCHPOSTEDAVAILABLEN  =>  LLKRXCHPOSTEDAVAILABLEN_outdelay,
	LLKRXCHPOSTEDPARTIALN  =>  LLKRXCHPOSTEDPARTIALN_outdelay,
	LLKRXDATA  =>  LLKRXDATA_outdelay,
	LLKRXECRCBADN  =>  LLKRXECRCBADN_outdelay,
	LLKRXEOFN  =>  LLKRXEOFN_outdelay,
	LLKRXEOPN  =>  LLKRXEOPN_outdelay,
	LLKRXPREFERREDTYPE  =>  LLKRXPREFERREDTYPE_outdelay,
	LLKRXSOFN  =>  LLKRXSOFN_outdelay,
	LLKRXSOPN  =>  LLKRXSOPN_outdelay,
	LLKRXSRCDSCN  =>  LLKRXSRCDSCN_outdelay,
	LLKRXSRCLASTREQN  =>  LLKRXSRCLASTREQN_outdelay,
	LLKRXSRCRDYN  =>  LLKRXSRCRDYN_outdelay,
	LLKRXVALIDN  =>  LLKRXVALIDN_outdelay,
	LLKTCSTATUS  =>  LLKTCSTATUS_outdelay,
	LLKTXCHANSPACE  =>  LLKTXCHANSPACE_outdelay,
	LLKTXCHCOMPLETIONREADYN  =>  LLKTXCHCOMPLETIONREADYN_outdelay,
	LLKTXCHNONPOSTEDREADYN  =>  LLKTXCHNONPOSTEDREADYN_outdelay,
	LLKTXCHPOSTEDREADYN  =>  LLKTXCHPOSTEDREADYN_outdelay,
	LLKTXCONFIGREADYN  =>  LLKTXCONFIGREADYN_outdelay,
	LLKTXDSTRDYN  =>  LLKTXDSTRDYN_outdelay,
	MAXPAYLOADSIZE  =>  MAXPAYLOADSIZE_outdelay,
	MAXREADREQUESTSIZE  =>  MAXREADREQUESTSIZE_outdelay,
	MEMSPACEENABLE  =>  MEMSPACEENABLE_outdelay,
	MGMTPSO  =>  MGMTPSO_outdelay,
	MGMTRDATA  =>  MGMTRDATA_outdelay,
	MGMTSTATSCREDIT  =>  MGMTSTATSCREDIT_outdelay,
	MIMDLLBRADD  =>  MIMDLLBRADD_outdelay,
	MIMDLLBREN  =>  MIMDLLBREN_outdelay,
	MIMDLLBWADD  =>  MIMDLLBWADD_outdelay,
	MIMDLLBWDATA  =>  MIMDLLBWDATA_outdelay,
	MIMDLLBWEN  =>  MIMDLLBWEN_outdelay,
	MIMRXBRADD  =>  MIMRXBRADD_outdelay,
	MIMRXBREN  =>  MIMRXBREN_outdelay,
	MIMRXBWADD  =>  MIMRXBWADD_outdelay,
	MIMRXBWDATA  =>  MIMRXBWDATA_outdelay,
	MIMRXBWEN  =>  MIMRXBWEN_outdelay,
	MIMTXBRADD  =>  MIMTXBRADD_outdelay,
	MIMTXBREN  =>  MIMTXBREN_outdelay,
	MIMTXBWADD  =>  MIMTXBWADD_outdelay,
	MIMTXBWDATA  =>  MIMTXBWDATA_outdelay,
	MIMTXBWEN  =>  MIMTXBWEN_outdelay,
	PARITYERRORRESPONSE  =>  PARITYERRORRESPONSE_outdelay,
	PIPEDESKEWLANESL0  =>  PIPEDESKEWLANESL0_outdelay,
	PIPEDESKEWLANESL1  =>  PIPEDESKEWLANESL1_outdelay,
	PIPEDESKEWLANESL2  =>  PIPEDESKEWLANESL2_outdelay,
	PIPEDESKEWLANESL3  =>  PIPEDESKEWLANESL3_outdelay,
	PIPEDESKEWLANESL4  =>  PIPEDESKEWLANESL4_outdelay,
	PIPEDESKEWLANESL5  =>  PIPEDESKEWLANESL5_outdelay,
	PIPEDESKEWLANESL6  =>  PIPEDESKEWLANESL6_outdelay,
	PIPEDESKEWLANESL7  =>  PIPEDESKEWLANESL7_outdelay,
	PIPEPOWERDOWNL0  =>  PIPEPOWERDOWNL0_outdelay,
	PIPEPOWERDOWNL1  =>  PIPEPOWERDOWNL1_outdelay,
	PIPEPOWERDOWNL2  =>  PIPEPOWERDOWNL2_outdelay,
	PIPEPOWERDOWNL3  =>  PIPEPOWERDOWNL3_outdelay,
	PIPEPOWERDOWNL4  =>  PIPEPOWERDOWNL4_outdelay,
	PIPEPOWERDOWNL5  =>  PIPEPOWERDOWNL5_outdelay,
	PIPEPOWERDOWNL6  =>  PIPEPOWERDOWNL6_outdelay,
	PIPEPOWERDOWNL7  =>  PIPEPOWERDOWNL7_outdelay,
	PIPERESETL0  =>  PIPERESETL0_outdelay,
	PIPERESETL1  =>  PIPERESETL1_outdelay,
	PIPERESETL2  =>  PIPERESETL2_outdelay,
	PIPERESETL3  =>  PIPERESETL3_outdelay,
	PIPERESETL4  =>  PIPERESETL4_outdelay,
	PIPERESETL5  =>  PIPERESETL5_outdelay,
	PIPERESETL6  =>  PIPERESETL6_outdelay,
	PIPERESETL7  =>  PIPERESETL7_outdelay,
	PIPERXPOLARITYL0  =>  PIPERXPOLARITYL0_outdelay,
	PIPERXPOLARITYL1  =>  PIPERXPOLARITYL1_outdelay,
	PIPERXPOLARITYL2  =>  PIPERXPOLARITYL2_outdelay,
	PIPERXPOLARITYL3  =>  PIPERXPOLARITYL3_outdelay,
	PIPERXPOLARITYL4  =>  PIPERXPOLARITYL4_outdelay,
	PIPERXPOLARITYL5  =>  PIPERXPOLARITYL5_outdelay,
	PIPERXPOLARITYL6  =>  PIPERXPOLARITYL6_outdelay,
	PIPERXPOLARITYL7  =>  PIPERXPOLARITYL7_outdelay,
	PIPETXCOMPLIANCEL0  =>  PIPETXCOMPLIANCEL0_outdelay,
	PIPETXCOMPLIANCEL1  =>  PIPETXCOMPLIANCEL1_outdelay,
	PIPETXCOMPLIANCEL2  =>  PIPETXCOMPLIANCEL2_outdelay,
	PIPETXCOMPLIANCEL3  =>  PIPETXCOMPLIANCEL3_outdelay,
	PIPETXCOMPLIANCEL4  =>  PIPETXCOMPLIANCEL4_outdelay,
	PIPETXCOMPLIANCEL5  =>  PIPETXCOMPLIANCEL5_outdelay,
	PIPETXCOMPLIANCEL6  =>  PIPETXCOMPLIANCEL6_outdelay,
	PIPETXCOMPLIANCEL7  =>  PIPETXCOMPLIANCEL7_outdelay,
	PIPETXDATAKL0  =>  PIPETXDATAKL0_outdelay,
	PIPETXDATAKL1  =>  PIPETXDATAKL1_outdelay,
	PIPETXDATAKL2  =>  PIPETXDATAKL2_outdelay,
	PIPETXDATAKL3  =>  PIPETXDATAKL3_outdelay,
	PIPETXDATAKL4  =>  PIPETXDATAKL4_outdelay,
	PIPETXDATAKL5  =>  PIPETXDATAKL5_outdelay,
	PIPETXDATAKL6  =>  PIPETXDATAKL6_outdelay,
	PIPETXDATAKL7  =>  PIPETXDATAKL7_outdelay,
	PIPETXDATAL0  =>  PIPETXDATAL0_outdelay,
	PIPETXDATAL1  =>  PIPETXDATAL1_outdelay,
	PIPETXDATAL2  =>  PIPETXDATAL2_outdelay,
	PIPETXDATAL3  =>  PIPETXDATAL3_outdelay,
	PIPETXDATAL4  =>  PIPETXDATAL4_outdelay,
	PIPETXDATAL5  =>  PIPETXDATAL5_outdelay,
	PIPETXDATAL6  =>  PIPETXDATAL6_outdelay,
	PIPETXDATAL7  =>  PIPETXDATAL7_outdelay,
	PIPETXDETECTRXLOOPBACKL0  =>  PIPETXDETECTRXLOOPBACKL0_outdelay,
	PIPETXDETECTRXLOOPBACKL1  =>  PIPETXDETECTRXLOOPBACKL1_outdelay,
	PIPETXDETECTRXLOOPBACKL2  =>  PIPETXDETECTRXLOOPBACKL2_outdelay,
	PIPETXDETECTRXLOOPBACKL3  =>  PIPETXDETECTRXLOOPBACKL3_outdelay,
	PIPETXDETECTRXLOOPBACKL4  =>  PIPETXDETECTRXLOOPBACKL4_outdelay,
	PIPETXDETECTRXLOOPBACKL5  =>  PIPETXDETECTRXLOOPBACKL5_outdelay,
	PIPETXDETECTRXLOOPBACKL6  =>  PIPETXDETECTRXLOOPBACKL6_outdelay,
	PIPETXDETECTRXLOOPBACKL7  =>  PIPETXDETECTRXLOOPBACKL7_outdelay,
	PIPETXELECIDLEL0  =>  PIPETXELECIDLEL0_outdelay,
	PIPETXELECIDLEL1  =>  PIPETXELECIDLEL1_outdelay,
	PIPETXELECIDLEL2  =>  PIPETXELECIDLEL2_outdelay,
	PIPETXELECIDLEL3  =>  PIPETXELECIDLEL3_outdelay,
	PIPETXELECIDLEL4  =>  PIPETXELECIDLEL4_outdelay,
	PIPETXELECIDLEL5  =>  PIPETXELECIDLEL5_outdelay,
	PIPETXELECIDLEL6  =>  PIPETXELECIDLEL6_outdelay,
	PIPETXELECIDLEL7  =>  PIPETXELECIDLEL7_outdelay,
	SERRENABLE  =>  SERRENABLE_outdelay,
	URREPORTINGENABLE  =>  URREPORTINGENABLE_outdelay,
	AUXPOWER  =>  AUXPOWER_indly,
	CFGNEGOTIATEDLINKWIDTH  =>  CFGNEGOTIATEDLINKWIDTH_indly,
	COMPLIANCEAVOID  =>  COMPLIANCEAVOID_indly,
	CRMCFGBRIDGEHOTRESET  =>  CRMCFGBRIDGEHOTRESET_indly,
	CRMCORECLK  =>  CRMCORECLK_indly,
	CRMCORECLKDLO  =>  CRMCORECLKDLO_indly,
	CRMCORECLKRXO  =>  CRMCORECLKRXO_indly,
	CRMCORECLKTXO  =>  CRMCORECLKTXO_indly,
	CRMLINKRSTN  =>  CRMLINKRSTN_indly,
	CRMMACRSTN  =>  CRMMACRSTN_indly,
	CRMMGMTRSTN  =>  CRMMGMTRSTN_indly,
	CRMNVRSTN  =>  CRMNVRSTN_indly,
	CRMTXHOTRESETN  =>  CRMTXHOTRESETN_indly,
	CRMURSTN  =>  CRMURSTN_indly,
	CRMUSERCFGRSTN  =>  CRMUSERCFGRSTN_indly,
	CRMUSERCLK  =>  CRMUSERCLK_indly,
	CRMUSERCLKRXO  =>  CRMUSERCLKRXO_indly,
	CRMUSERCLKTXO  =>  CRMUSERCLKTXO_indly,
	CROSSLINKSEED  =>  CROSSLINKSEED_indly,
-- <!--Aldec correction start        
        	GSR => GSR_local,
-- Aldec correction end --> 
	L0ACKNAKTIMERADJUSTMENT  =>  L0ACKNAKTIMERADJUSTMENT_indly,
	L0ALLDOWNPORTSINL1  =>  L0ALLDOWNPORTSINL1_indly,
	L0ALLDOWNRXPORTSINL0S  =>  L0ALLDOWNRXPORTSINL0S_indly,
	L0ASE  =>  L0ASE_indly,
	L0ASPORTCOUNT  =>  L0ASPORTCOUNT_indly,
	L0ASTURNPOOLBITSCONSUMED  =>  L0ASTURNPOOLBITSCONSUMED_indly,
	L0ATTENTIONBUTTONPRESSED  =>  L0ATTENTIONBUTTONPRESSED_indly,
	L0CFGASSPANTREEOWNEDSTATE  =>  L0CFGASSPANTREEOWNEDSTATE_indly,
	L0CFGASSTATECHANGECMD  =>  L0CFGASSTATECHANGECMD_indly,
	L0CFGDISABLESCRAMBLE  =>  L0CFGDISABLESCRAMBLE_indly,
	L0CFGEXTENDEDSYNC  =>  L0CFGEXTENDEDSYNC_indly,
	L0CFGL0SENTRYENABLE  =>  L0CFGL0SENTRYENABLE_indly,
	L0CFGL0SENTRYSUP  =>  L0CFGL0SENTRYSUP_indly,
	L0CFGL0SEXITLAT  =>  L0CFGL0SEXITLAT_indly,
	L0CFGLINKDISABLE  =>  L0CFGLINKDISABLE_indly,
	L0CFGLOOPBACKMASTER  =>  L0CFGLOOPBACKMASTER_indly,
	L0CFGNEGOTIATEDMAXP  =>  L0CFGNEGOTIATEDMAXP_indly,
	L0CFGVCENABLE  =>  L0CFGVCENABLE_indly,
	L0CFGVCID  =>  L0CFGVCID_indly,
	L0DLLHOLDLINKUP  =>  L0DLLHOLDLINKUP_indly,
	L0ELECTROMECHANICALINTERLOCKENGAGED  =>  L0ELECTROMECHANICALINTERLOCKENGAGED_indly,
	L0FWDASSERTINTALEGACYINT  =>  L0FWDASSERTINTALEGACYINT_indly,
	L0FWDASSERTINTBLEGACYINT  =>  L0FWDASSERTINTBLEGACYINT_indly,
	L0FWDASSERTINTCLEGACYINT  =>  L0FWDASSERTINTCLEGACYINT_indly,
	L0FWDASSERTINTDLEGACYINT  =>  L0FWDASSERTINTDLEGACYINT_indly,
	L0FWDCORRERRIN  =>  L0FWDCORRERRIN_indly,
	L0FWDDEASSERTINTALEGACYINT  =>  L0FWDDEASSERTINTALEGACYINT_indly,
	L0FWDDEASSERTINTBLEGACYINT  =>  L0FWDDEASSERTINTBLEGACYINT_indly,
	L0FWDDEASSERTINTCLEGACYINT  =>  L0FWDDEASSERTINTCLEGACYINT_indly,
	L0FWDDEASSERTINTDLEGACYINT  =>  L0FWDDEASSERTINTDLEGACYINT_indly,
	L0FWDFATALERRIN  =>  L0FWDFATALERRIN_indly,
	L0FWDNONFATALERRIN  =>  L0FWDNONFATALERRIN_indly,
	L0LEGACYINTFUNCT0  =>  L0LEGACYINTFUNCT0_indly,
	L0MRLSENSORCLOSEDN  =>  L0MRLSENSORCLOSEDN_indly,
	L0MSIREQUEST0  =>  L0MSIREQUEST0_indly,
	L0PACKETHEADERFROMUSER  =>  L0PACKETHEADERFROMUSER_indly,
	L0PMEREQIN  =>  L0PMEREQIN_indly,
	L0PORTNUMBER  =>  L0PORTNUMBER_indly,
	L0POWERFAULTDETECTED  =>  L0POWERFAULTDETECTED_indly,
	L0PRESENCEDETECTSLOTEMPTYN  =>  L0PRESENCEDETECTSLOTEMPTYN_indly,
	L0PWRNEWSTATEREQ  =>  L0PWRNEWSTATEREQ_indly,
	L0PWRNEXTLINKSTATE  =>  L0PWRNEXTLINKSTATE_indly,
	L0REPLAYTIMERADJUSTMENT  =>  L0REPLAYTIMERADJUSTMENT_indly,
	L0ROOTTURNOFFREQ  =>  L0ROOTTURNOFFREQ_indly,
	L0RXTLTLPNONINITIALIZEDVC  =>  L0RXTLTLPNONINITIALIZEDVC_indly,
	L0SENDUNLOCKMESSAGE  =>  L0SENDUNLOCKMESSAGE_indly,
	L0SETCOMPLETERABORTERROR  =>  L0SETCOMPLETERABORTERROR_indly,
	L0SETCOMPLETIONTIMEOUTCORRERROR  =>  L0SETCOMPLETIONTIMEOUTCORRERROR_indly,
	L0SETCOMPLETIONTIMEOUTUNCORRERROR  =>  L0SETCOMPLETIONTIMEOUTUNCORRERROR_indly,
	L0SETDETECTEDCORRERROR  =>  L0SETDETECTEDCORRERROR_indly,
	L0SETDETECTEDFATALERROR  =>  L0SETDETECTEDFATALERROR_indly,
	L0SETDETECTEDNONFATALERROR  =>  L0SETDETECTEDNONFATALERROR_indly,
	L0SETLINKDETECTEDPARITYERROR  =>  L0SETLINKDETECTEDPARITYERROR_indly,
	L0SETLINKMASTERDATAPARITY  =>  L0SETLINKMASTERDATAPARITY_indly,
	L0SETLINKRECEIVEDMASTERABORT  =>  L0SETLINKRECEIVEDMASTERABORT_indly,
	L0SETLINKRECEIVEDTARGETABORT  =>  L0SETLINKRECEIVEDTARGETABORT_indly,
	L0SETLINKSIGNALLEDTARGETABORT  =>  L0SETLINKSIGNALLEDTARGETABORT_indly,
	L0SETLINKSYSTEMERROR  =>  L0SETLINKSYSTEMERROR_indly,
	L0SETUNEXPECTEDCOMPLETIONCORRERROR  =>  L0SETUNEXPECTEDCOMPLETIONCORRERROR_indly,
	L0SETUNEXPECTEDCOMPLETIONUNCORRERROR  =>  L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_indly,
	L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR  =>  L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_indly,
	L0SETUNSUPPORTEDREQUESTOTHERERROR  =>  L0SETUNSUPPORTEDREQUESTOTHERERROR_indly,
	L0SETUSERDETECTEDPARITYERROR  =>  L0SETUSERDETECTEDPARITYERROR_indly,
	L0SETUSERMASTERDATAPARITY  =>  L0SETUSERMASTERDATAPARITY_indly,
	L0SETUSERRECEIVEDMASTERABORT  =>  L0SETUSERRECEIVEDMASTERABORT_indly,
	L0SETUSERRECEIVEDTARGETABORT  =>  L0SETUSERRECEIVEDTARGETABORT_indly,
	L0SETUSERSIGNALLEDTARGETABORT  =>  L0SETUSERSIGNALLEDTARGETABORT_indly,
	L0SETUSERSYSTEMERROR  =>  L0SETUSERSYSTEMERROR_indly,
	L0TLASFCCREDSTARVATION  =>  L0TLASFCCREDSTARVATION_indly,
	L0TLLINKRETRAIN  =>  L0TLLINKRETRAIN_indly,
	L0TRANSACTIONSPENDING  =>  L0TRANSACTIONSPENDING_indly,
	L0TXBEACON  =>  L0TXBEACON_indly,
	L0TXCFGPM  =>  L0TXCFGPM_indly,
	L0TXCFGPMTYPE  =>  L0TXCFGPMTYPE_indly,
	L0TXTLFCCMPLMCCRED  =>  L0TXTLFCCMPLMCCRED_indly,
	L0TXTLFCCMPLMCUPDATE  =>  L0TXTLFCCMPLMCUPDATE_indly,
	L0TXTLFCNPOSTBYPCRED  =>  L0TXTLFCNPOSTBYPCRED_indly,
	L0TXTLFCNPOSTBYPUPDATE  =>  L0TXTLFCNPOSTBYPUPDATE_indly,
	L0TXTLFCPOSTORDCRED  =>  L0TXTLFCPOSTORDCRED_indly,
	L0TXTLFCPOSTORDUPDATE  =>  L0TXTLFCPOSTORDUPDATE_indly,
	L0TXTLSBFCDATA  =>  L0TXTLSBFCDATA_indly,
	L0TXTLSBFCUPDATE  =>  L0TXTLSBFCUPDATE_indly,
	L0TXTLTLPDATA  =>  L0TXTLTLPDATA_indly,
	L0TXTLTLPEDB  =>  L0TXTLTLPEDB_indly,
	L0TXTLTLPENABLE  =>  L0TXTLTLPENABLE_indly,
	L0TXTLTLPEND  =>  L0TXTLTLPEND_indly,
	L0TXTLTLPLATENCY  =>  L0TXTLTLPLATENCY_indly,
	L0TXTLTLPREQ  =>  L0TXTLTLPREQ_indly,
	L0TXTLTLPREQEND  =>  L0TXTLTLPREQEND_indly,
	L0TXTLTLPWIDTH  =>  L0TXTLTLPWIDTH_indly,
	L0UPSTREAMRXPORTINL0S  =>  L0UPSTREAMRXPORTINL0S_indly,
	L0VC0PREVIEWEXPAND  =>  L0VC0PREVIEWEXPAND_indly,
	L0WAKEN  =>  L0WAKEN_indly,
	LLKRXCHFIFO  =>  LLKRXCHFIFO_indly,
	LLKRXCHTC  =>  LLKRXCHTC_indly,
	LLKRXDSTCONTREQN  =>  LLKRXDSTCONTREQN_indly,
	LLKRXDSTREQN  =>  LLKRXDSTREQN_indly,
	LLKTX4DWHEADERN  =>  LLKTX4DWHEADERN_indly,
	LLKTXCHFIFO  =>  LLKTXCHFIFO_indly,
	LLKTXCHTC  =>  LLKTXCHTC_indly,
	LLKTXCOMPLETEN  =>  LLKTXCOMPLETEN_indly,
	LLKTXCREATEECRCN  =>  LLKTXCREATEECRCN_indly,
	LLKTXDATA  =>  LLKTXDATA_indly,
	LLKTXENABLEN  =>  LLKTXENABLEN_indly,
	LLKTXEOFN  =>  LLKTXEOFN_indly,
	LLKTXEOPN  =>  LLKTXEOPN_indly,
	LLKTXSOFN  =>  LLKTXSOFN_indly,
	LLKTXSOPN  =>  LLKTXSOPN_indly,
	LLKTXSRCDSCN  =>  LLKTXSRCDSCN_indly,
	LLKTXSRCRDYN  =>  LLKTXSRCRDYN_indly,
	MAINPOWER  =>  MAINPOWER_indly,
	MGMTADDR  =>  MGMTADDR_indly,
	MGMTBWREN  =>  MGMTBWREN_indly,
	MGMTRDEN  =>  MGMTRDEN_indly,
	MGMTSTATSCREDITSEL  =>  MGMTSTATSCREDITSEL_indly,
	MGMTWDATA  =>  MGMTWDATA_indly,
	MGMTWREN  =>  MGMTWREN_indly,
	MIMDLLBRDATA  =>  MIMDLLBRDATA_indly,
	MIMRXBRDATA  =>  MIMRXBRDATA_indly,
	MIMTXBRDATA  =>  MIMTXBRDATA_indly,
	PIPEPHYSTATUSL0  =>  PIPEPHYSTATUSL0_indly,
	PIPEPHYSTATUSL1  =>  PIPEPHYSTATUSL1_indly,
	PIPEPHYSTATUSL2  =>  PIPEPHYSTATUSL2_indly,
	PIPEPHYSTATUSL3  =>  PIPEPHYSTATUSL3_indly,
	PIPEPHYSTATUSL4  =>  PIPEPHYSTATUSL4_indly,
	PIPEPHYSTATUSL5  =>  PIPEPHYSTATUSL5_indly,
	PIPEPHYSTATUSL6  =>  PIPEPHYSTATUSL6_indly,
	PIPEPHYSTATUSL7  =>  PIPEPHYSTATUSL7_indly,
	PIPERXCHANISALIGNEDL0  =>  PIPERXCHANISALIGNEDL0_indly,
	PIPERXCHANISALIGNEDL1  =>  PIPERXCHANISALIGNEDL1_indly,
	PIPERXCHANISALIGNEDL2  =>  PIPERXCHANISALIGNEDL2_indly,
	PIPERXCHANISALIGNEDL3  =>  PIPERXCHANISALIGNEDL3_indly,
	PIPERXCHANISALIGNEDL4  =>  PIPERXCHANISALIGNEDL4_indly,
	PIPERXCHANISALIGNEDL5  =>  PIPERXCHANISALIGNEDL5_indly,
	PIPERXCHANISALIGNEDL6  =>  PIPERXCHANISALIGNEDL6_indly,
	PIPERXCHANISALIGNEDL7  =>  PIPERXCHANISALIGNEDL7_indly,
	PIPERXDATAKL0  =>  PIPERXDATAKL0_indly,
	PIPERXDATAKL1  =>  PIPERXDATAKL1_indly,
	PIPERXDATAKL2  =>  PIPERXDATAKL2_indly,
	PIPERXDATAKL3  =>  PIPERXDATAKL3_indly,
	PIPERXDATAKL4  =>  PIPERXDATAKL4_indly,
	PIPERXDATAKL5  =>  PIPERXDATAKL5_indly,
	PIPERXDATAKL6  =>  PIPERXDATAKL6_indly,
	PIPERXDATAKL7  =>  PIPERXDATAKL7_indly,
	PIPERXDATAL0  =>  PIPERXDATAL0_indly,
	PIPERXDATAL1  =>  PIPERXDATAL1_indly,
	PIPERXDATAL2  =>  PIPERXDATAL2_indly,
	PIPERXDATAL3  =>  PIPERXDATAL3_indly,
	PIPERXDATAL4  =>  PIPERXDATAL4_indly,
	PIPERXDATAL5  =>  PIPERXDATAL5_indly,
	PIPERXDATAL6  =>  PIPERXDATAL6_indly,
	PIPERXDATAL7  =>  PIPERXDATAL7_indly,
	PIPERXELECIDLEL0  =>  PIPERXELECIDLEL0_indly,
	PIPERXELECIDLEL1  =>  PIPERXELECIDLEL1_indly,
	PIPERXELECIDLEL2  =>  PIPERXELECIDLEL2_indly,
	PIPERXELECIDLEL3  =>  PIPERXELECIDLEL3_indly,
	PIPERXELECIDLEL4  =>  PIPERXELECIDLEL4_indly,
	PIPERXELECIDLEL5  =>  PIPERXELECIDLEL5_indly,
	PIPERXELECIDLEL6  =>  PIPERXELECIDLEL6_indly,
	PIPERXELECIDLEL7  =>  PIPERXELECIDLEL7_indly,
	PIPERXSTATUSL0  =>  PIPERXSTATUSL0_indly,
	PIPERXSTATUSL1  =>  PIPERXSTATUSL1_indly,
	PIPERXSTATUSL2  =>  PIPERXSTATUSL2_indly,
	PIPERXSTATUSL3  =>  PIPERXSTATUSL3_indly,
	PIPERXSTATUSL4  =>  PIPERXSTATUSL4_indly,
	PIPERXSTATUSL5  =>  PIPERXSTATUSL5_indly,
	PIPERXSTATUSL6  =>  PIPERXSTATUSL6_indly,
	PIPERXSTATUSL7  =>  PIPERXSTATUSL7_indly,
	PIPERXVALIDL0  =>  PIPERXVALIDL0_indly,
	PIPERXVALIDL1  =>  PIPERXVALIDL1_indly,
	PIPERXVALIDL2  =>  PIPERXVALIDL2_indly,
	PIPERXVALIDL3  =>  PIPERXVALIDL3_indly,
	PIPERXVALIDL4  =>  PIPERXVALIDL4_indly,
	PIPERXVALIDL5  =>  PIPERXVALIDL5_indly,
	PIPERXVALIDL6  =>  PIPERXVALIDL6_indly,
	PIPERXVALIDL7  =>  PIPERXVALIDL7_indly
	);

	INIPROC : process
	begin
       case TXTSNFTS is
           when   0  =>  TXTSNFTS_BINARY <= "00000000";
           when   1  =>  TXTSNFTS_BINARY <= "00000001";
           when   2  =>  TXTSNFTS_BINARY <= "00000010";
           when   3  =>  TXTSNFTS_BINARY <= "00000011";
           when   4  =>  TXTSNFTS_BINARY <= "00000100";
           when   5  =>  TXTSNFTS_BINARY <= "00000101";
           when   6  =>  TXTSNFTS_BINARY <= "00000110";
           when   7  =>  TXTSNFTS_BINARY <= "00000111";
           when   8  =>  TXTSNFTS_BINARY <= "00001000";
           when   9  =>  TXTSNFTS_BINARY <= "00001001";
           when   10  =>  TXTSNFTS_BINARY <= "00001010";
           when   11  =>  TXTSNFTS_BINARY <= "00001011";
           when   12  =>  TXTSNFTS_BINARY <= "00001100";
           when   13  =>  TXTSNFTS_BINARY <= "00001101";
           when   14  =>  TXTSNFTS_BINARY <= "00001110";
           when   15  =>  TXTSNFTS_BINARY <= "00001111";
           when   16  =>  TXTSNFTS_BINARY <= "00010000";
           when   17  =>  TXTSNFTS_BINARY <= "00010001";
           when   18  =>  TXTSNFTS_BINARY <= "00010010";
           when   19  =>  TXTSNFTS_BINARY <= "00010011";
           when   20  =>  TXTSNFTS_BINARY <= "00010100";
           when   21  =>  TXTSNFTS_BINARY <= "00010101";
           when   22  =>  TXTSNFTS_BINARY <= "00010110";
           when   23  =>  TXTSNFTS_BINARY <= "00010111";
           when   24  =>  TXTSNFTS_BINARY <= "00011000";
           when   25  =>  TXTSNFTS_BINARY <= "00011001";
           when   26  =>  TXTSNFTS_BINARY <= "00011010";
           when   27  =>  TXTSNFTS_BINARY <= "00011011";
           when   28  =>  TXTSNFTS_BINARY <= "00011100";
           when   29  =>  TXTSNFTS_BINARY <= "00011101";
           when   30  =>  TXTSNFTS_BINARY <= "00011110";
           when   31  =>  TXTSNFTS_BINARY <= "00011111";
           when   32  =>  TXTSNFTS_BINARY <= "00100000";
           when   33  =>  TXTSNFTS_BINARY <= "00100001";
           when   34  =>  TXTSNFTS_BINARY <= "00100010";
           when   35  =>  TXTSNFTS_BINARY <= "00100011";
           when   36  =>  TXTSNFTS_BINARY <= "00100100";
           when   37  =>  TXTSNFTS_BINARY <= "00100101";
           when   38  =>  TXTSNFTS_BINARY <= "00100110";
           when   39  =>  TXTSNFTS_BINARY <= "00100111";
           when   40  =>  TXTSNFTS_BINARY <= "00101000";
           when   41  =>  TXTSNFTS_BINARY <= "00101001";
           when   42  =>  TXTSNFTS_BINARY <= "00101010";
           when   43  =>  TXTSNFTS_BINARY <= "00101011";
           when   44  =>  TXTSNFTS_BINARY <= "00101100";
           when   45  =>  TXTSNFTS_BINARY <= "00101101";
           when   46  =>  TXTSNFTS_BINARY <= "00101110";
           when   47  =>  TXTSNFTS_BINARY <= "00101111";
           when   48  =>  TXTSNFTS_BINARY <= "00110000";
           when   49  =>  TXTSNFTS_BINARY <= "00110001";
           when   50  =>  TXTSNFTS_BINARY <= "00110010";
           when   51  =>  TXTSNFTS_BINARY <= "00110011";
           when   52  =>  TXTSNFTS_BINARY <= "00110100";
           when   53  =>  TXTSNFTS_BINARY <= "00110101";
           when   54  =>  TXTSNFTS_BINARY <= "00110110";
           when   55  =>  TXTSNFTS_BINARY <= "00110111";
           when   56  =>  TXTSNFTS_BINARY <= "00111000";
           when   57  =>  TXTSNFTS_BINARY <= "00111001";
           when   58  =>  TXTSNFTS_BINARY <= "00111010";
           when   59  =>  TXTSNFTS_BINARY <= "00111011";
           when   60  =>  TXTSNFTS_BINARY <= "00111100";
           when   61  =>  TXTSNFTS_BINARY <= "00111101";
           when   62  =>  TXTSNFTS_BINARY <= "00111110";
           when   63  =>  TXTSNFTS_BINARY <= "00111111";
           when   64  =>  TXTSNFTS_BINARY <= "01000000";
           when   65  =>  TXTSNFTS_BINARY <= "01000001";
           when   66  =>  TXTSNFTS_BINARY <= "01000010";
           when   67  =>  TXTSNFTS_BINARY <= "01000011";
           when   68  =>  TXTSNFTS_BINARY <= "01000100";
           when   69  =>  TXTSNFTS_BINARY <= "01000101";
           when   70  =>  TXTSNFTS_BINARY <= "01000110";
           when   71  =>  TXTSNFTS_BINARY <= "01000111";
           when   72  =>  TXTSNFTS_BINARY <= "01001000";
           when   73  =>  TXTSNFTS_BINARY <= "01001001";
           when   74  =>  TXTSNFTS_BINARY <= "01001010";
           when   75  =>  TXTSNFTS_BINARY <= "01001011";
           when   76  =>  TXTSNFTS_BINARY <= "01001100";
           when   77  =>  TXTSNFTS_BINARY <= "01001101";
           when   78  =>  TXTSNFTS_BINARY <= "01001110";
           when   79  =>  TXTSNFTS_BINARY <= "01001111";
           when   80  =>  TXTSNFTS_BINARY <= "01010000";
           when   81  =>  TXTSNFTS_BINARY <= "01010001";
           when   82  =>  TXTSNFTS_BINARY <= "01010010";
           when   83  =>  TXTSNFTS_BINARY <= "01010011";
           when   84  =>  TXTSNFTS_BINARY <= "01010100";
           when   85  =>  TXTSNFTS_BINARY <= "01010101";
           when   86  =>  TXTSNFTS_BINARY <= "01010110";
           when   87  =>  TXTSNFTS_BINARY <= "01010111";
           when   88  =>  TXTSNFTS_BINARY <= "01011000";
           when   89  =>  TXTSNFTS_BINARY <= "01011001";
           when   90  =>  TXTSNFTS_BINARY <= "01011010";
           when   91  =>  TXTSNFTS_BINARY <= "01011011";
           when   92  =>  TXTSNFTS_BINARY <= "01011100";
           when   93  =>  TXTSNFTS_BINARY <= "01011101";
           when   94  =>  TXTSNFTS_BINARY <= "01011110";
           when   95  =>  TXTSNFTS_BINARY <= "01011111";
           when   96  =>  TXTSNFTS_BINARY <= "01100000";
           when   97  =>  TXTSNFTS_BINARY <= "01100001";
           when   98  =>  TXTSNFTS_BINARY <= "01100010";
           when   99  =>  TXTSNFTS_BINARY <= "01100011";
           when   100  =>  TXTSNFTS_BINARY <= "01100100";
           when   101  =>  TXTSNFTS_BINARY <= "01100101";
           when   102  =>  TXTSNFTS_BINARY <= "01100110";
           when   103  =>  TXTSNFTS_BINARY <= "01100111";
           when   104  =>  TXTSNFTS_BINARY <= "01101000";
           when   105  =>  TXTSNFTS_BINARY <= "01101001";
           when   106  =>  TXTSNFTS_BINARY <= "01101010";
           when   107  =>  TXTSNFTS_BINARY <= "01101011";
           when   108  =>  TXTSNFTS_BINARY <= "01101100";
           when   109  =>  TXTSNFTS_BINARY <= "01101101";
           when   110  =>  TXTSNFTS_BINARY <= "01101110";
           when   111  =>  TXTSNFTS_BINARY <= "01101111";
           when   112  =>  TXTSNFTS_BINARY <= "01110000";
           when   113  =>  TXTSNFTS_BINARY <= "01110001";
           when   114  =>  TXTSNFTS_BINARY <= "01110010";
           when   115  =>  TXTSNFTS_BINARY <= "01110011";
           when   116  =>  TXTSNFTS_BINARY <= "01110100";
           when   117  =>  TXTSNFTS_BINARY <= "01110101";
           when   118  =>  TXTSNFTS_BINARY <= "01110110";
           when   119  =>  TXTSNFTS_BINARY <= "01110111";
           when   120  =>  TXTSNFTS_BINARY <= "01111000";
           when   121  =>  TXTSNFTS_BINARY <= "01111001";
           when   122  =>  TXTSNFTS_BINARY <= "01111010";
           when   123  =>  TXTSNFTS_BINARY <= "01111011";
           when   124  =>  TXTSNFTS_BINARY <= "01111100";
           when   125  =>  TXTSNFTS_BINARY <= "01111101";
           when   126  =>  TXTSNFTS_BINARY <= "01111110";
           when   127  =>  TXTSNFTS_BINARY <= "01111111";
           when   128  =>  TXTSNFTS_BINARY <= "10000000";
           when   129  =>  TXTSNFTS_BINARY <= "10000001";
           when   130  =>  TXTSNFTS_BINARY <= "10000010";
           when   131  =>  TXTSNFTS_BINARY <= "10000011";
           when   132  =>  TXTSNFTS_BINARY <= "10000100";
           when   133  =>  TXTSNFTS_BINARY <= "10000101";
           when   134  =>  TXTSNFTS_BINARY <= "10000110";
           when   135  =>  TXTSNFTS_BINARY <= "10000111";
           when   136  =>  TXTSNFTS_BINARY <= "10001000";
           when   137  =>  TXTSNFTS_BINARY <= "10001001";
           when   138  =>  TXTSNFTS_BINARY <= "10001010";
           when   139  =>  TXTSNFTS_BINARY <= "10001011";
           when   140  =>  TXTSNFTS_BINARY <= "10001100";
           when   141  =>  TXTSNFTS_BINARY <= "10001101";
           when   142  =>  TXTSNFTS_BINARY <= "10001110";
           when   143  =>  TXTSNFTS_BINARY <= "10001111";
           when   144  =>  TXTSNFTS_BINARY <= "10010000";
           when   145  =>  TXTSNFTS_BINARY <= "10010001";
           when   146  =>  TXTSNFTS_BINARY <= "10010010";
           when   147  =>  TXTSNFTS_BINARY <= "10010011";
           when   148  =>  TXTSNFTS_BINARY <= "10010100";
           when   149  =>  TXTSNFTS_BINARY <= "10010101";
           when   150  =>  TXTSNFTS_BINARY <= "10010110";
           when   151  =>  TXTSNFTS_BINARY <= "10010111";
           when   152  =>  TXTSNFTS_BINARY <= "10011000";
           when   153  =>  TXTSNFTS_BINARY <= "10011001";
           when   154  =>  TXTSNFTS_BINARY <= "10011010";
           when   155  =>  TXTSNFTS_BINARY <= "10011011";
           when   156  =>  TXTSNFTS_BINARY <= "10011100";
           when   157  =>  TXTSNFTS_BINARY <= "10011101";
           when   158  =>  TXTSNFTS_BINARY <= "10011110";
           when   159  =>  TXTSNFTS_BINARY <= "10011111";
           when   160  =>  TXTSNFTS_BINARY <= "10100000";
           when   161  =>  TXTSNFTS_BINARY <= "10100001";
           when   162  =>  TXTSNFTS_BINARY <= "10100010";
           when   163  =>  TXTSNFTS_BINARY <= "10100011";
           when   164  =>  TXTSNFTS_BINARY <= "10100100";
           when   165  =>  TXTSNFTS_BINARY <= "10100101";
           when   166  =>  TXTSNFTS_BINARY <= "10100110";
           when   167  =>  TXTSNFTS_BINARY <= "10100111";
           when   168  =>  TXTSNFTS_BINARY <= "10101000";
           when   169  =>  TXTSNFTS_BINARY <= "10101001";
           when   170  =>  TXTSNFTS_BINARY <= "10101010";
           when   171  =>  TXTSNFTS_BINARY <= "10101011";
           when   172  =>  TXTSNFTS_BINARY <= "10101100";
           when   173  =>  TXTSNFTS_BINARY <= "10101101";
           when   174  =>  TXTSNFTS_BINARY <= "10101110";
           when   175  =>  TXTSNFTS_BINARY <= "10101111";
           when   176  =>  TXTSNFTS_BINARY <= "10110000";
           when   177  =>  TXTSNFTS_BINARY <= "10110001";
           when   178  =>  TXTSNFTS_BINARY <= "10110010";
           when   179  =>  TXTSNFTS_BINARY <= "10110011";
           when   180  =>  TXTSNFTS_BINARY <= "10110100";
           when   181  =>  TXTSNFTS_BINARY <= "10110101";
           when   182  =>  TXTSNFTS_BINARY <= "10110110";
           when   183  =>  TXTSNFTS_BINARY <= "10110111";
           when   184  =>  TXTSNFTS_BINARY <= "10111000";
           when   185  =>  TXTSNFTS_BINARY <= "10111001";
           when   186  =>  TXTSNFTS_BINARY <= "10111010";
           when   187  =>  TXTSNFTS_BINARY <= "10111011";
           when   188  =>  TXTSNFTS_BINARY <= "10111100";
           when   189  =>  TXTSNFTS_BINARY <= "10111101";
           when   190  =>  TXTSNFTS_BINARY <= "10111110";
           when   191  =>  TXTSNFTS_BINARY <= "10111111";
           when   192  =>  TXTSNFTS_BINARY <= "11000000";
           when   193  =>  TXTSNFTS_BINARY <= "11000001";
           when   194  =>  TXTSNFTS_BINARY <= "11000010";
           when   195  =>  TXTSNFTS_BINARY <= "11000011";
           when   196  =>  TXTSNFTS_BINARY <= "11000100";
           when   197  =>  TXTSNFTS_BINARY <= "11000101";
           when   198  =>  TXTSNFTS_BINARY <= "11000110";
           when   199  =>  TXTSNFTS_BINARY <= "11000111";
           when   200  =>  TXTSNFTS_BINARY <= "11001000";
           when   201  =>  TXTSNFTS_BINARY <= "11001001";
           when   202  =>  TXTSNFTS_BINARY <= "11001010";
           when   203  =>  TXTSNFTS_BINARY <= "11001011";
           when   204  =>  TXTSNFTS_BINARY <= "11001100";
           when   205  =>  TXTSNFTS_BINARY <= "11001101";
           when   206  =>  TXTSNFTS_BINARY <= "11001110";
           when   207  =>  TXTSNFTS_BINARY <= "11001111";
           when   208  =>  TXTSNFTS_BINARY <= "11010000";
           when   209  =>  TXTSNFTS_BINARY <= "11010001";
           when   210  =>  TXTSNFTS_BINARY <= "11010010";
           when   211  =>  TXTSNFTS_BINARY <= "11010011";
           when   212  =>  TXTSNFTS_BINARY <= "11010100";
           when   213  =>  TXTSNFTS_BINARY <= "11010101";
           when   214  =>  TXTSNFTS_BINARY <= "11010110";
           when   215  =>  TXTSNFTS_BINARY <= "11010111";
           when   216  =>  TXTSNFTS_BINARY <= "11011000";
           when   217  =>  TXTSNFTS_BINARY <= "11011001";
           when   218  =>  TXTSNFTS_BINARY <= "11011010";
           when   219  =>  TXTSNFTS_BINARY <= "11011011";
           when   220  =>  TXTSNFTS_BINARY <= "11011100";
           when   221  =>  TXTSNFTS_BINARY <= "11011101";
           when   222  =>  TXTSNFTS_BINARY <= "11011110";
           when   223  =>  TXTSNFTS_BINARY <= "11011111";
           when   224  =>  TXTSNFTS_BINARY <= "11100000";
           when   225  =>  TXTSNFTS_BINARY <= "11100001";
           when   226  =>  TXTSNFTS_BINARY <= "11100010";
           when   227  =>  TXTSNFTS_BINARY <= "11100011";
           when   228  =>  TXTSNFTS_BINARY <= "11100100";
           when   229  =>  TXTSNFTS_BINARY <= "11100101";
           when   230  =>  TXTSNFTS_BINARY <= "11100110";
           when   231  =>  TXTSNFTS_BINARY <= "11100111";
           when   232  =>  TXTSNFTS_BINARY <= "11101000";
           when   233  =>  TXTSNFTS_BINARY <= "11101001";
           when   234  =>  TXTSNFTS_BINARY <= "11101010";
           when   235  =>  TXTSNFTS_BINARY <= "11101011";
           when   236  =>  TXTSNFTS_BINARY <= "11101100";
           when   237  =>  TXTSNFTS_BINARY <= "11101101";
           when   238  =>  TXTSNFTS_BINARY <= "11101110";
           when   239  =>  TXTSNFTS_BINARY <= "11101111";
           when   240  =>  TXTSNFTS_BINARY <= "11110000";
           when   241  =>  TXTSNFTS_BINARY <= "11110001";
           when   242  =>  TXTSNFTS_BINARY <= "11110010";
           when   243  =>  TXTSNFTS_BINARY <= "11110011";
           when   244  =>  TXTSNFTS_BINARY <= "11110100";
           when   245  =>  TXTSNFTS_BINARY <= "11110101";
           when   246  =>  TXTSNFTS_BINARY <= "11110110";
           when   247  =>  TXTSNFTS_BINARY <= "11110111";
           when   248  =>  TXTSNFTS_BINARY <= "11111000";
           when   249  =>  TXTSNFTS_BINARY <= "11111001";
           when   250  =>  TXTSNFTS_BINARY <= "11111010";
           when   251  =>  TXTSNFTS_BINARY <= "11111011";
           when   252  =>  TXTSNFTS_BINARY <= "11111100";
           when   253  =>  TXTSNFTS_BINARY <= "11111101";
           when   254  =>  TXTSNFTS_BINARY <= "11111110";
           when   255  =>  TXTSNFTS_BINARY <= "11111111";
           when others  =>  assert FALSE report "Error : TXTSNFTS is not in range 0...255." severity error;
       end case;
       case TXTSNFTSCOMCLK is
           when   0  =>  TXTSNFTSCOMCLK_BINARY <= "00000000";
           when   1  =>  TXTSNFTSCOMCLK_BINARY <= "00000001";
           when   2  =>  TXTSNFTSCOMCLK_BINARY <= "00000010";
           when   3  =>  TXTSNFTSCOMCLK_BINARY <= "00000011";
           when   4  =>  TXTSNFTSCOMCLK_BINARY <= "00000100";
           when   5  =>  TXTSNFTSCOMCLK_BINARY <= "00000101";
           when   6  =>  TXTSNFTSCOMCLK_BINARY <= "00000110";
           when   7  =>  TXTSNFTSCOMCLK_BINARY <= "00000111";
           when   8  =>  TXTSNFTSCOMCLK_BINARY <= "00001000";
           when   9  =>  TXTSNFTSCOMCLK_BINARY <= "00001001";
           when   10  =>  TXTSNFTSCOMCLK_BINARY <= "00001010";
           when   11  =>  TXTSNFTSCOMCLK_BINARY <= "00001011";
           when   12  =>  TXTSNFTSCOMCLK_BINARY <= "00001100";
           when   13  =>  TXTSNFTSCOMCLK_BINARY <= "00001101";
           when   14  =>  TXTSNFTSCOMCLK_BINARY <= "00001110";
           when   15  =>  TXTSNFTSCOMCLK_BINARY <= "00001111";
           when   16  =>  TXTSNFTSCOMCLK_BINARY <= "00010000";
           when   17  =>  TXTSNFTSCOMCLK_BINARY <= "00010001";
           when   18  =>  TXTSNFTSCOMCLK_BINARY <= "00010010";
           when   19  =>  TXTSNFTSCOMCLK_BINARY <= "00010011";
           when   20  =>  TXTSNFTSCOMCLK_BINARY <= "00010100";
           when   21  =>  TXTSNFTSCOMCLK_BINARY <= "00010101";
           when   22  =>  TXTSNFTSCOMCLK_BINARY <= "00010110";
           when   23  =>  TXTSNFTSCOMCLK_BINARY <= "00010111";
           when   24  =>  TXTSNFTSCOMCLK_BINARY <= "00011000";
           when   25  =>  TXTSNFTSCOMCLK_BINARY <= "00011001";
           when   26  =>  TXTSNFTSCOMCLK_BINARY <= "00011010";
           when   27  =>  TXTSNFTSCOMCLK_BINARY <= "00011011";
           when   28  =>  TXTSNFTSCOMCLK_BINARY <= "00011100";
           when   29  =>  TXTSNFTSCOMCLK_BINARY <= "00011101";
           when   30  =>  TXTSNFTSCOMCLK_BINARY <= "00011110";
           when   31  =>  TXTSNFTSCOMCLK_BINARY <= "00011111";
           when   32  =>  TXTSNFTSCOMCLK_BINARY <= "00100000";
           when   33  =>  TXTSNFTSCOMCLK_BINARY <= "00100001";
           when   34  =>  TXTSNFTSCOMCLK_BINARY <= "00100010";
           when   35  =>  TXTSNFTSCOMCLK_BINARY <= "00100011";
           when   36  =>  TXTSNFTSCOMCLK_BINARY <= "00100100";
           when   37  =>  TXTSNFTSCOMCLK_BINARY <= "00100101";
           when   38  =>  TXTSNFTSCOMCLK_BINARY <= "00100110";
           when   39  =>  TXTSNFTSCOMCLK_BINARY <= "00100111";
           when   40  =>  TXTSNFTSCOMCLK_BINARY <= "00101000";
           when   41  =>  TXTSNFTSCOMCLK_BINARY <= "00101001";
           when   42  =>  TXTSNFTSCOMCLK_BINARY <= "00101010";
           when   43  =>  TXTSNFTSCOMCLK_BINARY <= "00101011";
           when   44  =>  TXTSNFTSCOMCLK_BINARY <= "00101100";
           when   45  =>  TXTSNFTSCOMCLK_BINARY <= "00101101";
           when   46  =>  TXTSNFTSCOMCLK_BINARY <= "00101110";
           when   47  =>  TXTSNFTSCOMCLK_BINARY <= "00101111";
           when   48  =>  TXTSNFTSCOMCLK_BINARY <= "00110000";
           when   49  =>  TXTSNFTSCOMCLK_BINARY <= "00110001";
           when   50  =>  TXTSNFTSCOMCLK_BINARY <= "00110010";
           when   51  =>  TXTSNFTSCOMCLK_BINARY <= "00110011";
           when   52  =>  TXTSNFTSCOMCLK_BINARY <= "00110100";
           when   53  =>  TXTSNFTSCOMCLK_BINARY <= "00110101";
           when   54  =>  TXTSNFTSCOMCLK_BINARY <= "00110110";
           when   55  =>  TXTSNFTSCOMCLK_BINARY <= "00110111";
           when   56  =>  TXTSNFTSCOMCLK_BINARY <= "00111000";
           when   57  =>  TXTSNFTSCOMCLK_BINARY <= "00111001";
           when   58  =>  TXTSNFTSCOMCLK_BINARY <= "00111010";
           when   59  =>  TXTSNFTSCOMCLK_BINARY <= "00111011";
           when   60  =>  TXTSNFTSCOMCLK_BINARY <= "00111100";
           when   61  =>  TXTSNFTSCOMCLK_BINARY <= "00111101";
           when   62  =>  TXTSNFTSCOMCLK_BINARY <= "00111110";
           when   63  =>  TXTSNFTSCOMCLK_BINARY <= "00111111";
           when   64  =>  TXTSNFTSCOMCLK_BINARY <= "01000000";
           when   65  =>  TXTSNFTSCOMCLK_BINARY <= "01000001";
           when   66  =>  TXTSNFTSCOMCLK_BINARY <= "01000010";
           when   67  =>  TXTSNFTSCOMCLK_BINARY <= "01000011";
           when   68  =>  TXTSNFTSCOMCLK_BINARY <= "01000100";
           when   69  =>  TXTSNFTSCOMCLK_BINARY <= "01000101";
           when   70  =>  TXTSNFTSCOMCLK_BINARY <= "01000110";
           when   71  =>  TXTSNFTSCOMCLK_BINARY <= "01000111";
           when   72  =>  TXTSNFTSCOMCLK_BINARY <= "01001000";
           when   73  =>  TXTSNFTSCOMCLK_BINARY <= "01001001";
           when   74  =>  TXTSNFTSCOMCLK_BINARY <= "01001010";
           when   75  =>  TXTSNFTSCOMCLK_BINARY <= "01001011";
           when   76  =>  TXTSNFTSCOMCLK_BINARY <= "01001100";
           when   77  =>  TXTSNFTSCOMCLK_BINARY <= "01001101";
           when   78  =>  TXTSNFTSCOMCLK_BINARY <= "01001110";
           when   79  =>  TXTSNFTSCOMCLK_BINARY <= "01001111";
           when   80  =>  TXTSNFTSCOMCLK_BINARY <= "01010000";
           when   81  =>  TXTSNFTSCOMCLK_BINARY <= "01010001";
           when   82  =>  TXTSNFTSCOMCLK_BINARY <= "01010010";
           when   83  =>  TXTSNFTSCOMCLK_BINARY <= "01010011";
           when   84  =>  TXTSNFTSCOMCLK_BINARY <= "01010100";
           when   85  =>  TXTSNFTSCOMCLK_BINARY <= "01010101";
           when   86  =>  TXTSNFTSCOMCLK_BINARY <= "01010110";
           when   87  =>  TXTSNFTSCOMCLK_BINARY <= "01010111";
           when   88  =>  TXTSNFTSCOMCLK_BINARY <= "01011000";
           when   89  =>  TXTSNFTSCOMCLK_BINARY <= "01011001";
           when   90  =>  TXTSNFTSCOMCLK_BINARY <= "01011010";
           when   91  =>  TXTSNFTSCOMCLK_BINARY <= "01011011";
           when   92  =>  TXTSNFTSCOMCLK_BINARY <= "01011100";
           when   93  =>  TXTSNFTSCOMCLK_BINARY <= "01011101";
           when   94  =>  TXTSNFTSCOMCLK_BINARY <= "01011110";
           when   95  =>  TXTSNFTSCOMCLK_BINARY <= "01011111";
           when   96  =>  TXTSNFTSCOMCLK_BINARY <= "01100000";
           when   97  =>  TXTSNFTSCOMCLK_BINARY <= "01100001";
           when   98  =>  TXTSNFTSCOMCLK_BINARY <= "01100010";
           when   99  =>  TXTSNFTSCOMCLK_BINARY <= "01100011";
           when   100  =>  TXTSNFTSCOMCLK_BINARY <= "01100100";
           when   101  =>  TXTSNFTSCOMCLK_BINARY <= "01100101";
           when   102  =>  TXTSNFTSCOMCLK_BINARY <= "01100110";
           when   103  =>  TXTSNFTSCOMCLK_BINARY <= "01100111";
           when   104  =>  TXTSNFTSCOMCLK_BINARY <= "01101000";
           when   105  =>  TXTSNFTSCOMCLK_BINARY <= "01101001";
           when   106  =>  TXTSNFTSCOMCLK_BINARY <= "01101010";
           when   107  =>  TXTSNFTSCOMCLK_BINARY <= "01101011";
           when   108  =>  TXTSNFTSCOMCLK_BINARY <= "01101100";
           when   109  =>  TXTSNFTSCOMCLK_BINARY <= "01101101";
           when   110  =>  TXTSNFTSCOMCLK_BINARY <= "01101110";
           when   111  =>  TXTSNFTSCOMCLK_BINARY <= "01101111";
           when   112  =>  TXTSNFTSCOMCLK_BINARY <= "01110000";
           when   113  =>  TXTSNFTSCOMCLK_BINARY <= "01110001";
           when   114  =>  TXTSNFTSCOMCLK_BINARY <= "01110010";
           when   115  =>  TXTSNFTSCOMCLK_BINARY <= "01110011";
           when   116  =>  TXTSNFTSCOMCLK_BINARY <= "01110100";
           when   117  =>  TXTSNFTSCOMCLK_BINARY <= "01110101";
           when   118  =>  TXTSNFTSCOMCLK_BINARY <= "01110110";
           when   119  =>  TXTSNFTSCOMCLK_BINARY <= "01110111";
           when   120  =>  TXTSNFTSCOMCLK_BINARY <= "01111000";
           when   121  =>  TXTSNFTSCOMCLK_BINARY <= "01111001";
           when   122  =>  TXTSNFTSCOMCLK_BINARY <= "01111010";
           when   123  =>  TXTSNFTSCOMCLK_BINARY <= "01111011";
           when   124  =>  TXTSNFTSCOMCLK_BINARY <= "01111100";
           when   125  =>  TXTSNFTSCOMCLK_BINARY <= "01111101";
           when   126  =>  TXTSNFTSCOMCLK_BINARY <= "01111110";
           when   127  =>  TXTSNFTSCOMCLK_BINARY <= "01111111";
           when   128  =>  TXTSNFTSCOMCLK_BINARY <= "10000000";
           when   129  =>  TXTSNFTSCOMCLK_BINARY <= "10000001";
           when   130  =>  TXTSNFTSCOMCLK_BINARY <= "10000010";
           when   131  =>  TXTSNFTSCOMCLK_BINARY <= "10000011";
           when   132  =>  TXTSNFTSCOMCLK_BINARY <= "10000100";
           when   133  =>  TXTSNFTSCOMCLK_BINARY <= "10000101";
           when   134  =>  TXTSNFTSCOMCLK_BINARY <= "10000110";
           when   135  =>  TXTSNFTSCOMCLK_BINARY <= "10000111";
           when   136  =>  TXTSNFTSCOMCLK_BINARY <= "10001000";
           when   137  =>  TXTSNFTSCOMCLK_BINARY <= "10001001";
           when   138  =>  TXTSNFTSCOMCLK_BINARY <= "10001010";
           when   139  =>  TXTSNFTSCOMCLK_BINARY <= "10001011";
           when   140  =>  TXTSNFTSCOMCLK_BINARY <= "10001100";
           when   141  =>  TXTSNFTSCOMCLK_BINARY <= "10001101";
           when   142  =>  TXTSNFTSCOMCLK_BINARY <= "10001110";
           when   143  =>  TXTSNFTSCOMCLK_BINARY <= "10001111";
           when   144  =>  TXTSNFTSCOMCLK_BINARY <= "10010000";
           when   145  =>  TXTSNFTSCOMCLK_BINARY <= "10010001";
           when   146  =>  TXTSNFTSCOMCLK_BINARY <= "10010010";
           when   147  =>  TXTSNFTSCOMCLK_BINARY <= "10010011";
           when   148  =>  TXTSNFTSCOMCLK_BINARY <= "10010100";
           when   149  =>  TXTSNFTSCOMCLK_BINARY <= "10010101";
           when   150  =>  TXTSNFTSCOMCLK_BINARY <= "10010110";
           when   151  =>  TXTSNFTSCOMCLK_BINARY <= "10010111";
           when   152  =>  TXTSNFTSCOMCLK_BINARY <= "10011000";
           when   153  =>  TXTSNFTSCOMCLK_BINARY <= "10011001";
           when   154  =>  TXTSNFTSCOMCLK_BINARY <= "10011010";
           when   155  =>  TXTSNFTSCOMCLK_BINARY <= "10011011";
           when   156  =>  TXTSNFTSCOMCLK_BINARY <= "10011100";
           when   157  =>  TXTSNFTSCOMCLK_BINARY <= "10011101";
           when   158  =>  TXTSNFTSCOMCLK_BINARY <= "10011110";
           when   159  =>  TXTSNFTSCOMCLK_BINARY <= "10011111";
           when   160  =>  TXTSNFTSCOMCLK_BINARY <= "10100000";
           when   161  =>  TXTSNFTSCOMCLK_BINARY <= "10100001";
           when   162  =>  TXTSNFTSCOMCLK_BINARY <= "10100010";
           when   163  =>  TXTSNFTSCOMCLK_BINARY <= "10100011";
           when   164  =>  TXTSNFTSCOMCLK_BINARY <= "10100100";
           when   165  =>  TXTSNFTSCOMCLK_BINARY <= "10100101";
           when   166  =>  TXTSNFTSCOMCLK_BINARY <= "10100110";
           when   167  =>  TXTSNFTSCOMCLK_BINARY <= "10100111";
           when   168  =>  TXTSNFTSCOMCLK_BINARY <= "10101000";
           when   169  =>  TXTSNFTSCOMCLK_BINARY <= "10101001";
           when   170  =>  TXTSNFTSCOMCLK_BINARY <= "10101010";
           when   171  =>  TXTSNFTSCOMCLK_BINARY <= "10101011";
           when   172  =>  TXTSNFTSCOMCLK_BINARY <= "10101100";
           when   173  =>  TXTSNFTSCOMCLK_BINARY <= "10101101";
           when   174  =>  TXTSNFTSCOMCLK_BINARY <= "10101110";
           when   175  =>  TXTSNFTSCOMCLK_BINARY <= "10101111";
           when   176  =>  TXTSNFTSCOMCLK_BINARY <= "10110000";
           when   177  =>  TXTSNFTSCOMCLK_BINARY <= "10110001";
           when   178  =>  TXTSNFTSCOMCLK_BINARY <= "10110010";
           when   179  =>  TXTSNFTSCOMCLK_BINARY <= "10110011";
           when   180  =>  TXTSNFTSCOMCLK_BINARY <= "10110100";
           when   181  =>  TXTSNFTSCOMCLK_BINARY <= "10110101";
           when   182  =>  TXTSNFTSCOMCLK_BINARY <= "10110110";
           when   183  =>  TXTSNFTSCOMCLK_BINARY <= "10110111";
           when   184  =>  TXTSNFTSCOMCLK_BINARY <= "10111000";
           when   185  =>  TXTSNFTSCOMCLK_BINARY <= "10111001";
           when   186  =>  TXTSNFTSCOMCLK_BINARY <= "10111010";
           when   187  =>  TXTSNFTSCOMCLK_BINARY <= "10111011";
           when   188  =>  TXTSNFTSCOMCLK_BINARY <= "10111100";
           when   189  =>  TXTSNFTSCOMCLK_BINARY <= "10111101";
           when   190  =>  TXTSNFTSCOMCLK_BINARY <= "10111110";
           when   191  =>  TXTSNFTSCOMCLK_BINARY <= "10111111";
           when   192  =>  TXTSNFTSCOMCLK_BINARY <= "11000000";
           when   193  =>  TXTSNFTSCOMCLK_BINARY <= "11000001";
           when   194  =>  TXTSNFTSCOMCLK_BINARY <= "11000010";
           when   195  =>  TXTSNFTSCOMCLK_BINARY <= "11000011";
           when   196  =>  TXTSNFTSCOMCLK_BINARY <= "11000100";
           when   197  =>  TXTSNFTSCOMCLK_BINARY <= "11000101";
           when   198  =>  TXTSNFTSCOMCLK_BINARY <= "11000110";
           when   199  =>  TXTSNFTSCOMCLK_BINARY <= "11000111";
           when   200  =>  TXTSNFTSCOMCLK_BINARY <= "11001000";
           when   201  =>  TXTSNFTSCOMCLK_BINARY <= "11001001";
           when   202  =>  TXTSNFTSCOMCLK_BINARY <= "11001010";
           when   203  =>  TXTSNFTSCOMCLK_BINARY <= "11001011";
           when   204  =>  TXTSNFTSCOMCLK_BINARY <= "11001100";
           when   205  =>  TXTSNFTSCOMCLK_BINARY <= "11001101";
           when   206  =>  TXTSNFTSCOMCLK_BINARY <= "11001110";
           when   207  =>  TXTSNFTSCOMCLK_BINARY <= "11001111";
           when   208  =>  TXTSNFTSCOMCLK_BINARY <= "11010000";
           when   209  =>  TXTSNFTSCOMCLK_BINARY <= "11010001";
           when   210  =>  TXTSNFTSCOMCLK_BINARY <= "11010010";
           when   211  =>  TXTSNFTSCOMCLK_BINARY <= "11010011";
           when   212  =>  TXTSNFTSCOMCLK_BINARY <= "11010100";
           when   213  =>  TXTSNFTSCOMCLK_BINARY <= "11010101";
           when   214  =>  TXTSNFTSCOMCLK_BINARY <= "11010110";
           when   215  =>  TXTSNFTSCOMCLK_BINARY <= "11010111";
           when   216  =>  TXTSNFTSCOMCLK_BINARY <= "11011000";
           when   217  =>  TXTSNFTSCOMCLK_BINARY <= "11011001";
           when   218  =>  TXTSNFTSCOMCLK_BINARY <= "11011010";
           when   219  =>  TXTSNFTSCOMCLK_BINARY <= "11011011";
           when   220  =>  TXTSNFTSCOMCLK_BINARY <= "11011100";
           when   221  =>  TXTSNFTSCOMCLK_BINARY <= "11011101";
           when   222  =>  TXTSNFTSCOMCLK_BINARY <= "11011110";
           when   223  =>  TXTSNFTSCOMCLK_BINARY <= "11011111";
           when   224  =>  TXTSNFTSCOMCLK_BINARY <= "11100000";
           when   225  =>  TXTSNFTSCOMCLK_BINARY <= "11100001";
           when   226  =>  TXTSNFTSCOMCLK_BINARY <= "11100010";
           when   227  =>  TXTSNFTSCOMCLK_BINARY <= "11100011";
           when   228  =>  TXTSNFTSCOMCLK_BINARY <= "11100100";
           when   229  =>  TXTSNFTSCOMCLK_BINARY <= "11100101";
           when   230  =>  TXTSNFTSCOMCLK_BINARY <= "11100110";
           when   231  =>  TXTSNFTSCOMCLK_BINARY <= "11100111";
           when   232  =>  TXTSNFTSCOMCLK_BINARY <= "11101000";
           when   233  =>  TXTSNFTSCOMCLK_BINARY <= "11101001";
           when   234  =>  TXTSNFTSCOMCLK_BINARY <= "11101010";
           when   235  =>  TXTSNFTSCOMCLK_BINARY <= "11101011";
           when   236  =>  TXTSNFTSCOMCLK_BINARY <= "11101100";
           when   237  =>  TXTSNFTSCOMCLK_BINARY <= "11101101";
           when   238  =>  TXTSNFTSCOMCLK_BINARY <= "11101110";
           when   239  =>  TXTSNFTSCOMCLK_BINARY <= "11101111";
           when   240  =>  TXTSNFTSCOMCLK_BINARY <= "11110000";
           when   241  =>  TXTSNFTSCOMCLK_BINARY <= "11110001";
           when   242  =>  TXTSNFTSCOMCLK_BINARY <= "11110010";
           when   243  =>  TXTSNFTSCOMCLK_BINARY <= "11110011";
           when   244  =>  TXTSNFTSCOMCLK_BINARY <= "11110100";
           when   245  =>  TXTSNFTSCOMCLK_BINARY <= "11110101";
           when   246  =>  TXTSNFTSCOMCLK_BINARY <= "11110110";
           when   247  =>  TXTSNFTSCOMCLK_BINARY <= "11110111";
           when   248  =>  TXTSNFTSCOMCLK_BINARY <= "11111000";
           when   249  =>  TXTSNFTSCOMCLK_BINARY <= "11111001";
           when   250  =>  TXTSNFTSCOMCLK_BINARY <= "11111010";
           when   251  =>  TXTSNFTSCOMCLK_BINARY <= "11111011";
           when   252  =>  TXTSNFTSCOMCLK_BINARY <= "11111100";
           when   253  =>  TXTSNFTSCOMCLK_BINARY <= "11111101";
           when   254  =>  TXTSNFTSCOMCLK_BINARY <= "11111110";
           when   255  =>  TXTSNFTSCOMCLK_BINARY <= "11111111";
           when others  =>  assert FALSE report "Error : TXTSNFTSCOMCLK is not in range 0...255." severity error;
       end case;
       case RETRYRAMREADLATENCY is
           when   0  =>  RETRYRAMREADLATENCY_BINARY <= "000";
           when   1  =>  RETRYRAMREADLATENCY_BINARY <= "001";
           when   2  =>  RETRYRAMREADLATENCY_BINARY <= "010";
           when   3  =>  RETRYRAMREADLATENCY_BINARY <= "011";
           when   4  =>  RETRYRAMREADLATENCY_BINARY <= "100";
           when   5  =>  RETRYRAMREADLATENCY_BINARY <= "101";
           when   6  =>  RETRYRAMREADLATENCY_BINARY <= "110";
           when   7  =>  RETRYRAMREADLATENCY_BINARY <= "111";
           when others  =>  assert FALSE report "Error : RETRYRAMREADLATENCY is not in range 0...7." severity error;
       end case;
       case RETRYRAMWRITELATENCY is
           when   0  =>  RETRYRAMWRITELATENCY_BINARY <= "000";
           when   1  =>  RETRYRAMWRITELATENCY_BINARY <= "001";
           when   2  =>  RETRYRAMWRITELATENCY_BINARY <= "010";
           when   3  =>  RETRYRAMWRITELATENCY_BINARY <= "011";
           when   4  =>  RETRYRAMWRITELATENCY_BINARY <= "100";
           when   5  =>  RETRYRAMWRITELATENCY_BINARY <= "101";
           when   6  =>  RETRYRAMWRITELATENCY_BINARY <= "110";
           when   7  =>  RETRYRAMWRITELATENCY_BINARY <= "111";
           when others  =>  assert FALSE report "Error : RETRYRAMWRITELATENCY is not in range 0...7." severity error;
       end case;
       case RETRYRAMWIDTH is
           when   0  =>  RETRYRAMWIDTH_BINARY <= '0';
           when   1  =>  RETRYRAMWIDTH_BINARY <= '1';
           when others  =>  assert FALSE report "Error : RETRYRAMWIDTH is not in range 0...1." severity error;
       end case;
       case RETRYWRITEPIPE is
           when FALSE   =>  RETRYWRITEPIPE_BINARY <= '0';
           when TRUE    =>  RETRYWRITEPIPE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : RETRYWRITEPIPE is neither TRUE nor FALSE." severity error;
       end case;
       case RETRYREADADDRPIPE is
           when FALSE   =>  RETRYREADADDRPIPE_BINARY <= '0';
           when TRUE    =>  RETRYREADADDRPIPE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : RETRYREADADDRPIPE is neither TRUE nor FALSE." severity error;
       end case;
       case RETRYREADDATAPIPE is
           when FALSE   =>  RETRYREADDATAPIPE_BINARY <= '0';
           when TRUE    =>  RETRYREADDATAPIPE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : RETRYREADDATAPIPE is neither TRUE nor FALSE." severity error;
       end case;
       case XLINKSUPPORTED is
           when FALSE   =>  XLINKSUPPORTED_BINARY <= '0';
           when TRUE    =>  XLINKSUPPORTED_BINARY <= '1';
           when others  =>  assert FALSE report "Error : XLINKSUPPORTED is neither TRUE nor FALSE." severity error;
       end case;
       case INFINITECOMPLETIONS is
           when FALSE   =>  INFINITECOMPLETIONS_BINARY <= '0';
           when TRUE    =>  INFINITECOMPLETIONS_BINARY <= '1';
           when others  =>  assert FALSE report "Error : INFINITECOMPLETIONS is neither TRUE nor FALSE." severity error;
       end case;
       case TLRAMREADLATENCY is
           when   0  =>  TLRAMREADLATENCY_BINARY <= "000";
           when   1  =>  TLRAMREADLATENCY_BINARY <= "001";
           when   2  =>  TLRAMREADLATENCY_BINARY <= "010";
           when   3  =>  TLRAMREADLATENCY_BINARY <= "011";
           when   4  =>  TLRAMREADLATENCY_BINARY <= "100";
           when   5  =>  TLRAMREADLATENCY_BINARY <= "101";
           when   6  =>  TLRAMREADLATENCY_BINARY <= "110";
           when   7  =>  TLRAMREADLATENCY_BINARY <= "111";
           when others  =>  assert FALSE report "Error : TLRAMREADLATENCY is not in range 0...7." severity error;
       end case;
       case TLRAMWRITELATENCY is
           when   0  =>  TLRAMWRITELATENCY_BINARY <= "000";
           when   1  =>  TLRAMWRITELATENCY_BINARY <= "001";
           when   2  =>  TLRAMWRITELATENCY_BINARY <= "010";
           when   3  =>  TLRAMWRITELATENCY_BINARY <= "011";
           when   4  =>  TLRAMWRITELATENCY_BINARY <= "100";
           when   5  =>  TLRAMWRITELATENCY_BINARY <= "101";
           when   6  =>  TLRAMWRITELATENCY_BINARY <= "110";
           when   7  =>  TLRAMWRITELATENCY_BINARY <= "111";
           when others  =>  assert FALSE report "Error : TLRAMWRITELATENCY is not in range 0...7." severity error;
       end case;
       case TLRAMWIDTH is
           when   0  =>  TLRAMWIDTH_BINARY <= '0';
           when   1  =>  TLRAMWIDTH_BINARY <= '1';
           when others  =>  assert FALSE report "Error : TLRAMWIDTH is not in range 0...1." severity error;
       end case;
       case RAMSHARETXRX is
           when FALSE   =>  RAMSHARETXRX_BINARY <= '0';
           when TRUE    =>  RAMSHARETXRX_BINARY <= '1';
           when others  =>  assert FALSE report "Error : RAMSHARETXRX is neither TRUE nor FALSE." severity error;
       end case;
       case L0SEXITLATENCY is
           when   0  =>  L0SEXITLATENCY_BINARY <= "000";
           when   1  =>  L0SEXITLATENCY_BINARY <= "001";
           when   2  =>  L0SEXITLATENCY_BINARY <= "010";
           when   3  =>  L0SEXITLATENCY_BINARY <= "011";
           when   4  =>  L0SEXITLATENCY_BINARY <= "100";
           when   5  =>  L0SEXITLATENCY_BINARY <= "101";
           when   6  =>  L0SEXITLATENCY_BINARY <= "110";
           when   7  =>  L0SEXITLATENCY_BINARY <= "111";
           when others  =>  assert FALSE report "Error : L0SEXITLATENCY is not in range 0...7." severity error;
       end case;
       case L0SEXITLATENCYCOMCLK is
           when   0  =>  L0SEXITLATENCYCOMCLK_BINARY <= "000";
           when   1  =>  L0SEXITLATENCYCOMCLK_BINARY <= "001";
           when   2  =>  L0SEXITLATENCYCOMCLK_BINARY <= "010";
           when   3  =>  L0SEXITLATENCYCOMCLK_BINARY <= "011";
           when   4  =>  L0SEXITLATENCYCOMCLK_BINARY <= "100";
           when   5  =>  L0SEXITLATENCYCOMCLK_BINARY <= "101";
           when   6  =>  L0SEXITLATENCYCOMCLK_BINARY <= "110";
           when   7  =>  L0SEXITLATENCYCOMCLK_BINARY <= "111";
           when others  =>  assert FALSE report "Error : L0SEXITLATENCYCOMCLK is not in range 0...7." severity error;
       end case;
       case L1EXITLATENCY is
           when   0  =>  L1EXITLATENCY_BINARY <= "000";
           when   1  =>  L1EXITLATENCY_BINARY <= "001";
           when   2  =>  L1EXITLATENCY_BINARY <= "010";
           when   3  =>  L1EXITLATENCY_BINARY <= "011";
           when   4  =>  L1EXITLATENCY_BINARY <= "100";
           when   5  =>  L1EXITLATENCY_BINARY <= "101";
           when   6  =>  L1EXITLATENCY_BINARY <= "110";
           when   7  =>  L1EXITLATENCY_BINARY <= "111";
           when others  =>  assert FALSE report "Error : L1EXITLATENCY is not in range 0...7." severity error;
       end case;
       case L1EXITLATENCYCOMCLK is
           when   0  =>  L1EXITLATENCYCOMCLK_BINARY <= "000";
           when   1  =>  L1EXITLATENCYCOMCLK_BINARY <= "001";
           when   2  =>  L1EXITLATENCYCOMCLK_BINARY <= "010";
           when   3  =>  L1EXITLATENCYCOMCLK_BINARY <= "011";
           when   4  =>  L1EXITLATENCYCOMCLK_BINARY <= "100";
           when   5  =>  L1EXITLATENCYCOMCLK_BINARY <= "101";
           when   6  =>  L1EXITLATENCYCOMCLK_BINARY <= "110";
           when   7  =>  L1EXITLATENCYCOMCLK_BINARY <= "111";
           when others  =>  assert FALSE report "Error : L1EXITLATENCYCOMCLK is not in range 0...7." severity error;
       end case;
       case DUALCORESLAVE is
           when FALSE   =>  DUALCORESLAVE_BINARY <= '0';
           when TRUE    =>  DUALCORESLAVE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : DUALCORESLAVE is neither TRUE nor FALSE." severity error;
       end case;
       case DUALCOREENABLE is
           when FALSE   =>  DUALCOREENABLE_BINARY <= '0';
           when TRUE    =>  DUALCOREENABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : DUALCOREENABLE is neither TRUE nor FALSE." severity error;
       end case;
       case DUALROLECFGCNTRLROOTEPN is
           when   0  =>  DUALROLECFGCNTRLROOTEPN_BINARY <= '0';
           when   1  =>  DUALROLECFGCNTRLROOTEPN_BINARY <= '1';
           when others  =>  assert FALSE report "Error : DUALROLECFGCNTRLROOTEPN is not in range 0...1." severity error;
       end case;
       case RXREADADDRPIPE is
           when FALSE   =>  RXREADADDRPIPE_BINARY <= '0';
           when TRUE    =>  RXREADADDRPIPE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : RXREADADDRPIPE is neither TRUE nor FALSE." severity error;
       end case;
       case RXREADDATAPIPE is
           when FALSE   =>  RXREADDATAPIPE_BINARY <= '0';
           when TRUE    =>  RXREADDATAPIPE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : RXREADDATAPIPE is neither TRUE nor FALSE." severity error;
       end case;
       case TXWRITEPIPE is
           when FALSE   =>  TXWRITEPIPE_BINARY <= '0';
           when TRUE    =>  TXWRITEPIPE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : TXWRITEPIPE is neither TRUE nor FALSE." severity error;
       end case;
       case TXREADADDRPIPE is
           when FALSE   =>  TXREADADDRPIPE_BINARY <= '0';
           when TRUE    =>  TXREADADDRPIPE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : TXREADADDRPIPE is neither TRUE nor FALSE." severity error;
       end case;
       case TXREADDATAPIPE is
           when FALSE   =>  TXREADDATAPIPE_BINARY <= '0';
           when TRUE    =>  TXREADDATAPIPE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : TXREADDATAPIPE is neither TRUE nor FALSE." severity error;
       end case;
       case RXWRITEPIPE is
           when FALSE   =>  RXWRITEPIPE_BINARY <= '0';
           when TRUE    =>  RXWRITEPIPE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : RXWRITEPIPE is neither TRUE nor FALSE." severity error;
       end case;
       case LLKBYPASS is
           when FALSE   =>  LLKBYPASS_BINARY <= '0';
           when TRUE    =>  LLKBYPASS_BINARY <= '1';
           when others  =>  assert FALSE report "Error : LLKBYPASS is neither TRUE nor FALSE." severity error;
       end case;
       case PCIEREVISION is
           when   0  =>  PCIEREVISION_BINARY <= '0';
           when   1  =>  PCIEREVISION_BINARY <= '1';
           when others  =>  assert FALSE report "Error : PCIEREVISION is not in range 0...1." severity error;
       end case;
       case SELECTDLLIF is
           when FALSE   =>  SELECTDLLIF_BINARY <= '0';
           when TRUE    =>  SELECTDLLIF_BINARY <= '1';
           when others  =>  assert FALSE report "Error : SELECTDLLIF is neither TRUE nor FALSE." severity error;
       end case;
       case SELECTASMODE is
           when FALSE   =>  SELECTASMODE_BINARY <= '0';
           when TRUE    =>  SELECTASMODE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : SELECTASMODE is neither TRUE nor FALSE." severity error;
       end case;
       case ISSWITCH is
           when FALSE   =>  ISSWITCH_BINARY <= '0';
           when TRUE    =>  ISSWITCH_BINARY <= '1';
           when others  =>  assert FALSE report "Error : ISSWITCH is neither TRUE nor FALSE." severity error;
       end case;
       case UPSTREAMFACING is
           when FALSE   =>  UPSTREAMFACING_BINARY <= '0';
           when TRUE    =>  UPSTREAMFACING_BINARY <= '1';
           when others  =>  assert FALSE report "Error : UPSTREAMFACING is neither TRUE nor FALSE." severity error;
       end case;
       case SLOTIMPLEMENTED is
           when FALSE   =>  SLOTIMPLEMENTED_BINARY <= '0';
           when TRUE    =>  SLOTIMPLEMENTED_BINARY <= '1';
           when others  =>  assert FALSE report "Error : SLOTIMPLEMENTED is neither TRUE nor FALSE." severity error;
       end case;
       case BAR0EXIST is
           when FALSE   =>  BAR0EXIST_BINARY <= '0';
           when TRUE    =>  BAR0EXIST_BINARY <= '1';
           when others  =>  assert FALSE report "Error : BAR0EXIST is neither TRUE nor FALSE." severity error;
       end case;
       case BAR1EXIST is
           when FALSE   =>  BAR1EXIST_BINARY <= '0';
           when TRUE    =>  BAR1EXIST_BINARY <= '1';
           when others  =>  assert FALSE report "Error : BAR1EXIST is neither TRUE nor FALSE." severity error;
       end case;
       case BAR2EXIST is
           when FALSE   =>  BAR2EXIST_BINARY <= '0';
           when TRUE    =>  BAR2EXIST_BINARY <= '1';
           when others  =>  assert FALSE report "Error : BAR2EXIST is neither TRUE nor FALSE." severity error;
       end case;
       case BAR3EXIST is
           when FALSE   =>  BAR3EXIST_BINARY <= '0';
           when TRUE    =>  BAR3EXIST_BINARY <= '1';
           when others  =>  assert FALSE report "Error : BAR3EXIST is neither TRUE nor FALSE." severity error;
       end case;
       case BAR4EXIST is
           when FALSE   =>  BAR4EXIST_BINARY <= '0';
           when TRUE    =>  BAR4EXIST_BINARY <= '1';
           when others  =>  assert FALSE report "Error : BAR4EXIST is neither TRUE nor FALSE." severity error;
       end case;
       case BAR5EXIST is
           when FALSE   =>  BAR5EXIST_BINARY <= '0';
           when TRUE    =>  BAR5EXIST_BINARY <= '1';
           when others  =>  assert FALSE report "Error : BAR5EXIST is neither TRUE nor FALSE." severity error;
       end case;
       case BAR0ADDRWIDTH is
           when   0  =>  BAR0ADDRWIDTH_BINARY <= '0';
           when   1  =>  BAR0ADDRWIDTH_BINARY <= '1';
           when others  =>  assert FALSE report "Error : BAR0ADDRWIDTH is not in range 0...1." severity error;
       end case;
       case BAR1ADDRWIDTH is
           when   0  =>  BAR1ADDRWIDTH_BINARY <= '0';
           when   1  =>  BAR1ADDRWIDTH_BINARY <= '1';
           when others  =>  assert FALSE report "Error : BAR1ADDRWIDTH is not in range 0...1." severity error;
       end case;
       case BAR2ADDRWIDTH is
           when   0  =>  BAR2ADDRWIDTH_BINARY <= '0';
           when   1  =>  BAR2ADDRWIDTH_BINARY <= '1';
           when others  =>  assert FALSE report "Error : BAR2ADDRWIDTH is not in range 0...1." severity error;
       end case;
       case BAR3ADDRWIDTH is
           when   0  =>  BAR3ADDRWIDTH_BINARY <= '0';
           when   1  =>  BAR3ADDRWIDTH_BINARY <= '1';
           when others  =>  assert FALSE report "Error : BAR3ADDRWIDTH is not in range 0...1." severity error;
       end case;
       case BAR4ADDRWIDTH is
           when   0  =>  BAR4ADDRWIDTH_BINARY <= '0';
           when   1  =>  BAR4ADDRWIDTH_BINARY <= '1';
           when others  =>  assert FALSE report "Error : BAR4ADDRWIDTH is not in range 0...1." severity error;
       end case;
       case BAR0PREFETCHABLE is
           when FALSE   =>  BAR0PREFETCHABLE_BINARY <= '0';
           when TRUE    =>  BAR0PREFETCHABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : BAR0PREFETCHABLE is neither TRUE nor FALSE." severity error;
       end case;
       case BAR1PREFETCHABLE is
           when FALSE   =>  BAR1PREFETCHABLE_BINARY <= '0';
           when TRUE    =>  BAR1PREFETCHABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : BAR1PREFETCHABLE is neither TRUE nor FALSE." severity error;
       end case;
       case BAR2PREFETCHABLE is
           when FALSE   =>  BAR2PREFETCHABLE_BINARY <= '0';
           when TRUE    =>  BAR2PREFETCHABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : BAR2PREFETCHABLE is neither TRUE nor FALSE." severity error;
       end case;
       case BAR3PREFETCHABLE is
           when FALSE   =>  BAR3PREFETCHABLE_BINARY <= '0';
           when TRUE    =>  BAR3PREFETCHABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : BAR3PREFETCHABLE is neither TRUE nor FALSE." severity error;
       end case;
       case BAR4PREFETCHABLE is
           when FALSE   =>  BAR4PREFETCHABLE_BINARY <= '0';
           when TRUE    =>  BAR4PREFETCHABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : BAR4PREFETCHABLE is neither TRUE nor FALSE." severity error;
       end case;
       case BAR5PREFETCHABLE is
           when FALSE   =>  BAR5PREFETCHABLE_BINARY <= '0';
           when TRUE    =>  BAR5PREFETCHABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : BAR5PREFETCHABLE is neither TRUE nor FALSE." severity error;
       end case;
       case BAR0IOMEMN is
           when   0  =>  BAR0IOMEMN_BINARY <= '0';
           when   1  =>  BAR0IOMEMN_BINARY <= '1';
           when others  =>  assert FALSE report "Error : BAR0IOMEMN is not in range 0...1." severity error;
       end case;
       case BAR1IOMEMN is
           when   0  =>  BAR1IOMEMN_BINARY <= '0';
           when   1  =>  BAR1IOMEMN_BINARY <= '1';
           when others  =>  assert FALSE report "Error : BAR1IOMEMN is not in range 0...1." severity error;
       end case;
       case BAR2IOMEMN is
           when   0  =>  BAR2IOMEMN_BINARY <= '0';
           when   1  =>  BAR2IOMEMN_BINARY <= '1';
           when others  =>  assert FALSE report "Error : BAR2IOMEMN is not in range 0...1." severity error;
       end case;
       case BAR3IOMEMN is
           when   0  =>  BAR3IOMEMN_BINARY <= '0';
           when   1  =>  BAR3IOMEMN_BINARY <= '1';
           when others  =>  assert FALSE report "Error : BAR3IOMEMN is not in range 0...1." severity error;
       end case;
       case BAR4IOMEMN is
           when   0  =>  BAR4IOMEMN_BINARY <= '0';
           when   1  =>  BAR4IOMEMN_BINARY <= '1';
           when others  =>  assert FALSE report "Error : BAR4IOMEMN is not in range 0...1." severity error;
       end case;
       case BAR5IOMEMN is
           when   0  =>  BAR5IOMEMN_BINARY <= '0';
           when   1  =>  BAR5IOMEMN_BINARY <= '1';
           when others  =>  assert FALSE report "Error : BAR5IOMEMN is not in range 0...1." severity error;
       end case;
       case XPMAXPAYLOAD is
           when   0  =>  XPMAXPAYLOAD_BINARY <= "000";
           when   1  =>  XPMAXPAYLOAD_BINARY <= "001";
           when   2  =>  XPMAXPAYLOAD_BINARY <= "010";
           when   3  =>  XPMAXPAYLOAD_BINARY <= "011";
           when   4  =>  XPMAXPAYLOAD_BINARY <= "100";
           when   5  =>  XPMAXPAYLOAD_BINARY <= "101";
           when   6  =>  XPMAXPAYLOAD_BINARY <= "110";
           when   7  =>  XPMAXPAYLOAD_BINARY <= "111";
           when others  =>  assert FALSE report "Error : XPMAXPAYLOAD is not in range 0...7." severity error;
       end case;
       case XPRCBCONTROL is
           when   0  =>  XPRCBCONTROL_BINARY <= '0';
           when   1  =>  XPRCBCONTROL_BINARY <= '1';
           when others  =>  assert FALSE report "Error : XPRCBCONTROL is not in range 0...1." severity error;
       end case;
       case LOWPRIORITYVCCOUNT is
           when   0  =>  LOWPRIORITYVCCOUNT_BINARY <= "000";
           when   1  =>  LOWPRIORITYVCCOUNT_BINARY <= "001";
           when   2  =>  LOWPRIORITYVCCOUNT_BINARY <= "010";
           when   3  =>  LOWPRIORITYVCCOUNT_BINARY <= "011";
           when   4  =>  LOWPRIORITYVCCOUNT_BINARY <= "100";
           when   5  =>  LOWPRIORITYVCCOUNT_BINARY <= "101";
           when   6  =>  LOWPRIORITYVCCOUNT_BINARY <= "110";
           when   7  =>  LOWPRIORITYVCCOUNT_BINARY <= "111";
           when others  =>  assert FALSE report "Error : LOWPRIORITYVCCOUNT is not in range 0...7." severity error;
       end case;
       case PMCAPABILITYDSI is
           when FALSE   =>  PMCAPABILITYDSI_BINARY <= '0';
           when TRUE    =>  PMCAPABILITYDSI_BINARY <= '1';
           when others  =>  assert FALSE report "Error : PMCAPABILITYDSI is neither TRUE nor FALSE." severity error;
       end case;
       case PMCAPABILITYD1SUPPORT is
           when FALSE   =>  PMCAPABILITYD1SUPPORT_BINARY <= '0';
           when TRUE    =>  PMCAPABILITYD1SUPPORT_BINARY <= '1';
           when others  =>  assert FALSE report "Error : PMCAPABILITYD1SUPPORT is neither TRUE nor FALSE." severity error;
       end case;
       case PMCAPABILITYD2SUPPORT is
           when FALSE   =>  PMCAPABILITYD2SUPPORT_BINARY <= '0';
           when TRUE    =>  PMCAPABILITYD2SUPPORT_BINARY <= '1';
           when others  =>  assert FALSE report "Error : PMCAPABILITYD2SUPPORT is neither TRUE nor FALSE." severity error;
       end case;
       case PMDATASCALE0 is
           when   0  =>  PMDATASCALE0_BINARY <= "00";
           when   1  =>  PMDATASCALE0_BINARY <= "01";
           when   2  =>  PMDATASCALE0_BINARY <= "10";
           when   3  =>  PMDATASCALE0_BINARY <= "11";
           when others  =>  assert FALSE report "Error : PMDATASCALE0 is not in range 0...3." severity error;
       end case;
       case PMDATASCALE1 is
           when   0  =>  PMDATASCALE1_BINARY <= "00";
           when   1  =>  PMDATASCALE1_BINARY <= "01";
           when   2  =>  PMDATASCALE1_BINARY <= "10";
           when   3  =>  PMDATASCALE1_BINARY <= "11";
           when others  =>  assert FALSE report "Error : PMDATASCALE1 is not in range 0...3." severity error;
       end case;
       case PMDATASCALE2 is
           when   0  =>  PMDATASCALE2_BINARY <= "00";
           when   1  =>  PMDATASCALE2_BINARY <= "01";
           when   2  =>  PMDATASCALE2_BINARY <= "10";
           when   3  =>  PMDATASCALE2_BINARY <= "11";
           when others  =>  assert FALSE report "Error : PMDATASCALE2 is not in range 0...3." severity error;
       end case;
       case PMDATASCALE3 is
           when   0  =>  PMDATASCALE3_BINARY <= "00";
           when   1  =>  PMDATASCALE3_BINARY <= "01";
           when   2  =>  PMDATASCALE3_BINARY <= "10";
           when   3  =>  PMDATASCALE3_BINARY <= "11";
           when others  =>  assert FALSE report "Error : PMDATASCALE3 is not in range 0...3." severity error;
       end case;
       case PMDATASCALE4 is
           when   0  =>  PMDATASCALE4_BINARY <= "00";
           when   1  =>  PMDATASCALE4_BINARY <= "01";
           when   2  =>  PMDATASCALE4_BINARY <= "10";
           when   3  =>  PMDATASCALE4_BINARY <= "11";
           when others  =>  assert FALSE report "Error : PMDATASCALE4 is not in range 0...3." severity error;
       end case;
       case PMDATASCALE5 is
           when   0  =>  PMDATASCALE5_BINARY <= "00";
           when   1  =>  PMDATASCALE5_BINARY <= "01";
           when   2  =>  PMDATASCALE5_BINARY <= "10";
           when   3  =>  PMDATASCALE5_BINARY <= "11";
           when others  =>  assert FALSE report "Error : PMDATASCALE5 is not in range 0...3." severity error;
       end case;
       case PMDATASCALE6 is
           when   0  =>  PMDATASCALE6_BINARY <= "00";
           when   1  =>  PMDATASCALE6_BINARY <= "01";
           when   2  =>  PMDATASCALE6_BINARY <= "10";
           when   3  =>  PMDATASCALE6_BINARY <= "11";
           when others  =>  assert FALSE report "Error : PMDATASCALE6 is not in range 0...3." severity error;
       end case;
       case PMDATASCALE7 is
           when   0  =>  PMDATASCALE7_BINARY <= "00";
           when   1  =>  PMDATASCALE7_BINARY <= "01";
           when   2  =>  PMDATASCALE7_BINARY <= "10";
           when   3  =>  PMDATASCALE7_BINARY <= "11";
           when others  =>  assert FALSE report "Error : PMDATASCALE7 is not in range 0...3." severity error;
       end case;
       case PMDATASCALE8 is
           when   0  =>  PMDATASCALE8_BINARY <= "00";
           when   1  =>  PMDATASCALE8_BINARY <= "01";
           when   2  =>  PMDATASCALE8_BINARY <= "10";
           when   3  =>  PMDATASCALE8_BINARY <= "11";
           when others  =>  assert FALSE report "Error : PMDATASCALE8 is not in range 0...3." severity error;
       end case;
       case PCIECAPABILITYSLOTIMPL is
           when FALSE   =>  PCIECAPABILITYSLOTIMPL_BINARY <= '0';
           when TRUE    =>  PCIECAPABILITYSLOTIMPL_BINARY <= '1';
           when others  =>  assert FALSE report "Error : PCIECAPABILITYSLOTIMPL is neither TRUE nor FALSE." severity error;
       end case;
       case LINKSTATUSSLOTCLOCKCONFIG is
           when FALSE   =>  LINKSTATUSSLOTCLOCKCONFIG_BINARY <= '0';
           when TRUE    =>  LINKSTATUSSLOTCLOCKCONFIG_BINARY <= '1';
           when others  =>  assert FALSE report "Error : LINKSTATUSSLOTCLOCKCONFIG is neither TRUE nor FALSE." severity error;
       end case;
       case SLOTCAPABILITYATTBUTTONPRESENT is
           when FALSE   =>  SLOTCAPABILITYATTBUTTONPRESENT_BINARY <= '0';
           when TRUE    =>  SLOTCAPABILITYATTBUTTONPRESENT_BINARY <= '1';
           when others  =>  assert FALSE report "Error : SLOTCAPABILITYATTBUTTONPRESENT is neither TRUE nor FALSE." severity error;
       end case;
       case SLOTCAPABILITYPOWERCONTROLLERPRESENT is
           when FALSE   =>  SLOTCAPABILITYPOWERCONTROLLERPRESENT_BINARY <= '0';
           when TRUE    =>  SLOTCAPABILITYPOWERCONTROLLERPRESENT_BINARY <= '1';
           when others  =>  assert FALSE report "Error : SLOTCAPABILITYPOWERCONTROLLERPRESENT is neither TRUE nor FALSE." severity error;
       end case;
       case SLOTCAPABILITYMSLSENSORPRESENT is
           when FALSE   =>  SLOTCAPABILITYMSLSENSORPRESENT_BINARY <= '0';
           when TRUE    =>  SLOTCAPABILITYMSLSENSORPRESENT_BINARY <= '1';
           when others  =>  assert FALSE report "Error : SLOTCAPABILITYMSLSENSORPRESENT is neither TRUE nor FALSE." severity error;
       end case;
       case SLOTCAPABILITYATTINDICATORPRESENT is
           when FALSE   =>  SLOTCAPABILITYATTINDICATORPRESENT_BINARY <= '0';
           when TRUE    =>  SLOTCAPABILITYATTINDICATORPRESENT_BINARY <= '1';
           when others  =>  assert FALSE report "Error : SLOTCAPABILITYATTINDICATORPRESENT is neither TRUE nor FALSE." severity error;
       end case;
       case SLOTCAPABILITYPOWERINDICATORPRESENT is
           when FALSE   =>  SLOTCAPABILITYPOWERINDICATORPRESENT_BINARY <= '0';
           when TRUE    =>  SLOTCAPABILITYPOWERINDICATORPRESENT_BINARY <= '1';
           when others  =>  assert FALSE report "Error : SLOTCAPABILITYPOWERINDICATORPRESENT is neither TRUE nor FALSE." severity error;
       end case;
       case SLOTCAPABILITYHOTPLUGSURPRISE is
           when FALSE   =>  SLOTCAPABILITYHOTPLUGSURPRISE_BINARY <= '0';
           when TRUE    =>  SLOTCAPABILITYHOTPLUGSURPRISE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : SLOTCAPABILITYHOTPLUGSURPRISE is neither TRUE nor FALSE." severity error;
       end case;
       case SLOTCAPABILITYHOTPLUGCAPABLE is
           when FALSE   =>  SLOTCAPABILITYHOTPLUGCAPABLE_BINARY <= '0';
           when TRUE    =>  SLOTCAPABILITYHOTPLUGCAPABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : SLOTCAPABILITYHOTPLUGCAPABLE is neither TRUE nor FALSE." severity error;
       end case;
       case AERCAPABILITYECRCGENCAPABLE is
           when FALSE   =>  AERCAPABILITYECRCGENCAPABLE_BINARY <= '0';
           when TRUE    =>  AERCAPABILITYECRCGENCAPABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : AERCAPABILITYECRCGENCAPABLE is neither TRUE nor FALSE." severity error;
       end case;
       case AERCAPABILITYECRCCHECKCAPABLE is
           when FALSE   =>  AERCAPABILITYECRCCHECKCAPABLE_BINARY <= '0';
           when TRUE    =>  AERCAPABILITYECRCCHECKCAPABLE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : AERCAPABILITYECRCCHECKCAPABLE is neither TRUE nor FALSE." severity error;
       end case;
       case PBCAPABILITYSYSTEMALLOCATED is
           when FALSE   =>  PBCAPABILITYSYSTEMALLOCATED_BINARY <= '0';
           when TRUE    =>  PBCAPABILITYSYSTEMALLOCATED_BINARY <= '1';
           when others  =>  assert FALSE report "Error : PBCAPABILITYSYSTEMALLOCATED is neither TRUE nor FALSE." severity error;
       end case;
       case RESETMODE is
           when FALSE   =>  RESETMODE_BINARY <= '0';
           when TRUE    =>  RESETMODE_BINARY <= '1';
           when others  =>  assert FALSE report "Error : RESETMODE is neither TRUE nor FALSE." severity error;
       end case;
       case CLKDIVIDED is
           when FALSE   =>  CLKDIVIDED_BINARY <= '0';
           when TRUE    =>  CLKDIVIDED_BINARY <= '1';
           when others  =>  assert FALSE report "Error : CLKDIVIDED is neither TRUE nor FALSE." severity error;
       end case;
	wait;
	end process INIPROC;

	TIMING : process

	variable Tmkr_AUXPOWER_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_AUXPOWER_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CFGNEGOTIATEDLINKWIDTH0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CFGNEGOTIATEDLINKWIDTH1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CFGNEGOTIATEDLINKWIDTH2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CFGNEGOTIATEDLINKWIDTH3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CFGNEGOTIATEDLINKWIDTH4_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CFGNEGOTIATEDLINKWIDTH5_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_COMPLIANCEAVOID_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CRMCFGBRIDGEHOTRESET_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CRMLINKRSTN_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CRMMACRSTN_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CRMMGMTRSTN_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CRMNVRSTN_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CRMTXHOTRESETN_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CRMURSTN_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CRMUSERCFGRSTN_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_CROSSLINKSEED_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ACKNAKTIMERADJUSTMENT0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ACKNAKTIMERADJUSTMENT10_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ACKNAKTIMERADJUSTMENT11_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ACKNAKTIMERADJUSTMENT1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ACKNAKTIMERADJUSTMENT2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ACKNAKTIMERADJUSTMENT3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ACKNAKTIMERADJUSTMENT4_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ACKNAKTIMERADJUSTMENT5_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ACKNAKTIMERADJUSTMENT6_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ACKNAKTIMERADJUSTMENT7_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ACKNAKTIMERADJUSTMENT8_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ACKNAKTIMERADJUSTMENT9_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ALLDOWNPORTSINL1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ALLDOWNPORTSINL1_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ALLDOWNRXPORTSINL0S_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ALLDOWNRXPORTSINL0S_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ASE_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ASPORTCOUNT0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ASPORTCOUNT1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ASPORTCOUNT2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ASPORTCOUNT3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ASPORTCOUNT4_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ASPORTCOUNT5_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ASPORTCOUNT6_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ASPORTCOUNT7_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ASTURNPOOLBITSCONSUMED0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ASTURNPOOLBITSCONSUMED1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ASTURNPOOLBITSCONSUMED2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ATTENTIONBUTTONPRESSED_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ATTENTIONBUTTONPRESSED_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGASSPANTREEOWNEDSTATE_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGASSTATECHANGECMD0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGASSTATECHANGECMD1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGASSTATECHANGECMD2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGASSTATECHANGECMD3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGDISABLESCRAMBLE_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGEXTENDEDSYNC_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGL0SENTRYENABLE_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGL0SENTRYSUP_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGL0SEXITLAT0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGL0SEXITLAT1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGL0SEXITLAT2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGLINKDISABLE_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGLOOPBACKMASTER_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGNEGOTIATEDMAXP0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGNEGOTIATEDMAXP1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGNEGOTIATEDMAXP2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCENABLE0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCENABLE1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCENABLE2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCENABLE3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCENABLE4_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCENABLE5_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCENABLE6_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCENABLE7_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCID0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCID10_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCID11_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCID12_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCID13_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCID14_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCID15_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCID16_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCID17_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCID18_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCID19_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCID1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCID20_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCID21_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCID22_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCID23_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCID2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCID3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCID4_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCID5_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCID6_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCID7_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCID8_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0CFGVCID9_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0DLLHOLDLINKUP_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ELECTROMECHANICALINTERLOCKENGAGED_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ELECTROMECHANICALINTERLOCKENGAGED_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0FWDASSERTINTALEGACYINT_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0FWDASSERTINTALEGACYINT_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0FWDASSERTINTBLEGACYINT_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0FWDASSERTINTBLEGACYINT_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0FWDASSERTINTCLEGACYINT_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0FWDASSERTINTCLEGACYINT_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0FWDASSERTINTDLEGACYINT_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0FWDASSERTINTDLEGACYINT_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0FWDCORRERRIN_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0FWDCORRERRIN_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0FWDDEASSERTINTALEGACYINT_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0FWDDEASSERTINTALEGACYINT_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0FWDDEASSERTINTBLEGACYINT_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0FWDDEASSERTINTBLEGACYINT_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0FWDDEASSERTINTCLEGACYINT_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0FWDDEASSERTINTCLEGACYINT_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0FWDDEASSERTINTDLEGACYINT_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0FWDDEASSERTINTDLEGACYINT_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0FWDFATALERRIN_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0FWDFATALERRIN_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0FWDNONFATALERRIN_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0FWDNONFATALERRIN_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0LEGACYINTFUNCT0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0LEGACYINTFUNCT0_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0MRLSENSORCLOSEDN_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0MRLSENSORCLOSEDN_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0MSIREQUEST00_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0MSIREQUEST00_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0MSIREQUEST01_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0MSIREQUEST01_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0MSIREQUEST02_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0MSIREQUEST02_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0MSIREQUEST03_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0MSIREQUEST03_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER0_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER100_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER100_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER101_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER101_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER102_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER102_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER103_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER103_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER104_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER104_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER105_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER105_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER106_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER106_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER107_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER107_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER108_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER108_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER109_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER109_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER10_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER10_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER110_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER110_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER111_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER111_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER112_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER112_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER113_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER113_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER114_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER114_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER115_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER115_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER116_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER116_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER117_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER117_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER118_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER118_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER119_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER119_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER11_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER11_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER120_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER120_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER121_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER121_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER122_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER122_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER123_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER123_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER124_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER124_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER125_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER125_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER126_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER126_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER127_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER127_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER12_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER12_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER13_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER13_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER14_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER14_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER15_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER15_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER16_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER16_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER17_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER17_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER18_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER18_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER19_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER19_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER1_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER20_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER20_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER21_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER21_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER22_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER22_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER23_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER23_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER24_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER24_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER25_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER25_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER26_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER26_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER27_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER27_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER28_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER28_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER29_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER29_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER2_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER30_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER30_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER31_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER31_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER32_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER32_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER33_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER33_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER34_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER34_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER35_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER35_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER36_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER36_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER37_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER37_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER38_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER38_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER39_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER39_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER3_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER40_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER40_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER41_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER41_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER42_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER42_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER43_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER43_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER44_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER44_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER45_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER45_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER46_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER46_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER47_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER47_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER48_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER48_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER49_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER49_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER4_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER4_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER50_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER50_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER51_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER51_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER52_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER52_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER53_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER53_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER54_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER54_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER55_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER55_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER56_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER56_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER57_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER57_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER58_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER58_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER59_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER59_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER5_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER5_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER60_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER60_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER61_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER61_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER62_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER62_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER63_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER63_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER64_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER64_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER65_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER65_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER66_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER66_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER67_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER67_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER68_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER68_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER69_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER69_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER6_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER6_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER70_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER70_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER71_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER71_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER72_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER72_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER73_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER73_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER74_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER74_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER75_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER75_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER76_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER76_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER77_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER77_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER78_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER78_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER79_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER79_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER7_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER7_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER80_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER80_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER81_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER81_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER82_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER82_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER83_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER83_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER84_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER84_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER85_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER85_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER86_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER86_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER87_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER87_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER88_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER88_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER89_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER89_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER8_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER8_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER90_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER90_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER91_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER91_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER92_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER92_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER93_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER93_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER94_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER94_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER95_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER95_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER96_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER96_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER97_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER97_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER98_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER98_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER99_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER99_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER9_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PACKETHEADERFROMUSER9_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PMEREQIN_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PORTNUMBER0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PORTNUMBER0_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PORTNUMBER1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PORTNUMBER1_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PORTNUMBER2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PORTNUMBER2_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PORTNUMBER3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PORTNUMBER3_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PORTNUMBER4_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PORTNUMBER4_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PORTNUMBER5_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PORTNUMBER5_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PORTNUMBER6_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PORTNUMBER6_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PORTNUMBER7_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PORTNUMBER7_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0POWERFAULTDETECTED_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0POWERFAULTDETECTED_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PRESENCEDETECTSLOTEMPTYN_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PRESENCEDETECTSLOTEMPTYN_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PWRNEWSTATEREQ_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PWRNEXTLINKSTATE0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0PWRNEXTLINKSTATE1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0REPLAYTIMERADJUSTMENT0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0REPLAYTIMERADJUSTMENT10_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0REPLAYTIMERADJUSTMENT11_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0REPLAYTIMERADJUSTMENT1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0REPLAYTIMERADJUSTMENT2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0REPLAYTIMERADJUSTMENT3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0REPLAYTIMERADJUSTMENT4_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0REPLAYTIMERADJUSTMENT5_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0REPLAYTIMERADJUSTMENT6_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0REPLAYTIMERADJUSTMENT7_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0REPLAYTIMERADJUSTMENT8_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0REPLAYTIMERADJUSTMENT9_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ROOTTURNOFFREQ_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0ROOTTURNOFFREQ_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0RXTLTLPNONINITIALIZEDVC0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0RXTLTLPNONINITIALIZEDVC1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0RXTLTLPNONINITIALIZEDVC2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0RXTLTLPNONINITIALIZEDVC3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0RXTLTLPNONINITIALIZEDVC4_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0RXTLTLPNONINITIALIZEDVC5_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0RXTLTLPNONINITIALIZEDVC6_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0RXTLTLPNONINITIALIZEDVC7_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SENDUNLOCKMESSAGE_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SENDUNLOCKMESSAGE_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETCOMPLETERABORTERROR_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETCOMPLETERABORTERROR_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETCOMPLETIONTIMEOUTCORRERROR_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETCOMPLETIONTIMEOUTCORRERROR_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETCOMPLETIONTIMEOUTUNCORRERROR_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETCOMPLETIONTIMEOUTUNCORRERROR_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETDETECTEDCORRERROR_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETDETECTEDCORRERROR_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETDETECTEDFATALERROR_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETDETECTEDFATALERROR_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETDETECTEDNONFATALERROR_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETDETECTEDNONFATALERROR_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETLINKDETECTEDPARITYERROR_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETLINKDETECTEDPARITYERROR_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETLINKMASTERDATAPARITY_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETLINKMASTERDATAPARITY_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETLINKRECEIVEDMASTERABORT_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETLINKRECEIVEDMASTERABORT_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETLINKRECEIVEDTARGETABORT_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETLINKRECEIVEDTARGETABORT_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETLINKSIGNALLEDTARGETABORT_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETLINKSIGNALLEDTARGETABORT_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETLINKSYSTEMERROR_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETLINKSYSTEMERROR_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETUNEXPECTEDCOMPLETIONCORRERROR_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETUNEXPECTEDCOMPLETIONCORRERROR_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETUNSUPPORTEDREQUESTOTHERERROR_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETUNSUPPORTEDREQUESTOTHERERROR_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETUSERDETECTEDPARITYERROR_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETUSERDETECTEDPARITYERROR_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETUSERMASTERDATAPARITY_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETUSERMASTERDATAPARITY_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETUSERRECEIVEDMASTERABORT_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETUSERRECEIVEDMASTERABORT_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETUSERRECEIVEDTARGETABORT_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETUSERRECEIVEDTARGETABORT_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETUSERSIGNALLEDTARGETABORT_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETUSERSIGNALLEDTARGETABORT_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETUSERSYSTEMERROR_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0SETUSERSYSTEMERROR_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TLASFCCREDSTARVATION_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TLLINKRETRAIN_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TRANSACTIONSPENDING_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TRANSACTIONSPENDING_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXBEACON_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXCFGPMTYPE0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXCFGPMTYPE1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXCFGPMTYPE2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXCFGPM_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED100_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED101_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED102_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED103_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED104_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED105_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED106_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED107_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED108_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED109_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED10_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED110_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED111_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED112_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED113_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED114_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED115_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED116_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED117_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED118_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED119_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED11_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED120_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED121_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED122_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED123_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED124_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED125_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED126_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED127_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED128_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED129_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED12_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED130_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED131_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED132_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED133_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED134_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED135_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED136_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED137_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED138_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED139_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED13_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED140_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED141_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED142_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED143_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED144_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED145_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED146_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED147_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED148_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED149_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED14_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED150_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED151_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED152_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED153_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED154_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED155_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED156_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED157_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED158_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED159_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED15_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED16_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED17_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED18_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED19_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED20_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED21_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED22_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED23_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED24_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED25_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED26_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED27_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED28_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED29_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED30_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED31_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED32_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED33_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED34_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED35_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED36_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED37_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED38_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED39_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED40_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED41_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED42_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED43_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED44_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED45_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED46_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED47_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED48_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED49_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED4_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED50_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED51_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED52_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED53_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED54_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED55_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED56_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED57_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED58_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED59_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED5_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED60_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED61_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED62_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED63_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED64_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED65_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED66_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED67_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED68_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED69_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED6_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED70_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED71_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED72_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED73_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED74_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED75_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED76_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED77_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED78_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED79_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED7_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED80_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED81_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED82_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED83_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED84_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED85_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED86_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED87_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED88_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED89_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED8_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED90_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED91_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED92_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED93_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED94_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED95_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED96_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED97_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED98_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED99_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCCRED9_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCUPDATE0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCUPDATE10_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCUPDATE11_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCUPDATE12_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCUPDATE13_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCUPDATE14_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCUPDATE15_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCUPDATE1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCUPDATE2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCUPDATE3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCUPDATE4_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCUPDATE5_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCUPDATE6_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCUPDATE7_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCUPDATE8_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCCMPLMCUPDATE9_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED100_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED101_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED102_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED103_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED104_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED105_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED106_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED107_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED108_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED109_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED10_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED110_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED111_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED112_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED113_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED114_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED115_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED116_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED117_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED118_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED119_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED11_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED120_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED121_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED122_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED123_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED124_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED125_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED126_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED127_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED128_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED129_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED12_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED130_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED131_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED132_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED133_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED134_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED135_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED136_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED137_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED138_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED139_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED13_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED140_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED141_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED142_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED143_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED144_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED145_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED146_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED147_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED148_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED149_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED14_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED150_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED151_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED152_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED153_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED154_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED155_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED156_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED157_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED158_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED159_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED15_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED160_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED161_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED162_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED163_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED164_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED165_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED166_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED167_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED168_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED169_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED16_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED170_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED171_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED172_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED173_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED174_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED175_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED176_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED177_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED178_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED179_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED17_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED180_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED181_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED182_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED183_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED184_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED185_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED186_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED187_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED188_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED189_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED18_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED190_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED191_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED19_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED20_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED21_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED22_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED23_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED24_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED25_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED26_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED27_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED28_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED29_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED30_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED31_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED32_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED33_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED34_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED35_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED36_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED37_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED38_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED39_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED40_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED41_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED42_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED43_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED44_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED45_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED46_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED47_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED48_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED49_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED4_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED50_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED51_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED52_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED53_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED54_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED55_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED56_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED57_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED58_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED59_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED5_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED60_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED61_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED62_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED63_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED64_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED65_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED66_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED67_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED68_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED69_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED6_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED70_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED71_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED72_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED73_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED74_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED75_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED76_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED77_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED78_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED79_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED7_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED80_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED81_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED82_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED83_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED84_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED85_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED86_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED87_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED88_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED89_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED8_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED90_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED91_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED92_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED93_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED94_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED95_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED96_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED97_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED98_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED99_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPCRED9_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPUPDATE0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPUPDATE10_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPUPDATE11_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPUPDATE12_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPUPDATE13_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPUPDATE14_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPUPDATE15_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPUPDATE1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPUPDATE2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPUPDATE3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPUPDATE4_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPUPDATE5_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPUPDATE6_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPUPDATE7_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPUPDATE8_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCNPOSTBYPUPDATE9_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED100_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED101_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED102_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED103_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED104_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED105_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED106_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED107_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED108_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED109_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED10_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED110_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED111_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED112_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED113_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED114_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED115_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED116_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED117_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED118_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED119_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED11_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED120_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED121_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED122_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED123_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED124_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED125_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED126_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED127_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED128_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED129_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED12_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED130_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED131_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED132_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED133_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED134_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED135_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED136_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED137_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED138_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED139_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED13_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED140_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED141_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED142_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED143_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED144_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED145_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED146_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED147_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED148_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED149_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED14_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED150_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED151_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED152_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED153_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED154_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED155_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED156_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED157_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED158_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED159_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED15_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED16_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED17_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED18_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED19_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED20_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED21_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED22_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED23_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED24_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED25_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED26_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED27_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED28_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED29_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED30_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED31_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED32_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED33_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED34_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED35_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED36_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED37_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED38_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED39_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED40_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED41_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED42_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED43_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED44_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED45_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED46_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED47_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED48_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED49_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED4_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED50_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED51_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED52_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED53_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED54_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED55_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED56_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED57_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED58_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED59_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED5_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED60_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED61_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED62_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED63_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED64_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED65_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED66_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED67_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED68_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED69_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED6_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED70_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED71_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED72_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED73_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED74_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED75_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED76_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED77_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED78_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED79_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED7_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED80_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED81_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED82_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED83_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED84_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED85_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED86_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED87_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED88_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED89_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED8_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED90_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED91_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED92_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED93_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED94_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED95_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED96_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED97_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED98_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED99_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDCRED9_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDUPDATE0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDUPDATE10_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDUPDATE11_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDUPDATE12_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDUPDATE13_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDUPDATE14_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDUPDATE15_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDUPDATE1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDUPDATE2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDUPDATE3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDUPDATE4_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDUPDATE5_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDUPDATE6_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDUPDATE7_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDUPDATE8_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLFCPOSTORDUPDATE9_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLSBFCDATA0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLSBFCDATA10_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLSBFCDATA11_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLSBFCDATA12_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLSBFCDATA13_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLSBFCDATA14_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLSBFCDATA15_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLSBFCDATA16_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLSBFCDATA17_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLSBFCDATA18_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLSBFCDATA1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLSBFCDATA2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLSBFCDATA3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLSBFCDATA4_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLSBFCDATA5_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLSBFCDATA6_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLSBFCDATA7_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLSBFCDATA8_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLSBFCDATA9_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLSBFCUPDATE_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA10_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA11_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA12_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA13_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA14_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA15_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA16_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA17_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA18_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA19_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA20_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA21_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA22_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA23_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA24_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA25_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA26_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA27_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA28_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA29_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA30_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA31_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA32_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA33_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA34_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA35_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA36_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA37_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA38_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA39_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA40_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA41_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA42_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA43_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA44_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA45_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA46_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA47_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA48_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA49_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA4_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA50_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA51_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA52_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA53_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA54_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA55_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA56_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA57_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA58_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA59_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA5_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA60_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA61_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA62_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA63_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA6_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA7_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA8_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPDATA9_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPEDB_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPENABLE0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPENABLE1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPEND0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPEND1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPLATENCY0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPLATENCY1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPLATENCY2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPLATENCY3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPREQEND_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPREQ_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0TXTLTLPWIDTH_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0UPSTREAMRXPORTINL0S_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0UPSTREAMRXPORTINL0S_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0VC0PREVIEWEXPAND_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_L0WAKEN_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKRXCHFIFO0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKRXCHFIFO0_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKRXCHFIFO1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKRXCHFIFO1_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKRXCHTC0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKRXCHTC0_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKRXCHTC1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKRXCHTC1_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKRXCHTC2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKRXCHTC2_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKRXDSTCONTREQN_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKRXDSTCONTREQN_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKRXDSTREQN_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKRXDSTREQN_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTX4DWHEADERN_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTX4DWHEADERN_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXCHFIFO0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXCHFIFO0_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXCHFIFO1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXCHFIFO1_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXCHTC0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXCHTC0_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXCHTC1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXCHTC1_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXCHTC2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXCHTC2_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXCOMPLETEN_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXCOMPLETEN_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXCREATEECRCN_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXCREATEECRCN_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA0_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA10_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA10_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA11_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA11_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA12_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA12_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA13_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA13_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA14_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA14_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA15_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA15_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA16_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA16_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA17_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA17_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA18_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA18_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA19_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA19_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA1_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA20_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA20_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA21_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA21_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA22_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA22_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA23_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA23_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA24_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA24_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA25_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA25_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA26_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA26_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA27_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA27_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA28_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA28_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA29_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA29_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA2_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA30_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA30_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA31_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA31_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA32_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA32_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA33_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA33_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA34_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA34_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA35_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA35_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA36_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA36_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA37_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA37_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA38_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA38_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA39_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA39_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA3_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA40_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA40_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA41_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA41_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA42_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA42_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA43_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA43_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA44_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA44_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA45_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA45_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA46_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA46_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA47_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA47_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA48_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA48_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA49_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA49_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA4_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA4_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA50_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA50_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA51_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA51_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA52_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA52_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA53_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA53_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA54_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA54_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA55_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA55_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA56_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA56_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA57_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA57_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA58_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA58_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA59_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA59_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA5_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA5_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA60_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA60_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA61_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA61_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA62_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA62_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA63_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA63_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA6_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA6_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA7_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA7_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA8_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA8_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA9_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXDATA9_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXENABLEN0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXENABLEN0_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXENABLEN1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXENABLEN1_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXEOFN_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXEOFN_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXEOPN_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXEOPN_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXSOFN_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXSOFN_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXSOPN_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXSOPN_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXSRCDSCN_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXSRCDSCN_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXSRCRDYN_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_LLKTXSRCRDYN_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MAINPOWER_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTADDR0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTADDR0_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTADDR10_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTADDR10_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTADDR1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTADDR1_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTADDR2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTADDR2_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTADDR3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTADDR3_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTADDR4_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTADDR4_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTADDR5_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTADDR5_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTADDR6_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTADDR6_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTADDR7_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTADDR7_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTADDR8_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTADDR8_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTADDR9_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTADDR9_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTBWREN0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTBWREN0_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTBWREN1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTBWREN1_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTBWREN2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTBWREN2_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTBWREN3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTBWREN3_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTRDEN_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTRDEN_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTSTATSCREDITSEL0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTSTATSCREDITSEL0_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTSTATSCREDITSEL1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTSTATSCREDITSEL1_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTSTATSCREDITSEL2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTSTATSCREDITSEL2_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTSTATSCREDITSEL3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTSTATSCREDITSEL3_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTSTATSCREDITSEL4_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTSTATSCREDITSEL4_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTSTATSCREDITSEL5_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTSTATSCREDITSEL5_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTSTATSCREDITSEL6_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTSTATSCREDITSEL6_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA0_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA10_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA10_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA11_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA11_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA12_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA12_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA13_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA13_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA14_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA14_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA15_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA15_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA16_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA16_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA17_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA17_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA18_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA18_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA19_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA19_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA1_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA20_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA20_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA21_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA21_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA22_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA22_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA23_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA23_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA24_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA24_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA25_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA25_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA26_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA26_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA27_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA27_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA28_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA28_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA29_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA29_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA2_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA30_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA30_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA31_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA31_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA3_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA4_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA4_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA5_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA5_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA6_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA6_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA7_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA7_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA8_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA8_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA9_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWDATA9_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWREN_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MGMTWREN_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA10_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA11_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA12_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA13_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA14_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA15_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA16_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA17_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA18_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA19_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA20_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA21_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA22_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA23_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA24_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA25_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA26_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA27_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA28_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA29_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA30_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA31_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA32_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA33_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA34_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA35_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA36_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA37_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA38_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA39_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA40_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA41_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA42_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA43_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA44_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA45_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA46_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA47_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA48_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA49_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA4_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA50_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA51_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA52_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA53_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA54_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA55_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA56_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA57_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA58_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA59_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA5_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA60_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA61_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA62_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA63_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA6_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA7_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA8_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMDLLBRDATA9_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA0_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA10_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA10_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA11_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA11_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA12_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA12_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA13_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA13_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA14_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA14_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA15_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA15_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA16_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA16_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA17_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA17_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA18_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA18_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA19_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA19_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA1_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA20_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA20_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA21_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA21_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA22_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA22_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA23_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA23_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA24_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA24_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA25_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA25_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA26_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA26_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA27_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA27_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA28_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA28_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA29_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA29_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA2_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA30_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA30_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA31_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA31_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA32_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA32_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA33_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA33_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA34_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA34_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA35_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA35_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA36_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA36_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA37_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA37_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA38_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA38_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA39_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA39_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA3_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA40_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA40_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA41_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA41_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA42_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA42_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA43_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA43_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA44_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA44_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA45_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA45_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA46_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA46_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA47_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA47_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA48_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA48_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA49_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA49_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA4_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA4_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA50_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA50_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA51_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA51_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA52_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA52_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA53_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA53_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA54_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA54_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA55_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA55_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA56_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA56_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA57_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA57_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA58_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA58_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA59_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA59_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA5_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA5_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA60_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA60_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA61_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA61_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA62_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA62_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA63_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA63_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA6_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA6_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA7_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA7_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA8_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA8_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA9_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMRXBRDATA9_CRMUSERCLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA10_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA11_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA12_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA13_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA14_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA15_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA16_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA17_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA18_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA19_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA20_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA21_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA22_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA23_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA24_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA25_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA26_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA27_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA28_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA29_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA30_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA31_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA32_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA33_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA34_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA35_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA36_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA37_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA38_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA39_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA40_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA41_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA42_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA43_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA44_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA45_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA46_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA47_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA48_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA49_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA4_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA50_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA51_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA52_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA53_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA54_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA55_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA56_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA57_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA58_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA59_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA5_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA60_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA61_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA62_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA63_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA6_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA7_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA8_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_MIMTXBRDATA9_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPEPHYSTATUSL0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPEPHYSTATUSL1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPEPHYSTATUSL2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPEPHYSTATUSL3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPEPHYSTATUSL4_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPEPHYSTATUSL5_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPEPHYSTATUSL6_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPEPHYSTATUSL7_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXCHANISALIGNEDL0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXCHANISALIGNEDL1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXCHANISALIGNEDL2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXCHANISALIGNEDL3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXCHANISALIGNEDL4_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXCHANISALIGNEDL5_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXCHANISALIGNEDL6_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXCHANISALIGNEDL7_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAKL0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAKL1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAKL2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAKL3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAKL4_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAKL5_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAKL6_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAKL7_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL00_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL01_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL02_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL03_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL04_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL05_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL06_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL07_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL10_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL11_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL12_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL13_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL14_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL15_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL16_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL17_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL20_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL21_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL22_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL23_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL24_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL25_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL26_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL27_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL30_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL31_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL32_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL33_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL34_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL35_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL36_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL37_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL40_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL41_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL42_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL43_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL44_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL45_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL46_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL47_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL50_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL51_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL52_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL53_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL54_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL55_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL56_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL57_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL60_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL61_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL62_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL63_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL64_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL65_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL66_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL67_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL70_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL71_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL72_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL73_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL74_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL75_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL76_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXDATAL77_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXELECIDLEL0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXELECIDLEL1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXELECIDLEL2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXELECIDLEL3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXELECIDLEL4_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXELECIDLEL5_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXELECIDLEL6_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXELECIDLEL7_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXSTATUSL00_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXSTATUSL01_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXSTATUSL02_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXSTATUSL10_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXSTATUSL11_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXSTATUSL12_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXSTATUSL20_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXSTATUSL21_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXSTATUSL22_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXSTATUSL30_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXSTATUSL31_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXSTATUSL32_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXSTATUSL40_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXSTATUSL41_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXSTATUSL42_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXSTATUSL50_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXSTATUSL51_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXSTATUSL52_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXSTATUSL60_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXSTATUSL61_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXSTATUSL62_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXSTATUSL70_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXSTATUSL71_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXSTATUSL72_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXVALIDL0_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXVALIDL1_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXVALIDL2_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXVALIDL3_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXVALIDL4_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXVALIDL5_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXVALIDL6_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tmkr_PIPERXVALIDL7_CRMCORECLK_posedge : VitalTimingDataType := VitalTimingDataInit;
	variable Tviol_AUXPOWER_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_AUXPOWER_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_CFGNEGOTIATEDLINKWIDTH0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_CFGNEGOTIATEDLINKWIDTH1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_CFGNEGOTIATEDLINKWIDTH2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_CFGNEGOTIATEDLINKWIDTH3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_CFGNEGOTIATEDLINKWIDTH4_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_CFGNEGOTIATEDLINKWIDTH5_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_COMPLIANCEAVOID_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_CRMCFGBRIDGEHOTRESET_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_CRMLINKRSTN_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_CRMMACRSTN_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_CRMMGMTRSTN_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_CRMNVRSTN_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_CRMTXHOTRESETN_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_CRMURSTN_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_CRMUSERCFGRSTN_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_CROSSLINKSEED_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ACKNAKTIMERADJUSTMENT0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ACKNAKTIMERADJUSTMENT10_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ACKNAKTIMERADJUSTMENT11_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ACKNAKTIMERADJUSTMENT1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ACKNAKTIMERADJUSTMENT2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ACKNAKTIMERADJUSTMENT3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ACKNAKTIMERADJUSTMENT4_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ACKNAKTIMERADJUSTMENT5_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ACKNAKTIMERADJUSTMENT6_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ACKNAKTIMERADJUSTMENT7_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ACKNAKTIMERADJUSTMENT8_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ACKNAKTIMERADJUSTMENT9_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ALLDOWNPORTSINL1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ALLDOWNPORTSINL1_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ALLDOWNRXPORTSINL0S_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ALLDOWNRXPORTSINL0S_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ASE_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ASPORTCOUNT0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ASPORTCOUNT1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ASPORTCOUNT2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ASPORTCOUNT3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ASPORTCOUNT4_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ASPORTCOUNT5_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ASPORTCOUNT6_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ASPORTCOUNT7_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ASTURNPOOLBITSCONSUMED0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ASTURNPOOLBITSCONSUMED1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ASTURNPOOLBITSCONSUMED2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ATTENTIONBUTTONPRESSED_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ATTENTIONBUTTONPRESSED_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGASSPANTREEOWNEDSTATE_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGASSTATECHANGECMD0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGASSTATECHANGECMD1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGASSTATECHANGECMD2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGASSTATECHANGECMD3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGDISABLESCRAMBLE_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGEXTENDEDSYNC_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGL0SENTRYENABLE_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGL0SENTRYSUP_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGL0SEXITLAT0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGL0SEXITLAT1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGL0SEXITLAT2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGLINKDISABLE_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGLOOPBACKMASTER_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGNEGOTIATEDMAXP0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGNEGOTIATEDMAXP1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGNEGOTIATEDMAXP2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCENABLE0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCENABLE1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCENABLE2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCENABLE3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCENABLE4_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCENABLE5_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCENABLE6_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCENABLE7_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCID0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCID10_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCID11_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCID12_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCID13_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCID14_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCID15_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCID16_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCID17_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCID18_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCID19_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCID1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCID20_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCID21_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCID22_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCID23_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCID2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCID3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCID4_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCID5_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCID6_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCID7_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCID8_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0CFGVCID9_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0DLLHOLDLINKUP_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ELECTROMECHANICALINTERLOCKENGAGED_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ELECTROMECHANICALINTERLOCKENGAGED_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0FWDASSERTINTALEGACYINT_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0FWDASSERTINTALEGACYINT_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0FWDASSERTINTBLEGACYINT_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0FWDASSERTINTBLEGACYINT_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0FWDASSERTINTCLEGACYINT_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0FWDASSERTINTCLEGACYINT_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0FWDASSERTINTDLEGACYINT_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0FWDASSERTINTDLEGACYINT_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0FWDCORRERRIN_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0FWDCORRERRIN_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0FWDDEASSERTINTALEGACYINT_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0FWDDEASSERTINTALEGACYINT_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0FWDDEASSERTINTBLEGACYINT_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0FWDDEASSERTINTBLEGACYINT_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0FWDDEASSERTINTCLEGACYINT_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0FWDDEASSERTINTCLEGACYINT_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0FWDDEASSERTINTDLEGACYINT_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0FWDDEASSERTINTDLEGACYINT_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0FWDFATALERRIN_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0FWDFATALERRIN_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0FWDNONFATALERRIN_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0FWDNONFATALERRIN_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0LEGACYINTFUNCT0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0LEGACYINTFUNCT0_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0MRLSENSORCLOSEDN_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0MRLSENSORCLOSEDN_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0MSIREQUEST00_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0MSIREQUEST00_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0MSIREQUEST01_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0MSIREQUEST01_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0MSIREQUEST02_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0MSIREQUEST02_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0MSIREQUEST03_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0MSIREQUEST03_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER0_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER100_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER100_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER101_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER101_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER102_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER102_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER103_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER103_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER104_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER104_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER105_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER105_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER106_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER106_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER107_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER107_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER108_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER108_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER109_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER109_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER10_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER10_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER110_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER110_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER111_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER111_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER112_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER112_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER113_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER113_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER114_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER114_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER115_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER115_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER116_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER116_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER117_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER117_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER118_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER118_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER119_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER119_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER11_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER11_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER120_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER120_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER121_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER121_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER122_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER122_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER123_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER123_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER124_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER124_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER125_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER125_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER126_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER126_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER127_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER127_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER12_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER12_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER13_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER13_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER14_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER14_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER15_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER15_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER16_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER16_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER17_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER17_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER18_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER18_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER19_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER19_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER1_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER20_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER20_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER21_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER21_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER22_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER22_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER23_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER23_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER24_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER24_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER25_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER25_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER26_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER26_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER27_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER27_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER28_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER28_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER29_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER29_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER2_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER30_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER30_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER31_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER31_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER32_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER32_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER33_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER33_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER34_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER34_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER35_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER35_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER36_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER36_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER37_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER37_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER38_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER38_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER39_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER39_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER3_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER40_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER40_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER41_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER41_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER42_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER42_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER43_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER43_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER44_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER44_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER45_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER45_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER46_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER46_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER47_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER47_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER48_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER48_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER49_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER49_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER4_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER4_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER50_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER50_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER51_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER51_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER52_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER52_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER53_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER53_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER54_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER54_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER55_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER55_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER56_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER56_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER57_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER57_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER58_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER58_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER59_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER59_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER5_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER5_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER60_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER60_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER61_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER61_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER62_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER62_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER63_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER63_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER64_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER64_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER65_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER65_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER66_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER66_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER67_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER67_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER68_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER68_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER69_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER69_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER6_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER6_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER70_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER70_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER71_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER71_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER72_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER72_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER73_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER73_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER74_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER74_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER75_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER75_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER76_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER76_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER77_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER77_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER78_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER78_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER79_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER79_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER7_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER7_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER80_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER80_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER81_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER81_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER82_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER82_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER83_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER83_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER84_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER84_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER85_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER85_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER86_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER86_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER87_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER87_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER88_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER88_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER89_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER89_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER8_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER8_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER90_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER90_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER91_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER91_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER92_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER92_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER93_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER93_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER94_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER94_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER95_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER95_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER96_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER96_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER97_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER97_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER98_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER98_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER99_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER99_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER9_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PACKETHEADERFROMUSER9_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PMEREQIN_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PORTNUMBER0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PORTNUMBER0_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PORTNUMBER1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PORTNUMBER1_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PORTNUMBER2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PORTNUMBER2_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PORTNUMBER3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PORTNUMBER3_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PORTNUMBER4_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PORTNUMBER4_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PORTNUMBER5_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PORTNUMBER5_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PORTNUMBER6_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PORTNUMBER6_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PORTNUMBER7_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PORTNUMBER7_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0POWERFAULTDETECTED_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0POWERFAULTDETECTED_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PRESENCEDETECTSLOTEMPTYN_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PRESENCEDETECTSLOTEMPTYN_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PWRNEWSTATEREQ_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PWRNEXTLINKSTATE0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0PWRNEXTLINKSTATE1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0REPLAYTIMERADJUSTMENT0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0REPLAYTIMERADJUSTMENT10_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0REPLAYTIMERADJUSTMENT11_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0REPLAYTIMERADJUSTMENT1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0REPLAYTIMERADJUSTMENT2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0REPLAYTIMERADJUSTMENT3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0REPLAYTIMERADJUSTMENT4_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0REPLAYTIMERADJUSTMENT5_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0REPLAYTIMERADJUSTMENT6_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0REPLAYTIMERADJUSTMENT7_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0REPLAYTIMERADJUSTMENT8_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0REPLAYTIMERADJUSTMENT9_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ROOTTURNOFFREQ_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0ROOTTURNOFFREQ_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0RXTLTLPNONINITIALIZEDVC0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0RXTLTLPNONINITIALIZEDVC1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0RXTLTLPNONINITIALIZEDVC2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0RXTLTLPNONINITIALIZEDVC3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0RXTLTLPNONINITIALIZEDVC4_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0RXTLTLPNONINITIALIZEDVC5_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0RXTLTLPNONINITIALIZEDVC6_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0RXTLTLPNONINITIALIZEDVC7_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SENDUNLOCKMESSAGE_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SENDUNLOCKMESSAGE_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETCOMPLETERABORTERROR_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETCOMPLETERABORTERROR_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETCOMPLETIONTIMEOUTCORRERROR_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETCOMPLETIONTIMEOUTCORRERROR_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETCOMPLETIONTIMEOUTUNCORRERROR_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETCOMPLETIONTIMEOUTUNCORRERROR_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETDETECTEDCORRERROR_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETDETECTEDCORRERROR_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETDETECTEDFATALERROR_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETDETECTEDFATALERROR_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETDETECTEDNONFATALERROR_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETDETECTEDNONFATALERROR_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETLINKDETECTEDPARITYERROR_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETLINKDETECTEDPARITYERROR_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETLINKMASTERDATAPARITY_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETLINKMASTERDATAPARITY_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETLINKRECEIVEDMASTERABORT_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETLINKRECEIVEDMASTERABORT_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETLINKRECEIVEDTARGETABORT_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETLINKRECEIVEDTARGETABORT_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETLINKSIGNALLEDTARGETABORT_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETLINKSIGNALLEDTARGETABORT_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETLINKSYSTEMERROR_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETLINKSYSTEMERROR_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETUNEXPECTEDCOMPLETIONCORRERROR_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETUNEXPECTEDCOMPLETIONCORRERROR_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETUNEXPECTEDCOMPLETIONUNCORRERROR_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETUNSUPPORTEDREQUESTNONPOSTEDERROR_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETUNSUPPORTEDREQUESTOTHERERROR_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETUNSUPPORTEDREQUESTOTHERERROR_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETUSERDETECTEDPARITYERROR_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETUSERDETECTEDPARITYERROR_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETUSERMASTERDATAPARITY_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETUSERMASTERDATAPARITY_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETUSERRECEIVEDMASTERABORT_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETUSERRECEIVEDMASTERABORT_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETUSERRECEIVEDTARGETABORT_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETUSERRECEIVEDTARGETABORT_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETUSERSIGNALLEDTARGETABORT_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETUSERSIGNALLEDTARGETABORT_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETUSERSYSTEMERROR_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0SETUSERSYSTEMERROR_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TLASFCCREDSTARVATION_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TLLINKRETRAIN_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TRANSACTIONSPENDING_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TRANSACTIONSPENDING_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXBEACON_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXCFGPMTYPE0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXCFGPMTYPE1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXCFGPMTYPE2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXCFGPM_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED100_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED101_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED102_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED103_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED104_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED105_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED106_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED107_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED108_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED109_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED10_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED110_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED111_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED112_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED113_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED114_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED115_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED116_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED117_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED118_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED119_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED11_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED120_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED121_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED122_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED123_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED124_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED125_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED126_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED127_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED128_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED129_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED12_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED130_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED131_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED132_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED133_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED134_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED135_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED136_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED137_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED138_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED139_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED13_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED140_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED141_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED142_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED143_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED144_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED145_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED146_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED147_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED148_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED149_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED14_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED150_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED151_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED152_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED153_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED154_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED155_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED156_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED157_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED158_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED159_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED15_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED16_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED17_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED18_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED19_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED20_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED21_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED22_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED23_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED24_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED25_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED26_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED27_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED28_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED29_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED30_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED31_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED32_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED33_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED34_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED35_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED36_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED37_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED38_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED39_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED40_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED41_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED42_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED43_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED44_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED45_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED46_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED47_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED48_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED49_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED4_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED50_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED51_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED52_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED53_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED54_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED55_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED56_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED57_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED58_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED59_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED5_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED60_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED61_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED62_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED63_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED64_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED65_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED66_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED67_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED68_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED69_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED6_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED70_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED71_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED72_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED73_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED74_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED75_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED76_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED77_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED78_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED79_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED7_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED80_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED81_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED82_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED83_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED84_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED85_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED86_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED87_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED88_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED89_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED8_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED90_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED91_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED92_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED93_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED94_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED95_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED96_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED97_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED98_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED99_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCCRED9_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCUPDATE0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCUPDATE10_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCUPDATE11_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCUPDATE12_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCUPDATE13_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCUPDATE14_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCUPDATE15_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCUPDATE1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCUPDATE2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCUPDATE3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCUPDATE4_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCUPDATE5_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCUPDATE6_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCUPDATE7_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCUPDATE8_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCCMPLMCUPDATE9_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED100_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED101_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED102_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED103_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED104_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED105_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED106_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED107_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED108_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED109_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED10_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED110_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED111_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED112_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED113_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED114_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED115_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED116_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED117_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED118_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED119_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED11_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED120_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED121_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED122_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED123_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED124_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED125_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED126_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED127_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED128_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED129_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED12_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED130_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED131_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED132_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED133_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED134_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED135_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED136_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED137_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED138_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED139_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED13_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED140_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED141_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED142_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED143_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED144_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED145_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED146_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED147_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED148_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED149_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED14_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED150_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED151_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED152_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED153_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED154_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED155_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED156_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED157_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED158_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED159_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED15_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED160_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED161_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED162_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED163_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED164_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED165_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED166_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED167_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED168_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED169_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED16_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED170_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED171_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED172_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED173_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED174_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED175_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED176_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED177_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED178_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED179_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED17_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED180_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED181_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED182_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED183_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED184_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED185_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED186_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED187_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED188_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED189_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED18_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED190_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED191_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED19_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED20_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED21_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED22_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED23_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED24_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED25_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED26_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED27_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED28_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED29_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED30_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED31_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED32_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED33_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED34_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED35_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED36_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED37_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED38_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED39_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED40_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED41_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED42_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED43_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED44_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED45_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED46_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED47_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED48_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED49_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED4_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED50_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED51_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED52_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED53_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED54_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED55_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED56_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED57_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED58_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED59_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED5_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED60_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED61_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED62_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED63_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED64_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED65_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED66_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED67_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED68_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED69_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED6_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED70_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED71_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED72_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED73_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED74_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED75_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED76_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED77_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED78_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED79_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED7_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED80_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED81_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED82_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED83_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED84_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED85_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED86_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED87_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED88_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED89_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED8_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED90_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED91_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED92_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED93_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED94_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED95_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED96_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED97_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED98_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED99_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPCRED9_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPUPDATE0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPUPDATE10_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPUPDATE11_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPUPDATE12_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPUPDATE13_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPUPDATE14_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPUPDATE15_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPUPDATE1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPUPDATE2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPUPDATE3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPUPDATE4_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPUPDATE5_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPUPDATE6_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPUPDATE7_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPUPDATE8_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCNPOSTBYPUPDATE9_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED100_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED101_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED102_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED103_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED104_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED105_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED106_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED107_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED108_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED109_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED10_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED110_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED111_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED112_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED113_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED114_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED115_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED116_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED117_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED118_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED119_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED11_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED120_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED121_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED122_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED123_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED124_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED125_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED126_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED127_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED128_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED129_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED12_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED130_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED131_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED132_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED133_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED134_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED135_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED136_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED137_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED138_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED139_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED13_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED140_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED141_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED142_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED143_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED144_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED145_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED146_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED147_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED148_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED149_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED14_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED150_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED151_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED152_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED153_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED154_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED155_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED156_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED157_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED158_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED159_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED15_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED16_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED17_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED18_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED19_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED20_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED21_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED22_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED23_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED24_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED25_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED26_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED27_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED28_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED29_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED30_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED31_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED32_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED33_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED34_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED35_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED36_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED37_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED38_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED39_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED40_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED41_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED42_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED43_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED44_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED45_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED46_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED47_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED48_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED49_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED4_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED50_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED51_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED52_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED53_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED54_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED55_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED56_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED57_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED58_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED59_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED5_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED60_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED61_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED62_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED63_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED64_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED65_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED66_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED67_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED68_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED69_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED6_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED70_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED71_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED72_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED73_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED74_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED75_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED76_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED77_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED78_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED79_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED7_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED80_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED81_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED82_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED83_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED84_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED85_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED86_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED87_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED88_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED89_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED8_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED90_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED91_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED92_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED93_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED94_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED95_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED96_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED97_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED98_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED99_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDCRED9_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDUPDATE0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDUPDATE10_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDUPDATE11_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDUPDATE12_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDUPDATE13_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDUPDATE14_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDUPDATE15_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDUPDATE1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDUPDATE2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDUPDATE3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDUPDATE4_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDUPDATE5_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDUPDATE6_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDUPDATE7_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDUPDATE8_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLFCPOSTORDUPDATE9_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLSBFCDATA0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLSBFCDATA10_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLSBFCDATA11_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLSBFCDATA12_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLSBFCDATA13_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLSBFCDATA14_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLSBFCDATA15_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLSBFCDATA16_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLSBFCDATA17_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLSBFCDATA18_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLSBFCDATA1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLSBFCDATA2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLSBFCDATA3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLSBFCDATA4_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLSBFCDATA5_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLSBFCDATA6_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLSBFCDATA7_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLSBFCDATA8_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLSBFCDATA9_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLSBFCUPDATE_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA10_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA11_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA12_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA13_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA14_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA15_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA16_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA17_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA18_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA19_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA20_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA21_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA22_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA23_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA24_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA25_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA26_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA27_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA28_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA29_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA30_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA31_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA32_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA33_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA34_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA35_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA36_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA37_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA38_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA39_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA40_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA41_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA42_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA43_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA44_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA45_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA46_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA47_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA48_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA49_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA4_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA50_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA51_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA52_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA53_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA54_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA55_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA56_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA57_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA58_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA59_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA5_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA60_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA61_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA62_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA63_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA6_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA7_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA8_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPDATA9_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPEDB_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPENABLE0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPENABLE1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPEND0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPEND1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPLATENCY0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPLATENCY1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPLATENCY2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPLATENCY3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPREQEND_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPREQ_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0TXTLTLPWIDTH_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0UPSTREAMRXPORTINL0S_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0UPSTREAMRXPORTINL0S_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0VC0PREVIEWEXPAND_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_L0WAKEN_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKRXCHFIFO0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKRXCHFIFO0_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKRXCHFIFO1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKRXCHFIFO1_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKRXCHTC0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKRXCHTC0_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKRXCHTC1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKRXCHTC1_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKRXCHTC2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKRXCHTC2_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKRXDSTCONTREQN_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKRXDSTCONTREQN_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKRXDSTREQN_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKRXDSTREQN_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTX4DWHEADERN_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTX4DWHEADERN_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXCHFIFO0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXCHFIFO0_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXCHFIFO1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXCHFIFO1_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXCHTC0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXCHTC0_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXCHTC1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXCHTC1_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXCHTC2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXCHTC2_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXCOMPLETEN_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXCOMPLETEN_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXCREATEECRCN_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXCREATEECRCN_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA0_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA10_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA10_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA11_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA11_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA12_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA12_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA13_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA13_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA14_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA14_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA15_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA15_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA16_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA16_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA17_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA17_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA18_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA18_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA19_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA19_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA1_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA20_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA20_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA21_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA21_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA22_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA22_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA23_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA23_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA24_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA24_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA25_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA25_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA26_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA26_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA27_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA27_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA28_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA28_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA29_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA29_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA2_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA30_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA30_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA31_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA31_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA32_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA32_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA33_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA33_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA34_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA34_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA35_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA35_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA36_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA36_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA37_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA37_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA38_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA38_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA39_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA39_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA3_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA40_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA40_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA41_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA41_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA42_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA42_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA43_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA43_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA44_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA44_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA45_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA45_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA46_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA46_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA47_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA47_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA48_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA48_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA49_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA49_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA4_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA4_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA50_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA50_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA51_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA51_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA52_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA52_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA53_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA53_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA54_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA54_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA55_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA55_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA56_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA56_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA57_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA57_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA58_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA58_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA59_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA59_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA5_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA5_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA60_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA60_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA61_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA61_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA62_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA62_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA63_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA63_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA6_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA6_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA7_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA7_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA8_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA8_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA9_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXDATA9_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXENABLEN0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXENABLEN0_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXENABLEN1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXENABLEN1_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXEOFN_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXEOFN_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXEOPN_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXEOPN_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXSOFN_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXSOFN_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXSOPN_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXSOPN_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXSRCDSCN_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXSRCDSCN_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXSRCRDYN_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_LLKTXSRCRDYN_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MAINPOWER_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTADDR0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTADDR0_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTADDR10_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTADDR10_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTADDR1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTADDR1_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTADDR2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTADDR2_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTADDR3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTADDR3_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTADDR4_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTADDR4_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTADDR5_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTADDR5_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTADDR6_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTADDR6_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTADDR7_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTADDR7_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTADDR8_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTADDR8_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTADDR9_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTADDR9_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTBWREN0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTBWREN0_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTBWREN1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTBWREN1_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTBWREN2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTBWREN2_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTBWREN3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTBWREN3_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTRDEN_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTRDEN_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTSTATSCREDITSEL0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTSTATSCREDITSEL0_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTSTATSCREDITSEL1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTSTATSCREDITSEL1_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTSTATSCREDITSEL2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTSTATSCREDITSEL2_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTSTATSCREDITSEL3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTSTATSCREDITSEL3_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTSTATSCREDITSEL4_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTSTATSCREDITSEL4_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTSTATSCREDITSEL5_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTSTATSCREDITSEL5_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTSTATSCREDITSEL6_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTSTATSCREDITSEL6_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA0_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA10_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA10_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA11_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA11_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA12_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA12_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA13_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA13_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA14_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA14_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA15_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA15_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA16_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA16_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA17_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA17_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA18_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA18_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA19_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA19_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA1_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA20_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA20_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA21_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA21_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA22_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA22_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA23_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA23_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA24_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA24_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA25_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA25_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA26_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA26_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA27_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA27_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA28_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA28_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA29_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA29_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA2_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA30_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA30_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA31_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA31_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA3_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA4_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA4_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA5_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA5_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA6_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA6_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA7_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA7_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA8_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA8_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA9_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWDATA9_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWREN_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MGMTWREN_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA10_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA11_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA12_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA13_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA14_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA15_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA16_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA17_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA18_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA19_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA20_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA21_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA22_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA23_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA24_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA25_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA26_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA27_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA28_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA29_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA30_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA31_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA32_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA33_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA34_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA35_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA36_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA37_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA38_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA39_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA40_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA41_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA42_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA43_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA44_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA45_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA46_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA47_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA48_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA49_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA4_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA50_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA51_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA52_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA53_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA54_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA55_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA56_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA57_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA58_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA59_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA5_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA60_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA61_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA62_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA63_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA6_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA7_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA8_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMDLLBRDATA9_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA0_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA10_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA10_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA11_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA11_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA12_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA12_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA13_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA13_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA14_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA14_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA15_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA15_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA16_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA16_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA17_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA17_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA18_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA18_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA19_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA19_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA1_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA20_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA20_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA21_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA21_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA22_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA22_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA23_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA23_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA24_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA24_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA25_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA25_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA26_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA26_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA27_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA27_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA28_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA28_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA29_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA29_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA2_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA30_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA30_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA31_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA31_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA32_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA32_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA33_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA33_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA34_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA34_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA35_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA35_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA36_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA36_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA37_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA37_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA38_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA38_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA39_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA39_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA3_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA40_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA40_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA41_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA41_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA42_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA42_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA43_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA43_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA44_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA44_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA45_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA45_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA46_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA46_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA47_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA47_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA48_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA48_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA49_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA49_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA4_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA4_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA50_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA50_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA51_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA51_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA52_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA52_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA53_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA53_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA54_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA54_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA55_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA55_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA56_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA56_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA57_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA57_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA58_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA58_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA59_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA59_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA5_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA5_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA60_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA60_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA61_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA61_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA62_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA62_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA63_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA63_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA6_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA6_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA7_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA7_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA8_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA8_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA9_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMRXBRDATA9_CRMUSERCLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA10_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA11_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA12_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA13_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA14_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA15_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA16_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA17_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA18_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA19_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA20_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA21_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA22_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA23_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA24_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA25_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA26_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA27_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA28_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA29_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA30_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA31_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA32_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA33_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA34_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA35_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA36_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA37_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA38_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA39_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA40_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA41_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA42_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA43_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA44_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA45_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA46_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA47_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA48_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA49_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA4_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA50_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA51_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA52_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA53_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA54_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA55_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA56_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA57_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA58_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA59_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA5_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA60_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA61_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA62_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA63_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA6_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA7_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA8_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_MIMTXBRDATA9_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPEPHYSTATUSL0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPEPHYSTATUSL1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPEPHYSTATUSL2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPEPHYSTATUSL3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPEPHYSTATUSL4_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPEPHYSTATUSL5_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPEPHYSTATUSL6_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPEPHYSTATUSL7_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXCHANISALIGNEDL0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXCHANISALIGNEDL1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXCHANISALIGNEDL2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXCHANISALIGNEDL3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXCHANISALIGNEDL4_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXCHANISALIGNEDL5_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXCHANISALIGNEDL6_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXCHANISALIGNEDL7_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAKL0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAKL1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAKL2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAKL3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAKL4_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAKL5_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAKL6_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAKL7_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL00_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL01_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL02_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL03_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL04_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL05_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL06_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL07_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL10_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL11_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL12_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL13_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL14_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL15_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL16_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL17_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL20_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL21_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL22_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL23_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL24_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL25_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL26_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL27_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL30_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL31_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL32_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL33_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL34_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL35_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL36_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL37_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL40_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL41_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL42_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL43_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL44_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL45_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL46_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL47_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL50_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL51_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL52_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL53_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL54_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL55_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL56_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL57_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL60_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL61_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL62_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL63_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL64_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL65_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL66_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL67_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL70_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL71_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL72_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL73_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL74_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL75_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL76_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXDATAL77_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXELECIDLEL0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXELECIDLEL1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXELECIDLEL2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXELECIDLEL3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXELECIDLEL4_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXELECIDLEL5_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXELECIDLEL6_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXELECIDLEL7_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXSTATUSL00_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXSTATUSL01_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXSTATUSL02_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXSTATUSL10_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXSTATUSL11_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXSTATUSL12_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXSTATUSL20_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXSTATUSL21_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXSTATUSL22_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXSTATUSL30_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXSTATUSL31_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXSTATUSL32_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXSTATUSL40_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXSTATUSL41_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXSTATUSL42_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXSTATUSL50_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXSTATUSL51_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXSTATUSL52_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXSTATUSL60_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXSTATUSL61_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXSTATUSL62_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXSTATUSL70_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXSTATUSL71_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXSTATUSL72_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXVALIDL0_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXVALIDL1_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXVALIDL2_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXVALIDL3_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXVALIDL4_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXVALIDL5_CRMCORECLK_posedge : STD_ULOGIC := '0';
	variable Tviol_PIPERXVALIDL6_CRMCORECLK_posedge : STD_ULOGIC := '0';
        variable Tviol_PIPERXVALIDL7_CRMCORECLK_posedge : STD_ULOGIC := '0';


	variable  PIPETXDATAL00_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL01_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL02_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL03_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL04_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL05_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL06_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL07_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAKL0_GlitchData : VitalGlitchDataType;
	variable  PIPETXELECIDLEL0_GlitchData : VitalGlitchDataType;
	variable  PIPETXDETECTRXLOOPBACKL0_GlitchData : VitalGlitchDataType;
	variable  PIPETXCOMPLIANCEL0_GlitchData : VitalGlitchDataType;
	variable  PIPERXPOLARITYL0_GlitchData : VitalGlitchDataType;
	variable  PIPEPOWERDOWNL00_GlitchData : VitalGlitchDataType;
	variable  PIPEPOWERDOWNL01_GlitchData : VitalGlitchDataType;
	variable  PIPEDESKEWLANESL0_GlitchData : VitalGlitchDataType;
	variable  PIPERESETL0_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL10_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL11_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL12_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL13_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL14_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL15_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL16_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL17_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAKL1_GlitchData : VitalGlitchDataType;
	variable  PIPETXELECIDLEL1_GlitchData : VitalGlitchDataType;
	variable  PIPETXDETECTRXLOOPBACKL1_GlitchData : VitalGlitchDataType;
	variable  PIPETXCOMPLIANCEL1_GlitchData : VitalGlitchDataType;
	variable  PIPERXPOLARITYL1_GlitchData : VitalGlitchDataType;
	variable  PIPEPOWERDOWNL10_GlitchData : VitalGlitchDataType;
	variable  PIPEPOWERDOWNL11_GlitchData : VitalGlitchDataType;
	variable  PIPEDESKEWLANESL1_GlitchData : VitalGlitchDataType;
	variable  PIPERESETL1_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL20_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL21_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL22_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL23_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL24_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL25_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL26_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL27_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAKL2_GlitchData : VitalGlitchDataType;
	variable  PIPETXELECIDLEL2_GlitchData : VitalGlitchDataType;
	variable  PIPETXDETECTRXLOOPBACKL2_GlitchData : VitalGlitchDataType;
	variable  PIPETXCOMPLIANCEL2_GlitchData : VitalGlitchDataType;
	variable  PIPERXPOLARITYL2_GlitchData : VitalGlitchDataType;
	variable  PIPEPOWERDOWNL20_GlitchData : VitalGlitchDataType;
	variable  PIPEPOWERDOWNL21_GlitchData : VitalGlitchDataType;
	variable  PIPEDESKEWLANESL2_GlitchData : VitalGlitchDataType;
	variable  PIPERESETL2_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL30_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL31_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL32_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL33_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL34_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL35_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL36_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL37_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAKL3_GlitchData : VitalGlitchDataType;
	variable  PIPETXELECIDLEL3_GlitchData : VitalGlitchDataType;
	variable  PIPETXDETECTRXLOOPBACKL3_GlitchData : VitalGlitchDataType;
	variable  PIPETXCOMPLIANCEL3_GlitchData : VitalGlitchDataType;
	variable  PIPERXPOLARITYL3_GlitchData : VitalGlitchDataType;
	variable  PIPEPOWERDOWNL30_GlitchData : VitalGlitchDataType;
	variable  PIPEPOWERDOWNL31_GlitchData : VitalGlitchDataType;
	variable  PIPEDESKEWLANESL3_GlitchData : VitalGlitchDataType;
	variable  PIPERESETL3_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL40_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL41_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL42_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL43_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL44_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL45_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL46_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL47_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAKL4_GlitchData : VitalGlitchDataType;
	variable  PIPETXELECIDLEL4_GlitchData : VitalGlitchDataType;
	variable  PIPETXDETECTRXLOOPBACKL4_GlitchData : VitalGlitchDataType;
	variable  PIPETXCOMPLIANCEL4_GlitchData : VitalGlitchDataType;
	variable  PIPERXPOLARITYL4_GlitchData : VitalGlitchDataType;
	variable  PIPEPOWERDOWNL40_GlitchData : VitalGlitchDataType;
	variable  PIPEPOWERDOWNL41_GlitchData : VitalGlitchDataType;
	variable  PIPEDESKEWLANESL4_GlitchData : VitalGlitchDataType;
	variable  PIPERESETL4_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL50_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL51_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL52_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL53_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL54_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL55_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL56_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL57_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAKL5_GlitchData : VitalGlitchDataType;
	variable  PIPETXELECIDLEL5_GlitchData : VitalGlitchDataType;
	variable  PIPETXDETECTRXLOOPBACKL5_GlitchData : VitalGlitchDataType;
	variable  PIPETXCOMPLIANCEL5_GlitchData : VitalGlitchDataType;
	variable  PIPERXPOLARITYL5_GlitchData : VitalGlitchDataType;
	variable  PIPEPOWERDOWNL50_GlitchData : VitalGlitchDataType;
	variable  PIPEPOWERDOWNL51_GlitchData : VitalGlitchDataType;
	variable  PIPEDESKEWLANESL5_GlitchData : VitalGlitchDataType;
	variable  PIPERESETL5_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL60_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL61_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL62_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL63_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL64_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL65_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL66_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL67_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAKL6_GlitchData : VitalGlitchDataType;
	variable  PIPETXELECIDLEL6_GlitchData : VitalGlitchDataType;
	variable  PIPETXDETECTRXLOOPBACKL6_GlitchData : VitalGlitchDataType;
	variable  PIPETXCOMPLIANCEL6_GlitchData : VitalGlitchDataType;
	variable  PIPERXPOLARITYL6_GlitchData : VitalGlitchDataType;
	variable  PIPEPOWERDOWNL60_GlitchData : VitalGlitchDataType;
	variable  PIPEPOWERDOWNL61_GlitchData : VitalGlitchDataType;
	variable  PIPEDESKEWLANESL6_GlitchData : VitalGlitchDataType;
	variable  PIPERESETL6_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL70_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL71_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL72_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL73_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL74_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL75_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL76_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAL77_GlitchData : VitalGlitchDataType;
	variable  PIPETXDATAKL7_GlitchData : VitalGlitchDataType;
	variable  PIPETXELECIDLEL7_GlitchData : VitalGlitchDataType;
	variable  PIPETXDETECTRXLOOPBACKL7_GlitchData : VitalGlitchDataType;
	variable  PIPETXCOMPLIANCEL7_GlitchData : VitalGlitchDataType;
	variable  PIPERXPOLARITYL7_GlitchData : VitalGlitchDataType;
	variable  PIPEPOWERDOWNL70_GlitchData : VitalGlitchDataType;
	variable  PIPEPOWERDOWNL71_GlitchData : VitalGlitchDataType;
	variable  PIPEDESKEWLANESL7_GlitchData : VitalGlitchDataType;
	variable  PIPERESETL7_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA0_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA1_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA2_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA3_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA4_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA5_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA6_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA7_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA8_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA9_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA10_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA11_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA12_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA13_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA14_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA15_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA16_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA17_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA18_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA19_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA20_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA21_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA22_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA23_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA24_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA25_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA26_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA27_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA28_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA29_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA30_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA31_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA32_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA33_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA34_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA35_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA36_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA37_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA38_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA39_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA40_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA41_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA42_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA43_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA44_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA45_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA46_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA47_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA48_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA49_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA50_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA51_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA52_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA53_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA54_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA55_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA56_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA57_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA58_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA59_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA60_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA61_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA62_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWDATA63_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWADD0_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWADD1_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWADD2_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWADD3_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWADD4_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWADD5_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWADD6_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWADD7_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWADD8_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWADD9_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWADD10_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWADD11_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWADD12_GlitchData : VitalGlitchDataType;
	variable  MIMRXBRADD0_GlitchData : VitalGlitchDataType;
	variable  MIMRXBRADD1_GlitchData : VitalGlitchDataType;
	variable  MIMRXBRADD2_GlitchData : VitalGlitchDataType;
	variable  MIMRXBRADD3_GlitchData : VitalGlitchDataType;
	variable  MIMRXBRADD4_GlitchData : VitalGlitchDataType;
	variable  MIMRXBRADD5_GlitchData : VitalGlitchDataType;
	variable  MIMRXBRADD6_GlitchData : VitalGlitchDataType;
	variable  MIMRXBRADD7_GlitchData : VitalGlitchDataType;
	variable  MIMRXBRADD8_GlitchData : VitalGlitchDataType;
	variable  MIMRXBRADD9_GlitchData : VitalGlitchDataType;
	variable  MIMRXBRADD10_GlitchData : VitalGlitchDataType;
	variable  MIMRXBRADD11_GlitchData : VitalGlitchDataType;
	variable  MIMRXBRADD12_GlitchData : VitalGlitchDataType;
	variable  MIMRXBWEN_GlitchData : VitalGlitchDataType;
	variable  MIMRXBREN_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA0_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA1_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA2_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA3_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA4_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA5_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA6_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA7_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA8_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA9_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA10_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA11_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA12_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA13_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA14_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA15_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA16_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA17_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA18_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA19_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA20_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA21_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA22_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA23_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA24_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA25_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA26_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA27_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA28_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA29_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA30_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA31_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA32_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA33_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA34_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA35_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA36_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA37_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA38_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA39_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA40_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA41_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA42_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA43_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA44_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA45_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA46_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA47_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA48_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA49_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA50_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA51_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA52_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA53_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA54_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA55_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA56_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA57_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA58_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA59_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA60_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA61_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA62_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWDATA63_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWADD0_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWADD1_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWADD2_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWADD3_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWADD4_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWADD5_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWADD6_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWADD7_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWADD8_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWADD9_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWADD10_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWADD11_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWADD12_GlitchData : VitalGlitchDataType;
	variable  MIMTXBRADD0_GlitchData : VitalGlitchDataType;
	variable  MIMTXBRADD1_GlitchData : VitalGlitchDataType;
	variable  MIMTXBRADD2_GlitchData : VitalGlitchDataType;
	variable  MIMTXBRADD3_GlitchData : VitalGlitchDataType;
	variable  MIMTXBRADD4_GlitchData : VitalGlitchDataType;
	variable  MIMTXBRADD5_GlitchData : VitalGlitchDataType;
	variable  MIMTXBRADD6_GlitchData : VitalGlitchDataType;
	variable  MIMTXBRADD7_GlitchData : VitalGlitchDataType;
	variable  MIMTXBRADD8_GlitchData : VitalGlitchDataType;
	variable  MIMTXBRADD9_GlitchData : VitalGlitchDataType;
	variable  MIMTXBRADD10_GlitchData : VitalGlitchDataType;
	variable  MIMTXBRADD11_GlitchData : VitalGlitchDataType;
	variable  MIMTXBRADD12_GlitchData : VitalGlitchDataType;
	variable  MIMTXBWEN_GlitchData : VitalGlitchDataType;
	variable  MIMTXBREN_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA0_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA1_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA2_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA3_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA4_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA5_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA6_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA7_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA8_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA9_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA10_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA11_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA12_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA13_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA14_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA15_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA16_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA17_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA18_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA19_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA20_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA21_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA22_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA23_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA24_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA25_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA26_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA27_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA28_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA29_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA30_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA31_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA32_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA33_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA34_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA35_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA36_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA37_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA38_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA39_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA40_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA41_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA42_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA43_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA44_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA45_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA46_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA47_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA48_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA49_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA50_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA51_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA52_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA53_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA54_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA55_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA56_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA57_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA58_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA59_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA60_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA61_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA62_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWDATA63_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWADD0_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWADD1_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWADD2_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWADD3_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWADD4_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWADD5_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWADD6_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWADD7_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWADD8_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWADD9_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWADD10_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWADD11_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBRADD0_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBRADD1_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBRADD2_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBRADD3_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBRADD4_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBRADD5_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBRADD6_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBRADD7_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBRADD8_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBRADD9_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBRADD10_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBRADD11_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBWEN_GlitchData : VitalGlitchDataType;
	variable  MIMDLLBREN_GlitchData : VitalGlitchDataType;
	variable  CRMRXHOTRESETN_GlitchData : VitalGlitchDataType;
	variable  CRMDOHOTRESETN_GlitchData : VitalGlitchDataType;
	variable  CRMPWRSOFTRESETN_GlitchData : VitalGlitchDataType;
	variable  LLKTCSTATUS0_GlitchData : VitalGlitchDataType;
	variable  LLKTCSTATUS1_GlitchData : VitalGlitchDataType;
	variable  LLKTCSTATUS2_GlitchData : VitalGlitchDataType;
	variable  LLKTCSTATUS3_GlitchData : VitalGlitchDataType;
	variable  LLKTCSTATUS4_GlitchData : VitalGlitchDataType;
	variable  LLKTCSTATUS5_GlitchData : VitalGlitchDataType;
	variable  LLKTCSTATUS6_GlitchData : VitalGlitchDataType;
	variable  LLKTCSTATUS7_GlitchData : VitalGlitchDataType;
	variable  LLKTXDSTRDYN_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHANSPACE0_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHANSPACE1_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHANSPACE2_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHANSPACE3_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHANSPACE4_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHANSPACE5_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHANSPACE6_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHANSPACE7_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHANSPACE8_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHANSPACE9_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHPOSTEDREADYN0_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHPOSTEDREADYN1_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHPOSTEDREADYN2_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHPOSTEDREADYN3_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHPOSTEDREADYN4_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHPOSTEDREADYN5_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHPOSTEDREADYN6_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHPOSTEDREADYN7_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHNONPOSTEDREADYN0_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHNONPOSTEDREADYN1_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHNONPOSTEDREADYN2_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHNONPOSTEDREADYN3_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHNONPOSTEDREADYN4_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHNONPOSTEDREADYN5_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHNONPOSTEDREADYN6_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHNONPOSTEDREADYN7_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHCOMPLETIONREADYN0_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHCOMPLETIONREADYN1_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHCOMPLETIONREADYN2_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHCOMPLETIONREADYN3_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHCOMPLETIONREADYN4_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHCOMPLETIONREADYN5_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHCOMPLETIONREADYN6_GlitchData : VitalGlitchDataType;
	variable  LLKTXCHCOMPLETIONREADYN7_GlitchData : VitalGlitchDataType;
	variable  LLKTXCONFIGREADYN_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA0_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA1_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA2_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA3_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA4_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA5_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA6_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA7_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA8_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA9_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA10_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA11_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA12_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA13_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA14_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA15_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA16_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA17_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA18_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA19_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA20_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA21_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA22_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA23_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA24_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA25_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA26_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA27_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA28_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA29_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA30_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA31_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA32_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA33_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA34_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA35_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA36_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA37_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA38_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA39_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA40_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA41_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA42_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA43_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA44_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA45_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA46_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA47_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA48_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA49_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA50_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA51_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA52_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA53_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA54_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA55_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA56_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA57_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA58_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA59_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA60_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA61_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA62_GlitchData : VitalGlitchDataType;
	variable  LLKRXDATA63_GlitchData : VitalGlitchDataType;
	variable  LLKRXSRCRDYN_GlitchData : VitalGlitchDataType;
	variable  LLKRXSRCLASTREQN_GlitchData : VitalGlitchDataType;
	variable  LLKRXSRCDSCN_GlitchData : VitalGlitchDataType;
	variable  LLKRXSOFN_GlitchData : VitalGlitchDataType;
	variable  LLKRXEOFN_GlitchData : VitalGlitchDataType;
	variable  LLKRXSOPN_GlitchData : VitalGlitchDataType;
	variable  LLKRXEOPN_GlitchData : VitalGlitchDataType;
	variable  LLKRXVALIDN0_GlitchData : VitalGlitchDataType;
	variable  LLKRXVALIDN1_GlitchData : VitalGlitchDataType;
	variable  LLKRXPREFERREDTYPE0_GlitchData : VitalGlitchDataType;
	variable  LLKRXPREFERREDTYPE1_GlitchData : VitalGlitchDataType;
	variable  LLKRXPREFERREDTYPE2_GlitchData : VitalGlitchDataType;
	variable  LLKRXPREFERREDTYPE3_GlitchData : VitalGlitchDataType;
	variable  LLKRXPREFERREDTYPE4_GlitchData : VitalGlitchDataType;
	variable  LLKRXPREFERREDTYPE5_GlitchData : VitalGlitchDataType;
	variable  LLKRXPREFERREDTYPE6_GlitchData : VitalGlitchDataType;
	variable  LLKRXPREFERREDTYPE7_GlitchData : VitalGlitchDataType;
	variable  LLKRXPREFERREDTYPE8_GlitchData : VitalGlitchDataType;
	variable  LLKRXPREFERREDTYPE9_GlitchData : VitalGlitchDataType;
	variable  LLKRXPREFERREDTYPE10_GlitchData : VitalGlitchDataType;
	variable  LLKRXPREFERREDTYPE11_GlitchData : VitalGlitchDataType;
	variable  LLKRXPREFERREDTYPE12_GlitchData : VitalGlitchDataType;
	variable  LLKRXPREFERREDTYPE13_GlitchData : VitalGlitchDataType;
	variable  LLKRXPREFERREDTYPE14_GlitchData : VitalGlitchDataType;
	variable  LLKRXPREFERREDTYPE15_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHPOSTEDAVAILABLEN0_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHPOSTEDAVAILABLEN1_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHPOSTEDAVAILABLEN2_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHPOSTEDAVAILABLEN3_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHPOSTEDAVAILABLEN4_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHPOSTEDAVAILABLEN5_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHPOSTEDAVAILABLEN6_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHPOSTEDAVAILABLEN7_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHNONPOSTEDAVAILABLEN0_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHNONPOSTEDAVAILABLEN1_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHNONPOSTEDAVAILABLEN2_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHNONPOSTEDAVAILABLEN3_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHNONPOSTEDAVAILABLEN4_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHNONPOSTEDAVAILABLEN5_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHNONPOSTEDAVAILABLEN6_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHNONPOSTEDAVAILABLEN7_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHCOMPLETIONAVAILABLEN0_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHCOMPLETIONAVAILABLEN1_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHCOMPLETIONAVAILABLEN2_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHCOMPLETIONAVAILABLEN3_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHCOMPLETIONAVAILABLEN4_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHCOMPLETIONAVAILABLEN5_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHCOMPLETIONAVAILABLEN6_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHCOMPLETIONAVAILABLEN7_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHCONFIGAVAILABLEN_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHPOSTEDPARTIALN0_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHPOSTEDPARTIALN1_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHPOSTEDPARTIALN2_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHPOSTEDPARTIALN3_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHPOSTEDPARTIALN4_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHPOSTEDPARTIALN5_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHPOSTEDPARTIALN6_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHPOSTEDPARTIALN7_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHNONPOSTEDPARTIALN0_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHNONPOSTEDPARTIALN1_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHNONPOSTEDPARTIALN2_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHNONPOSTEDPARTIALN3_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHNONPOSTEDPARTIALN4_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHNONPOSTEDPARTIALN5_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHNONPOSTEDPARTIALN6_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHNONPOSTEDPARTIALN7_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHCOMPLETIONPARTIALN0_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHCOMPLETIONPARTIALN1_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHCOMPLETIONPARTIALN2_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHCOMPLETIONPARTIALN3_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHCOMPLETIONPARTIALN4_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHCOMPLETIONPARTIALN5_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHCOMPLETIONPARTIALN6_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHCOMPLETIONPARTIALN7_GlitchData : VitalGlitchDataType;
	variable  LLKRXCHCONFIGPARTIALN_GlitchData : VitalGlitchDataType;
	variable  LLKRX4DWHEADERN_GlitchData : VitalGlitchDataType;
	variable  LLKRXECRCBADN_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA0_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA1_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA2_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA3_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA4_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA5_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA6_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA7_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA8_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA9_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA10_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA11_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA12_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA13_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA14_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA15_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA16_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA17_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA18_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA19_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA20_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA21_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA22_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA23_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA24_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA25_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA26_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA27_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA28_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA29_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA30_GlitchData : VitalGlitchDataType;
	variable  MGMTRDATA31_GlitchData : VitalGlitchDataType;
	variable  MGMTPSO0_GlitchData : VitalGlitchDataType;
	variable  MGMTPSO1_GlitchData : VitalGlitchDataType;
	variable  MGMTPSO2_GlitchData : VitalGlitchDataType;
	variable  MGMTPSO3_GlitchData : VitalGlitchDataType;
	variable  MGMTPSO4_GlitchData : VitalGlitchDataType;
	variable  MGMTPSO5_GlitchData : VitalGlitchDataType;
	variable  MGMTPSO6_GlitchData : VitalGlitchDataType;
	variable  MGMTPSO7_GlitchData : VitalGlitchDataType;
	variable  MGMTPSO8_GlitchData : VitalGlitchDataType;
	variable  MGMTPSO9_GlitchData : VitalGlitchDataType;
	variable  MGMTPSO10_GlitchData : VitalGlitchDataType;
	variable  MGMTPSO11_GlitchData : VitalGlitchDataType;
	variable  MGMTPSO12_GlitchData : VitalGlitchDataType;
	variable  MGMTPSO13_GlitchData : VitalGlitchDataType;
	variable  MGMTPSO14_GlitchData : VitalGlitchDataType;
	variable  MGMTPSO15_GlitchData : VitalGlitchDataType;
	variable  MGMTPSO16_GlitchData : VitalGlitchDataType;
	variable  MGMTSTATSCREDIT0_GlitchData : VitalGlitchDataType;
	variable  MGMTSTATSCREDIT1_GlitchData : VitalGlitchDataType;
	variable  MGMTSTATSCREDIT2_GlitchData : VitalGlitchDataType;
	variable  MGMTSTATSCREDIT3_GlitchData : VitalGlitchDataType;
	variable  MGMTSTATSCREDIT4_GlitchData : VitalGlitchDataType;
	variable  MGMTSTATSCREDIT5_GlitchData : VitalGlitchDataType;
	variable  MGMTSTATSCREDIT6_GlitchData : VitalGlitchDataType;
	variable  MGMTSTATSCREDIT7_GlitchData : VitalGlitchDataType;
	variable  MGMTSTATSCREDIT8_GlitchData : VitalGlitchDataType;
	variable  MGMTSTATSCREDIT9_GlitchData : VitalGlitchDataType;
	variable  MGMTSTATSCREDIT10_GlitchData : VitalGlitchDataType;
	variable  MGMTSTATSCREDIT11_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLTLPECRCOK_GlitchData : VitalGlitchDataType;
	variable  DLLTXPMDLLPOUTSTANDING_GlitchData : VitalGlitchDataType;
	variable  L0FIRSTCFGWRITEOCCURRED_GlitchData : VitalGlitchDataType;
	variable  L0CFGLOOPBACKACK_GlitchData : VitalGlitchDataType;
	variable  L0MACUPSTREAMDOWNSTREAM_GlitchData : VitalGlitchDataType;
	variable  L0RXMACLINKERROR0_GlitchData : VitalGlitchDataType;
	variable  L0RXMACLINKERROR1_GlitchData : VitalGlitchDataType;
	variable  L0MACLINKUP_GlitchData : VitalGlitchDataType;
	variable  L0MACNEGOTIATEDLINKWIDTH0_GlitchData : VitalGlitchDataType;
	variable  L0MACNEGOTIATEDLINKWIDTH1_GlitchData : VitalGlitchDataType;
	variable  L0MACNEGOTIATEDLINKWIDTH2_GlitchData : VitalGlitchDataType;
	variable  L0MACNEGOTIATEDLINKWIDTH3_GlitchData : VitalGlitchDataType;
	variable  L0MACLINKTRAINING_GlitchData : VitalGlitchDataType;
	variable  L0LTSSMSTATE0_GlitchData : VitalGlitchDataType;
	variable  L0LTSSMSTATE1_GlitchData : VitalGlitchDataType;
	variable  L0LTSSMSTATE2_GlitchData : VitalGlitchDataType;
	variable  L0LTSSMSTATE3_GlitchData : VitalGlitchDataType;
	variable  L0DLLVCSTATUS0_GlitchData : VitalGlitchDataType;
	variable  L0DLLVCSTATUS1_GlitchData : VitalGlitchDataType;
	variable  L0DLLVCSTATUS2_GlitchData : VitalGlitchDataType;
	variable  L0DLLVCSTATUS3_GlitchData : VitalGlitchDataType;
	variable  L0DLLVCSTATUS4_GlitchData : VitalGlitchDataType;
	variable  L0DLLVCSTATUS5_GlitchData : VitalGlitchDataType;
	variable  L0DLLVCSTATUS6_GlitchData : VitalGlitchDataType;
	variable  L0DLLVCSTATUS7_GlitchData : VitalGlitchDataType;
	variable  L0DLUPDOWN0_GlitchData : VitalGlitchDataType;
	variable  L0DLUPDOWN1_GlitchData : VitalGlitchDataType;
	variable  L0DLUPDOWN2_GlitchData : VitalGlitchDataType;
	variable  L0DLUPDOWN3_GlitchData : VitalGlitchDataType;
	variable  L0DLUPDOWN4_GlitchData : VitalGlitchDataType;
	variable  L0DLUPDOWN5_GlitchData : VitalGlitchDataType;
	variable  L0DLUPDOWN6_GlitchData : VitalGlitchDataType;
	variable  L0DLUPDOWN7_GlitchData : VitalGlitchDataType;
	variable  L0DLLERRORVECTOR0_GlitchData : VitalGlitchDataType;
	variable  L0DLLERRORVECTOR1_GlitchData : VitalGlitchDataType;
	variable  L0DLLERRORVECTOR2_GlitchData : VitalGlitchDataType;
	variable  L0DLLERRORVECTOR3_GlitchData : VitalGlitchDataType;
	variable  L0DLLERRORVECTOR4_GlitchData : VitalGlitchDataType;
	variable  L0DLLERRORVECTOR5_GlitchData : VitalGlitchDataType;
	variable  L0DLLERRORVECTOR6_GlitchData : VitalGlitchDataType;
	variable  L0DLLASRXSTATE0_GlitchData : VitalGlitchDataType;
	variable  L0DLLASRXSTATE1_GlitchData : VitalGlitchDataType;
	variable  L0DLLASTXSTATE_GlitchData : VitalGlitchDataType;
	variable  L0ASAUTONOMOUSINITCOMPLETED_GlitchData : VitalGlitchDataType;
	variable  L0COMPLETERID0_GlitchData : VitalGlitchDataType;
	variable  L0COMPLETERID1_GlitchData : VitalGlitchDataType;
	variable  L0COMPLETERID2_GlitchData : VitalGlitchDataType;
	variable  L0COMPLETERID3_GlitchData : VitalGlitchDataType;
	variable  L0COMPLETERID4_GlitchData : VitalGlitchDataType;
	variable  L0COMPLETERID5_GlitchData : VitalGlitchDataType;
	variable  L0COMPLETERID6_GlitchData : VitalGlitchDataType;
	variable  L0COMPLETERID7_GlitchData : VitalGlitchDataType;
	variable  L0COMPLETERID8_GlitchData : VitalGlitchDataType;
	variable  L0COMPLETERID9_GlitchData : VitalGlitchDataType;
	variable  L0COMPLETERID10_GlitchData : VitalGlitchDataType;
	variable  L0COMPLETERID11_GlitchData : VitalGlitchDataType;
	variable  L0COMPLETERID12_GlitchData : VitalGlitchDataType;
	variable  L0UNLOCKRECEIVED_GlitchData : VitalGlitchDataType;
	variable  L0CORRERRMSGRCVD_GlitchData : VitalGlitchDataType;
	variable  L0FATALERRMSGRCVD_GlitchData : VitalGlitchDataType;
	variable  L0NONFATALERRMSGRCVD_GlitchData : VitalGlitchDataType;
	variable  L0ERRMSGREQID0_GlitchData : VitalGlitchDataType;
	variable  L0ERRMSGREQID1_GlitchData : VitalGlitchDataType;
	variable  L0ERRMSGREQID2_GlitchData : VitalGlitchDataType;
	variable  L0ERRMSGREQID3_GlitchData : VitalGlitchDataType;
	variable  L0ERRMSGREQID4_GlitchData : VitalGlitchDataType;
	variable  L0ERRMSGREQID5_GlitchData : VitalGlitchDataType;
	variable  L0ERRMSGREQID6_GlitchData : VitalGlitchDataType;
	variable  L0ERRMSGREQID7_GlitchData : VitalGlitchDataType;
	variable  L0ERRMSGREQID8_GlitchData : VitalGlitchDataType;
	variable  L0ERRMSGREQID9_GlitchData : VitalGlitchDataType;
	variable  L0ERRMSGREQID10_GlitchData : VitalGlitchDataType;
	variable  L0ERRMSGREQID11_GlitchData : VitalGlitchDataType;
	variable  L0ERRMSGREQID12_GlitchData : VitalGlitchDataType;
	variable  L0ERRMSGREQID13_GlitchData : VitalGlitchDataType;
	variable  L0ERRMSGREQID14_GlitchData : VitalGlitchDataType;
	variable  L0ERRMSGREQID15_GlitchData : VitalGlitchDataType;
	variable  L0FWDCORRERROUT_GlitchData : VitalGlitchDataType;
	variable  L0FWDFATALERROUT_GlitchData : VitalGlitchDataType;
	variable  L0FWDNONFATALERROUT_GlitchData : VitalGlitchDataType;
	variable  L0RECEIVEDASSERTINTALEGACYINT_GlitchData : VitalGlitchDataType;
	variable  L0RECEIVEDASSERTINTBLEGACYINT_GlitchData : VitalGlitchDataType;
	variable  L0RECEIVEDASSERTINTCLEGACYINT_GlitchData : VitalGlitchDataType;
	variable  L0RECEIVEDASSERTINTDLEGACYINT_GlitchData : VitalGlitchDataType;
	variable  L0RECEIVEDDEASSERTINTALEGACYINT_GlitchData : VitalGlitchDataType;
	variable  L0RECEIVEDDEASSERTINTBLEGACYINT_GlitchData : VitalGlitchDataType;
	variable  L0RECEIVEDDEASSERTINTCLEGACYINT_GlitchData : VitalGlitchDataType;
	variable  L0RECEIVEDDEASSERTINTDLEGACYINT_GlitchData : VitalGlitchDataType;
	variable  L0MSIENABLE0_GlitchData : VitalGlitchDataType;
	variable  L0MULTIMSGEN00_GlitchData : VitalGlitchDataType;
	variable  L0MULTIMSGEN01_GlitchData : VitalGlitchDataType;
	variable  L0MULTIMSGEN02_GlitchData : VitalGlitchDataType;
	variable  L0STATSDLLPRECEIVED_GlitchData : VitalGlitchDataType;
	variable  L0STATSDLLPTRANSMITTED_GlitchData : VitalGlitchDataType;
	variable  L0STATSOSRECEIVED_GlitchData : VitalGlitchDataType;
	variable  L0STATSOSTRANSMITTED_GlitchData : VitalGlitchDataType;
	variable  L0STATSTLPRECEIVED_GlitchData : VitalGlitchDataType;
	variable  L0STATSTLPTRANSMITTED_GlitchData : VitalGlitchDataType;
	variable  L0STATSCFGRECEIVED_GlitchData : VitalGlitchDataType;
	variable  L0STATSCFGTRANSMITTED_GlitchData : VitalGlitchDataType;
	variable  L0STATSCFGOTHERRECEIVED_GlitchData : VitalGlitchDataType;
	variable  L0STATSCFGOTHERTRANSMITTED_GlitchData : VitalGlitchDataType;
	variable  MAXPAYLOADSIZE0_GlitchData : VitalGlitchDataType;
	variable  MAXPAYLOADSIZE1_GlitchData : VitalGlitchDataType;
	variable  MAXPAYLOADSIZE2_GlitchData : VitalGlitchDataType;
	variable  MAXREADREQUESTSIZE0_GlitchData : VitalGlitchDataType;
	variable  MAXREADREQUESTSIZE1_GlitchData : VitalGlitchDataType;
	variable  MAXREADREQUESTSIZE2_GlitchData : VitalGlitchDataType;
	variable  IOSPACEENABLE_GlitchData : VitalGlitchDataType;
	variable  MEMSPACEENABLE_GlitchData : VitalGlitchDataType;
	variable  L0ATTENTIONINDICATORCONTROL0_GlitchData : VitalGlitchDataType;
	variable  L0ATTENTIONINDICATORCONTROL1_GlitchData : VitalGlitchDataType;
	variable  L0POWERINDICATORCONTROL0_GlitchData : VitalGlitchDataType;
	variable  L0POWERINDICATORCONTROL1_GlitchData : VitalGlitchDataType;
	variable  L0POWERCONTROLLERCONTROL_GlitchData : VitalGlitchDataType;
	variable  L0TOGGLEELECTROMECHANICALINTERLOCK_GlitchData : VitalGlitchDataType;
	variable  L0RXBEACON_GlitchData : VitalGlitchDataType;
	variable  L0PWRSTATE00_GlitchData : VitalGlitchDataType;
	variable  L0PWRSTATE01_GlitchData : VitalGlitchDataType;
	variable  L0PMEACK_GlitchData : VitalGlitchDataType;
	variable  L0PMEREQOUT_GlitchData : VitalGlitchDataType;
	variable  L0PMEEN_GlitchData : VitalGlitchDataType;
	variable  L0PWRINHIBITTRANSFERS_GlitchData : VitalGlitchDataType;
	variable  L0PWRL1STATE_GlitchData : VitalGlitchDataType;
	variable  L0PWRL23READYDEVICE_GlitchData : VitalGlitchDataType;
	variable  L0PWRL23READYSTATE_GlitchData : VitalGlitchDataType;
	variable  L0PWRTXL0SSTATE_GlitchData : VitalGlitchDataType;
	variable  L0PWRTURNOFFREQ_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLPM_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLPMTYPE0_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLPMTYPE1_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLPMTYPE2_GlitchData : VitalGlitchDataType;
	variable  L0TXDLLPMUPDATED_GlitchData : VitalGlitchDataType;
	variable  L0MACNEWSTATEACK_GlitchData : VitalGlitchDataType;
	variable  L0MACRXL0SSTATE_GlitchData : VitalGlitchDataType;
	variable  L0MACENTEREDL0_GlitchData : VitalGlitchDataType;
	variable  L0DLLRXACKOUTSTANDING_GlitchData : VitalGlitchDataType;
	variable  L0DLLTXOUTSTANDING_GlitchData : VitalGlitchDataType;
	variable  L0DLLTXNONFCOUTSTANDING_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLTLPEND0_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLTLPEND1_GlitchData : VitalGlitchDataType;
	variable  L0TXDLLSBFCUPDATED_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLSBFCDATA0_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLSBFCDATA1_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLSBFCDATA2_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLSBFCDATA3_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLSBFCDATA4_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLSBFCDATA5_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLSBFCDATA6_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLSBFCDATA7_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLSBFCDATA8_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLSBFCDATA9_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLSBFCDATA10_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLSBFCDATA11_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLSBFCDATA12_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLSBFCDATA13_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLSBFCDATA14_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLSBFCDATA15_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLSBFCDATA16_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLSBFCDATA17_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLSBFCDATA18_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLSBFCUPDATE_GlitchData : VitalGlitchDataType;
	variable  L0TXDLLFCNPOSTBYPUPDATED0_GlitchData : VitalGlitchDataType;
	variable  L0TXDLLFCNPOSTBYPUPDATED1_GlitchData : VitalGlitchDataType;
	variable  L0TXDLLFCNPOSTBYPUPDATED2_GlitchData : VitalGlitchDataType;
	variable  L0TXDLLFCNPOSTBYPUPDATED3_GlitchData : VitalGlitchDataType;
	variable  L0TXDLLFCNPOSTBYPUPDATED4_GlitchData : VitalGlitchDataType;
	variable  L0TXDLLFCNPOSTBYPUPDATED5_GlitchData : VitalGlitchDataType;
	variable  L0TXDLLFCNPOSTBYPUPDATED6_GlitchData : VitalGlitchDataType;
	variable  L0TXDLLFCNPOSTBYPUPDATED7_GlitchData : VitalGlitchDataType;
	variable  L0TXDLLFCPOSTORDUPDATED0_GlitchData : VitalGlitchDataType;
	variable  L0TXDLLFCPOSTORDUPDATED1_GlitchData : VitalGlitchDataType;
	variable  L0TXDLLFCPOSTORDUPDATED2_GlitchData : VitalGlitchDataType;
	variable  L0TXDLLFCPOSTORDUPDATED3_GlitchData : VitalGlitchDataType;
	variable  L0TXDLLFCPOSTORDUPDATED4_GlitchData : VitalGlitchDataType;
	variable  L0TXDLLFCPOSTORDUPDATED5_GlitchData : VitalGlitchDataType;
	variable  L0TXDLLFCPOSTORDUPDATED6_GlitchData : VitalGlitchDataType;
	variable  L0TXDLLFCPOSTORDUPDATED7_GlitchData : VitalGlitchDataType;
	variable  L0TXDLLFCCMPLMCUPDATED0_GlitchData : VitalGlitchDataType;
	variable  L0TXDLLFCCMPLMCUPDATED1_GlitchData : VitalGlitchDataType;
	variable  L0TXDLLFCCMPLMCUPDATED2_GlitchData : VitalGlitchDataType;
	variable  L0TXDLLFCCMPLMCUPDATED3_GlitchData : VitalGlitchDataType;
	variable  L0TXDLLFCCMPLMCUPDATED4_GlitchData : VitalGlitchDataType;
	variable  L0TXDLLFCCMPLMCUPDATED5_GlitchData : VitalGlitchDataType;
	variable  L0TXDLLFCCMPLMCUPDATED6_GlitchData : VitalGlitchDataType;
	variable  L0TXDLLFCCMPLMCUPDATED7_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCNPOSTBYPCRED0_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCNPOSTBYPCRED1_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCNPOSTBYPCRED2_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCNPOSTBYPCRED3_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCNPOSTBYPCRED4_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCNPOSTBYPCRED5_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCNPOSTBYPCRED6_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCNPOSTBYPCRED7_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCNPOSTBYPCRED8_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCNPOSTBYPCRED9_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCNPOSTBYPCRED10_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCNPOSTBYPCRED11_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCNPOSTBYPCRED12_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCNPOSTBYPCRED13_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCNPOSTBYPCRED14_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCNPOSTBYPCRED15_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCNPOSTBYPCRED16_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCNPOSTBYPCRED17_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCNPOSTBYPCRED18_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCNPOSTBYPCRED19_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCNPOSTBYPUPDATE0_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCNPOSTBYPUPDATE1_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCNPOSTBYPUPDATE2_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCNPOSTBYPUPDATE3_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCNPOSTBYPUPDATE4_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCNPOSTBYPUPDATE5_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCNPOSTBYPUPDATE6_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCNPOSTBYPUPDATE7_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDCRED0_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDCRED1_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDCRED2_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDCRED3_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDCRED4_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDCRED5_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDCRED6_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDCRED7_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDCRED8_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDCRED9_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDCRED10_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDCRED11_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDCRED12_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDCRED13_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDCRED14_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDCRED15_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDCRED16_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDCRED17_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDCRED18_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDCRED19_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDCRED20_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDCRED21_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDCRED22_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDCRED23_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDUPDATE0_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDUPDATE1_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDUPDATE2_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDUPDATE3_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDUPDATE4_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDUPDATE5_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDUPDATE6_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCPOSTORDUPDATE7_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCCRED0_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCCRED1_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCCRED2_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCCRED3_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCCRED4_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCCRED5_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCCRED6_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCCRED7_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCCRED8_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCCRED9_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCCRED10_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCCRED11_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCCRED12_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCCRED13_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCCRED14_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCCRED15_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCCRED16_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCCRED17_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCCRED18_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCCRED19_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCCRED20_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCCRED21_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCCRED22_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCCRED23_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCUPDATE0_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCUPDATE1_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCUPDATE2_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCUPDATE3_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCUPDATE4_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCUPDATE5_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCUPDATE6_GlitchData : VitalGlitchDataType;
	variable  L0RXDLLFCCMPLMCUPDATE7_GlitchData : VitalGlitchDataType;
	variable  L0UCBYPFOUND0_GlitchData : VitalGlitchDataType;
	variable  L0UCBYPFOUND1_GlitchData : VitalGlitchDataType;
	variable  L0UCBYPFOUND2_GlitchData : VitalGlitchDataType;
	variable  L0UCBYPFOUND3_GlitchData : VitalGlitchDataType;
	variable  L0UCORDFOUND0_GlitchData : VitalGlitchDataType;
	variable  L0UCORDFOUND1_GlitchData : VitalGlitchDataType;
	variable  L0UCORDFOUND2_GlitchData : VitalGlitchDataType;
	variable  L0UCORDFOUND3_GlitchData : VitalGlitchDataType;
	variable  L0MCFOUND0_GlitchData : VitalGlitchDataType;
	variable  L0MCFOUND1_GlitchData : VitalGlitchDataType;
	variable  L0MCFOUND2_GlitchData : VitalGlitchDataType;
	variable  L0TRANSFORMEDVC0_GlitchData : VitalGlitchDataType;
	variable  L0TRANSFORMEDVC1_GlitchData : VitalGlitchDataType;
	variable  L0TRANSFORMEDVC2_GlitchData : VitalGlitchDataType;
	variable  BUSMASTERENABLE_GlitchData : VitalGlitchDataType;
	variable  PARITYERRORRESPONSE_GlitchData : VitalGlitchDataType;
	variable  SERRENABLE_GlitchData : VitalGlitchDataType;
	variable  INTERRUPTDISABLE_GlitchData : VitalGlitchDataType;
	variable  URREPORTINGENABLE_GlitchData : VitalGlitchDataType;
begin

     if (TimingChecksOn) then

       VitalRecoveryRemovalCheck (
              Violation            => Tviol_CRMURSTN_CRMCORECLK_posedge,
              TimingData           => Tmkr_CRMURSTN_CRMCORECLK_posedge,
              TestSignal           => CRMURSTN_dly,
              TestSignalName       => "RESET",
              TestDelay            => tisd_CRMURSTN_CRMCORECLK,
              RefSignal            => CRMCORECLK_dly,
              RefSignalName        => "HOSTCLK",
              RefDelay             => ticd_CRMCORECLK,
              Recovery             => trecovery_CRMURSTN_CRMCORECLK_negedge_posedge,
              Removal              => tremoval_CRMURSTN_CRMCORECLK_negedge_posedge,
              ActiveLow            => false,
              CheckEnabled         => TRUE,
              RefTransition        => 'R',
              HeaderMsg            => InstancePath & "/X_PCIE_INTRNAL_1_1",
              Xon                  => Xon,
	      MsgOn                => MsgOn,
              MsgSeverity          => WARNING
	);

       VitalRecoveryRemovalCheck (
              Violation            => Tviol_CRMURSTN_CRMCORECLK_posedge,
              TimingData           => Tmkr_CRMURSTN_CRMCORECLK_posedge,
              TestSignal           => CRMURSTN_dly,
              TestSignalName       => "RESET",
              TestDelay            => tisd_CRMURSTN_CRMCORECLK,
              RefSignal            => CRMCORECLK_dly,
              RefSignalName        => "HOSTCLK",
              RefDelay             => ticd_CRMCORECLK,
              Recovery             => trecovery_CRMURSTN_CRMCORECLK_posedge_posedge,
              Removal              => tremoval_CRMURSTN_CRMCORECLK_posedge_posedge,
              ActiveLow            => false,
              CheckEnabled         => TRUE,
              RefTransition        => 'R',
              HeaderMsg            => InstancePath & "/X_PCIE_INTRNAL_1_1",
              Xon                  => Xon,
	      MsgOn                => MsgOn,
              MsgSeverity          => WARNING
	);

         VitalRecoveryRemovalCheck (
              Violation            => Tviol_CRMNVRSTN_CRMCORECLK_posedge,
              TimingData           => Tmkr_CRMNVRSTN_CRMCORECLK_posedge,
              TestSignal           => CRMNVRSTN_dly,
              TestSignalName       => "RESET",
              TestDelay            => tisd_CRMNVRSTN_CRMCORECLK,
              RefSignal            => CRMCORECLK_dly,
              RefSignalName        => "HOSTCLK",
              RefDelay             => ticd_CRMCORECLK,
              Recovery             => trecovery_CRMNVRSTN_CRMCORECLK_negedge_posedge,
              Removal              => tremoval_CRMNVRSTN_CRMCORECLK_negedge_posedge,
              ActiveLow            => false,
              CheckEnabled         => TRUE,
              RefTransition        => 'R',
              HeaderMsg            => InstancePath & "/X_PCIE_INTRNAL_1_1",
              Xon                  => Xon,
	      MsgOn                => MsgOn,
              MsgSeverity          => WARNING
	);

       VitalRecoveryRemovalCheck (
              Violation            => Tviol_CRMNVRSTN_CRMCORECLK_posedge,
              TimingData           => Tmkr_CRMNVRSTN_CRMCORECLK_posedge,
              TestSignal           => CRMNVRSTN_dly,
              TestSignalName       => "RESET",
              TestDelay            => tisd_CRMNVRSTN_CRMCORECLK,
              RefSignal            => CRMCORECLK_dly,
              RefSignalName        => "HOSTCLK",
              RefDelay             => ticd_CRMCORECLK,
              Recovery             => trecovery_CRMNVRSTN_CRMCORECLK_posedge_posedge,
              Removal              => tremoval_CRMNVRSTN_CRMCORECLK_posedge_posedge,
              ActiveLow            => false,
              CheckEnabled         => TRUE,
              RefTransition        => 'R',
              HeaderMsg            => InstancePath & "/X_PCIE_INTRNAL_1_1",
              Xon                  => Xon,
	      MsgOn                => MsgOn,
              MsgSeverity          => WARNING
	);

     VitalRecoveryRemovalCheck (
              Violation            => Tviol_CRMMGMTRSTN_CRMCORECLK_posedge,
              TimingData           => Tmkr_CRMMGMTRSTN_CRMCORECLK_posedge,
              TestSignal           => CRMMGMTRSTN_dly,
              TestSignalName       => "RESET",
              TestDelay            => tisd_CRMMGMTRSTN_CRMCORECLK,
              RefSignal            => CRMCORECLK_dly,
              RefSignalName        => "HOSTCLK",
              RefDelay             => ticd_CRMCORECLK,
              Recovery             => trecovery_CRMMGMTRSTN_CRMCORECLK_negedge_posedge,
              Removal              => tremoval_CRMMGMTRSTN_CRMCORECLK_negedge_posedge,
              ActiveLow            => false,
              CheckEnabled         => TRUE,
              RefTransition        => 'R',
              HeaderMsg            => InstancePath & "/X_PCIE_INTRNAL_1_1",
              Xon                  => Xon,
	      MsgOn                => MsgOn,
              MsgSeverity          => WARNING
	);

       VitalRecoveryRemovalCheck (
              Violation            => Tviol_CRMMGMTRSTN_CRMCORECLK_posedge,
              TimingData           => Tmkr_CRMMGMTRSTN_CRMCORECLK_posedge,
              TestSignal           => CRMMGMTRSTN_dly,
              TestSignalName       => "RESET",
              TestDelay            => tisd_CRMMGMTRSTN_CRMCORECLK,
              RefSignal            => CRMCORECLK_dly,
              RefSignalName        => "HOSTCLK",
              RefDelay             => ticd_CRMCORECLK,
              Recovery             => trecovery_CRMMGMTRSTN_CRMCORECLK_posedge_posedge,
              Removal              => tremoval_CRMMGMTRSTN_CRMCORECLK_posedge_posedge,
              ActiveLow            => false,
              CheckEnabled         => TRUE,
              RefTransition        => 'R',
              HeaderMsg            => InstancePath & "/X_PCIE_INTRNAL_1_1",
              Xon                  => Xon,
	      MsgOn                => MsgOn,
              MsgSeverity          => WARNING
	);
       VitalRecoveryRemovalCheck (
              Violation            => Tviol_CRMUSERCFGRSTN_CRMCORECLK_posedge,
              TimingData           => Tmkr_CRMUSERCFGRSTN_CRMCORECLK_posedge,
              TestSignal           => CRMUSERCFGRSTN_dly,
              TestSignalName       => "RESET",
              TestDelay            => tisd_CRMUSERCFGRSTN_CRMCORECLK,
              RefSignal            => CRMCORECLK_dly,
              RefSignalName        => "HOSTCLK",
              RefDelay             => ticd_CRMCORECLK,
              Recovery             => trecovery_CRMUSERCFGRSTN_CRMCORECLK_negedge_posedge,
              Removal              => tremoval_CRMUSERCFGRSTN_CRMCORECLK_negedge_posedge,
              ActiveLow            => false,
              CheckEnabled         => TRUE,
              RefTransition        => 'R',
              HeaderMsg            => InstancePath & "/X_PCIE_INTRNAL_1_1",
              Xon                  => Xon,
	      MsgOn                => MsgOn,
              MsgSeverity          => WARNING
	);

       VitalRecoveryRemovalCheck (
              Violation            => Tviol_CRMUSERCFGRSTN_CRMCORECLK_posedge,
              TimingData           => Tmkr_CRMUSERCFGRSTN_CRMCORECLK_posedge,
              TestSignal           => CRMUSERCFGRSTN_dly,
              TestSignalName       => "RESET",
              TestDelay            => tisd_CRMUSERCFGRSTN_CRMCORECLK,
              RefSignal            => CRMCORECLK_dly,
              RefSignalName        => "HOSTCLK",
              RefDelay             => ticd_CRMCORECLK,
              Recovery             => trecovery_CRMUSERCFGRSTN_CRMCORECLK_posedge_posedge,
              Removal              => tremoval_CRMUSERCFGRSTN_CRMCORECLK_posedge_posedge,
              ActiveLow            => false,
              CheckEnabled         => TRUE,
              RefTransition        => 'R',
              HeaderMsg            => InstancePath & "/X_PCIE_INTRNAL_1_1",
              Xon                  => Xon,
	      MsgOn                => MsgOn,
              MsgSeverity          => WARNING
	);
       VitalRecoveryRemovalCheck (
              Violation            => Tviol_CRMMACRSTN_CRMCORECLK_posedge,
              TimingData           => Tmkr_CRMMACRSTN_CRMCORECLK_posedge,
              TestSignal           => CRMMACRSTN_dly,
              TestSignalName       => "RESET",
              TestDelay            => tisd_CRMMACRSTN_CRMCORECLK,
              RefSignal            => CRMCORECLK_dly,
              RefSignalName        => "HOSTCLK",
              RefDelay             => ticd_CRMCORECLK,
              Recovery             => trecovery_CRMMACRSTN_CRMCORECLK_negedge_posedge,
              Removal              => tremoval_CRMMACRSTN_CRMCORECLK_negedge_posedge,
              ActiveLow            => false,
              CheckEnabled         => TRUE,
              RefTransition        => 'R',
              HeaderMsg            => InstancePath & "/X_PCIE_INTRNAL_1_1",
              Xon                  => Xon,
	      MsgOn                => MsgOn,
              MsgSeverity          => WARNING
	);

       VitalRecoveryRemovalCheck (
              Violation            => Tviol_CRMMACRSTN_CRMCORECLK_posedge,
              TimingData           => Tmkr_CRMMACRSTN_CRMCORECLK_posedge,
              TestSignal           => CRMMACRSTN_dly,
              TestSignalName       => "RESET",
              TestDelay            => tisd_CRMMACRSTN_CRMCORECLK,
              RefSignal            => CRMCORECLK_dly,
              RefSignalName        => "HOSTCLK",
              RefDelay             => ticd_CRMCORECLK,
              Recovery             => trecovery_CRMMACRSTN_CRMCORECLK_posedge_posedge,
              Removal              => tremoval_CRMMACRSTN_CRMCORECLK_posedge_posedge,
              ActiveLow            => false,
              CheckEnabled         => TRUE,
              RefTransition        => 'R',
              HeaderMsg            => InstancePath & "/X_PCIE_INTRNAL_1_1",
              Xon                  => Xon,
	      MsgOn                => MsgOn,
              MsgSeverity          => WARNING
	);
        VitalRecoveryRemovalCheck (
              Violation            => Tviol_CRMLINKRSTN_CRMCORECLK_posedge,
              TimingData           => Tmkr_CRMLINKRSTN_CRMCORECLK_posedge,
              TestSignal           => CRMLINKRSTN_dly,
              TestSignalName       => "RESET",
              TestDelay            => tisd_CRMLINKRSTN_CRMCORECLK,
              RefSignal            => CRMCORECLK_dly,
              RefSignalName        => "HOSTCLK",
              RefDelay             => ticd_CRMCORECLK,
              Recovery             => trecovery_CRMLINKRSTN_CRMCORECLK_negedge_posedge,
              Removal              => tremoval_CRMLINKRSTN_CRMCORECLK_negedge_posedge,
              ActiveLow            => false,
              CheckEnabled         => TRUE,
              RefTransition        => 'R',
              HeaderMsg            => InstancePath & "/X_PCIE_INTRNAL_1_1",
              Xon                  => Xon,
	      MsgOn                => MsgOn,
              MsgSeverity          => WARNING
	);

       VitalRecoveryRemovalCheck (
              Violation            => Tviol_CRMLINKRSTN_CRMCORECLK_posedge,
              TimingData           => Tmkr_CRMLINKRSTN_CRMCORECLK_posedge,
              TestSignal           => CRMLINKRSTN_dly,
              TestSignalName       => "RESET",
              TestDelay            => tisd_CRMLINKRSTN_CRMCORECLK,
              RefSignal            => CRMCORECLK_dly,
              RefSignalName        => "HOSTCLK",
              RefDelay             => ticd_CRMCORECLK,
              Recovery             => trecovery_CRMLINKRSTN_CRMCORECLK_posedge_posedge,
              Removal              => tremoval_CRMLINKRSTN_CRMCORECLK_posedge_posedge,
              ActiveLow            => false,
              CheckEnabled         => TRUE,
              RefTransition        => 'R',
              HeaderMsg            => InstancePath & "/X_PCIE_INTRNAL_1_1",
              Xon                  => Xon,
	      MsgOn                => MsgOn,
              MsgSeverity          => WARNING
	);
       
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPERXELECIDLEL0_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPERXELECIDLEL0_CRMCORECLK_posedge,
	TestSignal     => PIPERXELECIDLEL0,
	TestSignalName => "PIPERXELECIDLEL0",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPERXELECIDLEL0_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPERXELECIDLEL0_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPERXELECIDLEL0_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPERXELECIDLEL0_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXSTATUSL00_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXSTATUSL00_CRMCORECLK_posedge,
	TestSignal => PIPERXSTATUSL0_dly(0),
	TestSignalName => "PIPERXSTATUSL0(0)",
	TestDelay => tisd_PIPERXSTATUSL0_CRMCORECLK(0),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXSTATUSL0_CRMCORECLK_posedge_posedge(0),
	SetupLow => tsetup_PIPERXSTATUSL0_CRMCORECLK_negedge_posedge(0),
	HoldLow => thold_PIPERXSTATUSL0_CRMCORECLK_posedge_posedge(0),
	HoldHigh => thold_PIPERXSTATUSL0_CRMCORECLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXSTATUSL01_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXSTATUSL01_CRMCORECLK_posedge,
	TestSignal => PIPERXSTATUSL0_dly(1),
	TestSignalName => "PIPERXSTATUSL0(1)",
	TestDelay => tisd_PIPERXSTATUSL0_CRMCORECLK(1),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXSTATUSL0_CRMCORECLK_posedge_posedge(1),
	SetupLow => tsetup_PIPERXSTATUSL0_CRMCORECLK_negedge_posedge(1),
	HoldLow => thold_PIPERXSTATUSL0_CRMCORECLK_posedge_posedge(1),
	HoldHigh => thold_PIPERXSTATUSL0_CRMCORECLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXSTATUSL02_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXSTATUSL02_CRMCORECLK_posedge,
	TestSignal => PIPERXSTATUSL0_dly(2),
	TestSignalName => "PIPERXSTATUSL0(2)",
	TestDelay => tisd_PIPERXSTATUSL0_CRMCORECLK(2),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXSTATUSL0_CRMCORECLK_posedge_posedge(2),
	SetupLow => tsetup_PIPERXSTATUSL0_CRMCORECLK_negedge_posedge(2),
	HoldLow => thold_PIPERXSTATUSL0_CRMCORECLK_posedge_posedge(2),
	HoldHigh => thold_PIPERXSTATUSL0_CRMCORECLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL00_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL00_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL0_dly(0),
	TestSignalName => "PIPERXDATAL0(0)",
	TestDelay => tisd_PIPERXDATAL0_CRMCORECLK(0),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL0_CRMCORECLK_posedge_posedge(0),
	SetupLow => tsetup_PIPERXDATAL0_CRMCORECLK_negedge_posedge(0),
	HoldLow => thold_PIPERXDATAL0_CRMCORECLK_posedge_posedge(0),
	HoldHigh => thold_PIPERXDATAL0_CRMCORECLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL01_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL01_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL0_dly(1),
	TestSignalName => "PIPERXDATAL0(1)",
	TestDelay => tisd_PIPERXDATAL0_CRMCORECLK(1),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL0_CRMCORECLK_posedge_posedge(1),
	SetupLow => tsetup_PIPERXDATAL0_CRMCORECLK_negedge_posedge(1),
	HoldLow => thold_PIPERXDATAL0_CRMCORECLK_posedge_posedge(1),
	HoldHigh => thold_PIPERXDATAL0_CRMCORECLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL02_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL02_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL0_dly(2),
	TestSignalName => "PIPERXDATAL0(2)",
	TestDelay => tisd_PIPERXDATAL0_CRMCORECLK(2),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL0_CRMCORECLK_posedge_posedge(2),
	SetupLow => tsetup_PIPERXDATAL0_CRMCORECLK_negedge_posedge(2),
	HoldLow => thold_PIPERXDATAL0_CRMCORECLK_posedge_posedge(2),
	HoldHigh => thold_PIPERXDATAL0_CRMCORECLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL03_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL03_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL0_dly(3),
	TestSignalName => "PIPERXDATAL0(3)",
	TestDelay => tisd_PIPERXDATAL0_CRMCORECLK(3),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL0_CRMCORECLK_posedge_posedge(3),
	SetupLow => tsetup_PIPERXDATAL0_CRMCORECLK_negedge_posedge(3),
	HoldLow => thold_PIPERXDATAL0_CRMCORECLK_posedge_posedge(3),
	HoldHigh => thold_PIPERXDATAL0_CRMCORECLK_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL04_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL04_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL0_dly(4),
	TestSignalName => "PIPERXDATAL0(4)",
	TestDelay => tisd_PIPERXDATAL0_CRMCORECLK(4),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL0_CRMCORECLK_posedge_posedge(4),
	SetupLow => tsetup_PIPERXDATAL0_CRMCORECLK_negedge_posedge(4),
	HoldLow => thold_PIPERXDATAL0_CRMCORECLK_posedge_posedge(4),
	HoldHigh => thold_PIPERXDATAL0_CRMCORECLK_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL05_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL05_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL0_dly(5),
	TestSignalName => "PIPERXDATAL0(5)",
	TestDelay => tisd_PIPERXDATAL0_CRMCORECLK(5),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL0_CRMCORECLK_posedge_posedge(5),
	SetupLow => tsetup_PIPERXDATAL0_CRMCORECLK_negedge_posedge(5),
	HoldLow => thold_PIPERXDATAL0_CRMCORECLK_posedge_posedge(5),
	HoldHigh => thold_PIPERXDATAL0_CRMCORECLK_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL06_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL06_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL0_dly(6),
	TestSignalName => "PIPERXDATAL0(6)",
	TestDelay => tisd_PIPERXDATAL0_CRMCORECLK(6),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL0_CRMCORECLK_posedge_posedge(6),
	SetupLow => tsetup_PIPERXDATAL0_CRMCORECLK_negedge_posedge(6),
	HoldLow => thold_PIPERXDATAL0_CRMCORECLK_posedge_posedge(6),
	HoldHigh => thold_PIPERXDATAL0_CRMCORECLK_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL07_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL07_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL0_dly(7),
	TestSignalName => "PIPERXDATAL0(7)",
	TestDelay => tisd_PIPERXDATAL0_CRMCORECLK(7),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL0_CRMCORECLK_posedge_posedge(7),
	SetupLow => tsetup_PIPERXDATAL0_CRMCORECLK_negedge_posedge(7),
	HoldLow => thold_PIPERXDATAL0_CRMCORECLK_posedge_posedge(7),
	HoldHigh => thold_PIPERXDATAL0_CRMCORECLK_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPEPHYSTATUSL0_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPEPHYSTATUSL0_CRMCORECLK_posedge,
	TestSignal     => PIPEPHYSTATUSL0,
	TestSignalName => "PIPEPHYSTATUSL0",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPEPHYSTATUSL0_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPEPHYSTATUSL0_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPEPHYSTATUSL0_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPEPHYSTATUSL0_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPERXDATAKL0_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPERXDATAKL0_CRMCORECLK_posedge,
	TestSignal     => PIPERXDATAKL0,
	TestSignalName => "PIPERXDATAKL0",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPERXDATAKL0_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPERXDATAKL0_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPERXDATAKL0_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPERXDATAKL0_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPERXVALIDL0_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPERXVALIDL0_CRMCORECLK_posedge,
	TestSignal     => PIPERXVALIDL0,
	TestSignalName => "PIPERXVALIDL0",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPERXVALIDL0_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPERXVALIDL0_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPERXVALIDL0_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPERXVALIDL0_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPERXCHANISALIGNEDL0_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPERXCHANISALIGNEDL0_CRMCORECLK_posedge,
	TestSignal     => PIPERXCHANISALIGNEDL0,
	TestSignalName => "PIPERXCHANISALIGNEDL0",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPERXCHANISALIGNEDL0_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPERXCHANISALIGNEDL0_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPERXCHANISALIGNEDL0_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPERXCHANISALIGNEDL0_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPERXELECIDLEL1_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPERXELECIDLEL1_CRMCORECLK_posedge,
	TestSignal     => PIPERXELECIDLEL1,
	TestSignalName => "PIPERXELECIDLEL1",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPERXELECIDLEL1_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPERXELECIDLEL1_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPERXELECIDLEL1_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPERXELECIDLEL1_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXSTATUSL10_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXSTATUSL10_CRMCORECLK_posedge,
	TestSignal => PIPERXSTATUSL1_dly(0),
	TestSignalName => "PIPERXSTATUSL1(0)",
	TestDelay => tisd_PIPERXSTATUSL1_CRMCORECLK(0),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXSTATUSL1_CRMCORECLK_posedge_posedge(0),
	SetupLow => tsetup_PIPERXSTATUSL1_CRMCORECLK_negedge_posedge(0),
	HoldLow => thold_PIPERXSTATUSL1_CRMCORECLK_posedge_posedge(0),
	HoldHigh => thold_PIPERXSTATUSL1_CRMCORECLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXSTATUSL11_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXSTATUSL11_CRMCORECLK_posedge,
	TestSignal => PIPERXSTATUSL1_dly(1),
	TestSignalName => "PIPERXSTATUSL1(1)",
	TestDelay => tisd_PIPERXSTATUSL1_CRMCORECLK(1),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXSTATUSL1_CRMCORECLK_posedge_posedge(1),
	SetupLow => tsetup_PIPERXSTATUSL1_CRMCORECLK_negedge_posedge(1),
	HoldLow => thold_PIPERXSTATUSL1_CRMCORECLK_posedge_posedge(1),
	HoldHigh => thold_PIPERXSTATUSL1_CRMCORECLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXSTATUSL12_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXSTATUSL12_CRMCORECLK_posedge,
	TestSignal => PIPERXSTATUSL1_dly(2),
	TestSignalName => "PIPERXSTATUSL1(2)",
	TestDelay => tisd_PIPERXSTATUSL1_CRMCORECLK(2),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXSTATUSL1_CRMCORECLK_posedge_posedge(2),
	SetupLow => tsetup_PIPERXSTATUSL1_CRMCORECLK_negedge_posedge(2),
	HoldLow => thold_PIPERXSTATUSL1_CRMCORECLK_posedge_posedge(2),
	HoldHigh => thold_PIPERXSTATUSL1_CRMCORECLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL10_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL10_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL1_dly(0),
	TestSignalName => "PIPERXDATAL1(0)",
	TestDelay => tisd_PIPERXDATAL1_CRMCORECLK(0),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL1_CRMCORECLK_posedge_posedge(0),
	SetupLow => tsetup_PIPERXDATAL1_CRMCORECLK_negedge_posedge(0),
	HoldLow => thold_PIPERXDATAL1_CRMCORECLK_posedge_posedge(0),
	HoldHigh => thold_PIPERXDATAL1_CRMCORECLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL11_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL11_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL1_dly(1),
	TestSignalName => "PIPERXDATAL1(1)",
	TestDelay => tisd_PIPERXDATAL1_CRMCORECLK(1),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL1_CRMCORECLK_posedge_posedge(1),
	SetupLow => tsetup_PIPERXDATAL1_CRMCORECLK_negedge_posedge(1),
	HoldLow => thold_PIPERXDATAL1_CRMCORECLK_posedge_posedge(1),
	HoldHigh => thold_PIPERXDATAL1_CRMCORECLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL12_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL12_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL1_dly(2),
	TestSignalName => "PIPERXDATAL1(2)",
	TestDelay => tisd_PIPERXDATAL1_CRMCORECLK(2),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL1_CRMCORECLK_posedge_posedge(2),
	SetupLow => tsetup_PIPERXDATAL1_CRMCORECLK_negedge_posedge(2),
	HoldLow => thold_PIPERXDATAL1_CRMCORECLK_posedge_posedge(2),
	HoldHigh => thold_PIPERXDATAL1_CRMCORECLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL13_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL13_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL1_dly(3),
	TestSignalName => "PIPERXDATAL1(3)",
	TestDelay => tisd_PIPERXDATAL1_CRMCORECLK(3),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL1_CRMCORECLK_posedge_posedge(3),
	SetupLow => tsetup_PIPERXDATAL1_CRMCORECLK_negedge_posedge(3),
	HoldLow => thold_PIPERXDATAL1_CRMCORECLK_posedge_posedge(3),
	HoldHigh => thold_PIPERXDATAL1_CRMCORECLK_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL14_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL14_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL1_dly(4),
	TestSignalName => "PIPERXDATAL1(4)",
	TestDelay => tisd_PIPERXDATAL1_CRMCORECLK(4),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL1_CRMCORECLK_posedge_posedge(4),
	SetupLow => tsetup_PIPERXDATAL1_CRMCORECLK_negedge_posedge(4),
	HoldLow => thold_PIPERXDATAL1_CRMCORECLK_posedge_posedge(4),
	HoldHigh => thold_PIPERXDATAL1_CRMCORECLK_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL15_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL15_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL1_dly(5),
	TestSignalName => "PIPERXDATAL1(5)",
	TestDelay => tisd_PIPERXDATAL1_CRMCORECLK(5),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL1_CRMCORECLK_posedge_posedge(5),
	SetupLow => tsetup_PIPERXDATAL1_CRMCORECLK_negedge_posedge(5),
	HoldLow => thold_PIPERXDATAL1_CRMCORECLK_posedge_posedge(5),
	HoldHigh => thold_PIPERXDATAL1_CRMCORECLK_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL16_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL16_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL1_dly(6),
	TestSignalName => "PIPERXDATAL1(6)",
	TestDelay => tisd_PIPERXDATAL1_CRMCORECLK(6),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL1_CRMCORECLK_posedge_posedge(6),
	SetupLow => tsetup_PIPERXDATAL1_CRMCORECLK_negedge_posedge(6),
	HoldLow => thold_PIPERXDATAL1_CRMCORECLK_posedge_posedge(6),
	HoldHigh => thold_PIPERXDATAL1_CRMCORECLK_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL17_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL17_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL1_dly(7),
	TestSignalName => "PIPERXDATAL1(7)",
	TestDelay => tisd_PIPERXDATAL1_CRMCORECLK(7),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL1_CRMCORECLK_posedge_posedge(7),
	SetupLow => tsetup_PIPERXDATAL1_CRMCORECLK_negedge_posedge(7),
	HoldLow => thold_PIPERXDATAL1_CRMCORECLK_posedge_posedge(7),
	HoldHigh => thold_PIPERXDATAL1_CRMCORECLK_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPEPHYSTATUSL1_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPEPHYSTATUSL1_CRMCORECLK_posedge,
	TestSignal     => PIPEPHYSTATUSL1,
	TestSignalName => "PIPEPHYSTATUSL1",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPEPHYSTATUSL1_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPEPHYSTATUSL1_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPEPHYSTATUSL1_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPEPHYSTATUSL1_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPERXDATAKL1_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPERXDATAKL1_CRMCORECLK_posedge,
	TestSignal     => PIPERXDATAKL1,
	TestSignalName => "PIPERXDATAKL1",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPERXDATAKL1_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPERXDATAKL1_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPERXDATAKL1_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPERXDATAKL1_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPERXVALIDL1_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPERXVALIDL1_CRMCORECLK_posedge,
	TestSignal     => PIPERXVALIDL1,
	TestSignalName => "PIPERXVALIDL1",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPERXVALIDL1_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPERXVALIDL1_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPERXVALIDL1_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPERXVALIDL1_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPERXCHANISALIGNEDL1_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPERXCHANISALIGNEDL1_CRMCORECLK_posedge,
	TestSignal     => PIPERXCHANISALIGNEDL1,
	TestSignalName => "PIPERXCHANISALIGNEDL1",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPERXCHANISALIGNEDL1_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPERXCHANISALIGNEDL1_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPERXCHANISALIGNEDL1_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPERXCHANISALIGNEDL1_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPERXELECIDLEL2_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPERXELECIDLEL2_CRMCORECLK_posedge,
	TestSignal     => PIPERXELECIDLEL2,
	TestSignalName => "PIPERXELECIDLEL2",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPERXELECIDLEL2_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPERXELECIDLEL2_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPERXELECIDLEL2_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPERXELECIDLEL2_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXSTATUSL20_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXSTATUSL20_CRMCORECLK_posedge,
	TestSignal => PIPERXSTATUSL2_dly(0),
	TestSignalName => "PIPERXSTATUSL2(0)",
	TestDelay => tisd_PIPERXSTATUSL2_CRMCORECLK(0),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXSTATUSL2_CRMCORECLK_posedge_posedge(0),
	SetupLow => tsetup_PIPERXSTATUSL2_CRMCORECLK_negedge_posedge(0),
	HoldLow => thold_PIPERXSTATUSL2_CRMCORECLK_posedge_posedge(0),
	HoldHigh => thold_PIPERXSTATUSL2_CRMCORECLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXSTATUSL21_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXSTATUSL21_CRMCORECLK_posedge,
	TestSignal => PIPERXSTATUSL2_dly(1),
	TestSignalName => "PIPERXSTATUSL2(1)",
	TestDelay => tisd_PIPERXSTATUSL2_CRMCORECLK(1),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXSTATUSL2_CRMCORECLK_posedge_posedge(1),
	SetupLow => tsetup_PIPERXSTATUSL2_CRMCORECLK_negedge_posedge(1),
	HoldLow => thold_PIPERXSTATUSL2_CRMCORECLK_posedge_posedge(1),
	HoldHigh => thold_PIPERXSTATUSL2_CRMCORECLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXSTATUSL22_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXSTATUSL22_CRMCORECLK_posedge,
	TestSignal => PIPERXSTATUSL2_dly(2),
	TestSignalName => "PIPERXSTATUSL2(2)",
	TestDelay => tisd_PIPERXSTATUSL2_CRMCORECLK(2),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXSTATUSL2_CRMCORECLK_posedge_posedge(2),
	SetupLow => tsetup_PIPERXSTATUSL2_CRMCORECLK_negedge_posedge(2),
	HoldLow => thold_PIPERXSTATUSL2_CRMCORECLK_posedge_posedge(2),
	HoldHigh => thold_PIPERXSTATUSL2_CRMCORECLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL20_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL20_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL2_dly(0),
	TestSignalName => "PIPERXDATAL2(0)",
	TestDelay => tisd_PIPERXDATAL2_CRMCORECLK(0),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL2_CRMCORECLK_posedge_posedge(0),
	SetupLow => tsetup_PIPERXDATAL2_CRMCORECLK_negedge_posedge(0),
	HoldLow => thold_PIPERXDATAL2_CRMCORECLK_posedge_posedge(0),
	HoldHigh => thold_PIPERXDATAL2_CRMCORECLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL21_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL21_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL2_dly(1),
	TestSignalName => "PIPERXDATAL2(1)",
	TestDelay => tisd_PIPERXDATAL2_CRMCORECLK(1),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL2_CRMCORECLK_posedge_posedge(1),
	SetupLow => tsetup_PIPERXDATAL2_CRMCORECLK_negedge_posedge(1),
	HoldLow => thold_PIPERXDATAL2_CRMCORECLK_posedge_posedge(1),
	HoldHigh => thold_PIPERXDATAL2_CRMCORECLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL22_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL22_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL2_dly(2),
	TestSignalName => "PIPERXDATAL2(2)",
	TestDelay => tisd_PIPERXDATAL2_CRMCORECLK(2),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL2_CRMCORECLK_posedge_posedge(2),
	SetupLow => tsetup_PIPERXDATAL2_CRMCORECLK_negedge_posedge(2),
	HoldLow => thold_PIPERXDATAL2_CRMCORECLK_posedge_posedge(2),
	HoldHigh => thold_PIPERXDATAL2_CRMCORECLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL23_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL23_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL2_dly(3),
	TestSignalName => "PIPERXDATAL2(3)",
	TestDelay => tisd_PIPERXDATAL2_CRMCORECLK(3),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL2_CRMCORECLK_posedge_posedge(3),
	SetupLow => tsetup_PIPERXDATAL2_CRMCORECLK_negedge_posedge(3),
	HoldLow => thold_PIPERXDATAL2_CRMCORECLK_posedge_posedge(3),
	HoldHigh => thold_PIPERXDATAL2_CRMCORECLK_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL24_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL24_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL2_dly(4),
	TestSignalName => "PIPERXDATAL2(4)",
	TestDelay => tisd_PIPERXDATAL2_CRMCORECLK(4),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL2_CRMCORECLK_posedge_posedge(4),
	SetupLow => tsetup_PIPERXDATAL2_CRMCORECLK_negedge_posedge(4),
	HoldLow => thold_PIPERXDATAL2_CRMCORECLK_posedge_posedge(4),
	HoldHigh => thold_PIPERXDATAL2_CRMCORECLK_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL25_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL25_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL2_dly(5),
	TestSignalName => "PIPERXDATAL2(5)",
	TestDelay => tisd_PIPERXDATAL2_CRMCORECLK(5),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL2_CRMCORECLK_posedge_posedge(5),
	SetupLow => tsetup_PIPERXDATAL2_CRMCORECLK_negedge_posedge(5),
	HoldLow => thold_PIPERXDATAL2_CRMCORECLK_posedge_posedge(5),
	HoldHigh => thold_PIPERXDATAL2_CRMCORECLK_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL26_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL26_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL2_dly(6),
	TestSignalName => "PIPERXDATAL2(6)",
	TestDelay => tisd_PIPERXDATAL2_CRMCORECLK(6),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL2_CRMCORECLK_posedge_posedge(6),
	SetupLow => tsetup_PIPERXDATAL2_CRMCORECLK_negedge_posedge(6),
	HoldLow => thold_PIPERXDATAL2_CRMCORECLK_posedge_posedge(6),
	HoldHigh => thold_PIPERXDATAL2_CRMCORECLK_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL27_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL27_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL2_dly(7),
	TestSignalName => "PIPERXDATAL2(7)",
	TestDelay => tisd_PIPERXDATAL2_CRMCORECLK(7),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL2_CRMCORECLK_posedge_posedge(7),
	SetupLow => tsetup_PIPERXDATAL2_CRMCORECLK_negedge_posedge(7),
	HoldLow => thold_PIPERXDATAL2_CRMCORECLK_posedge_posedge(7),
	HoldHigh => thold_PIPERXDATAL2_CRMCORECLK_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPEPHYSTATUSL2_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPEPHYSTATUSL2_CRMCORECLK_posedge,
	TestSignal     => PIPEPHYSTATUSL2,
	TestSignalName => "PIPEPHYSTATUSL2",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPEPHYSTATUSL2_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPEPHYSTATUSL2_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPEPHYSTATUSL2_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPEPHYSTATUSL2_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPERXDATAKL2_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPERXDATAKL2_CRMCORECLK_posedge,
	TestSignal     => PIPERXDATAKL2,
	TestSignalName => "PIPERXDATAKL2",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPERXDATAKL2_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPERXDATAKL2_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPERXDATAKL2_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPERXDATAKL2_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPERXVALIDL2_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPERXVALIDL2_CRMCORECLK_posedge,
	TestSignal     => PIPERXVALIDL2,
	TestSignalName => "PIPERXVALIDL2",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPERXVALIDL2_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPERXVALIDL2_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPERXVALIDL2_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPERXVALIDL2_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPERXCHANISALIGNEDL2_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPERXCHANISALIGNEDL2_CRMCORECLK_posedge,
	TestSignal     => PIPERXCHANISALIGNEDL2,
	TestSignalName => "PIPERXCHANISALIGNEDL2",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPERXCHANISALIGNEDL2_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPERXCHANISALIGNEDL2_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPERXCHANISALIGNEDL2_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPERXCHANISALIGNEDL2_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPERXELECIDLEL3_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPERXELECIDLEL3_CRMCORECLK_posedge,
	TestSignal     => PIPERXELECIDLEL3,
	TestSignalName => "PIPERXELECIDLEL3",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPERXELECIDLEL3_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPERXELECIDLEL3_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPERXELECIDLEL3_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPERXELECIDLEL3_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXSTATUSL30_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXSTATUSL30_CRMCORECLK_posedge,
	TestSignal => PIPERXSTATUSL3_dly(0),
	TestSignalName => "PIPERXSTATUSL3(0)",
	TestDelay => tisd_PIPERXSTATUSL3_CRMCORECLK(0),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXSTATUSL3_CRMCORECLK_posedge_posedge(0),
	SetupLow => tsetup_PIPERXSTATUSL3_CRMCORECLK_negedge_posedge(0),
	HoldLow => thold_PIPERXSTATUSL3_CRMCORECLK_posedge_posedge(0),
	HoldHigh => thold_PIPERXSTATUSL3_CRMCORECLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXSTATUSL31_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXSTATUSL31_CRMCORECLK_posedge,
	TestSignal => PIPERXSTATUSL3_dly(1),
	TestSignalName => "PIPERXSTATUSL3(1)",
	TestDelay => tisd_PIPERXSTATUSL3_CRMCORECLK(1),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXSTATUSL3_CRMCORECLK_posedge_posedge(1),
	SetupLow => tsetup_PIPERXSTATUSL3_CRMCORECLK_negedge_posedge(1),
	HoldLow => thold_PIPERXSTATUSL3_CRMCORECLK_posedge_posedge(1),
	HoldHigh => thold_PIPERXSTATUSL3_CRMCORECLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXSTATUSL32_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXSTATUSL32_CRMCORECLK_posedge,
	TestSignal => PIPERXSTATUSL3_dly(2),
	TestSignalName => "PIPERXSTATUSL3(2)",
	TestDelay => tisd_PIPERXSTATUSL3_CRMCORECLK(2),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXSTATUSL3_CRMCORECLK_posedge_posedge(2),
	SetupLow => tsetup_PIPERXSTATUSL3_CRMCORECLK_negedge_posedge(2),
	HoldLow => thold_PIPERXSTATUSL3_CRMCORECLK_posedge_posedge(2),
	HoldHigh => thold_PIPERXSTATUSL3_CRMCORECLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL30_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL30_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL3_dly(0),
	TestSignalName => "PIPERXDATAL3(0)",
	TestDelay => tisd_PIPERXDATAL3_CRMCORECLK(0),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL3_CRMCORECLK_posedge_posedge(0),
	SetupLow => tsetup_PIPERXDATAL3_CRMCORECLK_negedge_posedge(0),
	HoldLow => thold_PIPERXDATAL3_CRMCORECLK_posedge_posedge(0),
	HoldHigh => thold_PIPERXDATAL3_CRMCORECLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL31_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL31_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL3_dly(1),
	TestSignalName => "PIPERXDATAL3(1)",
	TestDelay => tisd_PIPERXDATAL3_CRMCORECLK(1),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL3_CRMCORECLK_posedge_posedge(1),
	SetupLow => tsetup_PIPERXDATAL3_CRMCORECLK_negedge_posedge(1),
	HoldLow => thold_PIPERXDATAL3_CRMCORECLK_posedge_posedge(1),
	HoldHigh => thold_PIPERXDATAL3_CRMCORECLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL32_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL32_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL3_dly(2),
	TestSignalName => "PIPERXDATAL3(2)",
	TestDelay => tisd_PIPERXDATAL3_CRMCORECLK(2),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL3_CRMCORECLK_posedge_posedge(2),
	SetupLow => tsetup_PIPERXDATAL3_CRMCORECLK_negedge_posedge(2),
	HoldLow => thold_PIPERXDATAL3_CRMCORECLK_posedge_posedge(2),
	HoldHigh => thold_PIPERXDATAL3_CRMCORECLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL33_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL33_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL3_dly(3),
	TestSignalName => "PIPERXDATAL3(3)",
	TestDelay => tisd_PIPERXDATAL3_CRMCORECLK(3),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL3_CRMCORECLK_posedge_posedge(3),
	SetupLow => tsetup_PIPERXDATAL3_CRMCORECLK_negedge_posedge(3),
	HoldLow => thold_PIPERXDATAL3_CRMCORECLK_posedge_posedge(3),
	HoldHigh => thold_PIPERXDATAL3_CRMCORECLK_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL34_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL34_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL3_dly(4),
	TestSignalName => "PIPERXDATAL3(4)",
	TestDelay => tisd_PIPERXDATAL3_CRMCORECLK(4),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL3_CRMCORECLK_posedge_posedge(4),
	SetupLow => tsetup_PIPERXDATAL3_CRMCORECLK_negedge_posedge(4),
	HoldLow => thold_PIPERXDATAL3_CRMCORECLK_posedge_posedge(4),
	HoldHigh => thold_PIPERXDATAL3_CRMCORECLK_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL35_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL35_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL3_dly(5),
	TestSignalName => "PIPERXDATAL3(5)",
	TestDelay => tisd_PIPERXDATAL3_CRMCORECLK(5),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL3_CRMCORECLK_posedge_posedge(5),
	SetupLow => tsetup_PIPERXDATAL3_CRMCORECLK_negedge_posedge(5),
	HoldLow => thold_PIPERXDATAL3_CRMCORECLK_posedge_posedge(5),
	HoldHigh => thold_PIPERXDATAL3_CRMCORECLK_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL36_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL36_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL3_dly(6),
	TestSignalName => "PIPERXDATAL3(6)",
	TestDelay => tisd_PIPERXDATAL3_CRMCORECLK(6),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL3_CRMCORECLK_posedge_posedge(6),
	SetupLow => tsetup_PIPERXDATAL3_CRMCORECLK_negedge_posedge(6),
	HoldLow => thold_PIPERXDATAL3_CRMCORECLK_posedge_posedge(6),
	HoldHigh => thold_PIPERXDATAL3_CRMCORECLK_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL37_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL37_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL3_dly(7),
	TestSignalName => "PIPERXDATAL3(7)",
	TestDelay => tisd_PIPERXDATAL3_CRMCORECLK(7),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL3_CRMCORECLK_posedge_posedge(7),
	SetupLow => tsetup_PIPERXDATAL3_CRMCORECLK_negedge_posedge(7),
	HoldLow => thold_PIPERXDATAL3_CRMCORECLK_posedge_posedge(7),
	HoldHigh => thold_PIPERXDATAL3_CRMCORECLK_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPEPHYSTATUSL3_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPEPHYSTATUSL3_CRMCORECLK_posedge,
	TestSignal     => PIPEPHYSTATUSL3,
	TestSignalName => "PIPEPHYSTATUSL3",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPEPHYSTATUSL3_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPEPHYSTATUSL3_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPEPHYSTATUSL3_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPEPHYSTATUSL3_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPERXDATAKL3_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPERXDATAKL3_CRMCORECLK_posedge,
	TestSignal     => PIPERXDATAKL3,
	TestSignalName => "PIPERXDATAKL3",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPERXDATAKL3_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPERXDATAKL3_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPERXDATAKL3_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPERXDATAKL3_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPERXVALIDL3_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPERXVALIDL3_CRMCORECLK_posedge,
	TestSignal     => PIPERXVALIDL3,
	TestSignalName => "PIPERXVALIDL3",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPERXVALIDL3_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPERXVALIDL3_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPERXVALIDL3_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPERXVALIDL3_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPERXCHANISALIGNEDL3_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPERXCHANISALIGNEDL3_CRMCORECLK_posedge,
	TestSignal     => PIPERXCHANISALIGNEDL3,
	TestSignalName => "PIPERXCHANISALIGNEDL3",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPERXCHANISALIGNEDL3_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPERXCHANISALIGNEDL3_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPERXCHANISALIGNEDL3_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPERXCHANISALIGNEDL3_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPERXELECIDLEL4_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPERXELECIDLEL4_CRMCORECLK_posedge,
	TestSignal     => PIPERXELECIDLEL4,
	TestSignalName => "PIPERXELECIDLEL4",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPERXELECIDLEL4_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPERXELECIDLEL4_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPERXELECIDLEL4_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPERXELECIDLEL4_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXSTATUSL40_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXSTATUSL40_CRMCORECLK_posedge,
	TestSignal => PIPERXSTATUSL4_dly(0),
	TestSignalName => "PIPERXSTATUSL4(0)",
	TestDelay => tisd_PIPERXSTATUSL4_CRMCORECLK(0),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXSTATUSL4_CRMCORECLK_posedge_posedge(0),
	SetupLow => tsetup_PIPERXSTATUSL4_CRMCORECLK_negedge_posedge(0),
	HoldLow => thold_PIPERXSTATUSL4_CRMCORECLK_posedge_posedge(0),
	HoldHigh => thold_PIPERXSTATUSL4_CRMCORECLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXSTATUSL41_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXSTATUSL41_CRMCORECLK_posedge,
	TestSignal => PIPERXSTATUSL4_dly(1),
	TestSignalName => "PIPERXSTATUSL4(1)",
	TestDelay => tisd_PIPERXSTATUSL4_CRMCORECLK(1),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXSTATUSL4_CRMCORECLK_posedge_posedge(1),
	SetupLow => tsetup_PIPERXSTATUSL4_CRMCORECLK_negedge_posedge(1),
	HoldLow => thold_PIPERXSTATUSL4_CRMCORECLK_posedge_posedge(1),
	HoldHigh => thold_PIPERXSTATUSL4_CRMCORECLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXSTATUSL42_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXSTATUSL42_CRMCORECLK_posedge,
	TestSignal => PIPERXSTATUSL4_dly(2),
	TestSignalName => "PIPERXSTATUSL4(2)",
	TestDelay => tisd_PIPERXSTATUSL4_CRMCORECLK(2),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXSTATUSL4_CRMCORECLK_posedge_posedge(2),
	SetupLow => tsetup_PIPERXSTATUSL4_CRMCORECLK_negedge_posedge(2),
	HoldLow => thold_PIPERXSTATUSL4_CRMCORECLK_posedge_posedge(2),
	HoldHigh => thold_PIPERXSTATUSL4_CRMCORECLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL40_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL40_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL4_dly(0),
	TestSignalName => "PIPERXDATAL4(0)",
	TestDelay => tisd_PIPERXDATAL4_CRMCORECLK(0),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL4_CRMCORECLK_posedge_posedge(0),
	SetupLow => tsetup_PIPERXDATAL4_CRMCORECLK_negedge_posedge(0),
	HoldLow => thold_PIPERXDATAL4_CRMCORECLK_posedge_posedge(0),
	HoldHigh => thold_PIPERXDATAL4_CRMCORECLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL41_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL41_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL4_dly(1),
	TestSignalName => "PIPERXDATAL4(1)",
	TestDelay => tisd_PIPERXDATAL4_CRMCORECLK(1),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL4_CRMCORECLK_posedge_posedge(1),
	SetupLow => tsetup_PIPERXDATAL4_CRMCORECLK_negedge_posedge(1),
	HoldLow => thold_PIPERXDATAL4_CRMCORECLK_posedge_posedge(1),
	HoldHigh => thold_PIPERXDATAL4_CRMCORECLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL42_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL42_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL4_dly(2),
	TestSignalName => "PIPERXDATAL4(2)",
	TestDelay => tisd_PIPERXDATAL4_CRMCORECLK(2),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL4_CRMCORECLK_posedge_posedge(2),
	SetupLow => tsetup_PIPERXDATAL4_CRMCORECLK_negedge_posedge(2),
	HoldLow => thold_PIPERXDATAL4_CRMCORECLK_posedge_posedge(2),
	HoldHigh => thold_PIPERXDATAL4_CRMCORECLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL43_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL43_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL4_dly(3),
	TestSignalName => "PIPERXDATAL4(3)",
	TestDelay => tisd_PIPERXDATAL4_CRMCORECLK(3),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL4_CRMCORECLK_posedge_posedge(3),
	SetupLow => tsetup_PIPERXDATAL4_CRMCORECLK_negedge_posedge(3),
	HoldLow => thold_PIPERXDATAL4_CRMCORECLK_posedge_posedge(3),
	HoldHigh => thold_PIPERXDATAL4_CRMCORECLK_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL44_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL44_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL4_dly(4),
	TestSignalName => "PIPERXDATAL4(4)",
	TestDelay => tisd_PIPERXDATAL4_CRMCORECLK(4),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL4_CRMCORECLK_posedge_posedge(4),
	SetupLow => tsetup_PIPERXDATAL4_CRMCORECLK_negedge_posedge(4),
	HoldLow => thold_PIPERXDATAL4_CRMCORECLK_posedge_posedge(4),
	HoldHigh => thold_PIPERXDATAL4_CRMCORECLK_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL45_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL45_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL4_dly(5),
	TestSignalName => "PIPERXDATAL4(5)",
	TestDelay => tisd_PIPERXDATAL4_CRMCORECLK(5),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL4_CRMCORECLK_posedge_posedge(5),
	SetupLow => tsetup_PIPERXDATAL4_CRMCORECLK_negedge_posedge(5),
	HoldLow => thold_PIPERXDATAL4_CRMCORECLK_posedge_posedge(5),
	HoldHigh => thold_PIPERXDATAL4_CRMCORECLK_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL46_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL46_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL4_dly(6),
	TestSignalName => "PIPERXDATAL4(6)",
	TestDelay => tisd_PIPERXDATAL4_CRMCORECLK(6),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL4_CRMCORECLK_posedge_posedge(6),
	SetupLow => tsetup_PIPERXDATAL4_CRMCORECLK_negedge_posedge(6),
	HoldLow => thold_PIPERXDATAL4_CRMCORECLK_posedge_posedge(6),
	HoldHigh => thold_PIPERXDATAL4_CRMCORECLK_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL47_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL47_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL4_dly(7),
	TestSignalName => "PIPERXDATAL4(7)",
	TestDelay => tisd_PIPERXDATAL4_CRMCORECLK(7),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL4_CRMCORECLK_posedge_posedge(7),
	SetupLow => tsetup_PIPERXDATAL4_CRMCORECLK_negedge_posedge(7),
	HoldLow => thold_PIPERXDATAL4_CRMCORECLK_posedge_posedge(7),
	HoldHigh => thold_PIPERXDATAL4_CRMCORECLK_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPEPHYSTATUSL4_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPEPHYSTATUSL4_CRMCORECLK_posedge,
	TestSignal     => PIPEPHYSTATUSL4,
	TestSignalName => "PIPEPHYSTATUSL4",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPEPHYSTATUSL4_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPEPHYSTATUSL4_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPEPHYSTATUSL4_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPEPHYSTATUSL4_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPERXDATAKL4_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPERXDATAKL4_CRMCORECLK_posedge,
	TestSignal     => PIPERXDATAKL4,
	TestSignalName => "PIPERXDATAKL4",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPERXDATAKL4_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPERXDATAKL4_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPERXDATAKL4_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPERXDATAKL4_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPERXVALIDL4_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPERXVALIDL4_CRMCORECLK_posedge,
	TestSignal     => PIPERXVALIDL4,
	TestSignalName => "PIPERXVALIDL4",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPERXVALIDL4_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPERXVALIDL4_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPERXVALIDL4_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPERXVALIDL4_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPERXCHANISALIGNEDL4_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPERXCHANISALIGNEDL4_CRMCORECLK_posedge,
	TestSignal     => PIPERXCHANISALIGNEDL4,
	TestSignalName => "PIPERXCHANISALIGNEDL4",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPERXCHANISALIGNEDL4_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPERXCHANISALIGNEDL4_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPERXCHANISALIGNEDL4_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPERXCHANISALIGNEDL4_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPERXELECIDLEL5_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPERXELECIDLEL5_CRMCORECLK_posedge,
	TestSignal     => PIPERXELECIDLEL5,
	TestSignalName => "PIPERXELECIDLEL5",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPERXELECIDLEL5_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPERXELECIDLEL5_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPERXELECIDLEL5_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPERXELECIDLEL5_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXSTATUSL50_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXSTATUSL50_CRMCORECLK_posedge,
	TestSignal => PIPERXSTATUSL5_dly(0),
	TestSignalName => "PIPERXSTATUSL5(0)",
	TestDelay => tisd_PIPERXSTATUSL5_CRMCORECLK(0),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXSTATUSL5_CRMCORECLK_posedge_posedge(0),
	SetupLow => tsetup_PIPERXSTATUSL5_CRMCORECLK_negedge_posedge(0),
	HoldLow => thold_PIPERXSTATUSL5_CRMCORECLK_posedge_posedge(0),
	HoldHigh => thold_PIPERXSTATUSL5_CRMCORECLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXSTATUSL51_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXSTATUSL51_CRMCORECLK_posedge,
	TestSignal => PIPERXSTATUSL5_dly(1),
	TestSignalName => "PIPERXSTATUSL5(1)",
	TestDelay => tisd_PIPERXSTATUSL5_CRMCORECLK(1),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXSTATUSL5_CRMCORECLK_posedge_posedge(1),
	SetupLow => tsetup_PIPERXSTATUSL5_CRMCORECLK_negedge_posedge(1),
	HoldLow => thold_PIPERXSTATUSL5_CRMCORECLK_posedge_posedge(1),
	HoldHigh => thold_PIPERXSTATUSL5_CRMCORECLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXSTATUSL52_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXSTATUSL52_CRMCORECLK_posedge,
	TestSignal => PIPERXSTATUSL5_dly(2),
	TestSignalName => "PIPERXSTATUSL5(2)",
	TestDelay => tisd_PIPERXSTATUSL5_CRMCORECLK(2),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXSTATUSL5_CRMCORECLK_posedge_posedge(2),
	SetupLow => tsetup_PIPERXSTATUSL5_CRMCORECLK_negedge_posedge(2),
	HoldLow => thold_PIPERXSTATUSL5_CRMCORECLK_posedge_posedge(2),
	HoldHigh => thold_PIPERXSTATUSL5_CRMCORECLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL50_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL50_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL5_dly(0),
	TestSignalName => "PIPERXDATAL5(0)",
	TestDelay => tisd_PIPERXDATAL5_CRMCORECLK(0),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL5_CRMCORECLK_posedge_posedge(0),
	SetupLow => tsetup_PIPERXDATAL5_CRMCORECLK_negedge_posedge(0),
	HoldLow => thold_PIPERXDATAL5_CRMCORECLK_posedge_posedge(0),
	HoldHigh => thold_PIPERXDATAL5_CRMCORECLK_negedge_posedge(0),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL51_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL51_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL5_dly(1),
	TestSignalName => "PIPERXDATAL5(1)",
	TestDelay => tisd_PIPERXDATAL5_CRMCORECLK(1),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL5_CRMCORECLK_posedge_posedge(1),
	SetupLow => tsetup_PIPERXDATAL5_CRMCORECLK_negedge_posedge(1),
	HoldLow => thold_PIPERXDATAL5_CRMCORECLK_posedge_posedge(1),
	HoldHigh => thold_PIPERXDATAL5_CRMCORECLK_negedge_posedge(1),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL52_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL52_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL5_dly(2),
	TestSignalName => "PIPERXDATAL5(2)",
	TestDelay => tisd_PIPERXDATAL5_CRMCORECLK(2),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL5_CRMCORECLK_posedge_posedge(2),
	SetupLow => tsetup_PIPERXDATAL5_CRMCORECLK_negedge_posedge(2),
	HoldLow => thold_PIPERXDATAL5_CRMCORECLK_posedge_posedge(2),
	HoldHigh => thold_PIPERXDATAL5_CRMCORECLK_negedge_posedge(2),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL53_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL53_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL5_dly(3),
	TestSignalName => "PIPERXDATAL5(3)",
	TestDelay => tisd_PIPERXDATAL5_CRMCORECLK(3),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL5_CRMCORECLK_posedge_posedge(3),
	SetupLow => tsetup_PIPERXDATAL5_CRMCORECLK_negedge_posedge(3),
	HoldLow => thold_PIPERXDATAL5_CRMCORECLK_posedge_posedge(3),
	HoldHigh => thold_PIPERXDATAL5_CRMCORECLK_negedge_posedge(3),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL54_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL54_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL5_dly(4),
	TestSignalName => "PIPERXDATAL5(4)",
	TestDelay => tisd_PIPERXDATAL5_CRMCORECLK(4),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL5_CRMCORECLK_posedge_posedge(4),
	SetupLow => tsetup_PIPERXDATAL5_CRMCORECLK_negedge_posedge(4),
	HoldLow => thold_PIPERXDATAL5_CRMCORECLK_posedge_posedge(4),
	HoldHigh => thold_PIPERXDATAL5_CRMCORECLK_negedge_posedge(4),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL55_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL55_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL5_dly(5),
	TestSignalName => "PIPERXDATAL5(5)",
	TestDelay => tisd_PIPERXDATAL5_CRMCORECLK(5),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL5_CRMCORECLK_posedge_posedge(5),
	SetupLow => tsetup_PIPERXDATAL5_CRMCORECLK_negedge_posedge(5),
	HoldLow => thold_PIPERXDATAL5_CRMCORECLK_posedge_posedge(5),
	HoldHigh => thold_PIPERXDATAL5_CRMCORECLK_negedge_posedge(5),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL56_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL56_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL5_dly(6),
	TestSignalName => "PIPERXDATAL5(6)",
	TestDelay => tisd_PIPERXDATAL5_CRMCORECLK(6),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL5_CRMCORECLK_posedge_posedge(6),
	SetupLow => tsetup_PIPERXDATAL5_CRMCORECLK_negedge_posedge(6),
	HoldLow => thold_PIPERXDATAL5_CRMCORECLK_posedge_posedge(6),
	HoldHigh => thold_PIPERXDATAL5_CRMCORECLK_negedge_posedge(6),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation => Tviol_PIPERXDATAL57_CRMCORECLK_posedge,
	TimingData => Tmkr_PIPERXDATAL57_CRMCORECLK_posedge,
	TestSignal => PIPERXDATAL5_dly(7),
	TestSignalName => "PIPERXDATAL5(7)",
	TestDelay => tisd_PIPERXDATAL5_CRMCORECLK(7),
	RefSignal => CRMCORECLK_dly,
	RefSignalName => "CRMCORECLK",
	RefDelay => ticd_CRMCORECLK,
	SetupHigh => tsetup_PIPERXDATAL5_CRMCORECLK_posedge_posedge(7),
	SetupLow => tsetup_PIPERXDATAL5_CRMCORECLK_negedge_posedge(7),
	HoldLow => thold_PIPERXDATAL5_CRMCORECLK_posedge_posedge(7),
	HoldHigh => thold_PIPERXDATAL5_CRMCORECLK_negedge_posedge(7),
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPEPHYSTATUSL5_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPEPHYSTATUSL5_CRMCORECLK_posedge,
	TestSignal     => PIPEPHYSTATUSL5,
	TestSignalName => "PIPEPHYSTATUSL5",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPEPHYSTATUSL5_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPEPHYSTATUSL5_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPEPHYSTATUSL5_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPEPHYSTATUSL5_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPERXDATAKL5_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPERXDATAKL5_CRMCORECLK_posedge,
	TestSignal     => PIPERXDATAKL5,
	TestSignalName => "PIPERXDATAKL5",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPERXDATAKL5_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPERXDATAKL5_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPERXDATAKL5_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPERXDATAKL5_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPERXVALIDL5_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPERXVALIDL5_CRMCORECLK_posedge,
	TestSignal     => PIPERXVALIDL5,
	TestSignalName => "PIPERXVALIDL5",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPERXVALIDL5_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPERXVALIDL5_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPERXVALIDL5_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPERXVALIDL5_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPERXCHANISALIGNEDL5_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPERXCHANISALIGNEDL5_CRMCORECLK_posedge,
	TestSignal     => PIPERXCHANISALIGNEDL5,
	TestSignalName => "PIPERXCHANISALIGNEDL5",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPERXCHANISALIGNEDL5_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPERXCHANISALIGNEDL5_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPERXCHANISALIGNEDL5_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPERXCHANISALIGNEDL5_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    => WARNING
	);
	VitalSetupHoldCheck
	(
	Violation      => Tviol_PIPERXELECIDLEL6_CRMCORECLK_posedge,
	TimingData     => Tmkr_PIPERXELECIDLEL6_CRMCORECLK_posedge,
	TestSignal     => PIPERXELECIDLEL6,
	TestSignalName => "PIPERXELECIDLEL6",
	TestDelay      => 0 ps,
	RefSignal => CRMCORECLK_dly,
	RefSignalName  => "CRMCORECLK",
	RefDelay       => 0 ps,
	SetupHigh      => tsetup_PIPERXELECIDLEL6_CRMCORECLK_posedge_posedge,
	SetupLow       => tsetup_PIPERXELECIDLEL6_CRMCORECLK_negedge_posedge,
	HoldLow        => thold_PIPERXELECIDLEL6_CRMCORECLK_posedge_posedge,
	HoldHigh       => thold_PIPERXELECIDLEL6_CRMCORECLK_negedge_posedge,
	CheckEnabled   => TRUE,
	RefTransition  => 'R',
	HeaderMsg      => InstancePath & "/X_PCIE_INTERNAL_1_1",
	Xon            => Xon,
	MsgOn          => MsgOn,
	MsgSeverity    =